import videojs from 'video.js';
import '../../../styles/volume-slider.css';

const Component = videojs.getComponent('Component');

class VolumeSlider extends Component {
  constructor(player, options) {
    super(player, options);
  }

  createEl() {
    const el = super.createEl('div', {
      className: 'videojs-drm-volume-slider-container'
    });
    
    el.innerHTML = `
      <input 
        type="range" 
        class="videojs-drm-volume-slider" 
        min="0" 
        max="1" 
        step="0.01" 
        value="1"
        aria-label="Volume"
      />
    `;
    
    return el;
  }

  ready() {
    super.ready();
    this.setupVolumeSlider();
  }

  setupVolumeSlider() {
    const slider = this.el().querySelector('.videojs-drm-volume-slider');
    
    // Handle slider input
    slider.addEventListener('input', (e) => {
      const volume = parseFloat(e.target.value);
      this.player().volume(volume);
      this.updateSliderVisual(slider, volume);
    });

    // Listen to player volume changes
    this.player().on('volumechange', () => {
      const volume = this.player().volume();
      slider.value = volume;
      this.updateSliderVisual(slider, volume);
    });

    // Initialize visual state
    this.updateSliderVisual(slider, this.player().volume());
  }

  updateSliderVisual(slider, volume) {
    // Update slider background to show filled portion
    const percentage = volume * 100;
    slider.style.background = `linear-gradient(to right, #ff6b6b 0%, #ff6b6b ${percentage}%, #333 ${percentage}%, #333 100%)`;
  }
}

// Register the component
videojs.registerComponent('VolumeSlider', VolumeSlider);

export default VolumeSlider;



