import videojs from 'video.js';
import './PlayButton.css';

const Button = videojs.getComponent('Button');

class PlayButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Play/Pause');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-play-button vjs-control vjs-button'
    });
    
    el.innerHTML = `
      <svg class="play-icon" viewBox="0 0 24 24" fill="currentColor">
        <path d="M8 5v14l11-7z"/>
      </svg>
      <svg class="pause-icon" viewBox="0 0 24 24" fill="currentColor" style="display: none;">
        <path d="M6 19h4V5H6v14zm8-14v14h4V5h-4z"/>
      </svg>
    `;
    
    return el;
  }

  handleClick() {
    if (this.player().paused()) {
      this.player().play();
    } else {
      this.player().pause();
    }
  }

  updatePlayButton(isPlaying) {
    const playIcon = this.el().querySelector('.play-icon');
    const pauseIcon = this.el().querySelector('.pause-icon');
    
    if (isPlaying) {
      playIcon.style.display = 'none';
      pauseIcon.style.display = 'block';
    } else {
      playIcon.style.display = 'block';
      pauseIcon.style.display = 'none';
    }
  }

  ready() {
    super.ready();
    
    // Listen to player events
    this.player().on('play', () => {
      this.updatePlayButton(true);
    });

    this.player().on('pause', () => {
      this.updatePlayButton(false);
    });
  }
}

// Register the component
videojs.registerComponent('PlayButton', PlayButton);

export default PlayButton;



