import videojs from 'video.js';
import {
  replayIcon,
  pauseIcon,
  playIcon,
} from "../../../assets/icons/index.js";
import '../../../styles/play-button.css';

const Button = videojs.getComponent('Button');

class PlayButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Play/Pause');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-play-button vjs-control vjs-button'
    });
    
    el.innerHTML = playIcon;
    
    return el;
  }

  handleClick() {
    if (this.player().paused()) {
      this.player().play();
    } else {
      this.player().pause();
    }
  }

  updatePlayButton() {
    this.el().innerHTML = this.player().ended()
    ? replayIcon
    : this.player().paused()
    ? playIcon
    : pauseIcon;
  }

  ready() {
    super.ready();
    
    // Listen to player events
    this.player().on('play', () => this.updatePlayButton());

    this.player().on('pause', () => this.updatePlayButton());

    this.player().on('ended', () => this.updatePlayButton());

    this.updatePlayButton();
  }
}

// Register the component
videojs.registerComponent('PlayButton', PlayButton);

export default PlayButton;



