export const formatQualityLabel = (level) => {
  let label;

  // Create label based on height
  if (level.height >= 2160) {
    label = level.height + "p (4K)";
  } else if (level.height >= 1440) {
    label = level.height + "p (2K)";
  } else if (level.height >= 720) {
    label = level.height + "p (HD)";
  } else if (level.height) {
    label = level.height + "p";
  } else {
    return undefined;
  }

  // if (level.bandwidth) {
  //   const mbps = (level.bandwidth / 1000000).toFixed(2);
  //   label += ` (${mbps} Mbps)`;
  // }

  return label;
};

export const sortQualityTracks = (track1, track2) => {
  // Keep Auto option first
  if (track1.id === -1) return -1;
  if (track2.id === -1) return 1;

  // Sort by height (highest first)
  const height1 = track1.height || 0;
  const height2 = track2.height || 0;

  if (height1 === height2) {
    return (track2.bandwidth || 0) - (track1.bandwidth || 0);
  }

  return height2 - height1;
};
