import { Service } from '../../core/nqs/Services';
import SessionsRequest from '../SessionsRequest';
import { Method } from '../../common/Constants';
import ExpirationManager from '../../common/ExpirationManager';
export default class SessionsRequestHandler {
    private _requests;
    private _waitingForToken;
    private readyToSend;
    private servicesToWait;
    onWillSendAnalyticsRequestListeners: ((serviceName: string, params: Map<string, string>) => void)[];
    /**
     * Npaw Communication implements an abstraction layer over API requests.
     * Internally, Communication implements queues of {@link Request} objects.
     * This queue can be blocked using {@link Transform}
     *
     */
    constructor();
    destroy(): void;
    shouldSendStats(): boolean;
    /**
     * Enqueues the provided request
     *
     * @param { SessionsRequest } request Request to be enqueued
     */
    sendRequest(request: SessionsRequest, sessionActive: boolean): void;
    prepareParams(request: SessionsRequest): void;
    /**
     * Build a generic request to the given host.
     *
     * @param {string} service A string with the service to be called. ie...
     * @param {Object} [params] Object of key:value params.
     * @param {Method} method Type of request (GET, POST, ...)
     * @param {any} body body of the request
     * @param {function} [onSuccessCallback] The defined onSuccess callback to the request
     * @param {function} [onFailCallback] The defined onFail callback to the request
     * @param {ExpirationManager} [expirationManager] Expiration Manager
     */
    buildRequest(service: Service, params: any, method?: Method, body?: any, onSuccessCallback?: () => void, onFailCallback?: () => void, expirationManager?: ExpirationManager): SessionsRequest;
    /**
     * Execute pending requests in the queue. Returns rejected ones to the queue.
     */
    private _processRequests;
}
