import { Method } from '../common/Constants';
import { Service } from '../core/nqs/Services';
import ExpirationManager from '../common/ExpirationManager';
export default class SessionsRequest {
    private method;
    private service;
    private params;
    private body?;
    private onSuccessCallback?;
    private onFailCallback?;
    private expirationManager?;
    /**
     * AppAnalyticsRequest class will wrap all the information relative to a request of the Video Analytics component
     *
     * @param service Name of the service. ie '/start'
     * @param params Object of key:value params.
     * @param body Body of the request if it exist
     * @param onSuccess Callback for a successful request
     * @param onFail Callback for a request that fails
     * @param expirationManager Expiration Manager
     *
     */
    constructor(service: Service, params: any, body?: any, onSuccess?: () => void, onFail?: () => void, expirationManager?: ExpirationManager);
    getService(): string;
    getMethod(): Method;
    setMethod(method: Method): void;
    getParams(): any;
    getOnSuccess(): (() => void) | undefined;
    getOnFail(): (() => void) | undefined;
    /** Returns the Expiration Manager */
    getExpirationManager(): ExpirationManager | undefined;
    /**
     * Returns the value of the given param, or undefined.
     * @param key Name of the param.
     */
    getParam(key: string): any;
    /**
     * Add or set a parameter for the request.
     * ie: if you want to add 'username=user' use setParam('username', 'user').
     * @param key Name of the param.
     * @param value Name of the param.
     * @return this
     */
    setParam(key: string, value: string): this;
    /**
     * Sets the parameters object to be used for the request
     * @param params Parameters object
     */
    setParams(params: any): void;
    getBody(): any;
    setBody(body: any): void;
    isPost(): boolean;
}
