/**
 * NpawProductAnalytics class is the base of npaw productAnalytics.
 * Every plugin will have an instance.
 */
export default class ProductAnalyticsSettings {
    autoTrackNavigation: boolean;
    autoTrackAttribution: boolean;
    highlightContentAfter: number;
    pageRules: Array<{
        rule: string;
        page: string;
    }>;
    /**
     * Constructor
     */
    constructor();
    /**
     * Build settings from generic object
     * @param settings
     * @returns
     */
    static buildFromObject(settings: any): ProductAnalyticsSettings | null;
    /**
     * Validate settings
     */
    validate(): void;
}
