import ProductAnalyticsEventType from './ProductAnalyticsEventTypes';
declare global {
    interface Window {
        npawtmConfig: any;
    }
}
/**
 * NpawProductAnalyticsConfig class handles automatical event binding
 */
export default class ProductAnalyticsConfig {
    private fireEvent;
    private config;
    /**
     * Constructor
     */
    constructor(fireEvent: (eventName: string, eventType: ProductAnalyticsEventType, dimensionsInternal: object, dimensionsUser?: object, metrics?: object) => void);
    /**
     * Identifies current page and get events to monitor when available.
     * @param {URL | null} URL to be identified
     * @returns {string} Identified page name / null
     */
    identify(url: URL | null): string | null;
    /**
     * Looks for a page matching the supplied URL (either directly or by means of a regular expression).
     * @param {URL} url URL to look for.
     * @returns {string|*} Name of the page matching the URL or null if no matches have been found.
     * @private
     */
    private getPage;
    /**
     * Gets events bound to the current page.
     * @param {string} page Page name to look for.
     * @private
     */
    private getEvents;
    /**
     * Binding of element events pointed out by npawtmConfig.
     * @param {Array} events List of events to bind
     * @private
     */
    private bindElements;
    /**
     * Tracks an event after a monitored element event has been triggered.
     * @param {Object} eventInfo
     * @param {ProductAnalyticsEventType} eventType type of the triggered event (click...).
     * @param {Object} eventData additional event data supplied by the event listener.
     * @private
     */
    private elementEvent;
}
