import CoreOptions from '../CoreOptions';
import BrowserStorage from './BrowserStorage';
export default class CoreStorage {
    private options;
    private browserStorage;
    constructor(options: CoreOptions, browserStorage: BrowserStorage);
    /**
     * Returns if storages are available or not
     *
     */
    isEnabled(): boolean;
    /**
     * Sets data in the local storage
     * @param key
     * @param value
     */
    setLocal(key: string, value: string): void;
    /**
     * Gets data from the local storage
     * @param key
     * @returns
     */
    getLocal(key: string): string | undefined;
    /**
     * Removes data from the local storage
     * @param key
     */
    removeLocal(key: string): void;
    /**
     * Returns service host
     *
     */
    getHost(): string;
    /**
     *
     * @returns {*}
     */
    getSession(): string | undefined;
    getStorageHost(): null;
    getLocalAccountCode(): string | undefined;
    getSessionAccountCode(): string | undefined;
    getAppAnalyticsRegisteredProperties(): any | undefined;
    setAppAnalyticsRegisteredProperties(registeredProperties: string): void;
    removeAppAnalyticsRegisteredProperties(): void;
    getDataTime(): string | undefined;
    setDataTime(time: string): void;
    /**
     * Get session last activity timestamp
     */
    getLastActive(): number;
    /**
     * Set session last activity timestamp
     */
    setLastActive(lastActive: string): void;
    /**
     * Remove session last activity timestamp
     */
    removeLastActive(): void;
    setSession(session: any): void;
    removeSession(): void;
    getSessionExpire(): number | undefined;
    getStoredData(): string | undefined;
    setStoredData(data: any): void;
    removeStoredData(): void;
    getStorages(key: string): Promise<string | undefined>;
}
