import { Method } from '../../common/Constants';
import { Service } from './Services';
import ExpirationManager from '../../common/ExpirationManager';
export default class NQSRequest {
    private isHttps;
    private host;
    private service;
    private method;
    private params;
    private headers;
    private body?;
    private xhr;
    private retries;
    private onSuccessCallback?;
    private onFailCallback?;
    private hadBody;
    private expirationManager?;
    constructor(isHttps: boolean, host: string, service: Service, method: Method, params: any, onSuccess?: () => void, onFail?: () => void, expirationManager?: ExpirationManager);
    performHttps(): boolean;
    getHost(): string;
    getService(): string;
    getMethod(): Method;
    getParams(): any;
    getBody(): any;
    setBody(body: any): void;
    addHeader(key: string, value: any): void;
    getExpirationManager(): any;
    getRetries(): number;
    /**
     * Performs the request to the specified host and service
     *
     * @param sendFail Callback to when the send fails
     * @param onSucess Callback to when the send succeeds (optional)
     */
    send(sendFail: () => void, onSuccess?: () => void): void;
    asyncSend(): Promise<void>;
    /**
     * Converts this object into a string to be saved on the local storage
     */
    toLocalStorageString(): string;
    private getUrl;
}
