import CoreOptions from './CoreOptions';
import BrowserStorage from './storage/BrowserStorage';
import CoreStorage from './storage/CoreStorage';
import NpawPluginOptions from './NpawPluginOptions';
export default class FastDataService {
    private options;
    private npawPluginOptions?;
    private readonly accountCode;
    private coreStorage;
    private browserStorage;
    private response;
    private _session;
    private _fastDataHost;
    private _refreshInterval?;
    private pingTime?;
    private beatTime?;
    private sessionExpire;
    private retries;
    private isUsingLegacy;
    /**
     * This class manages Fastdata service and view index.
     *
     * @constructs
     *
     * @param {CoreOptions} options Options from the Core
     * @param {CoreStorage} coreStorage Core storage object
     */
    constructor(options: CoreOptions, accountCode: string, coreStorage: CoreStorage, browserStorage: BrowserStorage, npawPluginOptions?: NpawPluginOptions);
    /**
     * Starts the 'FastData' fetching. This will send the initial request to NPAW in order to get
     * the needed info for the rest of the requests.
     *
     * This is an asynchronous process.
     *
     * When the fetch is complete, {@link #fastDataConfig} will contain the parsed info.
     * @see FastDataConfig
     */
    init(): void;
    updateOptions(options: object): void;
    getSessionExpireTime(): number;
    refreshSessionToken(): void;
    /**
     * Load configuration from backend
     */
    loadConfiguration(): void;
    /**
     * Returns the current session
     *
     * @returns Session
     */
    getSession(): string;
    /**
     * Sets the session
     *
     * @param sessionId Sets the session
     */
    setSession(session: string): void;
    /** Sets the host url
     *
     * @param host Sets the host
     */
    setHost(host: string): void;
    getPingTime(): number | undefined;
    getBeatTime(): number | undefined;
    /**
     * Uses given response to set fastdata response.
     *
     * @param {String} response Fastdata response as json string.
     */
    setData(response: string): void;
    /**
     *
     * @param response Fastdata response as json string
     */
    setConfiguration(response: string): void;
    getFastDataResponse(): any;
    getAccountCode(): string;
    getRequestNumber(): number;
    /**
     * Resets the data stored on the browser
     * @private
     */
    private reset;
    private performRequestToFastData;
    /**
     * Create Configuration Interval
     * @private
     */
    private _createConfigurationInterval;
    /**
     * Parse the response from the fastData service.
     *
     */
    private _receiveData;
    private _receiveConfiguration;
    private _failedData;
    private _failedConfiguration;
}
