import NpawPluginOptions from './NpawPluginOptions';
export default class Core {
    private static _instance;
    private options;
    private pluginOptions?;
    private readonly coreStorage;
    private readonly browserStorage;
    private readonly fastDataService;
    private nqsService;
    private sendingOffline;
    private isDestroyed;
    private usingLegacy;
    private commonVariables;
    private registeredPeriodicPushes;
    private coreEventListeners;
    static getInstance(accountCode?: string, options?: NpawPluginOptions, forceNew?: boolean): Core;
    private constructor();
    /**
     * Return the NPAW Plugin versions
     */
    static getPluginVersion(): string;
    /**
     * Stores a common value for a product that might need to be used by other products
     *
     * @param productKey Product identifier (e.g. balancer)
     * @param variableKey Variable identifier (e.g. balancer-id)
     * @param value Value to be stored
     */
    registerCommonVariable(productKey: string, variableKey: string, value: any): void;
    /**
     * Deletes a common variable for the specified product
     * @param productKey Product identifier (e.g. balancer)
     * @param variableKey Variable identifier (e.g. balancer-id)
     */
    unregisterCommonVariable(productKey: string, variableKey: string): void;
    /**
     * Fetches the value stored for a product and variable identifiers
     *
     * @param productKey Product identifier (e.g. balancer)
     * @param variableKey Variable identifier (e.g. balancer-id)
     * @returns The value of the variable associated with the product or undefined if it is not set
     */
    getCommonVariable(productKey: string, variableKey: string): any | undefined;
    /**
     *
     * @returns The FastData service session token
     */
    getFastDataSessionToken(): string;
    getFastDataSessionHost(): string;
    /**
     * Refreshes the session token
     */
    refreshSessionToken(): void;
    /**
     *
     * @returns true if the session token is expired, false otherwise
     */
    isSessionTokenExpired(): boolean;
    /**
     * Deletes a view data from local storage
     * @param viewId
     * @private
     */
    private deleteViewDataFromLocalStorage;
    private handleDataToSend;
    /**
     * Subscribes a callback to events. These events can be triggered by calling throwEvent.
     * @param listener A callback function that will receive event data.
     */
    subscribeListener(listener: (eventType: any) => void): void;
    /**
     * Triggers a event to all subscribed listeners
     * @param data The content of the event
     */
    throwEvent(eventType: any): void;
}
