export declare const Services: {
    CDN: string;
};
/**
 * Websocket events
 */
export declare const Events: {
    Get: {
        Success: string;
        Fail: string;
        Progress: string;
    };
};
/**
 * Segment object load events
 */
export declare const SegmentEvent: {
    Success: string;
    Fail: string;
    Progress: string;
};
/**
 * Loader object load events
 */
export declare const LoaderEvent: {
    Updated: string;
    Success: string;
    Fail: string;
};
/**
 * Balancer API url
 */
export declare const Balancer: {
    host: string;
    devHost: string;
    devDomains: string[];
    service: string;
    decisionCallWaitTime: number;
    decisionReloadIntervalPerManifestMilliseconds: number;
};
/**
 * File extensions we identify as video, excluding manifests, subtitles and audio
 */
export declare const VideoExtensions: string[];
/**
 * File extensions we identify as manifests, excluding video, subtitles and audio
 */
export declare const ManifestExtensions: string[];
/**
 * File extensions we identify as audio, excluding manifests, subtitles and video
 */
export declare const AudioExtensions: string[];
/**
 * File extensions we identify as subtitles, excluding video, manifests and audio
 */
export declare const SubtitleExtensions: string[];
/**
 * Peer events
 */
export declare const PeerEvent: {
    connect: string;
    close: string;
    error: string;
    data: string;
    ping: string;
    pong: string;
};
/**
 * CDN switch methods/algorithms
 */
export declare const SwitchMethod: {
    optimizedScore: string;
    optimizedFeedback: string;
    bestScore: string;
    qualityPriority: string;
    cdnPriority: string;
};
/**
 * Limit of bits for cdn priority switching method
 */
export declare const CdnPriorityLimits: {
    max: number;
    min: number;
    default: number;
};
/**
 * CDN fallback methods
 */
export declare const FallbackMethod: {
    random: string;
    default: string;
};
/**
 * Peer commands
 */
export declare const PeerCommand: {
    data: string;
    absent: string;
    map: string;
    newSegmentAvailable: string;
    request: string;
    cancel: string;
    ping: string;
    pong: string;
};
/**
 * Key names for the commands between peers
 */
export declare const PeerKey: {
    command: string;
    id: string;
    size: string;
    storageSize: string;
    map: string;
    identifier: string;
    splits: string;
    time: number;
    simpleMapKeys: string;
    simpleMapSize: string;
    dateTime: string;
    createdAt: string;
};
/**
 * Data prefixes for messages between peers
 */
export declare const Prefix: {
    bandwidth_test: number;
    message: number;
    data: number;
};
/**
 * P2P static settings
 */
export declare const P2PDefaultSettings: {
    maxMessageSize: number;
    probability: number;
    timeout: number;
    maxConcurrency: number;
    maxConnectedPeers: number;
    tracker: string;
    upload: boolean;
};
/**
 * P2P static settings
 */
export declare const P2PProtocolVersion: {
    version: number;
};
/**
 * Storage settings
 */
export declare const Storage: {
    expiration: number;
    count: number;
    safeMaxCount: number;
};
/**
 * Cdn static settings
 */
export declare const CDNDefaultSettings: {
    retries: number;
    retryDelay: number;
    defaultBwThreshold: number;
    connectTimeoutMilliseconds: number;
    readTimeoutMilliseconds: number;
    minRequestSizeForBwEstimateKB: number;
};
/**
 * Stats calculation settings
 */
export declare const StatsSettings: {
    totalDataInterval: number;
};
/**
 * Latency Probing
 */
export declare const LatencyProbing: {
    callTimeoutMilliseconds: number;
    timeBetweenCallsMilliseconds: number;
    timeBetweenBurstsMilliseconds: number;
};
/**
 * CDN Probing
 */
export declare const CDNProbing: {
    lastMeasurementWeight: number;
    maximumRelativeDeltaForTrial: number;
    minimumDurationSinceLastUsedForTrialMilliseconds: number;
    chunkExpirationProbingMs: number;
};
export declare const enum CdnRequestStatus {
    SUCESS = 0,
    FAILED_DUE_TO_ERROR = 1,
    FAILED_DUE_TO_CONNECTIVITY = 2,
    FAILED_DUE_TO_QUALITY = 3
}
