import Rendition from './Rendition';
/**
 * @class
 * @description This class stores information about the video resource.
 * @exports Resource
 */
export default class Resource {
    masterUri: string;
    private renditions;
    route: string;
    fileName: string;
    bandwidths: Array<number>;
    private pos;
    private lastCleanPos;
    private cleaning;
    clean(): void;
    addSegment(renditionKey: any, uriKey: string, uriValue: string): void;
    getSize(): number;
    private delete;
    addRendition(uri: string, rendition: Rendition): void;
    getRenditions(): Map<string, Rendition>;
    getVideoRenditions(): Map<string, Rendition>;
    getRendition(segmentUri: string): Rendition | undefined;
    private updateAvailableBandwidths;
    private getBandwidthsPos;
}
