import P2PLoader from './P2PLoader';
import CDNLoader from './CDNLoader';
import BalancerOptions from '../Utils/Options';
import SegmentStorage from '../Storage/SegmentStorage';
import { VideoSegment } from '../Storage/VideoSegment';
import CdnBalancer from '../CdnBalancer';
/**
 * @class
 * @description Request load main class, it manages and chooses between CDN and P2P requests and evaluates the requests.
 * @exports Loader
 */
export default class Loader {
    private _accountCode;
    private _resource;
    private readonly _options;
    private _balancerBusinessObject;
    private readonly statsReportBusinessObject;
    P2PLoader: P2PLoader;
    CDNLoader: CDNLoader;
    storage: SegmentStorage;
    private _segments;
    segmentsMap: Map<string, string>;
    uuid: string;
    private isEnabled;
    private apiHost;
    /**
     * Constructs loader.
     * @param {BalancerOptions} options Options object.
     */
    constructor(accountCode: string, options: BalancerOptions, apiHost: string);
    getReportInterval(): number;
    private camelToSnake;
    loadCDNBalancerData(firstRequest?: boolean): void;
    /**
     * Chooses to request to CDN or P2P and manages the response calling the callback.
     * @param {URL} url URL object for the request.
     * @param {callback} callback Callback method to call back when loaded.F
     * @param {Object} headers Optional headers of the request.
     * @param {number} retries Number of retries before giving up to load a segment if it fails, optional.
     * @param {boolean} forceArrayBuffer False by default, set as true if is expected to get the manifest response
     * in ArrayBuffer format.
     * @public
     */
    processSegment(url: URL, download: boolean, callbacks: callback[], headers: {
        [key: string]: string;
    }, retries?: number, forceArrayBuffer?: boolean, stats?: fragStats): VideoSegment;
    onProcessSegmentFail(segment: VideoSegment, retry: boolean): void;
    onProcessSegmentSuccess(segment: VideoSegment): void;
    /**
     * Returns the map of unfinished/active CDN requests.
     * @returns {Map<string,VideoSegment>} The map with the requests.
     * @public
     */
    enableCDN(name: string, enabled: boolean): boolean;
    setActive(name: string, enabled: boolean): boolean;
    setMaxBandwith(name: string, bandwidth: number): boolean;
    onAbort(xhr: XMLHttpRequest, segment: VideoSegment): void;
    loadEM(xhr: XMLHttpRequest, url: URL, e: ProgressEvent): void;
    loadStartEM(xhr: XMLHttpRequest, segment: VideoSegment, e: ProgressEvent): void;
    progressEM(xhr: XMLHttpRequest, segment: VideoSegment, e: ProgressEvent): void;
    readyStateChangeEM(xhr: XMLHttpRequest, segment: VideoSegment, cdnBalancer: CdnBalancer): boolean;
    timeout(xhr: XMLHttpRequest, segment: VideoSegment): void;
    loadEndEM(xhr: XMLHttpRequest, segment: VideoSegment, e: ProgressEvent): void;
    errorEM(xhr: XMLHttpRequest, segment: VideoSegment, e: ProgressEvent): void;
    getStats(): LoaderStats;
    enable(): void;
    disable(): void;
    getIsEnabled(): boolean;
}
