import { VideoSegment } from '../Storage/VideoSegment';
import Cdn from '../Loaders/Cdn';
import P2PLoader from '../Loaders/P2PLoader';
import BalancerOptions from '../Utils/Options';
/**
 * @class
 * @description This class is responsible for informing the CDN Balancer which CDN is more suitable to perform a request
 * @exports CDNSelectorBusinessObject
 */
export default class CDNSelectorBusinessObject {
    private _p2pLoader;
    private _cdnList;
    private _activeSwitching?;
    private _bandwidthThreshold;
    private _highetsSegmentBandwidth;
    private _options;
    constructor(cdnList: Map<string, Cdn>, bandwidthThreshold: number, highetsSegmentBandwidth: number, activeSwitching: string | undefined, loader: P2PLoader, options: BalancerOptions);
    getCDN(segment: VideoSegment, probingInfo: {
        currentCDN: string;
    }): string;
    /**
     * Starts by verifying if we need to perform a probe to any CDN on the list.
     * If there is no CDN to probe, starts to perform requests to all CDNs to assess their bandwidth. When that process is done, choses the one with the highest bandwidth
     * @returns {string} CDN name.
     * @private
     */
    private _qualityPriority;
    /**
     * Uses always the first CDN of the list until its bandwidth is lower than the defined value, then uses following one as a fallback.
     * If no CDNs are valid, chooses the one with the highest bandwidth
     * It also verifies if we need to perform a probe to a CDN.
     * @returns {string} CDN name.
     * @private
     */
    private _cdnPriority;
    /**
     * Returns always the CDN with the best score value provided by the API.
     * @returns {string} CDN name.
     * @private
     */
    private _bestScoredCdn;
    private _getNotUsedCdn;
    /**
     * Based on the RTT and estimated bandwidth filters and sorts the list of CDNs. If after filtering we don't have an empty list returns the name of the first CDN.
     * @param cdnList The list of CDNs available
     * @param asMode The active switching mode
     * @param cdnInUse The CDN currently being used
     * @returns The CDN name of the CDN to probe
     */
    private _getCdnToProbe;
}
