/**
 * @class
 * @description This class stores statistics related to a CDN
 */
export default class CDNStatsBean {
    provider: string;
    internal_provider: string;
    is_p2p: boolean;
    downloaded_bytes?: number;
    downloaded_chunks?: number;
    response_bytes?: number;
    min_response_bytes?: number;
    max_response_bytes?: number;
    response_bytes_samples?: number;
    response_time?: number;
    min_response_time?: number;
    max_response_time?: number;
    response_time_samples?: number;
    network_latency?: number;
    min_network_latency?: number;
    max_network_latency?: number;
    network_latency_samples?: number;
    throughput?: number;
    min_throughput?: number;
    max_throughput?: number;
    throughput_samples?: number;
    http_1XX?: number;
    http_2XX?: number;
    http_3XX?: number;
    http_4XX?: number;
    http_5XX?: number;
    errors?: number;
    unbanned_time?: number;
    banned_time?: number;
    uncompressed_video_bytes?: number;
    compressed_video_bytes?: number;
    switches?: number;
    switches_due_connectivity?: number;
    switches_due_errors?: number;
    switches_due_quality?: number;
    time?: number;
    max_bandwidth?: number;
    min_bandwidth?: number;
    banned?: number;
    unbanned?: number;
    avg_ping_time?: number;
    min_ping_time?: number;
    max_ping_time?: number;
    is_banned?: boolean;
    is_active: boolean;
    resource?: string;
    cache_hit_chunks?: number;
    cache_miss_chunks?: number;
    video_downloaded_bytes?: number;
    video_downloaded_chunks?: number;
    video_time?: number;
    internal_is_banned?: boolean;
    internal_banned?: number;
    internal_unbanned?: number;
    internal_switches?: number;
    internal_switches_due_quality?: number;
    internal_switches_due_connectivity?: number;
    internal_switches_due_errors?: number;
    internal_banned_time?: number;
    internal_unbanned_time?: number;
    constructor(provider: string, internal_provider: string, is_p2p: boolean, is_active: boolean, downloaded_bytes?: number, downloaded_chunks?: number, errors?: number, time?: number, max_bandwidth?: number, min_bandwidth?: number, avg_ping_time?: number, min_ping_time?: number, max_ping_time?: number, resource?: string, cache_hit_chunks?: number, cache_miss_chunks?: number, video_downloaded_bytes?: number, video_downloaded_chunks?: number, video_time?: number, response_bytes?: number, min_response_bytes?: number, max_response_bytes?: number, response_bytes_samples?: number, response_time?: number, min_response_time?: number, max_response_time?: number, response_time_samples?: number, network_latency?: number, min_network_latency?: number, max_network_latency?: number, network_latency_samples?: number, throughput?: number, min_throughput?: number, max_throughput?: number, throughput_samples?: number, http_1XX?: number, http_2XX?: number, http_3XX?: number, http_4XX?: number, http_5XX?: number, unbanned_time?: number, banned_time?: number, uncompressed_bytes?: number, compressed_bytes?: number, switches?: number, switches_due_connectivity?: number, switches_due_errors?: number, switches_due_quality?: number, is_banned?: boolean, banned?: number, unbanned?: number, internal_is_banned?: boolean, internal_banned?: number, internal_unbanned?: number, internal_switches?: number, internal_switches_due_quality?: number, internal_switches_due_connectivity?: number, internal_switches_due_errors?: number, internal_banned_time?: number, internal_unbanned_time?: number);
}
