import Core from './src/core/Core';
import BalancerOptions from './src/balancer/Utils/Options';
import DiagnosticTool from './src/diagnostic/DiagnosticTool';
import { LogLevel } from './src/common/log';
import Adapter from './src/analytics/adapter/videoAdapter';
import AdsAdapter from './src/analytics/adapter/adsAdapter';
import NpawPluginOptions from './src/core/NpawPluginOptions';
import AppAnalytics from './src/appAnalytics/AppAnalytics';
import ProductAnalytics from './src/productAnalytics/ProductAnalytics';
export { LogLevel } from './src/common/log';
export * from './src/core/NpawPluginOptions';
export default class NpawPlugin {
    core: Core;
    private cdnBalancer;
    private session;
    appAnalytics: AppAnalytics;
    productAnalytics: ProductAnalytics;
    videoAnalytics: any;
    diagnostic: DiagnosticTool;
    constructor(accountCode: string, options?: NpawPluginOptions);
    destroy(): void;
    /**
     * Changes the log level of the NPAW Plugin. See {@link LogLevel} for the different levels available
     *
     * @param logLevel Log level to be used
     */
    setLogLevel(logLevel: LogLevel): void;
    /**
     * Sets Balancer options. See {@link BalancerOptions}.
     * @param options Balancer options
     */
    setBalancerOptions(options: BalancerOptions): void;
    /**
     * Sets the manifest URL of the played content in the Balancer options object.
     * For url changes the loader is restarted.
     * @param url Manifest url of the content being played.
     * @public
     */
    setManifestResource(url: string): void;
    /**
     * Adds an interceptor to the Balancer
     * @param name Name of the interceptor
     * @param player Video player object
     */
    addInterceptor(name: string, player: any): void;
    /**
     * Returns Bitmovin configuration for request interception
     */
    getBitmovinSendHttpRequest(): (type: any, request: any) => {
        getResponse(): any;
        cancel(): void;
        setProgressListener(): void;
    } | null;
    /**
     * Returns the manifest/video URL to be used following the Selector API.
     * If an error occurs this will return undefined
     */
    getRecommendedManifest(): Promise<string>;
    /**
     * Register a video player within the Video Analytics module
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param player Video player instance
     * @param adapterUrl URL of the JSON adapter
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdapter(player: any, adapterUrl: string, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Register a video player within the Video Analytics module
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param player Video player instance
     * @param adapterClass Class of the adapter to be registered
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdapterFromClass(player: any, adapterClass: any, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Register a video player within the Video Analytics module
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param player Video player instance
     * @param adapterString JSON code with the adapter configuration
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdapterFromString(player: any, adapterString: string, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Registers a barebones player adapter without any intrinsic behavior within the Video Analytics module.
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param videoKey Custom video identifier
     * @param options Analytics options
     */
    registerDefaultAdapter(videoKey?: string, options?: any): void;
    /**
     * Removes a registered video adapter after calling a fireStop. Optionally, a video identifier can be passed.
     *
     * @param videoKey Custom video identifier
     */
    removeAdapter(videoKey?: string): void;
    /**
     * Returns the registered player adapter. Optionally, a video identifier can be passed.
     *
     * @param videoKey Custom video identifier
     */
    getAdapter(videoKey?: string): Adapter;
    /**
     * Returns the registered ads adapter. Optionally, a video identifier can be passed.
     *
     * @param videoKey Custom video identifier
     */
    getAdsAdapter(videoKey?: string): AdsAdapter | undefined;
    /**
     * Register an ads player within the Ads Analytics module.
     * If there already is a registered ads adapter, it is removed first.
     * This method is asynchronous.
     *
     * @param player Ads player/manager
     * @param adapterUrl URL of the JSON adapter
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdsAdapter(player: any, adapterUrl: string, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Register an ads player within the Ads Analytics module.
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param player Video player instance
     * @param adapterClass Class of the ads adapter to be registered
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdsAdapterFromClass(player: any, adapterClass: any, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Register an ads player within the Ads Analytics module.
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param player Ads player/manager
     * @param adapterString JSON code with the adapter configuration
     * @param options Analytics options
     * @param videoKey Custom video identifier
     * @param callback Callback to be called after the adapter is registered
     */
    registerAdsAdapterFromString(player: any, adapterString: string, options?: any, videoKey?: string, callback?: () => void): void;
    /**
     * Update the AdsAdapter by name, that is previously loaded internally with the registerAdapter method
     *
     * @param adsAdapterName
     * @param videoKey Custom video identifier
     */
    updateAdsAdapter(adsAdapterName: string, videoKey?: string): void;
    /**
     * Registers a barebones ads adapter without any intrinsic behavior within the Video Analytics module.
     * If there already is a registered ads adapter, it is removed first.
     *
     * @param videoKey Custom video identifier
     * @param options Analytics options
     */
    registerDefaultAdsAdapter(videoKey?: string, options?: any): void;
    /**
     * Removes a registered ads adapter. Optionally, a video identifier can be passed.
     *
     * @param videoKey Custom video identifier
     */
    removeAdsAdapter(videoKey?: string): void;
    /**
     * Sets Analytics options. See {@link npaw.Options.setOptions}.
     *
     * @param options Analytics options object
     */
    setAnalyticsOptions(options: any): void;
    /**
     * Sets analytics options for a specific video.
     * If no videoKey is provided, 'default' will be used
     *
     * @param options Analytics options object to set
     * @param videoKey Video Identifier
     */
    setVideoOptions(options: any, videoKey?: string): void;
    /**
     * Updates the user defined custom metrics
     *
     * @param metrics Metrics to be updated
     * @param videoKey Video Identifier
     */
    updateMetrics(metrics: any, videoKey?: string): void;
    /**
     * Sends the events that were previously stored during an offline session
     */
    fireOfflineEvents(): void;
    private registerAdapterFromClassInModule;
    private registerAdapterInModule;
    /**
     * Register adapter in Product Analytics
     * @param videoKey
     */
    private registerAdapterProductAnalytics;
}
