# NPAW Plugin
[![TypeScript](https://badges.frapsoft.com/typescript/version/typescript-next.svg?v=101)](https://github.com/ellerbrock/typescript-badges/)
[![codecov](https://codecov.io/bb/npaw/cdn-balancer-js/branch/master/graph/badge.svg?token=RNZP9IEWYO)](https://codecov.io/bb/npaw/cdn-balancer-js)
[![Package Quality](https://packagequality.com/shield/cdn-balancer-js.svg)](https://packagequality.com/#?package=cdn-balancer-js)
[![Pull requests](https://img.shields.io/bitbucket/pr/npaw/cdn-balancer-js)](https://bitbucket.org/npaw/cdn-balancer-js/pull-requests/)

NPAW Plugin is the ultimate solution to ensure you can understand, control and optimize your users' video experience, and your video delivery flow.

The integration of the NPAW Plugin into your applications will give you access, via the NPAW Suite, to the following main features:

## Analytics
- Collect metrics and metadata regarding the behaviour of any video streaming app, which can be divided into these categories:
    - Video Analytics
        - Broad analytics capabilities of the video platform’s performance and the audience’s behavior in the video playback, always in real-time
    - Ads Analytics
        - Analyze ad performance in terms of audience, business, quality, and engagement
    - App Analytics
        - Track any event in any app, enabling a comprehensive understanding of user behavior beyond video playback

## CDN Balancer
- Manage your multi-CDN endpoints automatically, to achieve your optimal tradeoff between user experience and delivery costs
    - Your application will proactively selecting the best CDN endpoint for each video segment
    - Proactive selection performed live, based on what your user is actually experiencing
    - Easily setup your business goals via NPAW Suite. This proactive selection is performed live, based on your desired business goals (defined by you via NPAW Suite), making sure you achieve your optimal tradeoff between user experience and delivery costs
    - *(Coming soon)* P2P video delivery to alleviate peak traffic and reduce your delivery costs

## Tech Stack
The NPAW Plugin is developed using TypeScript.

## Folder Structure
```
/
└── dist/     Built & Minified files ready to include and run
```

<!-- ├── spec/     Tests
├── samples/  Sample files
└── src/      Sourcecode of the project -->

## Documentation, Installation & Usage
Please refer to the [Documentation Portal](https://documentation.npaw.com/integration-docs/docs/).

## I need help!
If you find a bug, have a suggestion or need assistance send an E-mail to <support@nicepeopleatwork.com>
