const path = require("path");

/**
 * Embed LITE build (externals):
 * - JS: small wrapper bundle under embed/js/
 * - CSS: emitted as real files under embed/css/ (only THIS project’s CSS + video-js.css import if you keep it)
 *
 * IMPORTANT:
 * This build assumes the host page loads these globals BEFORE the wrapper:
 * - window.videojs           (Video.js)
 * - window.shaka             (Shaka Player)  ※ the library, not our Tech class
 * - videojs-contrib-eme      (adds player.eme())
 */
module.exports = {
  entry: "./src/index.js",
  output: {
    path: path.resolve(__dirname, "embed"),
    filename: "js/videojs-drm-player.lite.js",
    library: {
      name: "VideoJSDRMPlayer",
      type: "umd",
      export: "default",
    },
    globalObject: "this",
  },
  devtool: "source-map",
  optimization: {
    minimize: false,
  },
  externals: {
    // import videojs from "video.js";
    "video.js": "videojs",
    // import shaka from "shaka-player";
    "shaka-player": "shaka",
    // This plugin patches videojs player with .eme()
    "videojs-contrib-eme": "videojs.eme",
  },
  module: {
    rules: [
      {
        test: /\.css$/,
        type: "asset/resource",
        generator: {
          filename: "css/[name][ext]",
        },
      },
    ],
  },
  resolve: {
    extensions: [".js"],
  },
};

