const path = require("path");

/**
 * Embed DEV build:
 * - JS: readable (not minified) bundle under embed/js/
 * - CSS: emitted as real files under embed/css/
 *
 * Use this when you want to read/debug the bundled code.
 */
module.exports = {
  entry: "./src/index.js",
  output: {
    path: path.resolve(__dirname, "embed"),
    filename: "js/videojs-drm-player.js",
    library: {
      name: "VideoJSDRMPlayer",
      type: "umd",
      export: "default",
    },
    globalObject: "this",
  },
  devtool: "source-map",
  optimization: {
    minimize: false,
  },
  module: {
    rules: [
      {
        // Emit CSS files as-is. They must be linked from HTML.
        test: /\.css$/,
        type: "asset/resource",
        generator: {
          filename: "css/[name][ext]",
        },
      },
    ],
  },
  resolve: {
    extensions: [".js"],
  },
};

