const path = require("path");

/**
 * Embed build:
 * - JS: UMD bundle under embed/js/
 * - CSS: emitted as real files under embed/css/ (no runtime style injection)
 *
 * This keeps the existing dist build (style-loader) unchanged for backwards compatibility.
 */
module.exports = {
  entry: "./src/index.js",
  output: {
    path: path.resolve(__dirname, "embed"),
    filename: "js/videojs-drm-player.min.js",
    library: {
      name: "VideoJSDRMPlayer",
      type: "umd",
      export: "default",
    },
    globalObject: "this",
  },
  module: {
    rules: [
      {
        // Emit CSS files as-is. They must be linked from HTML.
        test: /\.css$/,
        type: "asset/resource",
        generator: {
          filename: "css/[name][ext]",
        },
      },
    ],
  },
  resolve: {
    extensions: [".js"],
  },
};

