const path = require('path');

module.exports = {
  entry: './src/index.js',
  output: {
    path: path.resolve(__dirname, 'dist'),
    filename: 'videojs-drm-player.min.js',
    library: {
      name: 'VideoJSDRMPlayer',
      type: 'umd',
      export: 'default'
    },
    globalObject: 'this'
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: {
          loader: 'babel-loader',
          options: {
            presets: ['@babel/preset-env']
          }
        }
      },
      {
        test: /\.css$/,
        use: ['style-loader', 'css-loader']
      },
    ]
  },
  // externals: {
  //   'video.js': 'videojs',
  //   'videojs-contrib-eme': 'videojs.eme',
  // },
  resolve: {
    extensions: ['.js']
  }
}; 