(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("videojs"), require("shaka"));
	else if(typeof define === 'function' && define.amd)
		define(["videojs", "shaka"], factory);
	else if(typeof exports === 'object')
		exports["VideoJSDRMPlayer"] = factory(require("videojs"), require("shaka"));
	else
		root["VideoJSDRMPlayer"] = factory(root["videojs"], root["shaka"]);
})(this, (__WEBPACK_EXTERNAL_MODULE_video_js__, __WEBPACK_EXTERNAL_MODULE_shaka_player__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/video.js/dist/video-js.css":
/*!*************************************************!*\
  !*** ./node_modules/video.js/dist/video-js.css ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/video-js.css";

/***/ }),

/***/ "./src/assets/icons/index.js":
/*!***********************************!*\
  !*** ./src/assets/icons/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkIcon: () => (/* binding */ checkIcon),
/* harmony export */   chevronLeftIcon: () => (/* binding */ chevronLeftIcon),
/* harmony export */   chevronRightIcon: () => (/* binding */ chevronRightIcon),
/* harmony export */   exitFullScreenIcon: () => (/* binding */ exitFullScreenIcon),
/* harmony export */   fullScreenIcon: () => (/* binding */ fullScreenIcon),
/* harmony export */   loadingIcon: () => (/* binding */ loadingIcon),
/* harmony export */   pauseIcon: () => (/* binding */ pauseIcon),
/* harmony export */   playIcon: () => (/* binding */ playIcon),
/* harmony export */   playbackSpeedIcon: () => (/* binding */ playbackSpeedIcon),
/* harmony export */   qualityIcon: () => (/* binding */ qualityIcon),
/* harmony export */   replayIcon: () => (/* binding */ replayIcon),
/* harmony export */   settingIcon: () => (/* binding */ settingIcon),
/* harmony export */   shareIcon: () => (/* binding */ shareIcon),
/* harmony export */   subtitleIcon: () => (/* binding */ subtitleIcon),
/* harmony export */   subtitleToggleIcon: () => (/* binding */ subtitleToggleIcon),
/* harmony export */   volumeHighIcon: () => (/* binding */ volumeHighIcon),
/* harmony export */   volumeLowIcon: () => (/* binding */ volumeLowIcon),
/* harmony export */   volumeMutedIcon: () => (/* binding */ volumeMutedIcon)
/* harmony export */ });
const playbackSpeedIcon = `
  <svg
    width="800px"
    height="800px"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2"
      stroke="#FFFFFF"
      stroke-width="1.5"
      stroke-linecap="round"
    />
    <path
      opacity="0.5"
      d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.97715 2 12.5 2"
      stroke="#FFFFFF"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-dasharray="4 3"
    />
    <path
      d="M15.4137 10.941C16.1954 11.4026 16.1954 12.5974 15.4137 13.059L10.6935 15.8458C9.93371 16.2944 9 15.7105 9 14.7868L9 9.21316C9 8.28947 9.93371 7.70561 10.6935 8.15419L15.4137 10.941Z"
      stroke="#FFFFFF"
      stroke-width="1.5"
    />
  </svg>
`;
const subtitleIcon = `
  <svg
    version="1.1"
    id="Layer_1"
    xmlns="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    x="0px"
    y="0px"
    viewBox="0 0 122.88 114.83"
    style="enable-background:new 0 0 122.88 114.83"
    xml:space="preserve"
    width="800px"
    height="800px"
  >
    <g>
      <path
        fill="#FFFFFF"
        d="M25.5,57.01c0-2.51,0.42-4.97,1.26-7.4c0.84-2.43,2.07-4.61,3.68-6.54
      c1.61-1.93,3.57-3.49,5.87-4.68c2.3-1.2,4.92-1.79,7.87-1.79c3.53,0,6.59,0.82,9.18,2.46c2.59,1.64,4.52,3.81,5.79,6.51l-7.67,6.13
      c-0.34-1-0.8-1.83-1.36-2.49c-0.57-0.66-1.19-1.18-1.88-1.56c-0.69-0.39-1.4-0.66-2.14-0.81c-0.74-0.15-1.45-0.23-2.14-0.23
      c-1.44,0-2.68,0.32-3.73,0.95c-1.05,0.64-1.9,1.46-2.57,2.49c-0.67,1.02-1.17,2.18-1.49,3.47c-0.33,1.29-0.49,2.57-0.49,3.85
      c0,1.43,0.19,2.8,0.57,4.11c0.38,1.31,0.93,2.47,1.65,3.47c0.72,1,1.6,1.8,2.65,2.4c1.05,0.6,2.22,0.9,3.52,0.9
      c0.69,0,1.39-0.09,2.11-0.26c0.72-0.17,1.42-0.46,2.08-0.87s1.27-0.93,1.8-1.56c0.53-0.64,0.95-1.42,1.26-2.34l8.18,5.49
      c-0.55,1.5-1.38,2.85-2.5,4.05c-1.11,1.2-2.38,2.2-3.81,3.01c-1.42,0.81-2.95,1.43-4.58,1.85c-1.63,0.42-3.22,0.64-4.76,0.64
      c-2.71,0-5.19-0.61-7.43-1.82c-2.25-1.21-4.18-2.82-5.81-4.83c-1.63-2-2.89-4.28-3.78-6.82C25.94,62.21,25.5,59.63,25.5,57.01z
      M15.77,0h91.34c4.34,0,8.28,1.77,11.14,4.63s4.63,6.8,4.63,11.14v83.29c0,4.34-1.77,8.28-4.63,11.14
      c-2.86,2.86-6.8,4.63-11.14,4.63H15.77c-4.34,0-8.28-1.77-11.14-4.63C1.77,107.34,0,103.4,0,99.06V15.77
      c0-4.34,1.77-8.29,4.63-11.14C7.48,1.77,11.43,0,15.77,0z M107.11,9.91H15.77c-1.61,0-3.07,0.66-4.13,1.72
      c-1.06,1.06-1.72,2.53-1.72,4.13v83.29c0,1.61,0.66,3.07,1.72,4.13c1.06,1.06,2.53,1.72,4.13,1.72h91.34
      c1.61,0,3.07-0.66,4.13-1.72c1.06-1.06,1.72-2.53,1.72-4.13V15.77c0-1.61-0.66-3.07-1.72-4.13
      C110.18,10.57,108.72,9.91,107.11,9.91z M63.38,57.01c0-2.51,0.42-4.97,1.26-7.4c0.84-2.43,2.07-4.61,3.68-6.54
      c1.61-1.93,3.57-3.49,5.87-4.68c2.3-1.2,4.92-1.79,7.87-1.79c3.53,0,6.59,0.82,9.18,2.46c2.59,1.64,4.52,3.81,5.79,6.51l-7.67,6.13
      c-0.34-1-0.8-1.83-1.36-2.49c-0.57-0.66-1.19-1.18-1.88-1.56c-0.69-0.39-1.4-0.66-2.14-0.81c-0.74-0.15-1.45-0.23-2.14-0.23
      c-1.44,0-2.68,0.32-3.73,0.95c-1.05,0.64-1.9,1.46-2.57,2.49s-1.17,2.18-1.49,3.47c-0.33,1.29-0.49,2.57-0.49,3.85
      c0,1.43,0.19,2.8,0.57,4.11c0.38,1.31,0.93,2.47,1.65,3.47c0.72,1,1.6,1.8,2.65,2.4c1.05,0.6,2.22,0.9,3.52,0.9
      c0.69,0,1.39-0.09,2.11-0.26c0.72-0.17,1.41-0.46,2.08-0.87c0.67-0.4,1.27-0.93,1.8-1.56c0.53-0.64,0.95-1.42,1.26-2.34l8.18,5.49
      c-0.55,1.5-1.38,2.85-2.5,4.05c-1.11,1.2-2.38,2.2-3.81,3.01c-1.42,0.81-2.95,1.43-4.58,1.85c-1.63,0.42-3.22,0.64-4.76,0.64
      c-2.71,0-5.19-0.61-7.43-1.82c-2.25-1.21-4.18-2.82-5.81-4.83c-1.63-2-2.89-4.28-3.78-6.82C63.82,62.21,63.37,59.63,63.38,57.01z"
      />
    </g>
  </svg>
`;
const qualityIcon = `
  <svg
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    stroke-width="2"
    stroke-linecap="round"
    stroke-linejoin="round"
  >
    <line x1="4" y1="21" x2="4" y2="14" />
    <line x1="4" y1="10" x2="4" y2="3" />
    <line x1="12" y1="21" x2="12" y2="12" />
    <line x1="12" y1="8" x2="12" y2="3" />
    <line x1="20" y1="21" x2="20" y2="16" />
    <line x1="20" y1="12" x2="20" y2="3" />
    <line x1="1" y1="14" x2="7" y2="14" />
    <line x1="9" y1="8" x2="15" y2="8" />
    <line x1="17" y1="16" x2="23" y2="16" />
  </svg>
`;
const chevronRightIcon = `
  <svg
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    stroke-width="2"
    stroke-linecap="round"
    stroke-linejoin="round"
  >
    <polyline points="9,18 15,12 9,6"></polyline>
  </svg>
`;
const chevronLeftIcon = `
  <svg
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    stroke-width="2"
    stroke-linecap="round"
    stroke-linejoin="round"
  >
    <polyline points="15,6 9,12 15,18"></polyline>
  </svg>
`;
const volumeLowIcon = `
  <svg height="24" width="24" version="1.1" viewBox="4 6 21.5 24">
    <use class="ytp-svg-shadow" xlink:href="#ytp-id-15"></use>
    <use class="ytp-svg-shadow" xlink:href="#ytp-id-16"></use>
    <defs>
      <clipPath id="ytp-svg-volume-animation-mask">
        <path d="m 14.35,-0.14 -5.86,5.86 20.73,20.78 5.86,-5.91 z"></path>
        <path d="M 7.07,6.87 -1.11,15.33 19.61,36.11 27.80,27.60 z"></path>
        <path
          class="ytp-svg-volume-animation-mover"
          d="M 9.09,5.20 6.47,7.88 26.82,28.77 29.66,25.99 z"
          transform="translate(0, 0)"
        ></path>
      </clipPath>
      <clipPath id="ytp-svg-volume-animation-slash-mask">
        <path
          class="ytp-svg-volume-animation-mover"
          d="m -11.45,-15.55 -4.44,4.51 20.45,20.94 4.55,-4.66 z"
          transform="translate(0, 0)"
        ></path>
      </clipPath>
    </defs>
    <path
      class="ytp-svg-fill ytp-svg-volume-animation-speaker"
      clip-path="url(#ytp-svg-volume-animation-mask)"
      d="M8,21 L12,21 L17,26 L17,10 L12,15 L8,15 L8,21 Z M19,14 L19,22 C20.48,21.32 21.5,19.77 21.5,18 C21.5,16.26 20.48,14.74 19,14 Z"
      fill="#fff"
      id="ytp-id-15"
    ></path>
    <path
      class="ytp-svg-fill ytp-svg-volume-animation-hider"
      clip-path="url(#ytp-svg-volume-animation-slash-mask)"
      d="M 9.25,9 7.98,10.27 24.71,27 l 1.27,-1.27 Z"
      fill="#fff"
      id="ytp-id-16"
      style="display: none;"
    ></path>
  </svg>
`;
const volumeHighIcon = `
  <svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
    <path d="M14,3.23V5.29C16.89,6.15 19,8.83 19,12C19,15.17 16.89,17.85 14,18.71V20.77C18.01,19.86 21,16.28 21,12C21,7.72 18.01,4.14 14,3.23M16.5,12C16.5,10.23 15.5,8.71 14,7.97V16C15.5,15.29 16.5,13.76 16.5,12M3,9V15H7L12,20V4L7,9H3Z" />
  </svg>
`;
const volumeMutedIcon = `
  <svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
    <path d="M12,4L9.91,6.09L12,8.18M4.27,3L3,4.27L7.73,9H3V15H7L12,20V13.27L16.25,17.53C15.58,18.04 14.83,18.46 14,18.7V20.77C15.38,20.45 16.63,19.82 17.68,18.96L19.73,21L21,19.73L12,10.73M19,12C19,12.94 18.8,13.82 18.46,14.64L19.97,16.15C20.62,14.91 21,13.5 21,12C21,7.72 18,4.14 14,3.23V5.29C16.89,6.15 19,8.83 19,12M16.5,12C16.5,10.23 15.5,8.71 14,7.97V10.18L16.45,12.63C16.5,12.43 16.5,12.21 16.5,12Z" />
  </svg>
`;
const checkIcon = `
  <svg
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <polyline
      points="20,6 9,17 4,12"
      stroke="currentColor"
      stroke-width="2"
      stroke-linecap="round"
      stroke-linejoin="round"
    ></polyline>
  </svg>
`;
const shareIcon = `
  <svg
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M15.4306 7.70172C7.55045 7.99826 3.43929 15.232 2.17021 19.3956C2.07701 19.7014 2.31139 20 2.63107 20C2.82491 20 3.0008 19.8828 3.08334 19.7074C6.04179 13.4211 12.7066 12.3152 15.514 12.5639C15.7583 12.5856 15.9333 12.7956 15.9333 13.0409V15.1247C15.9333 15.5667 16.4648 15.7913 16.7818 15.4833L20.6976 11.6784C20.8723 11.5087 20.8993 11.2378 20.7615 11.037L16.8456 5.32965C16.5677 4.92457 15.9333 5.12126 15.9333 5.61253V7.19231C15.9333 7.46845 15.7065 7.69133 15.4306 7.70172Z"
      fill="currentColor"
      stroke="currentColor"
      stroke-linecap="round"
      stroke-linejoin="round"
    ></path>
  </svg>
`;
const subtitleToggleIcon = `
  <svg
    version="1.1"
    viewBox="8 10 20 16"
    width="100%"
    fill-opacity="1"
  >
    <path
      d="M11,11 C9.89,11 9,11.9 9,13 L9,23 C9,24.1 9.89,25 11,25 L25,25 C26.1,25 27,24.1 27,23 L27,13 C27,11.9 26.1,11 25,11 L11,11 Z M17,17 L15.5,17 L15.5,16.5 L13.5,16.5 L13.5,19.5 L15.5,19.5 L15.5,19 L17,19 L17,20 C17,20.55 16.55,21 16,21 L13,21 C12.45,21 12,20.55 12,20 L12,16 C12,15.45 12.45,15 13,15 L16,15 C16.55,15 17,15.45 17,16 L17,17 L17,17 Z M24,17 L22.5,17 L22.5,16.5 L20.5,16.5 L20.5,19.5 L22.5,19.5 L22.5,19 L24,19 L24,20 C24,20.55 23.55,21 23,21 L20,21 C19.45,21 19,20.55 19,20 L19,16 C19,15.45 19.45,15 20,15 L23,15 C23.55,15 24,15.45 24,16 L24,17 L24,17 Z"
      fill="#fff"
    ></path>
  </svg>
`;
const settingIcon = `
  <svg height="100%" version="1.1" viewBox="0 0 36 36" width="100%">
    <use class="ytp-svg-shadow" xlink:href="#ytp-id-19"></use>
    <path
      d="m 23.94,18.78 c .03,-0.25 .05,-0.51 .05,-0.78 0,-0.27 -0.02,-0.52 -0.05,-0.78 l 1.68,-1.32 c .15,-0.12 .19,-0.33 .09,-0.51 l -1.6,-2.76 c -0.09,-0.17 -0.31,-0.24 -0.48,-0.17 l -1.99,.8 c -0.41,-0.32 -0.86,-0.58 -1.35,-0.78 l -0.30,-2.12 c -0.02,-0.19 -0.19,-0.33 -0.39,-0.33 l -3.2,0 c -0.2,0 -0.36,.14 -0.39,.33 l -0.30,2.12 c -0.48,.2 -0.93,.47 -1.35,.78 l -1.99,-0.8 c -0.18,-0.07 -0.39,0 -0.48,.17 l -1.6,2.76 c -0.10,.17 -0.05,.39 .09,.51 l 1.68,1.32 c -0.03,.25 -0.05,.52 -0.05,.78 0,.26 .02,.52 .05,.78 l -1.68,1.32 c -0.15,.12 -0.19,.33 -0.09,.51 l 1.6,2.76 c .09,.17 .31,.24 .48,.17 l 1.99,-0.8 c .41,.32 .86,.58 1.35,.78 l .30,2.12 c .02,.19 .19,.33 .39,.33 l 3.2,0 c .2,0 .36,-0.14 .39,-0.33 l .30,-2.12 c .48,-0.2 .93,-0.47 1.35,-0.78 l 1.99,.8 c .18,.07 .39,0 .48,-0.17 l 1.6,-2.76 c .09,-0.17 .05,-0.39 -0.09,-0.51 l -1.68,-1.32 0,0 z m -5.94,2.01 c -1.54,0 -2.8,-1.25 -2.8,-2.8 0,-1.54 1.25,-2.8 2.8,-2.8 1.54,0 2.8,1.25 2.8,2.8 0,1.54 -1.25,2.8 -2.8,2.8 l 0,0 z"
      fill="#fff"
      id="ytp-id-19"
    ></path>
  </svg>
`;
const fullScreenIcon = `
  <svg
    viewBox="0 0 24 24"
    fill="currentColor"
    width="24"
    height="24"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z" />
  </svg>
`;
const exitFullScreenIcon = `
  <svg
    viewBox="0 0 24 24"
    fill="currentColor"
    width="24"
    height="24"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z" />
  </svg>
`;
const playIcon = `
  <svg
    viewBox="0 0 24 24"
    fill="currentColor"
    width="24"
    height="24"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M8 5v14l11-7z" />
  </svg>
`;
const pauseIcon = `
  <svg
    viewBox="0 0 24 24"
    fill="currentColor"
    width="24"
    height="24"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M6 19h4V5H6v14zm8-14v14h4V5h-4z" />
  </svg>
`;
const replayIcon = `
  <svg
    width="20px"
    height="20px"
    viewBox="-4.5 -3 25 25"
    version="1.1"
    xmlns="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
  >
    <title>multimedia / 7 - multimedia, refresh, replay, video icon</title>
    <g
      id="Free-Icons"
      stroke="none"
      stroke-width="1"
      fill="none"
      fill-rule="evenodd"
    >
      <g transform="translate(-1193.000000, -305.000000)" id="Group">
        <g transform="translate(1189.000000, 302.000000)" id="Shape">
          <path
            d="M12,7 C15.8659932,7 19,10.1340068 19,14 C19,17.8659932 15.8659932,21 12,21 C8.13400675,21 5,17.8659932 5,14"
            stroke="white"
            stroke-width="2"
            stroke-linecap="round"
            stroke-linejoin="round"
          ></path>
          <path
            d="M10.8260915,10.8857148 L5.69568021,7.30477744 C5.47956961,7.17854145 5.43577155,6.93976099 5.5978545,6.77144635 C5.62566353,6.74256812 5.65860149,6.71691486 5.69568021,6.69525619 L10.8260915,3.11431886 C11.1502574,2.92496489 11.610137,2.97613213 11.8532614,3.2286041 C11.948511,3.32751578 12,3.4478202 12,3.5714598 L12,10.4285738 C12,10.7441638 11.6715145,11 11.2663072,11 C11.1075579,11 10.9530909,10.9598985 10.8260915,10.8857148 Z"
            fill="white"
          ></path>
        </g>
      </g>
    </g>
  </svg>
`;
const loadingIcon = `
  <svg
    width="80"
    height="80"
    viewBox="0 0 80 80"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <circle
      cx="40"
      cy="40"
      r="35"
      stroke="white"
      stroke-width="3"
      stroke-linecap="round"
      fill="none"
      opacity="0.3"
    />
    <circle
      cx="40"
      cy="40"
      r="35"
      stroke="white"
      stroke-width="3"
      stroke-linecap="round"
      fill="none"
      stroke-dasharray="55 165"
      stroke-dashoffset="0"
    >
      <animateTransform
        attributeName="transform"
        type="rotate"
        values="0 40 40;360 40 40"
        dur="1.5s"
        repeatCount="indefinite"
      />
    </circle>
  </svg>
`;

// Export all icons



/***/ }),

/***/ "./src/components/CustomControlBar.js":
/*!********************************************!*\
  !*** ./src/components/CustomControlBar.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _control_bar_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./control-bar/components */ "./src/components/control-bar/components/index.js");
/* harmony import */ var _styles_custom_control_bar_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../styles/custom-control-bar.css */ "./src/styles/custom-control-bar.css");




const Component = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Component');

class CustomControlBar extends Component {
  constructor(player) {
    super(player);

    console.log('CustomControlBar ready, setting up controls...');
    /**
     * このコンポーネントは Video.js の標準 `ControlBar` を置き換えるための “独自UI” です。
     * `VideoJSDRMPlayer` 側で classicControls=false の場合にプレイヤーDOMへ append されます。
     *
     * 構造（createEl 内のHTML）：
     * - 上段：プログレスバー（シーク）
     * - 下段左：再生/音量/時間
     * - 下段右：字幕/設定/フルスクリーン
     */
    this.setupControls();
  }

  createEl() {
    const el = super.createEl('div', {
      className: 'custom-video-control-bar'
    });

    // コントロールバーの骨組みだけを先に生成し、
    // 各ボタンコンポーネントは setupControls() でそれぞれのコンテナへ差し込みます。
    el.innerHTML = `
      <div class="custom-progress-container"></div>
      <div class="custom-controls-container">
        <div class="custom-controls-left">
          <div class="custom-play-button-container"></div>
          <div class="custom-volume-container"></div>
          <div class="custom-time-display-container"></div>
        </div>
        <div class="custom-controls-right">
          <div class="custom-cc-button-container"></div>
          <div class="custom-settings-button-container"></div>
          <div class="custom-fullscreen-button-container"></div>
        </div>
      </div>
    `;

    return el;
  }

  ready() {
    super.ready();
    console.log('CustomControlBar ready!');
  }

  setupControls() {
    // タッチ端末は hover が無いので、ボリュームスライダーの出し分けを行う
    const isTouchDevice = 'ontouchstart' in window || navigator.maxTouchPoints > 0;

    // Progress Bar（シーク）
    const progressBar = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar(this.player(), {});
    const progressContainer = this.el().querySelector('.custom-progress-container');
    progressContainer.appendChild(progressBar.el());

    // Play Button
    const playButton = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.PlayButton(this.player(), {});
    const playContainer = this.el().querySelector('.custom-play-button-container');
    playContainer.appendChild(playButton.el());

    // Volume（ボタン + スライダー）
    const volumeContainer = this.el().querySelector('.custom-volume-container');
    const volumeButton = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.VolumeButton(this.player(), {});
    volumeContainer.appendChild(volumeButton.el());
    if (!isTouchDevice) {
      const volumeSlider = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.VolumeSlider(this.player(), {});
      volumeContainer.appendChild(volumeSlider.el());
      this.setupVolumeSliderHover(volumeContainer, volumeSlider.el());
    }

    if (!this.player().options_.audioOnlyMode) {
      // 時間表示（audioOnlyMode のときは省略）
      const timeDisplay = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.TimeDisplay(this.player(), {});
      const timeContainer = this.el().querySelector('.custom-time-display-container');
      timeContainer.appendChild(timeDisplay.el());

      // 字幕ボタン（CC）
      const ccButton = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.CCButton(this.player(), {});
      const ccContainer = this.el().querySelector('.custom-cc-button-container');
      ccContainer.appendChild(ccButton.el());

      // 設定ポップアップ（再生速度/画質/字幕）
      const settingsButton = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.SettingsButton(this.player(), {});
      const settingsContainer = this.el().querySelector('.custom-settings-button-container');
      settingsContainer.appendChild(settingsButton.el());

      // フルスクリーン
      const fullscreenButton = new _control_bar_components__WEBPACK_IMPORTED_MODULE_1__.FullscreenButton(this.player(), {
        controlBar: this.el()
      });
      const fullscreenContainer = this.el().querySelector('.custom-fullscreen-button-container');
      fullscreenContainer.appendChild(fullscreenButton.el());
    }
  }


  setupVolumeSliderHover(vContainer, vSlider) {
    if (!vContainer || !vSlider) return;

    // マウスが外れたらスライダーを隠す（タッチ端末は hover が無いので使わない）
    const hideSlider = () => {
      vSlider.style.opacity = "0";
      vSlider.style.width = "0";
      vSlider.style.paddingRight = "0";
    };

    // 初期状態は隠す
    hideSlider();

    // hover で表示
    vContainer.addEventListener("mouseenter", () => {
      this.clearVolumeTimer();
      vSlider.style.opacity = "1";
      vSlider.style.width = null;
      vSlider.style.paddingRight = "4px";
    });

    vContainer.addEventListener("mouseleave", (e) => {
      this.volumnTimer = setTimeout(() => {
        hideSlider();
      }, 200);
    });
  }

  clearVolumeTimer() {
    if (this.volumnTimer) {
      clearTimeout(this.volumnTimer);
      this.volumnTimer = null;
    }
  }

  dispose() {
    // TODO: 追加したイベントリスナの掃除をより厳密に（必要なら）
    this.clearVolumeTimer();
    super.dispose();
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('CustomControlBar', CustomControlBar);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomControlBar);


/***/ }),

/***/ "./src/components/control-bar/components/CCButton.js":
/*!***********************************************************!*\
  !*** ./src/components/control-bar/components/CCButton.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../assets/icons/index.js */ "./src/assets/icons/index.js");
/* harmony import */ var _styles_cc_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../styles/cc-button.css */ "./src/styles/cc-button.css");




const Button = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Button');

class CCButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Closed Captions');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-cc-button'
    });
    
    el.innerHTML = `
      ${_assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.subtitleToggleIcon}
      <div class="videojs-drm-subtitle-toggle-indicator"></div>
    `;

    return el;
  }

  handleClick() {
    // Toggle captions if available
    const tracks = this.player().textTracks();
    const captionTracks = Array.from(tracks).filter(track => 
      track.kind === 'captions' || track.kind === 'subtitles' || track.kind === "subtitle"
    );
    
    if (captionTracks.length === 0) {
      return; // No captions available
    }
    
    // Check if any caption is currently showing
    const hasActiveCaption = captionTracks.some(track => track.mode === 'showing');
    
    if (hasActiveCaption) {
      // Turn off all captions
      captionTracks.forEach(track => {
        track.mode = 'disabled';
      });
    } else {
      // Turn on the first caption track
      captionTracks[0].mode = 'showing';
    }
    
    // Update button state
    this.updateButtonState();
    
    // Notify settings popup if it exists
    this.notifySettingsPopup();
  }
  
  notifySettingsPopup() {
    // Use VideoJS events to communicate with SettingsPopup
    this.player().trigger('subtitlechanged');
  }

  ready() {
    super.ready();

    // Listen for loadedmetadata to get subtitles
    this.player().on("loadedmetadata", () => {
      // Set timeout to ensure text tracks are loaded (for Safari)
      this.setTimeout(() => {
        this.disableSubtitlesByDefault();
        this.updateButtonState();
      }, 1000);
    });
    
    // this.player().on('texttrackchange', () => {
    //   this.updateButtonState();
    // });
    
    // Listen for subtitle changes from SettingsPopup
    this.player().on('subtitlechanged', () => {
      this.updateButtonState();
    });
  }
  
  disableSubtitlesByDefault() {
    const tracks = this.player().textTracks();
    Array.from(tracks).filter(track => 
      track.kind === 'captions' || track.kind === 'subtitles' || track.kind === 'subtitle'
    ).forEach(track => {
      track.mode = 'disabled';
    });
  }

  updateButtonState() {
    const tracks = this.player().textTracks();
    const hasCaptions = Array.from(tracks).some(track => 
      track.kind === 'captions' || track.kind === 'subtitles' || track.kind === 'subtitle'
    );
    
    const hasActiveCaption = Array.from(tracks).some(track => 
      (track.kind === 'captions' || track.kind === 'subtitles' || track.kind === 'subtitle') && track.mode === 'showing'
    );

    const indicator = this.el().querySelector('.videojs-drm-subtitle-toggle-indicator');
    
    // Enable/disable button based on caption availability
    this.el().disabled = !hasCaptions;
    this.el().style.opacity = hasCaptions ? '1' : '0.5';
    
    // Add red underline when captions are active
    if (hasActiveCaption) {
      indicator.style.opacity = '1';
    } else {
      indicator.style.opacity = '0';
    }
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('CCButton', CCButton);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CCButton);





/***/ }),

/***/ "./src/components/control-bar/components/FullscreenButton.js":
/*!*******************************************************************!*\
  !*** ./src/components/control-bar/components/FullscreenButton.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../assets/icons/index.js */ "./src/assets/icons/index.js");
/* harmony import */ var _styles_fullscreen_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../styles/fullscreen-button.css */ "./src/styles/fullscreen-button.css");




const Button = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Button');

class FullscreenButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Fullscreen');
    this.hideTimeout = null;
    this.isFullscreen = false;
    this.isMouseOverControls = false;
    this.controlBar = options.controlBar || null;
    this.isTouchDevice = false;
    this.isTouching = false;
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-fullscreen-button'
    });
    
    el.innerHTML = _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.fullScreenIcon;
    
    return el;
  }

  handleClick() {
    if (this.player().isFullscreen()) {
      this.player().exitFullscreen();
    } else {
      this.player().requestFullscreen();
    }
  }

  updateFullscreenIcon(isFullscreen) {
    this.el().innerHTML = isFullscreen ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.exitFullScreenIcon : _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.fullScreenIcon;
  }

  ready() {
    super.ready();
    
    // Listen to player events
    this.player().on('fullscreenchange', () => {
      this.isFullscreen = this.player().isFullscreen();
      this.updateFullscreenIcon(this.isFullscreen);
      this.handleFullscreenChange();
    });

    this.player().on('enterfullscreen', () => {
      this.isFullscreen = true;
      this.updateFullscreenIcon(true);
      this.handleFullscreenChange();
    });

    this.player().on('exitfullscreen', () => {
      this.isFullscreen = false;
      this.updateFullscreenIcon(false);
      this.handleFullscreenChange();
    });
  }

  handleFullscreenChange() {
    if (this.isFullscreen) {
      // In fullscreen, start auto-hide behavior
      this.setupAutoHideBehavior();
      this.resetHideTimeout();
    } else {
      // Not in fullscreen, always show controls
      this.showControls();
      this.clearHideTimeout();
      this.removeAutoHideBehavior();
    }
  }

  setupAutoHideBehavior() {
    if (!this.controlBar) return;

    const playerEl = this.player().el();
    
    // Detect touch device
    this.isTouchDevice = 'ontouchstart' in window || navigator.maxTouchPoints > 0;

    if (!this.isTouchDevice) {
      // Mouse events for desktop
      const handleMouseActivity = (event) => {
        this.showControls();
        this.resetHideTimeout();
      };

      const handleControlMouseEnter = () => {
        this.isMouseOverControls = true;
      };

      const handleControlMouseLeave = () => {
        this.isMouseOverControls = false;
      };

      // Add event listeners
      playerEl.addEventListener('click', handleMouseActivity);
      playerEl.addEventListener('mousemove', handleMouseActivity);
      this.controlBar.addEventListener('mouseenter', handleControlMouseEnter);
      this.controlBar.addEventListener('mouseleave', handleControlMouseLeave);

      this.handleMouseActivity = handleMouseActivity;
      this.handleControlMouseEnter = handleControlMouseEnter;
      this.handleControlMouseLeave = handleControlMouseLeave;
    } else {
      // Touch events for mobile
      const handleTouchStart = () => {
        this.isTouching = true;
        this.showControls();
      };

      const handleTouchMove = () => {
        this.showControls();
        this.resetHideTimeout();
      };

      const handleTouchEnd = () => {
        this.isTouching = false;
        this.resetHideTimeout();
      };

      playerEl.addEventListener('touchstart', handleTouchStart, { passive: true });
      playerEl.addEventListener('touchmove', handleTouchMove, { passive: true });
      playerEl.addEventListener('touchend', handleTouchEnd, { passive: true });
      playerEl.addEventListener('touchcancel', handleTouchEnd, { passive: true });

      this.handleTouchStart = handleTouchStart;
      this.handleTouchMove = handleTouchMove;
      this.handleTouchEnd = handleTouchEnd;
    }
  }

  removeAutoHideBehavior() {
    if (!this.controlBar) return;

    const playerEl = this.player().el();

    // Remove event listeners
    if (this.handleMouseActivity) {
      playerEl.removeEventListener('click', this.handleMouseActivity);
      playerEl.removeEventListener('mousemove', this.handleMouseActivity);
    }
    if (this.handleControlMouseEnter) {
      this.controlBar.removeEventListener('mouseenter', this.handleControlMouseEnter);
    }
    if (this.handleControlMouseLeave) {
      this.controlBar.removeEventListener('mouseleave', this.handleControlMouseLeave);
    }
    if (this.handleTouchStart) {
      playerEl.removeEventListener('touchstart', this.handleTouchStart);
    }
    if (this.handleTouchMove) {
      playerEl.removeEventListener('touchmove', this.handleTouchMove);
    }
    if (this.handleTouchEnd) {
      playerEl.removeEventListener('touchend', this.handleTouchEnd);
      playerEl.removeEventListener('touchcancel', this.handleTouchEnd);
    }

    // Clear references
    this.handleMouseActivity = null;
    this.handleControlMouseEnter = null;
    this.handleControlMouseLeave = null;
    this.handleTouchStart = null;
    this.handleTouchMove = null;
    this.handleTouchEnd = null;
  }

  showControls() {
    if (this.controlBar) {
      this.controlBar.style.opacity = '1';
      this.controlBar.style.visibility = 'visible';
    }
  }

  hideControls() {
    if (this.controlBar && this.isFullscreen && !this.isMouseOverControls && !this.isTouching) {
      this.controlBar.style.opacity = '0';
      this.controlBar.style.visibility = 'hidden';
    }
  }

  resetHideTimeout() {
    this.clearHideTimeout();
    if (this.isFullscreen) {
      // Different timeout for touch vs mouse devices
      const timeout = this.isTouchDevice ? 3000 : 4000; // 3s for touch, 4s for mouse
      this.hideTimeout = setTimeout(() => {
        this.hideControls();
      }, timeout);
    }
  }

  clearHideTimeout() {
    if (this.hideTimeout) {
      clearTimeout(this.hideTimeout);
      this.hideTimeout = null;
    }
  }

  dispose() {
    // Clean up event listeners and timeouts
    this.clearHideTimeout();
    this.removeAutoHideBehavior();
    super.dispose();
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('FullscreenButton', FullscreenButton);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FullscreenButton);


/***/ }),

/***/ "./src/components/control-bar/components/PlayButton.js":
/*!*************************************************************!*\
  !*** ./src/components/control-bar/components/PlayButton.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../assets/icons/index.js */ "./src/assets/icons/index.js");
/* harmony import */ var _styles_play_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../styles/play-button.css */ "./src/styles/play-button.css");




const Button = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Button');

class PlayButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Play/Pause');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-play-button'
    });
    
    el.innerHTML = _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.playIcon;
    
    return el;
  }

  handleClick() {
    if (this.player().paused()) {
      this.player().play();
    } else {
      this.player().pause();
    }
  }

  updatePlayButton() {
    this.el().innerHTML = this.player().ended()
    ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.replayIcon
    : this.player().paused()
    ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.playIcon
    : _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.pauseIcon;
  }

  ready() {
    super.ready();
    
    // Listen to player events
    this.player().on('play', () => this.updatePlayButton());

    this.player().on('pause', () => this.updatePlayButton());

    this.player().on('ended', () => this.updatePlayButton());

    this.updatePlayButton();
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('PlayButton', PlayButton);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlayButton);





/***/ }),

/***/ "./src/components/control-bar/components/ProgressBar.js":
/*!**************************************************************!*\
  !*** ./src/components/control-bar/components/ProgressBar.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_progress_bar_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../styles/progress-bar.css */ "./src/styles/progress-bar.css");



const Component = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent("Component");

class ProgressBar extends Component {
  constructor(player, options) {
    super(player, options);

    this.isDragging = false;
    this.isTouchDragging = false;
    this.tooltipTimeout = null;
  }

  createEl() {
    const el = super.createEl("div", {
      className: "custom-progress-container",
    });

    // Create progress bar HTML structure
    el.innerHTML = `
        <div class="custom-progress-loaded"></div>
        <div class="custom-progress-played"></div>
        <div class="custom-progress-handle"></div>
        <div class="custom-progress-tooltip">00:00</div>
    `;

    return el;
  }

  ready() {
    super.ready();
    this.setupProgressBar();
  }

  setupProgressBar() {
    const loadedBar = this.el().querySelector(".custom-progress-loaded");
    const playedBar = this.el().querySelector(".custom-progress-played");
    const handle = this.el().querySelector(".custom-progress-handle");
    const tooltip = this.el().querySelector(".custom-progress-tooltip");

    // Update progress display
    const updateProgress = () => {
      const currentTime = this.player().currentTime() || 0;
      const duration = this.player().duration() || 0;
      const buffered = this.player().buffered();

      if (duration > 0) {
        const playedPercent = (currentTime / duration) * 100;
        playedBar.style.width = `${playedPercent}%`;
        handle.style.left = `${playedPercent}%`;

        // Update loaded progress
        if (buffered.length > 0) {
          const loadedPercent =
            (buffered.end(buffered.length - 1) / duration) * 100;
          loadedBar.style.width = `${loadedPercent}%`;
        }
      }
    };

    // Handle click/tap to seek
    const seekToPosition = (e) => {
      const rect = this.el().getBoundingClientRect();
      const clientX =
        e.clientX || (e.touches && e.touches[0] ? e.touches[0].clientX : 0);
      const percent = Math.max(
        0,
        Math.min(1, (clientX - rect.left) / rect.width)
      );
      const duration = this.player().duration();
      const seekTime = percent * duration;

      if (duration && !isNaN(duration)) {
        this.player().currentTime(seekTime);
      }
    };

    // Helper function to format time
    const formatTime = (seconds) => {
      if (isNaN(seconds) || seconds < 0) {
        seconds = 0;
      }
      const date = new Date(null);
      date.setSeconds(seconds);
      const result = date.toISOString().substr(11, 8);
      return result.startsWith("00:") ? result.substr(3) : result;
    };

    // Update tooltip based on mouse/touch position
    const updateTooltipPosition = (e) => {
      const rect = this.el().getBoundingClientRect();
      const clientX =
        e.clientX || (e.touches && e.touches[0] ? e.touches[0].clientX : 0);
      const percent = Math.max(
        0,
        Math.min(1, (clientX - rect.left) / rect.width)
      );
      const duration = this.player().duration();

      if (duration && !isNaN(duration)) {
        const seekTime = percent * duration;
        tooltip.textContent = formatTime(seekTime);

        // Position tooltip at mouse/touch position
        const leftPercent = percent * 100;
        tooltip.style.left =
          leftPercent < 1
            ? "3px"
            : leftPercent > 99
            ? "calc(100% - 3px)"
            : `${leftPercent}%`;
      }
    };

    // Show tooltip
    const showTooltip = (e) => {
      clearTimeout(this.tooltipTimeout);
      tooltip.style.opacity = "1";
      tooltip.style.visibility = "visible";
      updateTooltipPosition(e);
    };

    // Hide tooltip with delay
    const hideTooltip = (delay = 0) => {
      clearTimeout(this.tooltipTimeout);
      this.tooltipTimeout = setTimeout(() => {
        tooltip.style.opacity = "0";
        tooltip.style.visibility = "hidden";
      }, delay);
    };

    // Mouse events
    this.el().addEventListener("click", seekToPosition);

    // Handle drag to seek
    const handleDrag = (e) => {
      if (this.isDragging || this.isTouchDragging) {
        seekToPosition(e);
      }
      updateTooltipPosition(e);
    };

    this.el().addEventListener("mousedown", (e) => {
      this.isDragging = true;
      seekToPosition(e);
    });

    document.addEventListener("mousemove", handleDrag);
    document.addEventListener("mouseup", () => {
      this.isDragging = false;
      if (!this.el().matches(":hover")) {
        hideTooltip();
      }
    });

    // Touch events for mobile
    this.el().addEventListener("touchstart", (e) => {
      e.preventDefault();
      this.isTouchDragging = true;
      showTooltip(e);
      seekToPosition(e);
    });

    this.el().addEventListener("touchmove", (e) => {
      e.preventDefault();
      if (this.isTouchDragging) {
        handleDrag(e);
      }
    });

    this.el().addEventListener("touchend", (e) => {
      e.preventDefault();
      this.isTouchDragging = false;
      // Hide tooltip after a delay on touch end
      hideTooltip(1000);
    });

    // Handle touch cancel
    this.el().addEventListener("touchcancel", (e) => {
      e.preventDefault();
      this.isTouchDragging = false;
      hideTooltip();
    });

    // Show tooltip on hover with position tracking
    this.el().addEventListener("mouseenter", (e) => {
      showTooltip(e);
    });

    this.el().addEventListener("mouseleave", () => {
      if (!this.isDragging) {
        hideTooltip();
      }
    });

    // Listen to player events
    this.player().on("timeupdate", updateProgress);
    this.player().on("progress", updateProgress);
    this.player().on("loadedmetadata", updateProgress);
    this.player().on("durationchange", updateProgress);
  }

  dispose() {
    // Clear tooltip timeout
    if (this.tooltipTimeout) {
      clearTimeout(this.tooltipTimeout);
      this.tooltipTimeout = null;
    }

    super.dispose();
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent("ProgressBar", ProgressBar);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProgressBar);


/***/ }),

/***/ "./src/components/control-bar/components/SettingsButton.js":
/*!*****************************************************************!*\
  !*** ./src/components/control-bar/components/SettingsButton.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_settings_button_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../styles/settings-button.css */ "./src/styles/settings-button.css");
/* harmony import */ var _SettingsPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SettingsPopup */ "./src/components/control-bar/components/SettingsPopup.js");




const Button = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Button');

class SettingsButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Settings');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-settings-button'
    });
    
    el.innerHTML = `
      <svg viewBox="0 0 24 24" fill="currentColor">
        <path d="M19.14,12.94c0.04-0.3,0.06-0.61,0.06-0.94c0-0.32-0.02-0.64-0.07-0.94l2.03-1.58c0.18-0.14,0.23-0.41,0.12-0.61 l-1.92-3.32c-0.12-0.22-0.37-0.29-0.59-0.22l-2.39,0.96c-0.5-0.38-1.03-0.7-1.62-0.94L14.4,2.81c-0.04-0.24-0.24-0.41-0.48-0.41 h-3.84c-0.24,0-0.43,0.17-0.47,0.41L9.25,5.35C8.66,5.59,8.12,5.92,7.63,6.29L5.24,5.33c-0.22-0.08-0.47,0-0.59,0.22L2.74,8.87 C2.62,9.08,2.66,9.34,2.86,9.48l2.03,1.58C4.84,11.36,4.8,11.69,4.8,12s0.02,0.64,0.07,0.94l-2.03,1.58 c-0.18,0.14-0.23,0.41-0.12,0.61l1.92,3.32c0.12,0.22,0.37,0.29,0.59,0.22l2.39-0.96c0.5,0.38,1.03,0.7,1.62,0.94l0.36,2.54 c0.05,0.24,0.24,0.41,0.48,0.41h3.84c0.24,0,0.44-0.17,0.47-0.41l0.36-2.54c0.59-0.24,1.13-0.56,1.62-0.94l2.39,0.96 c0.22,0.08,0.47,0,0.59-0.22l1.92-3.32c0.12-0.22,0.07-0.47-0.12-0.61L19.14,12.94z M12,15.6c-1.98,0-3.6-1.62-3.6-3.6 s1.62-3.6,3.6-3.6s3.6,1.62,3.6,3.6S13.98,15.6,12,15.6z"/>
      </svg>
    `;

    this.settingsPopup = new _SettingsPopup__WEBPACK_IMPORTED_MODULE_2__["default"](this.player());
    el.appendChild(this.settingsPopup.el());
    
    return el;
  }

  handleClick() {
    if (this.settingsPopup) {
      this.settingsPopup.toggle();
    }
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('SettingsButton', SettingsButton);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsButton);


/***/ }),

/***/ "./src/components/control-bar/components/SettingsPopup.js":
/*!****************************************************************!*\
  !*** ./src/components/control-bar/components/SettingsPopup.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_settings_popup_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../styles/settings-popup.css */ "./src/styles/settings-popup.css");
/* harmony import */ var _helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../helpers/renditionHelper */ "./src/helpers/renditionHelper.js");
/* harmony import */ var _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../assets/icons/index.js */ "./src/assets/icons/index.js");





const Component = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent("Component");

const AUTO_QUALITY_ID = -1;
const DEFAULT_QUALITY = {
  id: AUTO_QUALITY_ID,
  label: "Auto",
};

class SettingsPopup extends Component {
  constructor(player, options) {
    super(player, options);
    /**
     * 設定ポップアップ（歯車ボタンで開くメニュー）
     *
     * 目的：
     * - 再生速度（playbackRate）
     * - 画質（HLSの場合は Video.js/VHS、Shakaの場合は Shaka の VariantTrack）
     * - 字幕（Video.js textTracks / Shaka textTracks を UI で ON/OFF）
     *
     * 補足：
     * - Shaka Tech 使用時は `loadedqualitydata` イベント + qualitySwitchCallback を受け取り、
     *   Shaka の ABR/variant 選択を直接切り替えます。
     */
    this.isPopupOpen = false;
    this.currentSpeed = 1;
    this.currentRendition = DEFAULT_QUALITY;
    this.renditions = [];
    this.currentSubtitle = null;
    this.subtitles = [];
    this.currentMenu = "main"; // 'main', 'playback-speed', 'quality', or 'subtitles'
  }

  createEl() {
    const el = super.createEl("div", {
      className: "videojs-drm-settings-popup",
    });
    el.style.display = "none";

    return el;
  }

  ready() {
    super.ready();

    // Shaka Tech 判定（Shaka の場合は画質切替ロジックが異なる）
    this.isShakaPlayer =
      this.player().options().useShakaTech &&
      this.player().techName_ === "Shaka";
    // 初回表示用のメニューを組み立て
    this.createMainMenu();

    this.attachEvents();
    this.setupRenditionListener();
    this.setupSubtitleListener();
  }

  // Main popup container
  createMainMenu() {
    const mainMenuOptions = [
      {
        action: "playback-speed",
        icon: _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__.playbackSpeedIcon,
        title: "Playback speed",
        value: this.currentSpeed === 1 ? "Normal" : this.currentSpeed + "x",
      },
      {
        action: "quality",
        icon: _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__.qualityIcon,
        title: "Quality",
        value: this.currentRendition?.label,
      },
      {
        action: "subtitles",
        icon: _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__.subtitleIcon,
        title: "Subtitles",
        value: this.currentSubtitle
          ? this.currentSubtitle.label || this.currentSubtitle.language || "Unknown"
          : "Off",
      },
    ];

    this.mainMenuContent = mainMenuOptions
      .map(
        (option) => `
        <div class="vjsd-main-menu settings-popup-item" data-action="${option.action}">
            ${option.icon}
            <span class="settings-text settings-title">${option.title}</span>
            <span class="settings-value">${option.value}</span>
        </div>
    `
      )
      .join("");
  }

  createPlaybackSpeedMenu() {
    // 再生速度の候補（Video.js の playbackRate にそのまま渡す）
    const speedOptions = [
      { value: 0.5, label: "0.5x", selected: this.currentSpeed === 0.5 },
      { value: 0.75, label: "0.75x", selected: this.currentSpeed === 0.75 },
      { value: 1, label: "Normal", selected: this.currentSpeed === 1 },
      { value: 1.25, label: "1.25x", selected: this.currentSpeed === 1.25 },
      { value: 1.5, label: "1.5x", selected: this.currentSpeed === 1.5 },
      { value: 2, label: "2x", selected: this.currentSpeed === 2 },
    ];

    this.playbackSpeedMenuContent = this.createSubmenu(
      "Playback speed",
      "speed",
      speedOptions,
      ["speed-item"]
    );
  }

  createQualityMenu() {
    // Auto を先頭に（Auto=ABR有効 の意味で扱う）
    const qualityOptions = [];
    if (!this.renditions.some((r) => r.id == AUTO_QUALITY_ID)) {
      qualityOptions.push({
        value: AUTO_QUALITY_ID,
        label: "Auto",
        selected: this.currentRendition?.id == AUTO_QUALITY_ID,
      });
    }

    // 実際に選べる画質一覧（ShakaまたはVHS由来）
    this.renditions.forEach((rendition) => {
      qualityOptions.push({
        value: rendition.id,
        label: rendition.label,
        selected: this.currentRendition?.id == rendition.id,
      });
    });

    this.qualityMenuContent = this.createSubmenu(
      "Quality",
      "quality",
      qualityOptions,
      ["quality-item"]
    );
  }

  createSubtitlesMenu() {
    // 字幕OFF（デフォルト）
    const subtitleOptions = [{
        value: 'off',
        label: 'Off',
        selected: !this.currentSubtitle || this.currentSubtitle.id === 'off',
    }];

    // 利用可能な字幕トラック
    this.subtitles.forEach((subtitle) => {
      subtitleOptions.push({
        value: subtitle.id,
        label: subtitle.label || subtitle.language || "Unknown",
        selected: this.currentSubtitle?.id == subtitle.id,
      });
    });

    this.subtitlesMenuContent = this.createSubmenu(
      "Subtitles",
      "subtitle",
      subtitleOptions,
      ["subtitle-item"]
    );
  }

  createSubmenu(title, action, options, classNames) {
    return `
      ${this.createBackButton(title)}
      ${options
        .map(
          (option) => `
        <div class="settings-popup-item ${classNames.join(" ")} ${
            option.selected ? "selected" : ""
          }" data-${action}="${option.value}">
            <span class="settings-text">${option.label}</span>
            ${option.selected ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__.checkIcon : ""}
        </div>
        `
        )
        .join("")}
    `;
  }

  createBackButton(title) {
    return `
      <div class="settings-popup-item back-button" data-action="back">
        ${_assets_icons_index_js__WEBPACK_IMPORTED_MODULE_3__.chevronLeftIcon}
        <span class="settings-text settings-title">${title}</span>
      </div>
    `;
  }

  attachEvents() {
    // 動的にメニューが差し替わるので event delegation で一箇所に集約
    const handleInteraction = (e) => {
      e.stopPropagation();

      const item = e.target.closest(".settings-popup-item");
      if (!item) return;

      const action = item.dataset.action;
      const speed = item.dataset.speed;
      const quality = item.dataset.quality;
      const subtitle = item.dataset.subtitle;

      if (action === "playback-speed") {
        this.showPlaybackSpeedMenu();
      } else if (action === "quality") {
        this.showQualityMenu();
      } else if (action === "subtitles") {
        this.showSubtitlesMenu();
      } else if (action === "back") {
        this.showMainMenu();
      } else if (speed) {
        this.setPlaybackSpeed(parseFloat(speed));
      } else if (quality) {
        this.setQuality(quality);
      } else if (subtitle) {
        this.setSubtitle(subtitle);
      }
    };

    // モバイル対応：click と touchend の両方を処理
    this.el().addEventListener("click", handleInteraction);
    this.el().addEventListener("touchend", (e) => {
      // Prevent click event from firing after touchend
      e.preventDefault();
      handleInteraction(e);
    });
  }

  toggle() {
    this.isPopupOpen = !this.isPopupOpen;
    if (this.isPopupOpen) {
      this.show();
    } else {
      this.hide();
    }
  }

  show() {
    this.el().style.display = "block";
    this.isPopupOpen = true;
    this.currentMenu = "main";

    this.createMainMenu();
    this.showMainMenu();

    setTimeout(() => {
      this.outsideHandler = (evt) => {
        // ポップアップ外をクリックしたら閉じる
        if (!this.el().contains(evt.target)) {
          this.hide();
        }
      };
      document.addEventListener("click", this.outsideHandler);
    }, 0);
  }

  hide() {
    this.el().style.display = "none";
    this.isPopupOpen = false;
    this.currentMenu = "main";

    if (this.outsideHandler) {
      document.removeEventListener("click", this.outsideHandler);
      this.outsideHandler = null;
    }
  }

  showMainMenu() {
    this.currentMenu = "main";
    this.el().innerHTML = this.mainMenuContent;
  }

  showPlaybackSpeedMenu() {
    this.currentMenu = "playback-speed";
    // Ensure content is up to date
    this.createPlaybackSpeedMenu();
    this.el().innerHTML = this.playbackSpeedMenuContent;
  }

  showQualityMenu() {
    this.currentMenu = "quality";
    // Ensure content is up to date
    this.createQualityMenu();
    this.el().innerHTML = this.qualityMenuContent;
  }

  showSubtitlesMenu() {
    this.currentMenu = "subtitles";
    // Ensure content is up to date
    this.createSubtitlesMenu();
    this.el().innerHTML = this.subtitlesMenuContent;
  }

  setPlaybackSpeed(speed) {
    this.currentSpeed = speed;
    if (this.player) {
      // Video.js API：playbackRate を変更
      this.player().playbackRate(speed);
    }
    // Close popup after selection
    this.hide();
  }

  setQuality(qualityId) {
    try {
      // UIで選んだ id を、renditions 配列から引く
      const rendition = this.renditions.find((r) => r.id == qualityId) || null;
      if (!rendition) return;

      this.currentRendition = rendition;
      if (this.isShakaPlayer && this.qualitySwitchCallback) {
        // Shaka Tech の場合：setup-quality-tracks が渡した callback で Shaka に適用
        this.qualitySwitchCallback(rendition.id, "video");
        return;
      }

      // VHS / qualityLevels 経由の場合：Video.js 側の表現（representation/qualityLevel）を切替
      this.setRendition(rendition);
    } catch (error) {
      console.warn("Could not set quality:", error);
    } finally {
      this.hide();
    }
  }

  setSubtitle(subtitleId) {
    if (subtitleId === "off") {
      this.currentSubtitle = null;
      this.disableSubtitles();
    } else {
      const subtitle = this.subtitles.find((s) => s.id == subtitleId);
      if (subtitle) {
        this.currentSubtitle = subtitle;
        this.enableSubtitle(subtitle);
      }
    }
    // Close popup after selection
    this.hide();
  }

  setupRenditionListener() {
    if (!this.player()) return;

    const tech = this.player().tech();
    if (tech && this.isShakaPlayer) {
      tech.on(
        "loadedqualitydata",
        (event, { qualityData, qualitySwitchCallback }) => {
          // Shaka から画質情報を受け取る（loadedqualitydata は setup-quality-tracks が発火）
          this.qualitySwitchCallback = qualitySwitchCallback;
          this.updateRenditionsFromShaka(qualityData);
        }
      );
    }

    this.player().on("qualitytrackchange", (event, options) => {
      // Video.js 側の quality変更通知（UI表示の追従用）
      this.updateCurrentRendition(options);
    });

    if (!this.isShakaPlayer) {
      // Listen for loadedmetadata to get renditions
      this.player().on("loadedmetadata", () => {
        this.updateRenditions();
      });

      // Listen for source changes
      this.player().on("loadstart", () => {
        this.updateRenditions();
      });

      // Listen for quality changes
      this.player().on("qualitychange", () => {
        this.updateRenditions();
      });
    }
  }

  setupSubtitleListener() {
    if (!this.player) return;
    
    // this.player().tech().on("texttracksloaded", () => {
    //   this.updateSubtitles();
    // });

    // Listen for loadedmetadata to get subtitles
    this.player().on("loadedmetadata", () => {
      // Set timeout to ensure text tracks are loaded (for Safari)
      setTimeout(() => {
        // Video.js textTracks を読み取り、字幕候補を作り直す
        this.updateSubtitles();
      }, 1000);
    });

    // Listen for subtitle changes from CCButton
    this.player().on('subtitlechanged', () => {
      this.updateCurrentSubtitle();
    });

    // Listen for source changes
    // this.player().on("loadstart", () => {
    //   this.updateSubtitles();
    // });

    // Listen for text track changes
    // this.player().on("texttrackchange", () => {
    //   this.updateCurrentSubtitle();
    // });
  }

  updateRenditionsFromShaka(qualityData) {
    try {
      if (qualityData?.video?.length > 0) {
        // Shaka の qualityData（Auto + variants）を UI 用の renditions に変換
        this.renditions = qualityData.video.map((track, index) => ({
          id: track.id,
          bandwidth: track.bandwidth,
          width: track.width,
          height: track.height,
          label: track.label,
          index: index,
          originalTrack: track,
        }));

        // Keep the order from quality data (Auto first, then by height, then by bandwidth)
        this.currentRendition =
          this.renditions.find((r) => r.id == AUTO_QUALITY_ID) || null;
      }
    } catch (error) {
      console.warn("Could not update renditions from quality data:", error);
    }
  }

  updateRenditions() {
    console.log("Updating renditions");
    try {
      // Try using qualityLevels API first
      if (
        this.player().qualityLevels &&
        this.player().qualityLevels()?.length > 0
      ) {
        // qualityLevels が使える場合（主に HLS/VHS）：level.enabled の切替で画質固定ができる
        this.renditions = Array.from(this.player().qualityLevels())
          .map((level, index) => ({
            id: `quality-${index}`,
            label: (0,_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_2__.formatQualityLabel)(level),
            bandwidth: level.bandwidth,
            width: level.width,
            height: level.height,
            index: index,
            qualityLevel: level,
          }))
          .sort(_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_2__.sortQualityTracks);

        console.log(
          "Available renditions from qualityLevels:",
          this.renditions
        );
      } else if (this.player().tech()?.vhs) {
        console.log("Quality levels is not usable, trying VHS...");
        const vhs = this.player().tech().vhs;

        if (vhs.representations && vhs.representations()) {
          // VHS の representations（各解像度/帯域）を UI 用に整形
          const rawReps = vhs.representations();

          this.renditions = rawReps
            .map((rep, index) => ({
              id: `rendition-${index}`,
              label: (0,_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_2__.formatQualityLabel)(rep),
              bandwidth: rep.bandwidth,
              width: rep.width,
              height: rep.height,
              resolution: rep.resolution,
              index: index,
              representation: rep,
            }))
            .sort(_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_2__.sortQualityTracks);

          console.log("Available renditions from VHS:", this.renditions);
        }
      }
    } catch (error) {
      console.warn("Could not get renditions:", error);
    } finally {
      // UIの都合で Auto を必ず先頭に差し込む
      if (!this.renditions.some((r) => r.id == AUTO_QUALITY_ID)) {
        this.renditions.unshift(DEFAULT_QUALITY);
      }
    }
  }

  updateCurrentRendition(options) {
    try {
      if (options && options.id !== undefined) {
        this.currentRendition =
          this.renditions.find((r) => r.id == options.id) || null;
        console.log("Current rendition updated to:", this.currentRendition);
      }
    } catch (error) {
      console.warn("Could not update current rendition:", error);
    }
  }

  setRendition(rendition = null) {
    try {
      // Auto を選んだら “全部有効” にして ABR に委ねる
      const toAutoRendition = rendition.id === AUTO_QUALITY_ID;
      // Try using qualityLevels API first
      if (
        this.player().qualityLevels &&
        this.player().qualityLevels()?.length > 0
      ) {
        // Disable all quality levels first
        Array.from(this.player().qualityLevels()).forEach((level, index) => {
          level.enabled = toAutoRendition;
        });

        // Enable only the selected quality level
        if (rendition.qualityLevel) {
          rendition.qualityLevel.enabled = true;
          console.log(
            "Enabled quality level:",
            rendition.qualityLevel ?? rendition.label
          );
        }
      } else if (this.player().tech()?.vhs && rendition.representation) {
        const vhs = this.player().tech().vhs;
        const reps = vhs.representations();

        reps.forEach((rep) => {
          if (rep === rendition.representation) {
            rep.enabled = true;
          } else {
            rep.enabled = toAutoRendition;
          }
        });
        console.log("Set rendition to:", rendition);

        // Force VHS to update
        if (vhs.trigger) {
          vhs.trigger("renditionchange");
        }
      }
    } catch (error) {
      console.warn("Could not set rendition:", error);
    }
  }

  updateSubtitles() {
    try {
      let textTracks = this.player().textTracks();

      // textTracks の中から字幕/キャプションだけを抽出して UI 用配列にする
      this.subtitles = Array.from(textTracks)
        .filter(
          (track) =>
            track.kind === "captions" ||
            track.kind === "subtitles" ||
            track.kind === "subtitle"
        )
        .map((track, index) => ({
          id: track.id || `subtitle-${index}`,
          language: track.language || "unknown",
          label: track.label || track.language || `Subtitle ${index + 1}`,
          kind: track.kind,
          index: index,
          textTrack: track,
        }));

      console.log("Available subtitles:", this.subtitles);

      // Update current subtitle based on active track
      this.updateCurrentSubtitle();
    } catch (error) {
      console.warn("Could not get subtitles:", error);
    }
  }

  updateCurrentSubtitle() {
    try {
      const textTracks = this.player().textTracks();
      const activeTrack = Array.from(textTracks).find(
        (track) =>
          track.mode === "showing" &&
          (track.kind === "captions" ||
            track.kind === "subtitles" ||
            track.kind === "subtitle")
      );

      if (activeTrack) {
        this.currentSubtitle = this.subtitles.find(
          (subtitle) => subtitle.textTrack === activeTrack
        );
      } else {
        this.currentSubtitle = null;
      }

      console.log("Current subtitle:", this.currentSubtitle);
    } catch (error) {
      console.warn("Could not update current subtitle:", error);
    }
  }

  enableSubtitle(subtitle) {
    try {
      console.log("Enabling subtitle:", subtitle);

      // Disable all text tracks first
      const textTracks = this.player().textTracks();
      Array.from(textTracks).forEach((track) => {
        track.mode = "disabled";
        if (track === subtitle.textTrack) {
          // 目的のトラックだけ showing にする
          track.mode = "showing";
        }
      });

      this.updateCCButtonState();
    } catch (error) {
      console.warn("Could not enable subtitle:", error);
    }
  }

  disableSubtitles() {
    try {
      const textTracks = this.player().textTracks();
      Array.from(textTracks).forEach((track) => {
        if (track.kind === "captions" || track.kind === "subtitles" || track.kind === "subtitle") {
          track.mode = "disabled";
        }
      });

      this.updateCCButtonState();
    } catch (error) {
      console.warn("Could not disable subtitles:", error);
    }
  }
  
  updateCCButtonState() {
    // CCButton と状態を共有するためのイベント（CCButton 側がこれを購読して見た目更新）
    this.player().trigger('subtitlechanged');
  }

  dispose() {
    super.dispose();
    this.el().remove();
  }
}

video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent("SettingsPopup", SettingsPopup);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsPopup);


/***/ }),

/***/ "./src/components/control-bar/components/TimeDisplay.js":
/*!**************************************************************!*\
  !*** ./src/components/control-bar/components/TimeDisplay.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_time_display_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../styles/time-display.css */ "./src/styles/time-display.css");



const Component = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Component');

class TimeDisplay extends Component {
  constructor(player, options) {
    super(player, options);
  }

  createEl() {
    const el = super.createEl('div', {
      className: 'videojs-drm-time-display'
    });
    
    el.innerHTML = `
      <span class="current-time">00:00</span> / <span class="duration">00:00</span>
    `;
    
    return el;
  }

  ready() {
    super.ready();
    this.setupTimeDisplay();
  }

  setupTimeDisplay() {
    const currentTimeSpan = this.el().querySelector('.current-time');
    const durationSpan = this.el().querySelector('.duration');
    
    // Update time display
    const updateTime = () => {
      const currentTime = this.formatTime(this.player().currentTime() || 0);
      const duration = this.formatTime(this.player().duration() || 0);
      
      currentTimeSpan.textContent = currentTime;
      durationSpan.textContent = duration;
    };

    // Listen to player events
    this.player().on('timeupdate', updateTime);
    this.player().on('loadedmetadata', updateTime);
    this.player().on('durationchange', updateTime);
  }

  formatTime(seconds) {
    if (isNaN(seconds) || !isFinite(seconds)) {
      return '00:00';
    }
    
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const secs = Math.floor(seconds % 60);
    
    if (hours > 0) {
      return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
    } else {
      return `${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
    }
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('TimeDisplay', TimeDisplay);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TimeDisplay);





/***/ }),

/***/ "./src/components/control-bar/components/VolumeButton.js":
/*!***************************************************************!*\
  !*** ./src/components/control-bar/components/VolumeButton.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../assets/icons/index.js */ "./src/assets/icons/index.js");
/* harmony import */ var _styles_volume_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../styles/volume-button.css */ "./src/styles/volume-button.css");




const Button = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Button');

class VolumeButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Volume');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-volume-button'
    });
    
    el.innerHTML = _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.volumeHighIcon;
    
    return el;
  }

  handleClick() {
    if (this.player().muted()) {
      this.player().muted(false);
    } else {
      this.player().muted(true);
    }
  }

  updateVolumeIcon(volume, muted) {
    this.el().innerHTML = muted || volume === 0
      ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.volumeMutedIcon
      : volume < 0.5
      ? _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.volumeLowIcon
      : _assets_icons_index_js__WEBPACK_IMPORTED_MODULE_1__.volumeHighIcon;
  }

  ready() {
    super.ready();
    
    // Listen to player volume changes
    this.player().on('volumechange', () => {
      const volume = this.player().volume();
      const muted = this.player().muted();
      this.updateVolumeIcon(volume, muted);
    });

    this.updateVolumeIcon(this.player().volume(), this.player().muted());
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('VolumeButton', VolumeButton);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VolumeButton);





/***/ }),

/***/ "./src/components/control-bar/components/VolumeSlider.js":
/*!***************************************************************!*\
  !*** ./src/components/control-bar/components/VolumeSlider.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_volume_slider_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../styles/volume-slider.css */ "./src/styles/volume-slider.css");



const Component = video_js__WEBPACK_IMPORTED_MODULE_0___default().getComponent('Component');

class VolumeSlider extends Component {
  constructor(player, options) {
    super(player, options);
  }

  createEl() {
    const el = super.createEl('div', {
      className: 'videojs-drm-volume-slider-container'
    });
    
    el.innerHTML = `
      <input 
        type="range" 
        class="videojs-drm-volume-slider" 
        min="0" 
        max="1" 
        step="0.01" 
        value="1"
        aria-label="Volume"
      />
    `;
    
    return el;
  }

  ready() {
    super.ready();
    this.setupVolumeSlider();
  }

  setupVolumeSlider() {
    const slider = this.el().querySelector('.videojs-drm-volume-slider');
    
    // Handle slider input
    slider.addEventListener('input', (e) => {
      const volume = parseFloat(e.target.value);
      this.player().volume(volume);
      this.updateSliderVisual(slider, volume);
    });

    // Listen to player volume changes
    this.player().on('volumechange', () => {
      const volume = this.player().volume();
      slider.value = volume;
      this.updateSliderVisual(slider, volume);
    });

    // Initialize visual state
    this.updateSliderVisual(slider, this.player().volume());
  }

  updateSliderVisual(slider, volume) {
    // Update slider background to show filled portion
    const percentage = volume * 100;
    slider.style.background = `linear-gradient(to right, #ff6b6b 0%, #ff6b6b ${percentage}%, #333 ${percentage}%, #333 100%)`;
  }
}

// Register the component
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerComponent('VolumeSlider', VolumeSlider);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VolumeSlider);





/***/ }),

/***/ "./src/components/control-bar/components/index.js":
/*!********************************************************!*\
  !*** ./src/components/control-bar/components/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CCButton: () => (/* reexport safe */ _CCButton__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   FullscreenButton: () => (/* reexport safe */ _FullscreenButton__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   PlayButton: () => (/* reexport safe */ _PlayButton__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   ProgressBar: () => (/* reexport safe */ _ProgressBar__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   SettingsButton: () => (/* reexport safe */ _SettingsButton__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   TimeDisplay: () => (/* reexport safe */ _TimeDisplay__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   VolumeButton: () => (/* reexport safe */ _VolumeButton__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   VolumeSlider: () => (/* reexport safe */ _VolumeSlider__WEBPACK_IMPORTED_MODULE_2__["default"])
/* harmony export */ });
/* harmony import */ var _PlayButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PlayButton */ "./src/components/control-bar/components/PlayButton.js");
/* harmony import */ var _VolumeButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VolumeButton */ "./src/components/control-bar/components/VolumeButton.js");
/* harmony import */ var _VolumeSlider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./VolumeSlider */ "./src/components/control-bar/components/VolumeSlider.js");
/* harmony import */ var _TimeDisplay__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TimeDisplay */ "./src/components/control-bar/components/TimeDisplay.js");
/* harmony import */ var _CCButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CCButton */ "./src/components/control-bar/components/CCButton.js");
/* harmony import */ var _SettingsButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SettingsButton */ "./src/components/control-bar/components/SettingsButton.js");
/* harmony import */ var _FullscreenButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FullscreenButton */ "./src/components/control-bar/components/FullscreenButton.js");
/* harmony import */ var _ProgressBar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ProgressBar */ "./src/components/control-bar/components/ProgressBar.js");
// Export all control bar components













/***/ }),

/***/ "./src/constants/displayFormat.js":
/*!****************************************!*\
  !*** ./src/constants/displayFormat.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DISPLAY_FORMAT: () => (/* binding */ DISPLAY_FORMAT),
/* harmony export */   DISPLAY_FORMAT_VALUES: () => (/* binding */ DISPLAY_FORMAT_VALUES)
/* harmony export */ });
const DISPLAY_FORMAT = {
  DEFAULT: 1,
  VIDEO_AREA: 2,
  PLAY_PAUSE_ONLY: 3,
  HIDDEN: 4,
};

const DISPLAY_FORMAT_VALUES = Object.values(DISPLAY_FORMAT);

/***/ }),

/***/ "./src/drm-config.js":
/*!***************************!*\
  !*** ./src/drm-config.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DRM_TYPES: () => (/* binding */ DRM_TYPES),
/* harmony export */   setupDRM: () => (/* binding */ setupDRM)
/* harmony export */ });
/**
 * DRM Configuration（videojs-contrib-eme 経由）
 *
 * ここは Video.js の EME プラグイン（`videojs-contrib-eme`）に対して、
 * KeySystems（Widevine / PlayReady / FairPlay）を設定して `player.src({ keySystems })` します。
 *
 * つまり「DRMライセンス取得に必要なURL・ヘッダ」を外部システム側で用意し、
 * `drmConfig` としてこの関数に渡すのが前提です。
 *
 * 注意：
 * - CORS/HTTPS/Content-Type など、ブラウザからライセンスURLへ到達できる必要があります。
 * - FairPlay は Safari 前提のケースが多く、証明書取得（certificateUrl）も必要です。
 */
const DRM_TYPES = {
  WIDEVINE: "com.widevine.alpha",
  FAIRPLAY: "com.apple.fps.1_0",
  PLAYREADY: "com.microsoft.playready",
};

function setupDRM(player, source, drmConfig = {}) {
  // player: video.js Player インスタンス
  // source: { url, type } の想定（type は通常 detectSourceType() が作る）
  // drmConfig: { widevine?, playready?, fairplay? }
  if (!player || !drmConfig) {
    console.warn("DRM setup requires player and drmConfig");
    return;
  }

  const DRMConfig = {};
  // const drmSupport = detectDRMSupport(); TODO: add detectDRMSupport

  // drmConfig から、実際に EME に渡す最小の形へ整形する
  // （URLが未指定の場合は staging のデフォルトへフォールバックしているが、運用では明示指定推奨）
  if (drmConfig.widevine) {
    DRMConfig.widevine = {
      url:
        drmConfig.widevine.url ??
        "https://lic.staging.drmtoday.com/license-proxy-widevine/cenc/?specConform=true",
      licenseHeaders: drmConfig.widevine.licenseHeaders ?? {},
    };
  }

  if (drmConfig.fairplay) {
    DRMConfig.fairplay = {
      certificateUrl: drmConfig.fairplay.certificateUrl ?? "https://lic.staging.drmtoday.com/license-server-fairplay/cert/orca",
      url: drmConfig.fairplay.url ?? "https://lic.staging.drmtoday.com/license-server-fairplay/",
      licenseHeaders: drmConfig.fairplay.licenseHeaders ?? {}
    };
  }

  if (drmConfig.playready) {
    DRMConfig.playready = {
      url:
        drmConfig.playready.url ??
        "https://lic.staging.drmtoday.com/license-proxy-headerauth/drmtoday/RightsManager.asmx",
      licenseHeaders: drmConfig.playready.licenseHeaders ?? {},
    };
  }

  // Setup EME（Encrypted Media Extensions）
  // videojs-contrib-eme が読み込まれていると `player.eme()` が生えます。
  if (player.eme) {
    const keySystems = buildKeySystemsConfig(DRMConfig);

    player.ready(() => {
      // EME プラグイン初期化
      player.eme();
      if (drmConfig.fairplay) {
        // FairPlay（旧API互換）初期化
        player.eme.initLegacyFairplay();
      }

      // keySystems が1つでもあれば DRM として src をセット
      if (Object.keys(keySystems).length > 0) {
        player.src({
          src: source.url,
          keySystems,
        });
      }
    });

    // DRM関連イベント（復号/ライセンス失敗など）のログ・通知
    addDRMEventListeners(player);
  } else {
    console.error("videojs-contrib-eme plugin is required for DRM support");
  }
}

function buildKeySystemsConfig(drmConfig) {
  const keySystems = {};

  // Widevine 設定
  if (drmConfig.widevine && drmConfig.widevine.url && drmConfig.widevine.licenseHeaders) {
    keySystems[DRM_TYPES.WIDEVINE] = {
      // initDataTypes: ['cenc', 'webm'],
      url: drmConfig.widevine.url,
      licenseHeaders: drmConfig.widevine.licenseHeaders ?? {},
      // audioContentType: 'audio/mp4; codecs="mp4a.40.2"',
      // videoContentType: 'video/mp4; codecs="avc1.640028"',
      // audioRobustness: "SW_SECURE_CRYPTO",
      // videoRobustness: "SW_SECURE_CRYPTO",
    };
  }

  // FairPlay 設定（証明書取得→ライセンス取得、などを EME プラグインへ委譲）
  if (
    drmConfig.fairplay &&
    drmConfig.fairplay.certificateUrl &&
    drmConfig.fairplay.url &&
    drmConfig.fairplay.licenseHeaders
  ) {
    keySystems[DRM_TYPES.FAIRPLAY] = {
      getContentId: (emeOptions, initData) => initData,
      getCertificate: function (emeOptions, callback) {
        videojs.xhr(
          {
            url: drmConfig.fairplay.certificateUrl,
            method: "GET",
            responseType: "arraybuffer",
          },
          (err, response, responseBody) => {
            callback(null, new Uint8Array(responseBody));
          }
        );
      },
      getLicense: function (emeOptions, contentId, keyMessage, callback) {
        videojs.xhr(
          {
            url: drmConfig.fairplay.url,
            method: "POST",
            responseType: "text",
            body: keyMessage,
            headers: {
              ...(drmConfig.fairplay.licenseHeaders ?? {}),
            },
          },
          (err, response, responseBody) => {
            let rawLicenseString = atob(responseBody);
            let data = new Uint8Array(rawLicenseString.length);
            for (let i = 0; i < rawLicenseString.length; ++i) {
              data[i] = rawLicenseString.charCodeAt(i);
            }
            let key = data.buffer;
            callback(null, key);
          }
        );
      },
    };
  }

  // PlayReady 設定
  if (drmConfig.playready && drmConfig.playready.url) {
    keySystems[DRM_TYPES.PLAYREADY] = {
      url: drmConfig.playready.url,
      licenseHeaders: drmConfig.playready.licenseHeaders || {},
    };
  }

  return keySystems;
}

function addDRMEventListeners(player) {
  player.on("eme-error", (event) => {
    console.error("EME Error:", event);
    // videoId を Player の id から推定して渡す（外部連携用の CustomEvent 名に使用）
    handleDRMError(event, player, typeof player.id === "function" ? player.id() : undefined);
  });

  player.on("eme-keystatuschange", (event) => {
    console.log("Key Status Change:", event);
  });

  player.on("eme-keysessioncreated", (event) => {
    console.log("Key Session Created:", event);
  });
}

function handleDRMError(error, player, videoId) {
  console.error("DRM Error Details:", error);

  // Emit custom DRM error event
  const customEvent = new CustomEvent(
    `${videoId ?? "videojs-drm-player"}-videojs-drm-player:drm-error`,
    {
      detail: {
        error: error,
        player: player,
      },
    }
  );
  document.dispatchEvent(customEvent);

  // Display user-friendly error message
  if (player.error) {
    player.error({
      code: "DRM_ERROR",
      message:
        "Cannot play DRM-protected video. Please check your DRM configuration.",
    });
  }
}

// TODO: VideoJS - DRM detection problem -Helper function to detect DRM support 
// export function detectDRMSupport() {
//   const support = {
//     widevine: false,
//     fairplay: false,
//     playready: false,
//   };

//   if (window.navigator && window.navigator.requestMediaKeySystemAccess) {
//     // Check Widevine support
//     navigator
//       .requestMediaKeySystemAccess(DRM_TYPES.WIDEVINE, [
//         {
//           initDataTypes: ["cenc"],
//           videoCapabilities: [
//             {
//               contentType: 'video/mp4; codecs="avc1.42E01E"',
//             },
//           ],
//         },
//       ])
//       .then(() => {
//         support.widevine = true;
//       })
//       .catch(() => {
//         support.widevine = false;
//       });

//     // Check FairPlay support (Safari only)
//     if (window.WebKitMediaKeys) {
//       support.fairplay = true;
//     }

//     // Check PlayReady support
//     navigator
//       .requestMediaKeySystemAccess(DRM_TYPES.PLAYREADY, [
//         {
//           initDataTypes: ["cenc"],
//           videoCapabilities: [
//             {
//               contentType: 'video/mp4; codecs="avc1.42E01E"',
//             },
//           ],
//         },
//       ])
//       .then(() => {
//         support.playready = true;
//       })
//       .catch(() => {
//         support.playready = false;
//       });
//   }

//   return support;
// }


/***/ }),

/***/ "./src/helpers/helper.js":
/*!*******************************!*\
  !*** ./src/helpers/helper.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   detectSourceType: () => (/* binding */ detectSourceType),
/* harmony export */   isAudioMime: () => (/* binding */ isAudioMime)
/* harmony export */ });
function detectSourceType(source) {
  const extension = source.split(".").pop().toLowerCase();
  const typeMap = {
    mp4: "video/mp4",
    webm: "video/webm",
    ogv: "video/ogg",
    // Audio types
    mp3: "audio/mpeg",
    m4a: "audio/mp4",
    aac: "audio/aac",
    wav: "audio/wav",
    oga: "audio/ogg",
    ogg: "audio/ogg",
    // Encrypted Media Extensions
    m3u8: "application/x-mpegURL",
    mpd: "application/dash+xml",
  };

  return typeMap[extension] || "video/mp4";
}

function isAudioMime(type) {
  return typeof type === "string" && type.startsWith("audio/");
}


/***/ }),

/***/ "./src/helpers/renditionHelper.js":
/*!****************************************!*\
  !*** ./src/helpers/renditionHelper.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatQualityLabel: () => (/* binding */ formatQualityLabel),
/* harmony export */   sortQualityTracks: () => (/* binding */ sortQualityTracks)
/* harmony export */ });
const formatQualityLabel = (level) => {
  let label;

  // Create label based on height
  if (level.height >= 2160) {
    label = level.height + "p (4K)";
  } else if (level.height >= 1440) {
    label = level.height + "p (2K)";
  } else if (level.height >= 720) {
    label = level.height + "p (HD)";
  } else if (level.height) {
    label = level.height + "p";
  } else {
    return undefined;
  }

  if (level.bandwidth) {
    const mbps = (level.bandwidth / 1000000).toFixed(2);
    label += ` (${mbps} Mbps)`;
  }

  return label;
};

const sortQualityTracks = (track1, track2) => {
  // Keep Auto option first
  if (track1.id === -1) return -1;
  if (track2.id === -1) return 1;

  // Sort by height (highest first)
  const height1 = track1.height || 0;
  const height2 = track2.height || 0;

  if (height1 === height2) {
    return (track2.bandwidth || 0) - (track1.bandwidth || 0);
  }

  return height2 - height1;
};




/***/ }),

/***/ "./src/shaka/setup-audio-tracks.js":
/*!*****************************************!*\
  !*** ./src/shaka/setup-audio-tracks.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ setupAudioTracks)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);


// TODO: Modify this later if needed
/**
 * Setup audio tracks. Take the tracks from dash and add the tracks to videojs. Listen for when
 * videojs changes tracks and apply that to the dash player because videojs doesn't do this
 * natively.
 *
 * @private
 * @param {videojs} tech the videojs player tech instance
 * @param {videojs.tech} tech the videojs tech being used
 */
function handleAudioTracksAdded(tech, shakaPlayer, tracks) {
  /**
   * Shaka の “音声言語トラック” を Video.js の `audioTracks()` に同期します。
   *
   * なぜ必要？
   * - Shaka は音声言語/Role の概念を持つが、Video.js の標準UIだけでは Shaka の音声切替を自動反映しません。
   * - そこで Video.js 側に AudioTrack を作り、Video.js 側の選択変更を Shaka に反映します。
   *
   * ここで作る `videojs.AudioTrack` は UI/イベント連携のための “表示用ラッパー” です。
   */

  const videojsAudioTracks = tech.audioTracks();

  function generateIdFromTrackIndex(index) {
    return `dash-audio-${index}`;
  }

  function generateLabelFromTrack(track) {
    // label は UI に出る文字列（例: "en (main)" のように role を括弧付け）
    let label = track.language;

    if (track.role) {
      label += ` (${track.role})`;
    }

    return label;
  }

  function findDashAudioTrack(subDashAudioTracks, videojsAudioTrack) {
    return subDashAudioTracks.find((track) =>
      generateLabelFromTrack(track) === videojsAudioTrack.label
    );
  }

  // Safari creates a single native `AudioTrack` (not `videojs.AudioTrack`) when loading. Clear all
  // automatically generated audio tracks so we can create them all ourself.
  if (videojsAudioTracks.length) {
    // Safari 対策：自動生成されたトラックを消して、こちらで全て作り直す
    tech.clearTracks(['audio']);
  }

  const currentAudioTrack = tracks[0];

  tracks.forEach((dashTrack, index) => {
    const label = generateLabelFromTrack(dashTrack);

    if (dashTrack === currentAudioTrack) {
      // 外部/UI 連携用のイベント（必要なら Settings UI で表示更新に使える）
      tech.trigger('shakaaudiotrackchange', {
        language: dashTrack.language
      });
    }

    // Add the track to the player's audio track list.
    videojsAudioTracks.addTrack(
      new (video_js__WEBPACK_IMPORTED_MODULE_0___default().AudioTrack)({
        enabled: dashTrack === currentAudioTrack,
        id: generateIdFromTrackIndex(index),
        kind: 'main',
        label,
        language: dashTrack.language
      })
    );
  });

  const audioTracksChangeHandler = () => {
    // Video.js 側で有効化された AudioTrack を検出し、Shaka 側の音声言語へ反映する
    for (let i = 0; i < videojsAudioTracks.length; i++) {
      const track = videojsAudioTracks[i];

      if (track.enabled) {
        // Find the audio track we just selected by the id
        const dashAudioTrack = findDashAudioTrack(tracks, track);

        if (dashAudioTrack) {
          // Set is as the current track
          tech.trigger('shakaaudiotrackchange', {
            language: dashAudioTrack.language
          });
          // Shaka に音声言語（+ role）を適用
          shakaPlayer.selectAudioLanguage(dashAudioTrack.language, dashAudioTrack.role);

          // Stop looping
          continue;
        }

      }
    }
  };

  // Video.js の audioTracks change を購読し、Shaka へ同期
  videojsAudioTracks.addEventListener('change', audioTracksChangeHandler);
  shakaPlayer.addEventListener('unloading', () => {
    // ソース切替/破棄時にイベントを外す
    videojsAudioTracks.removeEventListener('change', audioTracksChangeHandler);
  });
}

function setupAudioTracks(tech, shakaPlayer) {
  // Shaka が持つ「音声言語 + role」の一覧を取り、Video.js の AudioTrack に反映
  handleAudioTracksAdded(tech, shakaPlayer, shakaPlayer.getAudioLanguagesAndRoles());
}


/***/ }),

/***/ "./src/shaka/setup-quality-tracks.js":
/*!*******************************************!*\
  !*** ./src/shaka/setup-quality-tracks.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ setupQualityTracks)
/* harmony export */ });
/* harmony import */ var _helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/renditionHelper */ "./src/helpers/renditionHelper.js");


const AUTO_QUALITY_LEVEL = {
  id: -1,
  label: 'Auto',
  height: null,
  width: null,
  bandwidth: null
};

function _getQuality(tech, shakaPlayer) { 
  /**
   * Shaka の VariantTracks（解像度/ビットレート違い）を取得して、
   * SettingsPopup 側で表示しやすい形式に整形します。
   *
   * - 先頭に “Auto” を入れておき、id=-1 を「ABR有効」の合図にしています。
   * - Shaka 側の track.id がある場合はそれを使い、無い場合は配列インデックスで代用します。
   */
  const tracks = [AUTO_QUALITY_LEVEL];

  const levels = shakaPlayer.getVariantTracks();
  console.log('Raw variant tracks:', levels);

  levels.forEach(function(level, index) {
    tracks.push({
      id: level.id ?? index,
      label: (0,_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_0__.formatQualityLabel)(level) || `Quality ${index + 1}`,
      height: level.height,
      width: level.width,
      bandwidth: level.bandwidth,
    });
  });

  // UI表示用にソート（Auto を先頭、残りは基本的に高解像度→低解像度の順）
  return tracks.sort(_helpers_renditionHelper__WEBPACK_IMPORTED_MODULE_0__.sortQualityTracks);
}

function setupQualityTracks(tech, shakaPlayer) {  
  /**
   * Video.js Tech 側へ `loadedqualitydata` を投げて、設定UI（SettingsPopup）へ画質候補を渡します。
   * また、UIから選ばれた id を受け取り Shaka に反映するコールバックも一緒に渡します。
   *
   * 実体としては:
   * - Auto: `abr.enabled = true`
   * - 固定: `selectVariantTrack(..., clearBuffer=true)` で明示選択 + ABR無効
   */
  const qualityData = _getQuality(tech, shakaPlayer);
  console.log('Quality tracks found:', qualityData);

  tech.trigger('loadedqualitydata', {
    qualityData: {
      video: qualityData
    },
    qualitySwitchCallback: function(id, type) {
      console.log('Quality switch callback called with id:', id, type);
      if (type !== 'video') return;

      // Auto のときは ABR（自動適応）を有効化、固定画質のときは無効化
      shakaPlayer.configure({
        abr: {
          enabled: id === AUTO_QUALITY_LEVEL.id
        }
      });

      // Auto の場合は ABR に任せるのでここで終了
      if (id === AUTO_QUALITY_LEVEL.id) return;

      // Shaka の track.id と一致する VariantTrack を探して選択
      const tracks = shakaPlayer.getVariantTracks().filter(t => Number(t.id) === Number(id));
      console.log('Selected variant track:', tracks[0]);

      if (tracks.length > 0) {
        shakaPlayer.selectVariantTrack(tracks[0], /* clearBuffer */ true);
        
        // Video.js 側にも「画質が変わった」ことを通知（UI側の表示更新などに使える）
        tech.player().trigger('qualitychange', {
          quality: tracks[0]
        });
      }

      // fire `variantchanged` event - only supports debug mode right now
      // todo - need to figure out how to do this in non debug mode
      // if (shaka.util.FakeEvent) {
      //   const event = new shaka.util.FakeEvent('variantchanged');
      //   shakaPlayer.dispatchEvent(event);
      // }
    }
  });
}

/***/ }),

/***/ "./src/shaka/setup-text-tracks.js":
/*!****************************************!*\
  !*** ./src/shaka/setup-text-tracks.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ setupTextTracks)
/* harmony export */ });
const find = (l, f) => {
  for (let i = 0; i < l.length; i++) {
    if (f(l[i])) {
      return l[i];
    }
  }
};

const attachDashTextTracksToVideojs = (tech, shakaPlayer, tracks) => {
  /**
   * Shaka が持つテキストトラック（字幕/キャプション）を Video.js の `textTracks()` に同期します。
   *
   * ポイント：
   * - Cue（字幕の中身）は Video.js 側に流し込まず、Shaka がネイティブに描画/制御する前提です。
   * - Video.js 側では “どのトラックが選ばれているか” の UI/状態管理だけ行い、
   *   選択状態の変更を Shaka に反映します。
   */
  const trackDictionary = [];

  // Add remote tracks
  const tracksAttached = tracks
    // Map input data to match HTMLTrackElement spec
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLTrackElement
    .map((track) => ({
      dashTrack: track,
      trackConfig: {
        id: track.id,
        label: track.label || track.language,
        language: track.language,
        srclang: track.language,
        kind: track.kind,
      },
    }))

    // Add track to videojs track list
    .map(({ dashTrack, trackConfig }) => {
      const remoteTextTrack = tech.addRemoteTextTrack(trackConfig, false);

      trackDictionary.push({ textTrack: remoteTextTrack.track, dashTrack });

      // Don't add the cues becuase we're going to let dash handle it natively. This will ensure
      // that dash handle external time text files and fragmented text tracks.
      //
      // Example file with external time text files:
      // https://storage.googleapis.com/shaka-demo-assets/sintel-mp4-wvtt/dash.mpd

      return remoteTextTrack;
    });

  /*
   * Scan `videojs.textTracks()` to find one that is showing. Set the dash text track.
   */
  const updateActiveDashTextTrack = () => {
    // Video.js 側の “showing” を見て、Shaka 側の selectTextTrack / visibility を切り替える
    let dashTrackToActivate;
    const textTracks = tech.textTracks();

    // Iterate through the tracks and find the one marked as showing. If none are showing,
    // disable text tracks.
    for (let i = 0; i < textTracks.length; i += 1) {
      const textTrack = textTracks[i];

      if (textTrack.mode === "showing") {
        // Find the dash track we want to use
        /* jshint loopfunc: true */
        const dictionaryLookupResult = find(
          trackDictionary,
          (track) => track.textTrack === textTrack
        );
        /* jshint loopfunc: false */

        dashTrackToActivate = dictionaryLookupResult
          ? dictionaryLookupResult.dashTrack
          : null;
      }
    }

    // If the text track has changed, then set it in shaka
    if (dashTrackToActivate) {
      shakaPlayer.selectTextTrack(dashTrackToActivate);
      shakaPlayer.setTextTrackVisibility(true);
    } else {
      // “字幕OFF” 相当
      shakaPlayer.setTextTrackVisibility(false);
    }
  };

  // Update dash when videojs's selected text track changes.
  tech.textTracks().on("change", updateActiveDashTextTrack);

  // Cleanup event listeners whenever we start loading a new source
  shakaPlayer.addEventListener("unloading", () => {
    tech.textTracks().off("change", updateActiveDashTextTrack);
  });

  // Initialize the text track on our first run-through
  updateActiveDashTextTrack();

  return tracksAttached;
};

function setupTextTracks(tech, shakaPlayer) {
  // Store the tracks that we've added so we can remove them later.
  let dashTracksAttachedToVideoJs = [];
  const tracks = shakaPlayer.getTextTracks();

  // Cleanup old tracks
  dashTracksAttachedToVideoJs.forEach(tech.removeRemoteTextTrack.bind(tech));
  dashTracksAttachedToVideoJs = [];

  // Don't try to add text tracks if there aren't any or if the app is sideloading webvtt files
  if (!tracks.length || tech.options_.sideload) {
    // トラックが無い、または外部VTTを別方式で入れている場合は Shaka の字幕表示をOFFにして終了
    shakaPlayer.setTextTrackVisibility(false);
    console.log("No text tracks to add or sideloading enabled");
    return;
  }

  // Save the tracks so we can remove them later
  dashTracksAttachedToVideoJs = attachDashTextTracksToVideojs(
    tech,
    shakaPlayer,
    tracks
  );

  // Set default subtitle state to disabled for Shaka
  // デフォルトは字幕OFF（ユーザーがUIでONにする想定）
  shakaPlayer.setTextTrackVisibility(false);

  // Trigger text tracks loaded event
  // （必要なら Settings UI 側でトラック一覧を更新するのに使える）
  tech.trigger("texttracksloaded", {
    tracks: tracks,
  });
}


/***/ }),

/***/ "./src/shaka/shaka-drm-config.js":
/*!***************************************!*\
  !*** ./src/shaka/shaka-drm-config.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   setupAdaptiveStreaming: () => (/* binding */ setupAdaptiveStreaming),
/* harmony export */   setupBitrateManagement: () => (/* binding */ setupBitrateManagement),
/* harmony export */   setupShakaDRM: () => (/* binding */ setupShakaDRM),
/* harmony export */   setupTextTracks: () => (/* binding */ setupTextTracks)
/* harmony export */ });
/* harmony import */ var shaka_player__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! shaka-player */ "shaka-player");
/* harmony import */ var shaka_player__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(shaka_player__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Shaka Player DRM Configuration
 */


async function setupShakaDRM(shakaPlayer, drmConfig = {}) {
  /**
   * Shaka Tech（Shaka Player）側の DRM 設定です。
   *
   * - Video.js + `videojs-contrib-eme` を使う場合は `src/drm-config.js` を通ります。
   * - `useShakaTech: true` の場合はこちらが使われ、Shaka の `drm.servers` を構成します。
   *
   * drmConfig は以下のような形を想定します：
   * {
   *   widevine: { url, licenseHeaders },
   *   playready: { url, licenseHeaders },
   *   fairplay: { certificateUrl, url, licenseHeaders }
   * }
   *
   * 注意：
   * - ライセンスリクエストのヘッダは、外部システム側で払い出したトークン等を注入してください。
   * - CORS/HTTPS/Content-Type は必須です（ブラウザがライセンスURLへ到達できること）。
   */
  if (!shakaPlayer || !drmConfig) {
    return;
  }

  const config = {
    drm: {
      servers: {},
      // retryParameters: {
      //   maxAttempts: 3,
      //   baseDelay: 1000,
      //   backoffFactor: 2,
      //   fuzzFactor: 0.1,
      //   timeout: 30000,
      // },
    },
    // streaming: {
    //   bufferBehind: 30,
    //   bufferingGoal: 10,
    //   rebufferingGoal: 2,
    //   bufferingGoalDefault: 10,
    //   rebufferingGoalDefault: 2,
    //   bufferBehindDefault: 30,
    // },
    // abr: {
    //   enabled: true,
    //   defaultBandwidthEstimate: 1000000,
    //   useNetworkInformation: true,
    // },
  };

  // ===== Widevine（Chrome/Android など）=====
  if (
    drmConfig.widevine &&
    drmConfig.widevine.url &&
    drmConfig.widevine.licenseHeaders
  ) {
    config.drm.servers["com.widevine.alpha"] = drmConfig.widevine.url;

    // if (drmConfig.widevine.audioContentType) {
    //   config.drm["com.widevine.alpha"] = {
    //     audioContentType: drmConfig.widevine.audioContentType,
    //     videoContentType: drmConfig.widevine_0.videoContentType,
    //   };
    // }
  }

  let req, cert;

  // ===== FairPlay（主に Safari）=====
  // FairPlay は serverCertificate が必要なケースが多く、certificateUrl から取得してセットします。
  const requestFairplay = Boolean(
    drmConfig.fairplay &&
      drmConfig.fairplay.certificateUrl &&
      drmConfig.fairplay.url &&
      drmConfig.fairplay.licenseHeaders
  );

  if (requestFairplay) {
    req = await fetch(
      drmConfig.fairplay.certificateUrl ??
        "https://lic.staging.drmtoday.com/license-server-fairplay/cert/orca"
    );
    cert = await req.arrayBuffer();

    config.drm.servers["com.apple.fps"] = drmConfig.fairplay.url;
    config.drm.advanced = {
      "com.apple.fps": {
        serverCertificate: new Uint8Array(cert),
      },
    };
  }

  // ===== PlayReady（主に Edge/Windows など）=====
  if (
    drmConfig.playready &&
    drmConfig.playready.url &&
    drmConfig.playready.licenseHeaders
  ) {
    config.drm.servers["com.microsoft.playready"] = config.drm.servers[
      "com.microsoft.playready"
    ] = drmConfig.playready.url;
  }

  // Apply configuration
  shakaPlayer.configure(config);

  shakaPlayer
    .getNetworkingEngine()
    .registerRequestFilter(function (type, request) {
      if (type == (shaka_player__WEBPACK_IMPORTED_MODULE_0___default().net).NetworkingEngine.RequestType.LICENSE) {
        /**
         * ライセンスリクエストにヘッダを注入します。
         * - 今は `x-dt-custom-data` だけを代表例として入れています。
         * - 必要なら `licenseHeaders` に入れたものをここで “全部” 展開する運用にしてください。
         *
         * 例）request.headers["x-dt-auth-token"] = "...";
         */
        const headers =
          drmConfig?.widevine?.licenseHeaders ??
          drmConfig?.fairplay?.licenseHeaders ??
          drmConfig?.playready?.licenseHeaders ??
          {};

        // 代表例（DRMtoday 系でよく使う）
        if (headers["x-dt-custom-data"]) {
          request.headers["x-dt-custom-data"] = headers["x-dt-custom-data"];
        }
      }
    });

  if (requestFairplay) {
    shakaPlayer
      .getNetworkingEngine()
      .registerResponseFilter((type, response) => {
        if (type === (shaka_player__WEBPACK_IMPORTED_MODULE_0___default().net).NetworkingEngine.RequestType.LICENSE) {
          if (shakaPlayer.keySystem() === "com.apple.fps") {
            // FairPlay ライセンス応答は base64 文字列で返ることがあり、binary に戻す必要がある
            let responseText = shaka_player__WEBPACK_IMPORTED_MODULE_0___default().util.StringUtils.fromUTF8(response.data);
            response.data =
              shaka_player__WEBPACK_IMPORTED_MODULE_0___default().util.Uint8ArrayUtils.fromBase64(responseText).buffer;
          }
        }
      });
  }

  // Event listener for errors
  shakaPlayer.addEventListener("error", (event) => {
    const error = event.detail;
    console.error("Shaka DRM Error:", error);

    // if (drmConfig.onError) {
    //   drmConfig.onError(error);
    // }
  });

  console.log("Shaka DRM configured successfully");
}

/**
 * Adaptive streaming
 */
function setupAdaptiveStreaming(shakaPlayer, streamingConfig = {}) {
  const config = {
    streaming: {
      bufferBehind: 30,
      bufferingGoal: 10,
      rebufferingGoal: 2,
      ...streamingConfig,
    },
    abr: {
      enabled: true,
      defaultBandwidthEstimate: 1000000,
      useNetworkInformation: true,
      ...streamingConfig.abr,
    },
    manifest: {
      dash: {
        clockSyncUri: "",
        ignoreDrmInfo: false,
        ...streamingConfig.dash,
      },
      hls: {
        ...streamingConfig.hls,
      },
    },
  };

  shakaPlayer.configure(config);
}

/**
 * Bitrate management
 */
function setupBitrateManagement(shakaPlayer, bitrateConfig = {}) {
  const config = {
    abr: {
      enabled: bitrateConfig.enabled !== false,
      defaultBandwidthEstimate: bitrateConfig.defaultBandwidth || 1000000,
      useNetworkInformation: bitrateConfig.useNetworkInfo !== false,
      restrictions: {
        minWidth: bitrateConfig.minWidth,
        maxWidth: bitrateConfig.maxWidth,
        minPixels: bitrateConfig.minPixels,
        maxPixels: bitrateConfig.maxPixels,
        minFrameRate: bitrateConfig.minFrameRate,
        maxFrameRate: bitrateConfig.maxFrameRate,
        minBandwidth: bitrateConfig.minBandwidth,
        maxBandwidth: bitrateConfig.maxBandwidth,
      },
    },
  };

  shakaPlayer.configure(config);
}

/**
 * Caption/subtitle
 */
function setupTextTracks(shakaPlayer, textConfig = {}) {
  if (textConfig.preferredLanguages) {
    shakaPlayer.configure({
      preferredAudioLanguage: textConfig.preferredLanguages.audio || "en",
      preferredTextLanguage: textConfig.preferredLanguages.text || "en",
    });
  }

  if (textConfig.tryStartWithClosedCaptions) {
    shakaPlayer.configure({
      textTrackRestrictions: {
        onlyForcedSubtitles: false,
      },
    });
  }
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  setupShakaDRM,
  setupAdaptiveStreaming,
  setupBitrateManagement,
  setupTextTracks,
});


/***/ }),

/***/ "./src/shaka/shaka.js":
/*!****************************!*\
  !*** ./src/shaka/shaka.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var shaka_player__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! shaka-player */ "shaka-player");
/* harmony import */ var shaka_player__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(shaka_player__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _shaka_drm_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shaka-drm-config */ "./src/shaka/shaka-drm-config.js");
/* harmony import */ var _setup_quality_tracks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./setup-quality-tracks */ "./src/shaka/setup-quality-tracks.js");
/* harmony import */ var _setup_text_tracks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./setup-text-tracks */ "./src/shaka/setup-text-tracks.js");
/* harmony import */ var _setup_audio_tracks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./setup-audio-tracks */ "./src/shaka/setup-audio-tracks.js");







const Html5 = video_js__WEBPACK_IMPORTED_MODULE_0___default().getTech("Html5");

// Expose Shaka library globally (only once)
if (typeof window !== "undefined" && !window.__shaka) {
  window.__shaka = (shaka_player__WEBPACK_IMPORTED_MODULE_1___default());
  console.log("[Shaka] Exposed Shaka library to window.__shaka");
  // 3.1 Log Shaka version (shared across all instances)
  console.log("[Shaka] Version:", (shaka_player__WEBPACK_IMPORTED_MODULE_1___default().Player).version);
}

class Shaka extends Html5 {
  constructor(options, ready) {
    super(options, ready);

    this.vjsPlayer = video_js__WEBPACK_IMPORTED_MODULE_0___default()(options.playerId);
    this.shaka_ = null;
    this._shakaListenersInstalled = false;
    this._shakaNetworkingInstalled = false;
    this._lastRequestByType = {};

    this.player_.ready(() => {
      this.player_.addClass("vjs-shaka");
    });
  }

  static isSupported() {
    return !!window.MediaSource && shaka_player__WEBPACK_IMPORTED_MODULE_1___default().Player.isBrowserSupported();
  }

  static canPlaySource(sourceObj, type) {
    const dashTypeRE = /^(application\/dash\+xml|application\/x-mpegURL)/i;

    if (dashTypeRE.test(sourceObj.type)) {
      return "probably";
    }

    return "";
  }

  createEl() {
    this.el_ = Html5.prototype.createEl.apply(this, arguments);

    // Install built-in polyfills to patch browser incompatibilities.
    shaka_player__WEBPACK_IMPORTED_MODULE_1___default().polyfill.installAll();

    // Set debug log level
    if ((shaka_player__WEBPACK_IMPORTED_MODULE_1___default().log)) {
      // tech-specific options は video.js の慣習に合わせて `options_.shaka` を優先
      const debug = !!(this.options_?.shaka?.debug ?? this.options_?.debug);
      if (debug) {
        shaka_player__WEBPACK_IMPORTED_MODULE_1___default().log.setLevel((shaka_player__WEBPACK_IMPORTED_MODULE_1___default().log).Level.DEBUG);
      } else {
        shaka_player__WEBPACK_IMPORTED_MODULE_1___default().log.setLevel((shaka_player__WEBPACK_IMPORTED_MODULE_1___default().log).Level.ERROR);
      }
    }

    this.el_.tech = this;

    return this.el_;
  }

  // Helper method to get container tag for logging
  getContainerTag() {
    return this.containerId_ ? `[${this.containerId_}]` : "";
  }

  async initializeShaka() {
    const containerTag = this.getContainerTag();
    
    if (!this.shaka_ && this.el_) {
      console.log(`${containerTag} [Shaka] Initializing Shaka Player...`);
      this.shaka_ = new (shaka_player__WEBPACK_IMPORTED_MODULE_1___default().Player)();
      await this.shaka_.attach(this.el_);

      // イベント/ネットワークフックは “1回だけ” 登録する（setSrc のたびに増殖させない）
      this.installShakaEventHandlers_();
      this.installShakaNetworkingHooks_();
      
      // Expose Shaka player instance if containerId is available
      if (this.containerId_) {
        this.exposeShakaInstances();
      }
      // this.shaka_.configure({
      //   streaming: {
      //     useNativeHlsForFairPlay: false,
      //     preferNativeHls: false,
      //   },
      // });

      // 3.2 Log ABR config + restrictions after configuration
      console.log(`${containerTag} [Shaka] Effective config abr:`, this.shaka_.getConfiguration().abr);
      console.log(`${containerTag} [Shaka] Effective config restrictions:`, this.shaka_.getConfiguration().restrictions);
      
      console.log(`${containerTag} [Shaka] Player initialized`);
    } else if (!this.el_) {
      console.log(`${containerTag} [Shaka] Element not created, cannot initialize Shaka Player`);
    }
  }

  /**
   * Shaka Player のイベントを 1 度だけ登録する
   * （reload/再初期化で setSrc が複数回呼ばれても重複させない）
   */
  installShakaEventHandlers_() {
    if (!this.shaka_ || this._shakaListenersInstalled) return;
    this._shakaListenersInstalled = true;

    const me = this;

    this.shaka_.addEventListener("buffering", function (event) {
      if (event.buffering) {
        me.vjsPlayer.trigger("waiting");
      } else {
        me.vjsPlayer.trigger("playing");
      }
    });

    // Error logging
    this.shaka_.addEventListener("error", function (event) {
      const containerTag = me.getContainerTag();
      console.error(`${containerTag} [Shaka] Player error event:`, event.detail);
      me.retriggerError(event.detail);
    });

    // Adaptation event logging
    this.shaka_.addEventListener("adaptation", function () {
      const containerTag = me.getContainerTag();
      console.log(`${containerTag} [Shaka] adaptation event fired`);
      me.logVariants(me.shaka_, "(after adaptation)");
    });
  }

  /**
   * Shaka の NetworkingEngine フックを 1 度だけ登録する
   * - 直近のリクエストURIを記録（エラー解析用）
   * - HLS manifest（m3u8）のみを対象に必要な置換を実施（MPD等に誤爆させない）
   */
  installShakaNetworkingHooks_() {
    if (!this.shaka_ || this._shakaNetworkingInstalled) return;
    this._shakaNetworkingInstalled = true;

    const containerTag = this.getContainerTag();
    const net = this.shaka_.getNetworkingEngine();
    if (!net) return;

    // 直近のリクエスト先を覚えておく（Shaka error の data が不十分なケースの補助）
    net.registerRequestFilter((type, request) => {
      try {
        const uri =
          (request && Array.isArray(request.uris) && request.uris[0]) ||
          request?.uri ||
          "";
        if (uri) this._lastRequestByType[String(type)] = uri;
      } catch (_) {}
    });

    // HLS manifest のみを安全に書き換える（m3u8 以外はスキップ）
    net.registerResponseFilter((type, response) => {
      try {
        if (type !== (shaka_player__WEBPACK_IMPORTED_MODULE_1___default().net).NetworkingEngine.RequestType.MANIFEST) return;
        if (!response || !response.data) return;

        const decoder = new TextDecoder("utf-8");
        const text = decoder.decode(response.data);

        // m3u8 以外（例: MPD/XML）に誤って置換を当てない
        if (!text || !text.startsWith("#EXTM3U")) return;

        let manifestText = text;
        manifestText = manifestText.replace(
          /GROUP-ID="audio-aacl-\d+"/g,
          'GROUP-ID="audio-main"'
        );
        manifestText = manifestText.replace(
          /AUDIO="audio-aacl-\d+"/g,
          'AUDIO="audio-main"'
        );

        if (manifestText !== text) {
          const encoder = new TextEncoder();
          response.data = encoder.encode(manifestText);
          console.log(`${containerTag} [Shaka] Patched HLS manifest (GROUP-ID/AUDIO)`);
        }
      } catch (e) {
        console.warn(`${containerTag} [Shaka] ResponseFilter failed:`, e);
      }
    });
  }

  // Shaka の error.detail から、できるだけ “人間が分かる” 形で情報を抽出する
  extractNetworkDetails_(err) {
    let status = null;
    let uri = null;

    try {
      const data = err?.data;
      if (Array.isArray(data)) {
        for (const item of data) {
          if (!item) continue;
          if (typeof item === "string" && !uri && /^https?:\/\//.test(item)) {
            uri = item;
          }
          if (typeof item === "number") {
            // 400〜599 は HTTP status の可能性が高い
            if (item >= 400 && item <= 599) status = item;
          }
          if (typeof item === "object") {
            const s = item?.status;
            if (typeof s === "number") status = s;
            const u = item?.uri || item?.url;
            if (!uri && typeof u === "string" && /^https?:\/\//.test(u)) uri = u;
          }
        }
      }
    } catch (_) {}

    return { status, uri };
  }

  async setSrc(src) {
    const me = this;

    // Ensure element and Shaka Player are initialized
    if (!this.el_) {
      console.log("Element has not been created, waiting...");
      // Add retry up to 3 times when waiting for this.el_
      if (typeof this._elRetryCount === "undefined") {
        this._elRetryCount = 0;
      }
      this._elRetryCount++;
      if (this._elRetryCount > 3) {
        console.error(
          "Cannot create element for Shaka Player after 3 retries."
        );
        return;
      }
      setTimeout(() => {
        me.setSrc(src);
      }, 100);
      return;
    }

    if (!this.shaka_) {
      console.log("Shaka Player has not been initialized, initializing...");
      await this.initializeShaka();
    }

    if (!this.shaka_) {
      console.log("Cannot initialize Shaka Player");
      return;
    }

    // tech-specific options を優先（video.js の慣習: options.shaka）
    const shakaTechOptions = this.options_?.shaka || {};
    const shakaOptions = shakaTechOptions.configuration || this.options_.configuration || {};

    if (!shakaOptions.abr) {
      shakaOptions.abr = {
        enabled: true,
      };
    }

    // ここで構成を反映（これまで options_.configuration が “作られるだけ” になっていた）
    try {
      this.shaka_.configure(shakaOptions);
    } catch (e) {
      const containerTag = this.getContainerTag();
      console.warn(`${containerTag} [Shaka] Failed to apply configuration:`, e);
    }

    const drmConfig = shakaTechOptions.drmConfig || this.options_.drmConfig;
    if (drmConfig) {
      await (0,_shaka_drm_config__WEBPACK_IMPORTED_MODULE_2__.setupShakaDRM)(this.shaka_, drmConfig);
    }

    const containerTag = this.getContainerTag();
    
    // 3.1 Log load request
    console.log(`${containerTag} [Shaka] Load request:`, { 
      uri: src, 
      isHls: src.includes('.m3u8') 
    });

    // 3.2 Log ABR config + restrictions before load
    console.log(`${containerTag} [Shaka] Effective config abr:`, this.shaka_.getConfiguration().abr);
    console.log(`${containerTag} [Shaka] Effective config restrictions:`, this.shaka_.getConfiguration().restrictions);

    this.shaka_
      .load(src)
      .then(function () {
        me.initShakaMenus();
        
        // 3.3 Log variants at startup
        me.logVariants(me.shaka_, '(at startup)');
        
        // 3.4 Start stats logging (first 30 seconds)
        me.startStatsLogging(me.shaka_);
        
        // Expose instances after source is loaded
        if (me.containerId_) {
          me.exposeShakaInstances();
        }
      })
      .catch((err) => me.retriggerError(err));
  }

  dispose() {
    // Clear stats logging timer
    if (this._statsTimer) {
      clearInterval(this._statsTimer);
      this._statsTimer = null;
    }

    if (this.shaka_) {
      this.shaka_.unload();
      this.shaka_.destroy();
    }
    super.dispose();
  }

  initShakaMenus() {
    // Setup quality tracks, text tracks, audio tracks
    console.log('Setting up Shaka menus...');
    
    try {
      // Setup quality tracks (renditions)
      (0,_setup_quality_tracks__WEBPACK_IMPORTED_MODULE_3__["default"])(this, this.shaka_);
      console.log('Quality tracks setup completed');
      
      // Setup text tracks (subtitles)
      (0,_setup_text_tracks__WEBPACK_IMPORTED_MODULE_4__["default"])(this, this.shaka_);
      console.log('Text tracks setup completed');
      
      // Setup audio tracks
      (0,_setup_audio_tracks__WEBPACK_IMPORTED_MODULE_5__["default"])(this, this.shaka_);
      console.log('Audio tracks setup completed');
    } catch (error) {
      console.error('Error setting up Shaka:', error);
    }
  }

  retriggerError(event) {
    let code;

    // map the shaka player error to the appropriate video.js error
    if (
      event.message &&
      (event.message.indexOf("UNSUPPORTED") > -1 ||
        event.message.indexOf("NOT_SUPPORTED") > -1)
    ) {
      code = 4;
    } else {
      switch (event.category) {
        case 1:
          code = 2;
          break;
        case 2:
        case 3:
        case 4:
          code = 3;
          break;
        case 5:
          code = 1;
          break;
        case 6:
          code = 5;
          break;
        case 7:
        case 8:
        case 9:
          code = 0;
          break;
      }
    }

    // 可能なら HTTP status / URI をメッセージに含める（切り分け用）
    const { status, uri } = this.extractNetworkDetails_(event);
    const extra =
      (typeof status === "number" ? ` status=${status}` : "") +
      (uri ? ` uri=${uri}` : "");

    this.vjsPlayer.error({
      code,
      message: `${event.code} - ${event.message}${extra}`,
    });

    // 404 等で「どう頑張っても取れない」場合、早めに unload してリトライ/ログ増殖を止める
    // ※dispose() は呼ばない（Video.js の内部タイマーが null 参照で落ちるのを避ける）
    if (status === 404 && this.shaka_) {
      const containerTag = this.getContainerTag();
      console.warn(
        `${containerTag} [Shaka] Detected HTTP 404. Unloading Shaka to stop further retries.`
      );

      if (this._statsTimer) {
        clearInterval(this._statsTimer);
        this._statsTimer = null;
      }

      try {
        const p = this.shaka_.unload();
        if (p && typeof p.catch === "function") {
          p.catch(() => {});
        }
      } catch (_) {}
    }

    /**
     * 重要：
     * 以前はエラー発生時に Tech 自体を dispose() していましたが、
     * Video.js 側には内部タイマー/ResizeObserver 等が残っており、
     * `this.tech_` が null になった状態で currentTime/videoHeight を参照して
     * 例外（Uncaught TypeError）を起こすことがあります。
     *
     * ここでは “Video.js にエラーを通知して止める” だけに留め、
     * Tech の破棄は上位（プレイヤーの dispose/再初期化）に委ねます。
     *
     * ※必要なら、外部UI側で `instance.dispose()` → 再生成 を行ってください。
     */
  }

  getShaka_() {
    return this.shaka_;
  }

  // 3.3 Log available variants + currently active
  logVariants(player, tag = '') {
    if (!player) return;
    
    try {
      const variants = player.getVariantTracks();
      const rows = variants
        .map(t => ({
          id: t.id,
          bw: t.bandwidth,
          w: t.width,
          h: t.height,
          codecs: t.codecs,
          active: t.active,
          language: t.language,
        }))
        .sort((a, b) => a.bw - b.bw);

      const containerTag = this.getContainerTag();
      console.log(`${containerTag} [Shaka] Variants ${tag}`, rows);
    } catch (error) {
      const containerTag = this.getContainerTag();
      console.warn(`${containerTag} [Shaka] Error logging variants:`, error);
    }
  }

  // 3.4 Log ABR stats periodically during playback (initial 30 seconds)
  startStatsLogging(player) {
    if (!player) return;
    
    // Clear any existing timer
    if (this._statsTimer) {
      clearInterval(this._statsTimer);
      this._statsTimer = null;
    }

    const containerTag = this.getContainerTag();
    let statsCount = 0;
    const maxStatsLogs = 15; // 30 seconds / 2 seconds = 15 logs

    this._statsTimer = setInterval(() => {
      try {
        const s = player.getStats();
        console.log(`${containerTag} [Shaka] Stats`, {
          estBw: s.estimatedBandwidth,
          playTime: s.playTime,
          bufferingTime: s.bufferingTime,
          variantBw: s.streamBandwidth,
          droppedFrames: s.droppedFrames,
        });

        statsCount++;
        if (statsCount >= maxStatsLogs) {
          clearInterval(this._statsTimer);
          this._statsTimer = null;
        }
      } catch (error) {
        const containerTag = this.getContainerTag();
        console.warn(`${containerTag} [Shaka] Error getting stats:`, error);
        clearInterval(this._statsTimer);
        this._statsTimer = null;
      }
    }, 2000);
  }

  // Set container ID for exposure
  setContainerId(containerId) {
    this.containerId_ = containerId;
    // If Shaka is already initialized, expose immediately
    if (this.shaka_) {
      this.exposeShakaInstances();
    }
  }

  // Expose Shaka instances to window with container-id as key
  exposeShakaInstances() {
    if (typeof window === "undefined" || !this.containerId_ || !this.shaka_) {
      return;
    }

    const containerId = this.containerId_;

    // Initialize window.__shaka_players if not exists
    if (!window.__shaka_players) {
      window.__shaka_players = {};
    }
    if (!window.__shaka_videos) {
      window.__shaka_videos = {};
    }
    if (!window.__shaka_debug) {
      window.__shaka_debug = {};
    }

    // Expose instances with container-id as key
    window.__shaka_players[containerId] = this.shaka_;
    window.__shaka_videos[containerId] = this.el_;

    // Expose debug helpers
    window.__shaka_debug[containerId] = {
      player: this.shaka_,
      video: this.el_,
      tech: this,
      vjsPlayer: this.vjsPlayer,
      getManifest: () => this.shaka_.getManifest(),
      getConfiguration: () => this.shaka_.getConfiguration(),
      getStats: () => this.shaka_.getStats(),
      getBufferedInfo: () => this.shaka_.getBufferedInfo(),
      getPlaybackRate: () => this.shaka_.getPlaybackRate(),
      getVolume: () => this.shaka_.getVolume(),
      isLive: () => this.shaka_.isLive(),
      seekRange: () => this.shaka_.seekRange(),
    };

    // Log exposure
    console.log(`[Shaka] Exposed instances for container "${containerId}":`, {
      __shaka: !!window.__shaka,
      __shaka_players: !!window.__shaka_players[containerId],
      __shaka_videos: !!window.__shaka_videos[containerId],
      __shaka_debug: !!window.__shaka_debug[containerId],
    });
  }
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Shaka);


/***/ }),

/***/ "./src/styles/cc-button.css":
/*!**********************************!*\
  !*** ./src/styles/cc-button.css ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/cc-button.css";

/***/ }),

/***/ "./src/styles/custom-control-bar.css":
/*!*******************************************!*\
  !*** ./src/styles/custom-control-bar.css ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/custom-control-bar.css";

/***/ }),

/***/ "./src/styles/fullscreen-button.css":
/*!******************************************!*\
  !*** ./src/styles/fullscreen-button.css ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/fullscreen-button.css";

/***/ }),

/***/ "./src/styles/play-button.css":
/*!************************************!*\
  !*** ./src/styles/play-button.css ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/play-button.css";

/***/ }),

/***/ "./src/styles/progress-bar.css":
/*!*************************************!*\
  !*** ./src/styles/progress-bar.css ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/progress-bar.css";

/***/ }),

/***/ "./src/styles/settings-button.css":
/*!****************************************!*\
  !*** ./src/styles/settings-button.css ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/settings-button.css";

/***/ }),

/***/ "./src/styles/settings-popup.css":
/*!***************************************!*\
  !*** ./src/styles/settings-popup.css ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/settings-popup.css";

/***/ }),

/***/ "./src/styles/styles.css":
/*!*******************************!*\
  !*** ./src/styles/styles.css ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/styles.css";

/***/ }),

/***/ "./src/styles/time-display.css":
/*!*************************************!*\
  !*** ./src/styles/time-display.css ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/time-display.css";

/***/ }),

/***/ "./src/styles/volume-button.css":
/*!**************************************!*\
  !*** ./src/styles/volume-button.css ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/volume-button.css";

/***/ }),

/***/ "./src/styles/volume-slider.css":
/*!**************************************!*\
  !*** ./src/styles/volume-slider.css ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "css/volume-slider.css";

/***/ }),

/***/ "shaka-player":
/*!************************!*\
  !*** external "shaka" ***!
  \************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_shaka_player__;

/***/ }),

/***/ "video.js":
/*!**************************!*\
  !*** external "videojs" ***!
  \**************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_video_js__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript && document.currentScript.tagName.toUpperCase() === 'SCRIPT')
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/^blob:/, "").replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl + "../";
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! video.js */ "video.js");
/* harmony import */ var video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(video_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var video_js_dist_video_js_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! video.js/dist/video-js.css */ "./node_modules/video.js/dist/video-js.css");
/* harmony import */ var _drm_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./drm-config */ "./src/drm-config.js");
/* harmony import */ var _components_CustomControlBar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/CustomControlBar */ "./src/components/CustomControlBar.js");
/* harmony import */ var _shaka_shaka_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shaka/shaka.js */ "./src/shaka/shaka.js");
/* harmony import */ var _styles_styles_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles/styles.css */ "./src/styles/styles.css");
/* harmony import */ var _constants_displayFormat_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants/displayFormat.js */ "./src/constants/displayFormat.js");
/* harmony import */ var _helpers_helper_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./helpers/helper.js */ "./src/helpers/helper.js");









/**
 * VideoJS DRM Player（ブラウザ用プレイヤー）
 *
 * - Video.js をベースに、DRM（EME / DRMtoday 等）とカスタムUIをまとめた薄いラッパーです。
 * - `new VideoJSDRMPlayer({ containerId, source, ... })` で初期化すると、
 *   指定したコンテナの中に `<video>` を自動生成して Video.js を起動します。
 *
 * 【重要】このファイルはライブラリのエントリーポイントです。
 * - embed 版（`embed/`）では、このソースから webpack で JS/CSS を生成しています。
 */

// Shaka Tech の内部状態（Video.js の Tech が参照する “state” 的な領域）
_shaka_shaka_js__WEBPACK_IMPORTED_MODULE_4__["default"].defaultState = {};

// Video.js に Shaka Tech を登録（`techOrder: ["shaka", "html5"]` で利用可能になる）
video_js__WEBPACK_IMPORTED_MODULE_0___default().registerTech("shaka", _shaka_shaka_js__WEBPACK_IMPORTED_MODULE_4__["default"]);

class VideoJSDRMPlayer {
  constructor(options = {}) {
    /**
     * options（代表的なもの）
     * - containerId {string} 必須: プレイヤーを挿入するDOM要素の id
     * - source {string} 必須: 動画URL（HLS/DASH/MP4等）
     * - isDRM {boolean} DRMコンテンツの場合 true
     * - drmConfig {object} isDRM=true の場合必須（ライセンスURLやヘッダ等）
     * - useShakaTech {boolean} true で Shaka Tech を使う（DASH/HLS等の拡張に有利）
     * - classicControls {boolean} true で Video.js 標準コントロールを表示
     * - controls {boolean} false でコントロール自体を無効化
     * - fluid {boolean} レスポンシブ（親要素に合わせて伸縮）
     * - audioOnlyMode {boolean} 音声のみUI（ビデオ面積を縮退）にするための補助
     * - displayFormat {number} audioOnlyMode の表示形式（HIDDEN / PLAY_PAUSE_ONLY 等）
     */

    // 必須パラメータの検証
    if (!options.containerId) {
      throw new Error("containerId parameter is required");
    }

    if (!options.source) {
      throw new Error("source parameter is required");
    }

    // DRM の場合は drmConfig が必須（ライセンスURL/ヘッダがないと再生不可）
    if (
      options.isDRM &&
      (!options.drmConfig || !Object.keys(options.drmConfig).length)
    ) {
      throw new Error("drmConfig parameter is required if isDRM is true");
    }

    this.options = {
      // Default options
      totalWidth: "100%",
      totalHeight:
        options.audioOnlyMode && options.classicControls ? "" : "auto",
      isDRM: false,
      useShakaTech: false,
      displayFormat: _constants_displayFormat_js__WEBPACK_IMPORTED_MODULE_6__.DISPLAY_FORMAT.DEFAULT,
      audioOnlyMode: false,
      classicControls: false,
      controls: true,
      // Merge with user options
      ...options,
    };

    this.containerId = options.containerId;
    this.source = options.source;
    this.isDRM = options.isDRM ?? false;
    this.player = null;

    // 1) コンテナ内に video タグを生成
    this.createVideoElement();

    // 2) Video.js を初期化し、ソース/DRM/UI をセットアップ
    this.initializePlayer();
  }

  createVideoElement() {
    const containerElement = document.getElementById(this.containerId);
    if (!containerElement) {
      throw new Error(
        `Container element with id "${this.containerId}" not found`
      );
    }

    // コンテナ内に Video.js 用の video タグを作成
    const videoElement = document.createElement("video");
    videoElement.id = `${this.containerId}-video`;
    videoElement.className = "video-js vjs-default-skin";
    if (!this.options.classicControls) {
      // classicControls=false のとき、Video.js 標準のコントロールバーを隠す
      videoElement.classList.add("hide-videojs-controls");
    }
    videoElement.setAttribute("playsinline", true);
    videoElement.setAttribute("webkit-playsinline", true);
    videoElement.setAttribute("x-webkit-airplay", "allow");

    if (this.options.totalWidth) {
      videoElement.style.width = this.options.totalWidth;
    }
    if (this.options.totalHeight) {
      videoElement.style.height = this.options.totalHeight;
    }

    // コンテナを一度クリアして video タグを差し込む
    containerElement.innerHTML = "";
    containerElement.appendChild(videoElement);

    // 既存プレイヤーが居れば破棄（再初期化対応）
    this.dispose();

    this.videoElement = videoElement;

    if (this.options.audioOnlyMode && !this.options.classicControls) {
      // audio-only 表示（CSS側でビデオ領域を縮退させる）
      this.videoElement.classList.add("audio-only");

      if (_constants_displayFormat_js__WEBPACK_IMPORTED_MODULE_6__.DISPLAY_FORMAT_VALUES.includes(this.options.displayFormat)) {
        this.videoElement.classList.add(
          `display-format-${this.options.displayFormat}`
        );

        if (this.options.displayFormat === _constants_displayFormat_js__WEBPACK_IMPORTED_MODULE_6__.DISPLAY_FORMAT.HIDDEN) {
          // “完全非表示” モード（音声だけ再生したいなど）
          this.videoElement.style.display = "none";
        }
      } else {
        console.warn(`Unknown displayFormat: ${this.options.displayFormat}`);
      }
    }
  }

  initializePlayer() {
    const playerOptions = {
      ...this.getVideoJSOptions(),
      // useShakaTech=true のとき Shaka Tech を優先して使う
      // （Shaka 側でDRM/トラック制御をしやすい）
      techOrder: this.options.useShakaTech ? ["shaka", "html5"] : ["html5"],
    };

    this.player = video_js__WEBPACK_IMPORTED_MODULE_0___default()(this.videoElement, playerOptions);

    if (!this.player) {
      throw new Error("Failed to initialize Video.js player");
    }

    if (this.options.fluid) {
      // Video.js の fluid（レスポンシブ）モード
      this.videoElement.classList.add("vjs-fluid");
      this.player.fluid(true);
    }

    // ページ離脱時の破棄（this を維持するため arrow function を使う）
    window.addEventListener("beforeunload", () => {
      this.dispose();
    });

    // エラーを外部に通知（CustomEvent で emit）
    this.player.on("error", (error) => {
      console.error("Video.js Player Error:", error);
      this.emit("error", error);
    });

    // Player ready 後に src/DRM/UI を設定する
    this.player.ready(() => {
      console.log("Video.js Player is ready");

      // Shaka Tech を使う場合、containerId を Tech に渡してデバッグ用インスタンスを expose する
      if (this.options.useShakaTech && this.player.tech()?.setContainerId) {
        this.player.tech().setContainerId(this.containerId);
      }

      // ソース設定：
      // - useShakaTech=false かつ isDRM=true → videojs-contrib-eme 経由で EME/DRM 設定
      // - それ以外 → 通常の player.src({src, type})
      if (!this.options.useShakaTech && this.isDRM) {
        (0,_drm_config__WEBPACK_IMPORTED_MODULE_2__.setupDRM)(
          this.player,
          {
            url: this.source,
            type: (0,_helpers_helper_js__WEBPACK_IMPORTED_MODULE_7__.detectSourceType)(this.source),
          },
          this.options.drmConfig
        );
      } else {
        this.player.src({
          src: this.source,
          type: (0,_helpers_helper_js__WEBPACK_IMPORTED_MODULE_7__.detectSourceType)(this.source),
        });
      }

      // 外部へ「初期化完了」を通知
      this.emit("ready");

      // Shaka Tech の場合、少し待ってから Shaka インスタンスを window に expose する
      if (this.options.useShakaTech) {
        // Shaka の attach/load が走る前後で tech/shaka_ が揃うまでの猶予
        setTimeout(() => {
          const tech = this.player.tech();
          if (tech?.shaka_ && tech?.setContainerId) {
            tech.setContainerId(this.containerId);
            tech.exposeShakaInstances();
          }
        }, 100);
      }

      // classicControls=false のとき、独自UI（CustomControlBar）を video.js の root に append
      if (!this.options.classicControls && this.options.controls) {
        const customControlBar = new _components_CustomControlBar__WEBPACK_IMPORTED_MODULE_3__["default"](this.player);
        this.player.el().appendChild(customControlBar.el());
      }

      // メタデータ取得後に audioOnlyMode 用の追加処理（Safari対策で少し待つ）
      this.player.on("loadedmetadata", () => {
        // Safari では loadedmetadata 直後だと要素が揃っていないことがあるため delay
        setTimeout(() => {
          try {
            if (
              !this.options.classicControls &&
              this.options.audioOnlyMode &&
              this.options.controls &&
              this.options.displayFormat === _constants_displayFormat_js__WEBPACK_IMPORTED_MODULE_6__.DISPLAY_FORMAT.PLAY_PAUSE_ONLY &&
              this.options.poster
            ) {
              const playButton = this.player
                .el()
                .querySelector(".videojs-drm-play-button");
              // PLAY_PAUSE_ONLY 表示のとき、ポスター画像をボタン背景として見せる
              playButton.style.background = null;
              playButton.style.backgroundRepeat = "no-repeat";
              playButton.style.backgroundPosition = "center";
              playButton.style.backgroundSize = "cover";
              playButton.style.backgroundImage = `url(${this.options.poster})`;
            }
          } catch (e) {
            console.error("Error applying audio-only mode:", e);
          }
        }, 500);
      });
    });
  }

  getVideoJSOptions() {
    const videojsOptions = { ...this.options };

    // Video.js へ渡してはいけない “このラッパー専用” オプションを除去
    delete videojsOptions.containerId;
    delete videojsOptions.source;
    delete videojsOptions.isDRM;
    delete videojsOptions.totalWidth;
    delete videojsOptions.totalHeight;
    delete videojsOptions.displayFormat;
    delete videojsOptions.classicControls;
    if (this.options.useShakaTech && this.options.isDRM) {
      // Shaka Tech の場合は、Video.js のオプションとして `shaka.drmConfig` を渡す
      videojsOptions.shaka = {
        drmConfig: this.options.drmConfig,
      };
    } else {
      delete videojsOptions.drmConfig;
    }

    return videojsOptions;
  }

  // ===== Custom event system（外部システム連携用）=====
  // DOM CustomEvent で `containerId-videojs-drm-player:<event>` という名前のイベントを発火します。
  emit(eventName, data = null) {
    const event = new CustomEvent(
      `${this.containerId}-videojs-drm-player:${eventName}`,
      {
        detail: data,
      }
    );
    document.dispatchEvent(event);
  }

  // 例: instance.on("ready", () => { ... })
  on(eventName, callback) {
    document.addEventListener(
      `${this.containerId}-videojs-drm-player:${eventName}`,
      callback
    );
  }

  // ===== Public API methods（外部から操作するための薄いラッパー）=====
  play() {
    if (this.player) {
      return this.player.play();
    }
  }

  pause() {
    if (this.player) {
      this.player.pause();
    }
  }

  stop() {
    if (this.player) {
      this.player.pause();
      this.player.currentTime(0);
    }
  }

  rewind(seconds = 10) {
    if (this.player) {
      const currentTime = this.player.currentTime();
      this.player.currentTime(Math.max(0, currentTime - seconds));
    }
  }

  forward(seconds = 10) {
    if (this.player) {
      const currentTime = this.player.currentTime();
      const duration = this.player.duration();
      this.player.currentTime(Math.min(duration, currentTime + seconds));
    }
  }

  setVolume(volume) {
    if (this.player && volume >= 0 && volume <= 1) {
      this.player.volume(volume);
    }
  }

  getVolume() {
    return this.player ? this.player.volume() : 0;
  }

  isMuted() {
    return this.player ? this.player.muted() : false;
  }

  mute() {
    if (this.player) {
      this.player.muted(true);
    }
  }

  unmute() {
    if (this.player) {
      this.player.muted(false);
    }
  }

  toggleMute() {
    if (this.player) {
      this.player.muted(!this.player.muted());
    }
  }

  getCurrentTime() {
    return this.player ? this.player.currentTime() : 0;
  }

  getDuration() {
    return this.player ? this.player.duration() : 0;
  }

  seek(time) {
    if (this.player && time >= 0) {
      this.player.currentTime(time);
    }
  }

  setSize(width, height) {
    if (this.player) {
      this.player.dimensions(width, height);
      this.options.width = width;
      this.options.height = height;
    }
  }

  // 破棄（メモリリーク防止）
  dispose() {
    if (this.player && !this.player.isDisposed()) {
      this.player.dispose();
      this.player = null;
    }

    // video 要素自体はコンテナ側で管理される前提のため、ここでは参照だけ外す
    this.videoElement = null;
  }
}

// Export for different module systems（ESM/UMD の両対応）
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VideoJSDRMPlayer);

// UMD として `<script>` 直読み込みした場合も使えるよう window にも公開
if (typeof window !== "undefined") {
  window.VideoJSDRMPlayer = VideoJSDRMPlayer;
}

})();

__webpack_exports__ = __webpack_exports__["default"];
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=videojs-drm-player.lite.js.map