(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["VideoJSDRMPlayer"] = factory();
	else
		root["VideoJSDRMPlayer"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}


/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/extends.js":
/*!********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/extends.js ***!
  \********************************************************/
/***/ ((module) => {

function _extends() {
  return module.exports = _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports, _extends.apply(null, arguments);
}
module.exports = _extends, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js":
/*!************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/byte-helpers.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ENDIANNESS: () => (/* binding */ ENDIANNESS),
/* harmony export */   IS_BIG_ENDIAN: () => (/* binding */ IS_BIG_ENDIAN),
/* harmony export */   IS_LITTLE_ENDIAN: () => (/* binding */ IS_LITTLE_ENDIAN),
/* harmony export */   bytesMatch: () => (/* binding */ bytesMatch),
/* harmony export */   bytesToNumber: () => (/* binding */ bytesToNumber),
/* harmony export */   bytesToString: () => (/* binding */ bytesToString),
/* harmony export */   concatTypedArrays: () => (/* binding */ concatTypedArrays),
/* harmony export */   countBits: () => (/* binding */ countBits),
/* harmony export */   countBytes: () => (/* binding */ countBytes),
/* harmony export */   isArrayBufferView: () => (/* binding */ isArrayBufferView),
/* harmony export */   isTypedArray: () => (/* binding */ isTypedArray),
/* harmony export */   numberToBytes: () => (/* binding */ numberToBytes),
/* harmony export */   padStart: () => (/* binding */ padStart),
/* harmony export */   reverseBytes: () => (/* binding */ reverseBytes),
/* harmony export */   sliceBytes: () => (/* binding */ sliceBytes),
/* harmony export */   stringToBytes: () => (/* binding */ stringToBytes),
/* harmony export */   toBinaryString: () => (/* binding */ toBinaryString),
/* harmony export */   toHexString: () => (/* binding */ toHexString),
/* harmony export */   toUint8: () => (/* binding */ toUint8)
/* harmony export */ });
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);
 // const log2 = Math.log2 ? Math.log2 : (x) => (Math.log(x) / Math.log(2));

var repeat = function repeat(str, len) {
  var acc = '';

  while (len--) {
    acc += str;
  }

  return acc;
}; // count the number of bits it would take to represent a number
// we used to do this with log2 but BigInt does not support builtin math
// Math.ceil(log2(x));


var countBits = function countBits(x) {
  return x.toString(2).length;
}; // count the number of whole bytes it would take to represent a number

var countBytes = function countBytes(x) {
  return Math.ceil(countBits(x) / 8);
};
var padStart = function padStart(b, len, str) {
  if (str === void 0) {
    str = ' ';
  }

  return (repeat(str, len) + b.toString()).slice(-len);
};
var isArrayBufferView = function isArrayBufferView(obj) {
  if (ArrayBuffer.isView === 'function') {
    return ArrayBuffer.isView(obj);
  }

  return obj && obj.buffer instanceof ArrayBuffer;
};
var isTypedArray = function isTypedArray(obj) {
  return isArrayBufferView(obj);
};
var toUint8 = function toUint8(bytes) {
  if (bytes instanceof Uint8Array) {
    return bytes;
  }

  if (!Array.isArray(bytes) && !isTypedArray(bytes) && !(bytes instanceof ArrayBuffer)) {
    // any non-number or NaN leads to empty uint8array
    // eslint-disable-next-line
    if (typeof bytes !== 'number' || typeof bytes === 'number' && bytes !== bytes) {
      bytes = 0;
    } else {
      bytes = [bytes];
    }
  }

  return new Uint8Array(bytes && bytes.buffer || bytes, bytes && bytes.byteOffset || 0, bytes && bytes.byteLength || 0);
};
var toHexString = function toHexString(bytes) {
  bytes = toUint8(bytes);
  var str = '';

  for (var i = 0; i < bytes.length; i++) {
    str += padStart(bytes[i].toString(16), 2, '0');
  }

  return str;
};
var toBinaryString = function toBinaryString(bytes) {
  bytes = toUint8(bytes);
  var str = '';

  for (var i = 0; i < bytes.length; i++) {
    str += padStart(bytes[i].toString(2), 8, '0');
  }

  return str;
};
var BigInt = (global_window__WEBPACK_IMPORTED_MODULE_0___default().BigInt) || Number;
var BYTE_TABLE = [BigInt('0x1'), BigInt('0x100'), BigInt('0x10000'), BigInt('0x1000000'), BigInt('0x100000000'), BigInt('0x10000000000'), BigInt('0x1000000000000'), BigInt('0x100000000000000'), BigInt('0x10000000000000000')];
var ENDIANNESS = function () {
  var a = new Uint16Array([0xFFCC]);
  var b = new Uint8Array(a.buffer, a.byteOffset, a.byteLength);

  if (b[0] === 0xFF) {
    return 'big';
  }

  if (b[0] === 0xCC) {
    return 'little';
  }

  return 'unknown';
}();
var IS_BIG_ENDIAN = ENDIANNESS === 'big';
var IS_LITTLE_ENDIAN = ENDIANNESS === 'little';
var bytesToNumber = function bytesToNumber(bytes, _temp) {
  var _ref = _temp === void 0 ? {} : _temp,
      _ref$signed = _ref.signed,
      signed = _ref$signed === void 0 ? false : _ref$signed,
      _ref$le = _ref.le,
      le = _ref$le === void 0 ? false : _ref$le;

  bytes = toUint8(bytes);
  var fn = le ? 'reduce' : 'reduceRight';
  var obj = bytes[fn] ? bytes[fn] : Array.prototype[fn];
  var number = obj.call(bytes, function (total, byte, i) {
    var exponent = le ? i : Math.abs(i + 1 - bytes.length);
    return total + BigInt(byte) * BYTE_TABLE[exponent];
  }, BigInt(0));

  if (signed) {
    var max = BYTE_TABLE[bytes.length] / BigInt(2) - BigInt(1);
    number = BigInt(number);

    if (number > max) {
      number -= max;
      number -= max;
      number -= BigInt(2);
    }
  }

  return Number(number);
};
var numberToBytes = function numberToBytes(number, _temp2) {
  var _ref2 = _temp2 === void 0 ? {} : _temp2,
      _ref2$le = _ref2.le,
      le = _ref2$le === void 0 ? false : _ref2$le;

  // eslint-disable-next-line
  if (typeof number !== 'bigint' && typeof number !== 'number' || typeof number === 'number' && number !== number) {
    number = 0;
  }

  number = BigInt(number);
  var byteCount = countBytes(number);
  var bytes = new Uint8Array(new ArrayBuffer(byteCount));

  for (var i = 0; i < byteCount; i++) {
    var byteIndex = le ? i : Math.abs(i + 1 - bytes.length);
    bytes[byteIndex] = Number(number / BYTE_TABLE[i] & BigInt(0xFF));

    if (number < 0) {
      bytes[byteIndex] = Math.abs(~bytes[byteIndex]);
      bytes[byteIndex] -= i === 0 ? 1 : 2;
    }
  }

  return bytes;
};
var bytesToString = function bytesToString(bytes) {
  if (!bytes) {
    return '';
  } // TODO: should toUint8 handle cases where we only have 8 bytes
  // but report more since this is a Uint16+ Array?


  bytes = Array.prototype.slice.call(bytes);
  var string = String.fromCharCode.apply(null, toUint8(bytes));

  try {
    return decodeURIComponent(escape(string));
  } catch (e) {// if decodeURIComponent/escape fails, we are dealing with partial
    // or full non string data. Just return the potentially garbled string.
  }

  return string;
};
var stringToBytes = function stringToBytes(string, stringIsBytes) {
  if (typeof string !== 'string' && string && typeof string.toString === 'function') {
    string = string.toString();
  }

  if (typeof string !== 'string') {
    return new Uint8Array();
  } // If the string already is bytes, we don't have to do this
  // otherwise we do this so that we split multi length characters
  // into individual bytes


  if (!stringIsBytes) {
    string = unescape(encodeURIComponent(string));
  }

  var view = new Uint8Array(string.length);

  for (var i = 0; i < string.length; i++) {
    view[i] = string.charCodeAt(i);
  }

  return view;
};
var concatTypedArrays = function concatTypedArrays() {
  for (var _len = arguments.length, buffers = new Array(_len), _key = 0; _key < _len; _key++) {
    buffers[_key] = arguments[_key];
  }

  buffers = buffers.filter(function (b) {
    return b && (b.byteLength || b.length) && typeof b !== 'string';
  });

  if (buffers.length <= 1) {
    // for 0 length we will return empty uint8
    // for 1 length we return the first uint8
    return toUint8(buffers[0]);
  }

  var totalLen = buffers.reduce(function (total, buf, i) {
    return total + (buf.byteLength || buf.length);
  }, 0);
  var tempBuffer = new Uint8Array(totalLen);
  var offset = 0;
  buffers.forEach(function (buf) {
    buf = toUint8(buf);
    tempBuffer.set(buf, offset);
    offset += buf.byteLength;
  });
  return tempBuffer;
};
/**
 * Check if the bytes "b" are contained within bytes "a".
 *
 * @param {Uint8Array|Array} a
 *        Bytes to check in
 *
 * @param {Uint8Array|Array} b
 *        Bytes to check for
 *
 * @param {Object} options
 *        options
 *
 * @param {Array|Uint8Array} [offset=0]
 *        offset to use when looking at bytes in a
 *
 * @param {Array|Uint8Array} [mask=[]]
 *        mask to use on bytes before comparison.
 *
 * @return {boolean}
 *         If all bytes in b are inside of a, taking into account
 *         bit masks.
 */

var bytesMatch = function bytesMatch(a, b, _temp3) {
  var _ref3 = _temp3 === void 0 ? {} : _temp3,
      _ref3$offset = _ref3.offset,
      offset = _ref3$offset === void 0 ? 0 : _ref3$offset,
      _ref3$mask = _ref3.mask,
      mask = _ref3$mask === void 0 ? [] : _ref3$mask;

  a = toUint8(a);
  b = toUint8(b); // ie 11 does not support uint8 every

  var fn = b.every ? b.every : Array.prototype.every;
  return b.length && a.length - offset >= b.length && // ie 11 doesn't support every on uin8
  fn.call(b, function (bByte, i) {
    var aByte = mask[i] ? mask[i] & a[offset + i] : a[offset + i];
    return bByte === aByte;
  });
};
var sliceBytes = function sliceBytes(src, start, end) {
  if (Uint8Array.prototype.slice) {
    return Uint8Array.prototype.slice.call(src, start, end);
  }

  return new Uint8Array(Array.prototype.slice.call(src, start, end));
};
var reverseBytes = function reverseBytes(src) {
  if (src.reverse) {
    return src.reverse();
  }

  return Array.prototype.reverse.call(src);
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/codec-helpers.js":
/*!*************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/codec-helpers.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAv1Codec: () => (/* binding */ getAv1Codec),
/* harmony export */   getAvcCodec: () => (/* binding */ getAvcCodec),
/* harmony export */   getHvcCodec: () => (/* binding */ getHvcCodec)
/* harmony export */ });
/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");
 // https://aomediacodec.github.io/av1-isobmff/#av1codecconfigurationbox-syntax
// https://developer.mozilla.org/en-US/docs/Web/Media/Formats/codecs_parameter#AV1

var getAv1Codec = function getAv1Codec(bytes) {
  var codec = '';
  var profile = bytes[1] >>> 3;
  var level = bytes[1] & 0x1F;
  var tier = bytes[2] >>> 7;
  var highBitDepth = (bytes[2] & 0x40) >> 6;
  var twelveBit = (bytes[2] & 0x20) >> 5;
  var monochrome = (bytes[2] & 0x10) >> 4;
  var chromaSubsamplingX = (bytes[2] & 0x08) >> 3;
  var chromaSubsamplingY = (bytes[2] & 0x04) >> 2;
  var chromaSamplePosition = bytes[2] & 0x03;
  codec += profile + "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0');

  if (tier === 0) {
    codec += 'M';
  } else if (tier === 1) {
    codec += 'H';
  }

  var bitDepth;

  if (profile === 2 && highBitDepth) {
    bitDepth = twelveBit ? 12 : 10;
  } else {
    bitDepth = highBitDepth ? 10 : 8;
  }

  codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0'); // TODO: can we parse color range??

  codec += "." + monochrome;
  codec += "." + chromaSubsamplingX + chromaSubsamplingY + chromaSamplePosition;
  return codec;
};
var getAvcCodec = function getAvcCodec(bytes) {
  var profileId = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[1]);
  var constraintFlags = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[2] & 0xFC);
  var levelId = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[3]);
  return "" + profileId + constraintFlags + levelId;
};
var getHvcCodec = function getHvcCodec(bytes) {
  var codec = '';
  var profileSpace = bytes[1] >> 6;
  var profileId = bytes[1] & 0x1F;
  var tierFlag = (bytes[1] & 0x20) >> 5;
  var profileCompat = bytes.subarray(2, 6);
  var constraintIds = bytes.subarray(6, 12);
  var levelId = bytes[12];

  if (profileSpace === 1) {
    codec += 'A';
  } else if (profileSpace === 2) {
    codec += 'B';
  } else if (profileSpace === 3) {
    codec += 'C';
  }

  codec += profileId + "."; // ffmpeg does this in big endian

  var profileCompatVal = parseInt((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toBinaryString)(profileCompat).split('').reverse().join(''), 2); // apple does this in little endian...

  if (profileCompatVal > 255) {
    profileCompatVal = parseInt((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toBinaryString)(profileCompat), 2);
  }

  codec += profileCompatVal.toString(16) + ".";

  if (tierFlag === 0) {
    codec += 'L';
  } else {
    codec += 'H';
  }

  codec += levelId;
  var constraints = '';

  for (var i = 0; i < constraintIds.length; i++) {
    var v = constraintIds[i];

    if (v) {
      if (constraints) {
        constraints += '.';
      }

      constraints += v.toString(16);
    }
  }

  if (constraints) {
    codec += "." + constraints;
  }

  return codec;
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/codecs.js":
/*!******************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/codecs.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_AUDIO_CODEC: () => (/* binding */ DEFAULT_AUDIO_CODEC),
/* harmony export */   DEFAULT_VIDEO_CODEC: () => (/* binding */ DEFAULT_VIDEO_CODEC),
/* harmony export */   browserSupportsCodec: () => (/* binding */ browserSupportsCodec),
/* harmony export */   codecsFromDefault: () => (/* binding */ codecsFromDefault),
/* harmony export */   getMimeForCodec: () => (/* binding */ getMimeForCodec),
/* harmony export */   isAudioCodec: () => (/* binding */ isAudioCodec),
/* harmony export */   isTextCodec: () => (/* binding */ isTextCodec),
/* harmony export */   isVideoCodec: () => (/* binding */ isVideoCodec),
/* harmony export */   mapLegacyAvcCodecs: () => (/* binding */ mapLegacyAvcCodecs),
/* harmony export */   muxerSupportsCodec: () => (/* binding */ muxerSupportsCodec),
/* harmony export */   parseCodecs: () => (/* binding */ parseCodecs),
/* harmony export */   translateLegacyCodec: () => (/* binding */ translateLegacyCodec),
/* harmony export */   translateLegacyCodecs: () => (/* binding */ translateLegacyCodecs)
/* harmony export */ });
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);

var regexs = {
  // to determine mime types
  mp4: /^(av0?1|avc0?[1234]|vp0?9|flac|opus|mp3|mp4a|mp4v|stpp.ttml.im1t)/,
  webm: /^(vp0?[89]|av0?1|opus|vorbis)/,
  ogg: /^(vp0?[89]|theora|flac|opus|vorbis)/,
  // to determine if a codec is audio or video
  video: /^(av0?1|avc0?[1234]|vp0?[89]|hvc1|hev1|theora|mp4v)/,
  audio: /^(mp4a|flac|vorbis|opus|ac-[34]|ec-3|alac|mp3|speex|aac)/,
  text: /^(stpp.ttml.im1t)/,
  // mux.js support regex
  muxerVideo: /^(avc0?1)/,
  muxerAudio: /^(mp4a)/,
  // match nothing as muxer does not support text right now.
  // there cannot never be a character before the start of a string
  // so this matches nothing.
  muxerText: /a^/
};
var mediaTypes = ['video', 'audio', 'text'];
var upperMediaTypes = ['Video', 'Audio', 'Text'];
/**
 * Replace the old apple-style `avc1.<dd>.<dd>` codec string with the standard
 * `avc1.<hhhhhh>`
 *
 * @param {string} codec
 *        Codec string to translate
 * @return {string}
 *         The translated codec string
 */

var translateLegacyCodec = function translateLegacyCodec(codec) {
  if (!codec) {
    return codec;
  }

  return codec.replace(/avc1\.(\d+)\.(\d+)/i, function (orig, profile, avcLevel) {
    var profileHex = ('00' + Number(profile).toString(16)).slice(-2);
    var avcLevelHex = ('00' + Number(avcLevel).toString(16)).slice(-2);
    return 'avc1.' + profileHex + '00' + avcLevelHex;
  });
};
/**
 * Replace the old apple-style `avc1.<dd>.<dd>` codec strings with the standard
 * `avc1.<hhhhhh>`
 *
 * @param {string[]} codecs
 *        An array of codec strings to translate
 * @return {string[]}
 *         The translated array of codec strings
 */

var translateLegacyCodecs = function translateLegacyCodecs(codecs) {
  return codecs.map(translateLegacyCodec);
};
/**
 * Replace codecs in the codec string with the old apple-style `avc1.<dd>.<dd>` to the
 * standard `avc1.<hhhhhh>`.
 *
 * @param {string} codecString
 *        The codec string
 * @return {string}
 *         The codec string with old apple-style codecs replaced
 *
 * @private
 */

var mapLegacyAvcCodecs = function mapLegacyAvcCodecs(codecString) {
  return codecString.replace(/avc1\.(\d+)\.(\d+)/i, function (match) {
    return translateLegacyCodecs([match])[0];
  });
};
/**
 * @typedef {Object} ParsedCodecInfo
 * @property {number} codecCount
 *           Number of codecs parsed
 * @property {string} [videoCodec]
 *           Parsed video codec (if found)
 * @property {string} [videoObjectTypeIndicator]
 *           Video object type indicator (if found)
 * @property {string|null} audioProfile
 *           Audio profile
 */

/**
 * Parses a codec string to retrieve the number of codecs specified, the video codec and
 * object type indicator, and the audio profile.
 *
 * @param {string} [codecString]
 *        The codec string to parse
 * @return {ParsedCodecInfo}
 *         Parsed codec info
 */

var parseCodecs = function parseCodecs(codecString) {
  if (codecString === void 0) {
    codecString = '';
  }

  var codecs = codecString.split(',');
  var result = [];
  codecs.forEach(function (codec) {
    codec = codec.trim();
    var codecType;
    mediaTypes.forEach(function (name) {
      var match = regexs[name].exec(codec.toLowerCase());

      if (!match || match.length <= 1) {
        return;
      }

      codecType = name; // maintain codec case

      var type = codec.substring(0, match[1].length);
      var details = codec.replace(type, '');
      result.push({
        type: type,
        details: details,
        mediaType: name
      });
    });

    if (!codecType) {
      result.push({
        type: codec,
        details: '',
        mediaType: 'unknown'
      });
    }
  });
  return result;
};
/**
 * Returns a ParsedCodecInfo object for the default alternate audio playlist if there is
 * a default alternate audio playlist for the provided audio group.
 *
 * @param {Object} master
 *        The master playlist
 * @param {string} audioGroupId
 *        ID of the audio group for which to find the default codec info
 * @return {ParsedCodecInfo}
 *         Parsed codec info
 */

var codecsFromDefault = function codecsFromDefault(master, audioGroupId) {
  if (!master.mediaGroups.AUDIO || !audioGroupId) {
    return null;
  }

  var audioGroup = master.mediaGroups.AUDIO[audioGroupId];

  if (!audioGroup) {
    return null;
  }

  for (var name in audioGroup) {
    var audioType = audioGroup[name];

    if (audioType.default && audioType.playlists) {
      // codec should be the same for all playlists within the audio type
      return parseCodecs(audioType.playlists[0].attributes.CODECS);
    }
  }

  return null;
};
var isVideoCodec = function isVideoCodec(codec) {
  if (codec === void 0) {
    codec = '';
  }

  return regexs.video.test(codec.trim().toLowerCase());
};
var isAudioCodec = function isAudioCodec(codec) {
  if (codec === void 0) {
    codec = '';
  }

  return regexs.audio.test(codec.trim().toLowerCase());
};
var isTextCodec = function isTextCodec(codec) {
  if (codec === void 0) {
    codec = '';
  }

  return regexs.text.test(codec.trim().toLowerCase());
};
var getMimeForCodec = function getMimeForCodec(codecString) {
  if (!codecString || typeof codecString !== 'string') {
    return;
  }

  var codecs = codecString.toLowerCase().split(',').map(function (c) {
    return translateLegacyCodec(c.trim());
  }); // default to video type

  var type = 'video'; // only change to audio type if the only codec we have is
  // audio

  if (codecs.length === 1 && isAudioCodec(codecs[0])) {
    type = 'audio';
  } else if (codecs.length === 1 && isTextCodec(codecs[0])) {
    // text uses application/<container> for now
    type = 'application';
  } // default the container to mp4


  var container = 'mp4'; // every codec must be able to go into the container
  // for that container to be the correct one

  if (codecs.every(function (c) {
    return regexs.mp4.test(c);
  })) {
    container = 'mp4';
  } else if (codecs.every(function (c) {
    return regexs.webm.test(c);
  })) {
    container = 'webm';
  } else if (codecs.every(function (c) {
    return regexs.ogg.test(c);
  })) {
    container = 'ogg';
  }

  return type + "/" + container + ";codecs=\"" + codecString + "\"";
};
/**
 * Tests whether the codec is supported by MediaSource. Optionally also tests ManagedMediaSource.
 *
 * @param {string} codecString
 *        Codec to test
 * @param {boolean} [withMMS]
 *        Whether to check if ManagedMediaSource supports it
 * @return {boolean}
 *          Codec is supported
 */

var browserSupportsCodec = function browserSupportsCodec(codecString, withMMS) {
  if (codecString === void 0) {
    codecString = '';
  }

  if (withMMS === void 0) {
    withMMS = false;
  }

  return (global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource) && (global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource).isTypeSupported && global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource.isTypeSupported(getMimeForCodec(codecString)) || withMMS && (global_window__WEBPACK_IMPORTED_MODULE_0___default().ManagedMediaSource) && (global_window__WEBPACK_IMPORTED_MODULE_0___default().ManagedMediaSource).isTypeSupported && global_window__WEBPACK_IMPORTED_MODULE_0___default().ManagedMediaSource.isTypeSupported(getMimeForCodec(codecString)) || false;
};
var muxerSupportsCodec = function muxerSupportsCodec(codecString) {
  if (codecString === void 0) {
    codecString = '';
  }

  return codecString.toLowerCase().split(',').every(function (codec) {
    codec = codec.trim(); // any match is supported.

    for (var i = 0; i < upperMediaTypes.length; i++) {
      var type = upperMediaTypes[i];

      if (regexs["muxer" + type].test(codec)) {
        return true;
      }
    }

    return false;
  });
};
var DEFAULT_AUDIO_CODEC = 'mp4a.40.2';
var DEFAULT_VIDEO_CODEC = 'avc1.4d400d';

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/containers.js":
/*!**********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/containers.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   detectContainerForBytes: () => (/* binding */ detectContainerForBytes),
/* harmony export */   isLikely: () => (/* binding */ isLikely),
/* harmony export */   isLikelyFmp4MediaSegment: () => (/* binding */ isLikelyFmp4MediaSegment)
/* harmony export */ });
/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");
/* harmony import */ var _mp4_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mp4-helpers.js */ "./node_modules/@videojs/vhs-utils/es/mp4-helpers.js");
/* harmony import */ var _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ebml-helpers.js */ "./node_modules/@videojs/vhs-utils/es/ebml-helpers.js");
/* harmony import */ var _id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./id3-helpers.js */ "./node_modules/@videojs/vhs-utils/es/id3-helpers.js");
/* harmony import */ var _nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./nal-helpers.js */ "./node_modules/@videojs/vhs-utils/es/nal-helpers.js");





var CONSTANTS = {
  // "webm" string literal in hex
  'webm': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x77, 0x65, 0x62, 0x6d]),
  // "matroska" string literal in hex
  'matroska': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6d, 0x61, 0x74, 0x72, 0x6f, 0x73, 0x6b, 0x61]),
  // "fLaC" string literal in hex
  'flac': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x4c, 0x61, 0x43]),
  // "OggS" string literal in hex
  'ogg': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x4f, 0x67, 0x67, 0x53]),
  // ac-3 sync byte, also works for ec-3 as that is simply a codec
  // of ac-3
  'ac3': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x0b, 0x77]),
  // "RIFF" string literal in hex used for wav and avi
  'riff': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x52, 0x49, 0x46, 0x46]),
  // "AVI" string literal in hex
  'avi': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x41, 0x56, 0x49]),
  // "WAVE" string literal in hex
  'wav': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x57, 0x41, 0x56, 0x45]),
  // "ftyp3g" string literal in hex
  '3gp': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70, 0x33, 0x67]),
  // "ftyp" string literal in hex
  'mp4': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70]),
  // "styp" string literal in hex
  'fmp4': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x73, 0x74, 0x79, 0x70]),
  // "ftypqt" string literal in hex
  'mov': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70, 0x71, 0x74]),
  // moov string literal in hex
  'moov': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6D, 0x6F, 0x6F, 0x76]),
  // moof string literal in hex
  'moof': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6D, 0x6F, 0x6F, 0x66])
};
var _isLikely = {
  aac: function aac(bytes) {
    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, [0xFF, 0x10], {
      offset: offset,
      mask: [0xFF, 0x16]
    });
  },
  mp3: function mp3(bytes) {
    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, [0xFF, 0x02], {
      offset: offset,
      mask: [0xFF, 0x06]
    });
  },
  webm: function webm(bytes) {
    var docType = (0,_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.findEbml)(bytes, [_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.EBML, _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.DocType])[0]; // check if DocType EBML tag is webm

    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(docType, CONSTANTS.webm);
  },
  mkv: function mkv(bytes) {
    var docType = (0,_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.findEbml)(bytes, [_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.EBML, _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.DocType])[0]; // check if DocType EBML tag is matroska

    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(docType, CONSTANTS.matroska);
  },
  mp4: function mp4(bytes) {
    // if this file is another base media file format, it is not mp4
    if (_isLikely['3gp'](bytes) || _isLikely.mov(bytes)) {
      return false;
    } // if this file starts with a ftyp or styp box its mp4


    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.mp4, {
      offset: 4
    }) || (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.fmp4, {
      offset: 4
    })) {
      return true;
    } // if this file starts with a moof/moov box its mp4


    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.moof, {
      offset: 4
    }) || (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.moov, {
      offset: 4
    })) {
      return true;
    }
  },
  mov: function mov(bytes) {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.mov, {
      offset: 4
    });
  },
  '3gp': function gp(bytes) {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS['3gp'], {
      offset: 4
    });
  },
  ac3: function ac3(bytes) {
    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.ac3, {
      offset: offset
    });
  },
  ts: function ts(bytes) {
    if (bytes.length < 189 && bytes.length >= 1) {
      return bytes[0] === 0x47;
    }

    var i = 0; // check the first 376 bytes for two matching sync bytes

    while (i + 188 < bytes.length && i < 188) {
      if (bytes[i] === 0x47 && bytes[i + 188] === 0x47) {
        return true;
      }

      i += 1;
    }

    return false;
  },
  flac: function flac(bytes) {
    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.flac, {
      offset: offset
    });
  },
  ogg: function ogg(bytes) {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.ogg);
  },
  avi: function avi(bytes) {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.riff) && (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.avi, {
      offset: 8
    });
  },
  wav: function wav(bytes) {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.riff) && (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.wav, {
      offset: 8
    });
  },
  'h264': function h264(bytes) {
    // find seq_parameter_set_rbsp
    return (0,_nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__.findH264Nal)(bytes, 7, 3).length;
  },
  'h265': function h265(bytes) {
    // find video_parameter_set_rbsp or seq_parameter_set_rbsp
    return (0,_nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__.findH265Nal)(bytes, [32, 33], 3).length;
  }
}; // get all the isLikely functions
// but make sure 'ts' is above h264 and h265
// but below everything else as it is the least specific

var isLikelyTypes = Object.keys(_isLikely) // remove ts, h264, h265
.filter(function (t) {
  return t !== 'ts' && t !== 'h264' && t !== 'h265';
}) // add it back to the bottom
.concat(['ts', 'h264', 'h265']); // make sure we are dealing with uint8 data.

isLikelyTypes.forEach(function (type) {
  var isLikelyFn = _isLikely[type];

  _isLikely[type] = function (bytes) {
    return isLikelyFn((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes));
  };
}); // export after wrapping

var isLikely = _isLikely; // A useful list of file signatures can be found here
// https://en.wikipedia.org/wiki/List_of_file_signatures

var detectContainerForBytes = function detectContainerForBytes(bytes) {
  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);

  for (var i = 0; i < isLikelyTypes.length; i++) {
    var type = isLikelyTypes[i];

    if (isLikely[type](bytes)) {
      return type;
    }
  }

  return '';
}; // fmp4 is not a container

var isLikelyFmp4MediaSegment = function isLikelyFmp4MediaSegment(bytes) {
  return (0,_mp4_helpers_js__WEBPACK_IMPORTED_MODULE_1__.findBox)(bytes, ['moof']).length > 0;
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ decodeB64ToUint8Array)
/* harmony export */ });
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);


var atob = function atob(s) {
  return (global_window__WEBPACK_IMPORTED_MODULE_0___default().atob) ? global_window__WEBPACK_IMPORTED_MODULE_0___default().atob(s) : Buffer.from(s, 'base64').toString('binary');
};

function decodeB64ToUint8Array(b64Text) {
  var decodedString = atob(b64Text);
  var array = new Uint8Array(decodedString.length);

  for (var i = 0; i < decodedString.length; i++) {
    array[i] = decodedString.charCodeAt(i);
  }

  return array;
}

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/ebml-helpers.js":
/*!************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/ebml-helpers.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EBML_TAGS: () => (/* binding */ EBML_TAGS),
/* harmony export */   decodeBlock: () => (/* binding */ decodeBlock),
/* harmony export */   findEbml: () => (/* binding */ findEbml),
/* harmony export */   parseData: () => (/* binding */ parseData),
/* harmony export */   parseTracks: () => (/* binding */ parseTracks)
/* harmony export */ });
/* harmony import */ var _byte_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");
/* harmony import */ var _codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codec-helpers.js */ "./node_modules/@videojs/vhs-utils/es/codec-helpers.js");

 // relevant specs for this parser:
// https://matroska-org.github.io/libebml/specs.html
// https://www.matroska.org/technical/elements.html
// https://www.webmproject.org/docs/container/

var EBML_TAGS = {
  EBML: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x1A, 0x45, 0xDF, 0xA3]),
  DocType: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x42, 0x82]),
  Segment: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x18, 0x53, 0x80, 0x67]),
  SegmentInfo: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x15, 0x49, 0xA9, 0x66]),
  Tracks: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x16, 0x54, 0xAE, 0x6B]),
  Track: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xAE]),
  TrackNumber: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xd7]),
  DefaultDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x23, 0xe3, 0x83]),
  TrackEntry: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xAE]),
  TrackType: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x83]),
  FlagDefault: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x88]),
  CodecID: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x86]),
  CodecPrivate: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x63, 0xA2]),
  VideoTrack: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xe0]),
  AudioTrack: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xe1]),
  // Not used yet, but will be used for live webm/mkv
  // see https://www.matroska.org/technical/basics.html#block-structure
  // see https://www.matroska.org/technical/basics.html#simpleblock-structure
  Cluster: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x1F, 0x43, 0xB6, 0x75]),
  Timestamp: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xE7]),
  TimestampScale: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x2A, 0xD7, 0xB1]),
  BlockGroup: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA0]),
  BlockDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x9B]),
  Block: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA1]),
  SimpleBlock: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA3])
};
/**
 * This is a simple table to determine the length
 * of things in ebml. The length is one based (starts at 1,
 * rather than zero) and for every zero bit before a one bit
 * we add one to length. We also need this table because in some
 * case we have to xor all the length bits from another value.
 */

var LENGTH_TABLE = [128, 64, 32, 16, 8, 4, 2, 1];

var getLength = function getLength(byte) {
  var len = 1;

  for (var i = 0; i < LENGTH_TABLE.length; i++) {
    if (byte & LENGTH_TABLE[i]) {
      break;
    }

    len++;
  }

  return len;
}; // length in ebml is stored in the first 4 to 8 bits
// of the first byte. 4 for the id length and 8 for the
// data size length. Length is measured by converting the number to binary
// then 1 + the number of zeros before a 1 is encountered starting
// from the left.


var getvint = function getvint(bytes, offset, removeLength, signed) {
  if (removeLength === void 0) {
    removeLength = true;
  }

  if (signed === void 0) {
    signed = false;
  }

  var length = getLength(bytes[offset]);
  var valueBytes = bytes.subarray(offset, offset + length); // NOTE that we do **not** subarray here because we need to copy these bytes
  // as they will be modified below to remove the dataSizeLen bits and we do not
  // want to modify the original data. normally we could just call slice on
  // uint8array but ie 11 does not support that...

  if (removeLength) {
    valueBytes = Array.prototype.slice.call(bytes, offset, offset + length);
    valueBytes[0] ^= LENGTH_TABLE[length - 1];
  }

  return {
    length: length,
    value: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(valueBytes, {
      signed: signed
    }),
    bytes: valueBytes
  };
};

var normalizePath = function normalizePath(path) {
  if (typeof path === 'string') {
    return path.match(/.{1,2}/g).map(function (p) {
      return normalizePath(p);
    });
  }

  if (typeof path === 'number') {
    return (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.numberToBytes)(path);
  }

  return path;
};

var normalizePaths = function normalizePaths(paths) {
  if (!Array.isArray(paths)) {
    return [normalizePath(paths)];
  }

  return paths.map(function (p) {
    return normalizePath(p);
  });
};

var getInfinityDataSize = function getInfinityDataSize(id, bytes, offset) {
  if (offset >= bytes.length) {
    return bytes.length;
  }

  var innerid = getvint(bytes, offset, false);

  if ((0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(id.bytes, innerid.bytes)) {
    return offset;
  }

  var dataHeader = getvint(bytes, offset + innerid.length);
  return getInfinityDataSize(id, bytes, offset + dataHeader.length + dataHeader.value + innerid.length);
};
/**
 * Notes on the EBLM format.
 *
 * EBLM uses "vints" tags. Every vint tag contains
 * two parts
 *
 * 1. The length from the first byte. You get this by
 *    converting the byte to binary and counting the zeros
 *    before a 1. Then you add 1 to that. Examples
 *    00011111 = length 4 because there are 3 zeros before a 1.
 *    00100000 = length 3 because there are 2 zeros before a 1.
 *    00000011 = length 7 because there are 6 zeros before a 1.
 *
 * 2. The bits used for length are removed from the first byte
 *    Then all the bytes are merged into a value. NOTE: this
 *    is not the case for id ebml tags as there id includes
 *    length bits.
 *
 */


var findEbml = function findEbml(bytes, paths) {
  paths = normalizePaths(paths);
  bytes = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var results = [];

  if (!paths.length) {
    return results;
  }

  var i = 0;

  while (i < bytes.length) {
    var id = getvint(bytes, i, false);
    var dataHeader = getvint(bytes, i + id.length);
    var dataStart = i + id.length + dataHeader.length; // dataSize is unknown or this is a live stream

    if (dataHeader.value === 0x7f) {
      dataHeader.value = getInfinityDataSize(id, bytes, dataStart);

      if (dataHeader.value !== bytes.length) {
        dataHeader.value -= dataStart;
      }
    }

    var dataEnd = dataStart + dataHeader.value > bytes.length ? bytes.length : dataStart + dataHeader.value;
    var data = bytes.subarray(dataStart, dataEnd);

    if ((0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(paths[0], id.bytes)) {
      if (paths.length === 1) {
        // this is the end of the paths and we've found the tag we were
        // looking for
        results.push(data);
      } else {
        // recursively search for the next tag inside of the data
        // of this one
        results = results.concat(findEbml(data, paths.slice(1)));
      }
    }

    var totalLength = id.length + dataHeader.length + data.length; // move past this tag entirely, we are not looking for it

    i += totalLength;
  }

  return results;
}; // see https://www.matroska.org/technical/basics.html#block-structure

var decodeBlock = function decodeBlock(block, type, timestampScale, clusterTimestamp) {
  var duration;

  if (type === 'group') {
    duration = findEbml(block, [EBML_TAGS.BlockDuration])[0];

    if (duration) {
      duration = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(duration);
      duration = 1 / timestampScale * duration * timestampScale / 1000;
    }

    block = findEbml(block, [EBML_TAGS.Block])[0];
    type = 'block'; // treat data as a block after this point
  }

  var dv = new DataView(block.buffer, block.byteOffset, block.byteLength);
  var trackNumber = getvint(block, 0);
  var timestamp = dv.getInt16(trackNumber.length, false);
  var flags = block[trackNumber.length + 2];
  var data = block.subarray(trackNumber.length + 3); // pts/dts in seconds

  var ptsdts = 1 / timestampScale * (clusterTimestamp + timestamp) * timestampScale / 1000; // return the frame

  var parsed = {
    duration: duration,
    trackNumber: trackNumber.value,
    keyframe: type === 'simple' && flags >> 7 === 1,
    invisible: (flags & 0x08) >> 3 === 1,
    lacing: (flags & 0x06) >> 1,
    discardable: type === 'simple' && (flags & 0x01) === 1,
    frames: [],
    pts: ptsdts,
    dts: ptsdts,
    timestamp: timestamp
  };

  if (!parsed.lacing) {
    parsed.frames.push(data);
    return parsed;
  }

  var numberOfFrames = data[0] + 1;
  var frameSizes = [];
  var offset = 1; // Fixed

  if (parsed.lacing === 2) {
    var sizeOfFrame = (data.length - offset) / numberOfFrames;

    for (var i = 0; i < numberOfFrames; i++) {
      frameSizes.push(sizeOfFrame);
    }
  } // xiph


  if (parsed.lacing === 1) {
    for (var _i = 0; _i < numberOfFrames - 1; _i++) {
      var size = 0;

      do {
        size += data[offset];
        offset++;
      } while (data[offset - 1] === 0xFF);

      frameSizes.push(size);
    }
  } // ebml


  if (parsed.lacing === 3) {
    // first vint is unsinged
    // after that vints are singed and
    // based on a compounding size
    var _size = 0;

    for (var _i2 = 0; _i2 < numberOfFrames - 1; _i2++) {
      var vint = _i2 === 0 ? getvint(data, offset) : getvint(data, offset, true, true);
      _size += vint.value;
      frameSizes.push(_size);
      offset += vint.length;
    }
  }

  frameSizes.forEach(function (size) {
    parsed.frames.push(data.subarray(offset, offset + size));
    offset += size;
  });
  return parsed;
}; // VP9 Codec Feature Metadata (CodecPrivate)
// https://www.webmproject.org/docs/container/

var parseVp9Private = function parseVp9Private(bytes) {
  var i = 0;
  var params = {};

  while (i < bytes.length) {
    var id = bytes[i] & 0x7f;
    var len = bytes[i + 1];
    var val = void 0;

    if (len === 1) {
      val = bytes[i + 2];
    } else {
      val = bytes.subarray(i + 2, i + 2 + len);
    }

    if (id === 1) {
      params.profile = val;
    } else if (id === 2) {
      params.level = val;
    } else if (id === 3) {
      params.bitDepth = val;
    } else if (id === 4) {
      params.chromaSubsampling = val;
    } else {
      params[id] = val;
    }

    i += 2 + len;
  }

  return params;
};

var parseTracks = function parseTracks(bytes) {
  bytes = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var decodedTracks = [];
  var tracks = findEbml(bytes, [EBML_TAGS.Segment, EBML_TAGS.Tracks, EBML_TAGS.Track]);

  if (!tracks.length) {
    tracks = findEbml(bytes, [EBML_TAGS.Tracks, EBML_TAGS.Track]);
  }

  if (!tracks.length) {
    tracks = findEbml(bytes, [EBML_TAGS.Track]);
  }

  if (!tracks.length) {
    return decodedTracks;
  }

  tracks.forEach(function (track) {
    var trackType = findEbml(track, EBML_TAGS.TrackType)[0];

    if (!trackType || !trackType.length) {
      return;
    } // 1 is video, 2 is audio, 17 is subtitle
    // other values are unimportant in this context


    if (trackType[0] === 1) {
      trackType = 'video';
    } else if (trackType[0] === 2) {
      trackType = 'audio';
    } else if (trackType[0] === 17) {
      trackType = 'subtitle';
    } else {
      return;
    } // todo parse language


    var decodedTrack = {
      rawCodec: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(findEbml(track, [EBML_TAGS.CodecID])[0]),
      type: trackType,
      codecPrivate: findEbml(track, [EBML_TAGS.CodecPrivate])[0],
      number: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(findEbml(track, [EBML_TAGS.TrackNumber])[0]),
      defaultDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(findEbml(track, [EBML_TAGS.DefaultDuration])[0]),
      default: findEbml(track, [EBML_TAGS.FlagDefault])[0],
      rawData: track
    };
    var codec = '';

    if (/V_MPEG4\/ISO\/AVC/.test(decodedTrack.rawCodec)) {
      codec = "avc1." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAvcCodec)(decodedTrack.codecPrivate);
    } else if (/V_MPEGH\/ISO\/HEVC/.test(decodedTrack.rawCodec)) {
      codec = "hev1." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getHvcCodec)(decodedTrack.codecPrivate);
    } else if (/V_MPEG4\/ISO\/ASP/.test(decodedTrack.rawCodec)) {
      if (decodedTrack.codecPrivate) {
        codec = 'mp4v.20.' + decodedTrack.codecPrivate[4].toString();
      } else {
        codec = 'mp4v.20.9';
      }
    } else if (/^V_THEORA/.test(decodedTrack.rawCodec)) {
      codec = 'theora';
    } else if (/^V_VP8/.test(decodedTrack.rawCodec)) {
      codec = 'vp8';
    } else if (/^V_VP9/.test(decodedTrack.rawCodec)) {
      if (decodedTrack.codecPrivate) {
        var _parseVp9Private = parseVp9Private(decodedTrack.codecPrivate),
            profile = _parseVp9Private.profile,
            level = _parseVp9Private.level,
            bitDepth = _parseVp9Private.bitDepth,
            chromaSubsampling = _parseVp9Private.chromaSubsampling;

        codec = 'vp09.';
        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(profile, 2, '0') + ".";
        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0') + ".";
        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0') + ".";
        codec += "" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(chromaSubsampling, 2, '0'); // Video -> Colour -> Ebml name

        var matrixCoefficients = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xB1]])[0] || [];
        var videoFullRangeFlag = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xB9]])[0] || [];
        var transferCharacteristics = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xBA]])[0] || [];
        var colourPrimaries = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xBB]])[0] || []; // if we find any optional codec parameter specify them all.

        if (matrixCoefficients.length || videoFullRangeFlag.length || transferCharacteristics.length || colourPrimaries.length) {
          codec += "." + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(colourPrimaries[0], 2, '0');
          codec += "." + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(transferCharacteristics[0], 2, '0');
          codec += "." + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(matrixCoefficients[0], 2, '0');
          codec += "." + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(videoFullRangeFlag[0], 2, '0');
        }
      } else {
        codec = 'vp9';
      }
    } else if (/^V_AV1/.test(decodedTrack.rawCodec)) {
      codec = "av01." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAv1Codec)(decodedTrack.codecPrivate);
    } else if (/A_ALAC/.test(decodedTrack.rawCodec)) {
      codec = 'alac';
    } else if (/A_MPEG\/L2/.test(decodedTrack.rawCodec)) {
      codec = 'mp2';
    } else if (/A_MPEG\/L3/.test(decodedTrack.rawCodec)) {
      codec = 'mp3';
    } else if (/^A_AAC/.test(decodedTrack.rawCodec)) {
      if (decodedTrack.codecPrivate) {
        codec = 'mp4a.40.' + (decodedTrack.codecPrivate[0] >>> 3).toString();
      } else {
        codec = 'mp4a.40.2';
      }
    } else if (/^A_AC3/.test(decodedTrack.rawCodec)) {
      codec = 'ac-3';
    } else if (/^A_PCM/.test(decodedTrack.rawCodec)) {
      codec = 'pcm';
    } else if (/^A_MS\/ACM/.test(decodedTrack.rawCodec)) {
      codec = 'speex';
    } else if (/^A_EAC3/.test(decodedTrack.rawCodec)) {
      codec = 'ec-3';
    } else if (/^A_VORBIS/.test(decodedTrack.rawCodec)) {
      codec = 'vorbis';
    } else if (/^A_FLAC/.test(decodedTrack.rawCodec)) {
      codec = 'flac';
    } else if (/^A_OPUS/.test(decodedTrack.rawCodec)) {
      codec = 'opus';
    }

    decodedTrack.codec = codec;
    decodedTracks.push(decodedTrack);
  });
  return decodedTracks.sort(function (a, b) {
    return a.number - b.number;
  });
};
var parseData = function parseData(data, tracks) {
  var allBlocks = [];
  var segment = findEbml(data, [EBML_TAGS.Segment])[0];
  var timestampScale = findEbml(segment, [EBML_TAGS.SegmentInfo, EBML_TAGS.TimestampScale])[0]; // in nanoseconds, defaults to 1ms

  if (timestampScale && timestampScale.length) {
    timestampScale = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(timestampScale);
  } else {
    timestampScale = 1000000;
  }

  var clusters = findEbml(segment, [EBML_TAGS.Cluster]);

  if (!tracks) {
    tracks = parseTracks(segment);
  }

  clusters.forEach(function (cluster, ci) {
    var simpleBlocks = findEbml(cluster, [EBML_TAGS.SimpleBlock]).map(function (b) {
      return {
        type: 'simple',
        data: b
      };
    });
    var blockGroups = findEbml(cluster, [EBML_TAGS.BlockGroup]).map(function (b) {
      return {
        type: 'group',
        data: b
      };
    });
    var timestamp = findEbml(cluster, [EBML_TAGS.Timestamp])[0] || 0;

    if (timestamp && timestamp.length) {
      timestamp = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(timestamp);
    } // get all blocks then sort them into the correct order


    var blocks = simpleBlocks.concat(blockGroups).sort(function (a, b) {
      return a.data.byteOffset - b.data.byteOffset;
    });
    blocks.forEach(function (block, bi) {
      var decoded = decodeBlock(block.data, block.type, timestampScale, timestamp);
      allBlocks.push(decoded);
    });
  });
  return {
    tracks: tracks,
    blocks: allBlocks
  };
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/id3-helpers.js":
/*!***********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/id3-helpers.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getId3Offset: () => (/* binding */ getId3Offset),
/* harmony export */   getId3Size: () => (/* binding */ getId3Size)
/* harmony export */ });
/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");

var ID3 = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x49, 0x44, 0x33]);
var getId3Size = function getId3Size(bytes, offset) {
  if (offset === void 0) {
    offset = 0;
  }

  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var flags = bytes[offset + 5];
  var returnSize = bytes[offset + 6] << 21 | bytes[offset + 7] << 14 | bytes[offset + 8] << 7 | bytes[offset + 9];
  var footerPresent = (flags & 16) >> 4;

  if (footerPresent) {
    return returnSize + 20;
  }

  return returnSize + 10;
};
var getId3Offset = function getId3Offset(bytes, offset) {
  if (offset === void 0) {
    offset = 0;
  }

  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);

  if (bytes.length - offset < 10 || !(0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, ID3, {
    offset: offset
  })) {
    return offset;
  }

  offset += getId3Size(bytes, offset); // recursive check for id3 tags as some files
  // have multiple ID3 tag sections even though
  // they should not.

  return getId3Offset(bytes, offset);
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/media-groups.js":
/*!************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/media-groups.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   forEachMediaGroup: () => (/* binding */ forEachMediaGroup)
/* harmony export */ });
/**
 * Loops through all supported media groups in master and calls the provided
 * callback for each group
 *
 * @param {Object} master
 *        The parsed master manifest object
 * @param {string[]} groups
 *        The media groups to call the callback for
 * @param {Function} callback
 *        Callback to call for each media group
 */
var forEachMediaGroup = function forEachMediaGroup(master, groups, callback) {
  groups.forEach(function (mediaType) {
    for (var groupKey in master.mediaGroups[mediaType]) {
      for (var labelKey in master.mediaGroups[mediaType][groupKey]) {
        var mediaProperties = master.mediaGroups[mediaType][groupKey][labelKey];
        callback(mediaProperties, mediaType, groupKey, labelKey);
      }
    }
  });
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/media-types.js":
/*!***********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/media-types.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   simpleTypeFromSourceType: () => (/* binding */ simpleTypeFromSourceType)
/* harmony export */ });
var MPEGURL_REGEX = /^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i;
var DASH_REGEX = /^application\/dash\+xml/i;
/**
 * Returns a string that describes the type of source based on a video source object's
 * media type.
 *
 * @see {@link https://dev.w3.org/html5/pf-summary/video.html#dom-source-type|Source Type}
 *
 * @param {string} type
 *        Video source object media type
 * @return {('hls'|'dash'|'vhs-json'|null)}
 *         VHS source type string
 */

var simpleTypeFromSourceType = function simpleTypeFromSourceType(type) {
  if (MPEGURL_REGEX.test(type)) {
    return 'hls';
  }

  if (DASH_REGEX.test(type)) {
    return 'dash';
  } // Denotes the special case of a manifest object passed to http-streaming instead of a
  // source URL.
  //
  // See https://en.wikipedia.org/wiki/Media_type for details on specifying media types.
  //
  // In this case, vnd stands for vendor, video.js for the organization, VHS for this
  // project, and the +json suffix identifies the structure of the media type.


  if (type === 'application/vnd.videojs.vhs+json') {
    return 'vhs-json';
  }

  return null;
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/mp4-helpers.js":
/*!***********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/mp4-helpers.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addSampleDescription: () => (/* binding */ addSampleDescription),
/* harmony export */   buildFrameTable: () => (/* binding */ buildFrameTable),
/* harmony export */   findBox: () => (/* binding */ findBox),
/* harmony export */   findNamedBox: () => (/* binding */ findNamedBox),
/* harmony export */   parseDescriptors: () => (/* binding */ parseDescriptors),
/* harmony export */   parseMediaInfo: () => (/* binding */ parseMediaInfo),
/* harmony export */   parseTracks: () => (/* binding */ parseTracks)
/* harmony export */ });
/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");
/* harmony import */ var _codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codec-helpers.js */ "./node_modules/@videojs/vhs-utils/es/codec-helpers.js");
/* harmony import */ var _opus_helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./opus-helpers.js */ "./node_modules/@videojs/vhs-utils/es/opus-helpers.js");




var normalizePath = function normalizePath(path) {
  if (typeof path === 'string') {
    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.stringToBytes)(path);
  }

  if (typeof path === 'number') {
    return path;
  }

  return path;
};

var normalizePaths = function normalizePaths(paths) {
  if (!Array.isArray(paths)) {
    return [normalizePath(paths)];
  }

  return paths.map(function (p) {
    return normalizePath(p);
  });
};

var DESCRIPTORS;
var parseDescriptors = function parseDescriptors(bytes) {
  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var results = [];
  var i = 0;

  while (bytes.length > i) {
    var tag = bytes[i];
    var size = 0;
    var headerSize = 0; // tag

    headerSize++;
    var byte = bytes[headerSize]; // first byte

    headerSize++;

    while (byte & 0x80) {
      size = (byte & 0x7F) << 7;
      byte = bytes[headerSize];
      headerSize++;
    }

    size += byte & 0x7F;

    for (var z = 0; z < DESCRIPTORS.length; z++) {
      var _DESCRIPTORS$z = DESCRIPTORS[z],
          id = _DESCRIPTORS$z.id,
          parser = _DESCRIPTORS$z.parser;

      if (tag === id) {
        results.push(parser(bytes.subarray(headerSize, headerSize + size)));
        break;
      }
    }

    i += size + headerSize;
  }

  return results;
};
DESCRIPTORS = [{
  id: 0x03,
  parser: function parser(bytes) {
    var desc = {
      tag: 0x03,
      id: bytes[0] << 8 | bytes[1],
      flags: bytes[2],
      size: 3,
      dependsOnEsId: 0,
      ocrEsId: 0,
      descriptors: [],
      url: ''
    }; // depends on es id

    if (desc.flags & 0x80) {
      desc.dependsOnEsId = bytes[desc.size] << 8 | bytes[desc.size + 1];
      desc.size += 2;
    } // url


    if (desc.flags & 0x40) {
      var len = bytes[desc.size];
      desc.url = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(bytes.subarray(desc.size + 1, desc.size + 1 + len));
      desc.size += len;
    } // ocr es id


    if (desc.flags & 0x20) {
      desc.ocrEsId = bytes[desc.size] << 8 | bytes[desc.size + 1];
      desc.size += 2;
    }

    desc.descriptors = parseDescriptors(bytes.subarray(desc.size)) || [];
    return desc;
  }
}, {
  id: 0x04,
  parser: function parser(bytes) {
    // DecoderConfigDescriptor
    var desc = {
      tag: 0x04,
      oti: bytes[0],
      streamType: bytes[1],
      bufferSize: bytes[2] << 16 | bytes[3] << 8 | bytes[4],
      maxBitrate: bytes[5] << 24 | bytes[6] << 16 | bytes[7] << 8 | bytes[8],
      avgBitrate: bytes[9] << 24 | bytes[10] << 16 | bytes[11] << 8 | bytes[12],
      descriptors: parseDescriptors(bytes.subarray(13))
    };
    return desc;
  }
}, {
  id: 0x05,
  parser: function parser(bytes) {
    // DecoderSpecificInfo
    return {
      tag: 0x05,
      bytes: bytes
    };
  }
}, {
  id: 0x06,
  parser: function parser(bytes) {
    // SLConfigDescriptor
    return {
      tag: 0x06,
      bytes: bytes
    };
  }
}];
/**
 * find any number of boxes by name given a path to it in an iso bmff
 * such as mp4.
 *
 * @param {TypedArray} bytes
 *        bytes for the iso bmff to search for boxes in
 *
 * @param {Uint8Array[]|string[]|string|Uint8Array} name
 *        An array of paths or a single path representing the name
 *        of boxes to search through in bytes. Paths may be
 *        uint8 (character codes) or strings.
 *
 * @param {boolean} [complete=false]
 *        Should we search only for complete boxes on the final path.
 *        This is very useful when you do not want to get back partial boxes
 *        in the case of streaming files.
 *
 * @return {Uint8Array[]}
 *         An array of the end paths that we found.
 */

var findBox = function findBox(bytes, paths, complete) {
  if (complete === void 0) {
    complete = false;
  }

  paths = normalizePaths(paths);
  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var results = [];

  if (!paths.length) {
    // short-circuit the search for empty paths
    return results;
  }

  var i = 0;

  while (i < bytes.length) {
    var size = (bytes[i] << 24 | bytes[i + 1] << 16 | bytes[i + 2] << 8 | bytes[i + 3]) >>> 0;
    var type = bytes.subarray(i + 4, i + 8); // invalid box format.

    if (size === 0) {
      break;
    }

    var end = i + size;

    if (end > bytes.length) {
      // this box is bigger than the number of bytes we have
      // and complete is set, we cannot find any more boxes.
      if (complete) {
        break;
      }

      end = bytes.length;
    }

    var data = bytes.subarray(i + 8, end);

    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(type, paths[0])) {
      if (paths.length === 1) {
        // this is the end of the path and we've found the box we were
        // looking for
        results.push(data);
      } else {
        // recursively search for the next box along the path
        results.push.apply(results, findBox(data, paths.slice(1), complete));
      }
    }

    i = end;
  } // we've finished searching all of bytes


  return results;
};
/**
 * Search for a single matching box by name in an iso bmff format like
 * mp4. This function is useful for finding codec boxes which
 * can be placed arbitrarily in sample descriptions depending
 * on the version of the file or file type.
 *
 * @param {TypedArray} bytes
 *        bytes for the iso bmff to search for boxes in
 *
 * @param {string|Uint8Array} name
 *        The name of the box to find.
 *
 * @return {Uint8Array[]}
 *         a subarray of bytes representing the name boxed we found.
 */

var findNamedBox = function findNamedBox(bytes, name) {
  name = normalizePath(name);

  if (!name.length) {
    // short-circuit the search for empty paths
    return bytes.subarray(bytes.length);
  }

  var i = 0;

  while (i < bytes.length) {
    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i, i + name.length), name)) {
      var size = (bytes[i - 4] << 24 | bytes[i - 3] << 16 | bytes[i - 2] << 8 | bytes[i - 1]) >>> 0;
      var end = size > 1 ? i + size : bytes.byteLength;
      return bytes.subarray(i + 4, end);
    }

    i++;
  } // we've finished searching all of bytes


  return bytes.subarray(bytes.length);
};

var parseSamples = function parseSamples(data, entrySize, parseEntry) {
  if (entrySize === void 0) {
    entrySize = 4;
  }

  if (parseEntry === void 0) {
    parseEntry = function parseEntry(d) {
      return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(d);
    };
  }

  var entries = [];

  if (!data || !data.length) {
    return entries;
  }

  var entryCount = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(data.subarray(4, 8));

  for (var i = 8; entryCount; i += entrySize, entryCount--) {
    entries.push(parseEntry(data.subarray(i, i + entrySize)));
  }

  return entries;
};

var buildFrameTable = function buildFrameTable(stbl, timescale) {
  var keySamples = parseSamples(findBox(stbl, ['stss'])[0]);
  var chunkOffsets = parseSamples(findBox(stbl, ['stco'])[0]);
  var timeToSamples = parseSamples(findBox(stbl, ['stts'])[0], 8, function (entry) {
    return {
      sampleCount: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(0, 4)),
      sampleDelta: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(4, 8))
    };
  });
  var samplesToChunks = parseSamples(findBox(stbl, ['stsc'])[0], 12, function (entry) {
    return {
      firstChunk: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(0, 4)),
      samplesPerChunk: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(4, 8)),
      sampleDescriptionIndex: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(8, 12))
    };
  });
  var stsz = findBox(stbl, ['stsz'])[0]; // stsz starts with a 4 byte sampleSize which we don't need

  var sampleSizes = parseSamples(stsz && stsz.length && stsz.subarray(4) || null);
  var frames = [];

  for (var chunkIndex = 0; chunkIndex < chunkOffsets.length; chunkIndex++) {
    var samplesInChunk = void 0;

    for (var i = 0; i < samplesToChunks.length; i++) {
      var sampleToChunk = samplesToChunks[i];
      var isThisOne = chunkIndex + 1 >= sampleToChunk.firstChunk && (i + 1 >= samplesToChunks.length || chunkIndex + 1 < samplesToChunks[i + 1].firstChunk);

      if (isThisOne) {
        samplesInChunk = sampleToChunk.samplesPerChunk;
        break;
      }
    }

    var chunkOffset = chunkOffsets[chunkIndex];

    for (var _i = 0; _i < samplesInChunk; _i++) {
      var frameEnd = sampleSizes[frames.length]; // if we don't have key samples every frame is a keyframe

      var keyframe = !keySamples.length;

      if (keySamples.length && keySamples.indexOf(frames.length + 1) !== -1) {
        keyframe = true;
      }

      var frame = {
        keyframe: keyframe,
        start: chunkOffset,
        end: chunkOffset + frameEnd
      };

      for (var k = 0; k < timeToSamples.length; k++) {
        var _timeToSamples$k = timeToSamples[k],
            sampleCount = _timeToSamples$k.sampleCount,
            sampleDelta = _timeToSamples$k.sampleDelta;

        if (frames.length <= sampleCount) {
          // ms to ns
          var lastTimestamp = frames.length ? frames[frames.length - 1].timestamp : 0;
          frame.timestamp = lastTimestamp + sampleDelta / timescale * 1000;
          frame.duration = sampleDelta;
          break;
        }
      }

      frames.push(frame);
      chunkOffset += frameEnd;
    }
  }

  return frames;
};
var addSampleDescription = function addSampleDescription(track, bytes) {
  var codec = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(bytes.subarray(0, 4));

  if (track.type === 'video') {
    track.info = track.info || {};
    track.info.width = bytes[28] << 8 | bytes[29];
    track.info.height = bytes[30] << 8 | bytes[31];
  } else if (track.type === 'audio') {
    track.info = track.info || {};
    track.info.channels = bytes[20] << 8 | bytes[21];
    track.info.bitDepth = bytes[22] << 8 | bytes[23];
    track.info.sampleRate = bytes[28] << 8 | bytes[29];
  }

  if (codec === 'avc1') {
    var avcC = findNamedBox(bytes, 'avcC'); // AVCDecoderConfigurationRecord

    codec += "." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAvcCodec)(avcC);
    track.info.avcC = avcC; // TODO: do we need to parse all this?

    /* {
      configurationVersion: avcC[0],
      profile: avcC[1],
      profileCompatibility: avcC[2],
      level: avcC[3],
      lengthSizeMinusOne: avcC[4] & 0x3
    };
     let spsNalUnitCount = avcC[5] & 0x1F;
    const spsNalUnits = track.info.avc.spsNalUnits = [];
     // past spsNalUnitCount
    let offset = 6;
     while (spsNalUnitCount--) {
      const nalLen = avcC[offset] << 8 | avcC[offset + 1];
       spsNalUnits.push(avcC.subarray(offset + 2, offset + 2 + nalLen));
       offset += nalLen + 2;
    }
    let ppsNalUnitCount = avcC[offset];
    const ppsNalUnits = track.info.avc.ppsNalUnits = [];
     // past ppsNalUnitCount
    offset += 1;
     while (ppsNalUnitCount--) {
      const nalLen = avcC[offset] << 8 | avcC[offset + 1];
       ppsNalUnits.push(avcC.subarray(offset + 2, offset + 2 + nalLen));
       offset += nalLen + 2;
    }*/
    // HEVCDecoderConfigurationRecord
  } else if (codec === 'hvc1' || codec === 'hev1') {
    codec += "." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getHvcCodec)(findNamedBox(bytes, 'hvcC'));
  } else if (codec === 'mp4a' || codec === 'mp4v') {
    var esds = findNamedBox(bytes, 'esds');
    var esDescriptor = parseDescriptors(esds.subarray(4))[0];
    var decoderConfig = esDescriptor && esDescriptor.descriptors.filter(function (_ref) {
      var tag = _ref.tag;
      return tag === 0x04;
    })[0];

    if (decoderConfig) {
      // most codecs do not have a further '.'
      // such as 0xa5 for ac-3 and 0xa6 for e-ac-3
      codec += '.' + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(decoderConfig.oti);

      if (decoderConfig.oti === 0x40) {
        codec += '.' + (decoderConfig.descriptors[0].bytes[0] >> 3).toString();
      } else if (decoderConfig.oti === 0x20) {
        codec += '.' + decoderConfig.descriptors[0].bytes[4].toString();
      } else if (decoderConfig.oti === 0xdd) {
        codec = 'vorbis';
      }
    } else if (track.type === 'audio') {
      codec += '.40.2';
    } else {
      codec += '.20.9';
    }
  } else if (codec === 'av01') {
    // AV1DecoderConfigurationRecord
    codec += "." + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAv1Codec)(findNamedBox(bytes, 'av1C'));
  } else if (codec === 'vp09') {
    // VPCodecConfigurationRecord
    var vpcC = findNamedBox(bytes, 'vpcC'); // https://www.webmproject.org/vp9/mp4/

    var profile = vpcC[0];
    var level = vpcC[1];
    var bitDepth = vpcC[2] >> 4;
    var chromaSubsampling = (vpcC[2] & 0x0F) >> 1;
    var videoFullRangeFlag = (vpcC[2] & 0x0F) >> 3;
    var colourPrimaries = vpcC[3];
    var transferCharacteristics = vpcC[4];
    var matrixCoefficients = vpcC[5];
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(profile, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(chromaSubsampling, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(colourPrimaries, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(transferCharacteristics, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(matrixCoefficients, 2, '0');
    codec += "." + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(videoFullRangeFlag, 2, '0');
  } else if (codec === 'theo') {
    codec = 'theora';
  } else if (codec === 'spex') {
    codec = 'speex';
  } else if (codec === '.mp3') {
    codec = 'mp4a.40.34';
  } else if (codec === 'msVo') {
    codec = 'vorbis';
  } else if (codec === 'Opus') {
    codec = 'opus';
    var dOps = findNamedBox(bytes, 'dOps');
    track.info.opus = (0,_opus_helpers_js__WEBPACK_IMPORTED_MODULE_2__.parseOpusHead)(dOps); // TODO: should this go into the webm code??
    // Firefox requires a codecDelay for opus playback
    // see https://bugzilla.mozilla.org/show_bug.cgi?id=1276238

    track.info.codecDelay = 6500000;
  } else {
    codec = codec.toLowerCase();
  }
  /* eslint-enable */
  // flac, ac-3, ec-3, opus


  track.codec = codec;
};
var parseTracks = function parseTracks(bytes, frameTable) {
  if (frameTable === void 0) {
    frameTable = true;
  }

  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  var traks = findBox(bytes, ['moov', 'trak'], true);
  var tracks = [];
  traks.forEach(function (trak) {
    var track = {
      bytes: trak
    };
    var mdia = findBox(trak, ['mdia'])[0];
    var hdlr = findBox(mdia, ['hdlr'])[0];
    var trakType = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(hdlr.subarray(8, 12));

    if (trakType === 'soun') {
      track.type = 'audio';
    } else if (trakType === 'vide') {
      track.type = 'video';
    } else {
      track.type = trakType;
    }

    var tkhd = findBox(trak, ['tkhd'])[0];

    if (tkhd) {
      var view = new DataView(tkhd.buffer, tkhd.byteOffset, tkhd.byteLength);
      var tkhdVersion = view.getUint8(0);
      track.number = tkhdVersion === 0 ? view.getUint32(12) : view.getUint32(20);
    }

    var mdhd = findBox(mdia, ['mdhd'])[0];

    if (mdhd) {
      // mdhd is a FullBox, meaning it will have its own version as the first byte
      var version = mdhd[0];
      var index = version === 0 ? 12 : 20;
      track.timescale = (mdhd[index] << 24 | mdhd[index + 1] << 16 | mdhd[index + 2] << 8 | mdhd[index + 3]) >>> 0;
    }

    var stbl = findBox(mdia, ['minf', 'stbl'])[0];
    var stsd = findBox(stbl, ['stsd'])[0];
    var descriptionCount = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(stsd.subarray(4, 8));
    var offset = 8; // add codec and codec info

    while (descriptionCount--) {
      var len = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(stsd.subarray(offset, offset + 4));
      var sampleDescriptor = stsd.subarray(offset + 4, offset + 4 + len);
      addSampleDescription(track, sampleDescriptor);
      offset += 4 + len;
    }

    if (frameTable) {
      track.frameTable = buildFrameTable(stbl, track.timescale);
    } // codec has no sub parameters


    tracks.push(track);
  });
  return tracks;
};
var parseMediaInfo = function parseMediaInfo(bytes) {
  var mvhd = findBox(bytes, ['moov', 'mvhd'], true)[0];

  if (!mvhd || !mvhd.length) {
    return;
  }

  var info = {}; // ms to ns
  // mvhd v1 has 8 byte duration and other fields too

  if (mvhd[0] === 1) {
    info.timestampScale = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(20, 24));
    info.duration = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(24, 32));
  } else {
    info.timestampScale = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(12, 16));
    info.duration = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(16, 20));
  }

  info.bytes = mvhd;
  return info;
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/nal-helpers.js":
/*!***********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/nal-helpers.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EMULATION_PREVENTION: () => (/* binding */ EMULATION_PREVENTION),
/* harmony export */   NAL_TYPE_ONE: () => (/* binding */ NAL_TYPE_ONE),
/* harmony export */   NAL_TYPE_TWO: () => (/* binding */ NAL_TYPE_TWO),
/* harmony export */   discardEmulationPreventionBytes: () => (/* binding */ discardEmulationPreventionBytes),
/* harmony export */   findH264Nal: () => (/* binding */ findH264Nal),
/* harmony export */   findH265Nal: () => (/* binding */ findH265Nal),
/* harmony export */   findNal: () => (/* binding */ findNal)
/* harmony export */ });
/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");

var NAL_TYPE_ONE = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x00, 0x01]);
var NAL_TYPE_TWO = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x01]);
var EMULATION_PREVENTION = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x03]);
/**
 * Expunge any "Emulation Prevention" bytes from a "Raw Byte
 * Sequence Payload"
 *
 * @param data {Uint8Array} the bytes of a RBSP from a NAL
 * unit
 * @return {Uint8Array} the RBSP without any Emulation
 * Prevention Bytes
 */

var discardEmulationPreventionBytes = function discardEmulationPreventionBytes(bytes) {
  var positions = [];
  var i = 1; // Find all `Emulation Prevention Bytes`

  while (i < bytes.length - 2) {
    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i, i + 3), EMULATION_PREVENTION)) {
      positions.push(i + 2);
      i++;
    }

    i++;
  } // If no Emulation Prevention Bytes were found just return the original
  // array


  if (positions.length === 0) {
    return bytes;
  } // Create a new array to hold the NAL unit data


  var newLength = bytes.length - positions.length;
  var newData = new Uint8Array(newLength);
  var sourceIndex = 0;

  for (i = 0; i < newLength; sourceIndex++, i++) {
    if (sourceIndex === positions[0]) {
      // Skip this byte
      sourceIndex++; // Remove this position index

      positions.shift();
    }

    newData[i] = bytes[sourceIndex];
  }

  return newData;
};
var findNal = function findNal(bytes, dataType, types, nalLimit) {
  if (nalLimit === void 0) {
    nalLimit = Infinity;
  }

  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);
  types = [].concat(types);
  var i = 0;
  var nalStart;
  var nalsFound = 0; // keep searching until:
  // we reach the end of bytes
  // we reach the maximum number of nals they want to seach
  // NOTE: that we disregard nalLimit when we have found the start
  // of the nal we want so that we can find the end of the nal we want.

  while (i < bytes.length && (nalsFound < nalLimit || nalStart)) {
    var nalOffset = void 0;

    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i), NAL_TYPE_ONE)) {
      nalOffset = 4;
    } else if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i), NAL_TYPE_TWO)) {
      nalOffset = 3;
    } // we are unsynced,
    // find the next nal unit


    if (!nalOffset) {
      i++;
      continue;
    }

    nalsFound++;

    if (nalStart) {
      return discardEmulationPreventionBytes(bytes.subarray(nalStart, i));
    }

    var nalType = void 0;

    if (dataType === 'h264') {
      nalType = bytes[i + nalOffset] & 0x1f;
    } else if (dataType === 'h265') {
      nalType = bytes[i + nalOffset] >> 1 & 0x3f;
    }

    if (types.indexOf(nalType) !== -1) {
      nalStart = i + nalOffset;
    } // nal header is 1 length for h264, and 2 for h265


    i += nalOffset + (dataType === 'h264' ? 1 : 2);
  }

  return bytes.subarray(0, 0);
};
var findH264Nal = function findH264Nal(bytes, type, nalLimit) {
  return findNal(bytes, 'h264', type, nalLimit);
};
var findH265Nal = function findH265Nal(bytes, type, nalLimit) {
  return findNal(bytes, 'h265', type, nalLimit);
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/opus-helpers.js":
/*!************************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/opus-helpers.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OPUS_HEAD: () => (/* binding */ OPUS_HEAD),
/* harmony export */   parseOpusHead: () => (/* binding */ parseOpusHead),
/* harmony export */   setOpusHead: () => (/* binding */ setOpusHead)
/* harmony export */ });
var OPUS_HEAD = new Uint8Array([// O, p, u, s
0x4f, 0x70, 0x75, 0x73, // H, e, a, d
0x48, 0x65, 0x61, 0x64]); // https://wiki.xiph.org/OggOpus
// https://vfrmaniac.fushizen.eu/contents/opus_in_isobmff.html
// https://opus-codec.org/docs/opusfile_api-0.7/structOpusHead.html

var parseOpusHead = function parseOpusHead(bytes) {
  var view = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
  var version = view.getUint8(0); // version 0, from mp4, does not use littleEndian.

  var littleEndian = version !== 0;
  var config = {
    version: version,
    channels: view.getUint8(1),
    preSkip: view.getUint16(2, littleEndian),
    sampleRate: view.getUint32(4, littleEndian),
    outputGain: view.getUint16(8, littleEndian),
    channelMappingFamily: view.getUint8(10)
  };

  if (config.channelMappingFamily > 0 && bytes.length > 10) {
    config.streamCount = view.getUint8(11);
    config.twoChannelStreamCount = view.getUint8(12);
    config.channelMapping = [];

    for (var c = 0; c < config.channels; c++) {
      config.channelMapping.push(view.getUint8(13 + c));
    }
  }

  return config;
};
var setOpusHead = function setOpusHead(config) {
  var size = config.channelMappingFamily <= 0 ? 11 : 12 + config.channels;
  var view = new DataView(new ArrayBuffer(size));
  var littleEndian = config.version !== 0;
  view.setUint8(0, config.version);
  view.setUint8(1, config.channels);
  view.setUint16(2, config.preSkip, littleEndian);
  view.setUint32(4, config.sampleRate, littleEndian);
  view.setUint16(8, config.outputGain, littleEndian);
  view.setUint8(10, config.channelMappingFamily);

  if (config.channelMappingFamily > 0) {
    view.setUint8(11, config.streamCount);
    config.channelMapping.foreach(function (cm, i) {
      view.setUint8(12 + i, cm);
    });
  }

  return new Uint8Array(view.buffer);
};

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/resolve-url.js":
/*!***********************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/resolve-url.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);

var DEFAULT_LOCATION = 'https://example.com';

var resolveUrl = function resolveUrl(baseUrl, relativeUrl) {
  // return early if we don't need to resolve
  if (/^[a-z]+:/i.test(relativeUrl)) {
    return relativeUrl;
  } // if baseUrl is a data URI, ignore it and resolve everything relative to window.location


  if (/^data:/.test(baseUrl)) {
    baseUrl = (global_window__WEBPACK_IMPORTED_MODULE_0___default().location) && (global_window__WEBPACK_IMPORTED_MODULE_0___default().location).href || '';
  }

  var protocolLess = /^\/\//.test(baseUrl); // remove location if window.location isn't available (i.e. we're in node)
  // and if baseUrl isn't an absolute url

  var removeLocation = !(global_window__WEBPACK_IMPORTED_MODULE_0___default().location) && !/\/\//i.test(baseUrl); // if the base URL is relative then combine with the current location

  baseUrl = new (global_window__WEBPACK_IMPORTED_MODULE_0___default().URL)(baseUrl, (global_window__WEBPACK_IMPORTED_MODULE_0___default().location) || DEFAULT_LOCATION);
  var newUrl = new URL(relativeUrl, baseUrl); // if we're a protocol-less url, remove the protocol
  // and if we're location-less, remove the location
  // otherwise, return the url unmodified

  if (removeLocation) {
    return newUrl.href.slice(DEFAULT_LOCATION.length);
  } else if (protocolLess) {
    return newUrl.href.slice(newUrl.protocol.length);
  }

  return newUrl.href;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (resolveUrl);

/***/ }),

/***/ "./node_modules/@videojs/vhs-utils/es/stream.js":
/*!******************************************************!*\
  !*** ./node_modules/@videojs/vhs-utils/es/stream.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Stream)
/* harmony export */ });
/**
 * @file stream.js
 */

/**
 * A lightweight readable stream implemention that handles event dispatching.
 *
 * @class Stream
 */
var Stream = /*#__PURE__*/function () {
  function Stream() {
    this.listeners = {};
  }
  /**
   * Add a listener for a specified event type.
   *
   * @param {string} type the event name
   * @param {Function} listener the callback to be invoked when an event of
   * the specified type occurs
   */


  var _proto = Stream.prototype;

  _proto.on = function on(type, listener) {
    if (!this.listeners[type]) {
      this.listeners[type] = [];
    }

    this.listeners[type].push(listener);
  }
  /**
   * Remove a listener for a specified event type.
   *
   * @param {string} type the event name
   * @param {Function} listener  a function previously registered for this
   * type of event through `on`
   * @return {boolean} if we could turn it off or not
   */
  ;

  _proto.off = function off(type, listener) {
    if (!this.listeners[type]) {
      return false;
    }

    var index = this.listeners[type].indexOf(listener); // TODO: which is better?
    // In Video.js we slice listener functions
    // on trigger so that it does not mess up the order
    // while we loop through.
    //
    // Here we slice on off so that the loop in trigger
    // can continue using it's old reference to loop without
    // messing up the order.

    this.listeners[type] = this.listeners[type].slice(0);
    this.listeners[type].splice(index, 1);
    return index > -1;
  }
  /**
   * Trigger an event of the specified type on this stream. Any additional
   * arguments to this function are passed as parameters to event listeners.
   *
   * @param {string} type the event name
   */
  ;

  _proto.trigger = function trigger(type) {
    var callbacks = this.listeners[type];

    if (!callbacks) {
      return;
    } // Slicing the arguments on every invocation of this method
    // can add a significant amount of overhead. Avoid the
    // intermediate object creation for the common case of a
    // single callback argument


    if (arguments.length === 2) {
      var length = callbacks.length;

      for (var i = 0; i < length; ++i) {
        callbacks[i].call(this, arguments[1]);
      }
    } else {
      var args = Array.prototype.slice.call(arguments, 1);
      var _length = callbacks.length;

      for (var _i = 0; _i < _length; ++_i) {
        callbacks[_i].apply(this, args);
      }
    }
  }
  /**
   * Destroys the stream and cleans up.
   */
  ;

  _proto.dispose = function dispose() {
    this.listeners = {};
  }
  /**
   * Forwards all `data` events on this stream to the destination stream. The
   * destination stream should provide a method `push` to receive the data
   * events as they arrive.
   *
   * @param {Stream} destination the stream that will receive all `data` events
   * @see http://nodejs.org/api/stream.html#stream_readable_pipe_destination_options
   */
  ;

  _proto.pipe = function pipe(destination) {
    this.on('data', function (data) {
      destination.push(data);
    });
  };

  return Stream;
}();



/***/ }),

/***/ "./node_modules/@videojs/xhr/lib/http-handler.js":
/*!*******************************************************!*\
  !*** ./node_modules/@videojs/xhr/lib/http-handler.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var window = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");

var httpResponseHandler = function httpResponseHandler(callback, decodeResponseBody) {
  if (decodeResponseBody === void 0) {
    decodeResponseBody = false;
  }

  return function (err, response, responseBody) {
    // if the XHR failed, return that error
    if (err) {
      callback(err);
      return;
    } // if the HTTP status code is 4xx or 5xx, the request also failed


    if (response.statusCode >= 400 && response.statusCode <= 599) {
      var cause = responseBody;

      if (decodeResponseBody) {
        if (window.TextDecoder) {
          var charset = getCharset(response.headers && response.headers['content-type']);

          try {
            cause = new TextDecoder(charset).decode(responseBody);
          } catch (e) {}
        } else {
          cause = String.fromCharCode.apply(null, new Uint8Array(responseBody));
        }
      }

      callback({
        cause: cause
      });
      return;
    } // otherwise, request succeeded


    callback(null, responseBody);
  };
};

function getCharset(contentTypeHeader) {
  if (contentTypeHeader === void 0) {
    contentTypeHeader = '';
  }

  return contentTypeHeader.toLowerCase().split(';').reduce(function (charset, contentType) {
    var _contentType$split = contentType.split('='),
        type = _contentType$split[0],
        value = _contentType$split[1];

    if (type.trim() === 'charset') {
      return value.trim();
    }

    return charset;
  }, 'utf-8');
}

module.exports = httpResponseHandler;

/***/ }),

/***/ "./node_modules/@videojs/xhr/lib/index.js":
/*!************************************************!*\
  !*** ./node_modules/@videojs/xhr/lib/index.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var window = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");

var _extends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/extends.js");

var isFunction = __webpack_require__(/*! is-function */ "./node_modules/is-function/index.js");

var InterceptorsStorage = __webpack_require__(/*! ./interceptors.js */ "./node_modules/@videojs/xhr/lib/interceptors.js");

var RetryManager = __webpack_require__(/*! ./retry.js */ "./node_modules/@videojs/xhr/lib/retry.js");

createXHR.httpHandler = __webpack_require__(/*! ./http-handler.js */ "./node_modules/@videojs/xhr/lib/http-handler.js");
createXHR.requestInterceptorsStorage = new InterceptorsStorage();
createXHR.responseInterceptorsStorage = new InterceptorsStorage();
createXHR.retryManager = new RetryManager();
/**
 * @license
 * slighly modified parse-headers 2.0.2 <https://github.com/kesla/parse-headers/>
 * Copyright (c) 2014 David Björklund
 * Available under the MIT license
 * <https://github.com/kesla/parse-headers/blob/master/LICENCE>
 */

var parseHeaders = function parseHeaders(headers) {
  var result = {};

  if (!headers) {
    return result;
  }

  headers.trim().split('\n').forEach(function (row) {
    var index = row.indexOf(':');
    var key = row.slice(0, index).trim().toLowerCase();
    var value = row.slice(index + 1).trim();

    if (typeof result[key] === 'undefined') {
      result[key] = value;
    } else if (Array.isArray(result[key])) {
      result[key].push(value);
    } else {
      result[key] = [result[key], value];
    }
  });
  return result;
};

module.exports = createXHR; // Allow use of default import syntax in TypeScript

module.exports["default"] = createXHR;
createXHR.XMLHttpRequest = window.XMLHttpRequest || noop;
createXHR.XDomainRequest = "withCredentials" in new createXHR.XMLHttpRequest() ? createXHR.XMLHttpRequest : window.XDomainRequest;
forEachArray(["get", "put", "post", "patch", "head", "delete"], function (method) {
  createXHR[method === "delete" ? "del" : method] = function (uri, options, callback) {
    options = initParams(uri, options, callback);
    options.method = method.toUpperCase();
    return _createXHR(options);
  };
});

function forEachArray(array, iterator) {
  for (var i = 0; i < array.length; i++) {
    iterator(array[i]);
  }
}

function isEmpty(obj) {
  for (var i in obj) {
    if (obj.hasOwnProperty(i)) return false;
  }

  return true;
}

function initParams(uri, options, callback) {
  var params = uri;

  if (isFunction(options)) {
    callback = options;

    if (typeof uri === "string") {
      params = {
        uri: uri
      };
    }
  } else {
    params = _extends({}, options, {
      uri: uri
    });
  }

  params.callback = callback;
  return params;
}

function createXHR(uri, options, callback) {
  options = initParams(uri, options, callback);
  return _createXHR(options);
}

function _createXHR(options) {
  if (typeof options.callback === "undefined") {
    throw new Error("callback argument missing");
  } // call all registered request interceptors for a given request type:


  if (options.requestType && createXHR.requestInterceptorsStorage.getIsEnabled()) {
    var requestInterceptorPayload = {
      uri: options.uri || options.url,
      headers: options.headers || {},
      body: options.body,
      metadata: options.metadata || {},
      retry: options.retry,
      timeout: options.timeout
    };
    var updatedPayload = createXHR.requestInterceptorsStorage.execute(options.requestType, requestInterceptorPayload);
    options.uri = updatedPayload.uri;
    options.headers = updatedPayload.headers;
    options.body = updatedPayload.body;
    options.metadata = updatedPayload.metadata;
    options.retry = updatedPayload.retry;
    options.timeout = updatedPayload.timeout;
  }

  var called = false;

  var callback = function cbOnce(err, response, body) {
    if (!called) {
      called = true;
      options.callback(err, response, body);
    }
  };

  function readystatechange() {
    // do not call load 2 times when response interceptors are enabled
    // why do we even need this 2nd load?
    if (xhr.readyState === 4 && !createXHR.responseInterceptorsStorage.getIsEnabled()) {
      setTimeout(loadFunc, 0);
    }
  }

  function getBody() {
    // Chrome with requestType=blob throws errors arround when even testing access to responseText
    var body = undefined;

    if (xhr.response) {
      body = xhr.response;
    } else {
      body = xhr.responseText || getXml(xhr);
    }

    if (isJson) {
      try {
        body = JSON.parse(body);
      } catch (e) {}
    }

    return body;
  }

  function errorFunc(evt) {
    clearTimeout(timeoutTimer);
    clearTimeout(options.retryTimeout);

    if (!(evt instanceof Error)) {
      evt = new Error("" + (evt || "Unknown XMLHttpRequest Error"));
    }

    evt.statusCode = 0; // we would like to retry on error:

    if (!aborted && createXHR.retryManager.getIsEnabled() && options.retry && options.retry.shouldRetry()) {
      options.retryTimeout = setTimeout(function () {
        options.retry.moveToNextAttempt(); // we want to re-use the same options and the same xhr object:

        options.xhr = xhr;

        _createXHR(options);
      }, options.retry.getCurrentFuzzedDelay());
      return;
    } // call all registered response interceptors for a given request type:


    if (options.requestType && createXHR.responseInterceptorsStorage.getIsEnabled()) {
      var responseInterceptorPayload = {
        headers: failureResponse.headers || {},
        body: failureResponse.body,
        responseUrl: xhr.responseURL,
        responseType: xhr.responseType
      };

      var _updatedPayload = createXHR.responseInterceptorsStorage.execute(options.requestType, responseInterceptorPayload);

      failureResponse.body = _updatedPayload.body;
      failureResponse.headers = _updatedPayload.headers;
    }

    return callback(evt, failureResponse);
  } // will load the data & process the response in a special response object


  function loadFunc() {
    if (aborted) return;
    var status;
    clearTimeout(timeoutTimer);
    clearTimeout(options.retryTimeout);

    if (options.useXDR && xhr.status === undefined) {
      //IE8 CORS GET successful response doesn't have a status field, but body is fine
      status = 200;
    } else {
      status = xhr.status === 1223 ? 204 : xhr.status;
    }

    var response = failureResponse;
    var err = null;

    if (status !== 0) {
      response = {
        body: getBody(),
        statusCode: status,
        method: method,
        headers: {},
        url: uri,
        rawRequest: xhr
      };

      if (xhr.getAllResponseHeaders) {
        //remember xhr can in fact be XDR for CORS in IE
        response.headers = parseHeaders(xhr.getAllResponseHeaders());
      }
    } else {
      err = new Error("Internal XMLHttpRequest Error");
    } // call all registered response interceptors for a given request type:


    if (options.requestType && createXHR.responseInterceptorsStorage.getIsEnabled()) {
      var responseInterceptorPayload = {
        headers: response.headers || {},
        body: response.body,
        responseUrl: xhr.responseURL,
        responseType: xhr.responseType
      };

      var _updatedPayload2 = createXHR.responseInterceptorsStorage.execute(options.requestType, responseInterceptorPayload);

      response.body = _updatedPayload2.body;
      response.headers = _updatedPayload2.headers;
    }

    return callback(err, response, response.body);
  }

  var xhr = options.xhr || null;

  if (!xhr) {
    if (options.cors || options.useXDR) {
      xhr = new createXHR.XDomainRequest();
    } else {
      xhr = new createXHR.XMLHttpRequest();
    }
  }

  var key;
  var aborted;
  var uri = xhr.url = options.uri || options.url;
  var method = xhr.method = options.method || "GET";
  var body = options.body || options.data;
  var headers = xhr.headers = options.headers || {};
  var sync = !!options.sync;
  var isJson = false;
  var timeoutTimer;
  var failureResponse = {
    body: undefined,
    headers: {},
    statusCode: 0,
    method: method,
    url: uri,
    rawRequest: xhr
  };

  if ("json" in options && options.json !== false) {
    isJson = true;
    headers["accept"] || headers["Accept"] || (headers["Accept"] = "application/json"); //Don't override existing accept header declared by user

    if (method !== "GET" && method !== "HEAD") {
      headers["content-type"] || headers["Content-Type"] || (headers["Content-Type"] = "application/json"); //Don't override existing accept header declared by user

      body = JSON.stringify(options.json === true ? body : options.json);
    }
  }

  xhr.onreadystatechange = readystatechange;
  xhr.onload = loadFunc;
  xhr.onerror = errorFunc; // IE9 must have onprogress be set to a unique function.

  xhr.onprogress = function () {// IE must die
  };

  xhr.onabort = function () {
    aborted = true;
    clearTimeout(options.retryTimeout);
  };

  xhr.ontimeout = errorFunc;
  xhr.open(method, uri, !sync, options.username, options.password); //has to be after open

  if (!sync) {
    xhr.withCredentials = !!options.withCredentials;
  } // Cannot set timeout with sync request
  // not setting timeout on the xhr object, because of old webkits etc. not handling that correctly
  // both npm's request and jquery 1.x use this kind of timeout, so this is being consistent


  if (!sync && options.timeout > 0) {
    timeoutTimer = setTimeout(function () {
      if (aborted) return;
      aborted = true; //IE9 may still call readystatechange

      xhr.abort("timeout");
      var e = new Error("XMLHttpRequest timeout");
      e.code = "ETIMEDOUT";
      errorFunc(e);
    }, options.timeout);
  }

  if (xhr.setRequestHeader) {
    for (key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  } else if (options.headers && !isEmpty(options.headers)) {
    throw new Error("Headers cannot be set on an XDomainRequest object");
  }

  if ("responseType" in options) {
    xhr.responseType = options.responseType;
  }

  if ("beforeSend" in options && typeof options.beforeSend === "function") {
    options.beforeSend(xhr);
  } // Microsoft Edge browser sends "undefined" when send is called with undefined value.
  // XMLHttpRequest spec says to pass null as body to indicate no body
  // See https://github.com/naugtur/xhr/issues/100.


  xhr.send(body || null);
  return xhr;
}

function getXml(xhr) {
  // xhr.responseXML will throw Exception "InvalidStateError" or "DOMException"
  // See https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/responseXML.
  try {
    if (xhr.responseType === "document") {
      return xhr.responseXML;
    }

    var firefoxBugTakenEffect = xhr.responseXML && xhr.responseXML.documentElement.nodeName === "parsererror";

    if (xhr.responseType === "" && !firefoxBugTakenEffect) {
      return xhr.responseXML;
    }
  } catch (e) {}

  return null;
}

function noop() {}

/***/ }),

/***/ "./node_modules/@videojs/xhr/lib/interceptors.js":
/*!*******************************************************!*\
  !*** ./node_modules/@videojs/xhr/lib/interceptors.js ***!
  \*******************************************************/
/***/ ((module) => {

"use strict";


function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var InterceptorsStorage = /*#__PURE__*/function () {
  function InterceptorsStorage() {
    this.typeToInterceptorsMap_ = new Map();
    this.enabled_ = false;
  }

  var _proto = InterceptorsStorage.prototype;

  _proto.getIsEnabled = function getIsEnabled() {
    return this.enabled_;
  };

  _proto.enable = function enable() {
    this.enabled_ = true;
  };

  _proto.disable = function disable() {
    this.enabled_ = false;
  };

  _proto.reset = function reset() {
    this.typeToInterceptorsMap_ = new Map();
    this.enabled_ = false;
  };

  _proto.addInterceptor = function addInterceptor(type, interceptor) {
    if (!this.typeToInterceptorsMap_.has(type)) {
      this.typeToInterceptorsMap_.set(type, new Set());
    }

    var interceptorsSet = this.typeToInterceptorsMap_.get(type);

    if (interceptorsSet.has(interceptor)) {
      // already have this interceptor
      return false;
    }

    interceptorsSet.add(interceptor);
    return true;
  };

  _proto.removeInterceptor = function removeInterceptor(type, interceptor) {
    var interceptorsSet = this.typeToInterceptorsMap_.get(type);

    if (interceptorsSet && interceptorsSet.has(interceptor)) {
      interceptorsSet.delete(interceptor);
      return true;
    }

    return false;
  };

  _proto.clearInterceptorsByType = function clearInterceptorsByType(type) {
    var interceptorsSet = this.typeToInterceptorsMap_.get(type);

    if (!interceptorsSet) {
      return false;
    }

    this.typeToInterceptorsMap_.delete(type);
    this.typeToInterceptorsMap_.set(type, new Set());
    return true;
  };

  _proto.clear = function clear() {
    if (!this.typeToInterceptorsMap_.size) {
      return false;
    }

    this.typeToInterceptorsMap_ = new Map();
    return true;
  };

  _proto.getForType = function getForType(type) {
    return this.typeToInterceptorsMap_.get(type) || new Set();
  };

  _proto.execute = function execute(type, payload) {
    var interceptors = this.getForType(type);

    for (var _iterator = _createForOfIteratorHelperLoose(interceptors), _step; !(_step = _iterator()).done;) {
      var interceptor = _step.value;

      try {
        payload = interceptor(payload);
      } catch (e) {//ignore
      }
    }

    return payload;
  };

  return InterceptorsStorage;
}();

module.exports = InterceptorsStorage;

/***/ }),

/***/ "./node_modules/@videojs/xhr/lib/retry.js":
/*!************************************************!*\
  !*** ./node_modules/@videojs/xhr/lib/retry.js ***!
  \************************************************/
/***/ ((module) => {

"use strict";


var RetryManager = /*#__PURE__*/function () {
  function RetryManager() {
    this.maxAttempts_ = 1;
    this.delayFactor_ = 0.1;
    this.fuzzFactor_ = 0.1;
    this.initialDelay_ = 1000;
    this.enabled_ = false;
  }

  var _proto = RetryManager.prototype;

  _proto.getIsEnabled = function getIsEnabled() {
    return this.enabled_;
  };

  _proto.enable = function enable() {
    this.enabled_ = true;
  };

  _proto.disable = function disable() {
    this.enabled_ = false;
  };

  _proto.reset = function reset() {
    this.maxAttempts_ = 1;
    this.delayFactor_ = 0.1;
    this.fuzzFactor_ = 0.1;
    this.initialDelay_ = 1000;
    this.enabled_ = false;
  };

  _proto.getMaxAttempts = function getMaxAttempts() {
    return this.maxAttempts_;
  };

  _proto.setMaxAttempts = function setMaxAttempts(maxAttempts) {
    this.maxAttempts_ = maxAttempts;
  };

  _proto.getDelayFactor = function getDelayFactor() {
    return this.delayFactor_;
  };

  _proto.setDelayFactor = function setDelayFactor(delayFactor) {
    this.delayFactor_ = delayFactor;
  };

  _proto.getFuzzFactor = function getFuzzFactor() {
    return this.fuzzFactor_;
  };

  _proto.setFuzzFactor = function setFuzzFactor(fuzzFactor) {
    this.fuzzFactor_ = fuzzFactor;
  };

  _proto.getInitialDelay = function getInitialDelay() {
    return this.initialDelay_;
  };

  _proto.setInitialDelay = function setInitialDelay(initialDelay) {
    this.initialDelay_ = initialDelay;
  };

  _proto.createRetry = function createRetry(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        maxAttempts = _ref.maxAttempts,
        delayFactor = _ref.delayFactor,
        fuzzFactor = _ref.fuzzFactor,
        initialDelay = _ref.initialDelay;

    return new Retry({
      maxAttempts: maxAttempts || this.maxAttempts_,
      delayFactor: delayFactor || this.delayFactor_,
      fuzzFactor: fuzzFactor || this.fuzzFactor_,
      initialDelay: initialDelay || this.initialDelay_
    });
  };

  return RetryManager;
}();

var Retry = /*#__PURE__*/function () {
  function Retry(options) {
    this.maxAttempts_ = options.maxAttempts;
    this.delayFactor_ = options.delayFactor;
    this.fuzzFactor_ = options.fuzzFactor;
    this.currentDelay_ = options.initialDelay;
    this.currentAttempt_ = 1;
  }

  var _proto2 = Retry.prototype;

  _proto2.moveToNextAttempt = function moveToNextAttempt() {
    this.currentAttempt_++;
    var delayDelta = this.currentDelay_ * this.delayFactor_;
    this.currentDelay_ = this.currentDelay_ + delayDelta;
  };

  _proto2.shouldRetry = function shouldRetry() {
    return this.currentAttempt_ < this.maxAttempts_;
  };

  _proto2.getCurrentDelay = function getCurrentDelay() {
    return this.currentDelay_;
  };

  _proto2.getCurrentMinPossibleDelay = function getCurrentMinPossibleDelay() {
    return (1 - this.fuzzFactor_) * this.currentDelay_;
  };

  _proto2.getCurrentMaxPossibleDelay = function getCurrentMaxPossibleDelay() {
    return (1 + this.fuzzFactor_) * this.currentDelay_;
  }
  /**
   * For example fuzzFactor is 0.1
   * This means ±10% deviation
   * So if we have delay as 1000
   * This function can generate any value from 900 to 1100
   */
  ;

  _proto2.getCurrentFuzzedDelay = function getCurrentFuzzedDelay() {
    var lowValue = this.getCurrentMinPossibleDelay();
    var highValue = this.getCurrentMaxPossibleDelay();
    return lowValue + Math.random() * (highValue - lowValue);
  };

  return Retry;
}();

module.exports = RetryManager;

/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/conventions.js":
/*!********************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/conventions.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


/**
 * Ponyfill for `Array.prototype.find` which is only available in ES6 runtimes.
 *
 * Works with anything that has a `length` property and index access properties, including NodeList.
 *
 * @template {unknown} T
 * @param {Array<T> | ({length:number, [number]: T})} list
 * @param {function (item: T, index: number, list:Array<T> | ({length:number, [number]: T})):boolean} predicate
 * @param {Partial<Pick<ArrayConstructor['prototype'], 'find'>>?} ac `Array.prototype` by default,
 * 				allows injecting a custom implementation in tests
 * @returns {T | undefined}
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find
 * @see https://tc39.es/ecma262/multipage/indexed-collections.html#sec-array.prototype.find
 */
function find(list, predicate, ac) {
	if (ac === undefined) {
		ac = Array.prototype;
	}
	if (list && typeof ac.find === 'function') {
		return ac.find.call(list, predicate);
	}
	for (var i = 0; i < list.length; i++) {
		if (Object.prototype.hasOwnProperty.call(list, i)) {
			var item = list[i];
			if (predicate.call(undefined, item, i, list)) {
				return item;
			}
		}
	}
}

/**
 * "Shallow freezes" an object to render it immutable.
 * Uses `Object.freeze` if available,
 * otherwise the immutability is only in the type.
 *
 * Is used to create "enum like" objects.
 *
 * @template T
 * @param {T} object the object to freeze
 * @param {Pick<ObjectConstructor, 'freeze'> = Object} oc `Object` by default,
 * 				allows to inject custom object constructor for tests
 * @returns {Readonly<T>}
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/freeze
 */
function freeze(object, oc) {
	if (oc === undefined) {
		oc = Object
	}
	return oc && typeof oc.freeze === 'function' ? oc.freeze(object) : object
}

/**
 * Since we can not rely on `Object.assign` we provide a simplified version
 * that is sufficient for our needs.
 *
 * @param {Object} target
 * @param {Object | null | undefined} source
 *
 * @returns {Object} target
 * @throws TypeError if target is not an object
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
 * @see https://tc39.es/ecma262/multipage/fundamental-objects.html#sec-object.assign
 */
function assign(target, source) {
	if (target === null || typeof target !== 'object') {
		throw new TypeError('target is not an object')
	}
	for (var key in source) {
		if (Object.prototype.hasOwnProperty.call(source, key)) {
			target[key] = source[key]
		}
	}
	return target
}

/**
 * All mime types that are allowed as input to `DOMParser.parseFromString`
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString#Argument02 MDN
 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#domparsersupportedtype WHATWG HTML Spec
 * @see DOMParser.prototype.parseFromString
 */
var MIME_TYPE = freeze({
	/**
	 * `text/html`, the only mime type that triggers treating an XML document as HTML.
	 *
	 * @see DOMParser.SupportedType.isHTML
	 * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration
	 * @see https://en.wikipedia.org/wiki/HTML Wikipedia
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN
	 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring WHATWG HTML Spec
	 */
	HTML: 'text/html',

	/**
	 * Helper method to check a mime type if it indicates an HTML document
	 *
	 * @param {string} [value]
	 * @returns {boolean}
	 *
	 * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration
	 * @see https://en.wikipedia.org/wiki/HTML Wikipedia
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN
	 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring 	 */
	isHTML: function (value) {
		return value === MIME_TYPE.HTML
	},

	/**
	 * `application/xml`, the standard mime type for XML documents.
	 *
	 * @see https://www.iana.org/assignments/media-types/application/xml IANA MimeType registration
	 * @see https://tools.ietf.org/html/rfc7303#section-9.1 RFC 7303
	 * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia
	 */
	XML_APPLICATION: 'application/xml',

	/**
	 * `text/html`, an alias for `application/xml`.
	 *
	 * @see https://tools.ietf.org/html/rfc7303#section-9.2 RFC 7303
	 * @see https://www.iana.org/assignments/media-types/text/xml IANA MimeType registration
	 * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia
	 */
	XML_TEXT: 'text/xml',

	/**
	 * `application/xhtml+xml`, indicates an XML document that has the default HTML namespace,
	 * but is parsed as an XML document.
	 *
	 * @see https://www.iana.org/assignments/media-types/application/xhtml+xml IANA MimeType registration
	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument WHATWG DOM Spec
	 * @see https://en.wikipedia.org/wiki/XHTML Wikipedia
	 */
	XML_XHTML_APPLICATION: 'application/xhtml+xml',

	/**
	 * `image/svg+xml`,
	 *
	 * @see https://www.iana.org/assignments/media-types/image/svg+xml IANA MimeType registration
	 * @see https://www.w3.org/TR/SVG11/ W3C SVG 1.1
	 * @see https://en.wikipedia.org/wiki/Scalable_Vector_Graphics Wikipedia
	 */
	XML_SVG_IMAGE: 'image/svg+xml',
})

/**
 * Namespaces that are used in this code base.
 *
 * @see http://www.w3.org/TR/REC-xml-names
 */
var NAMESPACE = freeze({
	/**
	 * The XHTML namespace.
	 *
	 * @see http://www.w3.org/1999/xhtml
	 */
	HTML: 'http://www.w3.org/1999/xhtml',

	/**
	 * Checks if `uri` equals `NAMESPACE.HTML`.
	 *
	 * @param {string} [uri]
	 *
	 * @see NAMESPACE.HTML
	 */
	isHTML: function (uri) {
		return uri === NAMESPACE.HTML
	},

	/**
	 * The SVG namespace.
	 *
	 * @see http://www.w3.org/2000/svg
	 */
	SVG: 'http://www.w3.org/2000/svg',

	/**
	 * The `xml:` namespace.
	 *
	 * @see http://www.w3.org/XML/1998/namespace
	 */
	XML: 'http://www.w3.org/XML/1998/namespace',

	/**
	 * The `xmlns:` namespace
	 *
	 * @see https://www.w3.org/2000/xmlns/
	 */
	XMLNS: 'http://www.w3.org/2000/xmlns/',
})

exports.assign = assign;
exports.find = find;
exports.freeze = freeze;
exports.MIME_TYPE = MIME_TYPE;
exports.NAMESPACE = NAMESPACE;


/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/dom-parser.js":
/*!*******************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/dom-parser.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var conventions = __webpack_require__(/*! ./conventions */ "./node_modules/@xmldom/xmldom/lib/conventions.js");
var dom = __webpack_require__(/*! ./dom */ "./node_modules/@xmldom/xmldom/lib/dom.js")
var entities = __webpack_require__(/*! ./entities */ "./node_modules/@xmldom/xmldom/lib/entities.js");
var sax = __webpack_require__(/*! ./sax */ "./node_modules/@xmldom/xmldom/lib/sax.js");

var DOMImplementation = dom.DOMImplementation;

var NAMESPACE = conventions.NAMESPACE;

var ParseError = sax.ParseError;
var XMLReader = sax.XMLReader;

/**
 * Normalizes line ending according to https://www.w3.org/TR/xml11/#sec-line-ends:
 *
 * > XML parsed entities are often stored in computer files which,
 * > for editing convenience, are organized into lines.
 * > These lines are typically separated by some combination
 * > of the characters CARRIAGE RETURN (#xD) and LINE FEED (#xA).
 * >
 * > To simplify the tasks of applications, the XML processor must behave
 * > as if it normalized all line breaks in external parsed entities (including the document entity)
 * > on input, before parsing, by translating all of the following to a single #xA character:
 * >
 * > 1. the two-character sequence #xD #xA
 * > 2. the two-character sequence #xD #x85
 * > 3. the single character #x85
 * > 4. the single character #x2028
 * > 5. any #xD character that is not immediately followed by #xA or #x85.
 *
 * @param {string} input
 * @returns {string}
 */
function normalizeLineEndings(input) {
	return input
		.replace(/\r[\n\u0085]/g, '\n')
		.replace(/[\r\u0085\u2028]/g, '\n')
}

/**
 * @typedef Locator
 * @property {number} [columnNumber]
 * @property {number} [lineNumber]
 */

/**
 * @typedef DOMParserOptions
 * @property {DOMHandler} [domBuilder]
 * @property {Function} [errorHandler]
 * @property {(string) => string} [normalizeLineEndings] used to replace line endings before parsing
 * 						defaults to `normalizeLineEndings`
 * @property {Locator} [locator]
 * @property {Record<string, string>} [xmlns]
 *
 * @see normalizeLineEndings
 */

/**
 * The DOMParser interface provides the ability to parse XML or HTML source code
 * from a string into a DOM `Document`.
 *
 * _xmldom is different from the spec in that it allows an `options` parameter,
 * to override the default behavior._
 *
 * @param {DOMParserOptions} [options]
 * @constructor
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser
 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-parsing-and-serialization
 */
function DOMParser(options){
	this.options = options ||{locator:{}};
}

DOMParser.prototype.parseFromString = function(source,mimeType){
	var options = this.options;
	var sax =  new XMLReader();
	var domBuilder = options.domBuilder || new DOMHandler();//contentHandler and LexicalHandler
	var errorHandler = options.errorHandler;
	var locator = options.locator;
	var defaultNSMap = options.xmlns||{};
	var isHTML = /\/x?html?$/.test(mimeType);//mimeType.toLowerCase().indexOf('html') > -1;
  	var entityMap = isHTML ? entities.HTML_ENTITIES : entities.XML_ENTITIES;
	if(locator){
		domBuilder.setDocumentLocator(locator)
	}

	sax.errorHandler = buildErrorHandler(errorHandler,domBuilder,locator);
	sax.domBuilder = options.domBuilder || domBuilder;
	if(isHTML){
		defaultNSMap[''] = NAMESPACE.HTML;
	}
	defaultNSMap.xml = defaultNSMap.xml || NAMESPACE.XML;
	var normalize = options.normalizeLineEndings || normalizeLineEndings;
	if (source && typeof source === 'string') {
		sax.parse(
			normalize(source),
			defaultNSMap,
			entityMap
		)
	} else {
		sax.errorHandler.error('invalid doc source')
	}
	return domBuilder.doc;
}
function buildErrorHandler(errorImpl,domBuilder,locator){
	if(!errorImpl){
		if(domBuilder instanceof DOMHandler){
			return domBuilder;
		}
		errorImpl = domBuilder ;
	}
	var errorHandler = {}
	var isCallback = errorImpl instanceof Function;
	locator = locator||{}
	function build(key){
		var fn = errorImpl[key];
		if(!fn && isCallback){
			fn = errorImpl.length == 2?function(msg){errorImpl(key,msg)}:errorImpl;
		}
		errorHandler[key] = fn && function(msg){
			fn('[xmldom '+key+']\t'+msg+_locator(locator));
		}||function(){};
	}
	build('warning');
	build('error');
	build('fatalError');
	return errorHandler;
}

//console.log('#\n\n\n\n\n\n\n####')
/**
 * +ContentHandler+ErrorHandler
 * +LexicalHandler+EntityResolver2
 * -DeclHandler-DTDHandler
 *
 * DefaultHandler:EntityResolver, DTDHandler, ContentHandler, ErrorHandler
 * DefaultHandler2:DefaultHandler,LexicalHandler, DeclHandler, EntityResolver2
 * @link http://www.saxproject.org/apidoc/org/xml/sax/helpers/DefaultHandler.html
 */
function DOMHandler() {
    this.cdata = false;
}
function position(locator,node){
	node.lineNumber = locator.lineNumber;
	node.columnNumber = locator.columnNumber;
}
/**
 * @see org.xml.sax.ContentHandler#startDocument
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ContentHandler.html
 */
DOMHandler.prototype = {
	startDocument : function() {
    	this.doc = new DOMImplementation().createDocument(null, null, null);
    	if (this.locator) {
        	this.doc.documentURI = this.locator.systemId;
    	}
	},
	startElement:function(namespaceURI, localName, qName, attrs) {
		var doc = this.doc;
	    var el = doc.createElementNS(namespaceURI, qName||localName);
	    var len = attrs.length;
	    appendElement(this, el);
	    this.currentElement = el;

		this.locator && position(this.locator,el)
	    for (var i = 0 ; i < len; i++) {
	        var namespaceURI = attrs.getURI(i);
	        var value = attrs.getValue(i);
	        var qName = attrs.getQName(i);
			var attr = doc.createAttributeNS(namespaceURI, qName);
			this.locator &&position(attrs.getLocator(i),attr);
			attr.value = attr.nodeValue = value;
			el.setAttributeNode(attr)
	    }
	},
	endElement:function(namespaceURI, localName, qName) {
		var current = this.currentElement
		var tagName = current.tagName;
		this.currentElement = current.parentNode;
	},
	startPrefixMapping:function(prefix, uri) {
	},
	endPrefixMapping:function(prefix) {
	},
	processingInstruction:function(target, data) {
	    var ins = this.doc.createProcessingInstruction(target, data);
	    this.locator && position(this.locator,ins)
	    appendElement(this, ins);
	},
	ignorableWhitespace:function(ch, start, length) {
	},
	characters:function(chars, start, length) {
		chars = _toString.apply(this,arguments)
		//console.log(chars)
		if(chars){
			if (this.cdata) {
				var charNode = this.doc.createCDATASection(chars);
			} else {
				var charNode = this.doc.createTextNode(chars);
			}
			if(this.currentElement){
				this.currentElement.appendChild(charNode);
			}else if(/^\s*$/.test(chars)){
				this.doc.appendChild(charNode);
				//process xml
			}
			this.locator && position(this.locator,charNode)
		}
	},
	skippedEntity:function(name) {
	},
	endDocument:function() {
		this.doc.normalize();
	},
	setDocumentLocator:function (locator) {
	    if(this.locator = locator){// && !('lineNumber' in locator)){
	    	locator.lineNumber = 0;
	    }
	},
	//LexicalHandler
	comment:function(chars, start, length) {
		chars = _toString.apply(this,arguments)
	    var comm = this.doc.createComment(chars);
	    this.locator && position(this.locator,comm)
	    appendElement(this, comm);
	},

	startCDATA:function() {
	    //used in characters() methods
	    this.cdata = true;
	},
	endCDATA:function() {
	    this.cdata = false;
	},

	startDTD:function(name, publicId, systemId) {
		var impl = this.doc.implementation;
	    if (impl && impl.createDocumentType) {
	        var dt = impl.createDocumentType(name, publicId, systemId);
	        this.locator && position(this.locator,dt)
	        appendElement(this, dt);
					this.doc.doctype = dt;
	    }
	},
	/**
	 * @see org.xml.sax.ErrorHandler
	 * @link http://www.saxproject.org/apidoc/org/xml/sax/ErrorHandler.html
	 */
	warning:function(error) {
		console.warn('[xmldom warning]\t'+error,_locator(this.locator));
	},
	error:function(error) {
		console.error('[xmldom error]\t'+error,_locator(this.locator));
	},
	fatalError:function(error) {
		throw new ParseError(error, this.locator);
	}
}
function _locator(l){
	if(l){
		return '\n@'+(l.systemId ||'')+'#[line:'+l.lineNumber+',col:'+l.columnNumber+']'
	}
}
function _toString(chars,start,length){
	if(typeof chars == 'string'){
		return chars.substr(start,length)
	}else{//java sax connect width xmldom on rhino(what about: "? && !(chars instanceof String)")
		if(chars.length >= start+length || start){
			return new java.lang.String(chars,start,length)+'';
		}
		return chars;
	}
}

/*
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/LexicalHandler.html
 * used method of org.xml.sax.ext.LexicalHandler:
 *  #comment(chars, start, length)
 *  #startCDATA()
 *  #endCDATA()
 *  #startDTD(name, publicId, systemId)
 *
 *
 * IGNORED method of org.xml.sax.ext.LexicalHandler:
 *  #endDTD()
 *  #startEntity(name)
 *  #endEntity(name)
 *
 *
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/DeclHandler.html
 * IGNORED method of org.xml.sax.ext.DeclHandler
 * 	#attributeDecl(eName, aName, type, mode, value)
 *  #elementDecl(name, model)
 *  #externalEntityDecl(name, publicId, systemId)
 *  #internalEntityDecl(name, value)
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/EntityResolver2.html
 * IGNORED method of org.xml.sax.EntityResolver2
 *  #resolveEntity(String name,String publicId,String baseURI,String systemId)
 *  #resolveEntity(publicId, systemId)
 *  #getExternalSubset(name, baseURI)
 * @link http://www.saxproject.org/apidoc/org/xml/sax/DTDHandler.html
 * IGNORED method of org.xml.sax.DTDHandler
 *  #notationDecl(name, publicId, systemId) {};
 *  #unparsedEntityDecl(name, publicId, systemId, notationName) {};
 */
"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(key){
	DOMHandler.prototype[key] = function(){return null}
})

/* Private static helpers treated below as private instance methods, so don't need to add these to the public API; we might use a Relator to also get rid of non-standard public properties */
function appendElement (hander,node) {
    if (!hander.currentElement) {
        hander.doc.appendChild(node);
    } else {
        hander.currentElement.appendChild(node);
    }
}//appendChild and setAttributeNS are preformance key

exports.__DOMHandler = DOMHandler;
exports.normalizeLineEndings = normalizeLineEndings;
exports.DOMParser = DOMParser;


/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/dom.js":
/*!************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/dom.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var conventions = __webpack_require__(/*! ./conventions */ "./node_modules/@xmldom/xmldom/lib/conventions.js");

var find = conventions.find;
var NAMESPACE = conventions.NAMESPACE;

/**
 * A prerequisite for `[].filter`, to drop elements that are empty
 * @param {string} input
 * @returns {boolean}
 */
function notEmptyString (input) {
	return input !== ''
}
/**
 * @see https://infra.spec.whatwg.org/#split-on-ascii-whitespace
 * @see https://infra.spec.whatwg.org/#ascii-whitespace
 *
 * @param {string} input
 * @returns {string[]} (can be empty)
 */
function splitOnASCIIWhitespace(input) {
	// U+0009 TAB, U+000A LF, U+000C FF, U+000D CR, U+0020 SPACE
	return input ? input.split(/[\t\n\f\r ]+/).filter(notEmptyString) : []
}

/**
 * Adds element as a key to current if it is not already present.
 *
 * @param {Record<string, boolean | undefined>} current
 * @param {string} element
 * @returns {Record<string, boolean | undefined>}
 */
function orderedSetReducer (current, element) {
	if (!current.hasOwnProperty(element)) {
		current[element] = true;
	}
	return current;
}

/**
 * @see https://infra.spec.whatwg.org/#ordered-set
 * @param {string} input
 * @returns {string[]}
 */
function toOrderedSet(input) {
	if (!input) return [];
	var list = splitOnASCIIWhitespace(input);
	return Object.keys(list.reduce(orderedSetReducer, {}))
}

/**
 * Uses `list.indexOf` to implement something like `Array.prototype.includes`,
 * which we can not rely on being available.
 *
 * @param {any[]} list
 * @returns {function(any): boolean}
 */
function arrayIncludes (list) {
	return function(element) {
		return list && list.indexOf(element) !== -1;
	}
}

function copy(src,dest){
	for(var p in src){
		if (Object.prototype.hasOwnProperty.call(src, p)) {
			dest[p] = src[p];
		}
	}
}

/**
^\w+\.prototype\.([_\w]+)\s*=\s*((?:.*\{\s*?[\r\n][\s\S]*?^})|\S.*?(?=[;\r\n]));?
^\w+\.prototype\.([_\w]+)\s*=\s*(\S.*?(?=[;\r\n]));?
 */
function _extends(Class,Super){
	var pt = Class.prototype;
	if(!(pt instanceof Super)){
		function t(){};
		t.prototype = Super.prototype;
		t = new t();
		copy(pt,t);
		Class.prototype = pt = t;
	}
	if(pt.constructor != Class){
		if(typeof Class != 'function'){
			console.error("unknown Class:"+Class)
		}
		pt.constructor = Class
	}
}

// Node Types
var NodeType = {}
var ELEMENT_NODE                = NodeType.ELEMENT_NODE                = 1;
var ATTRIBUTE_NODE              = NodeType.ATTRIBUTE_NODE              = 2;
var TEXT_NODE                   = NodeType.TEXT_NODE                   = 3;
var CDATA_SECTION_NODE          = NodeType.CDATA_SECTION_NODE          = 4;
var ENTITY_REFERENCE_NODE       = NodeType.ENTITY_REFERENCE_NODE       = 5;
var ENTITY_NODE                 = NodeType.ENTITY_NODE                 = 6;
var PROCESSING_INSTRUCTION_NODE = NodeType.PROCESSING_INSTRUCTION_NODE = 7;
var COMMENT_NODE                = NodeType.COMMENT_NODE                = 8;
var DOCUMENT_NODE               = NodeType.DOCUMENT_NODE               = 9;
var DOCUMENT_TYPE_NODE          = NodeType.DOCUMENT_TYPE_NODE          = 10;
var DOCUMENT_FRAGMENT_NODE      = NodeType.DOCUMENT_FRAGMENT_NODE      = 11;
var NOTATION_NODE               = NodeType.NOTATION_NODE               = 12;

// ExceptionCode
var ExceptionCode = {}
var ExceptionMessage = {};
var INDEX_SIZE_ERR              = ExceptionCode.INDEX_SIZE_ERR              = ((ExceptionMessage[1]="Index size error"),1);
var DOMSTRING_SIZE_ERR          = ExceptionCode.DOMSTRING_SIZE_ERR          = ((ExceptionMessage[2]="DOMString size error"),2);
var HIERARCHY_REQUEST_ERR       = ExceptionCode.HIERARCHY_REQUEST_ERR       = ((ExceptionMessage[3]="Hierarchy request error"),3);
var WRONG_DOCUMENT_ERR          = ExceptionCode.WRONG_DOCUMENT_ERR          = ((ExceptionMessage[4]="Wrong document"),4);
var INVALID_CHARACTER_ERR       = ExceptionCode.INVALID_CHARACTER_ERR       = ((ExceptionMessage[5]="Invalid character"),5);
var NO_DATA_ALLOWED_ERR         = ExceptionCode.NO_DATA_ALLOWED_ERR         = ((ExceptionMessage[6]="No data allowed"),6);
var NO_MODIFICATION_ALLOWED_ERR = ExceptionCode.NO_MODIFICATION_ALLOWED_ERR = ((ExceptionMessage[7]="No modification allowed"),7);
var NOT_FOUND_ERR               = ExceptionCode.NOT_FOUND_ERR               = ((ExceptionMessage[8]="Not found"),8);
var NOT_SUPPORTED_ERR           = ExceptionCode.NOT_SUPPORTED_ERR           = ((ExceptionMessage[9]="Not supported"),9);
var INUSE_ATTRIBUTE_ERR         = ExceptionCode.INUSE_ATTRIBUTE_ERR         = ((ExceptionMessage[10]="Attribute in use"),10);
//level2
var INVALID_STATE_ERR        	= ExceptionCode.INVALID_STATE_ERR        	= ((ExceptionMessage[11]="Invalid state"),11);
var SYNTAX_ERR               	= ExceptionCode.SYNTAX_ERR               	= ((ExceptionMessage[12]="Syntax error"),12);
var INVALID_MODIFICATION_ERR 	= ExceptionCode.INVALID_MODIFICATION_ERR 	= ((ExceptionMessage[13]="Invalid modification"),13);
var NAMESPACE_ERR            	= ExceptionCode.NAMESPACE_ERR           	= ((ExceptionMessage[14]="Invalid namespace"),14);
var INVALID_ACCESS_ERR       	= ExceptionCode.INVALID_ACCESS_ERR      	= ((ExceptionMessage[15]="Invalid access"),15);

/**
 * DOM Level 2
 * Object DOMException
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html
 * @see http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html
 */
function DOMException(code, message) {
	if(message instanceof Error){
		var error = message;
	}else{
		error = this;
		Error.call(this, ExceptionMessage[code]);
		this.message = ExceptionMessage[code];
		if(Error.captureStackTrace) Error.captureStackTrace(this, DOMException);
	}
	error.code = code;
	if(message) this.message = this.message + ": " + message;
	return error;
};
DOMException.prototype = Error.prototype;
copy(ExceptionCode,DOMException)

/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-536297177
 * The NodeList interface provides the abstraction of an ordered collection of nodes, without defining or constraining how this collection is implemented. NodeList objects in the DOM are live.
 * The items in the NodeList are accessible via an integral index, starting from 0.
 */
function NodeList() {
};
NodeList.prototype = {
	/**
	 * The number of nodes in the list. The range of valid child node indices is 0 to length-1 inclusive.
	 * @standard level1
	 */
	length:0,
	/**
	 * Returns the indexth item in the collection. If index is greater than or equal to the number of nodes in the list, this returns null.
	 * @standard level1
	 * @param index  unsigned long
	 *   Index into the collection.
	 * @return Node
	 * 	The node at the indexth position in the NodeList, or null if that is not a valid index.
	 */
	item: function(index) {
		return index >= 0 && index < this.length ? this[index] : null;
	},
	toString:function(isHTML,nodeFilter){
		for(var buf = [], i = 0;i<this.length;i++){
			serializeToString(this[i],buf,isHTML,nodeFilter);
		}
		return buf.join('');
	},
	/**
	 * @private
	 * @param {function (Node):boolean} predicate
	 * @returns {Node[]}
	 */
	filter: function (predicate) {
		return Array.prototype.filter.call(this, predicate);
	},
	/**
	 * @private
	 * @param {Node} item
	 * @returns {number}
	 */
	indexOf: function (item) {
		return Array.prototype.indexOf.call(this, item);
	},
};

function LiveNodeList(node,refresh){
	this._node = node;
	this._refresh = refresh
	_updateLiveList(this);
}
function _updateLiveList(list){
	var inc = list._node._inc || list._node.ownerDocument._inc;
	if (list._inc !== inc) {
		var ls = list._refresh(list._node);
		__set__(list,'length',ls.length);
		if (!list.$$length || ls.length < list.$$length) {
			for (var i = ls.length; i in list; i++) {
				if (Object.prototype.hasOwnProperty.call(list, i)) {
					delete list[i];
				}
			}
		}
		copy(ls,list);
		list._inc = inc;
	}
}
LiveNodeList.prototype.item = function(i){
	_updateLiveList(this);
	return this[i] || null;
}

_extends(LiveNodeList,NodeList);

/**
 * Objects implementing the NamedNodeMap interface are used
 * to represent collections of nodes that can be accessed by name.
 * Note that NamedNodeMap does not inherit from NodeList;
 * NamedNodeMaps are not maintained in any particular order.
 * Objects contained in an object implementing NamedNodeMap may also be accessed by an ordinal index,
 * but this is simply to allow convenient enumeration of the contents of a NamedNodeMap,
 * and does not imply that the DOM specifies an order to these Nodes.
 * NamedNodeMap objects in the DOM are live.
 * used for attributes or DocumentType entities
 */
function NamedNodeMap() {
};

function _findNodeIndex(list,node){
	var i = list.length;
	while(i--){
		if(list[i] === node){return i}
	}
}

function _addNamedNode(el,list,newAttr,oldAttr){
	if(oldAttr){
		list[_findNodeIndex(list,oldAttr)] = newAttr;
	}else{
		list[list.length++] = newAttr;
	}
	if(el){
		newAttr.ownerElement = el;
		var doc = el.ownerDocument;
		if(doc){
			oldAttr && _onRemoveAttribute(doc,el,oldAttr);
			_onAddAttribute(doc,el,newAttr);
		}
	}
}
function _removeNamedNode(el,list,attr){
	//console.log('remove attr:'+attr)
	var i = _findNodeIndex(list,attr);
	if(i>=0){
		var lastIndex = list.length-1
		while(i<lastIndex){
			list[i] = list[++i]
		}
		list.length = lastIndex;
		if(el){
			var doc = el.ownerDocument;
			if(doc){
				_onRemoveAttribute(doc,el,attr);
				attr.ownerElement = null;
			}
		}
	}else{
		throw new DOMException(NOT_FOUND_ERR,new Error(el.tagName+'@'+attr))
	}
}
NamedNodeMap.prototype = {
	length:0,
	item:NodeList.prototype.item,
	getNamedItem: function(key) {
//		if(key.indexOf(':')>0 || key == 'xmlns'){
//			return null;
//		}
		//console.log()
		var i = this.length;
		while(i--){
			var attr = this[i];
			//console.log(attr.nodeName,key)
			if(attr.nodeName == key){
				return attr;
			}
		}
	},
	setNamedItem: function(attr) {
		var el = attr.ownerElement;
		if(el && el!=this._ownerElement){
			throw new DOMException(INUSE_ATTRIBUTE_ERR);
		}
		var oldAttr = this.getNamedItem(attr.nodeName);
		_addNamedNode(this._ownerElement,this,attr,oldAttr);
		return oldAttr;
	},
	/* returns Node */
	setNamedItemNS: function(attr) {// raises: WRONG_DOCUMENT_ERR,NO_MODIFICATION_ALLOWED_ERR,INUSE_ATTRIBUTE_ERR
		var el = attr.ownerElement, oldAttr;
		if(el && el!=this._ownerElement){
			throw new DOMException(INUSE_ATTRIBUTE_ERR);
		}
		oldAttr = this.getNamedItemNS(attr.namespaceURI,attr.localName);
		_addNamedNode(this._ownerElement,this,attr,oldAttr);
		return oldAttr;
	},

	/* returns Node */
	removeNamedItem: function(key) {
		var attr = this.getNamedItem(key);
		_removeNamedNode(this._ownerElement,this,attr);
		return attr;


	},// raises: NOT_FOUND_ERR,NO_MODIFICATION_ALLOWED_ERR

	//for level2
	removeNamedItemNS:function(namespaceURI,localName){
		var attr = this.getNamedItemNS(namespaceURI,localName);
		_removeNamedNode(this._ownerElement,this,attr);
		return attr;
	},
	getNamedItemNS: function(namespaceURI, localName) {
		var i = this.length;
		while(i--){
			var node = this[i];
			if(node.localName == localName && node.namespaceURI == namespaceURI){
				return node;
			}
		}
		return null;
	}
};

/**
 * The DOMImplementation interface represents an object providing methods
 * which are not dependent on any particular document.
 * Such an object is returned by the `Document.implementation` property.
 *
 * __The individual methods describe the differences compared to the specs.__
 *
 * @constructor
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation MDN
 * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490 DOM Level 1 Core (Initial)
 * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-102161490 DOM Level 2 Core
 * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-102161490 DOM Level 3 Core
 * @see https://dom.spec.whatwg.org/#domimplementation DOM Living Standard
 */
function DOMImplementation() {
}

DOMImplementation.prototype = {
	/**
	 * The DOMImplementation.hasFeature() method returns a Boolean flag indicating if a given feature is supported.
	 * The different implementations fairly diverged in what kind of features were reported.
	 * The latest version of the spec settled to force this method to always return true, where the functionality was accurate and in use.
	 *
	 * @deprecated It is deprecated and modern browsers return true in all cases.
	 *
	 * @param {string} feature
	 * @param {string} [version]
	 * @returns {boolean} always true
	 *
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/hasFeature MDN
	 * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-5CED94D7 DOM Level 1 Core
	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-hasfeature DOM Living Standard
	 */
	hasFeature: function(feature, version) {
			return true;
	},
	/**
	 * Creates an XML Document object of the specified type with its document element.
	 *
	 * __It behaves slightly different from the description in the living standard__:
	 * - There is no interface/class `XMLDocument`, it returns a `Document` instance.
	 * - `contentType`, `encoding`, `mode`, `origin`, `url` fields are currently not declared.
	 * - this implementation is not validating names or qualified names
	 *   (when parsing XML strings, the SAX parser takes care of that)
	 *
	 * @param {string|null} namespaceURI
	 * @param {string} qualifiedName
	 * @param {DocumentType=null} doctype
	 * @returns {Document}
	 *
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocument MDN
	 * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocument DOM Level 2 Core (initial)
	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument  DOM Level 2 Core
	 *
	 * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract
	 * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names
	 * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names
	 */
	createDocument: function(namespaceURI,  qualifiedName, doctype){
		var doc = new Document();
		doc.implementation = this;
		doc.childNodes = new NodeList();
		doc.doctype = doctype || null;
		if (doctype){
			doc.appendChild(doctype);
		}
		if (qualifiedName){
			var root = doc.createElementNS(namespaceURI, qualifiedName);
			doc.appendChild(root);
		}
		return doc;
	},
	/**
	 * Returns a doctype, with the given `qualifiedName`, `publicId`, and `systemId`.
	 *
	 * __This behavior is slightly different from the in the specs__:
	 * - this implementation is not validating names or qualified names
	 *   (when parsing XML strings, the SAX parser takes care of that)
	 *
	 * @param {string} qualifiedName
	 * @param {string} [publicId]
	 * @param {string} [systemId]
	 * @returns {DocumentType} which can either be used with `DOMImplementation.createDocument` upon document creation
	 * 				  or can be put into the document via methods like `Node.insertBefore()` or `Node.replaceChild()`
	 *
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocumentType MDN
	 * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocType DOM Level 2 Core
	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocumenttype DOM Living Standard
	 *
	 * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract
	 * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names
	 * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names
	 */
	createDocumentType: function(qualifiedName, publicId, systemId){
		var node = new DocumentType();
		node.name = qualifiedName;
		node.nodeName = qualifiedName;
		node.publicId = publicId || '';
		node.systemId = systemId || '';

		return node;
	}
};


/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-1950641247
 */

function Node() {
};

Node.prototype = {
	firstChild : null,
	lastChild : null,
	previousSibling : null,
	nextSibling : null,
	attributes : null,
	parentNode : null,
	childNodes : null,
	ownerDocument : null,
	nodeValue : null,
	namespaceURI : null,
	prefix : null,
	localName : null,
	// Modified in DOM Level 2:
	insertBefore:function(newChild, refChild){//raises
		return _insertBefore(this,newChild,refChild);
	},
	replaceChild:function(newChild, oldChild){//raises
		_insertBefore(this, newChild,oldChild, assertPreReplacementValidityInDocument);
		if(oldChild){
			this.removeChild(oldChild);
		}
	},
	removeChild:function(oldChild){
		return _removeChild(this,oldChild);
	},
	appendChild:function(newChild){
		return this.insertBefore(newChild,null);
	},
	hasChildNodes:function(){
		return this.firstChild != null;
	},
	cloneNode:function(deep){
		return cloneNode(this.ownerDocument||this,this,deep);
	},
	// Modified in DOM Level 2:
	normalize:function(){
		var child = this.firstChild;
		while(child){
			var next = child.nextSibling;
			if(next && next.nodeType == TEXT_NODE && child.nodeType == TEXT_NODE){
				this.removeChild(next);
				child.appendData(next.data);
			}else{
				child.normalize();
				child = next;
			}
		}
	},
  	// Introduced in DOM Level 2:
	isSupported:function(feature, version){
		return this.ownerDocument.implementation.hasFeature(feature,version);
	},
    // Introduced in DOM Level 2:
    hasAttributes:function(){
    	return this.attributes.length>0;
    },
	/**
	 * Look up the prefix associated to the given namespace URI, starting from this node.
	 * **The default namespace declarations are ignored by this method.**
	 * See Namespace Prefix Lookup for details on the algorithm used by this method.
	 *
	 * _Note: The implementation seems to be incomplete when compared to the algorithm described in the specs._
	 *
	 * @param {string | null} namespaceURI
	 * @returns {string | null}
	 * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespacePrefix
	 * @see https://www.w3.org/TR/DOM-Level-3-Core/namespaces-algorithms.html#lookupNamespacePrefixAlgo
	 * @see https://dom.spec.whatwg.org/#dom-node-lookupprefix
	 * @see https://github.com/xmldom/xmldom/issues/322
	 */
    lookupPrefix:function(namespaceURI){
    	var el = this;
    	while(el){
    		var map = el._nsMap;
    		//console.dir(map)
    		if(map){
    			for(var n in map){
						if (Object.prototype.hasOwnProperty.call(map, n) && map[n] === namespaceURI) {
							return n;
						}
    			}
    		}
    		el = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;
    	}
    	return null;
    },
    // Introduced in DOM Level 3:
    lookupNamespaceURI:function(prefix){
    	var el = this;
    	while(el){
    		var map = el._nsMap;
    		//console.dir(map)
    		if(map){
    			if(Object.prototype.hasOwnProperty.call(map, prefix)){
    				return map[prefix] ;
    			}
    		}
    		el = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;
    	}
    	return null;
    },
    // Introduced in DOM Level 3:
    isDefaultNamespace:function(namespaceURI){
    	var prefix = this.lookupPrefix(namespaceURI);
    	return prefix == null;
    }
};


function _xmlEncoder(c){
	return c == '<' && '&lt;' ||
         c == '>' && '&gt;' ||
         c == '&' && '&amp;' ||
         c == '"' && '&quot;' ||
         '&#'+c.charCodeAt()+';'
}


copy(NodeType,Node);
copy(NodeType,Node.prototype);

/**
 * @param callback return true for continue,false for break
 * @return boolean true: break visit;
 */
function _visitNode(node,callback){
	if(callback(node)){
		return true;
	}
	if(node = node.firstChild){
		do{
			if(_visitNode(node,callback)){return true}
        }while(node=node.nextSibling)
    }
}



function Document(){
	this.ownerDocument = this;
}

function _onAddAttribute(doc,el,newAttr){
	doc && doc._inc++;
	var ns = newAttr.namespaceURI ;
	if(ns === NAMESPACE.XMLNS){
		//update namespace
		el._nsMap[newAttr.prefix?newAttr.localName:''] = newAttr.value
	}
}

function _onRemoveAttribute(doc,el,newAttr,remove){
	doc && doc._inc++;
	var ns = newAttr.namespaceURI ;
	if(ns === NAMESPACE.XMLNS){
		//update namespace
		delete el._nsMap[newAttr.prefix?newAttr.localName:'']
	}
}

/**
 * Updates `el.childNodes`, updating the indexed items and it's `length`.
 * Passing `newChild` means it will be appended.
 * Otherwise it's assumed that an item has been removed,
 * and `el.firstNode` and it's `.nextSibling` are used
 * to walk the current list of child nodes.
 *
 * @param {Document} doc
 * @param {Node} el
 * @param {Node} [newChild]
 * @private
 */
function _onUpdateChild (doc, el, newChild) {
	if(doc && doc._inc){
		doc._inc++;
		//update childNodes
		var cs = el.childNodes;
		if (newChild) {
			cs[cs.length++] = newChild;
		} else {
			var child = el.firstChild;
			var i = 0;
			while (child) {
				cs[i++] = child;
				child = child.nextSibling;
			}
			cs.length = i;
			delete cs[cs.length];
		}
	}
}

/**
 * Removes the connections between `parentNode` and `child`
 * and any existing `child.previousSibling` or `child.nextSibling`.
 *
 * @see https://github.com/xmldom/xmldom/issues/135
 * @see https://github.com/xmldom/xmldom/issues/145
 *
 * @param {Node} parentNode
 * @param {Node} child
 * @returns {Node} the child that was removed.
 * @private
 */
function _removeChild (parentNode, child) {
	var previous = child.previousSibling;
	var next = child.nextSibling;
	if (previous) {
		previous.nextSibling = next;
	} else {
		parentNode.firstChild = next;
	}
	if (next) {
		next.previousSibling = previous;
	} else {
		parentNode.lastChild = previous;
	}
	child.parentNode = null;
	child.previousSibling = null;
	child.nextSibling = null;
	_onUpdateChild(parentNode.ownerDocument, parentNode);
	return child;
}

/**
 * Returns `true` if `node` can be a parent for insertion.
 * @param {Node} node
 * @returns {boolean}
 */
function hasValidParentNodeType(node) {
	return (
		node &&
		(node.nodeType === Node.DOCUMENT_NODE || node.nodeType === Node.DOCUMENT_FRAGMENT_NODE || node.nodeType === Node.ELEMENT_NODE)
	);
}

/**
 * Returns `true` if `node` can be inserted according to it's `nodeType`.
 * @param {Node} node
 * @returns {boolean}
 */
function hasInsertableNodeType(node) {
	return (
		node &&
		(isElementNode(node) ||
			isTextNode(node) ||
			isDocTypeNode(node) ||
			node.nodeType === Node.DOCUMENT_FRAGMENT_NODE ||
			node.nodeType === Node.COMMENT_NODE ||
			node.nodeType === Node.PROCESSING_INSTRUCTION_NODE)
	);
}

/**
 * Returns true if `node` is a DOCTYPE node
 * @param {Node} node
 * @returns {boolean}
 */
function isDocTypeNode(node) {
	return node && node.nodeType === Node.DOCUMENT_TYPE_NODE;
}

/**
 * Returns true if the node is an element
 * @param {Node} node
 * @returns {boolean}
 */
function isElementNode(node) {
	return node && node.nodeType === Node.ELEMENT_NODE;
}
/**
 * Returns true if `node` is a text node
 * @param {Node} node
 * @returns {boolean}
 */
function isTextNode(node) {
	return node && node.nodeType === Node.TEXT_NODE;
}

/**
 * Check if en element node can be inserted before `child`, or at the end if child is falsy,
 * according to the presence and position of a doctype node on the same level.
 *
 * @param {Document} doc The document node
 * @param {Node} child the node that would become the nextSibling if the element would be inserted
 * @returns {boolean} `true` if an element can be inserted before child
 * @private
 * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 */
function isElementInsertionPossible(doc, child) {
	var parentChildNodes = doc.childNodes || [];
	if (find(parentChildNodes, isElementNode) || isDocTypeNode(child)) {
		return false;
	}
	var docTypeNode = find(parentChildNodes, isDocTypeNode);
	return !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));
}

/**
 * Check if en element node can be inserted before `child`, or at the end if child is falsy,
 * according to the presence and position of a doctype node on the same level.
 *
 * @param {Node} doc The document node
 * @param {Node} child the node that would become the nextSibling if the element would be inserted
 * @returns {boolean} `true` if an element can be inserted before child
 * @private
 * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 */
function isElementReplacementPossible(doc, child) {
	var parentChildNodes = doc.childNodes || [];

	function hasElementChildThatIsNotChild(node) {
		return isElementNode(node) && node !== child;
	}

	if (find(parentChildNodes, hasElementChildThatIsNotChild)) {
		return false;
	}
	var docTypeNode = find(parentChildNodes, isDocTypeNode);
	return !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));
}

/**
 * @private
 * Steps 1-5 of the checks before inserting and before replacing a child are the same.
 *
 * @param {Node} parent the parent node to insert `node` into
 * @param {Node} node the node to insert
 * @param {Node=} child the node that should become the `nextSibling` of `node`
 * @returns {Node}
 * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
 * @throws DOMException if `child` is provided but is not a child of `parent`.
 * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 * @see https://dom.spec.whatwg.org/#concept-node-replace
 */
function assertPreInsertionValidity1to5(parent, node, child) {
	// 1. If `parent` is not a Document, DocumentFragment, or Element node, then throw a "HierarchyRequestError" DOMException.
	if (!hasValidParentNodeType(parent)) {
		throw new DOMException(HIERARCHY_REQUEST_ERR, 'Unexpected parent node type ' + parent.nodeType);
	}
	// 2. If `node` is a host-including inclusive ancestor of `parent`, then throw a "HierarchyRequestError" DOMException.
	// not implemented!
	// 3. If `child` is non-null and its parent is not `parent`, then throw a "NotFoundError" DOMException.
	if (child && child.parentNode !== parent) {
		throw new DOMException(NOT_FOUND_ERR, 'child not in parent');
	}
	if (
		// 4. If `node` is not a DocumentFragment, DocumentType, Element, or CharacterData node, then throw a "HierarchyRequestError" DOMException.
		!hasInsertableNodeType(node) ||
		// 5. If either `node` is a Text node and `parent` is a document,
		// the sax parser currently adds top level text nodes, this will be fixed in 0.9.0
		// || (node.nodeType === Node.TEXT_NODE && parent.nodeType === Node.DOCUMENT_NODE)
		// or `node` is a doctype and `parent` is not a document, then throw a "HierarchyRequestError" DOMException.
		(isDocTypeNode(node) && parent.nodeType !== Node.DOCUMENT_NODE)
	) {
		throw new DOMException(
			HIERARCHY_REQUEST_ERR,
			'Unexpected node type ' + node.nodeType + ' for parent node type ' + parent.nodeType
		);
	}
}

/**
 * @private
 * Step 6 of the checks before inserting and before replacing a child are different.
 *
 * @param {Document} parent the parent node to insert `node` into
 * @param {Node} node the node to insert
 * @param {Node | undefined} child the node that should become the `nextSibling` of `node`
 * @returns {Node}
 * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
 * @throws DOMException if `child` is provided but is not a child of `parent`.
 * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 * @see https://dom.spec.whatwg.org/#concept-node-replace
 */
function assertPreInsertionValidityInDocument(parent, node, child) {
	var parentChildNodes = parent.childNodes || [];
	var nodeChildNodes = node.childNodes || [];

	// DocumentFragment
	if (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {
		var nodeChildElements = nodeChildNodes.filter(isElementNode);
		// If node has more than one element child or has a Text node child.
		if (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');
		}
		// Otherwise, if `node` has one element child and either `parent` has an element child,
		// `child` is a doctype, or `child` is non-null and a doctype is following `child`.
		if (nodeChildElements.length === 1 && !isElementInsertionPossible(parent, child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');
		}
	}
	// Element
	if (isElementNode(node)) {
		// `parent` has an element child, `child` is a doctype,
		// or `child` is non-null and a doctype is following `child`.
		if (!isElementInsertionPossible(parent, child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');
		}
	}
	// DocumentType
	if (isDocTypeNode(node)) {
		// `parent` has a doctype child,
		if (find(parentChildNodes, isDocTypeNode)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');
		}
		var parentElementChild = find(parentChildNodes, isElementNode);
		// `child` is non-null and an element is preceding `child`,
		if (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');
		}
		// or `child` is null and `parent` has an element child.
		if (!child && parentElementChild) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can not be appended since element is present');
		}
	}
}

/**
 * @private
 * Step 6 of the checks before inserting and before replacing a child are different.
 *
 * @param {Document} parent the parent node to insert `node` into
 * @param {Node} node the node to insert
 * @param {Node | undefined} child the node that should become the `nextSibling` of `node`
 * @returns {Node}
 * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
 * @throws DOMException if `child` is provided but is not a child of `parent`.
 * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 * @see https://dom.spec.whatwg.org/#concept-node-replace
 */
function assertPreReplacementValidityInDocument(parent, node, child) {
	var parentChildNodes = parent.childNodes || [];
	var nodeChildNodes = node.childNodes || [];

	// DocumentFragment
	if (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {
		var nodeChildElements = nodeChildNodes.filter(isElementNode);
		// If `node` has more than one element child or has a Text node child.
		if (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');
		}
		// Otherwise, if `node` has one element child and either `parent` has an element child that is not `child` or a doctype is following `child`.
		if (nodeChildElements.length === 1 && !isElementReplacementPossible(parent, child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');
		}
	}
	// Element
	if (isElementNode(node)) {
		// `parent` has an element child that is not `child` or a doctype is following `child`.
		if (!isElementReplacementPossible(parent, child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');
		}
	}
	// DocumentType
	if (isDocTypeNode(node)) {
		function hasDoctypeChildThatIsNotChild(node) {
			return isDocTypeNode(node) && node !== child;
		}

		// `parent` has a doctype child that is not `child`,
		if (find(parentChildNodes, hasDoctypeChildThatIsNotChild)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');
		}
		var parentElementChild = find(parentChildNodes, isElementNode);
		// or an element is preceding `child`.
		if (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {
			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');
		}
	}
}

/**
 * @private
 * @param {Node} parent the parent node to insert `node` into
 * @param {Node} node the node to insert
 * @param {Node=} child the node that should become the `nextSibling` of `node`
 * @returns {Node}
 * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
 * @throws DOMException if `child` is provided but is not a child of `parent`.
 * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
 */
function _insertBefore(parent, node, child, _inDocumentAssertion) {
	// To ensure pre-insertion validity of a node into a parent before a child, run these steps:
	assertPreInsertionValidity1to5(parent, node, child);

	// If parent is a document, and any of the statements below, switched on the interface node implements,
	// are true, then throw a "HierarchyRequestError" DOMException.
	if (parent.nodeType === Node.DOCUMENT_NODE) {
		(_inDocumentAssertion || assertPreInsertionValidityInDocument)(parent, node, child);
	}

	var cp = node.parentNode;
	if(cp){
		cp.removeChild(node);//remove and update
	}
	if(node.nodeType === DOCUMENT_FRAGMENT_NODE){
		var newFirst = node.firstChild;
		if (newFirst == null) {
			return node;
		}
		var newLast = node.lastChild;
	}else{
		newFirst = newLast = node;
	}
	var pre = child ? child.previousSibling : parent.lastChild;

	newFirst.previousSibling = pre;
	newLast.nextSibling = child;


	if(pre){
		pre.nextSibling = newFirst;
	}else{
		parent.firstChild = newFirst;
	}
	if(child == null){
		parent.lastChild = newLast;
	}else{
		child.previousSibling = newLast;
	}
	do{
		newFirst.parentNode = parent;
	}while(newFirst !== newLast && (newFirst= newFirst.nextSibling))
	_onUpdateChild(parent.ownerDocument||parent, parent);
	//console.log(parent.lastChild.nextSibling == null)
	if (node.nodeType == DOCUMENT_FRAGMENT_NODE) {
		node.firstChild = node.lastChild = null;
	}
	return node;
}

/**
 * Appends `newChild` to `parentNode`.
 * If `newChild` is already connected to a `parentNode` it is first removed from it.
 *
 * @see https://github.com/xmldom/xmldom/issues/135
 * @see https://github.com/xmldom/xmldom/issues/145
 * @param {Node} parentNode
 * @param {Node} newChild
 * @returns {Node}
 * @private
 */
function _appendSingleChild (parentNode, newChild) {
	if (newChild.parentNode) {
		newChild.parentNode.removeChild(newChild);
	}
	newChild.parentNode = parentNode;
	newChild.previousSibling = parentNode.lastChild;
	newChild.nextSibling = null;
	if (newChild.previousSibling) {
		newChild.previousSibling.nextSibling = newChild;
	} else {
		parentNode.firstChild = newChild;
	}
	parentNode.lastChild = newChild;
	_onUpdateChild(parentNode.ownerDocument, parentNode, newChild);
	return newChild;
}

Document.prototype = {
	//implementation : null,
	nodeName :  '#document',
	nodeType :  DOCUMENT_NODE,
	/**
	 * The DocumentType node of the document.
	 *
	 * @readonly
	 * @type DocumentType
	 */
	doctype :  null,
	documentElement :  null,
	_inc : 1,

	insertBefore :  function(newChild, refChild){//raises
		if(newChild.nodeType == DOCUMENT_FRAGMENT_NODE){
			var child = newChild.firstChild;
			while(child){
				var next = child.nextSibling;
				this.insertBefore(child,refChild);
				child = next;
			}
			return newChild;
		}
		_insertBefore(this, newChild, refChild);
		newChild.ownerDocument = this;
		if (this.documentElement === null && newChild.nodeType === ELEMENT_NODE) {
			this.documentElement = newChild;
		}

		return newChild;
	},
	removeChild :  function(oldChild){
		if(this.documentElement == oldChild){
			this.documentElement = null;
		}
		return _removeChild(this,oldChild);
	},
	replaceChild: function (newChild, oldChild) {
		//raises
		_insertBefore(this, newChild, oldChild, assertPreReplacementValidityInDocument);
		newChild.ownerDocument = this;
		if (oldChild) {
			this.removeChild(oldChild);
		}
		if (isElementNode(newChild)) {
			this.documentElement = newChild;
		}
	},
	// Introduced in DOM Level 2:
	importNode : function(importedNode,deep){
		return importNode(this,importedNode,deep);
	},
	// Introduced in DOM Level 2:
	getElementById :	function(id){
		var rtv = null;
		_visitNode(this.documentElement,function(node){
			if(node.nodeType == ELEMENT_NODE){
				if(node.getAttribute('id') == id){
					rtv = node;
					return true;
				}
			}
		})
		return rtv;
	},

	/**
	 * The `getElementsByClassName` method of `Document` interface returns an array-like object
	 * of all child elements which have **all** of the given class name(s).
	 *
	 * Returns an empty list if `classeNames` is an empty string or only contains HTML white space characters.
	 *
	 *
	 * Warning: This is a live LiveNodeList.
	 * Changes in the DOM will reflect in the array as the changes occur.
	 * If an element selected by this array no longer qualifies for the selector,
	 * it will automatically be removed. Be aware of this for iteration purposes.
	 *
	 * @param {string} classNames is a string representing the class name(s) to match; multiple class names are separated by (ASCII-)whitespace
	 *
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/getElementsByClassName
	 * @see https://dom.spec.whatwg.org/#concept-getelementsbyclassname
	 */
	getElementsByClassName: function(classNames) {
		var classNamesSet = toOrderedSet(classNames)
		return new LiveNodeList(this, function(base) {
			var ls = [];
			if (classNamesSet.length > 0) {
				_visitNode(base.documentElement, function(node) {
					if(node !== base && node.nodeType === ELEMENT_NODE) {
						var nodeClassNames = node.getAttribute('class')
						// can be null if the attribute does not exist
						if (nodeClassNames) {
							// before splitting and iterating just compare them for the most common case
							var matches = classNames === nodeClassNames;
							if (!matches) {
								var nodeClassNamesSet = toOrderedSet(nodeClassNames)
								matches = classNamesSet.every(arrayIncludes(nodeClassNamesSet))
							}
							if(matches) {
								ls.push(node);
							}
						}
					}
				});
			}
			return ls;
		});
	},

	//document factory method:
	createElement :	function(tagName){
		var node = new Element();
		node.ownerDocument = this;
		node.nodeName = tagName;
		node.tagName = tagName;
		node.localName = tagName;
		node.childNodes = new NodeList();
		var attrs	= node.attributes = new NamedNodeMap();
		attrs._ownerElement = node;
		return node;
	},
	createDocumentFragment :	function(){
		var node = new DocumentFragment();
		node.ownerDocument = this;
		node.childNodes = new NodeList();
		return node;
	},
	createTextNode :	function(data){
		var node = new Text();
		node.ownerDocument = this;
		node.appendData(data)
		return node;
	},
	createComment :	function(data){
		var node = new Comment();
		node.ownerDocument = this;
		node.appendData(data)
		return node;
	},
	createCDATASection :	function(data){
		var node = new CDATASection();
		node.ownerDocument = this;
		node.appendData(data)
		return node;
	},
	createProcessingInstruction :	function(target,data){
		var node = new ProcessingInstruction();
		node.ownerDocument = this;
		node.tagName = node.nodeName = node.target = target;
		node.nodeValue = node.data = data;
		return node;
	},
	createAttribute :	function(name){
		var node = new Attr();
		node.ownerDocument	= this;
		node.name = name;
		node.nodeName	= name;
		node.localName = name;
		node.specified = true;
		return node;
	},
	createEntityReference :	function(name){
		var node = new EntityReference();
		node.ownerDocument	= this;
		node.nodeName	= name;
		return node;
	},
	// Introduced in DOM Level 2:
	createElementNS :	function(namespaceURI,qualifiedName){
		var node = new Element();
		var pl = qualifiedName.split(':');
		var attrs	= node.attributes = new NamedNodeMap();
		node.childNodes = new NodeList();
		node.ownerDocument = this;
		node.nodeName = qualifiedName;
		node.tagName = qualifiedName;
		node.namespaceURI = namespaceURI;
		if(pl.length == 2){
			node.prefix = pl[0];
			node.localName = pl[1];
		}else{
			//el.prefix = null;
			node.localName = qualifiedName;
		}
		attrs._ownerElement = node;
		return node;
	},
	// Introduced in DOM Level 2:
	createAttributeNS :	function(namespaceURI,qualifiedName){
		var node = new Attr();
		var pl = qualifiedName.split(':');
		node.ownerDocument = this;
		node.nodeName = qualifiedName;
		node.name = qualifiedName;
		node.namespaceURI = namespaceURI;
		node.specified = true;
		if(pl.length == 2){
			node.prefix = pl[0];
			node.localName = pl[1];
		}else{
			//el.prefix = null;
			node.localName = qualifiedName;
		}
		return node;
	}
};
_extends(Document,Node);


function Element() {
	this._nsMap = {};
};
Element.prototype = {
	nodeType : ELEMENT_NODE,
	hasAttribute : function(name){
		return this.getAttributeNode(name)!=null;
	},
	getAttribute : function(name){
		var attr = this.getAttributeNode(name);
		return attr && attr.value || '';
	},
	getAttributeNode : function(name){
		return this.attributes.getNamedItem(name);
	},
	setAttribute : function(name, value){
		var attr = this.ownerDocument.createAttribute(name);
		attr.value = attr.nodeValue = "" + value;
		this.setAttributeNode(attr)
	},
	removeAttribute : function(name){
		var attr = this.getAttributeNode(name)
		attr && this.removeAttributeNode(attr);
	},

	//four real opeartion method
	appendChild:function(newChild){
		if(newChild.nodeType === DOCUMENT_FRAGMENT_NODE){
			return this.insertBefore(newChild,null);
		}else{
			return _appendSingleChild(this,newChild);
		}
	},
	setAttributeNode : function(newAttr){
		return this.attributes.setNamedItem(newAttr);
	},
	setAttributeNodeNS : function(newAttr){
		return this.attributes.setNamedItemNS(newAttr);
	},
	removeAttributeNode : function(oldAttr){
		//console.log(this == oldAttr.ownerElement)
		return this.attributes.removeNamedItem(oldAttr.nodeName);
	},
	//get real attribute name,and remove it by removeAttributeNode
	removeAttributeNS : function(namespaceURI, localName){
		var old = this.getAttributeNodeNS(namespaceURI, localName);
		old && this.removeAttributeNode(old);
	},

	hasAttributeNS : function(namespaceURI, localName){
		return this.getAttributeNodeNS(namespaceURI, localName)!=null;
	},
	getAttributeNS : function(namespaceURI, localName){
		var attr = this.getAttributeNodeNS(namespaceURI, localName);
		return attr && attr.value || '';
	},
	setAttributeNS : function(namespaceURI, qualifiedName, value){
		var attr = this.ownerDocument.createAttributeNS(namespaceURI, qualifiedName);
		attr.value = attr.nodeValue = "" + value;
		this.setAttributeNode(attr)
	},
	getAttributeNodeNS : function(namespaceURI, localName){
		return this.attributes.getNamedItemNS(namespaceURI, localName);
	},

	getElementsByTagName : function(tagName){
		return new LiveNodeList(this,function(base){
			var ls = [];
			_visitNode(base,function(node){
				if(node !== base && node.nodeType == ELEMENT_NODE && (tagName === '*' || node.tagName == tagName)){
					ls.push(node);
				}
			});
			return ls;
		});
	},
	getElementsByTagNameNS : function(namespaceURI, localName){
		return new LiveNodeList(this,function(base){
			var ls = [];
			_visitNode(base,function(node){
				if(node !== base && node.nodeType === ELEMENT_NODE && (namespaceURI === '*' || node.namespaceURI === namespaceURI) && (localName === '*' || node.localName == localName)){
					ls.push(node);
				}
			});
			return ls;

		});
	}
};
Document.prototype.getElementsByTagName = Element.prototype.getElementsByTagName;
Document.prototype.getElementsByTagNameNS = Element.prototype.getElementsByTagNameNS;


_extends(Element,Node);
function Attr() {
};
Attr.prototype.nodeType = ATTRIBUTE_NODE;
_extends(Attr,Node);


function CharacterData() {
};
CharacterData.prototype = {
	data : '',
	substringData : function(offset, count) {
		return this.data.substring(offset, offset+count);
	},
	appendData: function(text) {
		text = this.data+text;
		this.nodeValue = this.data = text;
		this.length = text.length;
	},
	insertData: function(offset,text) {
		this.replaceData(offset,0,text);

	},
	appendChild:function(newChild){
		throw new Error(ExceptionMessage[HIERARCHY_REQUEST_ERR])
	},
	deleteData: function(offset, count) {
		this.replaceData(offset,count,"");
	},
	replaceData: function(offset, count, text) {
		var start = this.data.substring(0,offset);
		var end = this.data.substring(offset+count);
		text = start + text + end;
		this.nodeValue = this.data = text;
		this.length = text.length;
	}
}
_extends(CharacterData,Node);
function Text() {
};
Text.prototype = {
	nodeName : "#text",
	nodeType : TEXT_NODE,
	splitText : function(offset) {
		var text = this.data;
		var newText = text.substring(offset);
		text = text.substring(0, offset);
		this.data = this.nodeValue = text;
		this.length = text.length;
		var newNode = this.ownerDocument.createTextNode(newText);
		if(this.parentNode){
			this.parentNode.insertBefore(newNode, this.nextSibling);
		}
		return newNode;
	}
}
_extends(Text,CharacterData);
function Comment() {
};
Comment.prototype = {
	nodeName : "#comment",
	nodeType : COMMENT_NODE
}
_extends(Comment,CharacterData);

function CDATASection() {
};
CDATASection.prototype = {
	nodeName : "#cdata-section",
	nodeType : CDATA_SECTION_NODE
}
_extends(CDATASection,CharacterData);


function DocumentType() {
};
DocumentType.prototype.nodeType = DOCUMENT_TYPE_NODE;
_extends(DocumentType,Node);

function Notation() {
};
Notation.prototype.nodeType = NOTATION_NODE;
_extends(Notation,Node);

function Entity() {
};
Entity.prototype.nodeType = ENTITY_NODE;
_extends(Entity,Node);

function EntityReference() {
};
EntityReference.prototype.nodeType = ENTITY_REFERENCE_NODE;
_extends(EntityReference,Node);

function DocumentFragment() {
};
DocumentFragment.prototype.nodeName =	"#document-fragment";
DocumentFragment.prototype.nodeType =	DOCUMENT_FRAGMENT_NODE;
_extends(DocumentFragment,Node);


function ProcessingInstruction() {
}
ProcessingInstruction.prototype.nodeType = PROCESSING_INSTRUCTION_NODE;
_extends(ProcessingInstruction,Node);
function XMLSerializer(){}
XMLSerializer.prototype.serializeToString = function(node,isHtml,nodeFilter){
	return nodeSerializeToString.call(node,isHtml,nodeFilter);
}
Node.prototype.toString = nodeSerializeToString;
function nodeSerializeToString(isHtml,nodeFilter){
	var buf = [];
	var refNode = this.nodeType == 9 && this.documentElement || this;
	var prefix = refNode.prefix;
	var uri = refNode.namespaceURI;

	if(uri && prefix == null){
		//console.log(prefix)
		var prefix = refNode.lookupPrefix(uri);
		if(prefix == null){
			//isHTML = true;
			var visibleNamespaces=[
			{namespace:uri,prefix:null}
			//{namespace:uri,prefix:''}
			]
		}
	}
	serializeToString(this,buf,isHtml,nodeFilter,visibleNamespaces);
	//console.log('###',this.nodeType,uri,prefix,buf.join(''))
	return buf.join('');
}

function needNamespaceDefine(node, isHTML, visibleNamespaces) {
	var prefix = node.prefix || '';
	var uri = node.namespaceURI;
	// According to [Namespaces in XML 1.0](https://www.w3.org/TR/REC-xml-names/#ns-using) ,
	// and more specifically https://www.w3.org/TR/REC-xml-names/#nsc-NoPrefixUndecl :
	// > In a namespace declaration for a prefix [...], the attribute value MUST NOT be empty.
	// in a similar manner [Namespaces in XML 1.1](https://www.w3.org/TR/xml-names11/#ns-using)
	// and more specifically https://www.w3.org/TR/xml-names11/#nsc-NSDeclared :
	// > [...] Furthermore, the attribute value [...] must not be an empty string.
	// so serializing empty namespace value like xmlns:ds="" would produce an invalid XML document.
	if (!uri) {
		return false;
	}
	if (prefix === "xml" && uri === NAMESPACE.XML || uri === NAMESPACE.XMLNS) {
		return false;
	}

	var i = visibleNamespaces.length
	while (i--) {
		var ns = visibleNamespaces[i];
		// get namespace prefix
		if (ns.prefix === prefix) {
			return ns.namespace !== uri;
		}
	}
	return true;
}
/**
 * Well-formed constraint: No < in Attribute Values
 * > The replacement text of any entity referred to directly or indirectly
 * > in an attribute value must not contain a <.
 * @see https://www.w3.org/TR/xml11/#CleanAttrVals
 * @see https://www.w3.org/TR/xml11/#NT-AttValue
 *
 * Literal whitespace other than space that appear in attribute values
 * are serialized as their entity references, so they will be preserved.
 * (In contrast to whitespace literals in the input which are normalized to spaces)
 * @see https://www.w3.org/TR/xml11/#AVNormalize
 * @see https://w3c.github.io/DOM-Parsing/#serializing-an-element-s-attributes
 */
function addSerializedAttribute(buf, qualifiedName, value) {
	buf.push(' ', qualifiedName, '="', value.replace(/[<>&"\t\n\r]/g, _xmlEncoder), '"')
}

function serializeToString(node,buf,isHTML,nodeFilter,visibleNamespaces){
	if (!visibleNamespaces) {
		visibleNamespaces = [];
	}

	if(nodeFilter){
		node = nodeFilter(node);
		if(node){
			if(typeof node == 'string'){
				buf.push(node);
				return;
			}
		}else{
			return;
		}
		//buf.sort.apply(attrs, attributeSorter);
	}

	switch(node.nodeType){
	case ELEMENT_NODE:
		var attrs = node.attributes;
		var len = attrs.length;
		var child = node.firstChild;
		var nodeName = node.tagName;

		isHTML = NAMESPACE.isHTML(node.namespaceURI) || isHTML

		var prefixedNodeName = nodeName
		if (!isHTML && !node.prefix && node.namespaceURI) {
			var defaultNS
			// lookup current default ns from `xmlns` attribute
			for (var ai = 0; ai < attrs.length; ai++) {
				if (attrs.item(ai).name === 'xmlns') {
					defaultNS = attrs.item(ai).value
					break
				}
			}
			if (!defaultNS) {
				// lookup current default ns in visibleNamespaces
				for (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {
					var namespace = visibleNamespaces[nsi]
					if (namespace.prefix === '' && namespace.namespace === node.namespaceURI) {
						defaultNS = namespace.namespace
						break
					}
				}
			}
			if (defaultNS !== node.namespaceURI) {
				for (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {
					var namespace = visibleNamespaces[nsi]
					if (namespace.namespace === node.namespaceURI) {
						if (namespace.prefix) {
							prefixedNodeName = namespace.prefix + ':' + nodeName
						}
						break
					}
				}
			}
		}

		buf.push('<', prefixedNodeName);

		for(var i=0;i<len;i++){
			// add namespaces for attributes
			var attr = attrs.item(i);
			if (attr.prefix == 'xmlns') {
				visibleNamespaces.push({ prefix: attr.localName, namespace: attr.value });
			}else if(attr.nodeName == 'xmlns'){
				visibleNamespaces.push({ prefix: '', namespace: attr.value });
			}
		}

		for(var i=0;i<len;i++){
			var attr = attrs.item(i);
			if (needNamespaceDefine(attr,isHTML, visibleNamespaces)) {
				var prefix = attr.prefix||'';
				var uri = attr.namespaceURI;
				addSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : "xmlns", uri);
				visibleNamespaces.push({ prefix: prefix, namespace:uri });
			}
			serializeToString(attr,buf,isHTML,nodeFilter,visibleNamespaces);
		}

		// add namespace for current node
		if (nodeName === prefixedNodeName && needNamespaceDefine(node, isHTML, visibleNamespaces)) {
			var prefix = node.prefix||'';
			var uri = node.namespaceURI;
			addSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : "xmlns", uri);
			visibleNamespaces.push({ prefix: prefix, namespace:uri });
		}

		if(child || isHTML && !/^(?:meta|link|img|br|hr|input)$/i.test(nodeName)){
			buf.push('>');
			//if is cdata child node
			if(isHTML && /^script$/i.test(nodeName)){
				while(child){
					if(child.data){
						buf.push(child.data);
					}else{
						serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
					}
					child = child.nextSibling;
				}
			}else
			{
				while(child){
					serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
					child = child.nextSibling;
				}
			}
			buf.push('</',prefixedNodeName,'>');
		}else{
			buf.push('/>');
		}
		// remove added visible namespaces
		//visibleNamespaces.length = startVisibleNamespaces;
		return;
	case DOCUMENT_NODE:
	case DOCUMENT_FRAGMENT_NODE:
		var child = node.firstChild;
		while(child){
			serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
			child = child.nextSibling;
		}
		return;
	case ATTRIBUTE_NODE:
		return addSerializedAttribute(buf, node.name, node.value);
	case TEXT_NODE:
		/**
		 * The ampersand character (&) and the left angle bracket (<) must not appear in their literal form,
		 * except when used as markup delimiters, or within a comment, a processing instruction, or a CDATA section.
		 * If they are needed elsewhere, they must be escaped using either numeric character references or the strings
		 * `&amp;` and `&lt;` respectively.
		 * The right angle bracket (>) may be represented using the string " &gt; ", and must, for compatibility,
		 * be escaped using either `&gt;` or a character reference when it appears in the string `]]>` in content,
		 * when that string is not marking the end of a CDATA section.
		 *
		 * In the content of elements, character data is any string of characters
		 * which does not contain the start-delimiter of any markup
		 * and does not include the CDATA-section-close delimiter, `]]>`.
		 *
		 * @see https://www.w3.org/TR/xml/#NT-CharData
		 * @see https://w3c.github.io/DOM-Parsing/#xml-serializing-a-text-node
		 */
		return buf.push(node.data
			.replace(/[<&>]/g,_xmlEncoder)
		);
	case CDATA_SECTION_NODE:
		return buf.push( '<![CDATA[',node.data,']]>');
	case COMMENT_NODE:
		return buf.push( "<!--",node.data,"-->");
	case DOCUMENT_TYPE_NODE:
		var pubid = node.publicId;
		var sysid = node.systemId;
		buf.push('<!DOCTYPE ',node.name);
		if(pubid){
			buf.push(' PUBLIC ', pubid);
			if (sysid && sysid!='.') {
				buf.push(' ', sysid);
			}
			buf.push('>');
		}else if(sysid && sysid!='.'){
			buf.push(' SYSTEM ', sysid, '>');
		}else{
			var sub = node.internalSubset;
			if(sub){
				buf.push(" [",sub,"]");
			}
			buf.push(">");
		}
		return;
	case PROCESSING_INSTRUCTION_NODE:
		return buf.push( "<?",node.target," ",node.data,"?>");
	case ENTITY_REFERENCE_NODE:
		return buf.push( '&',node.nodeName,';');
	//case ENTITY_NODE:
	//case NOTATION_NODE:
	default:
		buf.push('??',node.nodeName);
	}
}
function importNode(doc,node,deep){
	var node2;
	switch (node.nodeType) {
	case ELEMENT_NODE:
		node2 = node.cloneNode(false);
		node2.ownerDocument = doc;
		//var attrs = node2.attributes;
		//var len = attrs.length;
		//for(var i=0;i<len;i++){
			//node2.setAttributeNodeNS(importNode(doc,attrs.item(i),deep));
		//}
	case DOCUMENT_FRAGMENT_NODE:
		break;
	case ATTRIBUTE_NODE:
		deep = true;
		break;
	//case ENTITY_REFERENCE_NODE:
	//case PROCESSING_INSTRUCTION_NODE:
	////case TEXT_NODE:
	//case CDATA_SECTION_NODE:
	//case COMMENT_NODE:
	//	deep = false;
	//	break;
	//case DOCUMENT_NODE:
	//case DOCUMENT_TYPE_NODE:
	//cannot be imported.
	//case ENTITY_NODE:
	//case NOTATION_NODE：
	//can not hit in level3
	//default:throw e;
	}
	if(!node2){
		node2 = node.cloneNode(false);//false
	}
	node2.ownerDocument = doc;
	node2.parentNode = null;
	if(deep){
		var child = node.firstChild;
		while(child){
			node2.appendChild(importNode(doc,child,deep));
			child = child.nextSibling;
		}
	}
	return node2;
}
//
//var _relationMap = {firstChild:1,lastChild:1,previousSibling:1,nextSibling:1,
//					attributes:1,childNodes:1,parentNode:1,documentElement:1,doctype,};
function cloneNode(doc,node,deep){
	var node2 = new node.constructor();
	for (var n in node) {
		if (Object.prototype.hasOwnProperty.call(node, n)) {
			var v = node[n];
			if (typeof v != "object") {
				if (v != node2[n]) {
					node2[n] = v;
				}
			}
		}
	}
	if(node.childNodes){
		node2.childNodes = new NodeList();
	}
	node2.ownerDocument = doc;
	switch (node2.nodeType) {
	case ELEMENT_NODE:
		var attrs	= node.attributes;
		var attrs2	= node2.attributes = new NamedNodeMap();
		var len = attrs.length
		attrs2._ownerElement = node2;
		for(var i=0;i<len;i++){
			node2.setAttributeNode(cloneNode(doc,attrs.item(i),true));
		}
		break;;
	case ATTRIBUTE_NODE:
		deep = true;
	}
	if(deep){
		var child = node.firstChild;
		while(child){
			node2.appendChild(cloneNode(doc,child,deep));
			child = child.nextSibling;
		}
	}
	return node2;
}

function __set__(object,key,value){
	object[key] = value
}
//do dynamic
try{
	if(Object.defineProperty){
		Object.defineProperty(LiveNodeList.prototype,'length',{
			get:function(){
				_updateLiveList(this);
				return this.$$length;
			}
		});

		Object.defineProperty(Node.prototype,'textContent',{
			get:function(){
				return getTextContent(this);
			},

			set:function(data){
				switch(this.nodeType){
				case ELEMENT_NODE:
				case DOCUMENT_FRAGMENT_NODE:
					while(this.firstChild){
						this.removeChild(this.firstChild);
					}
					if(data || String(data)){
						this.appendChild(this.ownerDocument.createTextNode(data));
					}
					break;

				default:
					this.data = data;
					this.value = data;
					this.nodeValue = data;
				}
			}
		})

		function getTextContent(node){
			switch(node.nodeType){
			case ELEMENT_NODE:
			case DOCUMENT_FRAGMENT_NODE:
				var buf = [];
				node = node.firstChild;
				while(node){
					if(node.nodeType!==7 && node.nodeType !==8){
						buf.push(getTextContent(node));
					}
					node = node.nextSibling;
				}
				return buf.join('');
			default:
				return node.nodeValue;
			}
		}

		__set__ = function(object,key,value){
			//console.log(value)
			object['$$'+key] = value
		}
	}
}catch(e){//ie8
}

//if(typeof require == 'function'){
	exports.DocumentType = DocumentType;
	exports.DOMException = DOMException;
	exports.DOMImplementation = DOMImplementation;
	exports.Element = Element;
	exports.Node = Node;
	exports.NodeList = NodeList;
	exports.XMLSerializer = XMLSerializer;
//}


/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/entities.js":
/*!*****************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/entities.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var freeze = (__webpack_require__(/*! ./conventions */ "./node_modules/@xmldom/xmldom/lib/conventions.js").freeze);

/**
 * The entities that are predefined in every XML document.
 *
 * @see https://www.w3.org/TR/2006/REC-xml11-20060816/#sec-predefined-ent W3C XML 1.1
 * @see https://www.w3.org/TR/2008/REC-xml-20081126/#sec-predefined-ent W3C XML 1.0
 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Predefined_entities_in_XML Wikipedia
 */
exports.XML_ENTITIES = freeze({
	amp: '&',
	apos: "'",
	gt: '>',
	lt: '<',
	quot: '"',
});

/**
 * A map of all entities that are detected in an HTML document.
 * They contain all entries from `XML_ENTITIES`.
 *
 * @see XML_ENTITIES
 * @see DOMParser.parseFromString
 * @see DOMImplementation.prototype.createHTMLDocument
 * @see https://html.spec.whatwg.org/#named-character-references WHATWG HTML(5) Spec
 * @see https://html.spec.whatwg.org/entities.json JSON
 * @see https://www.w3.org/TR/xml-entity-names/ W3C XML Entity Names
 * @see https://www.w3.org/TR/html4/sgml/entities.html W3C HTML4/SGML
 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Character_entity_references_in_HTML Wikipedia (HTML)
 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Entities_representing_special_characters_in_XHTML Wikpedia (XHTML)
 */
exports.HTML_ENTITIES = freeze({
	Aacute: '\u00C1',
	aacute: '\u00E1',
	Abreve: '\u0102',
	abreve: '\u0103',
	ac: '\u223E',
	acd: '\u223F',
	acE: '\u223E\u0333',
	Acirc: '\u00C2',
	acirc: '\u00E2',
	acute: '\u00B4',
	Acy: '\u0410',
	acy: '\u0430',
	AElig: '\u00C6',
	aelig: '\u00E6',
	af: '\u2061',
	Afr: '\uD835\uDD04',
	afr: '\uD835\uDD1E',
	Agrave: '\u00C0',
	agrave: '\u00E0',
	alefsym: '\u2135',
	aleph: '\u2135',
	Alpha: '\u0391',
	alpha: '\u03B1',
	Amacr: '\u0100',
	amacr: '\u0101',
	amalg: '\u2A3F',
	AMP: '\u0026',
	amp: '\u0026',
	And: '\u2A53',
	and: '\u2227',
	andand: '\u2A55',
	andd: '\u2A5C',
	andslope: '\u2A58',
	andv: '\u2A5A',
	ang: '\u2220',
	ange: '\u29A4',
	angle: '\u2220',
	angmsd: '\u2221',
	angmsdaa: '\u29A8',
	angmsdab: '\u29A9',
	angmsdac: '\u29AA',
	angmsdad: '\u29AB',
	angmsdae: '\u29AC',
	angmsdaf: '\u29AD',
	angmsdag: '\u29AE',
	angmsdah: '\u29AF',
	angrt: '\u221F',
	angrtvb: '\u22BE',
	angrtvbd: '\u299D',
	angsph: '\u2222',
	angst: '\u00C5',
	angzarr: '\u237C',
	Aogon: '\u0104',
	aogon: '\u0105',
	Aopf: '\uD835\uDD38',
	aopf: '\uD835\uDD52',
	ap: '\u2248',
	apacir: '\u2A6F',
	apE: '\u2A70',
	ape: '\u224A',
	apid: '\u224B',
	apos: '\u0027',
	ApplyFunction: '\u2061',
	approx: '\u2248',
	approxeq: '\u224A',
	Aring: '\u00C5',
	aring: '\u00E5',
	Ascr: '\uD835\uDC9C',
	ascr: '\uD835\uDCB6',
	Assign: '\u2254',
	ast: '\u002A',
	asymp: '\u2248',
	asympeq: '\u224D',
	Atilde: '\u00C3',
	atilde: '\u00E3',
	Auml: '\u00C4',
	auml: '\u00E4',
	awconint: '\u2233',
	awint: '\u2A11',
	backcong: '\u224C',
	backepsilon: '\u03F6',
	backprime: '\u2035',
	backsim: '\u223D',
	backsimeq: '\u22CD',
	Backslash: '\u2216',
	Barv: '\u2AE7',
	barvee: '\u22BD',
	Barwed: '\u2306',
	barwed: '\u2305',
	barwedge: '\u2305',
	bbrk: '\u23B5',
	bbrktbrk: '\u23B6',
	bcong: '\u224C',
	Bcy: '\u0411',
	bcy: '\u0431',
	bdquo: '\u201E',
	becaus: '\u2235',
	Because: '\u2235',
	because: '\u2235',
	bemptyv: '\u29B0',
	bepsi: '\u03F6',
	bernou: '\u212C',
	Bernoullis: '\u212C',
	Beta: '\u0392',
	beta: '\u03B2',
	beth: '\u2136',
	between: '\u226C',
	Bfr: '\uD835\uDD05',
	bfr: '\uD835\uDD1F',
	bigcap: '\u22C2',
	bigcirc: '\u25EF',
	bigcup: '\u22C3',
	bigodot: '\u2A00',
	bigoplus: '\u2A01',
	bigotimes: '\u2A02',
	bigsqcup: '\u2A06',
	bigstar: '\u2605',
	bigtriangledown: '\u25BD',
	bigtriangleup: '\u25B3',
	biguplus: '\u2A04',
	bigvee: '\u22C1',
	bigwedge: '\u22C0',
	bkarow: '\u290D',
	blacklozenge: '\u29EB',
	blacksquare: '\u25AA',
	blacktriangle: '\u25B4',
	blacktriangledown: '\u25BE',
	blacktriangleleft: '\u25C2',
	blacktriangleright: '\u25B8',
	blank: '\u2423',
	blk12: '\u2592',
	blk14: '\u2591',
	blk34: '\u2593',
	block: '\u2588',
	bne: '\u003D\u20E5',
	bnequiv: '\u2261\u20E5',
	bNot: '\u2AED',
	bnot: '\u2310',
	Bopf: '\uD835\uDD39',
	bopf: '\uD835\uDD53',
	bot: '\u22A5',
	bottom: '\u22A5',
	bowtie: '\u22C8',
	boxbox: '\u29C9',
	boxDL: '\u2557',
	boxDl: '\u2556',
	boxdL: '\u2555',
	boxdl: '\u2510',
	boxDR: '\u2554',
	boxDr: '\u2553',
	boxdR: '\u2552',
	boxdr: '\u250C',
	boxH: '\u2550',
	boxh: '\u2500',
	boxHD: '\u2566',
	boxHd: '\u2564',
	boxhD: '\u2565',
	boxhd: '\u252C',
	boxHU: '\u2569',
	boxHu: '\u2567',
	boxhU: '\u2568',
	boxhu: '\u2534',
	boxminus: '\u229F',
	boxplus: '\u229E',
	boxtimes: '\u22A0',
	boxUL: '\u255D',
	boxUl: '\u255C',
	boxuL: '\u255B',
	boxul: '\u2518',
	boxUR: '\u255A',
	boxUr: '\u2559',
	boxuR: '\u2558',
	boxur: '\u2514',
	boxV: '\u2551',
	boxv: '\u2502',
	boxVH: '\u256C',
	boxVh: '\u256B',
	boxvH: '\u256A',
	boxvh: '\u253C',
	boxVL: '\u2563',
	boxVl: '\u2562',
	boxvL: '\u2561',
	boxvl: '\u2524',
	boxVR: '\u2560',
	boxVr: '\u255F',
	boxvR: '\u255E',
	boxvr: '\u251C',
	bprime: '\u2035',
	Breve: '\u02D8',
	breve: '\u02D8',
	brvbar: '\u00A6',
	Bscr: '\u212C',
	bscr: '\uD835\uDCB7',
	bsemi: '\u204F',
	bsim: '\u223D',
	bsime: '\u22CD',
	bsol: '\u005C',
	bsolb: '\u29C5',
	bsolhsub: '\u27C8',
	bull: '\u2022',
	bullet: '\u2022',
	bump: '\u224E',
	bumpE: '\u2AAE',
	bumpe: '\u224F',
	Bumpeq: '\u224E',
	bumpeq: '\u224F',
	Cacute: '\u0106',
	cacute: '\u0107',
	Cap: '\u22D2',
	cap: '\u2229',
	capand: '\u2A44',
	capbrcup: '\u2A49',
	capcap: '\u2A4B',
	capcup: '\u2A47',
	capdot: '\u2A40',
	CapitalDifferentialD: '\u2145',
	caps: '\u2229\uFE00',
	caret: '\u2041',
	caron: '\u02C7',
	Cayleys: '\u212D',
	ccaps: '\u2A4D',
	Ccaron: '\u010C',
	ccaron: '\u010D',
	Ccedil: '\u00C7',
	ccedil: '\u00E7',
	Ccirc: '\u0108',
	ccirc: '\u0109',
	Cconint: '\u2230',
	ccups: '\u2A4C',
	ccupssm: '\u2A50',
	Cdot: '\u010A',
	cdot: '\u010B',
	cedil: '\u00B8',
	Cedilla: '\u00B8',
	cemptyv: '\u29B2',
	cent: '\u00A2',
	CenterDot: '\u00B7',
	centerdot: '\u00B7',
	Cfr: '\u212D',
	cfr: '\uD835\uDD20',
	CHcy: '\u0427',
	chcy: '\u0447',
	check: '\u2713',
	checkmark: '\u2713',
	Chi: '\u03A7',
	chi: '\u03C7',
	cir: '\u25CB',
	circ: '\u02C6',
	circeq: '\u2257',
	circlearrowleft: '\u21BA',
	circlearrowright: '\u21BB',
	circledast: '\u229B',
	circledcirc: '\u229A',
	circleddash: '\u229D',
	CircleDot: '\u2299',
	circledR: '\u00AE',
	circledS: '\u24C8',
	CircleMinus: '\u2296',
	CirclePlus: '\u2295',
	CircleTimes: '\u2297',
	cirE: '\u29C3',
	cire: '\u2257',
	cirfnint: '\u2A10',
	cirmid: '\u2AEF',
	cirscir: '\u29C2',
	ClockwiseContourIntegral: '\u2232',
	CloseCurlyDoubleQuote: '\u201D',
	CloseCurlyQuote: '\u2019',
	clubs: '\u2663',
	clubsuit: '\u2663',
	Colon: '\u2237',
	colon: '\u003A',
	Colone: '\u2A74',
	colone: '\u2254',
	coloneq: '\u2254',
	comma: '\u002C',
	commat: '\u0040',
	comp: '\u2201',
	compfn: '\u2218',
	complement: '\u2201',
	complexes: '\u2102',
	cong: '\u2245',
	congdot: '\u2A6D',
	Congruent: '\u2261',
	Conint: '\u222F',
	conint: '\u222E',
	ContourIntegral: '\u222E',
	Copf: '\u2102',
	copf: '\uD835\uDD54',
	coprod: '\u2210',
	Coproduct: '\u2210',
	COPY: '\u00A9',
	copy: '\u00A9',
	copysr: '\u2117',
	CounterClockwiseContourIntegral: '\u2233',
	crarr: '\u21B5',
	Cross: '\u2A2F',
	cross: '\u2717',
	Cscr: '\uD835\uDC9E',
	cscr: '\uD835\uDCB8',
	csub: '\u2ACF',
	csube: '\u2AD1',
	csup: '\u2AD0',
	csupe: '\u2AD2',
	ctdot: '\u22EF',
	cudarrl: '\u2938',
	cudarrr: '\u2935',
	cuepr: '\u22DE',
	cuesc: '\u22DF',
	cularr: '\u21B6',
	cularrp: '\u293D',
	Cup: '\u22D3',
	cup: '\u222A',
	cupbrcap: '\u2A48',
	CupCap: '\u224D',
	cupcap: '\u2A46',
	cupcup: '\u2A4A',
	cupdot: '\u228D',
	cupor: '\u2A45',
	cups: '\u222A\uFE00',
	curarr: '\u21B7',
	curarrm: '\u293C',
	curlyeqprec: '\u22DE',
	curlyeqsucc: '\u22DF',
	curlyvee: '\u22CE',
	curlywedge: '\u22CF',
	curren: '\u00A4',
	curvearrowleft: '\u21B6',
	curvearrowright: '\u21B7',
	cuvee: '\u22CE',
	cuwed: '\u22CF',
	cwconint: '\u2232',
	cwint: '\u2231',
	cylcty: '\u232D',
	Dagger: '\u2021',
	dagger: '\u2020',
	daleth: '\u2138',
	Darr: '\u21A1',
	dArr: '\u21D3',
	darr: '\u2193',
	dash: '\u2010',
	Dashv: '\u2AE4',
	dashv: '\u22A3',
	dbkarow: '\u290F',
	dblac: '\u02DD',
	Dcaron: '\u010E',
	dcaron: '\u010F',
	Dcy: '\u0414',
	dcy: '\u0434',
	DD: '\u2145',
	dd: '\u2146',
	ddagger: '\u2021',
	ddarr: '\u21CA',
	DDotrahd: '\u2911',
	ddotseq: '\u2A77',
	deg: '\u00B0',
	Del: '\u2207',
	Delta: '\u0394',
	delta: '\u03B4',
	demptyv: '\u29B1',
	dfisht: '\u297F',
	Dfr: '\uD835\uDD07',
	dfr: '\uD835\uDD21',
	dHar: '\u2965',
	dharl: '\u21C3',
	dharr: '\u21C2',
	DiacriticalAcute: '\u00B4',
	DiacriticalDot: '\u02D9',
	DiacriticalDoubleAcute: '\u02DD',
	DiacriticalGrave: '\u0060',
	DiacriticalTilde: '\u02DC',
	diam: '\u22C4',
	Diamond: '\u22C4',
	diamond: '\u22C4',
	diamondsuit: '\u2666',
	diams: '\u2666',
	die: '\u00A8',
	DifferentialD: '\u2146',
	digamma: '\u03DD',
	disin: '\u22F2',
	div: '\u00F7',
	divide: '\u00F7',
	divideontimes: '\u22C7',
	divonx: '\u22C7',
	DJcy: '\u0402',
	djcy: '\u0452',
	dlcorn: '\u231E',
	dlcrop: '\u230D',
	dollar: '\u0024',
	Dopf: '\uD835\uDD3B',
	dopf: '\uD835\uDD55',
	Dot: '\u00A8',
	dot: '\u02D9',
	DotDot: '\u20DC',
	doteq: '\u2250',
	doteqdot: '\u2251',
	DotEqual: '\u2250',
	dotminus: '\u2238',
	dotplus: '\u2214',
	dotsquare: '\u22A1',
	doublebarwedge: '\u2306',
	DoubleContourIntegral: '\u222F',
	DoubleDot: '\u00A8',
	DoubleDownArrow: '\u21D3',
	DoubleLeftArrow: '\u21D0',
	DoubleLeftRightArrow: '\u21D4',
	DoubleLeftTee: '\u2AE4',
	DoubleLongLeftArrow: '\u27F8',
	DoubleLongLeftRightArrow: '\u27FA',
	DoubleLongRightArrow: '\u27F9',
	DoubleRightArrow: '\u21D2',
	DoubleRightTee: '\u22A8',
	DoubleUpArrow: '\u21D1',
	DoubleUpDownArrow: '\u21D5',
	DoubleVerticalBar: '\u2225',
	DownArrow: '\u2193',
	Downarrow: '\u21D3',
	downarrow: '\u2193',
	DownArrowBar: '\u2913',
	DownArrowUpArrow: '\u21F5',
	DownBreve: '\u0311',
	downdownarrows: '\u21CA',
	downharpoonleft: '\u21C3',
	downharpoonright: '\u21C2',
	DownLeftRightVector: '\u2950',
	DownLeftTeeVector: '\u295E',
	DownLeftVector: '\u21BD',
	DownLeftVectorBar: '\u2956',
	DownRightTeeVector: '\u295F',
	DownRightVector: '\u21C1',
	DownRightVectorBar: '\u2957',
	DownTee: '\u22A4',
	DownTeeArrow: '\u21A7',
	drbkarow: '\u2910',
	drcorn: '\u231F',
	drcrop: '\u230C',
	Dscr: '\uD835\uDC9F',
	dscr: '\uD835\uDCB9',
	DScy: '\u0405',
	dscy: '\u0455',
	dsol: '\u29F6',
	Dstrok: '\u0110',
	dstrok: '\u0111',
	dtdot: '\u22F1',
	dtri: '\u25BF',
	dtrif: '\u25BE',
	duarr: '\u21F5',
	duhar: '\u296F',
	dwangle: '\u29A6',
	DZcy: '\u040F',
	dzcy: '\u045F',
	dzigrarr: '\u27FF',
	Eacute: '\u00C9',
	eacute: '\u00E9',
	easter: '\u2A6E',
	Ecaron: '\u011A',
	ecaron: '\u011B',
	ecir: '\u2256',
	Ecirc: '\u00CA',
	ecirc: '\u00EA',
	ecolon: '\u2255',
	Ecy: '\u042D',
	ecy: '\u044D',
	eDDot: '\u2A77',
	Edot: '\u0116',
	eDot: '\u2251',
	edot: '\u0117',
	ee: '\u2147',
	efDot: '\u2252',
	Efr: '\uD835\uDD08',
	efr: '\uD835\uDD22',
	eg: '\u2A9A',
	Egrave: '\u00C8',
	egrave: '\u00E8',
	egs: '\u2A96',
	egsdot: '\u2A98',
	el: '\u2A99',
	Element: '\u2208',
	elinters: '\u23E7',
	ell: '\u2113',
	els: '\u2A95',
	elsdot: '\u2A97',
	Emacr: '\u0112',
	emacr: '\u0113',
	empty: '\u2205',
	emptyset: '\u2205',
	EmptySmallSquare: '\u25FB',
	emptyv: '\u2205',
	EmptyVerySmallSquare: '\u25AB',
	emsp: '\u2003',
	emsp13: '\u2004',
	emsp14: '\u2005',
	ENG: '\u014A',
	eng: '\u014B',
	ensp: '\u2002',
	Eogon: '\u0118',
	eogon: '\u0119',
	Eopf: '\uD835\uDD3C',
	eopf: '\uD835\uDD56',
	epar: '\u22D5',
	eparsl: '\u29E3',
	eplus: '\u2A71',
	epsi: '\u03B5',
	Epsilon: '\u0395',
	epsilon: '\u03B5',
	epsiv: '\u03F5',
	eqcirc: '\u2256',
	eqcolon: '\u2255',
	eqsim: '\u2242',
	eqslantgtr: '\u2A96',
	eqslantless: '\u2A95',
	Equal: '\u2A75',
	equals: '\u003D',
	EqualTilde: '\u2242',
	equest: '\u225F',
	Equilibrium: '\u21CC',
	equiv: '\u2261',
	equivDD: '\u2A78',
	eqvparsl: '\u29E5',
	erarr: '\u2971',
	erDot: '\u2253',
	Escr: '\u2130',
	escr: '\u212F',
	esdot: '\u2250',
	Esim: '\u2A73',
	esim: '\u2242',
	Eta: '\u0397',
	eta: '\u03B7',
	ETH: '\u00D0',
	eth: '\u00F0',
	Euml: '\u00CB',
	euml: '\u00EB',
	euro: '\u20AC',
	excl: '\u0021',
	exist: '\u2203',
	Exists: '\u2203',
	expectation: '\u2130',
	ExponentialE: '\u2147',
	exponentiale: '\u2147',
	fallingdotseq: '\u2252',
	Fcy: '\u0424',
	fcy: '\u0444',
	female: '\u2640',
	ffilig: '\uFB03',
	fflig: '\uFB00',
	ffllig: '\uFB04',
	Ffr: '\uD835\uDD09',
	ffr: '\uD835\uDD23',
	filig: '\uFB01',
	FilledSmallSquare: '\u25FC',
	FilledVerySmallSquare: '\u25AA',
	fjlig: '\u0066\u006A',
	flat: '\u266D',
	fllig: '\uFB02',
	fltns: '\u25B1',
	fnof: '\u0192',
	Fopf: '\uD835\uDD3D',
	fopf: '\uD835\uDD57',
	ForAll: '\u2200',
	forall: '\u2200',
	fork: '\u22D4',
	forkv: '\u2AD9',
	Fouriertrf: '\u2131',
	fpartint: '\u2A0D',
	frac12: '\u00BD',
	frac13: '\u2153',
	frac14: '\u00BC',
	frac15: '\u2155',
	frac16: '\u2159',
	frac18: '\u215B',
	frac23: '\u2154',
	frac25: '\u2156',
	frac34: '\u00BE',
	frac35: '\u2157',
	frac38: '\u215C',
	frac45: '\u2158',
	frac56: '\u215A',
	frac58: '\u215D',
	frac78: '\u215E',
	frasl: '\u2044',
	frown: '\u2322',
	Fscr: '\u2131',
	fscr: '\uD835\uDCBB',
	gacute: '\u01F5',
	Gamma: '\u0393',
	gamma: '\u03B3',
	Gammad: '\u03DC',
	gammad: '\u03DD',
	gap: '\u2A86',
	Gbreve: '\u011E',
	gbreve: '\u011F',
	Gcedil: '\u0122',
	Gcirc: '\u011C',
	gcirc: '\u011D',
	Gcy: '\u0413',
	gcy: '\u0433',
	Gdot: '\u0120',
	gdot: '\u0121',
	gE: '\u2267',
	ge: '\u2265',
	gEl: '\u2A8C',
	gel: '\u22DB',
	geq: '\u2265',
	geqq: '\u2267',
	geqslant: '\u2A7E',
	ges: '\u2A7E',
	gescc: '\u2AA9',
	gesdot: '\u2A80',
	gesdoto: '\u2A82',
	gesdotol: '\u2A84',
	gesl: '\u22DB\uFE00',
	gesles: '\u2A94',
	Gfr: '\uD835\uDD0A',
	gfr: '\uD835\uDD24',
	Gg: '\u22D9',
	gg: '\u226B',
	ggg: '\u22D9',
	gimel: '\u2137',
	GJcy: '\u0403',
	gjcy: '\u0453',
	gl: '\u2277',
	gla: '\u2AA5',
	glE: '\u2A92',
	glj: '\u2AA4',
	gnap: '\u2A8A',
	gnapprox: '\u2A8A',
	gnE: '\u2269',
	gne: '\u2A88',
	gneq: '\u2A88',
	gneqq: '\u2269',
	gnsim: '\u22E7',
	Gopf: '\uD835\uDD3E',
	gopf: '\uD835\uDD58',
	grave: '\u0060',
	GreaterEqual: '\u2265',
	GreaterEqualLess: '\u22DB',
	GreaterFullEqual: '\u2267',
	GreaterGreater: '\u2AA2',
	GreaterLess: '\u2277',
	GreaterSlantEqual: '\u2A7E',
	GreaterTilde: '\u2273',
	Gscr: '\uD835\uDCA2',
	gscr: '\u210A',
	gsim: '\u2273',
	gsime: '\u2A8E',
	gsiml: '\u2A90',
	Gt: '\u226B',
	GT: '\u003E',
	gt: '\u003E',
	gtcc: '\u2AA7',
	gtcir: '\u2A7A',
	gtdot: '\u22D7',
	gtlPar: '\u2995',
	gtquest: '\u2A7C',
	gtrapprox: '\u2A86',
	gtrarr: '\u2978',
	gtrdot: '\u22D7',
	gtreqless: '\u22DB',
	gtreqqless: '\u2A8C',
	gtrless: '\u2277',
	gtrsim: '\u2273',
	gvertneqq: '\u2269\uFE00',
	gvnE: '\u2269\uFE00',
	Hacek: '\u02C7',
	hairsp: '\u200A',
	half: '\u00BD',
	hamilt: '\u210B',
	HARDcy: '\u042A',
	hardcy: '\u044A',
	hArr: '\u21D4',
	harr: '\u2194',
	harrcir: '\u2948',
	harrw: '\u21AD',
	Hat: '\u005E',
	hbar: '\u210F',
	Hcirc: '\u0124',
	hcirc: '\u0125',
	hearts: '\u2665',
	heartsuit: '\u2665',
	hellip: '\u2026',
	hercon: '\u22B9',
	Hfr: '\u210C',
	hfr: '\uD835\uDD25',
	HilbertSpace: '\u210B',
	hksearow: '\u2925',
	hkswarow: '\u2926',
	hoarr: '\u21FF',
	homtht: '\u223B',
	hookleftarrow: '\u21A9',
	hookrightarrow: '\u21AA',
	Hopf: '\u210D',
	hopf: '\uD835\uDD59',
	horbar: '\u2015',
	HorizontalLine: '\u2500',
	Hscr: '\u210B',
	hscr: '\uD835\uDCBD',
	hslash: '\u210F',
	Hstrok: '\u0126',
	hstrok: '\u0127',
	HumpDownHump: '\u224E',
	HumpEqual: '\u224F',
	hybull: '\u2043',
	hyphen: '\u2010',
	Iacute: '\u00CD',
	iacute: '\u00ED',
	ic: '\u2063',
	Icirc: '\u00CE',
	icirc: '\u00EE',
	Icy: '\u0418',
	icy: '\u0438',
	Idot: '\u0130',
	IEcy: '\u0415',
	iecy: '\u0435',
	iexcl: '\u00A1',
	iff: '\u21D4',
	Ifr: '\u2111',
	ifr: '\uD835\uDD26',
	Igrave: '\u00CC',
	igrave: '\u00EC',
	ii: '\u2148',
	iiiint: '\u2A0C',
	iiint: '\u222D',
	iinfin: '\u29DC',
	iiota: '\u2129',
	IJlig: '\u0132',
	ijlig: '\u0133',
	Im: '\u2111',
	Imacr: '\u012A',
	imacr: '\u012B',
	image: '\u2111',
	ImaginaryI: '\u2148',
	imagline: '\u2110',
	imagpart: '\u2111',
	imath: '\u0131',
	imof: '\u22B7',
	imped: '\u01B5',
	Implies: '\u21D2',
	in: '\u2208',
	incare: '\u2105',
	infin: '\u221E',
	infintie: '\u29DD',
	inodot: '\u0131',
	Int: '\u222C',
	int: '\u222B',
	intcal: '\u22BA',
	integers: '\u2124',
	Integral: '\u222B',
	intercal: '\u22BA',
	Intersection: '\u22C2',
	intlarhk: '\u2A17',
	intprod: '\u2A3C',
	InvisibleComma: '\u2063',
	InvisibleTimes: '\u2062',
	IOcy: '\u0401',
	iocy: '\u0451',
	Iogon: '\u012E',
	iogon: '\u012F',
	Iopf: '\uD835\uDD40',
	iopf: '\uD835\uDD5A',
	Iota: '\u0399',
	iota: '\u03B9',
	iprod: '\u2A3C',
	iquest: '\u00BF',
	Iscr: '\u2110',
	iscr: '\uD835\uDCBE',
	isin: '\u2208',
	isindot: '\u22F5',
	isinE: '\u22F9',
	isins: '\u22F4',
	isinsv: '\u22F3',
	isinv: '\u2208',
	it: '\u2062',
	Itilde: '\u0128',
	itilde: '\u0129',
	Iukcy: '\u0406',
	iukcy: '\u0456',
	Iuml: '\u00CF',
	iuml: '\u00EF',
	Jcirc: '\u0134',
	jcirc: '\u0135',
	Jcy: '\u0419',
	jcy: '\u0439',
	Jfr: '\uD835\uDD0D',
	jfr: '\uD835\uDD27',
	jmath: '\u0237',
	Jopf: '\uD835\uDD41',
	jopf: '\uD835\uDD5B',
	Jscr: '\uD835\uDCA5',
	jscr: '\uD835\uDCBF',
	Jsercy: '\u0408',
	jsercy: '\u0458',
	Jukcy: '\u0404',
	jukcy: '\u0454',
	Kappa: '\u039A',
	kappa: '\u03BA',
	kappav: '\u03F0',
	Kcedil: '\u0136',
	kcedil: '\u0137',
	Kcy: '\u041A',
	kcy: '\u043A',
	Kfr: '\uD835\uDD0E',
	kfr: '\uD835\uDD28',
	kgreen: '\u0138',
	KHcy: '\u0425',
	khcy: '\u0445',
	KJcy: '\u040C',
	kjcy: '\u045C',
	Kopf: '\uD835\uDD42',
	kopf: '\uD835\uDD5C',
	Kscr: '\uD835\uDCA6',
	kscr: '\uD835\uDCC0',
	lAarr: '\u21DA',
	Lacute: '\u0139',
	lacute: '\u013A',
	laemptyv: '\u29B4',
	lagran: '\u2112',
	Lambda: '\u039B',
	lambda: '\u03BB',
	Lang: '\u27EA',
	lang: '\u27E8',
	langd: '\u2991',
	langle: '\u27E8',
	lap: '\u2A85',
	Laplacetrf: '\u2112',
	laquo: '\u00AB',
	Larr: '\u219E',
	lArr: '\u21D0',
	larr: '\u2190',
	larrb: '\u21E4',
	larrbfs: '\u291F',
	larrfs: '\u291D',
	larrhk: '\u21A9',
	larrlp: '\u21AB',
	larrpl: '\u2939',
	larrsim: '\u2973',
	larrtl: '\u21A2',
	lat: '\u2AAB',
	lAtail: '\u291B',
	latail: '\u2919',
	late: '\u2AAD',
	lates: '\u2AAD\uFE00',
	lBarr: '\u290E',
	lbarr: '\u290C',
	lbbrk: '\u2772',
	lbrace: '\u007B',
	lbrack: '\u005B',
	lbrke: '\u298B',
	lbrksld: '\u298F',
	lbrkslu: '\u298D',
	Lcaron: '\u013D',
	lcaron: '\u013E',
	Lcedil: '\u013B',
	lcedil: '\u013C',
	lceil: '\u2308',
	lcub: '\u007B',
	Lcy: '\u041B',
	lcy: '\u043B',
	ldca: '\u2936',
	ldquo: '\u201C',
	ldquor: '\u201E',
	ldrdhar: '\u2967',
	ldrushar: '\u294B',
	ldsh: '\u21B2',
	lE: '\u2266',
	le: '\u2264',
	LeftAngleBracket: '\u27E8',
	LeftArrow: '\u2190',
	Leftarrow: '\u21D0',
	leftarrow: '\u2190',
	LeftArrowBar: '\u21E4',
	LeftArrowRightArrow: '\u21C6',
	leftarrowtail: '\u21A2',
	LeftCeiling: '\u2308',
	LeftDoubleBracket: '\u27E6',
	LeftDownTeeVector: '\u2961',
	LeftDownVector: '\u21C3',
	LeftDownVectorBar: '\u2959',
	LeftFloor: '\u230A',
	leftharpoondown: '\u21BD',
	leftharpoonup: '\u21BC',
	leftleftarrows: '\u21C7',
	LeftRightArrow: '\u2194',
	Leftrightarrow: '\u21D4',
	leftrightarrow: '\u2194',
	leftrightarrows: '\u21C6',
	leftrightharpoons: '\u21CB',
	leftrightsquigarrow: '\u21AD',
	LeftRightVector: '\u294E',
	LeftTee: '\u22A3',
	LeftTeeArrow: '\u21A4',
	LeftTeeVector: '\u295A',
	leftthreetimes: '\u22CB',
	LeftTriangle: '\u22B2',
	LeftTriangleBar: '\u29CF',
	LeftTriangleEqual: '\u22B4',
	LeftUpDownVector: '\u2951',
	LeftUpTeeVector: '\u2960',
	LeftUpVector: '\u21BF',
	LeftUpVectorBar: '\u2958',
	LeftVector: '\u21BC',
	LeftVectorBar: '\u2952',
	lEg: '\u2A8B',
	leg: '\u22DA',
	leq: '\u2264',
	leqq: '\u2266',
	leqslant: '\u2A7D',
	les: '\u2A7D',
	lescc: '\u2AA8',
	lesdot: '\u2A7F',
	lesdoto: '\u2A81',
	lesdotor: '\u2A83',
	lesg: '\u22DA\uFE00',
	lesges: '\u2A93',
	lessapprox: '\u2A85',
	lessdot: '\u22D6',
	lesseqgtr: '\u22DA',
	lesseqqgtr: '\u2A8B',
	LessEqualGreater: '\u22DA',
	LessFullEqual: '\u2266',
	LessGreater: '\u2276',
	lessgtr: '\u2276',
	LessLess: '\u2AA1',
	lesssim: '\u2272',
	LessSlantEqual: '\u2A7D',
	LessTilde: '\u2272',
	lfisht: '\u297C',
	lfloor: '\u230A',
	Lfr: '\uD835\uDD0F',
	lfr: '\uD835\uDD29',
	lg: '\u2276',
	lgE: '\u2A91',
	lHar: '\u2962',
	lhard: '\u21BD',
	lharu: '\u21BC',
	lharul: '\u296A',
	lhblk: '\u2584',
	LJcy: '\u0409',
	ljcy: '\u0459',
	Ll: '\u22D8',
	ll: '\u226A',
	llarr: '\u21C7',
	llcorner: '\u231E',
	Lleftarrow: '\u21DA',
	llhard: '\u296B',
	lltri: '\u25FA',
	Lmidot: '\u013F',
	lmidot: '\u0140',
	lmoust: '\u23B0',
	lmoustache: '\u23B0',
	lnap: '\u2A89',
	lnapprox: '\u2A89',
	lnE: '\u2268',
	lne: '\u2A87',
	lneq: '\u2A87',
	lneqq: '\u2268',
	lnsim: '\u22E6',
	loang: '\u27EC',
	loarr: '\u21FD',
	lobrk: '\u27E6',
	LongLeftArrow: '\u27F5',
	Longleftarrow: '\u27F8',
	longleftarrow: '\u27F5',
	LongLeftRightArrow: '\u27F7',
	Longleftrightarrow: '\u27FA',
	longleftrightarrow: '\u27F7',
	longmapsto: '\u27FC',
	LongRightArrow: '\u27F6',
	Longrightarrow: '\u27F9',
	longrightarrow: '\u27F6',
	looparrowleft: '\u21AB',
	looparrowright: '\u21AC',
	lopar: '\u2985',
	Lopf: '\uD835\uDD43',
	lopf: '\uD835\uDD5D',
	loplus: '\u2A2D',
	lotimes: '\u2A34',
	lowast: '\u2217',
	lowbar: '\u005F',
	LowerLeftArrow: '\u2199',
	LowerRightArrow: '\u2198',
	loz: '\u25CA',
	lozenge: '\u25CA',
	lozf: '\u29EB',
	lpar: '\u0028',
	lparlt: '\u2993',
	lrarr: '\u21C6',
	lrcorner: '\u231F',
	lrhar: '\u21CB',
	lrhard: '\u296D',
	lrm: '\u200E',
	lrtri: '\u22BF',
	lsaquo: '\u2039',
	Lscr: '\u2112',
	lscr: '\uD835\uDCC1',
	Lsh: '\u21B0',
	lsh: '\u21B0',
	lsim: '\u2272',
	lsime: '\u2A8D',
	lsimg: '\u2A8F',
	lsqb: '\u005B',
	lsquo: '\u2018',
	lsquor: '\u201A',
	Lstrok: '\u0141',
	lstrok: '\u0142',
	Lt: '\u226A',
	LT: '\u003C',
	lt: '\u003C',
	ltcc: '\u2AA6',
	ltcir: '\u2A79',
	ltdot: '\u22D6',
	lthree: '\u22CB',
	ltimes: '\u22C9',
	ltlarr: '\u2976',
	ltquest: '\u2A7B',
	ltri: '\u25C3',
	ltrie: '\u22B4',
	ltrif: '\u25C2',
	ltrPar: '\u2996',
	lurdshar: '\u294A',
	luruhar: '\u2966',
	lvertneqq: '\u2268\uFE00',
	lvnE: '\u2268\uFE00',
	macr: '\u00AF',
	male: '\u2642',
	malt: '\u2720',
	maltese: '\u2720',
	Map: '\u2905',
	map: '\u21A6',
	mapsto: '\u21A6',
	mapstodown: '\u21A7',
	mapstoleft: '\u21A4',
	mapstoup: '\u21A5',
	marker: '\u25AE',
	mcomma: '\u2A29',
	Mcy: '\u041C',
	mcy: '\u043C',
	mdash: '\u2014',
	mDDot: '\u223A',
	measuredangle: '\u2221',
	MediumSpace: '\u205F',
	Mellintrf: '\u2133',
	Mfr: '\uD835\uDD10',
	mfr: '\uD835\uDD2A',
	mho: '\u2127',
	micro: '\u00B5',
	mid: '\u2223',
	midast: '\u002A',
	midcir: '\u2AF0',
	middot: '\u00B7',
	minus: '\u2212',
	minusb: '\u229F',
	minusd: '\u2238',
	minusdu: '\u2A2A',
	MinusPlus: '\u2213',
	mlcp: '\u2ADB',
	mldr: '\u2026',
	mnplus: '\u2213',
	models: '\u22A7',
	Mopf: '\uD835\uDD44',
	mopf: '\uD835\uDD5E',
	mp: '\u2213',
	Mscr: '\u2133',
	mscr: '\uD835\uDCC2',
	mstpos: '\u223E',
	Mu: '\u039C',
	mu: '\u03BC',
	multimap: '\u22B8',
	mumap: '\u22B8',
	nabla: '\u2207',
	Nacute: '\u0143',
	nacute: '\u0144',
	nang: '\u2220\u20D2',
	nap: '\u2249',
	napE: '\u2A70\u0338',
	napid: '\u224B\u0338',
	napos: '\u0149',
	napprox: '\u2249',
	natur: '\u266E',
	natural: '\u266E',
	naturals: '\u2115',
	nbsp: '\u00A0',
	nbump: '\u224E\u0338',
	nbumpe: '\u224F\u0338',
	ncap: '\u2A43',
	Ncaron: '\u0147',
	ncaron: '\u0148',
	Ncedil: '\u0145',
	ncedil: '\u0146',
	ncong: '\u2247',
	ncongdot: '\u2A6D\u0338',
	ncup: '\u2A42',
	Ncy: '\u041D',
	ncy: '\u043D',
	ndash: '\u2013',
	ne: '\u2260',
	nearhk: '\u2924',
	neArr: '\u21D7',
	nearr: '\u2197',
	nearrow: '\u2197',
	nedot: '\u2250\u0338',
	NegativeMediumSpace: '\u200B',
	NegativeThickSpace: '\u200B',
	NegativeThinSpace: '\u200B',
	NegativeVeryThinSpace: '\u200B',
	nequiv: '\u2262',
	nesear: '\u2928',
	nesim: '\u2242\u0338',
	NestedGreaterGreater: '\u226B',
	NestedLessLess: '\u226A',
	NewLine: '\u000A',
	nexist: '\u2204',
	nexists: '\u2204',
	Nfr: '\uD835\uDD11',
	nfr: '\uD835\uDD2B',
	ngE: '\u2267\u0338',
	nge: '\u2271',
	ngeq: '\u2271',
	ngeqq: '\u2267\u0338',
	ngeqslant: '\u2A7E\u0338',
	nges: '\u2A7E\u0338',
	nGg: '\u22D9\u0338',
	ngsim: '\u2275',
	nGt: '\u226B\u20D2',
	ngt: '\u226F',
	ngtr: '\u226F',
	nGtv: '\u226B\u0338',
	nhArr: '\u21CE',
	nharr: '\u21AE',
	nhpar: '\u2AF2',
	ni: '\u220B',
	nis: '\u22FC',
	nisd: '\u22FA',
	niv: '\u220B',
	NJcy: '\u040A',
	njcy: '\u045A',
	nlArr: '\u21CD',
	nlarr: '\u219A',
	nldr: '\u2025',
	nlE: '\u2266\u0338',
	nle: '\u2270',
	nLeftarrow: '\u21CD',
	nleftarrow: '\u219A',
	nLeftrightarrow: '\u21CE',
	nleftrightarrow: '\u21AE',
	nleq: '\u2270',
	nleqq: '\u2266\u0338',
	nleqslant: '\u2A7D\u0338',
	nles: '\u2A7D\u0338',
	nless: '\u226E',
	nLl: '\u22D8\u0338',
	nlsim: '\u2274',
	nLt: '\u226A\u20D2',
	nlt: '\u226E',
	nltri: '\u22EA',
	nltrie: '\u22EC',
	nLtv: '\u226A\u0338',
	nmid: '\u2224',
	NoBreak: '\u2060',
	NonBreakingSpace: '\u00A0',
	Nopf: '\u2115',
	nopf: '\uD835\uDD5F',
	Not: '\u2AEC',
	not: '\u00AC',
	NotCongruent: '\u2262',
	NotCupCap: '\u226D',
	NotDoubleVerticalBar: '\u2226',
	NotElement: '\u2209',
	NotEqual: '\u2260',
	NotEqualTilde: '\u2242\u0338',
	NotExists: '\u2204',
	NotGreater: '\u226F',
	NotGreaterEqual: '\u2271',
	NotGreaterFullEqual: '\u2267\u0338',
	NotGreaterGreater: '\u226B\u0338',
	NotGreaterLess: '\u2279',
	NotGreaterSlantEqual: '\u2A7E\u0338',
	NotGreaterTilde: '\u2275',
	NotHumpDownHump: '\u224E\u0338',
	NotHumpEqual: '\u224F\u0338',
	notin: '\u2209',
	notindot: '\u22F5\u0338',
	notinE: '\u22F9\u0338',
	notinva: '\u2209',
	notinvb: '\u22F7',
	notinvc: '\u22F6',
	NotLeftTriangle: '\u22EA',
	NotLeftTriangleBar: '\u29CF\u0338',
	NotLeftTriangleEqual: '\u22EC',
	NotLess: '\u226E',
	NotLessEqual: '\u2270',
	NotLessGreater: '\u2278',
	NotLessLess: '\u226A\u0338',
	NotLessSlantEqual: '\u2A7D\u0338',
	NotLessTilde: '\u2274',
	NotNestedGreaterGreater: '\u2AA2\u0338',
	NotNestedLessLess: '\u2AA1\u0338',
	notni: '\u220C',
	notniva: '\u220C',
	notnivb: '\u22FE',
	notnivc: '\u22FD',
	NotPrecedes: '\u2280',
	NotPrecedesEqual: '\u2AAF\u0338',
	NotPrecedesSlantEqual: '\u22E0',
	NotReverseElement: '\u220C',
	NotRightTriangle: '\u22EB',
	NotRightTriangleBar: '\u29D0\u0338',
	NotRightTriangleEqual: '\u22ED',
	NotSquareSubset: '\u228F\u0338',
	NotSquareSubsetEqual: '\u22E2',
	NotSquareSuperset: '\u2290\u0338',
	NotSquareSupersetEqual: '\u22E3',
	NotSubset: '\u2282\u20D2',
	NotSubsetEqual: '\u2288',
	NotSucceeds: '\u2281',
	NotSucceedsEqual: '\u2AB0\u0338',
	NotSucceedsSlantEqual: '\u22E1',
	NotSucceedsTilde: '\u227F\u0338',
	NotSuperset: '\u2283\u20D2',
	NotSupersetEqual: '\u2289',
	NotTilde: '\u2241',
	NotTildeEqual: '\u2244',
	NotTildeFullEqual: '\u2247',
	NotTildeTilde: '\u2249',
	NotVerticalBar: '\u2224',
	npar: '\u2226',
	nparallel: '\u2226',
	nparsl: '\u2AFD\u20E5',
	npart: '\u2202\u0338',
	npolint: '\u2A14',
	npr: '\u2280',
	nprcue: '\u22E0',
	npre: '\u2AAF\u0338',
	nprec: '\u2280',
	npreceq: '\u2AAF\u0338',
	nrArr: '\u21CF',
	nrarr: '\u219B',
	nrarrc: '\u2933\u0338',
	nrarrw: '\u219D\u0338',
	nRightarrow: '\u21CF',
	nrightarrow: '\u219B',
	nrtri: '\u22EB',
	nrtrie: '\u22ED',
	nsc: '\u2281',
	nsccue: '\u22E1',
	nsce: '\u2AB0\u0338',
	Nscr: '\uD835\uDCA9',
	nscr: '\uD835\uDCC3',
	nshortmid: '\u2224',
	nshortparallel: '\u2226',
	nsim: '\u2241',
	nsime: '\u2244',
	nsimeq: '\u2244',
	nsmid: '\u2224',
	nspar: '\u2226',
	nsqsube: '\u22E2',
	nsqsupe: '\u22E3',
	nsub: '\u2284',
	nsubE: '\u2AC5\u0338',
	nsube: '\u2288',
	nsubset: '\u2282\u20D2',
	nsubseteq: '\u2288',
	nsubseteqq: '\u2AC5\u0338',
	nsucc: '\u2281',
	nsucceq: '\u2AB0\u0338',
	nsup: '\u2285',
	nsupE: '\u2AC6\u0338',
	nsupe: '\u2289',
	nsupset: '\u2283\u20D2',
	nsupseteq: '\u2289',
	nsupseteqq: '\u2AC6\u0338',
	ntgl: '\u2279',
	Ntilde: '\u00D1',
	ntilde: '\u00F1',
	ntlg: '\u2278',
	ntriangleleft: '\u22EA',
	ntrianglelefteq: '\u22EC',
	ntriangleright: '\u22EB',
	ntrianglerighteq: '\u22ED',
	Nu: '\u039D',
	nu: '\u03BD',
	num: '\u0023',
	numero: '\u2116',
	numsp: '\u2007',
	nvap: '\u224D\u20D2',
	nVDash: '\u22AF',
	nVdash: '\u22AE',
	nvDash: '\u22AD',
	nvdash: '\u22AC',
	nvge: '\u2265\u20D2',
	nvgt: '\u003E\u20D2',
	nvHarr: '\u2904',
	nvinfin: '\u29DE',
	nvlArr: '\u2902',
	nvle: '\u2264\u20D2',
	nvlt: '\u003C\u20D2',
	nvltrie: '\u22B4\u20D2',
	nvrArr: '\u2903',
	nvrtrie: '\u22B5\u20D2',
	nvsim: '\u223C\u20D2',
	nwarhk: '\u2923',
	nwArr: '\u21D6',
	nwarr: '\u2196',
	nwarrow: '\u2196',
	nwnear: '\u2927',
	Oacute: '\u00D3',
	oacute: '\u00F3',
	oast: '\u229B',
	ocir: '\u229A',
	Ocirc: '\u00D4',
	ocirc: '\u00F4',
	Ocy: '\u041E',
	ocy: '\u043E',
	odash: '\u229D',
	Odblac: '\u0150',
	odblac: '\u0151',
	odiv: '\u2A38',
	odot: '\u2299',
	odsold: '\u29BC',
	OElig: '\u0152',
	oelig: '\u0153',
	ofcir: '\u29BF',
	Ofr: '\uD835\uDD12',
	ofr: '\uD835\uDD2C',
	ogon: '\u02DB',
	Ograve: '\u00D2',
	ograve: '\u00F2',
	ogt: '\u29C1',
	ohbar: '\u29B5',
	ohm: '\u03A9',
	oint: '\u222E',
	olarr: '\u21BA',
	olcir: '\u29BE',
	olcross: '\u29BB',
	oline: '\u203E',
	olt: '\u29C0',
	Omacr: '\u014C',
	omacr: '\u014D',
	Omega: '\u03A9',
	omega: '\u03C9',
	Omicron: '\u039F',
	omicron: '\u03BF',
	omid: '\u29B6',
	ominus: '\u2296',
	Oopf: '\uD835\uDD46',
	oopf: '\uD835\uDD60',
	opar: '\u29B7',
	OpenCurlyDoubleQuote: '\u201C',
	OpenCurlyQuote: '\u2018',
	operp: '\u29B9',
	oplus: '\u2295',
	Or: '\u2A54',
	or: '\u2228',
	orarr: '\u21BB',
	ord: '\u2A5D',
	order: '\u2134',
	orderof: '\u2134',
	ordf: '\u00AA',
	ordm: '\u00BA',
	origof: '\u22B6',
	oror: '\u2A56',
	orslope: '\u2A57',
	orv: '\u2A5B',
	oS: '\u24C8',
	Oscr: '\uD835\uDCAA',
	oscr: '\u2134',
	Oslash: '\u00D8',
	oslash: '\u00F8',
	osol: '\u2298',
	Otilde: '\u00D5',
	otilde: '\u00F5',
	Otimes: '\u2A37',
	otimes: '\u2297',
	otimesas: '\u2A36',
	Ouml: '\u00D6',
	ouml: '\u00F6',
	ovbar: '\u233D',
	OverBar: '\u203E',
	OverBrace: '\u23DE',
	OverBracket: '\u23B4',
	OverParenthesis: '\u23DC',
	par: '\u2225',
	para: '\u00B6',
	parallel: '\u2225',
	parsim: '\u2AF3',
	parsl: '\u2AFD',
	part: '\u2202',
	PartialD: '\u2202',
	Pcy: '\u041F',
	pcy: '\u043F',
	percnt: '\u0025',
	period: '\u002E',
	permil: '\u2030',
	perp: '\u22A5',
	pertenk: '\u2031',
	Pfr: '\uD835\uDD13',
	pfr: '\uD835\uDD2D',
	Phi: '\u03A6',
	phi: '\u03C6',
	phiv: '\u03D5',
	phmmat: '\u2133',
	phone: '\u260E',
	Pi: '\u03A0',
	pi: '\u03C0',
	pitchfork: '\u22D4',
	piv: '\u03D6',
	planck: '\u210F',
	planckh: '\u210E',
	plankv: '\u210F',
	plus: '\u002B',
	plusacir: '\u2A23',
	plusb: '\u229E',
	pluscir: '\u2A22',
	plusdo: '\u2214',
	plusdu: '\u2A25',
	pluse: '\u2A72',
	PlusMinus: '\u00B1',
	plusmn: '\u00B1',
	plussim: '\u2A26',
	plustwo: '\u2A27',
	pm: '\u00B1',
	Poincareplane: '\u210C',
	pointint: '\u2A15',
	Popf: '\u2119',
	popf: '\uD835\uDD61',
	pound: '\u00A3',
	Pr: '\u2ABB',
	pr: '\u227A',
	prap: '\u2AB7',
	prcue: '\u227C',
	prE: '\u2AB3',
	pre: '\u2AAF',
	prec: '\u227A',
	precapprox: '\u2AB7',
	preccurlyeq: '\u227C',
	Precedes: '\u227A',
	PrecedesEqual: '\u2AAF',
	PrecedesSlantEqual: '\u227C',
	PrecedesTilde: '\u227E',
	preceq: '\u2AAF',
	precnapprox: '\u2AB9',
	precneqq: '\u2AB5',
	precnsim: '\u22E8',
	precsim: '\u227E',
	Prime: '\u2033',
	prime: '\u2032',
	primes: '\u2119',
	prnap: '\u2AB9',
	prnE: '\u2AB5',
	prnsim: '\u22E8',
	prod: '\u220F',
	Product: '\u220F',
	profalar: '\u232E',
	profline: '\u2312',
	profsurf: '\u2313',
	prop: '\u221D',
	Proportion: '\u2237',
	Proportional: '\u221D',
	propto: '\u221D',
	prsim: '\u227E',
	prurel: '\u22B0',
	Pscr: '\uD835\uDCAB',
	pscr: '\uD835\uDCC5',
	Psi: '\u03A8',
	psi: '\u03C8',
	puncsp: '\u2008',
	Qfr: '\uD835\uDD14',
	qfr: '\uD835\uDD2E',
	qint: '\u2A0C',
	Qopf: '\u211A',
	qopf: '\uD835\uDD62',
	qprime: '\u2057',
	Qscr: '\uD835\uDCAC',
	qscr: '\uD835\uDCC6',
	quaternions: '\u210D',
	quatint: '\u2A16',
	quest: '\u003F',
	questeq: '\u225F',
	QUOT: '\u0022',
	quot: '\u0022',
	rAarr: '\u21DB',
	race: '\u223D\u0331',
	Racute: '\u0154',
	racute: '\u0155',
	radic: '\u221A',
	raemptyv: '\u29B3',
	Rang: '\u27EB',
	rang: '\u27E9',
	rangd: '\u2992',
	range: '\u29A5',
	rangle: '\u27E9',
	raquo: '\u00BB',
	Rarr: '\u21A0',
	rArr: '\u21D2',
	rarr: '\u2192',
	rarrap: '\u2975',
	rarrb: '\u21E5',
	rarrbfs: '\u2920',
	rarrc: '\u2933',
	rarrfs: '\u291E',
	rarrhk: '\u21AA',
	rarrlp: '\u21AC',
	rarrpl: '\u2945',
	rarrsim: '\u2974',
	Rarrtl: '\u2916',
	rarrtl: '\u21A3',
	rarrw: '\u219D',
	rAtail: '\u291C',
	ratail: '\u291A',
	ratio: '\u2236',
	rationals: '\u211A',
	RBarr: '\u2910',
	rBarr: '\u290F',
	rbarr: '\u290D',
	rbbrk: '\u2773',
	rbrace: '\u007D',
	rbrack: '\u005D',
	rbrke: '\u298C',
	rbrksld: '\u298E',
	rbrkslu: '\u2990',
	Rcaron: '\u0158',
	rcaron: '\u0159',
	Rcedil: '\u0156',
	rcedil: '\u0157',
	rceil: '\u2309',
	rcub: '\u007D',
	Rcy: '\u0420',
	rcy: '\u0440',
	rdca: '\u2937',
	rdldhar: '\u2969',
	rdquo: '\u201D',
	rdquor: '\u201D',
	rdsh: '\u21B3',
	Re: '\u211C',
	real: '\u211C',
	realine: '\u211B',
	realpart: '\u211C',
	reals: '\u211D',
	rect: '\u25AD',
	REG: '\u00AE',
	reg: '\u00AE',
	ReverseElement: '\u220B',
	ReverseEquilibrium: '\u21CB',
	ReverseUpEquilibrium: '\u296F',
	rfisht: '\u297D',
	rfloor: '\u230B',
	Rfr: '\u211C',
	rfr: '\uD835\uDD2F',
	rHar: '\u2964',
	rhard: '\u21C1',
	rharu: '\u21C0',
	rharul: '\u296C',
	Rho: '\u03A1',
	rho: '\u03C1',
	rhov: '\u03F1',
	RightAngleBracket: '\u27E9',
	RightArrow: '\u2192',
	Rightarrow: '\u21D2',
	rightarrow: '\u2192',
	RightArrowBar: '\u21E5',
	RightArrowLeftArrow: '\u21C4',
	rightarrowtail: '\u21A3',
	RightCeiling: '\u2309',
	RightDoubleBracket: '\u27E7',
	RightDownTeeVector: '\u295D',
	RightDownVector: '\u21C2',
	RightDownVectorBar: '\u2955',
	RightFloor: '\u230B',
	rightharpoondown: '\u21C1',
	rightharpoonup: '\u21C0',
	rightleftarrows: '\u21C4',
	rightleftharpoons: '\u21CC',
	rightrightarrows: '\u21C9',
	rightsquigarrow: '\u219D',
	RightTee: '\u22A2',
	RightTeeArrow: '\u21A6',
	RightTeeVector: '\u295B',
	rightthreetimes: '\u22CC',
	RightTriangle: '\u22B3',
	RightTriangleBar: '\u29D0',
	RightTriangleEqual: '\u22B5',
	RightUpDownVector: '\u294F',
	RightUpTeeVector: '\u295C',
	RightUpVector: '\u21BE',
	RightUpVectorBar: '\u2954',
	RightVector: '\u21C0',
	RightVectorBar: '\u2953',
	ring: '\u02DA',
	risingdotseq: '\u2253',
	rlarr: '\u21C4',
	rlhar: '\u21CC',
	rlm: '\u200F',
	rmoust: '\u23B1',
	rmoustache: '\u23B1',
	rnmid: '\u2AEE',
	roang: '\u27ED',
	roarr: '\u21FE',
	robrk: '\u27E7',
	ropar: '\u2986',
	Ropf: '\u211D',
	ropf: '\uD835\uDD63',
	roplus: '\u2A2E',
	rotimes: '\u2A35',
	RoundImplies: '\u2970',
	rpar: '\u0029',
	rpargt: '\u2994',
	rppolint: '\u2A12',
	rrarr: '\u21C9',
	Rrightarrow: '\u21DB',
	rsaquo: '\u203A',
	Rscr: '\u211B',
	rscr: '\uD835\uDCC7',
	Rsh: '\u21B1',
	rsh: '\u21B1',
	rsqb: '\u005D',
	rsquo: '\u2019',
	rsquor: '\u2019',
	rthree: '\u22CC',
	rtimes: '\u22CA',
	rtri: '\u25B9',
	rtrie: '\u22B5',
	rtrif: '\u25B8',
	rtriltri: '\u29CE',
	RuleDelayed: '\u29F4',
	ruluhar: '\u2968',
	rx: '\u211E',
	Sacute: '\u015A',
	sacute: '\u015B',
	sbquo: '\u201A',
	Sc: '\u2ABC',
	sc: '\u227B',
	scap: '\u2AB8',
	Scaron: '\u0160',
	scaron: '\u0161',
	sccue: '\u227D',
	scE: '\u2AB4',
	sce: '\u2AB0',
	Scedil: '\u015E',
	scedil: '\u015F',
	Scirc: '\u015C',
	scirc: '\u015D',
	scnap: '\u2ABA',
	scnE: '\u2AB6',
	scnsim: '\u22E9',
	scpolint: '\u2A13',
	scsim: '\u227F',
	Scy: '\u0421',
	scy: '\u0441',
	sdot: '\u22C5',
	sdotb: '\u22A1',
	sdote: '\u2A66',
	searhk: '\u2925',
	seArr: '\u21D8',
	searr: '\u2198',
	searrow: '\u2198',
	sect: '\u00A7',
	semi: '\u003B',
	seswar: '\u2929',
	setminus: '\u2216',
	setmn: '\u2216',
	sext: '\u2736',
	Sfr: '\uD835\uDD16',
	sfr: '\uD835\uDD30',
	sfrown: '\u2322',
	sharp: '\u266F',
	SHCHcy: '\u0429',
	shchcy: '\u0449',
	SHcy: '\u0428',
	shcy: '\u0448',
	ShortDownArrow: '\u2193',
	ShortLeftArrow: '\u2190',
	shortmid: '\u2223',
	shortparallel: '\u2225',
	ShortRightArrow: '\u2192',
	ShortUpArrow: '\u2191',
	shy: '\u00AD',
	Sigma: '\u03A3',
	sigma: '\u03C3',
	sigmaf: '\u03C2',
	sigmav: '\u03C2',
	sim: '\u223C',
	simdot: '\u2A6A',
	sime: '\u2243',
	simeq: '\u2243',
	simg: '\u2A9E',
	simgE: '\u2AA0',
	siml: '\u2A9D',
	simlE: '\u2A9F',
	simne: '\u2246',
	simplus: '\u2A24',
	simrarr: '\u2972',
	slarr: '\u2190',
	SmallCircle: '\u2218',
	smallsetminus: '\u2216',
	smashp: '\u2A33',
	smeparsl: '\u29E4',
	smid: '\u2223',
	smile: '\u2323',
	smt: '\u2AAA',
	smte: '\u2AAC',
	smtes: '\u2AAC\uFE00',
	SOFTcy: '\u042C',
	softcy: '\u044C',
	sol: '\u002F',
	solb: '\u29C4',
	solbar: '\u233F',
	Sopf: '\uD835\uDD4A',
	sopf: '\uD835\uDD64',
	spades: '\u2660',
	spadesuit: '\u2660',
	spar: '\u2225',
	sqcap: '\u2293',
	sqcaps: '\u2293\uFE00',
	sqcup: '\u2294',
	sqcups: '\u2294\uFE00',
	Sqrt: '\u221A',
	sqsub: '\u228F',
	sqsube: '\u2291',
	sqsubset: '\u228F',
	sqsubseteq: '\u2291',
	sqsup: '\u2290',
	sqsupe: '\u2292',
	sqsupset: '\u2290',
	sqsupseteq: '\u2292',
	squ: '\u25A1',
	Square: '\u25A1',
	square: '\u25A1',
	SquareIntersection: '\u2293',
	SquareSubset: '\u228F',
	SquareSubsetEqual: '\u2291',
	SquareSuperset: '\u2290',
	SquareSupersetEqual: '\u2292',
	SquareUnion: '\u2294',
	squarf: '\u25AA',
	squf: '\u25AA',
	srarr: '\u2192',
	Sscr: '\uD835\uDCAE',
	sscr: '\uD835\uDCC8',
	ssetmn: '\u2216',
	ssmile: '\u2323',
	sstarf: '\u22C6',
	Star: '\u22C6',
	star: '\u2606',
	starf: '\u2605',
	straightepsilon: '\u03F5',
	straightphi: '\u03D5',
	strns: '\u00AF',
	Sub: '\u22D0',
	sub: '\u2282',
	subdot: '\u2ABD',
	subE: '\u2AC5',
	sube: '\u2286',
	subedot: '\u2AC3',
	submult: '\u2AC1',
	subnE: '\u2ACB',
	subne: '\u228A',
	subplus: '\u2ABF',
	subrarr: '\u2979',
	Subset: '\u22D0',
	subset: '\u2282',
	subseteq: '\u2286',
	subseteqq: '\u2AC5',
	SubsetEqual: '\u2286',
	subsetneq: '\u228A',
	subsetneqq: '\u2ACB',
	subsim: '\u2AC7',
	subsub: '\u2AD5',
	subsup: '\u2AD3',
	succ: '\u227B',
	succapprox: '\u2AB8',
	succcurlyeq: '\u227D',
	Succeeds: '\u227B',
	SucceedsEqual: '\u2AB0',
	SucceedsSlantEqual: '\u227D',
	SucceedsTilde: '\u227F',
	succeq: '\u2AB0',
	succnapprox: '\u2ABA',
	succneqq: '\u2AB6',
	succnsim: '\u22E9',
	succsim: '\u227F',
	SuchThat: '\u220B',
	Sum: '\u2211',
	sum: '\u2211',
	sung: '\u266A',
	Sup: '\u22D1',
	sup: '\u2283',
	sup1: '\u00B9',
	sup2: '\u00B2',
	sup3: '\u00B3',
	supdot: '\u2ABE',
	supdsub: '\u2AD8',
	supE: '\u2AC6',
	supe: '\u2287',
	supedot: '\u2AC4',
	Superset: '\u2283',
	SupersetEqual: '\u2287',
	suphsol: '\u27C9',
	suphsub: '\u2AD7',
	suplarr: '\u297B',
	supmult: '\u2AC2',
	supnE: '\u2ACC',
	supne: '\u228B',
	supplus: '\u2AC0',
	Supset: '\u22D1',
	supset: '\u2283',
	supseteq: '\u2287',
	supseteqq: '\u2AC6',
	supsetneq: '\u228B',
	supsetneqq: '\u2ACC',
	supsim: '\u2AC8',
	supsub: '\u2AD4',
	supsup: '\u2AD6',
	swarhk: '\u2926',
	swArr: '\u21D9',
	swarr: '\u2199',
	swarrow: '\u2199',
	swnwar: '\u292A',
	szlig: '\u00DF',
	Tab: '\u0009',
	target: '\u2316',
	Tau: '\u03A4',
	tau: '\u03C4',
	tbrk: '\u23B4',
	Tcaron: '\u0164',
	tcaron: '\u0165',
	Tcedil: '\u0162',
	tcedil: '\u0163',
	Tcy: '\u0422',
	tcy: '\u0442',
	tdot: '\u20DB',
	telrec: '\u2315',
	Tfr: '\uD835\uDD17',
	tfr: '\uD835\uDD31',
	there4: '\u2234',
	Therefore: '\u2234',
	therefore: '\u2234',
	Theta: '\u0398',
	theta: '\u03B8',
	thetasym: '\u03D1',
	thetav: '\u03D1',
	thickapprox: '\u2248',
	thicksim: '\u223C',
	ThickSpace: '\u205F\u200A',
	thinsp: '\u2009',
	ThinSpace: '\u2009',
	thkap: '\u2248',
	thksim: '\u223C',
	THORN: '\u00DE',
	thorn: '\u00FE',
	Tilde: '\u223C',
	tilde: '\u02DC',
	TildeEqual: '\u2243',
	TildeFullEqual: '\u2245',
	TildeTilde: '\u2248',
	times: '\u00D7',
	timesb: '\u22A0',
	timesbar: '\u2A31',
	timesd: '\u2A30',
	tint: '\u222D',
	toea: '\u2928',
	top: '\u22A4',
	topbot: '\u2336',
	topcir: '\u2AF1',
	Topf: '\uD835\uDD4B',
	topf: '\uD835\uDD65',
	topfork: '\u2ADA',
	tosa: '\u2929',
	tprime: '\u2034',
	TRADE: '\u2122',
	trade: '\u2122',
	triangle: '\u25B5',
	triangledown: '\u25BF',
	triangleleft: '\u25C3',
	trianglelefteq: '\u22B4',
	triangleq: '\u225C',
	triangleright: '\u25B9',
	trianglerighteq: '\u22B5',
	tridot: '\u25EC',
	trie: '\u225C',
	triminus: '\u2A3A',
	TripleDot: '\u20DB',
	triplus: '\u2A39',
	trisb: '\u29CD',
	tritime: '\u2A3B',
	trpezium: '\u23E2',
	Tscr: '\uD835\uDCAF',
	tscr: '\uD835\uDCC9',
	TScy: '\u0426',
	tscy: '\u0446',
	TSHcy: '\u040B',
	tshcy: '\u045B',
	Tstrok: '\u0166',
	tstrok: '\u0167',
	twixt: '\u226C',
	twoheadleftarrow: '\u219E',
	twoheadrightarrow: '\u21A0',
	Uacute: '\u00DA',
	uacute: '\u00FA',
	Uarr: '\u219F',
	uArr: '\u21D1',
	uarr: '\u2191',
	Uarrocir: '\u2949',
	Ubrcy: '\u040E',
	ubrcy: '\u045E',
	Ubreve: '\u016C',
	ubreve: '\u016D',
	Ucirc: '\u00DB',
	ucirc: '\u00FB',
	Ucy: '\u0423',
	ucy: '\u0443',
	udarr: '\u21C5',
	Udblac: '\u0170',
	udblac: '\u0171',
	udhar: '\u296E',
	ufisht: '\u297E',
	Ufr: '\uD835\uDD18',
	ufr: '\uD835\uDD32',
	Ugrave: '\u00D9',
	ugrave: '\u00F9',
	uHar: '\u2963',
	uharl: '\u21BF',
	uharr: '\u21BE',
	uhblk: '\u2580',
	ulcorn: '\u231C',
	ulcorner: '\u231C',
	ulcrop: '\u230F',
	ultri: '\u25F8',
	Umacr: '\u016A',
	umacr: '\u016B',
	uml: '\u00A8',
	UnderBar: '\u005F',
	UnderBrace: '\u23DF',
	UnderBracket: '\u23B5',
	UnderParenthesis: '\u23DD',
	Union: '\u22C3',
	UnionPlus: '\u228E',
	Uogon: '\u0172',
	uogon: '\u0173',
	Uopf: '\uD835\uDD4C',
	uopf: '\uD835\uDD66',
	UpArrow: '\u2191',
	Uparrow: '\u21D1',
	uparrow: '\u2191',
	UpArrowBar: '\u2912',
	UpArrowDownArrow: '\u21C5',
	UpDownArrow: '\u2195',
	Updownarrow: '\u21D5',
	updownarrow: '\u2195',
	UpEquilibrium: '\u296E',
	upharpoonleft: '\u21BF',
	upharpoonright: '\u21BE',
	uplus: '\u228E',
	UpperLeftArrow: '\u2196',
	UpperRightArrow: '\u2197',
	Upsi: '\u03D2',
	upsi: '\u03C5',
	upsih: '\u03D2',
	Upsilon: '\u03A5',
	upsilon: '\u03C5',
	UpTee: '\u22A5',
	UpTeeArrow: '\u21A5',
	upuparrows: '\u21C8',
	urcorn: '\u231D',
	urcorner: '\u231D',
	urcrop: '\u230E',
	Uring: '\u016E',
	uring: '\u016F',
	urtri: '\u25F9',
	Uscr: '\uD835\uDCB0',
	uscr: '\uD835\uDCCA',
	utdot: '\u22F0',
	Utilde: '\u0168',
	utilde: '\u0169',
	utri: '\u25B5',
	utrif: '\u25B4',
	uuarr: '\u21C8',
	Uuml: '\u00DC',
	uuml: '\u00FC',
	uwangle: '\u29A7',
	vangrt: '\u299C',
	varepsilon: '\u03F5',
	varkappa: '\u03F0',
	varnothing: '\u2205',
	varphi: '\u03D5',
	varpi: '\u03D6',
	varpropto: '\u221D',
	vArr: '\u21D5',
	varr: '\u2195',
	varrho: '\u03F1',
	varsigma: '\u03C2',
	varsubsetneq: '\u228A\uFE00',
	varsubsetneqq: '\u2ACB\uFE00',
	varsupsetneq: '\u228B\uFE00',
	varsupsetneqq: '\u2ACC\uFE00',
	vartheta: '\u03D1',
	vartriangleleft: '\u22B2',
	vartriangleright: '\u22B3',
	Vbar: '\u2AEB',
	vBar: '\u2AE8',
	vBarv: '\u2AE9',
	Vcy: '\u0412',
	vcy: '\u0432',
	VDash: '\u22AB',
	Vdash: '\u22A9',
	vDash: '\u22A8',
	vdash: '\u22A2',
	Vdashl: '\u2AE6',
	Vee: '\u22C1',
	vee: '\u2228',
	veebar: '\u22BB',
	veeeq: '\u225A',
	vellip: '\u22EE',
	Verbar: '\u2016',
	verbar: '\u007C',
	Vert: '\u2016',
	vert: '\u007C',
	VerticalBar: '\u2223',
	VerticalLine: '\u007C',
	VerticalSeparator: '\u2758',
	VerticalTilde: '\u2240',
	VeryThinSpace: '\u200A',
	Vfr: '\uD835\uDD19',
	vfr: '\uD835\uDD33',
	vltri: '\u22B2',
	vnsub: '\u2282\u20D2',
	vnsup: '\u2283\u20D2',
	Vopf: '\uD835\uDD4D',
	vopf: '\uD835\uDD67',
	vprop: '\u221D',
	vrtri: '\u22B3',
	Vscr: '\uD835\uDCB1',
	vscr: '\uD835\uDCCB',
	vsubnE: '\u2ACB\uFE00',
	vsubne: '\u228A\uFE00',
	vsupnE: '\u2ACC\uFE00',
	vsupne: '\u228B\uFE00',
	Vvdash: '\u22AA',
	vzigzag: '\u299A',
	Wcirc: '\u0174',
	wcirc: '\u0175',
	wedbar: '\u2A5F',
	Wedge: '\u22C0',
	wedge: '\u2227',
	wedgeq: '\u2259',
	weierp: '\u2118',
	Wfr: '\uD835\uDD1A',
	wfr: '\uD835\uDD34',
	Wopf: '\uD835\uDD4E',
	wopf: '\uD835\uDD68',
	wp: '\u2118',
	wr: '\u2240',
	wreath: '\u2240',
	Wscr: '\uD835\uDCB2',
	wscr: '\uD835\uDCCC',
	xcap: '\u22C2',
	xcirc: '\u25EF',
	xcup: '\u22C3',
	xdtri: '\u25BD',
	Xfr: '\uD835\uDD1B',
	xfr: '\uD835\uDD35',
	xhArr: '\u27FA',
	xharr: '\u27F7',
	Xi: '\u039E',
	xi: '\u03BE',
	xlArr: '\u27F8',
	xlarr: '\u27F5',
	xmap: '\u27FC',
	xnis: '\u22FB',
	xodot: '\u2A00',
	Xopf: '\uD835\uDD4F',
	xopf: '\uD835\uDD69',
	xoplus: '\u2A01',
	xotime: '\u2A02',
	xrArr: '\u27F9',
	xrarr: '\u27F6',
	Xscr: '\uD835\uDCB3',
	xscr: '\uD835\uDCCD',
	xsqcup: '\u2A06',
	xuplus: '\u2A04',
	xutri: '\u25B3',
	xvee: '\u22C1',
	xwedge: '\u22C0',
	Yacute: '\u00DD',
	yacute: '\u00FD',
	YAcy: '\u042F',
	yacy: '\u044F',
	Ycirc: '\u0176',
	ycirc: '\u0177',
	Ycy: '\u042B',
	ycy: '\u044B',
	yen: '\u00A5',
	Yfr: '\uD835\uDD1C',
	yfr: '\uD835\uDD36',
	YIcy: '\u0407',
	yicy: '\u0457',
	Yopf: '\uD835\uDD50',
	yopf: '\uD835\uDD6A',
	Yscr: '\uD835\uDCB4',
	yscr: '\uD835\uDCCE',
	YUcy: '\u042E',
	yucy: '\u044E',
	Yuml: '\u0178',
	yuml: '\u00FF',
	Zacute: '\u0179',
	zacute: '\u017A',
	Zcaron: '\u017D',
	zcaron: '\u017E',
	Zcy: '\u0417',
	zcy: '\u0437',
	Zdot: '\u017B',
	zdot: '\u017C',
	zeetrf: '\u2128',
	ZeroWidthSpace: '\u200B',
	Zeta: '\u0396',
	zeta: '\u03B6',
	Zfr: '\u2128',
	zfr: '\uD835\uDD37',
	ZHcy: '\u0416',
	zhcy: '\u0436',
	zigrarr: '\u21DD',
	Zopf: '\u2124',
	zopf: '\uD835\uDD6B',
	Zscr: '\uD835\uDCB5',
	zscr: '\uD835\uDCCF',
	zwj: '\u200D',
	zwnj: '\u200C',
});

/**
 * @deprecated use `HTML_ENTITIES` instead
 * @see HTML_ENTITIES
 */
exports.entityMap = exports.HTML_ENTITIES;


/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var dom = __webpack_require__(/*! ./dom */ "./node_modules/@xmldom/xmldom/lib/dom.js")
exports.DOMImplementation = dom.DOMImplementation
exports.XMLSerializer = dom.XMLSerializer
exports.DOMParser = __webpack_require__(/*! ./dom-parser */ "./node_modules/@xmldom/xmldom/lib/dom-parser.js").DOMParser


/***/ }),

/***/ "./node_modules/@xmldom/xmldom/lib/sax.js":
/*!************************************************!*\
  !*** ./node_modules/@xmldom/xmldom/lib/sax.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var NAMESPACE = (__webpack_require__(/*! ./conventions */ "./node_modules/@xmldom/xmldom/lib/conventions.js").NAMESPACE);

//[4]   	NameStartChar	   ::=   	":" | [A-Z] | "_" | [a-z] | [#xC0-#xD6] | [#xD8-#xF6] | [#xF8-#x2FF] | [#x370-#x37D] | [#x37F-#x1FFF] | [#x200C-#x200D] | [#x2070-#x218F] | [#x2C00-#x2FEF] | [#x3001-#xD7FF] | [#xF900-#xFDCF] | [#xFDF0-#xFFFD] | [#x10000-#xEFFFF]
//[4a]   	NameChar	   ::=   	NameStartChar | "-" | "." | [0-9] | #xB7 | [#x0300-#x036F] | [#x203F-#x2040]
//[5]   	Name	   ::=   	NameStartChar (NameChar)*
var nameStartChar = /[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]///\u10000-\uEFFFF
var nameChar = new RegExp("[\\-\\.0-9"+nameStartChar.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]");
var tagNamePattern = new RegExp('^'+nameStartChar.source+nameChar.source+'*(?:\:'+nameStartChar.source+nameChar.source+'*)?$');
//var tagNamePattern = /^[a-zA-Z_][\w\-\.]*(?:\:[a-zA-Z_][\w\-\.]*)?$/
//var handlers = 'resolveEntity,getExternalSubset,characters,endDocument,endElement,endPrefixMapping,ignorableWhitespace,processingInstruction,setDocumentLocator,skippedEntity,startDocument,startElement,startPrefixMapping,notationDecl,unparsedEntityDecl,error,fatalError,warning,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,comment,endCDATA,endDTD,endEntity,startCDATA,startDTD,startEntity'.split(',')

//S_TAG,	S_ATTR,	S_EQ,	S_ATTR_NOQUOT_VALUE
//S_ATTR_SPACE,	S_ATTR_END,	S_TAG_SPACE, S_TAG_CLOSE
var S_TAG = 0;//tag name offerring
var S_ATTR = 1;//attr name offerring
var S_ATTR_SPACE=2;//attr name end and space offer
var S_EQ = 3;//=space?
var S_ATTR_NOQUOT_VALUE = 4;//attr value(no quot value only)
var S_ATTR_END = 5;//attr value end and no space(quot end)
var S_TAG_SPACE = 6;//(attr value end || tag end ) && (space offer)
var S_TAG_CLOSE = 7;//closed el<el />

/**
 * Creates an error that will not be caught by XMLReader aka the SAX parser.
 *
 * @param {string} message
 * @param {any?} locator Optional, can provide details about the location in the source
 * @constructor
 */
function ParseError(message, locator) {
	this.message = message
	this.locator = locator
	if(Error.captureStackTrace) Error.captureStackTrace(this, ParseError);
}
ParseError.prototype = new Error();
ParseError.prototype.name = ParseError.name

function XMLReader(){

}

XMLReader.prototype = {
	parse:function(source,defaultNSMap,entityMap){
		var domBuilder = this.domBuilder;
		domBuilder.startDocument();
		_copy(defaultNSMap ,defaultNSMap = {})
		parse(source,defaultNSMap,entityMap,
				domBuilder,this.errorHandler);
		domBuilder.endDocument();
	}
}
function parse(source,defaultNSMapCopy,entityMap,domBuilder,errorHandler){
	function fixedFromCharCode(code) {
		// String.prototype.fromCharCode does not supports
		// > 2 bytes unicode chars directly
		if (code > 0xffff) {
			code -= 0x10000;
			var surrogate1 = 0xd800 + (code >> 10)
				, surrogate2 = 0xdc00 + (code & 0x3ff);

			return String.fromCharCode(surrogate1, surrogate2);
		} else {
			return String.fromCharCode(code);
		}
	}
	function entityReplacer(a){
		var k = a.slice(1,-1);
		if (Object.hasOwnProperty.call(entityMap, k)) {
			return entityMap[k];
		}else if(k.charAt(0) === '#'){
			return fixedFromCharCode(parseInt(k.substr(1).replace('x','0x')))
		}else{
			errorHandler.error('entity not found:'+a);
			return a;
		}
	}
	function appendText(end){//has some bugs
		if(end>start){
			var xt = source.substring(start,end).replace(/&#?\w+;/g,entityReplacer);
			locator&&position(start);
			domBuilder.characters(xt,0,end-start);
			start = end
		}
	}
	function position(p,m){
		while(p>=lineEnd && (m = linePattern.exec(source))){
			lineStart = m.index;
			lineEnd = lineStart + m[0].length;
			locator.lineNumber++;
			//console.log('line++:',locator,startPos,endPos)
		}
		locator.columnNumber = p-lineStart+1;
	}
	var lineStart = 0;
	var lineEnd = 0;
	var linePattern = /.*(?:\r\n?|\n)|.*$/g
	var locator = domBuilder.locator;

	var parseStack = [{currentNSMap:defaultNSMapCopy}]
	var closeMap = {};
	var start = 0;
	while(true){
		try{
			var tagStart = source.indexOf('<',start);
			if(tagStart<0){
				if(!source.substr(start).match(/^\s*$/)){
					var doc = domBuilder.doc;
	    			var text = doc.createTextNode(source.substr(start));
	    			doc.appendChild(text);
	    			domBuilder.currentElement = text;
				}
				return;
			}
			if(tagStart>start){
				appendText(tagStart);
			}
			switch(source.charAt(tagStart+1)){
			case '/':
				var end = source.indexOf('>',tagStart+3);
				var tagName = source.substring(tagStart + 2, end).replace(/[ \t\n\r]+$/g, '');
				var config = parseStack.pop();
				if(end<0){

	        		tagName = source.substring(tagStart+2).replace(/[\s<].*/,'');
	        		errorHandler.error("end tag name: "+tagName+' is not complete:'+config.tagName);
	        		end = tagStart+1+tagName.length;
	        	}else if(tagName.match(/\s</)){
	        		tagName = tagName.replace(/[\s<].*/,'');
	        		errorHandler.error("end tag name: "+tagName+' maybe not complete');
	        		end = tagStart+1+tagName.length;
				}
				var localNSMap = config.localNSMap;
				var endMatch = config.tagName == tagName;
				var endIgnoreCaseMach = endMatch || config.tagName&&config.tagName.toLowerCase() == tagName.toLowerCase()
		        if(endIgnoreCaseMach){
		        	domBuilder.endElement(config.uri,config.localName,tagName);
					if(localNSMap){
						for (var prefix in localNSMap) {
							if (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {
								domBuilder.endPrefixMapping(prefix);
							}
						}
					}
					if(!endMatch){
		            	errorHandler.fatalError("end tag name: "+tagName+' is not match the current start tagName:'+config.tagName ); // No known test case
					}
		        }else{
		        	parseStack.push(config)
		        }

				end++;
				break;
				// end elment
			case '?':// <?...?>
				locator&&position(tagStart);
				end = parseInstruction(source,tagStart,domBuilder);
				break;
			case '!':// <!doctype,<![CDATA,<!--
				locator&&position(tagStart);
				end = parseDCC(source,tagStart,domBuilder,errorHandler);
				break;
			default:
				locator&&position(tagStart);
				var el = new ElementAttributes();
				var currentNSMap = parseStack[parseStack.length-1].currentNSMap;
				//elStartEnd
				var end = parseElementStartPart(source,tagStart,el,currentNSMap,entityReplacer,errorHandler);
				var len = el.length;


				if(!el.closed && fixSelfClosed(source,end,el.tagName,closeMap)){
					el.closed = true;
					if(!entityMap.nbsp){
						errorHandler.warning('unclosed xml attribute');
					}
				}
				if(locator && len){
					var locator2 = copyLocator(locator,{});
					//try{//attribute position fixed
					for(var i = 0;i<len;i++){
						var a = el[i];
						position(a.offset);
						a.locator = copyLocator(locator,{});
					}
					domBuilder.locator = locator2
					if(appendElement(el,domBuilder,currentNSMap)){
						parseStack.push(el)
					}
					domBuilder.locator = locator;
				}else{
					if(appendElement(el,domBuilder,currentNSMap)){
						parseStack.push(el)
					}
				}

				if (NAMESPACE.isHTML(el.uri) && !el.closed) {
					end = parseHtmlSpecialContent(source,end,el.tagName,entityReplacer,domBuilder)
				} else {
					end++;
				}
			}
		}catch(e){
			if (e instanceof ParseError) {
				throw e;
			}
			errorHandler.error('element parse error: '+e)
			end = -1;
		}
		if(end>start){
			start = end;
		}else{
			//TODO: 这里有可能sax回退，有位置错误风险
			appendText(Math.max(tagStart,start)+1);
		}
	}
}
function copyLocator(f,t){
	t.lineNumber = f.lineNumber;
	t.columnNumber = f.columnNumber;
	return t;
}

/**
 * @see #appendElement(source,elStartEnd,el,selfClosed,entityReplacer,domBuilder,parseStack);
 * @return end of the elementStartPart(end of elementEndPart for selfClosed el)
 */
function parseElementStartPart(source,start,el,currentNSMap,entityReplacer,errorHandler){

	/**
	 * @param {string} qname
	 * @param {string} value
	 * @param {number} startIndex
	 */
	function addAttribute(qname, value, startIndex) {
		if (el.attributeNames.hasOwnProperty(qname)) {
			errorHandler.fatalError('Attribute ' + qname + ' redefined')
		}
		el.addValue(
			qname,
			// @see https://www.w3.org/TR/xml/#AVNormalize
			// since the xmldom sax parser does not "interpret" DTD the following is not implemented:
			// - recursive replacement of (DTD) entity references
			// - trimming and collapsing multiple spaces into a single one for attributes that are not of type CDATA
			value.replace(/[\t\n\r]/g, ' ').replace(/&#?\w+;/g, entityReplacer),
			startIndex
		)
	}
	var attrName;
	var value;
	var p = ++start;
	var s = S_TAG;//status
	while(true){
		var c = source.charAt(p);
		switch(c){
		case '=':
			if(s === S_ATTR){//attrName
				attrName = source.slice(start,p);
				s = S_EQ;
			}else if(s === S_ATTR_SPACE){
				s = S_EQ;
			}else{
				//fatalError: equal must after attrName or space after attrName
				throw new Error('attribute equal must after attrName'); // No known test case
			}
			break;
		case '\'':
		case '"':
			if(s === S_EQ || s === S_ATTR //|| s == S_ATTR_SPACE
				){//equal
				if(s === S_ATTR){
					errorHandler.warning('attribute value must after "="')
					attrName = source.slice(start,p)
				}
				start = p+1;
				p = source.indexOf(c,start)
				if(p>0){
					value = source.slice(start, p);
					addAttribute(attrName, value, start-1);
					s = S_ATTR_END;
				}else{
					//fatalError: no end quot match
					throw new Error('attribute value no end \''+c+'\' match');
				}
			}else if(s == S_ATTR_NOQUOT_VALUE){
				value = source.slice(start, p);
				addAttribute(attrName, value, start);
				errorHandler.warning('attribute "'+attrName+'" missed start quot('+c+')!!');
				start = p+1;
				s = S_ATTR_END
			}else{
				//fatalError: no equal before
				throw new Error('attribute value must after "="'); // No known test case
			}
			break;
		case '/':
			switch(s){
			case S_TAG:
				el.setTagName(source.slice(start,p));
			case S_ATTR_END:
			case S_TAG_SPACE:
			case S_TAG_CLOSE:
				s =S_TAG_CLOSE;
				el.closed = true;
			case S_ATTR_NOQUOT_VALUE:
			case S_ATTR:
				break;
				case S_ATTR_SPACE:
					el.closed = true;
				break;
			//case S_EQ:
			default:
				throw new Error("attribute invalid close char('/')") // No known test case
			}
			break;
		case ''://end document
			errorHandler.error('unexpected end of input');
			if(s == S_TAG){
				el.setTagName(source.slice(start,p));
			}
			return p;
		case '>':
			switch(s){
			case S_TAG:
				el.setTagName(source.slice(start,p));
			case S_ATTR_END:
			case S_TAG_SPACE:
			case S_TAG_CLOSE:
				break;//normal
			case S_ATTR_NOQUOT_VALUE://Compatible state
			case S_ATTR:
				value = source.slice(start,p);
				if(value.slice(-1) === '/'){
					el.closed  = true;
					value = value.slice(0,-1)
				}
			case S_ATTR_SPACE:
				if(s === S_ATTR_SPACE){
					value = attrName;
				}
				if(s == S_ATTR_NOQUOT_VALUE){
					errorHandler.warning('attribute "'+value+'" missed quot(")!');
					addAttribute(attrName, value, start)
				}else{
					if(!NAMESPACE.isHTML(currentNSMap['']) || !value.match(/^(?:disabled|checked|selected)$/i)){
						errorHandler.warning('attribute "'+value+'" missed value!! "'+value+'" instead!!')
					}
					addAttribute(value, value, start)
				}
				break;
			case S_EQ:
				throw new Error('attribute value missed!!');
			}
//			console.log(tagName,tagNamePattern,tagNamePattern.test(tagName))
			return p;
		/*xml space '\x20' | #x9 | #xD | #xA; */
		case '\u0080':
			c = ' ';
		default:
			if(c<= ' '){//space
				switch(s){
				case S_TAG:
					el.setTagName(source.slice(start,p));//tagName
					s = S_TAG_SPACE;
					break;
				case S_ATTR:
					attrName = source.slice(start,p)
					s = S_ATTR_SPACE;
					break;
				case S_ATTR_NOQUOT_VALUE:
					var value = source.slice(start, p);
					errorHandler.warning('attribute "'+value+'" missed quot(")!!');
					addAttribute(attrName, value, start)
				case S_ATTR_END:
					s = S_TAG_SPACE;
					break;
				//case S_TAG_SPACE:
				//case S_EQ:
				//case S_ATTR_SPACE:
				//	void();break;
				//case S_TAG_CLOSE:
					//ignore warning
				}
			}else{//not space
//S_TAG,	S_ATTR,	S_EQ,	S_ATTR_NOQUOT_VALUE
//S_ATTR_SPACE,	S_ATTR_END,	S_TAG_SPACE, S_TAG_CLOSE
				switch(s){
				//case S_TAG:void();break;
				//case S_ATTR:void();break;
				//case S_ATTR_NOQUOT_VALUE:void();break;
				case S_ATTR_SPACE:
					var tagName =  el.tagName;
					if (!NAMESPACE.isHTML(currentNSMap['']) || !attrName.match(/^(?:disabled|checked|selected)$/i)) {
						errorHandler.warning('attribute "'+attrName+'" missed value!! "'+attrName+'" instead2!!')
					}
					addAttribute(attrName, attrName, start);
					start = p;
					s = S_ATTR;
					break;
				case S_ATTR_END:
					errorHandler.warning('attribute space is required"'+attrName+'"!!')
				case S_TAG_SPACE:
					s = S_ATTR;
					start = p;
					break;
				case S_EQ:
					s = S_ATTR_NOQUOT_VALUE;
					start = p;
					break;
				case S_TAG_CLOSE:
					throw new Error("elements closed character '/' and '>' must be connected to");
				}
			}
		}//end outer switch
		//console.log('p++',p)
		p++;
	}
}
/**
 * @return true if has new namespace define
 */
function appendElement(el,domBuilder,currentNSMap){
	var tagName = el.tagName;
	var localNSMap = null;
	//var currentNSMap = parseStack[parseStack.length-1].currentNSMap;
	var i = el.length;
	while(i--){
		var a = el[i];
		var qName = a.qName;
		var value = a.value;
		var nsp = qName.indexOf(':');
		if(nsp>0){
			var prefix = a.prefix = qName.slice(0,nsp);
			var localName = qName.slice(nsp+1);
			var nsPrefix = prefix === 'xmlns' && localName
		}else{
			localName = qName;
			prefix = null
			nsPrefix = qName === 'xmlns' && ''
		}
		//can not set prefix,because prefix !== ''
		a.localName = localName ;
		//prefix == null for no ns prefix attribute
		if(nsPrefix !== false){//hack!!
			if(localNSMap == null){
				localNSMap = {}
				//console.log(currentNSMap,0)
				_copy(currentNSMap,currentNSMap={})
				//console.log(currentNSMap,1)
			}
			currentNSMap[nsPrefix] = localNSMap[nsPrefix] = value;
			a.uri = NAMESPACE.XMLNS
			domBuilder.startPrefixMapping(nsPrefix, value)
		}
	}
	var i = el.length;
	while(i--){
		a = el[i];
		var prefix = a.prefix;
		if(prefix){//no prefix attribute has no namespace
			if(prefix === 'xml'){
				a.uri = NAMESPACE.XML;
			}if(prefix !== 'xmlns'){
				a.uri = currentNSMap[prefix || '']

				//{console.log('###'+a.qName,domBuilder.locator.systemId+'',currentNSMap,a.uri)}
			}
		}
	}
	var nsp = tagName.indexOf(':');
	if(nsp>0){
		prefix = el.prefix = tagName.slice(0,nsp);
		localName = el.localName = tagName.slice(nsp+1);
	}else{
		prefix = null;//important!!
		localName = el.localName = tagName;
	}
	//no prefix element has default namespace
	var ns = el.uri = currentNSMap[prefix || ''];
	domBuilder.startElement(ns,localName,tagName,el);
	//endPrefixMapping and startPrefixMapping have not any help for dom builder
	//localNSMap = null
	if(el.closed){
		domBuilder.endElement(ns,localName,tagName);
		if(localNSMap){
			for (prefix in localNSMap) {
				if (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {
					domBuilder.endPrefixMapping(prefix);
				}
			}
		}
	}else{
		el.currentNSMap = currentNSMap;
		el.localNSMap = localNSMap;
		//parseStack.push(el);
		return true;
	}
}
function parseHtmlSpecialContent(source,elStartEnd,tagName,entityReplacer,domBuilder){
	if(/^(?:script|textarea)$/i.test(tagName)){
		var elEndStart =  source.indexOf('</'+tagName+'>',elStartEnd);
		var text = source.substring(elStartEnd+1,elEndStart);
		if(/[&<]/.test(text)){
			if(/^script$/i.test(tagName)){
				//if(!/\]\]>/.test(text)){
					//lexHandler.startCDATA();
					domBuilder.characters(text,0,text.length);
					//lexHandler.endCDATA();
					return elEndStart;
				//}
			}//}else{//text area
				text = text.replace(/&#?\w+;/g,entityReplacer);
				domBuilder.characters(text,0,text.length);
				return elEndStart;
			//}

		}
	}
	return elStartEnd+1;
}
function fixSelfClosed(source,elStartEnd,tagName,closeMap){
	//if(tagName in closeMap){
	var pos = closeMap[tagName];
	if(pos == null){
		//console.log(tagName)
		pos =  source.lastIndexOf('</'+tagName+'>')
		if(pos<elStartEnd){//忘记闭合
			pos = source.lastIndexOf('</'+tagName)
		}
		closeMap[tagName] =pos
	}
	return pos<elStartEnd;
	//}
}

function _copy (source, target) {
	for (var n in source) {
		if (Object.prototype.hasOwnProperty.call(source, n)) {
			target[n] = source[n];
		}
	}
}

function parseDCC(source,start,domBuilder,errorHandler){//sure start with '<!'
	var next= source.charAt(start+2)
	switch(next){
	case '-':
		if(source.charAt(start + 3) === '-'){
			var end = source.indexOf('-->',start+4);
			//append comment source.substring(4,end)//<!--
			if(end>start){
				domBuilder.comment(source,start+4,end-start-4);
				return end+3;
			}else{
				errorHandler.error("Unclosed comment");
				return -1;
			}
		}else{
			//error
			return -1;
		}
	default:
		if(source.substr(start+3,6) == 'CDATA['){
			var end = source.indexOf(']]>',start+9);
			domBuilder.startCDATA();
			domBuilder.characters(source,start+9,end-start-9);
			domBuilder.endCDATA()
			return end+3;
		}
		//<!DOCTYPE
		//startDTD(java.lang.String name, java.lang.String publicId, java.lang.String systemId)
		var matchs = split(source,start);
		var len = matchs.length;
		if(len>1 && /!doctype/i.test(matchs[0][0])){
			var name = matchs[1][0];
			var pubid = false;
			var sysid = false;
			if(len>3){
				if(/^public$/i.test(matchs[2][0])){
					pubid = matchs[3][0];
					sysid = len>4 && matchs[4][0];
				}else if(/^system$/i.test(matchs[2][0])){
					sysid = matchs[3][0];
				}
			}
			var lastMatch = matchs[len-1]
			domBuilder.startDTD(name, pubid, sysid);
			domBuilder.endDTD();

			return lastMatch.index+lastMatch[0].length
		}
	}
	return -1;
}



function parseInstruction(source,start,domBuilder){
	var end = source.indexOf('?>',start);
	if(end){
		var match = source.substring(start,end).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);
		if(match){
			var len = match[0].length;
			domBuilder.processingInstruction(match[1], match[2]) ;
			return end+2;
		}else{//error
			return -1;
		}
	}
	return -1;
}

function ElementAttributes(){
	this.attributeNames = {}
}
ElementAttributes.prototype = {
	setTagName:function(tagName){
		if(!tagNamePattern.test(tagName)){
			throw new Error('invalid tagName:'+tagName)
		}
		this.tagName = tagName
	},
	addValue:function(qName, value, offset) {
		if(!tagNamePattern.test(qName)){
			throw new Error('invalid attribute:'+qName)
		}
		this.attributeNames[qName] = this.length;
		this[this.length++] = {qName:qName,value:value,offset:offset}
	},
	length:0,
	getLocalName:function(i){return this[i].localName},
	getLocator:function(i){return this[i].locator},
	getQName:function(i){return this[i].qName},
	getURI:function(i){return this[i].uri},
	getValue:function(i){return this[i].value}
//	,getIndex:function(uri, localName)){
//		if(localName){
//
//		}else{
//			var qName = uri
//		}
//	},
//	getValue:function(){return this.getValue(this.getIndex.apply(this,arguments))},
//	getType:function(uri,localName){}
//	getType:function(i){},
}



function split(source,start){
	var match;
	var buf = [];
	var reg = /'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;
	reg.lastIndex = start;
	reg.exec(source);//skip <
	while(match = reg.exec(source)){
		buf.push(match);
		if(match[1])return buf;
	}
}

exports.XMLReader = XMLReader;
exports.ParseError = ParseError;


/***/ }),

/***/ "./node_modules/global/document.js":
/*!*****************************************!*\
  !*** ./node_modules/global/document.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var topLevel = typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g :
    typeof window !== 'undefined' ? window : {}
var minDoc = __webpack_require__(/*! min-document */ "?34aa");

var doccy;

if (typeof document !== 'undefined') {
    doccy = document;
} else {
    doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'];

    if (!doccy) {
        doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'] = minDoc;
    }
}

module.exports = doccy;


/***/ }),

/***/ "./node_modules/global/window.js":
/*!***************************************!*\
  !*** ./node_modules/global/window.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var win;

if (typeof window !== "undefined") {
    win = window;
} else if (typeof __webpack_require__.g !== "undefined") {
    win = __webpack_require__.g;
} else if (typeof self !== "undefined"){
    win = self;
} else {
    win = {};
}

module.exports = win;


/***/ }),

/***/ "./node_modules/is-function/index.js":
/*!*******************************************!*\
  !*** ./node_modules/is-function/index.js ***!
  \*******************************************/
/***/ ((module) => {

module.exports = isFunction

var toString = Object.prototype.toString

function isFunction (fn) {
  if (!fn) {
    return false
  }
  var string = toString.call(fn)
  return string === '[object Function]' ||
    (typeof fn === 'function' && string !== '[object RegExp]') ||
    (typeof window !== 'undefined' &&
     // IE8 and below
     (fn === window.setTimeout ||
      fn === window.alert ||
      fn === window.confirm ||
      fn === window.prompt))
};


/***/ }),

/***/ "./node_modules/m3u8-parser/dist/m3u8-parser.es.js":
/*!*********************************************************!*\
  !*** ./node_modules/m3u8-parser/dist/m3u8-parser.es.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineStream: () => (/* binding */ LineStream),
/* harmony export */   ParseStream: () => (/* binding */ ParseStream),
/* harmony export */   Parser: () => (/* binding */ Parser)
/* harmony export */ });
/* harmony import */ var _videojs_vhs_utils_es_stream_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @videojs/vhs-utils/es/stream.js */ "./node_modules/@videojs/vhs-utils/es/stream.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _videojs_vhs_utils_es_decode_b64_to_uint8_array_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @videojs/vhs-utils/es/decode-b64-to-uint8-array.js */ "./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js");
/*! @name m3u8-parser @version 7.2.0 @license Apache-2.0 */




/**
 * @file m3u8/line-stream.js
 */
/**
 * A stream that buffers string input and generates a `data` event for each
 * line.
 *
 * @class LineStream
 * @extends Stream
 */

class LineStream extends _videojs_vhs_utils_es_stream_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super();
    this.buffer = '';
  }
  /**
   * Add new data to be parsed.
   *
   * @param {string} data the text to process
   */


  push(data) {
    let nextNewline;
    this.buffer += data;
    nextNewline = this.buffer.indexOf('\n');

    for (; nextNewline > -1; nextNewline = this.buffer.indexOf('\n')) {
      this.trigger('data', this.buffer.substring(0, nextNewline));
      this.buffer = this.buffer.substring(nextNewline + 1);
    }
  }

}

const TAB = String.fromCharCode(0x09);

const parseByterange = function (byterangeString) {
  // optionally match and capture 0+ digits before `@`
  // optionally match and capture 0+ digits after `@`
  const match = /([0-9.]*)?@?([0-9.]*)?/.exec(byterangeString || '');
  const result = {};

  if (match[1]) {
    result.length = parseInt(match[1], 10);
  }

  if (match[2]) {
    result.offset = parseInt(match[2], 10);
  }

  return result;
};
/**
 * "forgiving" attribute list psuedo-grammar:
 * attributes -> keyvalue (',' keyvalue)*
 * keyvalue   -> key '=' value
 * key        -> [^=]*
 * value      -> '"' [^"]* '"' | [^,]*
 */


const attributeSeparator = function () {
  const key = '[^=]*';
  const value = '"[^"]*"|[^,]*';
  const keyvalue = '(?:' + key + ')=(?:' + value + ')';
  return new RegExp('(?:^|,)(' + keyvalue + ')');
};
/**
 * Parse attributes from a line given the separator
 *
 * @param {string} attributes the attribute line to parse
 */


const parseAttributes = function (attributes) {
  const result = {};

  if (!attributes) {
    return result;
  } // split the string using attributes as the separator


  const attrs = attributes.split(attributeSeparator());
  let i = attrs.length;
  let attr;

  while (i--) {
    // filter out unmatched portions of the string
    if (attrs[i] === '') {
      continue;
    } // split the key and value


    attr = /([^=]*)=(.*)/.exec(attrs[i]).slice(1); // trim whitespace and remove optional quotes around the value

    attr[0] = attr[0].replace(/^\s+|\s+$/g, '');
    attr[1] = attr[1].replace(/^\s+|\s+$/g, '');
    attr[1] = attr[1].replace(/^['"](.*)['"]$/g, '$1');
    result[attr[0]] = attr[1];
  }

  return result;
};
/**
 * Converts a string into a resolution object
 *
 * @param {string} resolution a string such as 3840x2160
 *
 * @return {Object} An object representing the resolution
 *
 */


const parseResolution = resolution => {
  const split = resolution.split('x');
  const result = {};

  if (split[0]) {
    result.width = parseInt(split[0], 10);
  }

  if (split[1]) {
    result.height = parseInt(split[1], 10);
  }

  return result;
};
/**
 * A line-level M3U8 parser event stream. It expects to receive input one
 * line at a time and performs a context-free parse of its contents. A stream
 * interpretation of a manifest can be useful if the manifest is expected to
 * be too large to fit comfortably into memory or the entirety of the input
 * is not immediately available. Otherwise, it's probably much easier to work
 * with a regular `Parser` object.
 *
 * Produces `data` events with an object that captures the parser's
 * interpretation of the input. That object has a property `tag` that is one
 * of `uri`, `comment`, or `tag`. URIs only have a single additional
 * property, `line`, which captures the entirety of the input without
 * interpretation. Comments similarly have a single additional property
 * `text` which is the input without the leading `#`.
 *
 * Tags always have a property `tagType` which is the lower-cased version of
 * the M3U8 directive without the `#EXT` or `#EXT-X-` prefix. For instance,
 * `#EXT-X-MEDIA-SEQUENCE` becomes `media-sequence` when parsed. Unrecognized
 * tags are given the tag type `unknown` and a single additional property
 * `data` with the remainder of the input.
 *
 * @class ParseStream
 * @extends Stream
 */


class ParseStream extends _videojs_vhs_utils_es_stream_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super();
    this.customParsers = [];
    this.tagMappers = [];
  }
  /**
   * Parses an additional line of input.
   *
   * @param {string} line a single line of an M3U8 file to parse
   */


  push(line) {
    let match;
    let event; // strip whitespace

    line = line.trim();

    if (line.length === 0) {
      // ignore empty lines
      return;
    } // URIs


    if (line[0] !== '#') {
      this.trigger('data', {
        type: 'uri',
        uri: line
      });
      return;
    } // map tags


    const newLines = this.tagMappers.reduce((acc, mapper) => {
      const mappedLine = mapper(line); // skip if unchanged

      if (mappedLine === line) {
        return acc;
      }

      return acc.concat([mappedLine]);
    }, [line]);
    newLines.forEach(newLine => {
      for (let i = 0; i < this.customParsers.length; i++) {
        if (this.customParsers[i].call(this, newLine)) {
          return;
        }
      } // Comments


      if (newLine.indexOf('#EXT') !== 0) {
        this.trigger('data', {
          type: 'comment',
          text: newLine.slice(1)
        });
        return;
      } // strip off any carriage returns here so the regex matching
      // doesn't have to account for them.


      newLine = newLine.replace('\r', ''); // Tags

      match = /^#EXTM3U/.exec(newLine);

      if (match) {
        this.trigger('data', {
          type: 'tag',
          tagType: 'm3u'
        });
        return;
      }

      match = /^#EXTINF:([0-9\.]*)?,?(.*)?$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'inf'
        };

        if (match[1]) {
          event.duration = parseFloat(match[1]);
        }

        if (match[2]) {
          event.title = match[2];
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-TARGETDURATION:([0-9.]*)?/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'targetduration'
        };

        if (match[1]) {
          event.duration = parseInt(match[1], 10);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-VERSION:([0-9.]*)?/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'version'
        };

        if (match[1]) {
          event.version = parseInt(match[1], 10);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-MEDIA-SEQUENCE:(\-?[0-9.]*)?/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'media-sequence'
        };

        if (match[1]) {
          event.number = parseInt(match[1], 10);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-DISCONTINUITY-SEQUENCE:(\-?[0-9.]*)?/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'discontinuity-sequence'
        };

        if (match[1]) {
          event.number = parseInt(match[1], 10);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-PLAYLIST-TYPE:(.*)?$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'playlist-type'
        };

        if (match[1]) {
          event.playlistType = match[1];
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-BYTERANGE:(.*)?$/.exec(newLine);

      if (match) {
        event = (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])(parseByterange(match[1]), {
          type: 'tag',
          tagType: 'byterange'
        });
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-ALLOW-CACHE:(YES|NO)?/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'allow-cache'
        };

        if (match[1]) {
          event.allowed = !/NO/.test(match[1]);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-MAP:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'map'
        };

        if (match[1]) {
          const attributes = parseAttributes(match[1]);

          if (attributes.URI) {
            event.uri = attributes.URI;
          }

          if (attributes.BYTERANGE) {
            event.byterange = parseByterange(attributes.BYTERANGE);
          }
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-STREAM-INF:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'stream-inf'
        };

        if (match[1]) {
          event.attributes = parseAttributes(match[1]);

          if (event.attributes.RESOLUTION) {
            event.attributes.RESOLUTION = parseResolution(event.attributes.RESOLUTION);
          }

          if (event.attributes.BANDWIDTH) {
            event.attributes.BANDWIDTH = parseInt(event.attributes.BANDWIDTH, 10);
          }

          if (event.attributes['FRAME-RATE']) {
            event.attributes['FRAME-RATE'] = parseFloat(event.attributes['FRAME-RATE']);
          }

          if (event.attributes['PROGRAM-ID']) {
            event.attributes['PROGRAM-ID'] = parseInt(event.attributes['PROGRAM-ID'], 10);
          }
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-MEDIA:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'media'
        };

        if (match[1]) {
          event.attributes = parseAttributes(match[1]);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-ENDLIST/.exec(newLine);

      if (match) {
        this.trigger('data', {
          type: 'tag',
          tagType: 'endlist'
        });
        return;
      }

      match = /^#EXT-X-DISCONTINUITY/.exec(newLine);

      if (match) {
        this.trigger('data', {
          type: 'tag',
          tagType: 'discontinuity'
        });
        return;
      }

      match = /^#EXT-X-PROGRAM-DATE-TIME:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'program-date-time'
        };

        if (match[1]) {
          event.dateTimeString = match[1];
          event.dateTimeObject = new Date(match[1]);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-KEY:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'key'
        };

        if (match[1]) {
          event.attributes = parseAttributes(match[1]); // parse the IV string into a Uint32Array

          if (event.attributes.IV) {
            if (event.attributes.IV.substring(0, 2).toLowerCase() === '0x') {
              event.attributes.IV = event.attributes.IV.substring(2);
            }

            event.attributes.IV = event.attributes.IV.match(/.{8}/g);
            event.attributes.IV[0] = parseInt(event.attributes.IV[0], 16);
            event.attributes.IV[1] = parseInt(event.attributes.IV[1], 16);
            event.attributes.IV[2] = parseInt(event.attributes.IV[2], 16);
            event.attributes.IV[3] = parseInt(event.attributes.IV[3], 16);
            event.attributes.IV = new Uint32Array(event.attributes.IV);
          }
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-START:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'start'
        };

        if (match[1]) {
          event.attributes = parseAttributes(match[1]);
          event.attributes['TIME-OFFSET'] = parseFloat(event.attributes['TIME-OFFSET']);
          event.attributes.PRECISE = /YES/.test(event.attributes.PRECISE);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-CUE-OUT-CONT:(.*)?$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'cue-out-cont'
        };

        if (match[1]) {
          event.data = match[1];
        } else {
          event.data = '';
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-CUE-OUT:(.*)?$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'cue-out'
        };

        if (match[1]) {
          event.data = match[1];
        } else {
          event.data = '';
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-CUE-IN:?(.*)?$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'cue-in'
        };

        if (match[1]) {
          event.data = match[1];
        } else {
          event.data = '';
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-SKIP:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'skip'
        };
        event.attributes = parseAttributes(match[1]);

        if (event.attributes.hasOwnProperty('SKIPPED-SEGMENTS')) {
          event.attributes['SKIPPED-SEGMENTS'] = parseInt(event.attributes['SKIPPED-SEGMENTS'], 10);
        }

        if (event.attributes.hasOwnProperty('RECENTLY-REMOVED-DATERANGES')) {
          event.attributes['RECENTLY-REMOVED-DATERANGES'] = event.attributes['RECENTLY-REMOVED-DATERANGES'].split(TAB);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-PART:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'part'
        };
        event.attributes = parseAttributes(match[1]);
        ['DURATION'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseFloat(event.attributes[key]);
          }
        });
        ['INDEPENDENT', 'GAP'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = /YES/.test(event.attributes[key]);
          }
        });

        if (event.attributes.hasOwnProperty('BYTERANGE')) {
          event.attributes.byterange = parseByterange(event.attributes.BYTERANGE);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-SERVER-CONTROL:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'server-control'
        };
        event.attributes = parseAttributes(match[1]);
        ['CAN-SKIP-UNTIL', 'PART-HOLD-BACK', 'HOLD-BACK'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseFloat(event.attributes[key]);
          }
        });
        ['CAN-SKIP-DATERANGES', 'CAN-BLOCK-RELOAD'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = /YES/.test(event.attributes[key]);
          }
        });
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-PART-INF:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'part-inf'
        };
        event.attributes = parseAttributes(match[1]);
        ['PART-TARGET'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseFloat(event.attributes[key]);
          }
        });
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-PRELOAD-HINT:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'preload-hint'
        };
        event.attributes = parseAttributes(match[1]);
        ['BYTERANGE-START', 'BYTERANGE-LENGTH'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseInt(event.attributes[key], 10);
            const subkey = key === 'BYTERANGE-LENGTH' ? 'length' : 'offset';
            event.attributes.byterange = event.attributes.byterange || {};
            event.attributes.byterange[subkey] = event.attributes[key]; // only keep the parsed byterange object.

            delete event.attributes[key];
          }
        });
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-RENDITION-REPORT:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'rendition-report'
        };
        event.attributes = parseAttributes(match[1]);
        ['LAST-MSN', 'LAST-PART'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseInt(event.attributes[key], 10);
          }
        });
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-DATERANGE:(.*)$/.exec(newLine);

      if (match && match[1]) {
        event = {
          type: 'tag',
          tagType: 'daterange'
        };
        event.attributes = parseAttributes(match[1]);
        ['ID', 'CLASS'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = String(event.attributes[key]);
          }
        });
        ['START-DATE', 'END-DATE'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = new Date(event.attributes[key]);
          }
        });
        ['DURATION', 'PLANNED-DURATION'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = parseFloat(event.attributes[key]);
          }
        });
        ['END-ON-NEXT'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = /YES/i.test(event.attributes[key]);
          }
        });
        ['SCTE35-CMD', ' SCTE35-OUT', 'SCTE35-IN'].forEach(function (key) {
          if (event.attributes.hasOwnProperty(key)) {
            event.attributes[key] = event.attributes[key].toString(16);
          }
        });
        const clientAttributePattern = /^X-([A-Z]+-)+[A-Z]+$/;

        for (const key in event.attributes) {
          if (!clientAttributePattern.test(key)) {
            continue;
          }

          const isHexaDecimal = /[0-9A-Fa-f]{6}/g.test(event.attributes[key]);
          const isDecimalFloating = /^\d+(\.\d+)?$/.test(event.attributes[key]);
          event.attributes[key] = isHexaDecimal ? event.attributes[key].toString(16) : isDecimalFloating ? parseFloat(event.attributes[key]) : String(event.attributes[key]);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-INDEPENDENT-SEGMENTS/.exec(newLine);

      if (match) {
        this.trigger('data', {
          type: 'tag',
          tagType: 'independent-segments'
        });
        return;
      }

      match = /^#EXT-X-I-FRAMES-ONLY/.exec(newLine);

      if (match) {
        this.trigger('data', {
          type: 'tag',
          tagType: 'i-frames-only'
        });
        return;
      }

      match = /^#EXT-X-CONTENT-STEERING:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'content-steering'
        };
        event.attributes = parseAttributes(match[1]);
        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-I-FRAME-STREAM-INF:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'i-frame-playlist'
        };
        event.attributes = parseAttributes(match[1]);

        if (event.attributes.URI) {
          event.uri = event.attributes.URI;
        }

        if (event.attributes.BANDWIDTH) {
          event.attributes.BANDWIDTH = parseInt(event.attributes.BANDWIDTH, 10);
        }

        if (event.attributes.RESOLUTION) {
          event.attributes.RESOLUTION = parseResolution(event.attributes.RESOLUTION);
        }

        if (event.attributes['AVERAGE-BANDWIDTH']) {
          event.attributes['AVERAGE-BANDWIDTH'] = parseInt(event.attributes['AVERAGE-BANDWIDTH'], 10);
        }

        if (event.attributes['FRAME-RATE']) {
          event.attributes['FRAME-RATE'] = parseFloat(event.attributes['FRAME-RATE']);
        }

        this.trigger('data', event);
        return;
      }

      match = /^#EXT-X-DEFINE:(.*)$/.exec(newLine);

      if (match) {
        event = {
          type: 'tag',
          tagType: 'define'
        };
        event.attributes = parseAttributes(match[1]);
        this.trigger('data', event);
        return;
      } // unknown tag type


      this.trigger('data', {
        type: 'tag',
        data: newLine.slice(4)
      });
    });
  }
  /**
   * Add a parser for custom headers
   *
   * @param {Object}   options              a map of options for the added parser
   * @param {RegExp}   options.expression   a regular expression to match the custom header
   * @param {string}   options.customType   the custom type to register to the output
   * @param {Function} [options.dataParser] function to parse the line into an object
   * @param {boolean}  [options.segment]    should tag data be attached to the segment object
   */


  addParser({
    expression,
    customType,
    dataParser,
    segment
  }) {
    if (typeof dataParser !== 'function') {
      dataParser = line => line;
    }

    this.customParsers.push(line => {
      const match = expression.exec(line);

      if (match) {
        this.trigger('data', {
          type: 'custom',
          data: dataParser(line),
          customType,
          segment
        });
        return true;
      }
    });
  }
  /**
   * Add a custom header mapper
   *
   * @param {Object}   options
   * @param {RegExp}   options.expression   a regular expression to match the custom header
   * @param {Function} options.map          function to translate tag into a different tag
   */


  addTagMapper({
    expression,
    map
  }) {
    const mapFn = line => {
      if (expression.test(line)) {
        return map(line);
      }

      return line;
    };

    this.tagMappers.push(mapFn);
  }

}

const camelCase = str => str.toLowerCase().replace(/-(\w)/g, a => a[1].toUpperCase());

const camelCaseKeys = function (attributes) {
  const result = {};
  Object.keys(attributes).forEach(function (key) {
    result[camelCase(key)] = attributes[key];
  });
  return result;
}; // set SERVER-CONTROL hold back based upon targetDuration and partTargetDuration
// we need this helper because defaults are based upon targetDuration and
// partTargetDuration being set, but they may not be if SERVER-CONTROL appears before
// target durations are set.


const setHoldBack = function (manifest) {
  const {
    serverControl,
    targetDuration,
    partTargetDuration
  } = manifest;

  if (!serverControl) {
    return;
  }

  const tag = '#EXT-X-SERVER-CONTROL';
  const hb = 'holdBack';
  const phb = 'partHoldBack';
  const minTargetDuration = targetDuration && targetDuration * 3;
  const minPartDuration = partTargetDuration && partTargetDuration * 2;

  if (targetDuration && !serverControl.hasOwnProperty(hb)) {
    serverControl[hb] = minTargetDuration;
    this.trigger('info', {
      message: `${tag} defaulting HOLD-BACK to targetDuration * 3 (${minTargetDuration}).`
    });
  }

  if (minTargetDuration && serverControl[hb] < minTargetDuration) {
    this.trigger('warn', {
      message: `${tag} clamping HOLD-BACK (${serverControl[hb]}) to targetDuration * 3 (${minTargetDuration})`
    });
    serverControl[hb] = minTargetDuration;
  } // default no part hold back to part target duration * 3


  if (partTargetDuration && !serverControl.hasOwnProperty(phb)) {
    serverControl[phb] = partTargetDuration * 3;
    this.trigger('info', {
      message: `${tag} defaulting PART-HOLD-BACK to partTargetDuration * 3 (${serverControl[phb]}).`
    });
  } // if part hold back is too small default it to part target duration * 2


  if (partTargetDuration && serverControl[phb] < minPartDuration) {
    this.trigger('warn', {
      message: `${tag} clamping PART-HOLD-BACK (${serverControl[phb]}) to partTargetDuration * 2 (${minPartDuration}).`
    });
    serverControl[phb] = minPartDuration;
  }
};
/**
 * A parser for M3U8 files. The current interpretation of the input is
 * exposed as a property `manifest` on parser objects. It's just two lines to
 * create and parse a manifest once you have the contents available as a string:
 *
 * ```js
 * var parser = new m3u8.Parser();
 * parser.push(xhr.responseText);
 * ```
 *
 * New input can later be applied to update the manifest object by calling
 * `push` again.
 *
 * The parser attempts to create a usable manifest object even if the
 * underlying input is somewhat nonsensical. It emits `info` and `warning`
 * events during the parse if it encounters input that seems invalid or
 * requires some property of the manifest object to be defaulted.
 *
 * @class Parser
 * @param {Object} [opts] Options for the constructor, needed for substitutions
 * @param {string} [opts.uri] URL to check for query params
 * @param {Object} [opts.mainDefinitions] Definitions on main playlist that can be imported
 * @extends Stream
 */


class Parser extends _videojs_vhs_utils_es_stream_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(opts = {}) {
    super();
    this.lineStream = new LineStream();
    this.parseStream = new ParseStream();
    this.lineStream.pipe(this.parseStream);
    this.mainDefinitions = opts.mainDefinitions || {};
    this.params = new URL(opts.uri, 'https://a.com').searchParams;
    this.lastProgramDateTime = null;
    /* eslint-disable consistent-this */

    const self = this;
    /* eslint-enable consistent-this */

    const uris = [];
    let currentUri = {}; // if specified, the active EXT-X-MAP definition

    let currentMap; // if specified, the active decryption key

    let key;
    let hasParts = false;

    const noop = function () {};

    const defaultMediaGroups = {
      'AUDIO': {},
      'VIDEO': {},
      'CLOSED-CAPTIONS': {},
      'SUBTITLES': {}
    }; // This is the Widevine UUID from DASH IF IOP. The same exact string is
    // used in MPDs with Widevine encrypted streams.

    const widevineUuid = 'urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed'; // group segments into numbered timelines delineated by discontinuities

    let currentTimeline = 0; // the manifest is empty until the parse stream begins delivering data

    this.manifest = {
      allowCache: true,
      discontinuityStarts: [],
      dateRanges: [],
      iFramePlaylists: [],
      segments: []
    }; // keep track of the last seen segment's byte range end, as segments are not required
    // to provide the offset, in which case it defaults to the next byte after the
    // previous segment

    let lastByterangeEnd = 0; // keep track of the last seen part's byte range end.

    let lastPartByterangeEnd = 0;
    const dateRangeTags = {};
    this.on('end', () => {
      // only add preloadSegment if we don't yet have a uri for it.
      // and we actually have parts/preloadHints
      if (currentUri.uri || !currentUri.parts && !currentUri.preloadHints) {
        return;
      }

      if (!currentUri.map && currentMap) {
        currentUri.map = currentMap;
      }

      if (!currentUri.key && key) {
        currentUri.key = key;
      }

      if (!currentUri.timeline && typeof currentTimeline === 'number') {
        currentUri.timeline = currentTimeline;
      }

      this.manifest.preloadSegment = currentUri;
    }); // update the manifest with the m3u8 entry from the parse stream

    this.parseStream.on('data', function (entry) {
      let mediaGroup;
      let rendition; // Replace variables in uris and attributes as defined in #EXT-X-DEFINE tags

      if (self.manifest.definitions) {
        for (const def in self.manifest.definitions) {
          if (entry.uri) {
            entry.uri = entry.uri.replace(`{$${def}}`, self.manifest.definitions[def]);
          }

          if (entry.attributes) {
            for (const attr in entry.attributes) {
              if (typeof entry.attributes[attr] === 'string') {
                entry.attributes[attr] = entry.attributes[attr].replace(`{$${def}}`, self.manifest.definitions[def]);
              }
            }
          }
        }
      }

      ({
        tag() {
          // switch based on the tag type
          (({
            version() {
              if (entry.version) {
                this.manifest.version = entry.version;
              }
            },

            'allow-cache'() {
              this.manifest.allowCache = entry.allowed;

              if (!('allowed' in entry)) {
                this.trigger('info', {
                  message: 'defaulting allowCache to YES'
                });
                this.manifest.allowCache = true;
              }
            },

            byterange() {
              const byterange = {};

              if ('length' in entry) {
                currentUri.byterange = byterange;
                byterange.length = entry.length;

                if (!('offset' in entry)) {
                  /*
                   * From the latest spec (as of this writing):
                   * https://tools.ietf.org/html/draft-pantos-http-live-streaming-23#section-4.3.2.2
                   *
                   * Same text since EXT-X-BYTERANGE's introduction in draft 7:
                   * https://tools.ietf.org/html/draft-pantos-http-live-streaming-07#section-3.3.1)
                   *
                   * "If o [offset] is not present, the sub-range begins at the next byte
                   * following the sub-range of the previous media segment."
                   */
                  entry.offset = lastByterangeEnd;
                }
              }

              if ('offset' in entry) {
                currentUri.byterange = byterange;
                byterange.offset = entry.offset;
              }

              lastByterangeEnd = byterange.offset + byterange.length;
            },

            endlist() {
              this.manifest.endList = true;
            },

            inf() {
              if (!('mediaSequence' in this.manifest)) {
                this.manifest.mediaSequence = 0;
                this.trigger('info', {
                  message: 'defaulting media sequence to zero'
                });
              }

              if (!('discontinuitySequence' in this.manifest)) {
                this.manifest.discontinuitySequence = 0;
                this.trigger('info', {
                  message: 'defaulting discontinuity sequence to zero'
                });
              }

              if (entry.title) {
                currentUri.title = entry.title;
              }

              if (entry.duration > 0) {
                currentUri.duration = entry.duration;
              }

              if (entry.duration === 0) {
                currentUri.duration = 0.01;
                this.trigger('info', {
                  message: 'updating zero segment duration to a small value'
                });
              }

              this.manifest.segments = uris;
            },

            key() {
              if (!entry.attributes) {
                this.trigger('warn', {
                  message: 'ignoring key declaration without attribute list'
                });
                return;
              } // clear the active encryption key


              if (entry.attributes.METHOD === 'NONE') {
                key = null;
                return;
              }

              if (!entry.attributes.URI) {
                this.trigger('warn', {
                  message: 'ignoring key declaration without URI'
                });
                return;
              }

              if (entry.attributes.KEYFORMAT === 'com.apple.streamingkeydelivery') {
                this.manifest.contentProtection = this.manifest.contentProtection || {}; // TODO: add full support for this.

                this.manifest.contentProtection['com.apple.fps.1_0'] = {
                  attributes: entry.attributes
                };
                return;
              }

              if (entry.attributes.KEYFORMAT === 'com.microsoft.playready') {
                this.manifest.contentProtection = this.manifest.contentProtection || {}; // TODO: add full support for this.

                this.manifest.contentProtection['com.microsoft.playready'] = {
                  uri: entry.attributes.URI
                };
                return;
              } // check if the content is encrypted for Widevine
              // Widevine/HLS spec: https://storage.googleapis.com/wvdocs/Widevine_DRM_HLS.pdf


              if (entry.attributes.KEYFORMAT === widevineUuid) {
                const VALID_METHODS = ['SAMPLE-AES', 'SAMPLE-AES-CTR', 'SAMPLE-AES-CENC'];

                if (VALID_METHODS.indexOf(entry.attributes.METHOD) === -1) {
                  this.trigger('warn', {
                    message: 'invalid key method provided for Widevine'
                  });
                  return;
                }

                if (entry.attributes.METHOD === 'SAMPLE-AES-CENC') {
                  this.trigger('warn', {
                    message: 'SAMPLE-AES-CENC is deprecated, please use SAMPLE-AES-CTR instead'
                  });
                }

                if (entry.attributes.URI.substring(0, 23) !== 'data:text/plain;base64,') {
                  this.trigger('warn', {
                    message: 'invalid key URI provided for Widevine'
                  });
                  return;
                }

                if (!(entry.attributes.KEYID && entry.attributes.KEYID.substring(0, 2) === '0x')) {
                  this.trigger('warn', {
                    message: 'invalid key ID provided for Widevine'
                  });
                  return;
                } // if Widevine key attributes are valid, store them as `contentProtection`
                // on the manifest to emulate Widevine tag structure in a DASH mpd


                this.manifest.contentProtection = this.manifest.contentProtection || {};
                this.manifest.contentProtection['com.widevine.alpha'] = {
                  attributes: {
                    schemeIdUri: entry.attributes.KEYFORMAT,
                    // remove '0x' from the key id string
                    keyId: entry.attributes.KEYID.substring(2)
                  },
                  // decode the base64-encoded PSSH box
                  pssh: (0,_videojs_vhs_utils_es_decode_b64_to_uint8_array_js__WEBPACK_IMPORTED_MODULE_2__["default"])(entry.attributes.URI.split(',')[1])
                };
                return;
              }

              if (!entry.attributes.METHOD) {
                this.trigger('warn', {
                  message: 'defaulting key method to AES-128'
                });
              } // setup an encryption key for upcoming segments


              key = {
                method: entry.attributes.METHOD || 'AES-128',
                uri: entry.attributes.URI
              };

              if (typeof entry.attributes.IV !== 'undefined') {
                key.iv = entry.attributes.IV;
              }
            },

            'media-sequence'() {
              if (!isFinite(entry.number)) {
                this.trigger('warn', {
                  message: 'ignoring invalid media sequence: ' + entry.number
                });
                return;
              }

              this.manifest.mediaSequence = entry.number;
            },

            'discontinuity-sequence'() {
              if (!isFinite(entry.number)) {
                this.trigger('warn', {
                  message: 'ignoring invalid discontinuity sequence: ' + entry.number
                });
                return;
              }

              this.manifest.discontinuitySequence = entry.number;
              currentTimeline = entry.number;
            },

            'playlist-type'() {
              if (!/VOD|EVENT/.test(entry.playlistType)) {
                this.trigger('warn', {
                  message: 'ignoring unknown playlist type: ' + entry.playlist
                });
                return;
              }

              this.manifest.playlistType = entry.playlistType;
            },

            map() {
              currentMap = {};

              if (entry.uri) {
                currentMap.uri = entry.uri;
              }

              if (entry.byterange) {
                currentMap.byterange = entry.byterange;
              }

              if (key) {
                currentMap.key = key;
              }
            },

            'stream-inf'() {
              this.manifest.playlists = uris;
              this.manifest.mediaGroups = this.manifest.mediaGroups || defaultMediaGroups;

              if (!entry.attributes) {
                this.trigger('warn', {
                  message: 'ignoring empty stream-inf attributes'
                });
                return;
              }

              if (!currentUri.attributes) {
                currentUri.attributes = {};
              }

              (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])(currentUri.attributes, entry.attributes);
            },

            media() {
              this.manifest.mediaGroups = this.manifest.mediaGroups || defaultMediaGroups;

              if (!(entry.attributes && entry.attributes.TYPE && entry.attributes['GROUP-ID'] && entry.attributes.NAME)) {
                this.trigger('warn', {
                  message: 'ignoring incomplete or missing media group'
                });
                return;
              } // find the media group, creating defaults as necessary


              const mediaGroupType = this.manifest.mediaGroups[entry.attributes.TYPE];
              mediaGroupType[entry.attributes['GROUP-ID']] = mediaGroupType[entry.attributes['GROUP-ID']] || {};
              mediaGroup = mediaGroupType[entry.attributes['GROUP-ID']]; // collect the rendition metadata

              rendition = {
                default: /yes/i.test(entry.attributes.DEFAULT)
              };

              if (rendition.default) {
                rendition.autoselect = true;
              } else {
                rendition.autoselect = /yes/i.test(entry.attributes.AUTOSELECT);
              }

              if (entry.attributes.LANGUAGE) {
                rendition.language = entry.attributes.LANGUAGE;
              }

              if (entry.attributes.URI) {
                rendition.uri = entry.attributes.URI;
              }

              if (entry.attributes['INSTREAM-ID']) {
                rendition.instreamId = entry.attributes['INSTREAM-ID'];
              }

              if (entry.attributes.CHARACTERISTICS) {
                rendition.characteristics = entry.attributes.CHARACTERISTICS;
              }

              if (entry.attributes.FORCED) {
                rendition.forced = /yes/i.test(entry.attributes.FORCED);
              } // insert the new rendition


              mediaGroup[entry.attributes.NAME] = rendition;
            },

            discontinuity() {
              currentTimeline += 1;
              currentUri.discontinuity = true;
              this.manifest.discontinuityStarts.push(uris.length);
            },

            'program-date-time'() {
              if (typeof this.manifest.dateTimeString === 'undefined') {
                // PROGRAM-DATE-TIME is a media-segment tag, but for backwards
                // compatibility, we add the first occurence of the PROGRAM-DATE-TIME tag
                // to the manifest object
                // TODO: Consider removing this in future major version
                this.manifest.dateTimeString = entry.dateTimeString;
                this.manifest.dateTimeObject = entry.dateTimeObject;
              }

              currentUri.dateTimeString = entry.dateTimeString;
              currentUri.dateTimeObject = entry.dateTimeObject;
              const {
                lastProgramDateTime
              } = this;
              this.lastProgramDateTime = new Date(entry.dateTimeString).getTime(); // We should extrapolate Program Date Time backward only during first program date time occurrence.
              // Once we have at least one program date time point, we can always extrapolate it forward using lastProgramDateTime reference.

              if (lastProgramDateTime === null) {
                // Extrapolate Program Date Time backward
                // Since it is first program date time occurrence we're assuming that
                // all this.manifest.segments have no program date time info
                this.manifest.segments.reduceRight((programDateTime, segment) => {
                  segment.programDateTime = programDateTime - segment.duration * 1000;
                  return segment.programDateTime;
                }, this.lastProgramDateTime);
              }
            },

            targetduration() {
              if (!isFinite(entry.duration) || entry.duration < 0) {
                this.trigger('warn', {
                  message: 'ignoring invalid target duration: ' + entry.duration
                });
                return;
              }

              this.manifest.targetDuration = entry.duration;
              setHoldBack.call(this, this.manifest);
            },

            start() {
              if (!entry.attributes || isNaN(entry.attributes['TIME-OFFSET'])) {
                this.trigger('warn', {
                  message: 'ignoring start declaration without appropriate attribute list'
                });
                return;
              }

              this.manifest.start = {
                timeOffset: entry.attributes['TIME-OFFSET'],
                precise: entry.attributes.PRECISE
              };
            },

            'cue-out'() {
              currentUri.cueOut = entry.data;
            },

            'cue-out-cont'() {
              currentUri.cueOutCont = entry.data;
            },

            'cue-in'() {
              currentUri.cueIn = entry.data;
            },

            'skip'() {
              this.manifest.skip = camelCaseKeys(entry.attributes);
              this.warnOnMissingAttributes_('#EXT-X-SKIP', entry.attributes, ['SKIPPED-SEGMENTS']);
            },

            'part'() {
              hasParts = true; // parts are always specifed before a segment

              const segmentIndex = this.manifest.segments.length;
              const part = camelCaseKeys(entry.attributes);
              currentUri.parts = currentUri.parts || [];
              currentUri.parts.push(part);

              if (part.byterange) {
                if (!part.byterange.hasOwnProperty('offset')) {
                  part.byterange.offset = lastPartByterangeEnd;
                }

                lastPartByterangeEnd = part.byterange.offset + part.byterange.length;
              }

              const partIndex = currentUri.parts.length - 1;
              this.warnOnMissingAttributes_(`#EXT-X-PART #${partIndex} for segment #${segmentIndex}`, entry.attributes, ['URI', 'DURATION']);

              if (this.manifest.renditionReports) {
                this.manifest.renditionReports.forEach((r, i) => {
                  if (!r.hasOwnProperty('lastPart')) {
                    this.trigger('warn', {
                      message: `#EXT-X-RENDITION-REPORT #${i} lacks required attribute(s): LAST-PART`
                    });
                  }
                });
              }
            },

            'server-control'() {
              const attrs = this.manifest.serverControl = camelCaseKeys(entry.attributes);

              if (!attrs.hasOwnProperty('canBlockReload')) {
                attrs.canBlockReload = false;
                this.trigger('info', {
                  message: '#EXT-X-SERVER-CONTROL defaulting CAN-BLOCK-RELOAD to false'
                });
              }

              setHoldBack.call(this, this.manifest);

              if (attrs.canSkipDateranges && !attrs.hasOwnProperty('canSkipUntil')) {
                this.trigger('warn', {
                  message: '#EXT-X-SERVER-CONTROL lacks required attribute CAN-SKIP-UNTIL which is required when CAN-SKIP-DATERANGES is set'
                });
              }
            },

            'preload-hint'() {
              // parts are always specifed before a segment
              const segmentIndex = this.manifest.segments.length;
              const hint = camelCaseKeys(entry.attributes);
              const isPart = hint.type && hint.type === 'PART';
              currentUri.preloadHints = currentUri.preloadHints || [];
              currentUri.preloadHints.push(hint);

              if (hint.byterange) {
                if (!hint.byterange.hasOwnProperty('offset')) {
                  // use last part byterange end or zero if not a part.
                  hint.byterange.offset = isPart ? lastPartByterangeEnd : 0;

                  if (isPart) {
                    lastPartByterangeEnd = hint.byterange.offset + hint.byterange.length;
                  }
                }
              }

              const index = currentUri.preloadHints.length - 1;
              this.warnOnMissingAttributes_(`#EXT-X-PRELOAD-HINT #${index} for segment #${segmentIndex}`, entry.attributes, ['TYPE', 'URI']);

              if (!hint.type) {
                return;
              } // search through all preload hints except for the current one for
              // a duplicate type.


              for (let i = 0; i < currentUri.preloadHints.length - 1; i++) {
                const otherHint = currentUri.preloadHints[i];

                if (!otherHint.type) {
                  continue;
                }

                if (otherHint.type === hint.type) {
                  this.trigger('warn', {
                    message: `#EXT-X-PRELOAD-HINT #${index} for segment #${segmentIndex} has the same TYPE ${hint.type} as preload hint #${i}`
                  });
                }
              }
            },

            'rendition-report'() {
              const report = camelCaseKeys(entry.attributes);
              this.manifest.renditionReports = this.manifest.renditionReports || [];
              this.manifest.renditionReports.push(report);
              const index = this.manifest.renditionReports.length - 1;
              const required = ['LAST-MSN', 'URI'];

              if (hasParts) {
                required.push('LAST-PART');
              }

              this.warnOnMissingAttributes_(`#EXT-X-RENDITION-REPORT #${index}`, entry.attributes, required);
            },

            'part-inf'() {
              this.manifest.partInf = camelCaseKeys(entry.attributes);
              this.warnOnMissingAttributes_('#EXT-X-PART-INF', entry.attributes, ['PART-TARGET']);

              if (this.manifest.partInf.partTarget) {
                this.manifest.partTargetDuration = this.manifest.partInf.partTarget;
              }

              setHoldBack.call(this, this.manifest);
            },

            'daterange'() {
              this.manifest.dateRanges.push(camelCaseKeys(entry.attributes));
              const index = this.manifest.dateRanges.length - 1;
              this.warnOnMissingAttributes_(`#EXT-X-DATERANGE #${index}`, entry.attributes, ['ID', 'START-DATE']);
              const dateRange = this.manifest.dateRanges[index];

              if (dateRange.endDate && dateRange.startDate && new Date(dateRange.endDate) < new Date(dateRange.startDate)) {
                this.trigger('warn', {
                  message: 'EXT-X-DATERANGE END-DATE must be equal to or later than the value of the START-DATE'
                });
              }

              if (dateRange.duration && dateRange.duration < 0) {
                this.trigger('warn', {
                  message: 'EXT-X-DATERANGE DURATION must not be negative'
                });
              }

              if (dateRange.plannedDuration && dateRange.plannedDuration < 0) {
                this.trigger('warn', {
                  message: 'EXT-X-DATERANGE PLANNED-DURATION must not be negative'
                });
              }

              const endOnNextYes = !!dateRange.endOnNext;

              if (endOnNextYes && !dateRange.class) {
                this.trigger('warn', {
                  message: 'EXT-X-DATERANGE with an END-ON-NEXT=YES attribute must have a CLASS attribute'
                });
              }

              if (endOnNextYes && (dateRange.duration || dateRange.endDate)) {
                this.trigger('warn', {
                  message: 'EXT-X-DATERANGE with an END-ON-NEXT=YES attribute must not contain DURATION or END-DATE attributes'
                });
              }

              if (dateRange.duration && dateRange.endDate) {
                const startDate = dateRange.startDate;
                const newDateInSeconds = startDate.getTime() + dateRange.duration * 1000;
                this.manifest.dateRanges[index].endDate = new Date(newDateInSeconds);
              }

              if (!dateRangeTags[dateRange.id]) {
                dateRangeTags[dateRange.id] = dateRange;
              } else {
                for (const attribute in dateRangeTags[dateRange.id]) {
                  if (!!dateRange[attribute] && JSON.stringify(dateRangeTags[dateRange.id][attribute]) !== JSON.stringify(dateRange[attribute])) {
                    this.trigger('warn', {
                      message: 'EXT-X-DATERANGE tags with the same ID in a playlist must have the same attributes values'
                    });
                    break;
                  }
                } // if tags with the same ID do not have conflicting attributes, merge them


                const dateRangeWithSameId = this.manifest.dateRanges.findIndex(dateRangeToFind => dateRangeToFind.id === dateRange.id);
                this.manifest.dateRanges[dateRangeWithSameId] = (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])(this.manifest.dateRanges[dateRangeWithSameId], dateRange);
                dateRangeTags[dateRange.id] = (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])(dateRangeTags[dateRange.id], dateRange); // after merging, delete the duplicate dateRange that was added last

                this.manifest.dateRanges.pop();
              }
            },

            'independent-segments'() {
              this.manifest.independentSegments = true;
            },

            'i-frames-only'() {
              this.manifest.iFramesOnly = true;
              this.requiredCompatibilityversion(this.manifest.version, 4);
            },

            'content-steering'() {
              this.manifest.contentSteering = camelCaseKeys(entry.attributes);
              this.warnOnMissingAttributes_('#EXT-X-CONTENT-STEERING', entry.attributes, ['SERVER-URI']);
            },

            /** @this {Parser} */
            define() {
              this.manifest.definitions = this.manifest.definitions || {};

              const addDef = (n, v) => {
                if (n in this.manifest.definitions) {
                  // An EXT-X-DEFINE tag MUST NOT specify the same Variable Name as any other
                  // EXT-X-DEFINE tag in the same Playlist.  Parsers that encounter duplicate
                  // Variable Name declarations MUST fail to parse the Playlist.
                  this.trigger('error', {
                    message: `EXT-X-DEFINE: Duplicate name ${n}`
                  });
                  return;
                }

                this.manifest.definitions[n] = v;
              };

              if ('QUERYPARAM' in entry.attributes) {
                if ('NAME' in entry.attributes || 'IMPORT' in entry.attributes) {
                  // An EXT-X-DEFINE tag MUST contain either a NAME, an IMPORT, or a
                  // QUERYPARAM attribute, but only one of the three.  Otherwise, the
                  // client MUST fail to parse the Playlist.
                  this.trigger('error', {
                    message: 'EXT-X-DEFINE: Invalid attributes'
                  });
                  return;
                }

                const val = this.params.get(entry.attributes.QUERYPARAM);

                if (!val) {
                  // If the QUERYPARAM attribute value does not match any query parameter in
                  // the URI or the matching parameter has no associated value, the parser
                  // MUST fail to parse the Playlist.  If more than one parameter matches,
                  // any of the associated values MAY be used.
                  this.trigger('error', {
                    message: `EXT-X-DEFINE: No query param ${entry.attributes.QUERYPARAM}`
                  });
                  return;
                }

                addDef(entry.attributes.QUERYPARAM, decodeURIComponent(val));
                return;
              }

              if ('NAME' in entry.attributes) {
                if ('IMPORT' in entry.attributes) {
                  // An EXT-X-DEFINE tag MUST contain either a NAME, an IMPORT, or a
                  // QUERYPARAM attribute, but only one of the three.  Otherwise, the
                  // client MUST fail to parse the Playlist.
                  this.trigger('error', {
                    message: 'EXT-X-DEFINE: Invalid attributes'
                  });
                  return;
                }

                if (!('VALUE' in entry.attributes) || typeof entry.attributes.VALUE !== 'string') {
                  // This attribute is REQUIRED if the EXT-X-DEFINE tag has a NAME attribute.
                  // The quoted-string MAY be empty.
                  this.trigger('error', {
                    message: `EXT-X-DEFINE: No value for ${entry.attributes.NAME}`
                  });
                  return;
                }

                addDef(entry.attributes.NAME, entry.attributes.VALUE);
                return;
              }

              if ('IMPORT' in entry.attributes) {
                if (!this.mainDefinitions[entry.attributes.IMPORT]) {
                  // Covers two conditions, as mainDefinitions will always be empty on main
                  //
                  // EXT-X-DEFINE tags containing the IMPORT attribute MUST NOT occur in
                  // Multivariant Playlists; they are only allowed in Media Playlists.
                  //
                  // If the IMPORT attribute value does not match any Variable Name in the
                  // Multivariant Playlist, or if the Media Playlist loaded from a
                  // Multivariant Playlist, the parser MUST fail the Playlist.
                  this.trigger('error', {
                    message: `EXT-X-DEFINE: No value ${entry.attributes.IMPORT} to import, or IMPORT used on main playlist`
                  });
                  return;
                }

                addDef(entry.attributes.IMPORT, this.mainDefinitions[entry.attributes.IMPORT]);
                return;
              } // An EXT-X-DEFINE tag MUST contain either a NAME, an IMPORT, or a QUERYPARAM
              // attribute, but only one of the three.  Otherwise, the client MUST fail to
              // parse the Playlist.


              this.trigger('error', {
                message: 'EXT-X-DEFINE: No attribute'
              });
            },

            'i-frame-playlist'() {
              this.manifest.iFramePlaylists.push({
                attributes: entry.attributes,
                uri: entry.uri,
                timeline: currentTimeline
              });
              this.warnOnMissingAttributes_('#EXT-X-I-FRAME-STREAM-INF', entry.attributes, ['BANDWIDTH', 'URI']);
            }

          })[entry.tagType] || noop).call(self);
        },

        uri() {
          currentUri.uri = entry.uri;
          uris.push(currentUri); // if no explicit duration was declared, use the target duration

          if (this.manifest.targetDuration && !('duration' in currentUri)) {
            this.trigger('warn', {
              message: 'defaulting segment duration to the target duration'
            });
            currentUri.duration = this.manifest.targetDuration;
          } // annotate with encryption information, if necessary


          if (key) {
            currentUri.key = key;
          }

          currentUri.timeline = currentTimeline; // annotate with initialization segment information, if necessary

          if (currentMap) {
            currentUri.map = currentMap;
          } // reset the last byterange end as it needs to be 0 between parts


          lastPartByterangeEnd = 0; // Once we have at least one program date time we can always extrapolate it forward

          if (this.lastProgramDateTime !== null) {
            currentUri.programDateTime = this.lastProgramDateTime;
            this.lastProgramDateTime += currentUri.duration * 1000;
          } // prepare for the next URI


          currentUri = {};
        },

        comment() {// comments are not important for playback
        },

        custom() {
          // if this is segment-level data attach the output to the segment
          if (entry.segment) {
            currentUri.custom = currentUri.custom || {};
            currentUri.custom[entry.customType] = entry.data; // if this is manifest-level data attach to the top level manifest object
          } else {
            this.manifest.custom = this.manifest.custom || {};
            this.manifest.custom[entry.customType] = entry.data;
          }
        }

      })[entry.type].call(self);
    });
  }

  requiredCompatibilityversion(currentVersion, targetVersion) {
    if (currentVersion < targetVersion || !currentVersion) {
      this.trigger('warn', {
        message: `manifest must be at least version ${targetVersion}`
      });
    }
  }

  warnOnMissingAttributes_(identifier, attributes, required) {
    const missing = [];
    required.forEach(function (key) {
      if (!attributes.hasOwnProperty(key)) {
        missing.push(key);
      }
    });

    if (missing.length) {
      this.trigger('warn', {
        message: `${identifier} lacks required attribute(s): ${missing.join(', ')}`
      });
    }
  }
  /**
   * Parse the input string and update the manifest object.
   *
   * @param {string} chunk a potentially incomplete portion of the manifest
   */


  push(chunk) {
    this.lineStream.push(chunk);
  }
  /**
   * Flush any remaining input. This can be handy if the last line of an M3U8
   * manifest did not contain a trailing newline but the file has been
   * completely received.
   */


  end() {
    // flush any buffered input
    this.lineStream.push('\n');

    if (this.manifest.dateRanges.length && this.lastProgramDateTime === null) {
      this.trigger('warn', {
        message: 'A playlist with EXT-X-DATERANGE tag must contain atleast one EXT-X-PROGRAM-DATE-TIME tag'
      });
    }

    this.lastProgramDateTime = null;
    this.trigger('end');
  }
  /**
   * Add an additional parser for non-standard tags
   *
   * @param {Object}   options              a map of options for the added parser
   * @param {RegExp}   options.expression   a regular expression to match the custom header
   * @param {string}   options.customType   the custom type to register to the output
   * @param {Function} [options.dataParser] function to parse the line into an object
   * @param {boolean}  [options.segment]    should tag data be attached to the segment object
   */


  addParser(options) {
    this.parseStream.addParser(options);
  }
  /**
   * Add a custom header mapper
   *
   * @param {Object}   options
   * @param {RegExp}   options.expression   a regular expression to match the custom header
   * @param {Function} options.map          function to translate tag into a different tag
   */


  addTagMapper(options) {
    this.parseStream.addTagMapper(options);
  }

}




/***/ }),

/***/ "./node_modules/mpd-parser/dist/mpd-parser.es.js":
/*!*******************************************************!*\
  !*** ./node_modules/mpd-parser/dist/mpd-parser.es.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VERSION: () => (/* binding */ VERSION),
/* harmony export */   addSidxSegmentsToPlaylist: () => (/* binding */ addSidxSegmentsToPlaylist$1),
/* harmony export */   generateSidxKey: () => (/* binding */ generateSidxKey),
/* harmony export */   inheritAttributes: () => (/* binding */ inheritAttributes),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   parseUTCTiming: () => (/* binding */ parseUTCTiming),
/* harmony export */   stringToMpdXml: () => (/* binding */ stringToMpdXml),
/* harmony export */   toM3u8: () => (/* binding */ toM3u8),
/* harmony export */   toPlaylists: () => (/* binding */ toPlaylists)
/* harmony export */ });
/* harmony import */ var _videojs_vhs_utils_es_resolve_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @videojs/vhs-utils/es/resolve-url */ "./node_modules/@videojs/vhs-utils/es/resolve-url.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");
/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _videojs_vhs_utils_es_media_groups__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @videojs/vhs-utils/es/media-groups */ "./node_modules/@videojs/vhs-utils/es/media-groups.js");
/* harmony import */ var _videojs_vhs_utils_es_decode_b64_to_uint8_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @videojs/vhs-utils/es/decode-b64-to-uint8-array */ "./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js");
/* harmony import */ var _xmldom_xmldom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @xmldom/xmldom */ "./node_modules/@xmldom/xmldom/lib/index.js");
/*! @name mpd-parser @version 1.3.1 @license Apache-2.0 */






var version = "1.3.1";

const isObject = obj => {
  return !!obj && typeof obj === 'object';
};

const merge = (...objects) => {
  return objects.reduce((result, source) => {
    if (typeof source !== 'object') {
      return result;
    }

    Object.keys(source).forEach(key => {
      if (Array.isArray(result[key]) && Array.isArray(source[key])) {
        result[key] = result[key].concat(source[key]);
      } else if (isObject(result[key]) && isObject(source[key])) {
        result[key] = merge(result[key], source[key]);
      } else {
        result[key] = source[key];
      }
    });
    return result;
  }, {});
};
const values = o => Object.keys(o).map(k => o[k]);

const range = (start, end) => {
  const result = [];

  for (let i = start; i < end; i++) {
    result.push(i);
  }

  return result;
};
const flatten = lists => lists.reduce((x, y) => x.concat(y), []);
const from = list => {
  if (!list.length) {
    return [];
  }

  const result = [];

  for (let i = 0; i < list.length; i++) {
    result.push(list[i]);
  }

  return result;
};
const findIndexes = (l, key) => l.reduce((a, e, i) => {
  if (e[key]) {
    a.push(i);
  }

  return a;
}, []);
/**
 * Returns a union of the included lists provided each element can be identified by a key.
 *
 * @param {Array} list - list of lists to get the union of
 * @param {Function} keyFunction - the function to use as a key for each element
 *
 * @return {Array} the union of the arrays
 */

const union = (lists, keyFunction) => {
  return values(lists.reduce((acc, list) => {
    list.forEach(el => {
      acc[keyFunction(el)] = el;
    });
    return acc;
  }, {}));
};

var errors = {
  INVALID_NUMBER_OF_PERIOD: 'INVALID_NUMBER_OF_PERIOD',
  INVALID_NUMBER_OF_CONTENT_STEERING: 'INVALID_NUMBER_OF_CONTENT_STEERING',
  DASH_EMPTY_MANIFEST: 'DASH_EMPTY_MANIFEST',
  DASH_INVALID_XML: 'DASH_INVALID_XML',
  NO_BASE_URL: 'NO_BASE_URL',
  MISSING_SEGMENT_INFORMATION: 'MISSING_SEGMENT_INFORMATION',
  SEGMENT_TIME_UNSPECIFIED: 'SEGMENT_TIME_UNSPECIFIED',
  UNSUPPORTED_UTC_TIMING_SCHEME: 'UNSUPPORTED_UTC_TIMING_SCHEME'
};

/**
 * @typedef {Object} SingleUri
 * @property {string} uri - relative location of segment
 * @property {string} resolvedUri - resolved location of segment
 * @property {Object} byterange - Object containing information on how to make byte range
 *   requests following byte-range-spec per RFC2616.
 * @property {String} byterange.length - length of range request
 * @property {String} byterange.offset - byte offset of range request
 *
 * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.1
 */

/**
 * Converts a URLType node (5.3.9.2.3 Table 13) to a segment object
 * that conforms to how m3u8-parser is structured
 *
 * @see https://github.com/videojs/m3u8-parser
 *
 * @param {string} baseUrl - baseUrl provided by <BaseUrl> nodes
 * @param {string} source - source url for segment
 * @param {string} range - optional range used for range calls,
 *   follows  RFC 2616, Clause 14.35.1
 * @return {SingleUri} full segment information transformed into a format similar
 *   to m3u8-parser
 */

const urlTypeToSegment = ({
  baseUrl = '',
  source = '',
  range = '',
  indexRange = ''
}) => {
  const segment = {
    uri: source,
    resolvedUri: (0,_videojs_vhs_utils_es_resolve_url__WEBPACK_IMPORTED_MODULE_0__["default"])(baseUrl || '', source)
  };

  if (range || indexRange) {
    const rangeStr = range ? range : indexRange;
    const ranges = rangeStr.split('-'); // default to parsing this as a BigInt if possible

    let startRange = (global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt) ? global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(ranges[0]) : parseInt(ranges[0], 10);
    let endRange = (global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt) ? global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(ranges[1]) : parseInt(ranges[1], 10); // convert back to a number if less than MAX_SAFE_INTEGER

    if (startRange < Number.MAX_SAFE_INTEGER && typeof startRange === 'bigint') {
      startRange = Number(startRange);
    }

    if (endRange < Number.MAX_SAFE_INTEGER && typeof endRange === 'bigint') {
      endRange = Number(endRange);
    }

    let length;

    if (typeof endRange === 'bigint' || typeof startRange === 'bigint') {
      length = global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(endRange) - global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(startRange) + global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(1);
    } else {
      length = endRange - startRange + 1;
    }

    if (typeof length === 'bigint' && length < Number.MAX_SAFE_INTEGER) {
      length = Number(length);
    } // byterange should be inclusive according to
    // RFC 2616, Clause 14.35.1


    segment.byterange = {
      length,
      offset: startRange
    };
  }

  return segment;
};
const byteRangeToString = byterange => {
  // `endRange` is one less than `offset + length` because the HTTP range
  // header uses inclusive ranges
  let endRange;

  if (typeof byterange.offset === 'bigint' || typeof byterange.length === 'bigint') {
    endRange = global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(byterange.offset) + global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(byterange.length) - global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(1);
  } else {
    endRange = byterange.offset + byterange.length - 1;
  }

  return `${byterange.offset}-${endRange}`;
};

/**
 * parse the end number attribue that can be a string
 * number, or undefined.
 *
 * @param {string|number|undefined} endNumber
 *        The end number attribute.
 *
 * @return {number|null}
 *          The result of parsing the end number.
 */

const parseEndNumber = endNumber => {
  if (endNumber && typeof endNumber !== 'number') {
    endNumber = parseInt(endNumber, 10);
  }

  if (isNaN(endNumber)) {
    return null;
  }

  return endNumber;
};
/**
 * Functions for calculating the range of available segments in static and dynamic
 * manifests.
 */


const segmentRange = {
  /**
   * Returns the entire range of available segments for a static MPD
   *
   * @param {Object} attributes
   *        Inheritied MPD attributes
   * @return {{ start: number, end: number }}
   *         The start and end numbers for available segments
   */
  static(attributes) {
    const {
      duration,
      timescale = 1,
      sourceDuration,
      periodDuration
    } = attributes;
    const endNumber = parseEndNumber(attributes.endNumber);
    const segmentDuration = duration / timescale;

    if (typeof endNumber === 'number') {
      return {
        start: 0,
        end: endNumber
      };
    }

    if (typeof periodDuration === 'number') {
      return {
        start: 0,
        end: periodDuration / segmentDuration
      };
    }

    return {
      start: 0,
      end: sourceDuration / segmentDuration
    };
  },

  /**
   * Returns the current live window range of available segments for a dynamic MPD
   *
   * @param {Object} attributes
   *        Inheritied MPD attributes
   * @return {{ start: number, end: number }}
   *         The start and end numbers for available segments
   */
  dynamic(attributes) {
    const {
      NOW,
      clientOffset,
      availabilityStartTime,
      timescale = 1,
      duration,
      periodStart = 0,
      minimumUpdatePeriod = 0,
      timeShiftBufferDepth = Infinity
    } = attributes;
    const endNumber = parseEndNumber(attributes.endNumber); // clientOffset is passed in at the top level of mpd-parser and is an offset calculated
    // after retrieving UTC server time.

    const now = (NOW + clientOffset) / 1000; // WC stands for Wall Clock.
    // Convert the period start time to EPOCH.

    const periodStartWC = availabilityStartTime + periodStart; // Period end in EPOCH is manifest's retrieval time + time until next update.

    const periodEndWC = now + minimumUpdatePeriod;
    const periodDuration = periodEndWC - periodStartWC;
    const segmentCount = Math.ceil(periodDuration * timescale / duration);
    const availableStart = Math.floor((now - periodStartWC - timeShiftBufferDepth) * timescale / duration);
    const availableEnd = Math.floor((now - periodStartWC) * timescale / duration);
    return {
      start: Math.max(0, availableStart),
      end: typeof endNumber === 'number' ? endNumber : Math.min(segmentCount, availableEnd)
    };
  }

};
/**
 * Maps a range of numbers to objects with information needed to build the corresponding
 * segment list
 *
 * @name toSegmentsCallback
 * @function
 * @param {number} number
 *        Number of the segment
 * @param {number} index
 *        Index of the number in the range list
 * @return {{ number: Number, duration: Number, timeline: Number, time: Number }}
 *         Object with segment timing and duration info
 */

/**
 * Returns a callback for Array.prototype.map for mapping a range of numbers to
 * information needed to build the segment list.
 *
 * @param {Object} attributes
 *        Inherited MPD attributes
 * @return {toSegmentsCallback}
 *         Callback map function
 */

const toSegments = attributes => number => {
  const {
    duration,
    timescale = 1,
    periodStart,
    startNumber = 1
  } = attributes;
  return {
    number: startNumber + number,
    duration: duration / timescale,
    timeline: periodStart,
    time: number * duration
  };
};
/**
 * Returns a list of objects containing segment timing and duration info used for
 * building the list of segments. This uses the @duration attribute specified
 * in the MPD manifest to derive the range of segments.
 *
 * @param {Object} attributes
 *        Inherited MPD attributes
 * @return {{number: number, duration: number, time: number, timeline: number}[]}
 *         List of Objects with segment timing and duration info
 */

const parseByDuration = attributes => {
  const {
    type,
    duration,
    timescale = 1,
    periodDuration,
    sourceDuration
  } = attributes;
  const {
    start,
    end
  } = segmentRange[type](attributes);
  const segments = range(start, end).map(toSegments(attributes));

  if (type === 'static') {
    const index = segments.length - 1; // section is either a period or the full source

    const sectionDuration = typeof periodDuration === 'number' ? periodDuration : sourceDuration; // final segment may be less than full segment duration

    segments[index].duration = sectionDuration - duration / timescale * index;
  }

  return segments;
};

/**
 * Translates SegmentBase into a set of segments.
 * (DASH SPEC Section 5.3.9.3.2) contains a set of <SegmentURL> nodes.  Each
 * node should be translated into segment.
 *
 * @param {Object} attributes
 *   Object containing all inherited attributes from parent elements with attribute
 *   names as keys
 * @return {Object.<Array>} list of segments
 */

const segmentsFromBase = attributes => {
  const {
    baseUrl,
    initialization = {},
    sourceDuration,
    indexRange = '',
    periodStart,
    presentationTime,
    number = 0,
    duration
  } = attributes; // base url is required for SegmentBase to work, per spec (Section 5.3.9.2.1)

  if (!baseUrl) {
    throw new Error(errors.NO_BASE_URL);
  }

  const initSegment = urlTypeToSegment({
    baseUrl,
    source: initialization.sourceURL,
    range: initialization.range
  });
  const segment = urlTypeToSegment({
    baseUrl,
    source: baseUrl,
    indexRange
  });
  segment.map = initSegment; // If there is a duration, use it, otherwise use the given duration of the source
  // (since SegmentBase is only for one total segment)

  if (duration) {
    const segmentTimeInfo = parseByDuration(attributes);

    if (segmentTimeInfo.length) {
      segment.duration = segmentTimeInfo[0].duration;
      segment.timeline = segmentTimeInfo[0].timeline;
    }
  } else if (sourceDuration) {
    segment.duration = sourceDuration;
    segment.timeline = periodStart;
  } // If presentation time is provided, these segments are being generated by SIDX
  // references, and should use the time provided. For the general case of SegmentBase,
  // there should only be one segment in the period, so its presentation time is the same
  // as its period start.


  segment.presentationTime = presentationTime || periodStart;
  segment.number = number;
  return [segment];
};
/**
 * Given a playlist, a sidx box, and a baseUrl, update the segment list of the playlist
 * according to the sidx information given.
 *
 * playlist.sidx has metadadata about the sidx where-as the sidx param
 * is the parsed sidx box itself.
 *
 * @param {Object} playlist the playlist to update the sidx information for
 * @param {Object} sidx the parsed sidx box
 * @return {Object} the playlist object with the updated sidx information
 */

const addSidxSegmentsToPlaylist$1 = (playlist, sidx, baseUrl) => {
  // Retain init segment information
  const initSegment = playlist.sidx.map ? playlist.sidx.map : null; // Retain source duration from initial main manifest parsing

  const sourceDuration = playlist.sidx.duration; // Retain source timeline

  const timeline = playlist.timeline || 0;
  const sidxByteRange = playlist.sidx.byterange;
  const sidxEnd = sidxByteRange.offset + sidxByteRange.length; // Retain timescale of the parsed sidx

  const timescale = sidx.timescale; // referenceType 1 refers to other sidx boxes

  const mediaReferences = sidx.references.filter(r => r.referenceType !== 1);
  const segments = [];
  const type = playlist.endList ? 'static' : 'dynamic';
  const periodStart = playlist.sidx.timeline;
  let presentationTime = periodStart;
  let number = playlist.mediaSequence || 0; // firstOffset is the offset from the end of the sidx box

  let startIndex; // eslint-disable-next-line

  if (typeof sidx.firstOffset === 'bigint') {
    startIndex = global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(sidxEnd) + sidx.firstOffset;
  } else {
    startIndex = sidxEnd + sidx.firstOffset;
  }

  for (let i = 0; i < mediaReferences.length; i++) {
    const reference = sidx.references[i]; // size of the referenced (sub)segment

    const size = reference.referencedSize; // duration of the referenced (sub)segment, in  the  timescale
    // this will be converted to seconds when generating segments

    const duration = reference.subsegmentDuration; // should be an inclusive range

    let endIndex; // eslint-disable-next-line

    if (typeof startIndex === 'bigint') {
      endIndex = startIndex + global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(size) - global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(1);
    } else {
      endIndex = startIndex + size - 1;
    }

    const indexRange = `${startIndex}-${endIndex}`;
    const attributes = {
      baseUrl,
      timescale,
      timeline,
      periodStart,
      presentationTime,
      number,
      duration,
      sourceDuration,
      indexRange,
      type
    };
    const segment = segmentsFromBase(attributes)[0];

    if (initSegment) {
      segment.map = initSegment;
    }

    segments.push(segment);

    if (typeof startIndex === 'bigint') {
      startIndex += global_window__WEBPACK_IMPORTED_MODULE_1___default().BigInt(size);
    } else {
      startIndex += size;
    }

    presentationTime += duration / timescale;
    number++;
  }

  playlist.segments = segments;
  return playlist;
};

const SUPPORTED_MEDIA_TYPES = ['AUDIO', 'SUBTITLES']; // allow one 60fps frame as leniency (arbitrarily chosen)

const TIME_FUDGE = 1 / 60;
/**
 * Given a list of timelineStarts, combines, dedupes, and sorts them.
 *
 * @param {TimelineStart[]} timelineStarts - list of timeline starts
 *
 * @return {TimelineStart[]} the combined and deduped timeline starts
 */

const getUniqueTimelineStarts = timelineStarts => {
  return union(timelineStarts, ({
    timeline
  }) => timeline).sort((a, b) => a.timeline > b.timeline ? 1 : -1);
};
/**
 * Finds the playlist with the matching NAME attribute.
 *
 * @param {Array} playlists - playlists to search through
 * @param {string} name - the NAME attribute to search for
 *
 * @return {Object|null} the matching playlist object, or null
 */

const findPlaylistWithName = (playlists, name) => {
  for (let i = 0; i < playlists.length; i++) {
    if (playlists[i].attributes.NAME === name) {
      return playlists[i];
    }
  }

  return null;
};
/**
 * Gets a flattened array of media group playlists.
 *
 * @param {Object} manifest - the main manifest object
 *
 * @return {Array} the media group playlists
 */

const getMediaGroupPlaylists = manifest => {
  let mediaGroupPlaylists = [];
  (0,_videojs_vhs_utils_es_media_groups__WEBPACK_IMPORTED_MODULE_2__.forEachMediaGroup)(manifest, SUPPORTED_MEDIA_TYPES, (properties, type, group, label) => {
    mediaGroupPlaylists = mediaGroupPlaylists.concat(properties.playlists || []);
  });
  return mediaGroupPlaylists;
};
/**
 * Updates the playlist's media sequence numbers.
 *
 * @param {Object} config - options object
 * @param {Object} config.playlist - the playlist to update
 * @param {number} config.mediaSequence - the mediaSequence number to start with
 */

const updateMediaSequenceForPlaylist = ({
  playlist,
  mediaSequence
}) => {
  playlist.mediaSequence = mediaSequence;
  playlist.segments.forEach((segment, index) => {
    segment.number = playlist.mediaSequence + index;
  });
};
/**
 * Updates the media and discontinuity sequence numbers of newPlaylists given oldPlaylists
 * and a complete list of timeline starts.
 *
 * If no matching playlist is found, only the discontinuity sequence number of the playlist
 * will be updated.
 *
 * Since early available timelines are not supported, at least one segment must be present.
 *
 * @param {Object} config - options object
 * @param {Object[]} oldPlaylists - the old playlists to use as a reference
 * @param {Object[]} newPlaylists - the new playlists to update
 * @param {Object} timelineStarts - all timelineStarts seen in the stream to this point
 */

const updateSequenceNumbers = ({
  oldPlaylists,
  newPlaylists,
  timelineStarts
}) => {
  newPlaylists.forEach(playlist => {
    playlist.discontinuitySequence = timelineStarts.findIndex(function ({
      timeline
    }) {
      return timeline === playlist.timeline;
    }); // Playlists NAMEs come from DASH Representation IDs, which are mandatory
    // (see ISO_23009-1-2012 5.3.5.2).
    //
    // If the same Representation existed in a prior Period, it will retain the same NAME.

    const oldPlaylist = findPlaylistWithName(oldPlaylists, playlist.attributes.NAME);

    if (!oldPlaylist) {
      // Since this is a new playlist, the media sequence values can start from 0 without
      // consequence.
      return;
    } // TODO better support for live SIDX
    //
    // As of this writing, mpd-parser does not support multiperiod SIDX (in live or VOD).
    // This is evident by a playlist only having a single SIDX reference. In a multiperiod
    // playlist there would need to be multiple SIDX references. In addition, live SIDX is
    // not supported when the SIDX properties change on refreshes.
    //
    // In the future, if support needs to be added, the merging logic here can be called
    // after SIDX references are resolved. For now, exit early to prevent exceptions being
    // thrown due to undefined references.


    if (playlist.sidx) {
      return;
    } // Since we don't yet support early available timelines, we don't need to support
    // playlists with no segments.


    const firstNewSegment = playlist.segments[0];
    const oldMatchingSegmentIndex = oldPlaylist.segments.findIndex(function (oldSegment) {
      return Math.abs(oldSegment.presentationTime - firstNewSegment.presentationTime) < TIME_FUDGE;
    }); // No matching segment from the old playlist means the entire playlist was refreshed.
    // In this case the media sequence should account for this update, and the new segments
    // should be marked as discontinuous from the prior content, since the last prior
    // timeline was removed.

    if (oldMatchingSegmentIndex === -1) {
      updateMediaSequenceForPlaylist({
        playlist,
        mediaSequence: oldPlaylist.mediaSequence + oldPlaylist.segments.length
      });
      playlist.segments[0].discontinuity = true;
      playlist.discontinuityStarts.unshift(0); // No matching segment does not necessarily mean there's missing content.
      //
      // If the new playlist's timeline is the same as the last seen segment's timeline,
      // then a discontinuity can be added to identify that there's potentially missing
      // content. If there's no missing content, the discontinuity should still be rather
      // harmless. It's possible that if segment durations are accurate enough, that the
      // existence of a gap can be determined using the presentation times and durations,
      // but if the segment timing info is off, it may introduce more problems than simply
      // adding the discontinuity.
      //
      // If the new playlist's timeline is different from the last seen segment's timeline,
      // then a discontinuity can be added to identify that this is the first seen segment
      // of a new timeline. However, the logic at the start of this function that
      // determined the disconinuity sequence by timeline index is now off by one (the
      // discontinuity of the newest timeline hasn't yet fallen off the manifest...since
      // we added it), so the disconinuity sequence must be decremented.
      //
      // A period may also have a duration of zero, so the case of no segments is handled
      // here even though we don't yet support early available periods.

      if (!oldPlaylist.segments.length && playlist.timeline > oldPlaylist.timeline || oldPlaylist.segments.length && playlist.timeline > oldPlaylist.segments[oldPlaylist.segments.length - 1].timeline) {
        playlist.discontinuitySequence--;
      }

      return;
    } // If the first segment matched with a prior segment on a discontinuity (it's matching
    // on the first segment of a period), then the discontinuitySequence shouldn't be the
    // timeline's matching one, but instead should be the one prior, and the first segment
    // of the new manifest should be marked with a discontinuity.
    //
    // The reason for this special case is that discontinuity sequence shows how many
    // discontinuities have fallen off of the playlist, and discontinuities are marked on
    // the first segment of a new "timeline." Because of this, while DASH will retain that
    // Period while the "timeline" exists, HLS keeps track of it via the discontinuity
    // sequence, and that first segment is an indicator, but can be removed before that
    // timeline is gone.


    const oldMatchingSegment = oldPlaylist.segments[oldMatchingSegmentIndex];

    if (oldMatchingSegment.discontinuity && !firstNewSegment.discontinuity) {
      firstNewSegment.discontinuity = true;
      playlist.discontinuityStarts.unshift(0);
      playlist.discontinuitySequence--;
    }

    updateMediaSequenceForPlaylist({
      playlist,
      mediaSequence: oldPlaylist.segments[oldMatchingSegmentIndex].number
    });
  });
};
/**
 * Given an old parsed manifest object and a new parsed manifest object, updates the
 * sequence and timing values within the new manifest to ensure that it lines up with the
 * old.
 *
 * @param {Array} oldManifest - the old main manifest object
 * @param {Array} newManifest - the new main manifest object
 *
 * @return {Object} the updated new manifest object
 */

const positionManifestOnTimeline = ({
  oldManifest,
  newManifest
}) => {
  // Starting from v4.1.2 of the IOP, section 4.4.3.3 states:
  //
  // "MPD@availabilityStartTime and Period@start shall not be changed over MPD updates."
  //
  // This was added from https://github.com/Dash-Industry-Forum/DASH-IF-IOP/issues/160
  //
  // Because of this change, and the difficulty of supporting periods with changing start
  // times, periods with changing start times are not supported. This makes the logic much
  // simpler, since periods with the same start time can be considerred the same period
  // across refreshes.
  //
  // To give an example as to the difficulty of handling periods where the start time may
  // change, if a single period manifest is refreshed with another manifest with a single
  // period, and both the start and end times are increased, then the only way to determine
  // if it's a new period or an old one that has changed is to look through the segments of
  // each playlist and determine the presentation time bounds to find a match. In addition,
  // if the period start changed to exceed the old period end, then there would be no
  // match, and it would not be possible to determine whether the refreshed period is a new
  // one or the old one.
  const oldPlaylists = oldManifest.playlists.concat(getMediaGroupPlaylists(oldManifest));
  const newPlaylists = newManifest.playlists.concat(getMediaGroupPlaylists(newManifest)); // Save all seen timelineStarts to the new manifest. Although this potentially means that
  // there's a "memory leak" in that it will never stop growing, in reality, only a couple
  // of properties are saved for each seen Period. Even long running live streams won't
  // generate too many Periods, unless the stream is watched for decades. In the future,
  // this can be optimized by mapping to discontinuity sequence numbers for each timeline,
  // but it may not become an issue, and the additional info can be useful for debugging.

  newManifest.timelineStarts = getUniqueTimelineStarts([oldManifest.timelineStarts, newManifest.timelineStarts]);
  updateSequenceNumbers({
    oldPlaylists,
    newPlaylists,
    timelineStarts: newManifest.timelineStarts
  });
  return newManifest;
};

const generateSidxKey = sidx => sidx && sidx.uri + '-' + byteRangeToString(sidx.byterange);

const mergeDiscontiguousPlaylists = playlists => {
  // Break out playlists into groups based on their baseUrl
  const playlistsByBaseUrl = playlists.reduce(function (acc, cur) {
    if (!acc[cur.attributes.baseUrl]) {
      acc[cur.attributes.baseUrl] = [];
    }

    acc[cur.attributes.baseUrl].push(cur);
    return acc;
  }, {});
  let allPlaylists = [];
  Object.values(playlistsByBaseUrl).forEach(playlistGroup => {
    const mergedPlaylists = values(playlistGroup.reduce((acc, playlist) => {
      // assuming playlist IDs are the same across periods
      // TODO: handle multiperiod where representation sets are not the same
      // across periods
      const name = playlist.attributes.id + (playlist.attributes.lang || '');

      if (!acc[name]) {
        // First Period
        acc[name] = playlist;
        acc[name].attributes.timelineStarts = [];
      } else {
        // Subsequent Periods
        if (playlist.segments) {
          // first segment of subsequent periods signal a discontinuity
          if (playlist.segments[0]) {
            playlist.segments[0].discontinuity = true;
          }

          acc[name].segments.push(...playlist.segments);
        } // bubble up contentProtection, this assumes all DRM content
        // has the same contentProtection


        if (playlist.attributes.contentProtection) {
          acc[name].attributes.contentProtection = playlist.attributes.contentProtection;
        }
      }

      acc[name].attributes.timelineStarts.push({
        // Although they represent the same number, it's important to have both to make it
        // compatible with HLS potentially having a similar attribute.
        start: playlist.attributes.periodStart,
        timeline: playlist.attributes.periodStart
      });
      return acc;
    }, {}));
    allPlaylists = allPlaylists.concat(mergedPlaylists);
  });
  return allPlaylists.map(playlist => {
    playlist.discontinuityStarts = findIndexes(playlist.segments || [], 'discontinuity');
    return playlist;
  });
};

const addSidxSegmentsToPlaylist = (playlist, sidxMapping) => {
  const sidxKey = generateSidxKey(playlist.sidx);
  const sidxMatch = sidxKey && sidxMapping[sidxKey] && sidxMapping[sidxKey].sidx;

  if (sidxMatch) {
    addSidxSegmentsToPlaylist$1(playlist, sidxMatch, playlist.sidx.resolvedUri);
  }

  return playlist;
};
const addSidxSegmentsToPlaylists = (playlists, sidxMapping = {}) => {
  if (!Object.keys(sidxMapping).length) {
    return playlists;
  }

  for (const i in playlists) {
    playlists[i] = addSidxSegmentsToPlaylist(playlists[i], sidxMapping);
  }

  return playlists;
};
const formatAudioPlaylist = ({
  attributes,
  segments,
  sidx,
  mediaSequence,
  discontinuitySequence,
  discontinuityStarts
}, isAudioOnly) => {
  const playlist = {
    attributes: {
      NAME: attributes.id,
      BANDWIDTH: attributes.bandwidth,
      CODECS: attributes.codecs,
      ['PROGRAM-ID']: 1
    },
    uri: '',
    endList: attributes.type === 'static',
    timeline: attributes.periodStart,
    resolvedUri: attributes.baseUrl || '',
    targetDuration: attributes.duration,
    discontinuitySequence,
    discontinuityStarts,
    timelineStarts: attributes.timelineStarts,
    mediaSequence,
    segments
  };

  if (attributes.contentProtection) {
    playlist.contentProtection = attributes.contentProtection;
  }

  if (attributes.serviceLocation) {
    playlist.attributes.serviceLocation = attributes.serviceLocation;
  }

  if (sidx) {
    playlist.sidx = sidx;
  }

  if (isAudioOnly) {
    playlist.attributes.AUDIO = 'audio';
    playlist.attributes.SUBTITLES = 'subs';
  }

  return playlist;
};
const formatVttPlaylist = ({
  attributes,
  segments,
  mediaSequence,
  discontinuityStarts,
  discontinuitySequence
}) => {
  if (typeof segments === 'undefined') {
    // vtt tracks may use single file in BaseURL
    segments = [{
      uri: attributes.baseUrl,
      timeline: attributes.periodStart,
      resolvedUri: attributes.baseUrl || '',
      duration: attributes.sourceDuration,
      number: 0
    }]; // targetDuration should be the same duration as the only segment

    attributes.duration = attributes.sourceDuration;
  }

  const m3u8Attributes = {
    NAME: attributes.id,
    BANDWIDTH: attributes.bandwidth,
    ['PROGRAM-ID']: 1
  };

  if (attributes.codecs) {
    m3u8Attributes.CODECS = attributes.codecs;
  }

  const vttPlaylist = {
    attributes: m3u8Attributes,
    uri: '',
    endList: attributes.type === 'static',
    timeline: attributes.periodStart,
    resolvedUri: attributes.baseUrl || '',
    targetDuration: attributes.duration,
    timelineStarts: attributes.timelineStarts,
    discontinuityStarts,
    discontinuitySequence,
    mediaSequence,
    segments
  };

  if (attributes.serviceLocation) {
    vttPlaylist.attributes.serviceLocation = attributes.serviceLocation;
  }

  return vttPlaylist;
};
const organizeAudioPlaylists = (playlists, sidxMapping = {}, isAudioOnly = false) => {
  let mainPlaylist;
  const formattedPlaylists = playlists.reduce((a, playlist) => {
    const role = playlist.attributes.role && playlist.attributes.role.value || '';
    const language = playlist.attributes.lang || '';
    let label = playlist.attributes.label || 'main';

    if (language && !playlist.attributes.label) {
      const roleLabel = role ? ` (${role})` : '';
      label = `${playlist.attributes.lang}${roleLabel}`;
    }

    if (!a[label]) {
      a[label] = {
        language,
        autoselect: true,
        default: role === 'main',
        playlists: [],
        uri: ''
      };
    }

    const formatted = addSidxSegmentsToPlaylist(formatAudioPlaylist(playlist, isAudioOnly), sidxMapping);
    a[label].playlists.push(formatted);

    if (typeof mainPlaylist === 'undefined' && role === 'main') {
      mainPlaylist = playlist;
      mainPlaylist.default = true;
    }

    return a;
  }, {}); // if no playlists have role "main", mark the first as main

  if (!mainPlaylist) {
    const firstLabel = Object.keys(formattedPlaylists)[0];
    formattedPlaylists[firstLabel].default = true;
  }

  return formattedPlaylists;
};
const organizeVttPlaylists = (playlists, sidxMapping = {}) => {
  return playlists.reduce((a, playlist) => {
    const label = playlist.attributes.label || playlist.attributes.lang || 'text';
    const language = playlist.attributes.lang || 'und';

    if (!a[label]) {
      a[label] = {
        language,
        default: false,
        autoselect: false,
        playlists: [],
        uri: ''
      };
    }

    a[label].playlists.push(addSidxSegmentsToPlaylist(formatVttPlaylist(playlist), sidxMapping));
    return a;
  }, {});
};

const organizeCaptionServices = captionServices => captionServices.reduce((svcObj, svc) => {
  if (!svc) {
    return svcObj;
  }

  svc.forEach(service => {
    const {
      channel,
      language
    } = service;
    svcObj[language] = {
      autoselect: false,
      default: false,
      instreamId: channel,
      language
    };

    if (service.hasOwnProperty('aspectRatio')) {
      svcObj[language].aspectRatio = service.aspectRatio;
    }

    if (service.hasOwnProperty('easyReader')) {
      svcObj[language].easyReader = service.easyReader;
    }

    if (service.hasOwnProperty('3D')) {
      svcObj[language]['3D'] = service['3D'];
    }
  });
  return svcObj;
}, {});

const formatVideoPlaylist = ({
  attributes,
  segments,
  sidx,
  discontinuityStarts
}) => {
  const playlist = {
    attributes: {
      NAME: attributes.id,
      AUDIO: 'audio',
      SUBTITLES: 'subs',
      RESOLUTION: {
        width: attributes.width,
        height: attributes.height
      },
      CODECS: attributes.codecs,
      BANDWIDTH: attributes.bandwidth,
      ['PROGRAM-ID']: 1
    },
    uri: '',
    endList: attributes.type === 'static',
    timeline: attributes.periodStart,
    resolvedUri: attributes.baseUrl || '',
    targetDuration: attributes.duration,
    discontinuityStarts,
    timelineStarts: attributes.timelineStarts,
    segments
  };

  if (attributes.frameRate) {
    playlist.attributes['FRAME-RATE'] = attributes.frameRate;
  }

  if (attributes.contentProtection) {
    playlist.contentProtection = attributes.contentProtection;
  }

  if (attributes.serviceLocation) {
    playlist.attributes.serviceLocation = attributes.serviceLocation;
  }

  if (sidx) {
    playlist.sidx = sidx;
  }

  return playlist;
};

const videoOnly = ({
  attributes
}) => attributes.mimeType === 'video/mp4' || attributes.mimeType === 'video/webm' || attributes.contentType === 'video';

const audioOnly = ({
  attributes
}) => attributes.mimeType === 'audio/mp4' || attributes.mimeType === 'audio/webm' || attributes.contentType === 'audio';

const vttOnly = ({
  attributes
}) => attributes.mimeType === 'text/vtt' || attributes.contentType === 'text';
/**
 * Contains start and timeline properties denoting a timeline start. For DASH, these will
 * be the same number.
 *
 * @typedef {Object} TimelineStart
 * @property {number} start - the start time of the timeline
 * @property {number} timeline - the timeline number
 */

/**
 * Adds appropriate media and discontinuity sequence values to the segments and playlists.
 *
 * Throughout mpd-parser, the `number` attribute is used in relation to `startNumber`, a
 * DASH specific attribute used in constructing segment URI's from templates. However, from
 * an HLS perspective, the `number` attribute on a segment would be its `mediaSequence`
 * value, which should start at the original media sequence value (or 0) and increment by 1
 * for each segment thereafter. Since DASH's `startNumber` values are independent per
 * period, it doesn't make sense to use it for `number`. Instead, assume everything starts
 * from a 0 mediaSequence value and increment from there.
 *
 * Note that VHS currently doesn't use the `number` property, but it can be helpful for
 * debugging and making sense of the manifest.
 *
 * For live playlists, to account for values increasing in manifests when periods are
 * removed on refreshes, merging logic should be used to update the numbers to their
 * appropriate values (to ensure they're sequential and increasing).
 *
 * @param {Object[]} playlists - the playlists to update
 * @param {TimelineStart[]} timelineStarts - the timeline starts for the manifest
 */


const addMediaSequenceValues = (playlists, timelineStarts) => {
  // increment all segments sequentially
  playlists.forEach(playlist => {
    playlist.mediaSequence = 0;
    playlist.discontinuitySequence = timelineStarts.findIndex(function ({
      timeline
    }) {
      return timeline === playlist.timeline;
    });

    if (!playlist.segments) {
      return;
    }

    playlist.segments.forEach((segment, index) => {
      segment.number = index;
    });
  });
};
/**
 * Given a media group object, flattens all playlists within the media group into a single
 * array.
 *
 * @param {Object} mediaGroupObject - the media group object
 *
 * @return {Object[]}
 *         The media group playlists
 */

const flattenMediaGroupPlaylists = mediaGroupObject => {
  if (!mediaGroupObject) {
    return [];
  }

  return Object.keys(mediaGroupObject).reduce((acc, label) => {
    const labelContents = mediaGroupObject[label];
    return acc.concat(labelContents.playlists);
  }, []);
};
const toM3u8 = ({
  dashPlaylists,
  locations,
  contentSteering,
  sidxMapping = {},
  previousManifest,
  eventStream
}) => {
  if (!dashPlaylists.length) {
    return {};
  } // grab all main manifest attributes


  const {
    sourceDuration: duration,
    type,
    suggestedPresentationDelay,
    minimumUpdatePeriod
  } = dashPlaylists[0].attributes;
  const videoPlaylists = mergeDiscontiguousPlaylists(dashPlaylists.filter(videoOnly)).map(formatVideoPlaylist);
  const audioPlaylists = mergeDiscontiguousPlaylists(dashPlaylists.filter(audioOnly));
  const vttPlaylists = mergeDiscontiguousPlaylists(dashPlaylists.filter(vttOnly));
  const captions = dashPlaylists.map(playlist => playlist.attributes.captionServices).filter(Boolean);
  const manifest = {
    allowCache: true,
    discontinuityStarts: [],
    segments: [],
    endList: true,
    mediaGroups: {
      AUDIO: {},
      VIDEO: {},
      ['CLOSED-CAPTIONS']: {},
      SUBTITLES: {}
    },
    uri: '',
    duration,
    playlists: addSidxSegmentsToPlaylists(videoPlaylists, sidxMapping)
  };

  if (minimumUpdatePeriod >= 0) {
    manifest.minimumUpdatePeriod = minimumUpdatePeriod * 1000;
  }

  if (locations) {
    manifest.locations = locations;
  }

  if (contentSteering) {
    manifest.contentSteering = contentSteering;
  }

  if (type === 'dynamic') {
    manifest.suggestedPresentationDelay = suggestedPresentationDelay;
  }

  if (eventStream && eventStream.length > 0) {
    manifest.eventStream = eventStream;
  }

  const isAudioOnly = manifest.playlists.length === 0;
  const organizedAudioGroup = audioPlaylists.length ? organizeAudioPlaylists(audioPlaylists, sidxMapping, isAudioOnly) : null;
  const organizedVttGroup = vttPlaylists.length ? organizeVttPlaylists(vttPlaylists, sidxMapping) : null;
  const formattedPlaylists = videoPlaylists.concat(flattenMediaGroupPlaylists(organizedAudioGroup), flattenMediaGroupPlaylists(organizedVttGroup));
  const playlistTimelineStarts = formattedPlaylists.map(({
    timelineStarts
  }) => timelineStarts);
  manifest.timelineStarts = getUniqueTimelineStarts(playlistTimelineStarts);
  addMediaSequenceValues(formattedPlaylists, manifest.timelineStarts);

  if (organizedAudioGroup) {
    manifest.mediaGroups.AUDIO.audio = organizedAudioGroup;
  }

  if (organizedVttGroup) {
    manifest.mediaGroups.SUBTITLES.subs = organizedVttGroup;
  }

  if (captions.length) {
    manifest.mediaGroups['CLOSED-CAPTIONS'].cc = organizeCaptionServices(captions);
  }

  if (previousManifest) {
    return positionManifestOnTimeline({
      oldManifest: previousManifest,
      newManifest: manifest
    });
  }

  return manifest;
};

/**
 * Calculates the R (repetition) value for a live stream (for the final segment
 * in a manifest where the r value is negative 1)
 *
 * @param {Object} attributes
 *        Object containing all inherited attributes from parent elements with attribute
 *        names as keys
 * @param {number} time
 *        current time (typically the total time up until the final segment)
 * @param {number} duration
 *        duration property for the given <S />
 *
 * @return {number}
 *        R value to reach the end of the given period
 */
const getLiveRValue = (attributes, time, duration) => {
  const {
    NOW,
    clientOffset,
    availabilityStartTime,
    timescale = 1,
    periodStart = 0,
    minimumUpdatePeriod = 0
  } = attributes;
  const now = (NOW + clientOffset) / 1000;
  const periodStartWC = availabilityStartTime + periodStart;
  const periodEndWC = now + minimumUpdatePeriod;
  const periodDuration = periodEndWC - periodStartWC;
  return Math.ceil((periodDuration * timescale - time) / duration);
};
/**
 * Uses information provided by SegmentTemplate.SegmentTimeline to determine segment
 * timing and duration
 *
 * @param {Object} attributes
 *        Object containing all inherited attributes from parent elements with attribute
 *        names as keys
 * @param {Object[]} segmentTimeline
 *        List of objects representing the attributes of each S element contained within
 *
 * @return {{number: number, duration: number, time: number, timeline: number}[]}
 *         List of Objects with segment timing and duration info
 */


const parseByTimeline = (attributes, segmentTimeline) => {
  const {
    type,
    minimumUpdatePeriod = 0,
    media = '',
    sourceDuration,
    timescale = 1,
    startNumber = 1,
    periodStart: timeline
  } = attributes;
  const segments = [];
  let time = -1;

  for (let sIndex = 0; sIndex < segmentTimeline.length; sIndex++) {
    const S = segmentTimeline[sIndex];
    const duration = S.d;
    const repeat = S.r || 0;
    const segmentTime = S.t || 0;

    if (time < 0) {
      // first segment
      time = segmentTime;
    }

    if (segmentTime && segmentTime > time) {
      // discontinuity
      // TODO: How to handle this type of discontinuity
      // timeline++ here would treat it like HLS discontuity and content would
      // get appended without gap
      // E.G.
      //  <S t="0" d="1" />
      //  <S d="1" />
      //  <S d="1" />
      //  <S t="5" d="1" />
      // would have $Time$ values of [0, 1, 2, 5]
      // should this be appened at time positions [0, 1, 2, 3],(#EXT-X-DISCONTINUITY)
      // or [0, 1, 2, gap, gap, 5]? (#EXT-X-GAP)
      // does the value of sourceDuration consider this when calculating arbitrary
      // negative @r repeat value?
      // E.G. Same elements as above with this added at the end
      //  <S d="1" r="-1" />
      //  with a sourceDuration of 10
      // Would the 2 gaps be included in the time duration calculations resulting in
      // 8 segments with $Time$ values of [0, 1, 2, 5, 6, 7, 8, 9] or 10 segments
      // with $Time$ values of [0, 1, 2, 5, 6, 7, 8, 9, 10, 11] ?
      time = segmentTime;
    }

    let count;

    if (repeat < 0) {
      const nextS = sIndex + 1;

      if (nextS === segmentTimeline.length) {
        // last segment
        if (type === 'dynamic' && minimumUpdatePeriod > 0 && media.indexOf('$Number$') > 0) {
          count = getLiveRValue(attributes, time, duration);
        } else {
          // TODO: This may be incorrect depending on conclusion of TODO above
          count = (sourceDuration * timescale - time) / duration;
        }
      } else {
        count = (segmentTimeline[nextS].t - time) / duration;
      }
    } else {
      count = repeat + 1;
    }

    const end = startNumber + segments.length + count;
    let number = startNumber + segments.length;

    while (number < end) {
      segments.push({
        number,
        duration: duration / timescale,
        time,
        timeline
      });
      time += duration;
      number++;
    }
  }

  return segments;
};

const identifierPattern = /\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g;
/**
 * Replaces template identifiers with corresponding values. To be used as the callback
 * for String.prototype.replace
 *
 * @name replaceCallback
 * @function
 * @param {string} match
 *        Entire match of identifier
 * @param {string} identifier
 *        Name of matched identifier
 * @param {string} format
 *        Format tag string. Its presence indicates that padding is expected
 * @param {string} width
 *        Desired length of the replaced value. Values less than this width shall be left
 *        zero padded
 * @return {string}
 *         Replacement for the matched identifier
 */

/**
 * Returns a function to be used as a callback for String.prototype.replace to replace
 * template identifiers
 *
 * @param {Obect} values
 *        Object containing values that shall be used to replace known identifiers
 * @param {number} values.RepresentationID
 *        Value of the Representation@id attribute
 * @param {number} values.Number
 *        Number of the corresponding segment
 * @param {number} values.Bandwidth
 *        Value of the Representation@bandwidth attribute.
 * @param {number} values.Time
 *        Timestamp value of the corresponding segment
 * @return {replaceCallback}
 *         Callback to be used with String.prototype.replace to replace identifiers
 */

const identifierReplacement = values => (match, identifier, format, width) => {
  if (match === '$$') {
    // escape sequence
    return '$';
  }

  if (typeof values[identifier] === 'undefined') {
    return match;
  }

  const value = '' + values[identifier];

  if (identifier === 'RepresentationID') {
    // Format tag shall not be present with RepresentationID
    return value;
  }

  if (!format) {
    width = 1;
  } else {
    width = parseInt(width, 10);
  }

  if (value.length >= width) {
    return value;
  }

  return `${new Array(width - value.length + 1).join('0')}${value}`;
};
/**
 * Constructs a segment url from a template string
 *
 * @param {string} url
 *        Template string to construct url from
 * @param {Obect} values
 *        Object containing values that shall be used to replace known identifiers
 * @param {number} values.RepresentationID
 *        Value of the Representation@id attribute
 * @param {number} values.Number
 *        Number of the corresponding segment
 * @param {number} values.Bandwidth
 *        Value of the Representation@bandwidth attribute.
 * @param {number} values.Time
 *        Timestamp value of the corresponding segment
 * @return {string}
 *         Segment url with identifiers replaced
 */

const constructTemplateUrl = (url, values) => url.replace(identifierPattern, identifierReplacement(values));
/**
 * Generates a list of objects containing timing and duration information about each
 * segment needed to generate segment uris and the complete segment object
 *
 * @param {Object} attributes
 *        Object containing all inherited attributes from parent elements with attribute
 *        names as keys
 * @param {Object[]|undefined} segmentTimeline
 *        List of objects representing the attributes of each S element contained within
 *        the SegmentTimeline element
 * @return {{number: number, duration: number, time: number, timeline: number}[]}
 *         List of Objects with segment timing and duration info
 */

const parseTemplateInfo = (attributes, segmentTimeline) => {
  if (!attributes.duration && !segmentTimeline) {
    // if neither @duration or SegmentTimeline are present, then there shall be exactly
    // one media segment
    return [{
      number: attributes.startNumber || 1,
      duration: attributes.sourceDuration,
      time: 0,
      timeline: attributes.periodStart
    }];
  }

  if (attributes.duration) {
    return parseByDuration(attributes);
  }

  return parseByTimeline(attributes, segmentTimeline);
};
/**
 * Generates a list of segments using information provided by the SegmentTemplate element
 *
 * @param {Object} attributes
 *        Object containing all inherited attributes from parent elements with attribute
 *        names as keys
 * @param {Object[]|undefined} segmentTimeline
 *        List of objects representing the attributes of each S element contained within
 *        the SegmentTimeline element
 * @return {Object[]}
 *         List of segment objects
 */

const segmentsFromTemplate = (attributes, segmentTimeline) => {
  const templateValues = {
    RepresentationID: attributes.id,
    Bandwidth: attributes.bandwidth || 0
  };
  const {
    initialization = {
      sourceURL: '',
      range: ''
    }
  } = attributes;
  const mapSegment = urlTypeToSegment({
    baseUrl: attributes.baseUrl,
    source: constructTemplateUrl(initialization.sourceURL, templateValues),
    range: initialization.range
  });
  const segments = parseTemplateInfo(attributes, segmentTimeline);
  return segments.map(segment => {
    templateValues.Number = segment.number;
    templateValues.Time = segment.time;
    const uri = constructTemplateUrl(attributes.media || '', templateValues); // See DASH spec section 5.3.9.2.2
    // - if timescale isn't present on any level, default to 1.

    const timescale = attributes.timescale || 1; // - if presentationTimeOffset isn't present on any level, default to 0

    const presentationTimeOffset = attributes.presentationTimeOffset || 0;
    const presentationTime = // Even if the @t attribute is not specified for the segment, segment.time is
    // calculated in mpd-parser prior to this, so it's assumed to be available.
    attributes.periodStart + (segment.time - presentationTimeOffset) / timescale;
    const map = {
      uri,
      timeline: segment.timeline,
      duration: segment.duration,
      resolvedUri: (0,_videojs_vhs_utils_es_resolve_url__WEBPACK_IMPORTED_MODULE_0__["default"])(attributes.baseUrl || '', uri),
      map: mapSegment,
      number: segment.number,
      presentationTime
    };
    return map;
  });
};

/**
 * Converts a <SegmentUrl> (of type URLType from the DASH spec 5.3.9.2 Table 14)
 * to an object that matches the output of a segment in videojs/mpd-parser
 *
 * @param {Object} attributes
 *   Object containing all inherited attributes from parent elements with attribute
 *   names as keys
 * @param {Object} segmentUrl
 *   <SegmentURL> node to translate into a segment object
 * @return {Object} translated segment object
 */

const SegmentURLToSegmentObject = (attributes, segmentUrl) => {
  const {
    baseUrl,
    initialization = {}
  } = attributes;
  const initSegment = urlTypeToSegment({
    baseUrl,
    source: initialization.sourceURL,
    range: initialization.range
  });
  const segment = urlTypeToSegment({
    baseUrl,
    source: segmentUrl.media,
    range: segmentUrl.mediaRange
  });
  segment.map = initSegment;
  return segment;
};
/**
 * Generates a list of segments using information provided by the SegmentList element
 * SegmentList (DASH SPEC Section 5.3.9.3.2) contains a set of <SegmentURL> nodes.  Each
 * node should be translated into segment.
 *
 * @param {Object} attributes
 *   Object containing all inherited attributes from parent elements with attribute
 *   names as keys
 * @param {Object[]|undefined} segmentTimeline
 *        List of objects representing the attributes of each S element contained within
 *        the SegmentTimeline element
 * @return {Object.<Array>} list of segments
 */


const segmentsFromList = (attributes, segmentTimeline) => {
  const {
    duration,
    segmentUrls = [],
    periodStart
  } = attributes; // Per spec (5.3.9.2.1) no way to determine segment duration OR
  // if both SegmentTimeline and @duration are defined, it is outside of spec.

  if (!duration && !segmentTimeline || duration && segmentTimeline) {
    throw new Error(errors.SEGMENT_TIME_UNSPECIFIED);
  }

  const segmentUrlMap = segmentUrls.map(segmentUrlObject => SegmentURLToSegmentObject(attributes, segmentUrlObject));
  let segmentTimeInfo;

  if (duration) {
    segmentTimeInfo = parseByDuration(attributes);
  }

  if (segmentTimeline) {
    segmentTimeInfo = parseByTimeline(attributes, segmentTimeline);
  }

  const segments = segmentTimeInfo.map((segmentTime, index) => {
    if (segmentUrlMap[index]) {
      const segment = segmentUrlMap[index]; // See DASH spec section 5.3.9.2.2
      // - if timescale isn't present on any level, default to 1.

      const timescale = attributes.timescale || 1; // - if presentationTimeOffset isn't present on any level, default to 0

      const presentationTimeOffset = attributes.presentationTimeOffset || 0;
      segment.timeline = segmentTime.timeline;
      segment.duration = segmentTime.duration;
      segment.number = segmentTime.number;
      segment.presentationTime = periodStart + (segmentTime.time - presentationTimeOffset) / timescale;
      return segment;
    } // Since we're mapping we should get rid of any blank segments (in case
    // the given SegmentTimeline is handling for more elements than we have
    // SegmentURLs for).

  }).filter(segment => segment);
  return segments;
};

const generateSegments = ({
  attributes,
  segmentInfo
}) => {
  let segmentAttributes;
  let segmentsFn;

  if (segmentInfo.template) {
    segmentsFn = segmentsFromTemplate;
    segmentAttributes = merge(attributes, segmentInfo.template);
  } else if (segmentInfo.base) {
    segmentsFn = segmentsFromBase;
    segmentAttributes = merge(attributes, segmentInfo.base);
  } else if (segmentInfo.list) {
    segmentsFn = segmentsFromList;
    segmentAttributes = merge(attributes, segmentInfo.list);
  }

  const segmentsInfo = {
    attributes
  };

  if (!segmentsFn) {
    return segmentsInfo;
  }

  const segments = segmentsFn(segmentAttributes, segmentInfo.segmentTimeline); // The @duration attribute will be used to determin the playlist's targetDuration which
  // must be in seconds. Since we've generated the segment list, we no longer need
  // @duration to be in @timescale units, so we can convert it here.

  if (segmentAttributes.duration) {
    const {
      duration,
      timescale = 1
    } = segmentAttributes;
    segmentAttributes.duration = duration / timescale;
  } else if (segments.length) {
    // if there is no @duration attribute, use the largest segment duration as
    // as target duration
    segmentAttributes.duration = segments.reduce((max, segment) => {
      return Math.max(max, Math.ceil(segment.duration));
    }, 0);
  } else {
    segmentAttributes.duration = 0;
  }

  segmentsInfo.attributes = segmentAttributes;
  segmentsInfo.segments = segments; // This is a sidx box without actual segment information

  if (segmentInfo.base && segmentAttributes.indexRange) {
    segmentsInfo.sidx = segments[0];
    segmentsInfo.segments = [];
  }

  return segmentsInfo;
};
const toPlaylists = representations => representations.map(generateSegments);

const findChildren = (element, name) => from(element.childNodes).filter(({
  tagName
}) => tagName === name);
const getContent = element => element.textContent.trim();

/**
 * Converts the provided string that may contain a division operation to a number.
 *
 * @param {string} value - the provided string value
 *
 * @return {number} the parsed string value
 */
const parseDivisionValue = value => {
  return parseFloat(value.split('/').reduce((prev, current) => prev / current));
};

const parseDuration = str => {
  const SECONDS_IN_YEAR = 365 * 24 * 60 * 60;
  const SECONDS_IN_MONTH = 30 * 24 * 60 * 60;
  const SECONDS_IN_DAY = 24 * 60 * 60;
  const SECONDS_IN_HOUR = 60 * 60;
  const SECONDS_IN_MIN = 60; // P10Y10M10DT10H10M10.1S

  const durationRegex = /P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/;
  const match = durationRegex.exec(str);

  if (!match) {
    return 0;
  }

  const [year, month, day, hour, minute, second] = match.slice(1);
  return parseFloat(year || 0) * SECONDS_IN_YEAR + parseFloat(month || 0) * SECONDS_IN_MONTH + parseFloat(day || 0) * SECONDS_IN_DAY + parseFloat(hour || 0) * SECONDS_IN_HOUR + parseFloat(minute || 0) * SECONDS_IN_MIN + parseFloat(second || 0);
};
const parseDate = str => {
  // Date format without timezone according to ISO 8601
  // YYY-MM-DDThh:mm:ss.ssssss
  const dateRegex = /^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/; // If the date string does not specifiy a timezone, we must specifiy UTC. This is
  // expressed by ending with 'Z'

  if (dateRegex.test(str)) {
    str += 'Z';
  }

  return Date.parse(str);
};

const parsers = {
  /**
   * Specifies the duration of the entire Media Presentation. Format is a duration string
   * as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The duration in seconds
   */
  mediaPresentationDuration(value) {
    return parseDuration(value);
  },

  /**
   * Specifies the Segment availability start time for all Segments referred to in this
   * MPD. For a dynamic manifest, it specifies the anchor for the earliest availability
   * time. Format is a date string as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The date as seconds from unix epoch
   */
  availabilityStartTime(value) {
    return parseDate(value) / 1000;
  },

  /**
   * Specifies the smallest period between potential changes to the MPD. Format is a
   * duration string as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The duration in seconds
   */
  minimumUpdatePeriod(value) {
    return parseDuration(value);
  },

  /**
   * Specifies the suggested presentation delay. Format is a
   * duration string as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The duration in seconds
   */
  suggestedPresentationDelay(value) {
    return parseDuration(value);
  },

  /**
   * specifices the type of mpd. Can be either "static" or "dynamic"
   *
   * @param {string} value
   *        value of attribute as a string
   *
   * @return {string}
   *         The type as a string
   */
  type(value) {
    return value;
  },

  /**
   * Specifies the duration of the smallest time shifting buffer for any Representation
   * in the MPD. Format is a duration string as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The duration in seconds
   */
  timeShiftBufferDepth(value) {
    return parseDuration(value);
  },

  /**
   * Specifies the PeriodStart time of the Period relative to the availabilityStarttime.
   * Format is a duration string as specified in ISO 8601
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The duration in seconds
   */
  start(value) {
    return parseDuration(value);
  },

  /**
   * Specifies the width of the visual presentation
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed width
   */
  width(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the height of the visual presentation
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed height
   */
  height(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the bitrate of the representation
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed bandwidth
   */
  bandwidth(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the frame rate of the representation
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed frame rate
   */
  frameRate(value) {
    return parseDivisionValue(value);
  },

  /**
   * Specifies the number of the first Media Segment in this Representation in the Period
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed number
   */
  startNumber(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the timescale in units per seconds
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed timescale
   */
  timescale(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the presentationTimeOffset.
   *
   * @param {string} value
   *        value of the attribute as a string
   *
   * @return {number}
   *         The parsed presentationTimeOffset
   */
  presentationTimeOffset(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the constant approximate Segment duration
   * NOTE: The <Period> element also contains an @duration attribute. This duration
   *       specifies the duration of the Period. This attribute is currently not
   *       supported by the rest of the parser, however we still check for it to prevent
   *       errors.
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed duration
   */
  duration(value) {
    const parsedValue = parseInt(value, 10);

    if (isNaN(parsedValue)) {
      return parseDuration(value);
    }

    return parsedValue;
  },

  /**
   * Specifies the Segment duration, in units of the value of the @timescale.
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed duration
   */
  d(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the MPD start time, in @timescale units, the first Segment in the series
   * starts relative to the beginning of the Period
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed time
   */
  t(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the repeat count of the number of following contiguous Segments with the
   * same duration expressed by the value of @d
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {number}
   *         The parsed number
   */
  r(value) {
    return parseInt(value, 10);
  },

  /**
   * Specifies the presentationTime.
   *
   * @param {string} value
   *        value of the attribute as a string
   *
   * @return {number}
   *         The parsed presentationTime
   */
  presentationTime(value) {
    return parseInt(value, 10);
  },

  /**
   * Default parser for all other attributes. Acts as a no-op and just returns the value
   * as a string
   *
   * @param {string} value
   *        value of attribute as a string
   * @return {string}
   *         Unparsed value
   */
  DEFAULT(value) {
    return value;
  }

};
/**
 * Gets all the attributes and values of the provided node, parses attributes with known
 * types, and returns an object with attribute names mapped to values.
 *
 * @param {Node} el
 *        The node to parse attributes from
 * @return {Object}
 *         Object with all attributes of el parsed
 */

const parseAttributes = el => {
  if (!(el && el.attributes)) {
    return {};
  }

  return from(el.attributes).reduce((a, e) => {
    const parseFn = parsers[e.name] || parsers.DEFAULT;
    a[e.name] = parseFn(e.value);
    return a;
  }, {});
};

const keySystemsMap = {
  'urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b': 'org.w3.clearkey',
  'urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed': 'com.widevine.alpha',
  'urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95': 'com.microsoft.playready',
  'urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb': 'com.adobe.primetime',
  // ISO_IEC 23009-1_2022 5.8.5.2.2 The mp4 Protection Scheme
  'urn:mpeg:dash:mp4protection:2011': 'mp4protection'
};
/**
 * Builds a list of urls that is the product of the reference urls and BaseURL values
 *
 * @param {Object[]} references
 *        List of objects containing the reference URL as well as its attributes
 * @param {Node[]} baseUrlElements
 *        List of BaseURL nodes from the mpd
 * @return {Object[]}
 *         List of objects with resolved urls and attributes
 */

const buildBaseUrls = (references, baseUrlElements) => {
  if (!baseUrlElements.length) {
    return references;
  }

  return flatten(references.map(function (reference) {
    return baseUrlElements.map(function (baseUrlElement) {
      const initialBaseUrl = getContent(baseUrlElement);
      const resolvedBaseUrl = (0,_videojs_vhs_utils_es_resolve_url__WEBPACK_IMPORTED_MODULE_0__["default"])(reference.baseUrl, initialBaseUrl);
      const finalBaseUrl = merge(parseAttributes(baseUrlElement), {
        baseUrl: resolvedBaseUrl
      }); // If the URL is resolved, we want to get the serviceLocation from the reference
      // assuming there is no serviceLocation on the initialBaseUrl

      if (resolvedBaseUrl !== initialBaseUrl && !finalBaseUrl.serviceLocation && reference.serviceLocation) {
        finalBaseUrl.serviceLocation = reference.serviceLocation;
      }

      return finalBaseUrl;
    });
  }));
};
/**
 * Contains all Segment information for its containing AdaptationSet
 *
 * @typedef {Object} SegmentInformation
 * @property {Object|undefined} template
 *           Contains the attributes for the SegmentTemplate node
 * @property {Object[]|undefined} segmentTimeline
 *           Contains a list of atrributes for each S node within the SegmentTimeline node
 * @property {Object|undefined} list
 *           Contains the attributes for the SegmentList node
 * @property {Object|undefined} base
 *           Contains the attributes for the SegmentBase node
 */

/**
 * Returns all available Segment information contained within the AdaptationSet node
 *
 * @param {Node} adaptationSet
 *        The AdaptationSet node to get Segment information from
 * @return {SegmentInformation}
 *         The Segment information contained within the provided AdaptationSet
 */

const getSegmentInformation = adaptationSet => {
  const segmentTemplate = findChildren(adaptationSet, 'SegmentTemplate')[0];
  const segmentList = findChildren(adaptationSet, 'SegmentList')[0];
  const segmentUrls = segmentList && findChildren(segmentList, 'SegmentURL').map(s => merge({
    tag: 'SegmentURL'
  }, parseAttributes(s)));
  const segmentBase = findChildren(adaptationSet, 'SegmentBase')[0];
  const segmentTimelineParentNode = segmentList || segmentTemplate;
  const segmentTimeline = segmentTimelineParentNode && findChildren(segmentTimelineParentNode, 'SegmentTimeline')[0];
  const segmentInitializationParentNode = segmentList || segmentBase || segmentTemplate;
  const segmentInitialization = segmentInitializationParentNode && findChildren(segmentInitializationParentNode, 'Initialization')[0]; // SegmentTemplate is handled slightly differently, since it can have both
  // @initialization and an <Initialization> node.  @initialization can be templated,
  // while the node can have a url and range specified.  If the <SegmentTemplate> has
  // both @initialization and an <Initialization> subelement we opt to override with
  // the node, as this interaction is not defined in the spec.

  const template = segmentTemplate && parseAttributes(segmentTemplate);

  if (template && segmentInitialization) {
    template.initialization = segmentInitialization && parseAttributes(segmentInitialization);
  } else if (template && template.initialization) {
    // If it is @initialization we convert it to an object since this is the format that
    // later functions will rely on for the initialization segment.  This is only valid
    // for <SegmentTemplate>
    template.initialization = {
      sourceURL: template.initialization
    };
  }

  const segmentInfo = {
    template,
    segmentTimeline: segmentTimeline && findChildren(segmentTimeline, 'S').map(s => parseAttributes(s)),
    list: segmentList && merge(parseAttributes(segmentList), {
      segmentUrls,
      initialization: parseAttributes(segmentInitialization)
    }),
    base: segmentBase && merge(parseAttributes(segmentBase), {
      initialization: parseAttributes(segmentInitialization)
    })
  };
  Object.keys(segmentInfo).forEach(key => {
    if (!segmentInfo[key]) {
      delete segmentInfo[key];
    }
  });
  return segmentInfo;
};
/**
 * Contains Segment information and attributes needed to construct a Playlist object
 * from a Representation
 *
 * @typedef {Object} RepresentationInformation
 * @property {SegmentInformation} segmentInfo
 *           Segment information for this Representation
 * @property {Object} attributes
 *           Inherited attributes for this Representation
 */

/**
 * Maps a Representation node to an object containing Segment information and attributes
 *
 * @name inheritBaseUrlsCallback
 * @function
 * @param {Node} representation
 *        Representation node from the mpd
 * @return {RepresentationInformation}
 *         Representation information needed to construct a Playlist object
 */

/**
 * Returns a callback for Array.prototype.map for mapping Representation nodes to
 * Segment information and attributes using inherited BaseURL nodes.
 *
 * @param {Object} adaptationSetAttributes
 *        Contains attributes inherited by the AdaptationSet
 * @param {Object[]} adaptationSetBaseUrls
 *        List of objects containing resolved base URLs and attributes
 *        inherited by the AdaptationSet
 * @param {SegmentInformation} adaptationSetSegmentInfo
 *        Contains Segment information for the AdaptationSet
 * @return {inheritBaseUrlsCallback}
 *         Callback map function
 */

const inheritBaseUrls = (adaptationSetAttributes, adaptationSetBaseUrls, adaptationSetSegmentInfo) => representation => {
  const repBaseUrlElements = findChildren(representation, 'BaseURL');
  const repBaseUrls = buildBaseUrls(adaptationSetBaseUrls, repBaseUrlElements);
  const attributes = merge(adaptationSetAttributes, parseAttributes(representation));
  const representationSegmentInfo = getSegmentInformation(representation);
  return repBaseUrls.map(baseUrl => {
    return {
      segmentInfo: merge(adaptationSetSegmentInfo, representationSegmentInfo),
      attributes: merge(attributes, baseUrl)
    };
  });
};
/**
 * Tranforms a series of content protection nodes to
 * an object containing pssh data by key system
 *
 * @param {Node[]} contentProtectionNodes
 *        Content protection nodes
 * @return {Object}
 *        Object containing pssh data by key system
 */

const generateKeySystemInformation = contentProtectionNodes => {
  return contentProtectionNodes.reduce((acc, node) => {
    const attributes = parseAttributes(node); // Although it could be argued that according to the UUID RFC spec the UUID string (a-f chars) should be generated
    // as a lowercase string it also mentions it should be treated as case-insensitive on input. Since the key system
    // UUIDs in the keySystemsMap are hardcoded as lowercase in the codebase there isn't any reason not to do
    // .toLowerCase() on the input UUID string from the manifest (at least I could not think of one).

    if (attributes.schemeIdUri) {
      attributes.schemeIdUri = attributes.schemeIdUri.toLowerCase();
    }

    const keySystem = keySystemsMap[attributes.schemeIdUri];

    if (keySystem) {
      acc[keySystem] = {
        attributes
      };
      const psshNode = findChildren(node, 'cenc:pssh')[0];

      if (psshNode) {
        const pssh = getContent(psshNode);
        acc[keySystem].pssh = pssh && (0,_videojs_vhs_utils_es_decode_b64_to_uint8_array__WEBPACK_IMPORTED_MODULE_3__["default"])(pssh);
      }
    }

    return acc;
  }, {});
}; // defined in ANSI_SCTE 214-1 2016


const parseCaptionServiceMetadata = service => {
  // 608 captions
  if (service.schemeIdUri === 'urn:scte:dash:cc:cea-608:2015') {
    const values = typeof service.value !== 'string' ? [] : service.value.split(';');
    return values.map(value => {
      let channel;
      let language; // default language to value

      language = value;

      if (/^CC\d=/.test(value)) {
        [channel, language] = value.split('=');
      } else if (/^CC\d$/.test(value)) {
        channel = value;
      }

      return {
        channel,
        language
      };
    });
  } else if (service.schemeIdUri === 'urn:scte:dash:cc:cea-708:2015') {
    const values = typeof service.value !== 'string' ? [] : service.value.split(';');
    return values.map(value => {
      const flags = {
        // service or channel number 1-63
        'channel': undefined,
        // language is a 3ALPHA per ISO 639.2/B
        // field is required
        'language': undefined,
        // BIT 1/0 or ?
        // default value is 1, meaning 16:9 aspect ratio, 0 is 4:3, ? is unknown
        'aspectRatio': 1,
        // BIT 1/0
        // easy reader flag indicated the text is tailed to the needs of beginning readers
        // default 0, or off
        'easyReader': 0,
        // BIT 1/0
        // If 3d metadata is present (CEA-708.1) then 1
        // default 0
        '3D': 0
      };

      if (/=/.test(value)) {
        const [channel, opts = ''] = value.split('=');
        flags.channel = channel;
        flags.language = value;
        opts.split(',').forEach(opt => {
          const [name, val] = opt.split(':');

          if (name === 'lang') {
            flags.language = val; // er for easyReadery
          } else if (name === 'er') {
            flags.easyReader = Number(val); // war for wide aspect ratio
          } else if (name === 'war') {
            flags.aspectRatio = Number(val);
          } else if (name === '3D') {
            flags['3D'] = Number(val);
          }
        });
      } else {
        flags.language = value;
      }

      if (flags.channel) {
        flags.channel = 'SERVICE' + flags.channel;
      }

      return flags;
    });
  }
};
/**
 * A map callback that will parse all event stream data for a collection of periods
 * DASH ISO_IEC_23009 5.10.2.2
 * https://dashif-documents.azurewebsites.net/Events/master/event.html#mpd-event-timing
 *
 * @param {PeriodInformation} period object containing necessary period information
 * @return a collection of parsed eventstream event objects
 */

const toEventStream = period => {
  // get and flatten all EventStreams tags and parse attributes and children
  return flatten(findChildren(period.node, 'EventStream').map(eventStream => {
    const eventStreamAttributes = parseAttributes(eventStream);
    const schemeIdUri = eventStreamAttributes.schemeIdUri; // find all Events per EventStream tag and map to return objects

    return findChildren(eventStream, 'Event').map(event => {
      const eventAttributes = parseAttributes(event);
      const presentationTime = eventAttributes.presentationTime || 0;
      const timescale = eventStreamAttributes.timescale || 1;
      const duration = eventAttributes.duration || 0;
      const start = presentationTime / timescale + period.attributes.start;
      return {
        schemeIdUri,
        value: eventStreamAttributes.value,
        id: eventAttributes.id,
        start,
        end: start + duration / timescale,
        messageData: getContent(event) || eventAttributes.messageData,
        contentEncoding: eventStreamAttributes.contentEncoding,
        presentationTimeOffset: eventStreamAttributes.presentationTimeOffset || 0
      };
    });
  }));
};
/**
 * Maps an AdaptationSet node to a list of Representation information objects
 *
 * @name toRepresentationsCallback
 * @function
 * @param {Node} adaptationSet
 *        AdaptationSet node from the mpd
 * @return {RepresentationInformation[]}
 *         List of objects containing Representaion information
 */

/**
 * Returns a callback for Array.prototype.map for mapping AdaptationSet nodes to a list of
 * Representation information objects
 *
 * @param {Object} periodAttributes
 *        Contains attributes inherited by the Period
 * @param {Object[]} periodBaseUrls
 *        Contains list of objects with resolved base urls and attributes
 *        inherited by the Period
 * @param {string[]} periodSegmentInfo
 *        Contains Segment Information at the period level
 * @return {toRepresentationsCallback}
 *         Callback map function
 */

const toRepresentations = (periodAttributes, periodBaseUrls, periodSegmentInfo) => adaptationSet => {
  const adaptationSetAttributes = parseAttributes(adaptationSet);
  const adaptationSetBaseUrls = buildBaseUrls(periodBaseUrls, findChildren(adaptationSet, 'BaseURL'));
  const role = findChildren(adaptationSet, 'Role')[0];
  const roleAttributes = {
    role: parseAttributes(role)
  };
  let attrs = merge(periodAttributes, adaptationSetAttributes, roleAttributes);
  const accessibility = findChildren(adaptationSet, 'Accessibility')[0];
  const captionServices = parseCaptionServiceMetadata(parseAttributes(accessibility));

  if (captionServices) {
    attrs = merge(attrs, {
      captionServices
    });
  }

  const label = findChildren(adaptationSet, 'Label')[0];

  if (label && label.childNodes.length) {
    const labelVal = label.childNodes[0].nodeValue.trim();
    attrs = merge(attrs, {
      label: labelVal
    });
  }

  const contentProtection = generateKeySystemInformation(findChildren(adaptationSet, 'ContentProtection'));

  if (Object.keys(contentProtection).length) {
    attrs = merge(attrs, {
      contentProtection
    });
  }

  const segmentInfo = getSegmentInformation(adaptationSet);
  const representations = findChildren(adaptationSet, 'Representation');
  const adaptationSetSegmentInfo = merge(periodSegmentInfo, segmentInfo);
  return flatten(representations.map(inheritBaseUrls(attrs, adaptationSetBaseUrls, adaptationSetSegmentInfo)));
};
/**
 * Contains all period information for mapping nodes onto adaptation sets.
 *
 * @typedef {Object} PeriodInformation
 * @property {Node} period.node
 *           Period node from the mpd
 * @property {Object} period.attributes
 *           Parsed period attributes from node plus any added
 */

/**
 * Maps a PeriodInformation object to a list of Representation information objects for all
 * AdaptationSet nodes contained within the Period.
 *
 * @name toAdaptationSetsCallback
 * @function
 * @param {PeriodInformation} period
 *        Period object containing necessary period information
 * @param {number} periodStart
 *        Start time of the Period within the mpd
 * @return {RepresentationInformation[]}
 *         List of objects containing Representaion information
 */

/**
 * Returns a callback for Array.prototype.map for mapping Period nodes to a list of
 * Representation information objects
 *
 * @param {Object} mpdAttributes
 *        Contains attributes inherited by the mpd
  * @param {Object[]} mpdBaseUrls
 *        Contains list of objects with resolved base urls and attributes
 *        inherited by the mpd
 * @return {toAdaptationSetsCallback}
 *         Callback map function
 */

const toAdaptationSets = (mpdAttributes, mpdBaseUrls) => (period, index) => {
  const periodBaseUrls = buildBaseUrls(mpdBaseUrls, findChildren(period.node, 'BaseURL'));
  const periodAttributes = merge(mpdAttributes, {
    periodStart: period.attributes.start
  });

  if (typeof period.attributes.duration === 'number') {
    periodAttributes.periodDuration = period.attributes.duration;
  }

  const adaptationSets = findChildren(period.node, 'AdaptationSet');
  const periodSegmentInfo = getSegmentInformation(period.node);
  return flatten(adaptationSets.map(toRepresentations(periodAttributes, periodBaseUrls, periodSegmentInfo)));
};
/**
 * Tranforms an array of content steering nodes into an object
 * containing CDN content steering information from the MPD manifest.
 *
 * For more information on the DASH spec for Content Steering parsing, see:
 * https://dashif.org/docs/DASH-IF-CTS-00XX-Content-Steering-Community-Review.pdf
 *
 * @param {Node[]} contentSteeringNodes
 *        Content steering nodes
 * @param {Function} eventHandler
 *        The event handler passed into the parser options to handle warnings
 * @return {Object}
 *        Object containing content steering data
 */

const generateContentSteeringInformation = (contentSteeringNodes, eventHandler) => {
  // If there are more than one ContentSteering tags, throw an error
  if (contentSteeringNodes.length > 1) {
    eventHandler({
      type: 'warn',
      message: 'The MPD manifest should contain no more than one ContentSteering tag'
    });
  } // Return a null value if there are no ContentSteering tags


  if (!contentSteeringNodes.length) {
    return null;
  }

  const infoFromContentSteeringTag = merge({
    serverURL: getContent(contentSteeringNodes[0])
  }, parseAttributes(contentSteeringNodes[0])); // Converts `queryBeforeStart` to a boolean, as well as setting the default value
  // to `false` if it doesn't exist

  infoFromContentSteeringTag.queryBeforeStart = infoFromContentSteeringTag.queryBeforeStart === 'true';
  return infoFromContentSteeringTag;
};
/**
 * Gets Period@start property for a given period.
 *
 * @param {Object} options
 *        Options object
 * @param {Object} options.attributes
 *        Period attributes
 * @param {Object} [options.priorPeriodAttributes]
 *        Prior period attributes (if prior period is available)
 * @param {string} options.mpdType
 *        The MPD@type these periods came from
 * @return {number|null}
 *         The period start, or null if it's an early available period or error
 */

const getPeriodStart = ({
  attributes,
  priorPeriodAttributes,
  mpdType
}) => {
  // Summary of period start time calculation from DASH spec section 5.3.2.1
  //
  // A period's start is the first period's start + time elapsed after playing all
  // prior periods to this one. Periods continue one after the other in time (without
  // gaps) until the end of the presentation.
  //
  // The value of Period@start should be:
  // 1. if Period@start is present: value of Period@start
  // 2. if previous period exists and it has @duration: previous Period@start +
  //    previous Period@duration
  // 3. if this is first period and MPD@type is 'static': 0
  // 4. in all other cases, consider the period an "early available period" (note: not
  //    currently supported)
  // (1)
  if (typeof attributes.start === 'number') {
    return attributes.start;
  } // (2)


  if (priorPeriodAttributes && typeof priorPeriodAttributes.start === 'number' && typeof priorPeriodAttributes.duration === 'number') {
    return priorPeriodAttributes.start + priorPeriodAttributes.duration;
  } // (3)


  if (!priorPeriodAttributes && mpdType === 'static') {
    return 0;
  } // (4)
  // There is currently no logic for calculating the Period@start value if there is
  // no Period@start or prior Period@start and Period@duration available. This is not made
  // explicit by the DASH interop guidelines or the DASH spec, however, since there's
  // nothing about any other resolution strategies, it's implied. Thus, this case should
  // be considered an early available period, or error, and null should suffice for both
  // of those cases.


  return null;
};
/**
 * Traverses the mpd xml tree to generate a list of Representation information objects
 * that have inherited attributes from parent nodes
 *
 * @param {Node} mpd
 *        The root node of the mpd
 * @param {Object} options
 *        Available options for inheritAttributes
 * @param {string} options.manifestUri
 *        The uri source of the mpd
 * @param {number} options.NOW
 *        Current time per DASH IOP.  Default is current time in ms since epoch
 * @param {number} options.clientOffset
 *        Client time difference from NOW (in milliseconds)
 * @return {RepresentationInformation[]}
 *         List of objects containing Representation information
 */

const inheritAttributes = (mpd, options = {}) => {
  const {
    manifestUri = '',
    NOW = Date.now(),
    clientOffset = 0,
    // TODO: For now, we are expecting an eventHandler callback function
    // to be passed into the mpd parser as an option.
    // In the future, we should enable stream parsing by using the Stream class from vhs-utils.
    // This will support new features including a standardized event handler.
    // See the m3u8 parser for examples of how stream parsing is currently used for HLS parsing.
    // https://github.com/videojs/vhs-utils/blob/88d6e10c631e57a5af02c5a62bc7376cd456b4f5/src/stream.js#L9
    eventHandler = function () {}
  } = options;
  const periodNodes = findChildren(mpd, 'Period');

  if (!periodNodes.length) {
    throw new Error(errors.INVALID_NUMBER_OF_PERIOD);
  }

  const locations = findChildren(mpd, 'Location');
  const mpdAttributes = parseAttributes(mpd);
  const mpdBaseUrls = buildBaseUrls([{
    baseUrl: manifestUri
  }], findChildren(mpd, 'BaseURL'));
  const contentSteeringNodes = findChildren(mpd, 'ContentSteering'); // See DASH spec section 5.3.1.2, Semantics of MPD element. Default type to 'static'.

  mpdAttributes.type = mpdAttributes.type || 'static';
  mpdAttributes.sourceDuration = mpdAttributes.mediaPresentationDuration || 0;
  mpdAttributes.NOW = NOW;
  mpdAttributes.clientOffset = clientOffset;

  if (locations.length) {
    mpdAttributes.locations = locations.map(getContent);
  }

  const periods = []; // Since toAdaptationSets acts on individual periods right now, the simplest approach to
  // adding properties that require looking at prior periods is to parse attributes and add
  // missing ones before toAdaptationSets is called. If more such properties are added, it
  // may be better to refactor toAdaptationSets.

  periodNodes.forEach((node, index) => {
    const attributes = parseAttributes(node); // Use the last modified prior period, as it may contain added information necessary
    // for this period.

    const priorPeriod = periods[index - 1];
    attributes.start = getPeriodStart({
      attributes,
      priorPeriodAttributes: priorPeriod ? priorPeriod.attributes : null,
      mpdType: mpdAttributes.type
    });
    periods.push({
      node,
      attributes
    });
  });
  return {
    locations: mpdAttributes.locations,
    contentSteeringInfo: generateContentSteeringInformation(contentSteeringNodes, eventHandler),
    // TODO: There are occurences where this `representationInfo` array contains undesired
    // duplicates. This generally occurs when there are multiple BaseURL nodes that are
    // direct children of the MPD node. When we attempt to resolve URLs from a combination of the
    // parent BaseURL and a child BaseURL, and the value does not resolve,
    // we end up returning the child BaseURL multiple times.
    // We need to determine a way to remove these duplicates in a safe way.
    // See: https://github.com/videojs/mpd-parser/pull/17#discussion_r162750527
    representationInfo: flatten(periods.map(toAdaptationSets(mpdAttributes, mpdBaseUrls))),
    eventStream: flatten(periods.map(toEventStream))
  };
};

const stringToMpdXml = manifestString => {
  if (manifestString === '') {
    throw new Error(errors.DASH_EMPTY_MANIFEST);
  }

  const parser = new _xmldom_xmldom__WEBPACK_IMPORTED_MODULE_4__.DOMParser();
  let xml;
  let mpd;

  try {
    xml = parser.parseFromString(manifestString, 'application/xml');
    mpd = xml && xml.documentElement.tagName === 'MPD' ? xml.documentElement : null;
  } catch (e) {// ie 11 throws on invalid xml
  }

  if (!mpd || mpd && mpd.getElementsByTagName('parsererror').length > 0) {
    throw new Error(errors.DASH_INVALID_XML);
  }

  return mpd;
};

/**
 * Parses the manifest for a UTCTiming node, returning the nodes attributes if found
 *
 * @param {string} mpd
 *        XML string of the MPD manifest
 * @return {Object|null}
 *         Attributes of UTCTiming node specified in the manifest. Null if none found
 */

const parseUTCTimingScheme = mpd => {
  const UTCTimingNode = findChildren(mpd, 'UTCTiming')[0];

  if (!UTCTimingNode) {
    return null;
  }

  const attributes = parseAttributes(UTCTimingNode);

  switch (attributes.schemeIdUri) {
    case 'urn:mpeg:dash:utc:http-head:2014':
    case 'urn:mpeg:dash:utc:http-head:2012':
      attributes.method = 'HEAD';
      break;

    case 'urn:mpeg:dash:utc:http-xsdate:2014':
    case 'urn:mpeg:dash:utc:http-iso:2014':
    case 'urn:mpeg:dash:utc:http-xsdate:2012':
    case 'urn:mpeg:dash:utc:http-iso:2012':
      attributes.method = 'GET';
      break;

    case 'urn:mpeg:dash:utc:direct:2014':
    case 'urn:mpeg:dash:utc:direct:2012':
      attributes.method = 'DIRECT';
      attributes.value = Date.parse(attributes.value);
      break;

    case 'urn:mpeg:dash:utc:http-ntp:2014':
    case 'urn:mpeg:dash:utc:ntp:2014':
    case 'urn:mpeg:dash:utc:sntp:2014':
    default:
      throw new Error(errors.UNSUPPORTED_UTC_TIMING_SCHEME);
  }

  return attributes;
};

const VERSION = version;
/*
 * Given a DASH manifest string and options, parses the DASH manifest into an object in the
 * form outputed by m3u8-parser and accepted by videojs/http-streaming.
 *
 * For live DASH manifests, if `previousManifest` is provided in options, then the newly
 * parsed DASH manifest will have its media sequence and discontinuity sequence values
 * updated to reflect its position relative to the prior manifest.
 *
 * @param {string} manifestString - the DASH manifest as a string
 * @param {options} [options] - any options
 *
 * @return {Object} the manifest object
 */

const parse = (manifestString, options = {}) => {
  const parsedManifestInfo = inheritAttributes(stringToMpdXml(manifestString), options);
  const playlists = toPlaylists(parsedManifestInfo.representationInfo);
  return toM3u8({
    dashPlaylists: playlists,
    locations: parsedManifestInfo.locations,
    contentSteering: parsedManifestInfo.contentSteeringInfo,
    sidxMapping: options.sidxMapping,
    previousManifest: options.previousManifest,
    eventStream: parsedManifestInfo.eventStream
  });
};
/**
 * Parses the manifest for a UTCTiming node, returning the nodes attributes if found
 *
 * @param {string} manifestString
 *        XML string of the MPD manifest
 * @return {Object|null}
 *         Attributes of UTCTiming node specified in the manifest. Null if none found
 */


const parseUTCTiming = manifestString => parseUTCTimingScheme(stringToMpdXml(manifestString));




/***/ }),

/***/ "./node_modules/mux.js/lib/tools/parse-sidx.js":
/*!*****************************************************!*\
  !*** ./node_modules/mux.js/lib/tools/parse-sidx.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getUint64 = (__webpack_require__(/*! ../utils/numbers.js */ "./node_modules/mux.js/lib/utils/numbers.js").getUint64);

var parseSidx = function(data) {
  var view = new DataView(data.buffer, data.byteOffset, data.byteLength),
      result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        references: [],
        referenceId: view.getUint32(4),
        timescale: view.getUint32(8)
      },
    i = 12;

  if (result.version === 0) {
    result.earliestPresentationTime = view.getUint32(i);
    result.firstOffset = view.getUint32(i + 4);
    i += 8;
  } else {
    // read 64 bits
    result.earliestPresentationTime = getUint64(data.subarray(i));
    result.firstOffset = getUint64(data.subarray(i + 8));
    i += 16;
  }

  i += 2; // reserved

  var referenceCount = view.getUint16(i);

  i += 2; // start of references

  for (; referenceCount > 0; i += 12, referenceCount--) {
    result.references.push({
      referenceType: (data[i] & 0x80) >>> 7,
      referencedSize: view.getUint32(i) & 0x7FFFFFFF,
      subsegmentDuration: view.getUint32(i + 4),
      startsWithSap: !!(data[i + 8] & 0x80),
      sapType: (data[i + 8] & 0x70) >>> 4,
      sapDeltaTime: view.getUint32(i + 8) & 0x0FFFFFFF
    });
  }

  return result;
};


module.exports = parseSidx;


/***/ }),

/***/ "./node_modules/mux.js/lib/utils/clock.js":
/*!************************************************!*\
  !*** ./node_modules/mux.js/lib/utils/clock.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * mux.js
 *
 * Copyright (c) Brightcove
 * Licensed Apache-2.0 https://github.com/videojs/mux.js/blob/master/LICENSE
 */
var
  ONE_SECOND_IN_TS = 90000, // 90kHz clock
  secondsToVideoTs,
  secondsToAudioTs,
  videoTsToSeconds,
  audioTsToSeconds,
  audioTsToVideoTs,
  videoTsToAudioTs,
  metadataTsToSeconds;

secondsToVideoTs = function(seconds) {
  return seconds * ONE_SECOND_IN_TS;
};

secondsToAudioTs = function(seconds, sampleRate) {
  return seconds * sampleRate;
};

videoTsToSeconds = function(timestamp) {
  return timestamp / ONE_SECOND_IN_TS;
};

audioTsToSeconds = function(timestamp, sampleRate) {
  return timestamp / sampleRate;
};

audioTsToVideoTs = function(timestamp, sampleRate) {
  return secondsToVideoTs(audioTsToSeconds(timestamp, sampleRate));
};

videoTsToAudioTs = function(timestamp, sampleRate) {
  return secondsToAudioTs(videoTsToSeconds(timestamp), sampleRate);
};

/**
 * Adjust ID3 tag or caption timing information by the timeline pts values
 * (if keepOriginalTimestamps is false) and convert to seconds
 */
metadataTsToSeconds = function(timestamp, timelineStartPts, keepOriginalTimestamps) {
  return videoTsToSeconds(keepOriginalTimestamps ? timestamp : timestamp - timelineStartPts);
};

module.exports = {
  ONE_SECOND_IN_TS: ONE_SECOND_IN_TS,
  secondsToVideoTs: secondsToVideoTs,
  secondsToAudioTs: secondsToAudioTs,
  videoTsToSeconds: videoTsToSeconds,
  audioTsToSeconds: audioTsToSeconds,
  audioTsToVideoTs: audioTsToVideoTs,
  videoTsToAudioTs: videoTsToAudioTs,
  metadataTsToSeconds: metadataTsToSeconds
};


/***/ }),

/***/ "./node_modules/mux.js/lib/utils/numbers.js":
/*!**************************************************!*\
  !*** ./node_modules/mux.js/lib/utils/numbers.js ***!
  \**************************************************/
/***/ ((module) => {

var MAX_UINT32 = Math.pow(2, 32);

var getUint64 = function(uint8) {
  var dv = new DataView(uint8.buffer, uint8.byteOffset, uint8.byteLength);
  var value;

  if (dv.getBigUint64) {
    value = dv.getBigUint64(0);

    if (value < Number.MAX_SAFE_INTEGER) {
      return Number(value);
    }

    return value;
  }

  return (dv.getUint32(0) * MAX_UINT32) + dv.getUint32(4);
};

module.exports = {
  getUint64: getUint64,
  MAX_UINT32: MAX_UINT32
};


/***/ }),

/***/ "./node_modules/shaka-player/dist/shaka-player.compiled.js":
/*!*****************************************************************!*\
  !*** ./node_modules/shaka-player/dist/shaka-player.compiled.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/*
 @license
 Shaka Player
 Copyright 2016 Google LLC
 SPDX-License-Identifier: Apache-2.0
*/
(function(){var innerGlobal=typeof window!="undefined"?window:__webpack_require__.g;var exportTo={};(function(window,global,module){/*

 Copyright The Closure Library Authors.
 SPDX-License-Identifier: Apache-2.0
*/
var p,aa=typeof Object.create=="function"?Object.create:function(a){function b(){}b.prototype=a;return new b},ba=typeof Object.defineProperties=="function"?Object.defineProperty:function(a,b,c){if(a==Array.prototype||a==Object.prototype)return a;a[b]=c.value;return a};
function ca(a){a=["object"==typeof globalThis&&globalThis,a,"object"==typeof window&&window,"object"==typeof self&&self,"object"==typeof global&&global];for(var b=0;b<a.length;++b){var c=a[b];if(c&&c.Math==Math)return c}throw Error("Cannot find global object");}var da=ca(this);function ea(a,b){if(b)a:{var c=da;a=a.split(".");for(var d=0;d<a.length-1;d++){var e=a[d];if(!(e in c))break a;c=c[e]}a=a[a.length-1];d=c[a];b=b(d);b!=d&&b!=null&&ba(c,a,{configurable:!0,writable:!0,value:b})}}var fa;
if(typeof Object.setPrototypeOf=="function")fa=Object.setPrototypeOf;else{var ha;a:{var ia={a:!0},ja={};try{ja.__proto__=ia;ha=ja.a;break a}catch(a){}ha=!1}fa=ha?function(a,b){a.__proto__=b;if(a.__proto__!==b)throw new TypeError(a+" is not extensible");return a}:null}var la=fa;
function ma(a,b){a.prototype=aa(b.prototype);a.prototype.constructor=a;if(la)la(a,b);else for(var c in b)if(c!="prototype")if(Object.defineProperties){var d=Object.getOwnPropertyDescriptor(b,c);d&&Object.defineProperty(a,c,d)}else a[c]=b[c];a.Im=b.prototype}function na(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
function u(a){var b=typeof Symbol!="undefined"&&Symbol.iterator&&a[Symbol.iterator];if(b)return b.call(a);if(typeof a.length=="number")return{next:na(a)};throw Error(String(a)+" is not an iterable or ArrayLike");}function x(a){if(!(a instanceof Array)){a=u(a);for(var b,c=[];!(b=a.next()).done;)c.push(b.value);a=c}return a}function oa(){this.o=!1;this.l=null;this.h=void 0;this.g=1;this.j=this.m=0;this.B=this.i=null}function pa(a){if(a.o)throw new TypeError("Generator is already running");a.o=!0}
oa.prototype.u=function(a){this.h=a};function qa(a,b){a.i={bi:b,si:!0};a.g=a.m||a.j}oa.prototype.return=function(a){this.i={return:a};this.g=this.j};function G(a,b,c){a.g=c;return{value:b}}oa.prototype.A=function(a){this.g=a};function H(a){a.g=0}function sa(a,b,c){a.m=b;c!=void 0&&(a.j=c)}function ta(a,b){a.m=0;a.j=b||0}function ua(a,b,c){a.g=b;a.m=c||0}function Aa(a,b){a.m=b||0;b=a.i.bi;a.i=null;return b}function Ba(a){a.B=[a.i];a.m=0;a.j=0}
function Ea(a,b){var c=a.B.splice(0)[0];(c=a.i=a.i||c)?c.si?a.g=a.m||a.j:c.A!=void 0&&a.j<c.A?(a.g=c.A,a.i=null):a.g=a.j:a.g=b}function Ga(a){this.g=new oa;this.h=a}function Ha(a,b){pa(a.g);var c=a.g.l;if(c)return Ia(a,"return"in c?c["return"]:function(d){return{value:d,done:!0}},b,a.g.return);a.g.return(b);return Ka(a)}
function Ia(a,b,c,d){try{var e=b.call(a.g.l,c);if(!(e instanceof Object))throw new TypeError("Iterator result "+e+" is not an object");if(!e.done)return a.g.o=!1,e;var f=e.value}catch(g){return a.g.l=null,qa(a.g,g),Ka(a)}a.g.l=null;d.call(a.g,f);return Ka(a)}function Ka(a){for(;a.g.g;)try{var b=a.h(a.g);if(b)return a.g.o=!1,{value:b.value,done:!1}}catch(c){a.g.h=void 0,qa(a.g,c)}a.g.o=!1;if(a.g.i){b=a.g.i;a.g.i=null;if(b.si)throw b.bi;return{value:b.return,done:!0}}return{value:void 0,done:!0}}
function La(a){this.next=function(b){pa(a.g);a.g.l?b=Ia(a,a.g.l.next,b,a.g.u):(a.g.u(b),b=Ka(a));return b};this.throw=function(b){pa(a.g);a.g.l?b=Ia(a,a.g.l["throw"],b,a.g.u):(qa(a.g,b),b=Ka(a));return b};this.return=function(b){return Ha(a,b)};this[Symbol.iterator]=function(){return this}}function Ma(a){function b(d){return a.next(d)}function c(d){return a.throw(d)}return new Promise(function(d,e){function f(g){g.done?d(g.value):Promise.resolve(g.value).then(b,c).then(f,e)}f(a.next())})}
function O(a){return Ma(new La(new Ga(a)))}function Na(){for(var a=Number(this),b=[],c=a;c<arguments.length;c++)b[c-a]=arguments[c];return b}ea("Symbol",function(a){function b(f){if(this instanceof b)throw new TypeError("Symbol is not a constructor");return new c(d+(f||"")+"_"+e++,f)}function c(f,g){this.g=f;ba(this,"description",{configurable:!0,writable:!0,value:g})}if(a)return a;c.prototype.toString=function(){return this.g};var d="jscomp_symbol_"+(Math.random()*1E9>>>0)+"_",e=0;return b});
ea("Symbol.iterator",function(a){if(a)return a;a=Symbol("Symbol.iterator");ba(Array.prototype,a,{configurable:!0,writable:!0,value:function(){return Oa(na(this))}});return a});function Oa(a){a={next:a};a[Symbol.iterator]=function(){return this};return a}
ea("Promise",function(a){function b(g){this.h=0;this.i=void 0;this.g=[];this.o=!1;var h=this.j();try{g(h.resolve,h.reject)}catch(k){h.reject(k)}}function c(){this.g=null}function d(g){return g instanceof b?g:new b(function(h){h(g)})}if(a)return a;c.prototype.h=function(g){if(this.g==null){this.g=[];var h=this;this.i(function(){h.l()})}this.g.push(g)};var e=da.setTimeout;c.prototype.i=function(g){e(g,0)};c.prototype.l=function(){for(;this.g&&this.g.length;){var g=this.g;this.g=[];for(var h=0;h<g.length;++h){var k=
g[h];g[h]=null;try{k()}catch(l){this.j(l)}}}this.g=null};c.prototype.j=function(g){this.i(function(){throw g;})};b.prototype.j=function(){function g(l){return function(m){k||(k=!0,l.call(h,m))}}var h=this,k=!1;return{resolve:g(this.G),reject:g(this.l)}};b.prototype.G=function(g){if(g===this)this.l(new TypeError("A Promise cannot resolve to itself"));else if(g instanceof b)this.I(g);else{a:switch(typeof g){case "object":var h=g!=null;break a;case "function":h=!0;break a;default:h=!1}h?this.F(g):this.m(g)}};
b.prototype.F=function(g){var h=void 0;try{h=g.then}catch(k){this.l(k);return}typeof h=="function"?this.J(h,g):this.m(g)};b.prototype.l=function(g){this.u(2,g)};b.prototype.m=function(g){this.u(1,g)};b.prototype.u=function(g,h){if(this.h!=0)throw Error("Cannot settle("+g+", "+h+"): Promise already settled in state"+this.h);this.h=g;this.i=h;this.h===2&&this.H();this.B()};b.prototype.H=function(){var g=this;e(function(){if(g.C()){var h=da.console;typeof h!=="undefined"&&h.error(g.i)}},1)};b.prototype.C=
function(){if(this.o)return!1;var g=da.CustomEvent,h=da.Event,k=da.dispatchEvent;if(typeof k==="undefined")return!0;typeof g==="function"?g=new g("unhandledrejection",{cancelable:!0}):typeof h==="function"?g=new h("unhandledrejection",{cancelable:!0}):(g=da.document.createEvent("CustomEvent"),g.initCustomEvent("unhandledrejection",!1,!0,g));g.promise=this;g.reason=this.i;return k(g)};b.prototype.B=function(){if(this.g!=null){for(var g=0;g<this.g.length;++g)f.h(this.g[g]);this.g=null}};var f=new c;
b.prototype.I=function(g){var h=this.j();g.Te(h.resolve,h.reject)};b.prototype.J=function(g,h){var k=this.j();try{g.call(h,k.resolve,k.reject)}catch(l){k.reject(l)}};b.prototype.then=function(g,h){function k(q,r){return typeof q=="function"?function(t){try{l(q(t))}catch(v){m(v)}}:r}var l,m,n=new b(function(q,r){l=q;m=r});this.Te(k(g,l),k(h,m));return n};b.prototype.catch=function(g){return this.then(void 0,g)};b.prototype.Te=function(g,h){function k(){switch(l.h){case 1:g(l.i);break;case 2:h(l.i);
break;default:throw Error("Unexpected state: "+l.h);}}var l=this;this.g==null?f.h(k):this.g.push(k);this.o=!0};b.resolve=d;b.reject=function(g){return new b(function(h,k){k(g)})};b.race=function(g){return new b(function(h,k){for(var l=u(g),m=l.next();!m.done;m=l.next())d(m.value).Te(h,k)})};b.all=function(g){var h=u(g),k=h.next();return k.done?d([]):new b(function(l,m){function n(t){return function(v){q[t]=v;r--;r==0&&l(q)}}var q=[],r=0;do q.push(void 0),r++,d(k.value).Te(n(q.length-1),m),k=h.next();
while(!k.done)})};return b});function Pa(a,b){return Object.prototype.hasOwnProperty.call(a,b)}
ea("WeakMap",function(a){function b(k){this.g=(h+=Math.random()+1).toString();if(k){k=u(k);for(var l;!(l=k.next()).done;)l=l.value,this.set(l[0],l[1])}}function c(){}function d(k){var l=typeof k;return l==="object"&&k!==null||l==="function"}function e(k){if(!Pa(k,g)){var l=new c;ba(k,g,{value:l})}}function f(k){var l=Object[k];l&&(Object[k]=function(m){if(m instanceof c)return m;Object.isExtensible(m)&&e(m);return l(m)})}if(function(){if(!a||!Object.seal)return!1;try{var k=Object.seal({}),l=Object.seal({}),
m=new a([[k,2],[l,3]]);if(m.get(k)!=2||m.get(l)!=3)return!1;m.delete(k);m.set(l,4);return!m.has(k)&&m.get(l)==4}catch(n){return!1}}())return a;var g="$jscomp_hidden_"+Math.random();f("freeze");f("preventExtensions");f("seal");var h=0;b.prototype.set=function(k,l){if(!d(k))throw Error("Invalid WeakMap key");e(k);if(!Pa(k,g))throw Error("WeakMap key fail: "+k);k[g][this.g]=l;return this};b.prototype.get=function(k){return d(k)&&Pa(k,g)?k[g][this.g]:void 0};b.prototype.has=function(k){return d(k)&&Pa(k,
g)&&Pa(k[g],this.g)};b.prototype.delete=function(k){return d(k)&&Pa(k,g)&&Pa(k[g],this.g)?delete k[g][this.g]:!1};return b});
ea("Map",function(a){function b(){var h={};return h.xc=h.next=h.head=h}function c(h,k){var l=h[1];return Oa(function(){if(l){for(;l.head!=h[1];)l=l.xc;for(;l.next!=l.head;)return l=l.next,{done:!1,value:k(l)};l=null}return{done:!0,value:void 0}})}function d(h,k){var l=k&&typeof k;l=="object"||l=="function"?f.has(k)?l=f.get(k):(l=""+ ++g,f.set(k,l)):l="p_"+k;var m=h[0][l];if(m&&Pa(h[0],l))for(h=0;h<m.length;h++){var n=m[h];if(k!==k&&n.key!==n.key||k===n.key)return{id:l,list:m,index:h,entry:n}}return{id:l,
list:m,index:-1,entry:void 0}}function e(h){this[0]={};this[1]=b();this.size=0;if(h){h=u(h);for(var k;!(k=h.next()).done;)k=k.value,this.set(k[0],k[1])}}if(function(){if(!a||typeof a!="function"||!a.prototype.entries||typeof Object.seal!="function")return!1;try{var h=Object.seal({x:4}),k=new a(u([[h,"s"]]));if(k.get(h)!="s"||k.size!=1||k.get({x:4})||k.set({x:4},"t")!=k||k.size!=2)return!1;var l=k.entries(),m=l.next();if(m.done||m.value[0]!=h||m.value[1]!="s")return!1;m=l.next();return m.done||m.value[0].x!=
4||m.value[1]!="t"||!l.next().done?!1:!0}catch(n){return!1}}())return a;var f=new WeakMap;e.prototype.set=function(h,k){h=h===0?0:h;var l=d(this,h);l.list||(l.list=this[0][l.id]=[]);l.entry?l.entry.value=k:(l.entry={next:this[1],xc:this[1].xc,head:this[1],key:h,value:k},l.list.push(l.entry),this[1].xc.next=l.entry,this[1].xc=l.entry,this.size++);return this};e.prototype.delete=function(h){h=d(this,h);return h.entry&&h.list?(h.list.splice(h.index,1),h.list.length||delete this[0][h.id],h.entry.xc.next=
h.entry.next,h.entry.next.xc=h.entry.xc,h.entry.head=null,this.size--,!0):!1};e.prototype.clear=function(){this[0]={};this[1]=this[1].xc=b();this.size=0};e.prototype.has=function(h){return!!d(this,h).entry};e.prototype.get=function(h){return(h=d(this,h).entry)&&h.value};e.prototype.entries=function(){return c(this,function(h){return[h.key,h.value]})};e.prototype.keys=function(){return c(this,function(h){return h.key})};e.prototype.values=function(){return c(this,function(h){return h.value})};e.prototype.forEach=
function(h,k){for(var l=this.entries(),m;!(m=l.next()).done;)m=m.value,h.call(k,m[1],m[0],this)};e.prototype[Symbol.iterator]=e.prototype.entries;var g=0;return e});
ea("Set",function(a){function b(c){this.g=new Map;if(c){c=u(c);for(var d;!(d=c.next()).done;)this.add(d.value)}this.size=this.g.size}if(function(){if(!a||typeof a!="function"||!a.prototype.entries||typeof Object.seal!="function")return!1;try{var c=Object.seal({x:4}),d=new a(u([c]));if(!d.has(c)||d.size!=1||d.add(c)!=d||d.size!=1||d.add({x:4})!=d||d.size!=2)return!1;var e=d.entries(),f=e.next();if(f.done||f.value[0]!=c||f.value[1]!=c)return!1;f=e.next();return f.done||f.value[0]==c||f.value[0].x!=
4||f.value[1]!=f.value[0]?!1:e.next().done}catch(g){return!1}}())return a;b.prototype.add=function(c){c=c===0?0:c;this.g.set(c,c);this.size=this.g.size;return this};b.prototype.delete=function(c){c=this.g.delete(c);this.size=this.g.size;return c};b.prototype.clear=function(){this.g.clear();this.size=0};b.prototype.has=function(c){return this.g.has(c)};b.prototype.entries=function(){return this.g.entries()};b.prototype.values=function(){return this.g.values()};b.prototype.keys=b.prototype.values;b.prototype[Symbol.iterator]=
b.prototype.values;b.prototype.forEach=function(c,d){var e=this;this.g.forEach(function(f){return c.call(d,f,f,e)})};return b});function Qa(a,b,c){a instanceof String&&(a=String(a));for(var d=a.length,e=0;e<d;e++){var f=a[e];if(b.call(c,f,e,a))return{ni:e,v:f}}return{ni:-1,v:void 0}}ea("Array.prototype.findIndex",function(a){return a?a:function(b,c){return Qa(this,b,c).ni}});
function Ra(a,b){a instanceof String&&(a+="");var c=0,d=!1,e={next:function(){if(!d&&c<a.length){var f=c++;return{value:b(f,a[f]),done:!1}}d=!0;return{done:!0,value:void 0}}};e[Symbol.iterator]=function(){return e};return e}ea("Array.prototype.values",function(a){return a?a:function(){return Ra(this,function(b,c){return c})}});
ea("Array.from",function(a){return a?a:function(b,c,d){c=c!=null?c:function(h){return h};var e=[],f=typeof Symbol!="undefined"&&Symbol.iterator&&b[Symbol.iterator];if(typeof f=="function"){b=f.call(b);for(var g=0;!(f=b.next()).done;)e.push(c.call(d,f.value,g++))}else for(f=b.length,g=0;g<f;g++)e.push(c.call(d,b[g],g));return e}});ea("Array.prototype.keys",function(a){return a?a:function(){return Ra(this,function(b){return b})}});
function Sa(a,b,c){if(a==null)throw new TypeError("The 'this' value for String.prototype."+c+" must not be null or undefined");if(b instanceof RegExp)throw new TypeError("First argument to String.prototype."+c+" must not be a regular expression");return a+""}ea("String.prototype.startsWith",function(a){return a?a:function(b,c){var d=Sa(this,b,"startsWith"),e=d.length,f=b.length;c=Math.max(0,Math.min(c|0,d.length));for(var g=0;g<f&&c<e;)if(d[c++]!=b[g++])return!1;return g>=f}});
ea("Object.is",function(a){return a?a:function(b,c){return b===c?b!==0||1/b===1/c:b!==b&&c!==c}});ea("Array.prototype.includes",function(a){return a?a:function(b,c){var d=this;d instanceof String&&(d=String(d));var e=d.length;c=c||0;for(c<0&&(c=Math.max(c+e,0));c<e;c++){var f=d[c];if(f===b||Object.is(f,b))return!0}return!1}});ea("String.prototype.includes",function(a){return a?a:function(b,c){return Sa(this,b,"includes").indexOf(b,c||0)!==-1}});
ea("String.fromCodePoint",function(a){return a?a:function(b){for(var c="",d=0;d<arguments.length;d++){var e=Number(arguments[d]);if(e<0||e>1114111||e!==Math.floor(e))throw new RangeError("invalid_code_point "+e);e<=65535?c+=String.fromCharCode(e):(e-=65536,c+=String.fromCharCode(e>>>10&1023|55296),c+=String.fromCharCode(e&1023|56320))}return c}});
ea("WeakSet",function(a){function b(c){this.g=new WeakMap;if(c){c=u(c);for(var d;!(d=c.next()).done;)this.add(d.value)}}if(function(){if(!a||!Object.seal)return!1;try{var c=Object.seal({}),d=Object.seal({}),e=new a([c]);if(!e.has(c)||e.has(d))return!1;e.delete(c);e.add(d);return!e.has(c)&&e.has(d)}catch(f){return!1}}())return a;b.prototype.add=function(c){this.g.set(c,!0);return this};b.prototype.has=function(c){return this.g.has(c)};b.prototype.delete=function(c){return this.g.delete(c)};return b});
ea("Array.prototype.find",function(a){return a?a:function(b,c){return Qa(this,b,c).v}});ea("Object.entries",function(a){return a?a:function(b){var c=[],d;for(d in b)Pa(b,d)&&c.push([d,b[d]]);return c}});var Ta=typeof Object.assign=="function"?Object.assign:function(a,b){if(a==null)throw new TypeError("No nullish arg");a=Object(a);for(var c=1;c<arguments.length;c++){var d=arguments[c];if(d)for(var e in d)Pa(d,e)&&(a[e]=d[e])}return a};ea("Object.assign",function(a){return a||Ta});
ea("Promise.prototype.finally",function(a){return a?a:function(b){return this.then(function(c){return Promise.resolve(b()).then(function(){return c})},function(c){return Promise.resolve(b()).then(function(){throw c;})})}});ea("Array.prototype.entries",function(a){return a?a:function(){return Ra(this,function(b,c){return[b,c]})}});ea("Number.isNaN",function(a){return a?a:function(b){return typeof b==="number"&&isNaN(b)}});
ea("String.prototype.repeat",function(a){return a?a:function(b){var c=Sa(this,null,"repeat");if(b<0||b>1342177279)throw new RangeError("Invalid count value");b|=0;for(var d="";b;)if(b&1&&(d+=c),b>>>=1)c+=c;return d}});ea("Number.EPSILON",function(){return 2.220446049250313E-16});ea("Number.MAX_SAFE_INTEGER",function(){return 9007199254740991});ea("Number.isFinite",function(a){return a?a:function(b){return typeof b!=="number"?!1:!isNaN(b)&&b!==Infinity&&b!==-Infinity}});
ea("Object.values",function(a){return a?a:function(b){var c=[],d;for(d in b)Pa(b,d)&&c.push(b[d]);return c}});ea("Math.log2",function(a){return a?a:function(b){return Math.log(b)/Math.LN2}});ea("String.prototype.endsWith",function(a){return a?a:function(b,c){var d=Sa(this,b,"endsWith");c===void 0&&(c=d.length);c=Math.max(0,Math.min(c|0,d.length));for(var e=b.length;e>0&&c>0;)if(d[--c]!=b[--e])return!1;return e<=0}});
ea("Math.trunc",function(a){return a?a:function(b){b=Number(b);if(isNaN(b)||b===Infinity||b===-Infinity||b===0)return b;var c=Math.floor(Math.abs(b));return b<0?-c:c}});var Ua=this||self;function T(a,b){a=a.split(".");var c=Ua;a[0]in c||typeof c.execScript=="undefined"||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)a.length||b===void 0?c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}:c[d]=b};/*
 @license
 Shaka Player
 Copyright 2016 Google LLC
 SPDX-License-Identifier: Apache-2.0
*/
function Va(a){this.g=Math.exp(Math.log(.5)/a);this.i=this.h=0}Va.prototype.sample=function(a,b){var c=Math.pow(this.g,a);b=b*(1-c)+c*this.h;isNaN(b)||(this.h=b,this.i+=a)};function Wa(a){return a.h/(1-Math.pow(a.g,a.i))};function Xa(){this.h=new Va(2);this.j=new Va(5);this.g=0;this.i=128E3;this.l=16E3}Xa.prototype.configure=function(a){this.i=a.minTotalBytes;this.l=a.minBytes;this.h.g=Math.exp(Math.log(.5)/a.fastHalfLife);this.j.g=Math.exp(Math.log(.5)/a.slowHalfLife)};Xa.prototype.sample=function(a,b){if(!(b<this.l)){var c=8E3*b/a;a/=1E3;this.g+=b;this.h.sample(a,c);this.j.sample(a,c)}};Xa.prototype.getBandwidthEstimate=function(a){return this.g<this.i?a:Math.min(Wa(this.h),Wa(this.j))};function Ya(){}function Za(){}function $a(){}function ab(a){var b=Na.apply(1,arguments);bb.has(a)||(bb.add(a),$a.apply(Ya,x(b)))}function cb(){}function db(){}function eb(){}var bb=new Set;
window.console&&((new Map).set(1,function(){return console.error.apply(console,x(Na.apply(0,arguments)))}).set(2,function(){return console.warn.apply(console,x(Na.apply(0,arguments)))}).set(3,function(){return console.info.apply(console,x(Na.apply(0,arguments)))}).set(4,function(){return console.log.apply(console,x(Na.apply(0,arguments)))}).set(5,function(){return console.debug.apply(console,x(Na.apply(0,arguments)))}).set(6,function(){return console.debug.apply(console,x(Na.apply(0,arguments)))}),
$a=function(){return console.warn.apply(console,x(Na.apply(0,arguments)))},Za=function(){console.error.apply(console,x(Na.apply(0,arguments)))});function fb(a,b){return typeof a==="number"&&typeof b==="number"&&isNaN(a)&&isNaN(b)?!0:a===b}function gb(a,b){b=a.indexOf(b);b>-1&&a.splice(b,1)}function hb(a,b,c){c||(c=fb);if(a.length!=b.length)return!1;b=b.slice();a=u(a);for(var d=a.next(),e={};!d.done;e={ui:void 0},d=a.next()){e.ui=d.value;d=b.findIndex(function(f){return function(g){return c(f.ui,g)}}(e));if(d==-1)return!1;b[d]=b[b.length-1];b.pop()}return b.length==0}
function ib(a,b,c){if(a===b)return!0;if(!a||!b)return a==b;c||(c=fb);if(a.length!=b.length)return!1;for(var d=0;d<a.length;d++)if(!c(a[d],b[d]))return!1;return!0};function jb(){this.g=new Map}p=jb.prototype;p.push=function(a,b){this.g.has(a)?this.g.get(a).push(b):this.g.set(a,[b])};p.get=function(a){return this.g.has(a)?this.g.get(a).slice():null};p.remove=function(a,b){if(this.g.has(a)){var c=this.g.get(a).filter(function(d){return d!=b});this.g.set(a,c);c.length||this.g.delete(a)}};p.forEach=function(a){this.g.forEach(function(b,c){a(c,b)})};p.size=function(){return this.g.size};p.keys=function(){return Array.from(this.g.keys())};function kb(){this.g=new jb}p=kb.prototype;p.release=function(){this.Qa();this.g=null};p.D=function(a,b,c,d){this.g&&(a=new lb(a,b,c,d),this.g.push(b,a))};p.Aa=function(a,b,c,d){function e(g){f.Ma(a,b,e);c(g)}var f=this;this.D(a,b,e,d)};p.Ma=function(a,b,c){if(this.g){var d=this.g.get(b)||[];d=u(d);for(var e=d.next();!e.done;e=d.next())e=e.value,e.target!=a||c!=e.listener&&c||(e.Ma(),this.g.remove(b,e))}};
p.Qa=function(){if(this.g){for(var a=[],b=u(this.g.g.values()),c=b.next();!c.done;c=b.next())a.push.apply(a,x(c.value));a=u(a);for(b=a.next();!b.done;b=a.next())b.value.Ma();this.g.g.clear()}};T("shaka.util.EventManager",kb);kb.prototype.removeAll=kb.prototype.Qa;kb.prototype.unlisten=kb.prototype.Ma;kb.prototype.listenOnce=kb.prototype.Aa;kb.prototype.listen=kb.prototype.D;kb.prototype.release=kb.prototype.release;
function lb(a,b,c,d){this.target=a;this.type=b;this.listener=c;this.g=mb(a,d);this.target.addEventListener(b,c,this.g)}lb.prototype.Ma=function(){this.target.removeEventListener(this.type,this.listener,this.g);this.listener=this.target=null;this.g=!1};function mb(a,b){if(b==void 0)return!1;if(typeof b=="boolean")return b;var c=new Set(["passive","capture"]);Object.keys(b).filter(function(d){return!c.has(d)});return nb(a)?b:b.capture||!1}
function nb(a){var b=ob;if(b==void 0){b=!1;try{var c={},d={get:function(){b=!0;return!1}};Object.defineProperty(c,"passive",d);Object.defineProperty(c,"capture",d);d=function(){};a.addEventListener("test",d,c);a.removeEventListener("test",d,c)}catch(e){b=!1}ob=b}return b||!1}var ob=void 0;T("shaka.config.AutoShowText",{NEVER:0,ALWAYS:1,IF_PREFERRED_TEXT_LANGUAGE:2,IF_SUBTITLES_MAY_BE_NEEDED:3});function qb(a){this.h=a;this.g=void 0}qb.prototype.value=function(){this.g===void 0&&(this.g=this.h());return this.g};/*
 @license
 Shaka Player
 Copyright 2025 Google LLC
 SPDX-License-Identifier: Apache-2.0
*/
function rb(){return sb.value()}var vb=null,wb=null,sb=new qb(function(){var a=void 0;vb&&(a=vb());!a&&wb&&(a=wb());return a});function xb(a,b){this.g=a;this.h=b}xb.prototype.toString=function(){return"v"+this.g+"."+this.h};function yb(a,b){var c=new xb(5,0),d=zb,e=d.g,f=c.h-e.h;((c.g-e.g||f)>0?d.i:d.h)(d.g,c,a,b)}function Ab(a,b,c,d){$a([c,"has been deprecated and will be removed in",b,". We are currently at version",a,". Additional information:",d].join(" "))}function Bb(a,b,c,d){Za([c,"has been deprecated and has been removed in",b,". We are now at version",a,". Additional information:",d].join(" "))}var zb=null;/*
 @license
 Copyright 2008 The Closure Library Authors
 SPDX-License-Identifier: Apache-2.0
*/
var Cb=RegExp("^(?:([^:/?#.]+):)?(?://(?:([^/?#]*)@)?([^/#?]*?)(?::([0-9]+))?(?=[/#?]|$))?([^?#]+)?(?:\\?([^#]*))?(?:#(.*))?$");/*
 @license
 Copyright 2006 The Closure Library Authors
 SPDX-License-Identifier: Apache-2.0
*/
function Db(a){var b;a instanceof Db?(Eb(this,a.fc),this.hd=a.hd,Fb(this,a.Db),Gb(this,a.Dd),this.Sb=a.Sb,Hb(this,a.g.clone()),this.Rc=a.Rc):a&&(b=String(a).match(Cb))?(Eb(this,b[1]||"",!0),this.hd=Ib(b[2]||""),Fb(this,b[3]||"",!0),Gb(this,b[4]),this.Sb=Ib(b[5]||"",!0),Hb(this,b[6]||"",!0),this.Rc=Ib(b[7]||"")):this.g=new Jb(null)}p=Db.prototype;p.fc="";p.hd="";p.Db="";p.Dd=null;p.Sb="";p.Rc="";
p.toString=function(){var a=[],b=this.fc;b&&a.push(Kb(b,Lb,!0),":");if(b=this.Db){a.push("//");var c=this.hd;c&&a.push(Kb(c,Lb,!0),"@");a.push(encodeURIComponent(b).replace(/%25([0-9a-fA-F]{2})/g,"%$1"));b=this.Dd;b!=null&&a.push(":",String(b))}if(b=this.Sb)this.Db&&b.charAt(0)!="/"&&a.push("/"),a.push(Kb(b,b.charAt(0)=="/"?Mb:Nb,!0));(b=this.g.toString())&&a.push("?",b);(b=this.Rc)&&a.push("#",Kb(b,Ob));return a.join("")};
p.resolve=function(a){var b=this.clone();b.fc==="data"&&(b=new Db);var c=!!a.fc;c?Eb(b,a.fc):c=!!a.hd;c?b.hd=a.hd:c=!!a.Db;c?Fb(b,a.Db):c=a.Dd!=null;var d=a.Sb;if(c)Gb(b,a.Dd);else if(c=!!a.Sb){if(d.charAt(0)!="/")if(this.Db&&!this.Sb)d="/"+d;else{var e=b.Sb.lastIndexOf("/");e!=-1&&(d=b.Sb.substr(0,e+1)+d)}if(d==".."||d==".")d="";else if(d.indexOf("./")!=-1||d.indexOf("/.")!=-1){e=d.lastIndexOf("/",0)==0;d=d.split("/");for(var f=[],g=0;g<d.length;){var h=d[g++];h=="."?e&&g==d.length&&f.push(""):h==
".."?((f.length>1||f.length==1&&f[0]!="")&&f.pop(),e&&g==d.length&&f.push("")):(f.push(h),e=!0)}d=f.join("/")}}c?b.Sb=d:c=a.g.toString()!=="";c?Hb(b,a.g.clone()):c=!!a.Rc;c&&(b.Rc=a.Rc);return b};p.clone=function(){return new Db(this)};function Eb(a,b,c){a.fc=c?Ib(b,!0):b;a.fc&&(a.fc=a.fc.replace(/:$/,""))}function Fb(a,b,c){a.Db=c?Ib(b,!0):b}function Gb(a,b){if(b){b=Number(b);if(isNaN(b)||b<0)throw Error("Bad port number "+b);a.Dd=b}else a.Dd=null}
function Hb(a,b,c){b instanceof Jb?a.g=b:(c||(b=Kb(b,Pb)),a.g=new Jb(b))}function Ib(a,b){return a?b?decodeURI(a):decodeURIComponent(a):""}function Kb(a,b,c){return a!=null?(a=encodeURI(a).replace(b,Qb),c&&(a=a.replace(/%25([0-9a-fA-F]{2})/g,"%$1")),a):null}function Qb(a){a=a.charCodeAt(0);return"%"+(a>>4&15).toString(16)+(a&15).toString(16)}var Lb=/[#\/\?@]/g,Nb=/[#\?:]/g,Mb=/[#\?]/g,Pb=/[#\?@]/g,Ob=/#/g;function Jb(a){this.g=a||null}
function Rb(a){if(!a.fb&&(a.fb=new Map,a.Vd=0,a.g))for(var b=a.g.split("&"),c=0;c<b.length;c++){var d=b[c].indexOf("="),e=null;if(d>=0){var f=b[c].substring(0,d);e=b[c].substring(d+1)}else f=b[c];f=decodeURIComponent(f);e=e||"";a.add(f,decodeURIComponent(e))}}p=Jb.prototype;p.fb=null;p.Vd=null;function Sb(a){Rb(a);return a.Vd}p.add=function(a,b){Rb(this);this.g=null;var c=this.fb.has(a)?this.fb.get(a):null;c||this.fb.set(a,c=[]);c.push(b);this.Vd++;return this};
p.set=function(a,b){Rb(this);this.g=null;this.fb.has(a)?this.fb.set(a,[b]):this.add(a,b);return this};p.get=function(a){Rb(this);return this.fb.get(a)||[]};p.toString=function(){if(this.g)return this.g;if(!this.fb||!this.fb.size)return"";for(var a=[],b=u(this.fb.keys()),c=b.next();!c.done;c=b.next()){var d=c.value;c=encodeURIComponent(d);d=this.fb.get(d);for(var e=0;e<d.length;e++){var f=c;d[e]!==""&&(f+="="+encodeURIComponent(d[e]));a.push(f)}}return this.g=a.join("&")};
p.clone=function(){var a=new Jb;a.g=this.g;if(this.fb){for(var b=new Map,c=u(this.fb),d=c.next();!d.done;d=c.next()){var e=u(d.value);d=e.next().value;e=e.next().value;b.set(d,e.concat())}a.fb=b;a.Vd=this.Vd}return a};function Tb(){}function Ub(a,b){if(!a&&!b)return!0;if(!a||!b||a.byteLength!=b.byteLength)return!1;if((ArrayBuffer.isView(a)?a.buffer:a)==(ArrayBuffer.isView(b)?b.buffer:b)&&(a.byteOffset||0)==(b.byteOffset||0))return!0;var c=Wb(a);b=Wb(b);for(var d=0;d<a.byteLength;d++)if(c[d]!=b[d])return!1;return!0}function Yb(a){return ArrayBuffer.isView(a)?a.byteOffset==0&&a.byteLength==a.buffer.byteLength?a.buffer:(new Uint8Array(a)).buffer:a}
function Wb(a,b,c){c=c===void 0?Infinity:c;return Zb(a,b===void 0?0:b,c,Uint8Array)}function $b(a,b,c){c=c===void 0?Infinity:c;return Zb(a,b===void 0?0:b,c,Uint16Array)}function ac(a,b,c){c=c===void 0?Infinity:c;return Zb(a,b===void 0?0:b,c,DataView)}
function Zb(a,b,c,d){var e=ArrayBuffer.isView(a)?a.buffer:a,f=1;"BYTES_PER_ELEMENT"in d&&(f=d.BYTES_PER_ELEMENT);var g=((a.byteOffset||0)+a.byteLength)/f;a=Math.floor(Math.max(0,Math.min(((a.byteOffset||0)+b)/f,g)));return new d(e,a,Math.floor(Math.min(a+Math.max(c,0),g))-a)}T("shaka.util.BufferUtils",Tb);Tb.toDataView=ac;Tb.toUint16=$b;Tb.toUint8=Wb;Tb.toArrayBuffer=Yb;Tb.equal=Ub;function bc(a,b){if(a===b||!a.length||!b.length)return!0;a=u(a);for(var c=a.next();!c.done;c=a.next()){c=c.value;if(cc(c))return!0;for(var d=u(b),e=d.next();!e.done;e=d.next())if(e=e.value,c.keySystem===e.keySystem||cc(e))return!0}return!1}
function fc(a,b){if(!a.length)return b;if(!b.length)return a;var c=[];a=u(a);for(var d=a.next();!d.done;d=a.next()){d=d.value;for(var e=u(b),f=e.next();!f.done;f=e.next())if(f=f.value,d.keySystem==f.keySystem){e=new Map;for(var g=u((d.initData||[]).concat(f.initData||[])),h=g.next();!h.done;h=g.next())h=h.value,e.set(h.keyId,h);e=Array.from(e.values());g=d.keyIds&&f.keyIds?new Set([].concat(x(d.keyIds),x(f.keyIds))):d.keyIds||f.keyIds;c.push({keySystem:d.keySystem,licenseServerUri:d.licenseServerUri||
f.licenseServerUri,distinctiveIdentifierRequired:d.distinctiveIdentifierRequired||f.distinctiveIdentifierRequired,persistentStateRequired:d.persistentStateRequired||f.persistentStateRequired,videoRobustness:d.videoRobustness||f.videoRobustness,audioRobustness:d.audioRobustness||f.audioRobustness,serverCertificate:d.serverCertificate||f.serverCertificate,serverCertificateUri:d.serverCertificateUri||f.serverCertificateUri,initData:e,keyIds:g});break}else cc(d)?c.push(d):cc(f)&&c.push(f)}return c}
function hc(a){return a?!!a.match(/^com\.(microsoft|chromecast)\.playready/):!1}function ic(a){return a?!!a.match(/^com\.apple\.fps/):!1}function cc(a){return(a=a.licenseServerUri)?a.startsWith("data:application/json;base64,"):!1}function jc(a,b,c,d){d=[].concat(x(new Set(d))).sort().join("#");return a+"#"+b+"#"+c+"#"+d}var kc=new qb(function(){return Yb(new Uint8Array([0]))}),lc=new Map;function U(a,b,c){var d=Na.apply(3,arguments);this.severity=a;this.category=b;this.code=c;this.data=d;this.handled=!1;this.message="Shaka Error "+this.code;if(mc)try{throw Error(this.message||"Shaka Error");}catch(e){this.stack=e.stack}}U.prototype.toString=function(){return"shaka.util.Error "+JSON.stringify(this,null,"  ")};T("shaka.util.Error",U);var mc=!0;U.Severity={RECOVERABLE:1,CRITICAL:2};U.Category={NETWORK:1,TEXT:2,MEDIA:3,MANIFEST:4,STREAMING:5,DRM:6,PLAYER:7,CAST:8,STORAGE:9,ADS:10};
U.Code={UNSUPPORTED_SCHEME:1E3,BAD_HTTP_STATUS:1001,HTTP_ERROR:1002,TIMEOUT:1003,MALFORMED_DATA_URI:1004,REQUEST_FILTER_ERROR:1006,RESPONSE_FILTER_ERROR:1007,MALFORMED_TEST_URI:1008,UNEXPECTED_TEST_REQUEST:1009,ATTEMPTS_EXHAUSTED:1010,SEGMENT_MISSING:1011,INVALID_TEXT_HEADER:2E3,INVALID_TEXT_CUE:2001,UNABLE_TO_DETECT_ENCODING:2003,BAD_ENCODING:2004,INVALID_XML:2005,INVALID_MP4_TTML:2007,INVALID_MP4_VTT:2008,UNABLE_TO_EXTRACT_CUE_START_TIME:2009,INVALID_MP4_CEA:2010,TEXT_COULD_NOT_GUESS_MIME_TYPE:2011,
CANNOT_ADD_EXTERNAL_TEXT_TO_SRC_EQUALS:2012,TEXT_ONLY_WEBVTT_SRC_EQUALS:2013,MISSING_TEXT_PLUGIN:2014,UNSUPPORTED_EXTERNAL_THUMBNAILS_URI:2017,BUFFER_READ_OUT_OF_BOUNDS:3E3,JS_INTEGER_OVERFLOW:3001,EBML_OVERFLOW:3002,EBML_BAD_FLOATING_POINT_SIZE:3003,MP4_SIDX_WRONG_BOX_TYPE:3004,MP4_SIDX_INVALID_TIMESCALE:3005,MP4_SIDX_TYPE_NOT_SUPPORTED:3006,WEBM_CUES_ELEMENT_MISSING:3007,WEBM_EBML_HEADER_ELEMENT_MISSING:3008,WEBM_SEGMENT_ELEMENT_MISSING:3009,WEBM_INFO_ELEMENT_MISSING:3010,WEBM_DURATION_ELEMENT_MISSING:3011,
WEBM_CUE_TRACK_POSITIONS_ELEMENT_MISSING:3012,WEBM_CUE_TIME_ELEMENT_MISSING:3013,MEDIA_SOURCE_OPERATION_FAILED:3014,MEDIA_SOURCE_OPERATION_THREW:3015,VIDEO_ERROR:3016,QUOTA_EXCEEDED_ERROR:3017,TRANSMUXING_FAILED:3018,CONTENT_TRANSFORMATION_FAILED:3019,MSS_MISSING_DATA_FOR_TRANSMUXING:3020,MSS_TRANSMUXING_FAILED:3022,TRANSMUXING_NO_VIDEO_DATA:3023,STREAMING_NOT_ALLOWED:3024,UNABLE_TO_GUESS_MANIFEST_TYPE:4E3,DASH_INVALID_XML:4001,DASH_NO_SEGMENT_INFO:4002,DASH_EMPTY_ADAPTATION_SET:4003,DASH_EMPTY_PERIOD:4004,
DASH_WEBM_MISSING_INIT:4005,DASH_UNSUPPORTED_CONTAINER:4006,DASH_PSSH_BAD_ENCODING:4007,DASH_NO_COMMON_KEY_SYSTEM:4008,DASH_MULTIPLE_KEY_IDS_NOT_SUPPORTED:4009,DASH_CONFLICTING_KEY_IDS:4010,RESTRICTIONS_CANNOT_BE_MET:4012,HLS_PLAYLIST_HEADER_MISSING:4015,INVALID_HLS_TAG:4016,HLS_INVALID_PLAYLIST_HIERARCHY:4017,DASH_DUPLICATE_REPRESENTATION_ID:4018,HLS_MULTIPLE_MEDIA_INIT_SECTIONS_FOUND:4020,HLS_REQUIRED_ATTRIBUTE_MISSING:4023,HLS_REQUIRED_TAG_MISSING:4024,HLS_COULD_NOT_GUESS_CODECS:4025,HLS_KEYFORMATS_NOT_SUPPORTED:4026,
DASH_UNSUPPORTED_XLINK_ACTUATE:4027,DASH_XLINK_DEPTH_LIMIT:4028,CONTENT_UNSUPPORTED_BY_BROWSER:4032,CANNOT_ADD_EXTERNAL_TEXT_TO_LIVE_STREAM:4033,NO_VARIANTS:4036,PERIOD_FLATTENING_FAILED:4037,INCONSISTENT_DRM_ACROSS_PERIODS:4038,HLS_VARIABLE_NOT_FOUND:4039,HLS_MSE_ENCRYPTED_MP2T_NOT_SUPPORTED:4040,HLS_MSE_ENCRYPTED_LEGACY_APPLE_MEDIA_KEYS_NOT_SUPPORTED:4041,NO_WEB_CRYPTO_API:4042,CANNOT_ADD_EXTERNAL_THUMBNAILS_TO_LIVE_STREAM:4045,MSS_INVALID_XML:4046,MSS_LIVE_CONTENT_NOT_SUPPORTED:4047,AES_128_INVALID_IV_LENGTH:4048,
AES_128_INVALID_KEY_LENGTH:4049,DASH_CONFLICTING_AES_128:4050,DASH_UNSUPPORTED_AES_128:4051,DASH_INVALID_PATCH:4052,HLS_EMPTY_MEDIA_PLAYLIST:4053,DASH_MSE_ENCRYPTED_LEGACY_APPLE_MEDIA_KEYS_NOT_SUPPORTED:4054,CANNOT_ADD_EXTERNAL_CHAPTERS_TO_LIVE_STREAM:4055,STREAMING_ENGINE_STARTUP_INVALID_STATE:5006,NO_RECOGNIZED_KEY_SYSTEMS:6E3,REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE:6001,FAILED_TO_CREATE_CDM:6002,FAILED_TO_ATTACH_TO_VIDEO:6003,INVALID_SERVER_CERTIFICATE:6004,FAILED_TO_CREATE_SESSION:6005,FAILED_TO_GENERATE_LICENSE_REQUEST:6006,
LICENSE_REQUEST_FAILED:6007,LICENSE_RESPONSE_REJECTED:6008,ENCRYPTED_CONTENT_WITHOUT_DRM_INFO:6010,NO_LICENSE_SERVER_GIVEN:6012,OFFLINE_SESSION_REMOVED:6013,EXPIRED:6014,SERVER_CERTIFICATE_REQUIRED:6015,INIT_DATA_TRANSFORM_ERROR:6016,SERVER_CERTIFICATE_REQUEST_FAILED:6017,MIN_HDCP_VERSION_NOT_MATCH:6018,ERROR_CHECKING_HDCP_VERSION:6019,MISSING_EME_SUPPORT:6020,LOAD_INTERRUPTED:7E3,OPERATION_ABORTED:7001,NO_VIDEO_ELEMENT:7002,OBJECT_DESTROYED:7003,CONTENT_NOT_LOADED:7004,SRC_EQUALS_PRELOAD_NOT_SUPPORTED:7005,
PRELOAD_DESTROYED:7006,QUEUE_INDEX_OUT_OF_BOUNDS:7007,CAST_API_UNAVAILABLE:8E3,NO_CAST_RECEIVERS:8001,ALREADY_CASTING:8002,UNEXPECTED_CAST_ERROR:8003,CAST_CANCELED_BY_USER:8004,CAST_CONNECTION_TIMED_OUT:8005,CAST_RECEIVER_APP_UNAVAILABLE:8006,STORAGE_NOT_SUPPORTED:9E3,INDEXED_DB_ERROR:9001,DEPRECATED_OPERATION_ABORTED:9002,REQUESTED_ITEM_NOT_FOUND:9003,MALFORMED_OFFLINE_URI:9004,CANNOT_STORE_LIVE_OFFLINE:9005,NO_INIT_DATA_FOR_OFFLINE:9007,LOCAL_PLAYER_INSTANCE_REQUIRED:9008,NEW_KEY_OPERATION_NOT_SUPPORTED:9011,
KEY_NOT_FOUND:9012,MISSING_STORAGE_CELL:9013,STORAGE_LIMIT_REACHED:9014,DOWNLOAD_SIZE_CALLBACK_ERROR:9015,MODIFY_OPERATION_NOT_SUPPORTED:9016,INDEXED_DB_INIT_TIMED_OUT:9017,CS_IMA_SDK_MISSING:1E4,CS_AD_MANAGER_NOT_INITIALIZED:10001,SS_IMA_SDK_MISSING:10002,SS_AD_MANAGER_NOT_INITIALIZED:10003,CURRENT_DAI_REQUEST_NOT_FINISHED:10004,MT_AD_MANAGER_NOT_INITIALIZED:10005,INTERSTITIAL_AD_MANAGER_NOT_INITIALIZED:10006,VAST_INVALID_XML:10007};function nc(){}
function oc(a){if(!a)return"";a=Wb(a);a[0]==239&&a[1]==187&&a[2]==191&&(a=a.subarray(3));if(window.TextDecoder&&!rb().xh())return a=(new TextDecoder).decode(a),a.includes("\ufffd")&&Za('Decoded string contains an "unknown character" codepoint.  That probably means the UTF8 encoding was incorrect!'),a;for(var b="",c=0;c<a.length;++c){var d=65533;(a[c]&128)==0?d=a[c]:a.length>=c+2&&(a[c]&224)==192&&(a[c+1]&192)==128?(d=(a[c]&31)<<6|a[c+1]&63,c+=1):a.length>=c+3&&(a[c]&240)==224&&(a[c+1]&192)==128&&
(a[c+2]&192)==128?(d=(a[c]&15)<<12|(a[c+1]&63)<<6|a[c+2]&63,c+=2):a.length>=c+4&&(a[c]&241)==240&&(a[c+1]&192)==128&&(a[c+2]&192)==128&&(a[c+3]&192)==128&&(d=(a[c]&7)<<18|(a[c+1]&63)<<12|(a[c+2]&63)<<6|a[c+3]&63,c+=3);if(d<=65535)b+=String.fromCharCode(d);else{d-=65536;var e=d&1023;b+=String.fromCharCode(55296+(d>>10));b+=String.fromCharCode(56320+e)}}return b}
function qc(a,b,c){if(!a)return"";if(!c&&a.byteLength%2!=0)throw new U(2,2,2004);c=Math.floor(a.byteLength/2);var d=new Uint16Array(c);a=ac(a);for(var e=0;e<c;e++)d[e]=a.getUint16(e*2,b);return rc.value()(d)}
function sc(a){function b(d){return c.byteLength<=d||c[d]>=9&&c[d]<=126}if(!a)return"";var c=Wb(a);if(c[0]==239&&c[1]==187&&c[2]==191)return oc(c);if(c[0]==254&&c[1]==255)return qc(c.subarray(2),!1);if(c[0]==255&&c[1]==254)return qc(c.subarray(2),!0);if(c[0]==0&&c[2]==0)return qc(a,!1);if(c[1]==0&&c[3]==0)return qc(a,!0);if(b(0)&&b(1)&&b(2)&&b(3))return oc(a);throw new U(2,2,2003);}
function uc(a){if(window.TextEncoder&&!rb().xh()){var b=new TextEncoder;return Yb(b.encode(a))}a=encodeURIComponent(a);a=unescape(a);b=new Uint8Array(a.length);for(var c=0;c<a.length;c++)b[c]=a[c].charCodeAt(0);return Yb(b)}function vc(a,b){for(var c=new ArrayBuffer(a.length*2),d=new DataView(c),e=0;e<a.length;++e)d.setUint16(e*2,a.charCodeAt(e),b);return c}
function wc(a){var b={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&apos;":"'","&nbsp;":"\u00a0","&lrm;":"\u200e","&rlm;":"\u200f"},c=/&(?:amp|lt|gt|quot|apos|nbsp|lrm|rlm|#[xX]?[0-9a-fA-F]+);/g,d=RegExp(c.source);return a&&d.test(a)?a.replace(c,function(e){return e[1]=="#"?(e=e[2]=="x"||e[2]=="X"?parseInt(e.substring(3),16):parseInt(e.substring(2),10),e>=0&&e<=1114111?String.fromCodePoint(e):""):b[e]||"'"}):a||""}T("shaka.util.StringUtils",nc);nc.resetFromCharCode=function(){rc.g=void 0};
nc.toUTF16=vc;nc.toUTF8=uc;nc.fromBytesAutoDetect=sc;nc.fromUTF16=qc;nc.fromUTF8=oc;var rc=new qb(function(){function a(c){try{var d=new Uint8Array(c);return String.fromCharCode.apply(null,d).length>0}catch(e){return!1}}for(var b={Pc:65536};b.Pc>0;b={Pc:b.Pc},b.Pc/=2)if(a(b.Pc))return function(c){return function(d){for(var e="",f=0;f<d.length;f+=c.Pc)e+=String.fromCharCode.apply(null,d.subarray(f,f+c.Pc));return e}}(b);return null});function xc(){}function yc(a){a=Wb(a);return Uint8Array.prototype.toBase64?a.toBase64({alphabet:"base64",omitPadding:!1}):(a=rc.value()(a),btoa(a))}function zc(a,b){b=b==void 0?!0:b;return Uint8Array.prototype.toBase64?Wb(a).toBase64({alphabet:"base64url",omitPadding:!b}):(a=yc(a).replace(/\+/g,"-").replace(/\//g,"_"),b?a:a.replace(/[=]*$/,""))}
function Ac(a){if(!("fromBase64"in Uint8Array)){a=window.atob(a.replace(/-/g,"+").replace(/_/g,"/"));for(var b=new Uint8Array(a.length),c=0;c<a.length;++c)b[c]=a.charCodeAt(c);return b}a=a.replace(/\s+/g,"");return Uint8Array.fromBase64(a,{alphabet:/[-_]/.test(a)?"base64url":"base64"})}function Bc(a){if(!("fromHex"in Uint8Array)){for(var b=a.length/2,c=new Uint8Array(b),d=0;d<b;d++)c[d]=window.parseInt(a.substr(d*2,2),16);return c}return Uint8Array.fromHex(a)}
function Cc(a){var b=Wb(a);if(!Uint8Array.prototype.toHex){a="";b=u(b);for(var c=b.next();!c.done;c=b.next())c=c.value,c=c.toString(16),c.length==1&&(c="0"+c),a+=c;return a}return b.toHex()}function Dc(){for(var a=Na.apply(0,arguments),b=0,c=0;c<a.length;++c)b+=a[c].byteLength;b=new Uint8Array(b);for(var d=c=0;d<a.length;++d){var e=a[d];ArrayBuffer.isView(e)&&e.BYTES_PER_ELEMENT===1?b.set(e,c):b.set(Wb(e),c);c+=e.byteLength}return b}T("shaka.util.Uint8ArrayUtils",xc);xc.concat=Dc;xc.toHex=Cc;
xc.fromHex=Bc;xc.fromBase64=Ac;xc.toBase64=zc;xc.toStandardBase64=yc;function Ec(a,b,c){c=c===void 0?"":c;if(b.length==0)return a;if(a.length==1&&b.length==1){var d=new Db(a[0]);b=new Db(b[0]);b=d.resolve(b);c&&Hb(b,c);return[b.toString()]}b=b.map(function(h){return new Db(h)});d=[];a=u(a);for(var e=a.next();!e.done;e=a.next()){e=new Db(e.value);for(var f=u(b),g=f.next();!g.done;g=f.next())g=e.resolve(g.value),c&&Hb(g,c),d.push(g.toString())}return d}
function Fc(a,b,c,d,e){b={keySystem:a,encryptionScheme:b,licenseServerUri:"",distinctiveIdentifierRequired:!1,persistentStateRequired:!1,audioRobustness:"",videoRobustness:"",serverCertificate:null,serverCertificateUri:"",sessionType:"",initData:c||[],keyIds:new Set,mediaTypes:e};d&&(b.keySystemUris=new Set([d]));!c&&ic(a)&&b.initData.push({initDataType:"sinf",initData:new Uint8Array(0),keyId:null});return b}
function Gc(a,b){b=b===void 0?"cenc":b;var c=[],d=[],e=[];a.forEach(function(g,h){var k=h;k.length!=22&&(k=zc(Bc(h),!1));var l=g;l.length!=22&&(l=zc(Bc(g),!1));g={kty:"oct",kid:k,k:l};c.push(g);d.push(g.kid);e.push(h)});a=JSON.stringify({keys:c});var f=JSON.stringify({kids:d});f=[{initData:Wb(uc(f)),initDataType:"keyids"}];return{keySystem:"org.w3.clearkey",encryptionScheme:b,licenseServerUri:"data:application/json;base64,"+window.btoa(a),distinctiveIdentifierRequired:!1,persistentStateRequired:!1,
audioRobustness:"",videoRobustness:"",serverCertificate:null,serverCertificateUri:"",sessionType:"",initData:f,keyIds:new Set(e)}}function Hc(a,b){if(b.length==1)return b[0];a=Ic(a,b);if(a!=null)return a;throw new U(2,4,4025,b);}function Ic(a,b){var c=Jc.get(a);c=u(c);for(var d=c.next();!d.done;d=c.next()){d=d.value;for(var e=u(b),f=e.next();!f.done;f=e.next())if(f=f.value,d.test(f.trim()))return f.trim()}return a==Kc?"":null}
function Lc(a,b){var c=[];a=Jc.get(a);a=u(a);for(var d=a.next();!d.done;d=a.next()){d=d.value;for(var e=u(b),f=e.next();!f.done;f=e.next())f=f.value,d.test(f.trim())&&c.push(f.trim())}return c}
var Kc="text",Mc={wa:"video",aa:"audio",Na:Kc,Yf:"image",ul:"application"},Nc=1/15,Jc=(new Map).set("audio",[/^vorbis$/,/^Opus$/,/^opus$/,/^fLaC$/,/^flac$/,/^mp4a/,/^[ae]c-3$/,/^ac-4/,/^dts[cex]$/,/^iamf/,/^mhm[12]/,/^ac3$/,/^eac3$/,/^apac$/]).set("video",[/^avc/,/^hev/,/^hvc/,/^vvc/,/^vvi/,/^vp0?[89]/,/^av01/,/^dvh/,/^dva/,/^dav/]).set("text",[/^vtt$/,/^wvtt/,/^stpp/]);function Oc(a,b,c,d){this.g=null;this.l=a;this.i=b;this.m=c;this.o=d;this.j=!1;a:{typeof libDPIModule==="undefined"&&$a("Could not find LCEVC Library dependencies on this page");if(typeof LCEVCdec!=="undefined")this.h=LCEVCdec;else if(typeof LcevcDil!=="undefined")this.h=LcevcDil,this.j=!0,yb("LcevcDil","lcevc_dil.js is deprecated, please use lcevc_dec.js instead");else{$a("Could not find LCEVC Library on this page");a=!1;break a}typeof this.h.SupportObject==="undefined"?($a("Could not find LCEVC Library on this page"),
a=!1):(this.h.SupportObject.SupportStatus||$a(this.h.SupportObject.SupportError),a=typeof this.h!=="undefined"&&typeof libDPIModule!=="undefined"&&this.i instanceof HTMLCanvasElement&&this.h.SupportObject.SupportStatus)}a&&!this.g&&this.h.SupportObject.webGLSupport(this.i)&&(this.i.classList.remove("shaka-hidden"),this.g=this.j?new this.h.LcevcDil(this.l,this.i,this.m):new this.h.LCEVCdec(this.l,this.i,this.m))}
function Pc(a,b,c,d){d.type!=="video"||a.o&&!d.baseOriginalId||a.g&&a.g.appendBuffer(b,"video",d.id,-c,!a.o)}function Qc(a){a.g&&a.i.classList.add("shaka-hidden")}Oc.prototype.release=function(){this.g&&(this.g.close(),this.g=null)};function Rc(a){return a&&typeof LCEVCdec!=="undefined"?a.codecs=="lvc1":!1}T("shaka.lcevc.Dec",Oc);Oc.prototype.release=Oc.prototype.release;function Sc(){}function Tc(a,b){Uc.set(a,b)}function Vc(){var a={};rb();if(Wc())for(var b=u(Uc.keys()),c=b.next();!c.done;c=b.next())a[c.value]=!0;b=u(["application/dash+xml","application/x-mpegurl","application/vnd.apple.mpegurl","application/vnd.ms-sstr+xml"]);for(c=b.next();!c.done;c=b.next())c=c.value,a[c]=Wc()?Uc.has(c):Xc().canPlayType(c)!="";return a}function Yc(a,b){if(b){var c=Uc.get(b.toLowerCase());if(c)return c}throw new U(2,4,4E3,a,b);}T("shaka.media.ManifestParser",Sc);
Sc.unregisterParserByMime=function(a){Uc.delete(a)};Sc.registerParserByMime=Tc;Sc.registerParserByExtension=function(){yb("ManifestParser.registerParserByExtension","Please use an ManifestParser with registerParserByMime function.")};Sc.AccessibilityPurpose={Cm:"visually impaired",Nl:"hard of hearing",jm:"spoken subtitles"};var Uc=new Map;function Zc(){}Zc.prototype.extract=function(){};Zc.prototype.decode=function(){return[]};Zc.prototype.clear=function(){};Zc.prototype.getStreams=function(){return[]};function $c(){}$c.prototype.init=function(){};$c.prototype.parse=function(){return[]};function ad(){}p=ad.prototype;p.init=function(){};p.Af=function(){};p.Pd=function(){};p.remove=function(){};p.Zf=function(){};T("shaka.media.IClosedCaptionParser",ad);function bd(a){this.h=new Map;this.i=0;this.j=new $c;if(a=cd(a.toLowerCase()))this.j=a();this.g=new Zc;if(a=dd)this.g=a(),this.h.set(this.i,this.g)}p=bd.prototype;
p.init=function(a,b,c){b=b===void 0?!1:b;c=c===void 0?-1:c;if(c!=-1&&this.i!=c){b=c;var d=this.h.get(b);this.h.set(this.i,this.g);if(d)this.g=d;else{if(d=dd)this.g=d();this.h.set(b,this.g)}}else b||this.Pd();this.j.init(a);c!=-1&&(this.i=c)};p.Af=function(a){a=this.j.parse(a);a=u(a);for(var b=a.next();!b.done;b=a.next()){b=b.value;var c=Wb(b.packet);c.length>0&&this.g.extract(c,b.pts)}return this.g.decode()};p.Pd=function(){this.g.clear()};
p.remove=function(a){a=a===void 0?[]:a;a=new Set(a);for(var b=u(this.h.keys()),c=b.next();!c.done;c=b.next())if(c=c.value,!a.has(c)){var d=this.h.get(c);d&&d.clear();this.h.delete(c)}};p.Zf=function(){return this.g.getStreams()};function ed(a,b){gd.set(a,b)}function cd(a){return gd.get(a)}T("shaka.media.ClosedCaptionParser",bd);bd.findDecoder=function(){return dd};bd.unregisterDecoder=function(){dd=null};bd.registerDecoder=function(a){dd=a};bd.findParser=cd;bd.unregisterParser=function(a){gd.delete(a)};
bd.registerParser=ed;var gd=new Map,dd=null;function hd(){this.id="";this.regionAnchorY=this.regionAnchorX=this.viewportAnchorY=this.viewportAnchorX=0;this.height=this.width=100;this.viewportAnchorUnits=this.widthUnits=this.heightUnits=id;this.scroll=jd}T("shaka.text.CueRegion",hd);var id=1;hd.units={PX:0,PERCENTAGE:id,LINES:2};var jd="";hd.scrollMode={NONE:jd,UP:"up"};function kd(a){this.h=a||"";this.g=0}function ld(a){md(a,/[ \t]+/gm)}function md(a,b){b.lastIndex=a.g;b=b.exec(a.h);b=b==null?null:{position:b.index,length:b[0].length,results:b};if(a.g==a.h.length||b==null||b.position!=a.g)return null;a.g+=b.length;return b.results}function nd(a){return a.g==a.h.length?null:(a=md(a,/[^ \t\n]*/gm))?a[0]:null}
function rd(a){a=md(a,td);if(a==null)return null;var b=Number(a[2]),c=Number(a[3]);return b>59||c>59?null:(Number(a[6])||0)/1E3+c+b*60+(Number(a[1])||0)*3600}function ud(a){return a?rd(new kd(a)):null}var td=/(?:(\d{1,}):)?(\d{2}):(\d{2})((\.(\d{1,3})))?/g;function vd(){}function wd(a){function b(d){switch(typeof d){case "undefined":case "boolean":case "number":case "string":case "symbol":case "function":return d;default:if(!d||ArrayBuffer.isView(d))return d;if(c.has(d))return null;var e=Array.isArray(d);if(d.constructor!=Object&&!e)return null;c.add(d);var f=e?[]:{},g;for(g in d)f[g]=b(d[g]);e&&(f.length=d.length);return f}}var c=new WeakSet;return b(a)}function xd(a){var b={},c;for(c in a)b[c]=a[c];return b}
function yd(a){if(Array.isArray(a)){for(var b=[],c=0;c<a.length;c++){var d=c.toString(),e=a[c];e!==void 0&&(e=yd(e))&&b.push(d+":"+e)}a="["+b.join(",")+"]"}else if(typeof a=="function")a="";else if(a instanceof Object){c=Object.keys(a);c.sort();b=[];c=u(c);for(d=c.next();!d.done;d=c.next())e=d.value,d=JSON.stringify(e),e=a[e],e!==void 0&&(e=yd(e))&&b.push(d+":"+e);a="{"+b.join(",")+"}"}else a=JSON.stringify(a);return a}T("shaka.util.ObjectUtils",vd);vd.alphabeticalKeyOrderStringify=yd;
vd.shallowCloneObject=xd;vd.cloneObject=wd;/*
 @license
 tXml
 Copyright 2015 Tobias Nickel
 SPDX-License-Identifier: MIT
*/
function zd(a,b){var c=c===void 0?!1:c;a=sc(a);return Ad(a,b,c)}function Ad(a,b,c){a=Bd(a,c===void 0?!1:c);return!b&&a.length?a[0]:(a=a.find(function(d){return b.split(",").includes(d.tagName)}))?a:null}function Cd(a){return Dd.has(a)?Dd.get(a):""}
function Bd(a,b){function c(f,g){g=g===void 0?!1:g;for(var h=[];a[e];)if(a.charCodeAt(e)==60){if(a.charCodeAt(e+1)===47){g=e+2;e=a.indexOf(">",e);g=a.substring(g,e);var k=g.indexOf(f);if(k==-1){var l=f.indexOf(".");l>0&&(k=g.indexOf(f.substring(0,l)))}if(k==-1)throw f=a.substring(0,e).split("\n"),Error("Unexpected close tag\nLine: "+(f.length-1)+"\nColumn: "+(f[f.length-1].length+1)+"\nChar: "+a[e]);e+1&&(e+=1);break}else if(a.charCodeAt(e+1)===33){if(a.charCodeAt(e+2)==45){for(;e!==-1&&(a.charCodeAt(e)!==
62||a.charCodeAt(e-1)!=45||a.charCodeAt(e-2)!=45||e==-1);)e=a.indexOf(">",e+1);e===-1&&(e=a.length)}else if(a.charCodeAt(e+2)===91&&a.charCodeAt(e+8)===91&&a.substr(e+3,5).toLowerCase()==="cdata"){k=a.indexOf("]]\x3e",e);k==-1?(h.push(a.substr(e+9)),e=a.length):(h.push(a.substring(e+9,k)),e=k+3);continue}e++;continue}a:{l=g;e++;var m=d(),n={};for(k=[];a.charCodeAt(e)!==62&&a[e];){var q=a.charCodeAt(e);if(q>64&&q<91||q>96&&q<123){q=d();for(var r=a.charCodeAt(e);r&&r!==39&&r!==34&&!(r>64&&r<91||r>96&&
r<123)&&r!==62;)e++,r=a.charCodeAt(e);var t=e+1;e=a.indexOf(a[e],t);t=(" "+a.slice(t,e)).slice(1);if(r===39||r===34){if(e===-1){l={tagName:m,attributes:n,children:k,parent:null};if(b)for(m=0;m<k.length;m++)typeof k[m]!=="string"&&(k[m].parent=l);k=l;break a}}else t=null,e--;if(q.startsWith("xmlns:")){r=t;var v=q.split(":")[1];Dd.set(r,v);Ed.set(v,r)}m==="tt"&&q==="xml:space"&&t==="preserve"&&(l=!0);n[q]=t}e++}a.charCodeAt(e-1)!==47?(e++,k=c(m,l)):e++;l={tagName:m,attributes:n,children:k,parent:null};
m=k.length;for(n=0;n<m;n++)q=k[n],typeof q!=="string"?b&&(q.parent=l):n==m-1&&q=="\n"&&k.pop();k=l}h.push(k);if(typeof k==="string")break;k.tagName[0]==="?"&&k.children&&(h.push.apply(h,x(k.children)),k.children=[])}else k=e,e=a.indexOf("<",e)-1,e===-2&&(e=a.length),k=(" "+a.slice(k,e+1)).slice(1),g?k.length>0&&h.push(k):h.length&&k.length==1&&k[0]=="\n"?h.push(k):k.trim().length>0&&h.push(k),e++;return h}function d(){for(var f=e;"\r\n\t>/= ".indexOf(a[e])===-1&&a[e];)e++;return(" "+a.slice(f,e)).slice(1)}
var e=0;return c("")}function Fd(a){return typeof a==="string"}function Gd(a){var b=[];if(!a.children)return[];a=u(a.children);for(var c=a.next();!c.done;c=a.next())c=c.value,typeof c!=="string"&&b.push(c);return b}function Hd(a,b){var c=[];if(!a.children)return[];a=u(a.children);for(var d=a.next();!d.done;d=a.next())d=d.value,d.tagName===b&&c.push(d);return c}
function Id(a){if(typeof a==="string")return wc(a);a=a.children.reduce(function(b,c){return typeof c==="string"?b+c:b},"");return a===""?null:wc(a)}function Jd(a){if(!Array.from(a.children).every(function(b){return typeof b==="string"}))return null;(a=Id(a))&&(a=a.trim());return a}function Kd(a,b,c){c=c===void 0?[]:c;a.tagName===b&&c.push(a);if(a.children){a=u(a.children);for(var d=a.next();!d.done;d=a.next())Kd(d.value,b,c)}return c}function Ld(a,b){a=Hd(a,b);return a.length!=1?null:a[0]}
function Md(a,b,c){a=Nd(a,b,c);return a.length!=1?null:a[0]}function Od(a,b,c,d){d=d===void 0?null:d;var e=null;a=a.attributes[b];a!=null&&(e=c(a));return e==null?d:e}function Pd(a,b,c){b=Cd(b);return a.attributes[b+":"+c]||null}function Nd(a,b,c){var d=Cd(b);b=[];if(a.children)for(c=d?d+":"+c:c,a=u(a.children),d=a.next();!d.done;d=a.next())(d=d.value)&&d.tagName===c&&b.push(d);return b}function Qd(a,b,c){b=u(b);for(var d=b.next();!d.done;d=b.next())if(d=Pd(a,d.value,c))return d;return null}
function Rd(a){if(!a)return null;/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(a)&&(a+="Z");a=Date.parse(a);return isNaN(a)?null:a/1E3}function Sd(a){if(!a)return null;a=RegExp("^P(?:([0-9]*)Y)?(?:([0-9]*)M)?(?:([0-9]*)D)?(?:T(?:([0-9]*)H)?(?:([0-9]*)M)?(?:([0-9.]*)S)?)?$","i").exec(a);if(!a)return null;a=31536E3*Number(a[1]||null)+2592E3*Number(a[2]||null)+86400*Number(a[3]||null)+3600*Number(a[4]||null)+60*Number(a[5]||null)+Number(a[6]||null);return isFinite(a)?a:null}
function Ud(a){var b=/([0-9]+)-([0-9]+)/.exec(a);if(!b)return null;a=Number(b[1]);if(!isFinite(a))return null;b=Number(b[2]);return isFinite(b)?{start:a,end:b}:null}function Vd(a){a=Number(a);return a%1===0?a:null}function Wd(a){a=Number(a);return a%1===0&&a>0?a:null}function Xd(a){a=Number(a);return a%1===0&&a>=0?a:null}function Yd(a){a=Number(a);return isNaN(a)?null:a}function Zd(a){return a?a.toLowerCase()==="true":!1}
function $d(a){var b;var c=(b=a.match(/^(\d+)\/(\d+)$/))?Number(b[1])/Number(b[2]):Number(a);return isNaN(c)?null:c}
function ae(a){var b=[];a=wc(a).split(/\/+(?=(?:[^'"]*['"][^'"]*['"])*[^'"]*$)/);a=u(a);for(var c=a.next();!c.done;c=a.next()){c=c.value;var d=c.match(/^([\w]+)/);if(d){var e=c.match(/(@id='(.*?)')/),f=c.match(/(@t='(\d+)')/),g=c.match(/(@n='(\d+)')/),h=c.match(/\[(\d+)\]/);b.push({name:d[0],id:e?e[0].match(/'(.*?)'/)[0].replace(/'/gm,""):null,t:f?Number(f[0].match(/'(.*?)'/)[0].replace(/'/gm,"")):null,n:g?Number(g[0].match(/'(.*?)'/)[0].replace(/'/gm,"")):null,position:h?Number(h[1])-1:null,Dc:c.split("/@")[1]||
null})}else c.startsWith("@")&&b.length&&(b[b.length-1].Dc=c.slice(1))}return b}
function be(a,b){var c=ae(b.attributes.sel||"");if(c.length){var d=c[c.length-1],e=b.attributes.pos||null;c=d.position;c==null&&(d.t!==null&&(c=ce(a,"t",d.t)),d.n!==null&&(c=ce(a,"n",d.n)));c===null?c=e==="prepend"?0:a.length:e==="prepend"?--c:e==="after"&&++c;e=b.tagName;(d=d.Dc)&&a[c]?de(a[c],e,d,Jd(b)||""):(e!=="remove"&&e!=="replace"||a.splice(c,1),e!=="add"&&e!=="replace"||a.splice.apply(a,[c,0].concat(x(b.children))))}}
function ce(a,b,c){var d=0;a=u(a);for(var e=a.next();!e.done;e=a.next()){if(Number(e.value.attributes[b])===c)return d;d++}return null}function de(a,b,c,d){if(b==="remove")delete a.attributes[c];else if(b==="add"||b==="replace")a.attributes[c]=d}
function ee(a){var b="",c=a.tagName.split(":");c.length>0&&(b=c[0],b=Ed.has(b)?Ed.get(b):"");b=document.createElementNS(b,a.tagName);for(var d in a.attributes)b.setAttribute(d,a.attributes[d]);a=u(a.children);for(d=a.next();!d.done;d=a.next())d=d.value,c=void 0,typeof d=="string"?c=new Text(d):c=ee(d),b.appendChild(c);return b}
function fe(a){if(!a)return null;var b={tagName:a.tagName,attributes:xd(a.attributes),children:[],parent:null};a=u(a.children);for(var c=a.next();!c.done;c=a.next())c=c.value,typeof c==="string"?b.children.push(c):(c=fe(c),c.parent=b,b.children.push(c));return b}var Dd=new Map,Ed=new Map;function ge(a,b,c){this.startTime=a;this.endTime=b;this.payload=c;this.region=new hd;this.position=null;this.positionAlign=he;this.size=0;this.textAlign=ie;this.direction=je;this.writingMode=ke;this.lineInterpretation=le;this.line=null;this.lineHeight="";this.lineAlign=me;this.displayAlign=ne;this.fontSize=this.border=this.backgroundImage=this.backgroundColor=this.color="";this.fontWeight=oe;this.fontStyle=pe;this.linePadding=this.letterSpacing=this.fontFamily="";this.opacity=1;this.textCombineUpright=
"";this.textDecoration=[];this.textStrokeWidth=this.textStrokeColor=this.textShadow="";this.wrapLine=!0;this.id="";this.nestedCues=[];this.lineBreak=this.isContainer=!1;this.rubyTag=null;this.cellResolution={columns:32,rows:15}}function qe(a,b){a=new ge(a,b,"");a.lineBreak=!0;return a}ge.prototype.clone=function(){var a=new ge(0,0,""),b;for(b in this)a[b]=this[b],Array.isArray(a[b])&&(a[b]=a[b].slice());return a};
function re(a,b){if(a.payload!=b.payload||!(Math.abs(a.startTime-b.startTime)<.001&&Math.abs(a.endTime-b.endTime)<.001))return!1;for(var c in a)if(c!="startTime"&&c!="endTime"&&c!="payload")if(c=="nestedCues"){if(!ib(a.nestedCues,b.nestedCues,re))return!1}else if(c=="region"||c=="cellResolution")for(var d in a[c]){if(a[c][d]!=b[c][d])return!1}else if(Array.isArray(a[c])){if(!ib(a[c],b[c]))return!1}else if(a[c]!=b[c])return!1;return!0}
function se(a,b){b=b===void 0?new Map:b;var c=a.payload;if(c.includes("<")){b.size===0&&ve(b);var d=c;c=[];for(var e=-1,f=0;f<d.length;f++)d[f]==="<"?e=f+1:d[f]===">"&&e>0&&(e=d.substr(e,f-e),e.match(we)&&c.push(e),e=-1);c=u(c);for(f=c.next();!f.done;f=c.next())f=f.value,d=d.replace("<"+f+">",'<div time="'+f+'">'),d+="</div>";a:{f=d;e=[];var g=-1;c="";d=!1;for(var h=0;h<f.length;h++)if(f[h]==="/"){var k=f.indexOf(">",h);if(k===-1){c=f;break a}if((k=f.substring(h+1,k))&&k=="v"){d=!0;var l=null;e.length&&
(l=e[e.length-1]);if(l){if(l===k)c+="/"+k+">";else{if(!l.startsWith("v")){c+=f[h];continue}c+="/"+l+">"}h+=k.length+1}else c+=f[h]}else c+=f[h]}else f[h]==="<"?(g=h+1,f[g]!="v"&&(g=-1)):f[h]===">"&&g>0&&(e.push(f.substr(g,h-g)),g=-1),c+=f[h];f=u(e);for(e=f.next();!e.done;e=f.next())e=e.value,g=e.replace(" ",".voice-"),c=c.replace("<"+e+">","<"+g+">"),c=c.replace("</"+e+">","</"+g+">"),d||(c+="</"+g+">")}c=xe(c);a.payload="";d="<span>"+c.replace(/\n/g,"<br />")+"</span>";try{var m=Ad(d,"span")}catch(n){}if(m)if(m=
m.children,m.length!=1||m[0].tagName)for(m=u(m),c=m.next();!c.done;c=m.next())ye(c.value,a,b);else a.payload=wc(c);else a.payload=wc(c)}else a.payload=wc(c)}function ve(a){for(var b=u(Object.entries(ze)),c=b.next();!c.done;c=b.next()){var d=u(c.value);c=d.next().value;d=d.next().value;var e=new ge(0,0,"");e.color=d;a.set("."+c,e)}b=u(Object.entries(Ae));for(c=b.next();!c.done;c=b.next())d=u(c.value),c=d.next().value,d=d.next().value,e=new ge(0,0,""),e.backgroundColor=d,a.set("."+c,e)}
function xe(a){var b={"< ":""," >":" &gt;"},c=/(< +>|<\s|\s>)/g,d=RegExp(c.source);return a&&d.test(a)?a.replace(c,function(e){return b[e]||""}):a||""}
function ye(a,b,c){var d=b.clone();d.nestedCues=[];d.payload="";d.rubyTag="";d.line=null;d.region=new hd;d.position=null;d.size=0;d.textAlign=ie;if(a.tagName)for(var e=u(a.tagName.split(/(?=[ .])+/g)),f=e.next();!f.done;f=e.next()){var g=f=f.value;if(g.startsWith(".voice-")){var h=g.split("-").pop();g='v[voice="'+h+'"]';c.has(g)||(g="v[voice="+h+"]")}c.has(g)&&(h=d,g=c.get(g))&&(h.backgroundColor=Be(g.backgroundColor,h.backgroundColor),h.color=Be(g.color,h.color),h.fontFamily=Be(g.fontFamily,h.fontFamily),
h.fontSize=Be(g.fontSize,h.fontSize),h.textShadow=Be(g.textShadow,h.textShadow),h.fontWeight=g.fontWeight,h.fontStyle=g.fontStyle,h.opacity=g.opacity,h.rubyTag=g.rubyTag,h.textCombineUpright=g.textCombineUpright,h.wrapLine=g.wrapLine);switch(f){case "br":d=qe(d.startTime,d.endTime);b.nestedCues.push(d);return;case "b":d.fontWeight=Ce;break;case "i":d.fontStyle=De;break;case "u":d.textDecoration.push(Ee);break;case "font":if(f=a.attributes.color)d.color=f;break;case "div":f=a.attributes.time;if(!f)break;
if(f=ud(f))d.startTime=f;break;case "ruby":case "rp":case "rt":d.rubyTag=f}}e=a.children;if(Fd(a)||e.length==1&&Fd(e[0]))for(c=Id(a).split("\n"),a=!0,c=u(c),e=c.next();!e.done;e=c.next())e=e.value,a||(a=qe(d.startTime,d.endTime),b.nestedCues.push(a)),e.length>0&&(a=d.clone(),a.payload=wc(e),b.nestedCues.push(a)),a=!1;else for(b.nestedCues.push(d),b=u(e),a=b.next();!a.done;a=b.next())ye(a.value,d,c)}function Be(a,b){return a&&a.length>0?a:b}T("shaka.text.Cue",ge);ge.parseCuePayload=se;ge.equal=re;
ge.prototype.clone=ge.prototype.clone;var he="auto";ge.positionAlign={LEFT:"line-left",RIGHT:"line-right",CENTER:"center",AUTO:he};var ie="center",Fe={LEFT:"left",RIGHT:"right",CENTER:ie,START:"start",END:"end"};ge.textAlign=Fe;var ne="after",Ge={BEFORE:"before",CENTER:"center",AFTER:ne};ge.displayAlign=Ge;var je="ltr";ge.direction={HORIZONTAL_LEFT_TO_RIGHT:je,HORIZONTAL_RIGHT_TO_LEFT:"rtl"};var ke="horizontal-tb";ge.writingMode={HORIZONTAL_TOP_TO_BOTTOM:ke,VERTICAL_LEFT_TO_RIGHT:"vertical-lr",VERTICAL_RIGHT_TO_LEFT:"vertical-rl"};
var le=0;ge.lineInterpretation={LINE_NUMBER:le,PERCENTAGE:1};var me="start",He={CENTER:"center",START:me,END:"end"};ge.lineAlign=He;var ze={white:"white",lime:"lime",cyan:"cyan",red:"red",yellow:"yellow",magenta:"magenta",blue:"blue",black:"black"};ge.defaultTextColor=ze;var Ae={bg_white:"white",bg_lime:"lime",bg_cyan:"cyan",bg_red:"red",bg_yellow:"yellow",bg_magenta:"magenta",bg_blue:"blue",bg_black:"black"};ge.defaultTextBackgroundColor=Ae;var oe=400,Ce=700;ge.fontWeight={NORMAL:oe,BOLD:Ce};
var pe="normal",De="italic",Ie={NORMAL:pe,ITALIC:De,OBLIQUE:"oblique"};ge.fontStyle=Ie;var Ee="underline";ge.textDecoration={UNDERLINE:Ee,LINE_THROUGH:"lineThrough",OVERLINE:"overline"};var we=/(?:(\d{1,}):)?(\d{2}):(\d{2})\.(\d{2,3})/g;function Je(){}Je.prototype.destroy=function(){};function Ke(a,b,c){Le.set(a.toLowerCase().split(";")[0]+"-"+c,{priority:c,Bf:b})}function Me(a,b){for(var c=a.toLowerCase().split(";")[0],d=u([Ne,Oe,Pe,Qe]),e=d.next();!e.done;e=d.next())if(e=Le.get(c+"-"+e.value)){var f=e.Bf(),g=f.isSupported(a,b);f.destroy();if(g)return e.Bf}return null}T("shaka.transmuxer.TransmuxerEngine",Je);Je.findTransmuxer=Me;Je.unregisterTransmuxer=function(a,b){Le.delete(a.toLowerCase().split(";")[0]+"-"+b)};
Je.registerTransmuxer=Ke;Je.prototype.destroy=Je.prototype.destroy;var Le=new Map,Qe=1,Pe=2,Oe=3,Ne=4;Je.PluginPriority={FALLBACK:Qe,PREFERRED_SECONDARY:Pe,PREFERRED:Oe,APPLICATION:Ne};function Re(){}function Se(a,b){var c=a;b&&!Te.includes(a)&&(c+='; codecs="'+b+'"');return c}function Ue(a,b){b&&(a+='; codecs="'+b+'"');return a}function Ve(a,b,c){var d=Se(a,b);b=Ue(a,b);Me(b)?(a=Me(b))?(a=a(),c=a.convertCodecs(c,b),a.destroy()):c=b:c=a!="video/mp2t"&&c=="audio"?d.replace("video","audio"):d;return c}function Xe(a){return a.split(";")[0].split("/")[1]}
function Ye(a){var b=Ze(a);a=b[0].toLowerCase();b=b[1].toLowerCase();switch(!0){case a==="mp4a"&&b==="69":case a==="mp4a"&&b==="6b":case a==="mp4a"&&b==="40.34":return"mp3";case a==="mp4a"&&b==="66":case a==="mp4a"&&b==="67":case a==="mp4a"&&b==="68":case a==="mp4a"&&b==="40.2":case a==="mp4a"&&b==="40.02":case a==="mp4a"&&b==="40.5":case a==="mp4a"&&b==="40.05":case a==="mp4a"&&b==="40.29":case a==="mp4a"&&b==="40.42":return"aac";case a==="mp4a"&&b==="a5":case a==="ac3":case a==="ac-3":return"ac-3";
case a==="mp4a"&&b==="a6":case a==="eac3":case a==="ec-3":return"ec-3";case a==="ac-4":return"ac-4";case a==="mp4a"&&b==="b2":return"dtsx";case a==="mp4a"&&b==="a9":return"dtsc";case a==="vp09":case a==="vp9":return"vp9";case a==="avc1":case a==="avc3":return"avc";case a==="hvc1":case a==="hev1":return"hevc";case a==="vvc1":case a==="vvi1":return"vvc";case a==="dvh1":case a==="dvhe":return b&&b.startsWith("05")?"dovi-p5":"dovi-hevc";case a==="dvav":case a==="dva1":return"dovi-avc";case a==="dav1":return"dovi-av1";
case a==="dvc1":case a==="dvi1":return"dovi-vvc";case a==="lvc1":return"lcevc"}return a}function $e(a){var b=[];a=u(a.split(","));for(var c=a.next();!c.done;c=a.next())c=Ze(c.value),b.push(c[0]);return b.sort().join(",")}function af(a){return a.split(";")[0]}function bf(a){a=a.split(/ *; */);a.shift();return(a=a.find(function(b){return b.startsWith("codecs=")}))?a.split("=")[1].replace(/^"|"$/g,""):""}function cf(a){return a==="application/x-mpegurl"||a==="application/vnd.apple.mpegurl"}
function Ze(a){a=a.split(".");var b=a[0];a.shift();return[b,a.join(".")]}T("shaka.util.MimeUtils",Re);Re.getFullTypeWithAllCodecs=Ue;Re.getFullType=Se;(new Map).set("codecs","codecs").set("frameRate","framerate").set("bandwidth","bitrate").set("width","width").set("height","height").set("channelsCount","channels");var Te=["audio/aac","audio/ac3","audio/ec3","audio/mpeg"];function df(a){this.i=null;this.l=a;this.C=!1;this.m=this.u=0;this.o=Infinity;this.h=this.g=null;this.F="";this.B=function(){};this.j=new Map}function ef(a,b){ff.set(a,b)}function gf(a){return ff.get(a)}function hf(a){return ff.has(a)?!0:a=="application/cea-608"||a=="application/cea-708"?!!dd:!1}df.prototype.destroy=function(){this.l=this.i=null;this.j.clear();return Promise.resolve()};
function jf(a,b,c,d,e){var f,g,h,k,l,m,n;return O(function(q){if(q.g==1)return G(q,Promise.resolve(),2);if(!a.i||!a.l)return q.return();if(c==null||d==null)return a.i.parseInit(Wb(b)),q.return();f=a.C?c:a.u;g={periodStart:a.u,segmentStart:c,segmentEnd:d,vttOffset:f};h=a.i.parseMedia(Wb(b),g,e,[]);k=u(h);for(l=k.next();!l.done;l=k.next())m=l.value,a.B(m,e||null,g);n=h.filter(function(r){return r.startTime>=a.m&&r.startTime<a.o});a.l.append(n);a.g==null&&(a.g=Math.max(c,a.m));a.h=Math.min(d,a.o);H(q)})}
df.prototype.remove=function(a,b,c){c=c===void 0?!1:c;var d=this;return O(function(e){if(e.g==1)return G(e,Promise.resolve(),2);if(a>=b)return e.return();c&&kf(d,a,b);d.l&&d.l.remove(a,b)&&d.g!=null&&(b<=d.g||a>=d.h||(a<=d.g&&b>=d.h?d.g=d.h=null:a<=d.g&&b<d.h?d.g=b:a>d.g&&b>=d.h&&(d.h=a)),lf(d));H(e)})};function mf(a,b,c){a.m=b;a.o=c}function nf(a,b,c){a.F=b;if(b=a.j.get(b))b=b.filter(function(d){return d.endTime<=c}),b.length&&a.l.append(b)}
function of(a,b,c){b.startTime+=c;b.endTime+=c;b=u(b.nestedCues);for(var d=b.next();!d.done;d=b.next())of(a,d.value,c)}
function pf(a,b,c){var d=new Map;b=u(b);for(var e=b.next();!e.done;e=b.next()){var f=e.value;e=f.stream;f=f.cue;d.has(e)||d.set(e,[]);of(a,f,c);f.startTime>=a.m&&f.startTime<a.o&&(d.get(e).push(f),e==a.F&&a.l.append([f]))}c=u(d.keys());for(b=c.next();!b.done;b=c.next())for(b=b.value,a.j.has(b)||a.j.set(b,[]),e=u(d.get(b)),f=e.next();!f.done;f=e.next())f=f.value,a.j.get(b).push(f);lf(a)}
function kf(a,b,c){for(var d=u(a.j.keys()),e=d.next();!e.done;e=d.next()){e=e.value;var f=a.j.get(e);f=f.filter(function(g){return g.startTime<b||g.endTime>=c});a.j.set(e,f)}}
function lf(a){for(var b=Infinity,c=-Infinity,d=u(a.j.values()),e=d.next();!e.done;e=d.next()){e=u(e.value);for(var f=e.next();!f.done;f=e.next())f=f.value,b=Math.min(b,f.startTime),c=Math.max(c,f.endTime)}b!==Infinity&&c!==-Infinity&&(a.g=a.g==null?Math.max(b,a.m):Math.min(a.g,Math.max(b,a.m)),a.h=Math.max(a.h,Math.min(c,a.o)))}T("shaka.text.TextEngine",df);df.prototype.destroy=df.prototype.destroy;df.findParser=gf;df.unregisterParser=function(a){ff.delete(a)};df.registerParser=ef;var ff=new Map;function qf(a){this.h=a;this.g=null}qf.prototype.ka=function(a){var b=this;this.stop();var c=!0,d=null;this.g=function(){window.clearTimeout(d);c=!1};d=window.setTimeout(function(){c&&b.h()},a*1E3);return this};qf.prototype.stop=function(){this.g&&(this.g(),this.g=null)};function rf(a){this.h=a;this.g=null}rf.prototype.Jb=function(){this.stop();this.h();return this};rf.prototype.ka=function(a){var b=this;this.stop();this.g=(new qf(function(){b.h()})).ka(a);return this};rf.prototype.Ea=function(a){var b=this;this.stop();this.g=(new qf(function(){b.g.ka(a);b.h()})).ka(a);return this};rf.prototype.stop=function(){this.g&&(this.g.stop(),this.g=null)};T("shaka.util.Timer",rf);rf.prototype.stop=rf.prototype.stop;rf.prototype.tickEvery=rf.prototype.Ea;
rf.prototype.tickAfter=rf.prototype.ka;rf.prototype.tickNow=rf.prototype.Jb;function sf(a,b){return a.concat(b)}function tf(){}function uf(a){return a!=null}function vf(a,b){return Promise.race([b,new Promise(function(c,d){(new rf(d)).ka(a)})])};function wf(){}function xf(a,b){a=yf(a);b=yf(b);return a.split("-")[0]==b.split("-")[0]}function zf(a,b){a=yf(a);b=yf(b);a=a.split("-");b=b.split("-");return a[0]==b[0]&&a.length==1&&b.length==2}function Af(a,b){a=yf(a);b=yf(b);a=a.split("-");b=b.split("-");return a.length==2&&b.length==2&&a[0]==b[0]}
function yf(a){a=u(a.split("-x-"));var b=a.next().value;b=b===void 0?"":b;a=a.next().value;a=a===void 0?"":a;var c=u(b.split("-"));b=c.next().value;b=b===void 0?"":b;c=c.next().value;c=c===void 0?"":c;a=a?"x-"+a:"";b=b.toLowerCase();b=Bf.get(b)||b;c=c.toUpperCase();return(c?b+"-"+c:b)+(a?"-"+a:"")}function Cf(a,b){a=yf(a);b=yf(b);return b==a?4:zf(b,a)?3:Af(b,a)?2:zf(a,b)?1:0}function Df(a){var b=a.indexOf("-");a=b>=0?a.substring(0,b):a;a=a.toLowerCase();return a=Bf.get(a)||a}
function Ef(a){return a.language?yf(a.language):a.audio&&a.audio.language?yf(a.audio.language):a.video&&a.video.language?yf(a.video.language):"und"}
function Ff(a,b){a=yf(a);var c=new Set;b=u(b);for(var d=b.next();!d.done;d=b.next())c.add(yf(d.value));b=u(c);for(d=b.next();!d.done;d=b.next())if(d=d.value,d==a)return d;b=u(c);for(d=b.next();!d.done;d=b.next())if(d=d.value,zf(d,a))return d;b=u(c);for(d=b.next();!d.done;d=b.next())if(d=d.value,Af(d,a))return d;c=u(c);for(b=c.next();!b.done;b=c.next())if(b=b.value,zf(a,b))return b;return null}T("shaka.util.LanguageUtils",wf);wf.findClosestLocale=Ff;wf.getLocaleForVariant=Ef;
wf.getLocaleForText=function(a){return yf(a.language||"und")};wf.getBase=Df;wf.relatedness=Cf;wf.areSiblings=function(a,b){var c=Df(a),d=Df(b);return a!=c&&b!=d&&c==d};wf.normalize=yf;wf.isSiblingOf=Af;wf.isParentOf=zf;wf.areLanguageCompatible=xf;wf.areLocaleCompatible=function(a,b){a=yf(a);b=yf(b);return a==b};
var Bf=new Map([["aar","aa"],["abk","ab"],["afr","af"],["aka","ak"],["alb","sq"],["amh","am"],["ara","ar"],["arg","an"],["arm","hy"],["asm","as"],["ava","av"],["ave","ae"],["aym","ay"],["aze","az"],["bak","ba"],["bam","bm"],["baq","eu"],["bel","be"],["ben","bn"],["bih","bh"],["bis","bi"],["bod","bo"],["bos","bs"],["bre","br"],["bul","bg"],["bur","my"],["cat","ca"],["ces","cs"],["cha","ch"],["che","ce"],["chi","zh"],["chu","cu"],["chv","cv"],["cor","kw"],["cos","co"],["cre","cr"],["cym","cy"],["cze",
"cs"],["dan","da"],["deu","de"],["div","dv"],["dut","nl"],["dzo","dz"],["ell","el"],["eng","en"],["epo","eo"],["est","et"],["eus","eu"],["ewe","ee"],["fao","fo"],["fas","fa"],["fij","fj"],["fin","fi"],["fra","fr"],["fre","fr"],["fry","fy"],["ful","ff"],["geo","ka"],["ger","de"],["gla","gd"],["gle","ga"],["glg","gl"],["glv","gv"],["gre","el"],["grn","gn"],["guj","gu"],["hat","ht"],["hau","ha"],["heb","he"],["her","hz"],["hin","hi"],["hmo","ho"],["hrv","hr"],["hun","hu"],["hye","hy"],["ibo","ig"],["ice",
"is"],["ido","io"],["iii","ii"],["iku","iu"],["ile","ie"],["ina","ia"],["ind","id"],["ipk","ik"],["isl","is"],["ita","it"],["jav","jv"],["jpn","ja"],["kal","kl"],["kan","kn"],["kas","ks"],["kat","ka"],["kau","kr"],["kaz","kk"],["khm","km"],["kik","ki"],["kin","rw"],["kir","ky"],["kom","kv"],["kon","kg"],["kor","ko"],["kua","kj"],["kur","ku"],["lao","lo"],["lat","la"],["lav","lv"],["lim","li"],["lin","ln"],["lit","lt"],["ltz","lb"],["lub","lu"],["lug","lg"],["mac","mk"],["mah","mh"],["mal","ml"],["mao",
"mi"],["mar","mr"],["may","ms"],["mkd","mk"],["mlg","mg"],["mlt","mt"],["mon","mn"],["mri","mi"],["msa","ms"],["mya","my"],["nau","na"],["nav","nv"],["nbl","nr"],["nde","nd"],["ndo","ng"],["nep","ne"],["nld","nl"],["nno","nn"],["nob","nb"],["nor","no"],["nya","ny"],["oci","oc"],["oji","oj"],["ori","or"],["orm","om"],["oss","os"],["pan","pa"],["per","fa"],["pli","pi"],["pol","pl"],["por","pt"],["pus","ps"],["que","qu"],["roh","rm"],["ron","ro"],["rum","ro"],["run","rn"],["rus","ru"],["sag","sg"],["san",
"sa"],["sin","si"],["slk","sk"],["slo","sk"],["slv","sl"],["sme","se"],["smo","sm"],["sna","sn"],["snd","sd"],["som","so"],["sot","st"],["spa","es"],["sqi","sq"],["srd","sc"],["srp","sr"],["ssw","ss"],["sun","su"],["swa","sw"],["swe","sv"],["tah","ty"],["tam","ta"],["tat","tt"],["tel","te"],["tgk","tg"],["tgl","tl"],["tha","th"],["tib","bo"],["tir","ti"],["ton","to"],["tsn","tn"],["tso","ts"],["tuk","tk"],["tur","tr"],["twi","tw"],["uig","ug"],["ukr","uk"],["urd","ur"],["uzb","uz"],["ven","ve"],["vie",
"vi"],["vol","vo"],["wel","cy"],["wln","wa"],["wol","wo"],["xho","xh"],["yid","yi"],["yor","yo"],["zha","za"],["zho","zh"],["zul","zu"]]);function Gf(){}
function Hf(a,b,c,d,e){if(e.length){var f=a.textStreams;e=u(e);for(var g=e.next(),h={};!g.done;h={Fh:void 0},g=e.next())if(h.Fh=g.value,g=f.filter(function(t){return function(v){return v.codecs.startsWith(t.Fh)||v.mimeType.startsWith(t.Fh)?!0:!1}}(h)),g.length){f=g;break}a.textStreams=f}f=a.variants;if(b.length||c.length)f=If(f,b,c);if(d.length){b=new jb;f=u(f);for(c=f.next();!c.done;c=f.next())c=c.value,b.push(String(c.video.width||0),c);var k=[];b.forEach(function(t,v){t=0;var w=[];v=u(v);for(var z=
v.next(),y={};!z.done;y={Xf:void 0},z=v.next())y.Xf=z.value,z=d.filter(function(A){return function(E){return A.Xf.decodingInfos[0][E]}}(y)).length,z>t?(t=z,w=[y.Xf]):z==t&&w.push(y.Xf);k.push.apply(k,x(w))});f=k}b=new Set;c=u(f);for(e=c.next();!e.done;e=c.next())e=e.value,e.video&&b.add(e.video);if(b.size){var l={vp8:1,avc:1,"dovi-avc":.95,vp9:.9,vp09:.9,hevc:.85,"dovi-hevc":.8,"dovi-p5":.75,av01:.7,"dovi-av1":.65,vvc:.6};e=Array.from(b).sort(function(t,v){return t.bandwidth&&v.bandwidth&&t.bandwidth!=
v.bandwidth?t.bandwidth-v.bandwidth:t.width!=v.width?t.width-v.width:t.codecs&&v.codecs?(t=Ye(t.codecs),v=Ye(v.codecs),(l[t]||1)-(l[v]||1)):0});var m=[];b=new Map;c=function(t){var v=[String(t.width||""),String(t.height||""),String(Math.round(t.frameRate||0)),t.hdr||"",t.fastSwitching];t.dependencyStream&&v.push(t.dependencyStream.baseOriginalId||"");t.roles&&v.push(t.roles.sort().join("_"));return v.join(";")};e=u(e);for(g=e.next();!g.done;g=e.next()){g=g.value;h=c(g);var n=b.get(h)||[];if(n.length){var q=
Ye(n[n.length-1].codecs),r=Ye(g.codecs);q==r&&(n.push(g),m.push(g.id))}else n.push(g),m.push(g.id);b.set(h,n)}a.variants=f.filter(function(t){return(t=t.video)&&!m.includes(t.id)?!1:!0})}else a.variants=f}
function If(a,b,c){b=u(b);for(var d=b.next(),e={};!d.done;e={lj:void 0},d=b.next())if(e.lj=d.value,d=a.filter(function(f){return function(g){return g.video&&g.video.codecs.startsWith(f.lj)}}(e)),d.length){a=d;break}c=u(c);b=c.next();for(d={};!b.done;d={Rh:void 0},b=c.next())if(d.Rh=b.value,b=a.filter(function(f){return function(g){return g.audio&&g.audio.codecs.startsWith(f.Rh)}}(d)),b.length){a=b;break}return a}function Jf(a,b,c){a.variants=a.variants.filter(function(d){return Kf(d,b,c)})}
function Kf(a,b,c){function d(g,h,k){return g>=h&&g<=k}if(a&&a.video&&a.video.width&&a.video.height){var e=a.video.width,f=a.video.height;f>e&&(f=u([f,e]),e=f.next().value,f=f.next().value);if(!d(e,b.minWidth,Math.min(b.maxWidth,c.width))||!d(f,b.minHeight,Math.min(b.maxHeight,c.height))||!d(e*f,b.minPixels,b.maxPixels))return!1}return a&&a.video&&a.video.frameRate&&!d(a.video.frameRate,b.minFrameRate,b.maxFrameRate)||a&&a.audio&&a.audio.channelsCount&&!d(a.audio.channelsCount,b.minChannelsCount,
b.maxChannelsCount)||!d(a.bandwidth,b.minBandwidth,b.maxBandwidth)?!1:!0}function Lf(a,b,c,d){c=c===void 0?[]:c;d=d===void 0?{}:d;return O(function(e){if(e.g==1)return G(e,Mf(a,b,b.offlineSessionIds.length>0,c,d),2);Nf(b);return G(e,Of(b),0)})}
function Mf(a,b,c,d,e){var f,g;return O(function(h){if(h.g==1)return rb().$i()&&Pf(b.variants),G(h,Qf(b.variants,c,!1,d),2);f=null;a&&(g=a.g)&&(f=g.keySystem);b.variants=b.variants.filter(function(k){var l=Rf(k,f,e);if(!l){var m=[];k.audio&&m.push(Sf(k.audio));k.video&&m.push(Sf(k.video))}return l});H(h)})}
function Pf(a){var b=(new Map).set("dvav","avc3").set("dva1","avc1").set("dvhe","hev1").set("dvh1","hvc1").set("dvc1","vvc1").set("dvi1","vvi1"),c=new Set;a=u(a);for(var d=a.next();!d.done;d=a.next())d=d.value,d.video&&c.add(d.video);c=u(c);for(a=c.next();!a.done;a=c.next()){a=a.value;d=u(b);for(var e=d.next();!e.done;e=d.next()){var f=u(e.value);e=f.next().value;f=f.next().value;if(a.codecs.includes(e)){a.codecs=a.codecs.replace(e,f);break}}}}
function Rf(a,b,c){if(!a.decodingInfos.some(function(k){return!k.supported||b&&(k=k.keySystemAccess)&&(c[k.keySystem]||k.keySystem)!=b?!1:!0}))return!1;var d=rb(),e=d.Nb()==="Xbox";d=d.Oa()==="MOBILE"&&d.Ha()==="GECKO";var f=a.video,g=f&&f.width||0,h=f&&f.height||0;if(e&&f&&(g>1920||h>1080)&&(f.codecs.includes("avc1.")||f.codecs.includes("avc3."))||(e=f&&f.dependencyStream)&&!Rc(e))return!1;a=a.audio;return d&&a&&a.encrypted&&a.codecs.toLowerCase().includes("opus")||a&&a.dependencyStream?!1:!0}
function Tf(a,b){var c,d,e,f,g,h,k;return O(function(l){if(l.g==1){c=function(m,n){if(m){var q=xd(m);q.supported=m.supported&&n.supported;q.powerEfficient=m.powerEfficient&&n.powerEfficient;q.smooth=m.smooth&&n.smooth;n.keySystemAccess&&!q.keySystemAccess&&(q.keySystemAccess=n.keySystemAccess);return q}return n};d=null;e=[];f=u(b);g=f.next();for(h={};!g.done;h={cache:void 0,Se:void 0},g=f.next())k=g.value,h.Se=yd(k),h.cache=Yf,h.cache.has(h.Se)?d=c(d,h.cache.get(h.Se)):e.push(Zf(k).then(function(m){return function(n){var q=
null;n=u(n||[]);for(var r=n.next();!r.done;r=n.next())q=c(q,r.value);q&&(m.cache.set(m.Se,q),d=c(d,q))}}(h)));return G(l,Promise.all(e),2)}d&&a.decodingInfos.push(d);H(l)})}
function Zf(a){var b=[""];a.video&&(b=bf(a.video.contentType).split(","));var c=[""];a.audio&&(c=bf(a.audio.contentType).split(","));var d=[];b=u(b);for(var e=b.next();!e.done;e=b.next()){e=e.value;for(var f=u(c),g=f.next(),h={};!g.done;h={Qc:void 0},g=f.next())g=g.value,h.Qc=wd(a),a.video&&(h.Qc.video.contentType=Se(af(h.Qc.video.contentType),e)),a.audio&&(h.Qc.audio.contentType=Se(af(h.Qc.audio.contentType),g)),d.push(new Promise(function(k){return function(l,m){(rb().Oa()=="MOBILE"?vf(5,navigator.mediaCapabilities.decodingInfo(k.Qc)):
navigator.mediaCapabilities.decodingInfo(k.Qc)).then(function(n){l(n)}).catch(m)}}(h)))}return Promise.all(d).catch(function(){JSON.stringify(a);return null})}
function Qf(a,b,c,d){var e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D;return O(function(C){switch(C.g){case 1:if(e=a.some(function(B){return B.decodingInfos.length}))return C.return();f=u(d);g=f.next();h={};case 2:if(g.done){C.A(4);break}h.Ji=g.value;k=!1;l=u(a);m=l.next();case 5:if(m.done){C.A(7);break}n=m.value;q=$f(n,b,c).filter(function(B){return function(J){J=J[0];return(J.keySystemConfiguration&&J.keySystemConfiguration.keySystem)===B.Ji}}(h));r=u(q);t=r.next();case 8:if(t.done){C.A(10);break}v=t.value;
return G(C,Tf(n,v),9);case 9:t=r.next();C.A(8);break;case 10:n.decodingInfos.some(function(B){return B.supported})&&(k=!0);m=l.next();C.A(5);break;case 7:if(k)return C.return();h={Ji:void 0};g=f.next();C.A(2);break;case 4:w=u(a),z=w.next();case 12:if(z.done){C.A(0);break}y=z.value;A=$f(y,b,c).filter(function(B){B=B[0];B=B.keySystemConfiguration&&B.keySystemConfiguration.keySystem;return!B||!d.includes(B)});E=u(A);I=E.next();case 15:if(I.done){z=w.next();C.A(12);break}D=I.value;return G(C,Tf(y,D),
16);case 16:I=E.next(),C.A(15)}})}
function $f(a,b,c){var d=a.audio,e=a.video,f=[],g=[];if(e)for(var h=u(e.fullMimeTypes),k=h.next();!k.done;k=h.next()){k=k.value;var l=bf(k);if(l.includes(",")&&!d){var m=l.split(","),n=af(k);l=Hc("video",m);m=Hc("audio",m);m=ag(m,n);n=Ve(n,m,"audio");g.push({contentType:n,channels:2,bitrate:a.bandwidth||1,samplerate:1,spatialRendering:!1})}l=bg(l);k={contentType:Ve(af(k),l,"video"),width:e.width||64,height:e.height||64,bitrate:e.bandwidth||a.bandwidth||1,framerate:e.frameRate||30};if(e.hdr)switch(e.hdr){case "PQ":k.transferFunction=
"pq";break;case "HLG":k.transferFunction="hlg"}e.colorGamut&&(k.colorGamut=e.colorGamut);f.push(k)}if(d)for(h=u(d.fullMimeTypes),k=h.next();!k.done;k=h.next())l=k.value,k=af(l),l=ag(bf(l),k),k=Ve(k,l,"audio"),g.push({contentType:k,channels:d.channelsCount||2,bitrate:d.bandwidth||a.bandwidth||1,samplerate:d.audioSamplingRate||1,spatialRendering:d.spatialAudio});h=[];f.length==0&&f.push(null);g.length==0&&g.push(null);f=u(f);for(k=f.next();!k.done;k=f.next())for(k=k.value,l=u(g),n=l.next();!n.done;n=
l.next())n=n.value,m={type:c?"file":"media-source"},k&&(m.video=k),n&&(m.audio=n),h.push(m);g=(a.video?a.video.drmInfos:[]).concat(a.audio?a.audio.drmInfos:[]);if(!g.length)return[h];a=[];c=new Map;g=u(g);for(f=g.next();!f.done;f=g.next())f=f.value,c.get(f.keySystem)||c.set(f.keySystem,[]),c.get(f.keySystem).push(f);g=b?"required":"optional";b=b?["persistent-license"]:["temporary"];f=u(c.keys());for(k=f.next();!k.done;k=f.next()){k=k.value;n=c.get(k);l=new Map;n=u(n);for(m=n.next();!m.done;m=n.next()){m=
m.value;var q=m.videoRobustness+","+m.audioRobustness;l.get(q)||l.set(q,[]);l.get(q).push(m)}l=u(l.values());for(n=l.next();!n.done;n=l.next()){n=n.value;m=[];q=u(h);for(var r=q.next();!r.done;r=q.next()){r=Object.assign({},r.value);for(var t={keySystem:k,initDataType:"cenc",persistentState:g,distinctiveIdentifier:"optional",sessionTypes:b},v=u(n),w=v.next();!w.done;w=v.next()){w=w.value;if(w.initData&&w.initData.length){for(var z=new Set,y=u(w.initData),A=y.next();!A.done;A=y.next())z.add(A.value.initDataType);
t.initDataType=w.initData[0].initDataType}w.distinctiveIdentifierRequired&&(t.distinctiveIdentifier="required");w.persistentStateRequired&&(t.persistentState="required");w.sessionType&&(t.sessionTypes=[w.sessionType]);d&&(t.audio?(w.encryptionScheme&&(t.audio.encryptionScheme=t.audio.encryptionScheme||w.encryptionScheme),t.audio.robustness=t.audio.robustness||w.audioRobustness):(t.audio={robustness:w.audioRobustness},w.encryptionScheme&&(t.audio.encryptionScheme=w.encryptionScheme)),t.audio.robustness==
""&&delete t.audio.robustness);e&&(t.video?(w.encryptionScheme&&(t.video.encryptionScheme=t.video.encryptionScheme||w.encryptionScheme),t.video.robustness=t.video.robustness||w.videoRobustness):(t.video={robustness:w.videoRobustness},w.encryptionScheme&&(t.video.encryptionScheme=w.encryptionScheme)),t.video.robustness==""&&delete t.video.robustness)}r.keySystemConfiguration=t;m.push(r)}a.push(m)}}return a}
function ag(a,b){var c=rb();return a.toLowerCase()=="flac"?c.Ha()!="WEBKIT"?"flac":"fLaC":a.toLowerCase()==="opus"?c.Ha()!="WEBKIT"?"opus":Xe(b)=="mp4"?"Opus":"opus":a.toLowerCase()=="ac-3"&&c.se()?"ec-3":a}function bg(a){if(a.includes("avc1")){var b=a.split(".");if(b.length==3)return a=b.shift()+".",a+=parseInt(b.shift(),10).toString(16),a+=("000"+parseInt(b.shift(),10).toString(16)).slice(-4)}else if(a=="vp9")return"vp09.00.41.08";return a}
function Nf(a){a.textStreams=a.textStreams.filter(function(b){b=Se(b.mimeType,b.codecs);return hf(b)})}
function Of(a){var b,c,d,e,f,g,h,k;return O(function(l){switch(l.g){case 1:b=[],c=u(a.imageStreams),d=c.next();case 2:if(d.done){l.A(4);break}e=d.value;f=e.mimeType;f=="application/mp4"&&e.codecs=="mjpg"&&(f="image/jpg");if(gg.has(f)){l.A(5);break}g=hg.get(f);if(!g){gg.set(f,!1);l.A(5);break}return G(l,ig(g),7);case 7:h=l.h,gg.set(f,h);case 5:(k=gg.get(f))&&b.push(e);d=c.next();l.A(2);break;case 4:a.imageStreams=b,H(l)}})}
function ig(a){return new Promise(function(b){var c=new Image;c.src=a;"decode"in c?c.decode().then(function(){b(!0)}).catch(function(){b(!1)}):c.onload=c.onerror=function(){b(c.height===2)}})}
function jg(a){var b=a.audio,c=a.video,d=b?b.mimeType:null,e=c?c.mimeType:null,f=b?b.codecs:null,g=c?c.codecs:null,h=b?b.groupId:null,k=[];c&&k.push(c.mimeType);b&&k.push(b.mimeType);k=k[0]||null;var l=[];b&&l.push(b.kind);c&&l.push(c.kind);l=l[0]||null;var m=new Set;if(b)for(var n=u(b.roles),q=n.next();!q.done;q=n.next())m.add(q.value);if(c)for(n=u(c.roles),q=n.next();!q.done;q=n.next())m.add(q.value);a={id:a.id,active:!1,type:"variant",bandwidth:a.bandwidth,language:a.language,label:null,videoLabel:null,
kind:l,width:null,height:null,frameRate:null,pixelAspectRatio:null,hdr:null,colorGamut:null,videoLayout:null,mimeType:k,audioMimeType:d,videoMimeType:e,codecs:"",audioCodec:f,videoCodec:g,primary:a.primary,roles:Array.from(m),audioRoles:null,videoRoles:null,forced:!1,videoId:null,audioId:null,audioGroupId:h,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,tilesLayout:null,audioBandwidth:null,videoBandwidth:null,originalVideoId:null,originalAudioId:null,originalTextId:null,originalImageId:null,
accessibilityPurpose:null,originalLanguage:null};if(c){a.videoId=c.id;a.originalVideoId=c.originalId;a.width=c.width||null;a.height=c.height||null;a.frameRate=c.frameRate||null;a.pixelAspectRatio=c.pixelAspectRatio||null;a.videoBandwidth=c.bandwidth||null;a.hdr=c.hdr||null;a.colorGamut=c.colorGamut||null;a.videoLayout=c.videoLayout||null;a.videoRoles=c.roles;a.videoLabel=c.label;if(d=c.dependencyStream)a.width=d.width||a.width,a.height=d.height||a.height,a.videoCodec=d.codecs||a.videoCodec,a.pixelAspectRatio=
d.pixelAspectRatio||a.pixelAspectRatio,a.videoBandwidth&&d.bandwidth&&(a.videoBandwidth+=d.bandwidth);if(g.includes(",")){a.channelsCount=c.channelsCount;a.audioSamplingRate=c.audioSamplingRate;a.spatialAudio=c.spatialAudio;a.originalLanguage=c.originalLanguage;a.audioMimeType=e;e=g.split(",");try{a.videoCodec=Hc("video",e),a.audioCodec=Hc("audio",e)}catch(r){}}}b&&(a.audioId=b.id,a.originalAudioId=b.originalId,a.channelsCount=b.channelsCount,a.audioSamplingRate=b.audioSamplingRate,a.audioBandwidth=
b.bandwidth||null,a.spatialAudio=b.spatialAudio,a.label=b.label,a.audioRoles=b.roles,a.accessibilityPurpose=b.accessibilityPurpose,a.originalLanguage=b.originalLanguage,e=b.dependencyStream)&&(a.audioCodec=e.codecs||a.audioCodec,a.audioBandwidth&&e.bandwidth&&(a.audioBandwidth+=e.bandwidth));c&&!a.videoBandwidth&&(b?a.audioBandwidth&&(a.videoBandwidth=a.bandwidth-a.audioBandwidth):a.videoBandwidth=a.bandwidth);b&&!a.audioBandwidth&&(c?a.videoBandwidth&&(a.audioBandwidth=a.bandwidth-a.videoBandwidth):
a.audioBandwidth=a.bandwidth);b=[];a.videoCodec&&b.push(a.videoCodec);a.audioCodec&&b.push(a.audioCodec);a.codecs=b.join(", ");return a}function kg(a){return{id:a.id,active:!1,type:Kc,bandwidth:a.bandwidth||0,language:a.language,label:a.label,kind:a.kind||null,mimeType:a.mimeType,codecs:a.codecs||null,primary:a.primary,roles:a.roles,accessibilityPurpose:a.accessibilityPurpose,forced:a.forced,originalTextId:a.originalId,originalLanguage:a.originalLanguage}}
function lg(a){var b=a.width||null,c=a.height||null,d=null;a.segmentIndex&&(d=mg(a.segmentIndex));var e=a.tilesLayout;d&&(e=d.tilesLayout||e);e&&b!=null&&(b/=Number(e.split("x")[0]));e&&c!=null&&(c/=Number(e.split("x")[1]));return{id:a.id,type:"image",bandwidth:a.bandwidth||0,width:b,height:c,mimeType:a.mimeType,codecs:a.codecs||null,tilesLayout:e||null,originalImageId:a.originalId}}function ng(a){a.__shaka_id||(a.__shaka_id=og++);return a.__shaka_id}
function pg(a){var b={id:ng(a),active:a.mode!="disabled",type:Kc,bandwidth:0,language:yf(a.language||"und"),label:a.label,kind:a.kind,mimeType:null,codecs:null,primary:!1,roles:[],accessibilityPurpose:null,forced:a.kind=="forced",originalTextId:a.id,originalLanguage:a.language};a.kind=="captions"&&(b.mimeType="unknown");a.kind=="subtitles"&&(b.mimeType="text/vtt");a.kind&&(b.roles=[a.kind]);return b}
function qg(a,b){var c=a?a.language:null;c={id:ng(a||b),active:a?a.enabled:b.selected,type:"variant",bandwidth:0,language:yf(c||"und"),label:a?a.label:null,videoLabel:null,kind:a?a.kind:null,width:null,height:null,frameRate:null,pixelAspectRatio:null,hdr:null,colorGamut:null,videoLayout:null,mimeType:null,audioMimeType:null,videoMimeType:null,codecs:null,audioCodec:null,videoCodec:null,primary:a?a.kind=="main":!1,roles:[],forced:!1,audioRoles:null,videoRoles:null,videoId:null,audioId:null,audioGroupId:null,
channelsCount:null,audioSamplingRate:null,spatialAudio:!1,tilesLayout:null,audioBandwidth:null,videoBandwidth:null,originalVideoId:b?b.id:null,originalAudioId:a?a.id:null,originalTextId:null,originalImageId:null,accessibilityPurpose:null,originalLanguage:c};a&&a.kind&&(c.roles=[a.kind],c.audioRoles=[a.kind]);a&&a.configuration&&(a.configuration.codec&&(c.audioCodec=a.configuration.codec,c.codecs=c.audioCodec),a.configuration.bitrate&&(c.audioBandwidth=a.configuration.bitrate,c.bandwidth+=c.audioBandwidth),
a.configuration.sampleRate&&(c.audioSamplingRate=a.configuration.sampleRate),a.configuration.numberOfChannels&&(c.channelsCount=a.configuration.numberOfChannels));if(b&&b.configuration&&(b.configuration.codec&&(c.videoCodec=b.configuration.codec,c.codecs=c.codecs?c.codecs+(","+c.videoCodec):c.videoCodec),b.configuration.bitrate&&(c.videoBandwidth=b.configuration.bitrate,c.bandwidth+=c.videoBandwidth),b.configuration.framerate&&(c.frameRate=b.configuration.framerate),b.configuration.width&&(c.width=
b.configuration.width),b.configuration.height&&(c.height=b.configuration.height),b.configuration.colorSpace&&b.configuration.colorSpace.transfer))switch(b.configuration.colorSpace.transfer){case "pq":c.hdr="PQ";break;case "hlg":c.hdr="HLG";break;case "bt709":c.hdr="SDR"}return c}function rg(a){return a.allowedByApplication&&a.allowedByKeySystem&&a.disabledUntilTime==0}function sg(a){return a.filter(function(b){return rg(b)})}
function tg(a,b,c,d){var e=a,f=a.filter(function(k){return k.primary});f.length&&(e=f);var g=e.length?e[0].language:"";e=e.filter(function(k){return k.language==g});if(b){var h=Ff(yf(b),a.map(function(k){return k.language}));h&&(e=a.filter(function(k){return yf(k.language)==h}))}e=e.filter(function(k){return k.forced==d});if(c){if(a=ug(e,c),a.length)return a}else if(a=e.filter(function(k){return k.roles.length==0}),a.length)return a;a=e.map(function(k){return k.roles}).reduce(sf,[]);return a.length?
ug(e,a[0]):e}function ug(a,b){return a.filter(function(c){return c.roles.includes(b)})}function vg(a){var b=[];a.audio&&b.push(a.audio);a.video&&b.push(a.video);return b}
function wg(a,b){b.length&&(b=b.filter(function(c){return Ye(a.codecs)==Ye(c.codecs)}).sort(function(c,d){return c.bandwidth&&d.bandwidth&&c.bandwidth!=d.bandwidth?c.bandwidth-d.bandwidth:(c.width||0)-(d.width||0)}),a.trickModeVideo=b[0],b.length>1&&(b=b.find(function(c){return a.width==c.width&&a.height==c.height})))&&(a.trickModeVideo=b)}
function Sf(a){return a.type=="audio"?"type=audio codecs="+a.codecs+" bandwidth="+a.bandwidth+" channelsCount="+a.channelsCount+" audioSamplingRate="+a.audioSamplingRate:a.type=="video"?"type=video codecs="+a.codecs+" bandwidth="+a.bandwidth+" frameRate="+a.frameRate+" width="+a.width+" height="+a.height:"unexpected stream type"}
function xg(a,b,c){if(c.autoShowText==0)return!1;if(c.autoShowText==1)return!0;var d=yf(c.preferredTextLanguage);b=yf(b.language);if(c.autoShowText==2)return xf(b,d);if(c.autoShowText==3){if(!a)return!1;a=yf(a.language);return xf(b,d)&&!xf(a,b)}$a("Invalid autoShowText setting!");return!1}
function yg(a){var b={id:0,language:"und",disabledUntilTime:0,primary:!1,audio:null,video:null,bandwidth:100,allowedByApplication:!0,allowedByKeySystem:!0,decodingInfos:[]};a=u(a);for(var c=a.next();!c.done;c=a.next()){c=c.value;var d={id:0,originalId:null,groupId:null,createSegmentIndex:function(){return Promise.resolve()},segmentIndex:null,mimeType:c?af(c):"",codecs:c?bf(c):"",encrypted:!0,drmInfos:[],keyIds:new Set,language:"und",originalLanguage:null,label:null,type:"video",primary:!1,trickModeVideo:null,
dependencyStream:null,emsgSchemeIdUris:null,roles:[],forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,accessibilityPurpose:null,external:!1,fastSwitching:!1,fullMimeTypes:new Set,isAudioMuxedInVideo:!1,baseOriginalId:null};d.fullMimeTypes.add(Se(d.mimeType,d.codecs));c.startsWith("audio/")?(d.type="audio",b.audio=d):b.video=d}return b}T("shaka.util.StreamUtils",Gf);Gf.meetsRestrictions=Kf;
var Yf=new Map,og=0,gg=(new Map).set("image/svg+xml",!0).set("image/png",!0).set("image/jpeg",!0).set("image/jpg",!0),hg=(new Map).set("image/webp","data:image/webp;base64,UklGRjoAAABXRUJQVlA4IC4AAACyAgCdASoCAAIALmk0mk0iIiIiIgBoSygABc6WWgAA/veff/0PP8bA//LwYAAA").set("image/avif","data:image/avif;base64,AAAAIGZ0eXBhdmlmAAAAAGF2aWZtaWYxbWlhZk1BMUIAAADybWV0YQAAAAAAAAAoaGRscgAAAAAAAAAAcGljdAAAAAAAAAAAAAAAAGxpYmF2aWYAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAABGgAAAB0AAAAoaWluZgAAAAAAAQAAABppbmZlAgAAAAABAABhdjAxQ29sb3IAAAAAamlwcnAAAABLaXBjbwAAABRpc3BlAAAAAAAAAAIAAAACAAAAEHBpeGkAAAAAAwgICAAAAAxhdjFDgQ0MAAAAABNjb2xybmNseAACAAIAAYAAAAAXaXBtYQAAAAAAAAABAAEEAQKDBAAAACVtZGF0EgAKCBgANogQEAwgMg8f8D///8WfhwB8+ErK42A=");function zg(){var a=this;this.H=null;this.G=!1;this.u=new Xa;this.j=new kb;navigator.connection&&navigator.connection.addEventListener&&this.j.D(navigator.connection,"change",function(){a.g.useNetworkInformation&&navigator.onLine&&(a.u=new Xa,a.g&&a.u.configure(a.g.advanced),a.trySuggestStreams())});this.l=[];this.I=1;this.J=!1;this.h=this.o=this.g=this.B=null;this.m=new rf(function(){if(a.G&&(a.g.restrictToElementSize||a.g.restrictToScreenSize)){var b=a.chooseVariant();b&&a.H(b,a.g.clearBufferSwitch,
a.g.safeMarginSwitch)}});this.C=window;"documentPictureInPicture"in window&&this.j.D(window.documentPictureInPicture,"enter",function(){a.C=window.documentPictureInPicture.window;a.m&&a.m.Jb();a.j.Aa(a.C,"pagehide",function(){a.C=window;a.m&&a.m.Jb()})});this.F=this.i=null}p=zg.prototype;p.stop=function(){this.H=null;this.G=!1;this.l=[];this.I=1;this.o=this.B=null;this.h&&(this.h.disconnect(),this.h=null);this.m&&this.m.stop();this.F=this.i=null};
p.release=function(){this.stop();this.j.release();this.m=null};p.init=function(a){this.H=a};
p.chooseVariant=function(a){a=a===void 0?!1:a;var b=Infinity,c=Infinity;this.g.restrictToScreenSize&&(c=this.g.ignoreDevicePixelRatio?1:this.C.devicePixelRatio,b=this.C.screen.height*c,c*=this.C.screen.width);if(this.h&&this.g.restrictToElementSize){var d=this.g.ignoreDevicePixelRatio?1:this.C.devicePixelRatio,e=this.o.clientHeight,f=this.o.clientWidth;this.i&&document.pictureInPictureElement&&document.pictureInPictureElement==this.o&&(e=this.i.height,f=this.i.width);b=Math.min(b,e*d);c=Math.min(c,
f*d)}e=this.l.filter(function(l){return l&&!(l.audio&&l.audio.fastSwitching||l.video&&l.video.fastSwitching)});e.length||(e=this.l);d=e;a&&e.length!=this.l.length&&(d=this.l.filter(function(l){return l&&(l.audio&&l.audio.fastSwitching||l.video&&l.video.fastSwitching?!0:!1)}));a=Ag(this,this.g.restrictions,d,Infinity,Infinity);if(b!=Infinity||c!=Infinity){a=Bg(a);a=u(a);for(e=a.next();!e.done;e=a.next())if(e=e.value,e.height>=b&&e.width>=c){b=e.height;c=e.width;break}a=Ag(this,this.g.restrictions,
d,b,c)}b=this.getBandwidthEstimate();d.length&&!a.length&&(a=Ag(this,null,d,Infinity,Infinity),a=[a[0]]);c=a[0]||null;for(d=0;d<a.length;d++){e=a[d];var g=isNaN(this.I)?1:Math.abs(this.I);f=g*e.bandwidth/this.g.bandwidthDowngradeTarget;for(var h={bandwidth:Infinity},k=d+1;k<a.length;k++)if(e.bandwidth!=a[k].bandwidth){h=a[k];break}g=g*h.bandwidth/this.g.bandwidthUpgradeTarget;c&&e&&b>=f&&b<=g&&(c.bandwidth!=e.bandwidth||c.bandwidth==e.bandwidth&&c.video&&e.video&&(c.video.width<e.video.width||c.video.height<
e.video.height))&&(c=e)}this.B=Date.now();return c};p.enable=function(){this.G=!0;this.l.length&&this.trySuggestStreams()};p.disable=function(){this.G=!1};p.segmentDownloaded=function(a,b,c,d){var e=a;this.g.removeLatencyFromFirstPacketTime&&d&&d.packetNumber===1&&d.timeToFirstByte&&(e=a-d.timeToFirstByte);e>=this.g.cacheLoadThreshold&&this.u.sample(e,b);c&&this.B!=null&&this.G&&Cg(this)};p.trySuggestStreams=function(){this.G&&(this.B=Date.now(),Cg(this,!0))};
p.getBandwidthEstimate=function(){var a=this.g.defaultBandwidthEstimate;navigator.connection&&navigator.connection.downlink&&this.g.useNetworkInformation&&(a=navigator.connection.downlink*1E6);if(navigator.connection&&navigator.connection.downlink&&this.g.useNetworkInformation&&this.g.preferNetworkInformationBandwidth)return a;a=this.u.getBandwidthEstimate(a);return this.F?this.F.getBandwidthEstimate(a):a};p.setVariants=function(a){if(hb(a,this.l))return!1;this.l=a;return!0};
p.playbackRateChanged=function(a){this.I=a};p.setMediaElement=function(a){function b(){c.m.ka(Dg)}var c=this;this.o=a;this.h&&(this.h.disconnect(),this.h=null);this.o&&"ResizeObserver"in window&&(this.h=new ResizeObserver(b),this.h.observe(this.o));this.j.D(a,"enterpictureinpicture",function(d){d.pictureInPictureWindow&&(c.i=d.pictureInPictureWindow,c.j.D(c.i,"resize",b))});this.j.D(a,"leavepictureinpicture",function(){c.i&&c.j.Ma(c.i,"resize",b);c.i=null})};p.setCmsdManager=function(a){this.F=a};
p.configure=function(a){this.g=a;this.u&&this.g&&this.u.configure(this.g.advanced)};function Cg(a,b){if(b===void 0||!b){if(!a.J){b=a.u;if(!(b.g>=b.i))return;a.J=!0;a.B-=(a.g.switchInterval-a.g.minTimeToSwitch)*1E3}if(Date.now()-a.B<a.g.switchInterval*1E3)return}b=a.chooseVariant();a.getBandwidthEstimate();b&&a.H(b,a.g.clearBufferSwitch,a.g.safeMarginSwitch)}
function Ag(a,b,c,d,e){if(a.F){var f=a.F.ji();f&&(c=c.filter(function(g){return g.bandwidth&&f?g.bandwidth<=f:!0}))}b&&(c=c.filter(function(g){return Kf(g,b,{width:e,height:d})}));return c.sort(function(g,h){return g.bandwidth-h.bandwidth})}function Bg(a){var b=[];a=u(a);for(var c=a.next();!c.done;c=a.next())(c=c.value)&&(c=c.video)&&c.height&&c.width&&b.push({height:c.height,width:c.width});return b.sort(function(d,e){return d.width-e.width})}T("shaka.abr.SimpleAbrManager",zg);
zg.prototype.configure=zg.prototype.configure;zg.prototype.setCmsdManager=zg.prototype.setCmsdManager;zg.prototype.setMediaElement=zg.prototype.setMediaElement;zg.prototype.playbackRateChanged=zg.prototype.playbackRateChanged;zg.prototype.setVariants=zg.prototype.setVariants;zg.prototype.getBandwidthEstimate=zg.prototype.getBandwidthEstimate;zg.prototype.trySuggestStreams=zg.prototype.trySuggestStreams;zg.prototype.segmentDownloaded=zg.prototype.segmentDownloaded;zg.prototype.disable=zg.prototype.disable;
zg.prototype.enable=zg.prototype.enable;zg.prototype.chooseVariant=zg.prototype.chooseVariant;zg.prototype.init=zg.prototype.init;zg.prototype.release=zg.prototype.release;zg.prototype.stop=zg.prototype.stop;var Dg=1;function Eg(a,b){var c=Fg();this.l=a.maxAttempts==null?c.maxAttempts:a.maxAttempts;this.j=a.baseDelay==null?c.baseDelay:a.baseDelay;this.o=a.fuzzFactor==null?c.fuzzFactor:a.fuzzFactor;this.m=a.backoffFactor==null?c.backoffFactor:a.backoffFactor;this.g=0;this.h=this.j;if(this.i=b===void 0?!1:b)this.g=1}
function Gg(a){var b,c;return O(function(d){if(d.g==1){if(a.g>=a.l)if(a.i)a.g=1,a.h=a.j;else throw new U(2,7,1010);b=a.g;a.g++;if(b==0)return d.return();c=a.h*(1+(Math.random()*2-1)*a.o);return G(d,new Promise(function(e){(new rf(e)).ka(c/1E3)}),2)}a.h*=a.m;H(d)})}function Fg(){return{maxAttempts:2,baseDelay:1E3,backoffFactor:2,fuzzFactor:.5,timeout:3E4,stallTimeout:5E3,connectionTimeout:1E4}};function Hg(){var a,b,c=new Promise(function(d,e){a=d;b=e});c.resolve=a;c.reject=b;return c}Hg.prototype.resolve=function(){};Hg.prototype.reject=function(){};function Ig(a,b){this.promise=a;this.i=b;this.g=null}function Jg(a){return new Ig(Promise.reject(a),function(){return Promise.resolve()})}function Kg(){var a=Promise.reject(new U(2,7,7001));a.catch(function(){});return new Ig(a,function(){return Promise.resolve()})}function Lg(a){return new Ig(Promise.resolve(a),function(){return Promise.resolve()})}function Mg(a){return new Ig(a,function(){return a.catch(function(){})})}Ig.prototype.abort=function(){this.g||(this.g=this.i());return this.g};
function Ng(a){return new Ig(Promise.all(a.map(function(b){return b.promise})),function(){return Promise.all(a.map(function(b){return b.abort()}))})}Ig.prototype.finally=function(a){this.promise.then(function(){return a(!0)},function(){return a(!1)});return this};
Ig.prototype.Xa=function(a,b){function c(h){return function(k){if(e.g&&h)f.reject(g);else{var l=h?a:b;l?d=Og(l,k,f):(h?f.resolve:f.reject)(k)}}}function d(){f.reject(g);return e.abort()}var e=this,f=new Hg;f.catch(function(){});var g=new U(2,7,7001);this.promise.then(c(!0),c(!1));return new Ig(f,function(){return d()})};
function Og(a,b,c){try{var d=a(b);if(d&&d.promise&&d.abort)return c.resolve(d.promise),function(){return d.abort()};c.resolve(d);return function(){return Promise.resolve(d).then(function(){},function(){})}}catch(e){return c.reject(e),function(){return Promise.resolve()}}}da.Object.defineProperties(Ig.prototype,{aborted:{configurable:!0,enumerable:!0,get:function(){return this.g!==null}}});T("shaka.util.AbortableOperation",Ig);Ig.prototype.chain=Ig.prototype.Xa;Ig.prototype["finally"]=Ig.prototype.finally;
Ig.all=Ng;Ig.prototype.abort=Ig.prototype.abort;Ig.notAbortable=Mg;Ig.completed=Lg;Ig.aborted=Kg;Ig.failed=Jg;function V(a,b){if(b)if(b instanceof Map)for(var c=u(b.keys()),d=c.next();!d.done;d=c.next())d=d.value,Object.defineProperty(this,d,{value:b.get(d),writable:!0,enumerable:!0});else for(c in b)Object.defineProperty(this,c,{value:b[c],writable:!0,enumerable:!0});this.defaultPrevented=this.cancelable=this.bubbles=!1;this.timeStamp=window.performance&&window.performance.now?window.performance.now():Date.now();this.type=a;this.isTrusted=!1;this.target=this.currentTarget=null;this.g=!1}
function Pg(a){var b=new V(a.type),c;for(c in a)Object.defineProperty(b,c,{value:a[c],writable:!0,enumerable:!0});return b}V.prototype.preventDefault=function(){this.cancelable&&(this.defaultPrevented=!0)};V.prototype.stopImmediatePropagation=function(){this.g=!0};V.prototype.stopPropagation=function(){};T("shaka.util.FakeEvent",V);
var Qg={wl:"abrstatuschanged",xl:"adaptation",yl:"audiotrackchanged",zl:"audiotrackschanged",Al:"boundarycrossed",Bl:"buffering",Cl:"canupdatestarttime",Dl:"complete",El:"currentitemchanged",Fl:"downloadcompleted",Gl:"downloadfailed",Hl:"downloadheadersreceived",Il:"drmsessionupdate",Jl:"emsg",Pl:"itemsinserted",Ql:"itemsremoved",gm:"prft",Error:"error",Kl:"expirationupdated",Ll:"firstquartile",Ml:"gapjumped",Rl:"keystatuschanged",Ul:"loaded",Vl:"loading",Xl:"manifestparsed",Yl:"manifestupdated",
Zl:"mediaqualitychanged",$l:"mediasourcerecovered",am:"metadataadded",Metadata:"metadata",bm:"midpoint",dm:"nospatialvideoinfo",fm:"onstatechange",hm:"ratechange",lm:"segmentappended",nm:"sessiondata",om:"spatialvideoinfo",pm:"stalldetected",qm:"started",rm:"statechanged",sm:"streaming",tm:"textchanged",um:"texttrackvisibility",vm:"thirdquartile",wm:"timelineregionadded",xm:"timelineregionenter",ym:"timelineregionexit",zm:"trackschanged",Bm:"unloading",Dm:"variantchanged"};function Rg(){this.ab=new jb;this.Je=this}Rg.prototype.addEventListener=function(a,b){this.ab&&this.ab.push(a,b)};Rg.prototype.removeEventListener=function(a,b){this.ab&&this.ab.remove(a,b)};Rg.prototype.dispatchEvent=function(a){if(!this.ab)return!0;var b=this.ab.get(a.type)||[],c=this.ab.get("All");c&&(b=b.concat(c));b=u(b);for(c=b.next();!c.done;c=b.next()){c=c.value;a.target=this.Je;a.currentTarget=this.Je;try{c.handleEvent?c.handleEvent(a):c.call(this,a)}catch(d){}if(a.g)break}return a.defaultPrevented};
Rg.prototype.release=function(){this.ab=null};function Sg(){this.g=[]}function Tg(a,b){a.g.push(b.finally(function(){gb(a.g,b)}))}Sg.prototype.destroy=function(){for(var a=[],b=u(this.g),c=b.next();!c.done;c=b.next())c=c.value,c.promise.catch(function(){}),a.push(c.abort());this.g=[];return Promise.all(a)};function Ug(a,b,c,d,e,f,g){Rg.call(this);this.i=null;this.j=!1;this.u=new Sg;this.g=new Set;this.h=new Set;this.o=a||null;this.m=b||null;this.B=c||null;this.C=d||null;this.F=e||null;this.H=f||null;this.G=g||null;this.l=new Map}ma(Ug,Rg);p=Ug.prototype;p.configure=function(a){this.i=a};function Vg(a,b,c,d){d=d===void 0?!1:d;c=c||Wg;var e=Xg.get(a);(!e||c>=e.priority)&&Xg.set(a,{priority:c,Bf:b,Ik:d})}
function Yg(a,b){for(var c=u(a.g),d=c.next();!d.done;d=c.next())b.g.add(d.value);a=u(a.h);for(c=a.next();!c.done;c=a.next())b.h.add(c.value)}p.Lk=function(a){this.g.add(a)};p.kl=function(a){this.g.delete(a)};p.vj=function(){this.g.clear()};p.Mk=function(a){this.h.add(a)};p.ll=function(a){this.h.delete(a)};p.wj=function(){this.h.clear()};p.Wh=function(){this.l.clear()};
function Zg(a,b,c){return{uris:a,method:"GET",body:null,headers:{},allowCrossSiteCredentials:!1,retryParameters:b,licenseRequestType:null,sessionId:null,drmInfo:null,initData:null,initDataType:null,streamDataCallback:c===void 0?null:c}}p.destroy=function(){this.j=!0;this.g.clear();this.h.clear();this.l.clear();Rg.prototype.release.call(this);return this.u.destroy()};
p.request=function(a,b,c){var d=this,e=new $g;if(this.j){var f=Promise.reject(new U(2,7,7001));f.catch(function(){});return new ah(f,function(){return Promise.resolve()},e)}b.method=b.method||"GET";b.headers=b.headers||{};b.retryParameters=b.retryParameters?wd(b.retryParameters):Fg();b.uris=wd(b.uris);f=bh(this,a,b,c);var g=f.Xa(function(){return ch(d,a,b,c,new Eg(b.retryParameters,!1),0,null,e)}),h=g.Xa(function(q){return dh(d,a,q,c)}),k=Date.now(),l=0;f.promise.then(function(){l=Date.now()-k},function(){});
var m=0;g.promise.then(function(){m=Date.now()},function(){});var n=h.Xa(function(q){var r=Date.now()-m,t=q.response;t.timeMs+=l;t.timeMs+=r;q.jk||!d.o||t.fromCache||b.method=="HEAD"||a!=eh||d.o(t.timeMs,t.data.byteLength,fh(c),b,c);d.G&&d.G(a,t,c);return t},function(q){q&&(q.severity=2);throw q;});f=new ah(n.promise,function(){return n.abort()},e);Tg(this.u,f);return f};
function bh(a,b,c,d){function e(h){f=f.Xa(function(){c.body&&(c.body=Yb(c.body));return h(b,c,d)})}var f=Lg(void 0);a.F&&e(a.F);a=u(a.g);for(var g=a.next();!g.done;g=a.next())e(g.value);return f.Xa(void 0,function(h){if(h instanceof U&&h.code==7001)throw h;throw new U(2,1,1006,h);})}
function ch(a,b,c,d,e,f,g,h){a.i.forceHTTP&&(c.uris[f]=c.uris[f].replace("https://","http://"));a.i.forceHTTPS&&(c.uris[f]=c.uris[f].replace("http://","https://"));f>0&&a.H&&a.H(b,d,c.uris[f],c.uris[f-1]);var k=new Db(c.uris[f]),l=k.fc,m=!1;l||(l=location.protocol,l=l.slice(0,-1),Eb(k,l),c.uris[f]=k.toString());l=l.toLowerCase();var n=(l=Xg.get(l))?l.Bf:null;if(!n)return Jg(new U(2,1,1E3,k));var q=l.Ik;(k=a.l.get(k.Db))&&(c.headers["common-access-token"]=k);var r=null,t=null,v=!1,w=!1,z;return Mg(Gg(e)).Xa(function(){if(a.j)return Kg();
z=Date.now();var y=0;c.requestStartTime=Date.now();var A=n(c.uris[f],c,b,function(D,C,B){r&&r.stop();t&&t.ka(I/1E3);a.o&&b==eh&&(y++,c.packetNumber=y,a.o(D,C,fh(d),c,d),m=!0,h.g=B)},function(D){w=!0;c.timeToFirstByte=Date.now()-c.requestStartTime;a.m&&a.m(D,c,b)},{minBytesForProgressEvents:a.i.minBytesForProgressEvents});if(!q)return A;var E=c.retryParameters.connectionTimeout;E&&(r=new rf(function(){v=!0;A.abort()}),r.ka(E/1E3));var I=c.retryParameters.stallTimeout;I&&(t=new rf(function(){v=!0;A.abort()}));
return A}).Xa(function(y){r&&r.stop();t&&t.stop();y.timeMs==void 0&&(y.timeMs=Date.now()-z);var A=y.headers["common-access-token"];if(A){var E=new Db(y.uri);a.l.set(E.Db,A)}A={response:y,jk:m};!w&&a.m&&a.m(y.headers,c,b);a.B&&a.B(c,y);return A},function(y){r&&r.stop();t&&t.stop();if(a.C){var A=null,E=0;y instanceof U&&(A=y,y.code==1001&&(E=y.data[1]));a.C(c,A,E,v)}if(a.j)return Kg();v&&(y=new U(1,1,1003,c.uris[f],b));if(y instanceof U){if(y.code==7001)throw y;if(y.code==1010)throw g;if(y.severity==
1){A=(new Map).set("error",y);A=new V("retry",A);A.cancelable=!0;a.dispatchEvent(A);if(A.defaultPrevented)throw y;f=(f+1)%c.uris.length;return ch(a,b,c,d,e,f,y,h)}}throw y;})}
function dh(a,b,c,d){var e=Lg(void 0);a=u(a.h);for(var f=a.next(),g={};!f.done;g={Pi:void 0},f=a.next())g.Pi=f.value,e=e.Xa(function(h){return function(){var k=c.response;k.data&&(k.data=Yb(k.data));return(0,h.Pi)(b,k,d)}}(g));return e.Xa(function(){return c},function(h){var k=2;if(h instanceof U){if(h.code==7001)throw h;k=h.severity}throw new U(k,1,1007,h);})}function fh(a){if(a){var b=a.segment;a=a.stream;if(b&&a&&a.fastSwitching&&b.Xc)return!1}return!0}T("shaka.net.NetworkingEngine",Ug);
Ug.prototype.request=Ug.prototype.request;Ug.prototype.destroy=Ug.prototype.destroy;Ug.makeRequest=Zg;Ug.defaultRetryParameters=function(){return Fg()};Ug.prototype.clearCommonAccessTokenMap=Ug.prototype.Wh;Ug.prototype.clearAllResponseFilters=Ug.prototype.wj;Ug.prototype.unregisterResponseFilter=Ug.prototype.ll;Ug.prototype.registerResponseFilter=Ug.prototype.Mk;Ug.prototype.clearAllRequestFilters=Ug.prototype.vj;Ug.prototype.unregisterRequestFilter=Ug.prototype.kl;
Ug.prototype.registerRequestFilter=Ug.prototype.Lk;Ug.unregisterScheme=function(a){Xg.delete(a)};Ug.registerScheme=Vg;Ug.prototype.configure=Ug.prototype.configure;function $g(){this.g=0}Ug.NumBytesRemainingClass=$g;function ah(a,b,c){Ig.call(this,a,b);this.h=c}ma(ah,Ig);Ug.PendingRequest=ah;var eh=1;Ug.RequestType={MANIFEST:0,SEGMENT:eh,LICENSE:2,APP:3,TIMING:4,SERVER_CERTIFICATE:5,KEY:6,ADS:7,CONTENT_STEERING:8,CMCD:9};
Ug.AdvancedRequestType={INIT_SEGMENT:0,MEDIA_SEGMENT:1,MEDIA_PLAYLIST:2,MASTER_PLAYLIST:3,MPD:4,MSS:5,MPD_PATCH:6,MEDIATAILOR_SESSION_INFO:7,MEDIATAILOR_TRACKING_INFO:8,MEDIATAILOR_STATIC_RESOURCE:9,MEDIATAILOR_TRACKING_EVENT:10,INTERSTITIAL_ASSET_LIST:11,INTERSTITIAL_AD_URL:12};var Wg=3;Ug.PluginPriority={FALLBACK:1,PREFERRED:2,APPLICATION:Wg};var Xg=new Map;function gh(a){this.g=!1;this.h=new Hg;this.i=a}gh.prototype.destroy=function(){var a=this;if(this.g)return this.h;this.g=!0;return this.i().then(function(){a.h.resolve()},function(){a.h.resolve()})};function hh(a,b){if(a.g){if(b instanceof U&&b.code==7003)throw b;throw new U(2,7,7003,b);}};function ih(a,b){var c=[];a=u(a);for(var d=a.next();!d.done;d=a.next())c.push(b(d.value));return c}function jh(a,b){a=u(a);for(var c=a.next();!c.done;c=a.next())if(!b(c.value))return!1;return!0};function kh(a){for(var b=new Map,c=u(Object.keys(a)),d=c.next();!d.done;d=c.next())d=d.value,b.set(d,a[d]);return b}function lh(a){var b={};a.forEach(function(c,d){b[d]=c});return b};function mh(a,b){this.h=ac(a);this.i=b==nh;this.g=0}p=mh.prototype;p.Ia=function(){return this.g<this.h.byteLength};p.Pa=function(){return this.g};p.getLength=function(){return this.h.byteLength};p.Y=function(){try{var a=this.h.getUint8(this.g);this.g+=1;return a}catch(b){throw oh();}};p.Ca=function(){try{var a=this.h.getUint16(this.g,this.i);this.g+=2;return a}catch(b){throw oh();}};p.U=function(){try{var a=this.h.getUint32(this.g,this.i);this.g+=4;return a}catch(b){throw oh();}};
p.dh=function(){try{var a=this.h.getInt32(this.g,this.i);this.g+=4;return a}catch(b){throw oh();}};p.Ed=function(){try{if(this.i){var a=this.h.getUint32(this.g,!0);var b=this.h.getUint32(this.g+4,!0)}else b=this.h.getUint32(this.g,!1),a=this.h.getUint32(this.g+4,!1)}catch(c){throw oh();}if(b>2097151)throw new U(2,3,3001);this.g+=8;return b*4294967296+a};p.Tb=function(a,b){if(this.g+a>this.h.byteLength)throw oh();var c=Wb(this.h,this.g,a);this.g+=a;return b?new Uint8Array(c):c};
p.skip=function(a){if(this.g+a>this.h.byteLength)throw oh();this.g+=a};p.Qi=function(a){if(this.g<a)throw oh();this.g-=a};p.seek=function(a){if(a<0||a>this.h.byteLength)throw oh();this.g=a};p.Yc=function(){for(var a=this.g;this.Ia()&&this.h.getUint8(this.g)!=0;)this.g+=1;a=Wb(this.h,a,this.g-a);this.g+=1;return oc(a)};function oh(){return new U(2,3,3E3)}T("shaka.util.DataViewReader",mh);mh.prototype.readTerminatedString=mh.prototype.Yc;mh.prototype.seek=mh.prototype.seek;mh.prototype.rewind=mh.prototype.Qi;
mh.prototype.skip=mh.prototype.skip;mh.prototype.readBytes=mh.prototype.Tb;mh.prototype.readUint64=mh.prototype.Ed;mh.prototype.readInt32=mh.prototype.dh;mh.prototype.readUint32=mh.prototype.U;mh.prototype.readUint16=mh.prototype.Ca;mh.prototype.readUint8=mh.prototype.Y;mh.prototype.getLength=mh.prototype.getLength;mh.prototype.getPosition=mh.prototype.Pa;mh.prototype.hasMoreData=mh.prototype.Ia;var nh=1;mh.Endianness={BIG_ENDIAN:0,LITTLE_ENDIAN:nh};function ph(){this.i=new Map;this.h=new Map;this.g=!1}p=ph.prototype;p.box=function(a,b){a=qh(a);this.i.set(a,rh);this.h.set(a,b);return this};p.S=function(a,b){a=qh(a);this.i.set(a,sh);this.h.set(a,b);return this};p.stop=function(){this.g=!0};p.parse=function(a,b,c){a=new mh(a,0);for(this.g=!1;a.Ia()&&!this.g;)this.Bd(0,a,b,c)};
p.Bd=function(a,b,c,d){var e=b.Pa();if(d&&e+8>b.getLength())this.g=!0;else{var f=b.U(),g=b.U(),h=th(g),k=!1;switch(f){case 0:f=b.getLength()-e;break;case 1:if(d&&b.Pa()+8>b.getLength()){this.g=!0;return}f=b.Ed();k=!0}var l=this.h.get(g);if(l){var m=null,n=null;if(this.i.get(g)==sh){if(d&&b.Pa()+4>b.getLength()){this.g=!0;return}n=b.U();m=n>>>24;n&=16777215}g=e+f;c&&g>b.getLength()&&(g=b.getLength());d&&g>b.getLength()?this.g=!0:(g-=b.Pa(),b=g>0?b.Tb(g,!1):new Uint8Array(0),b=new mh(b,0),l({name:h,
parser:this,partialOkay:c||!1,stopOnPartial:d||!1,version:m,flags:n,reader:b,size:f,start:e+a,has64BitSize:k}))}else b.skip(Math.min(e+f-b.Pa(),b.getLength()-b.Pa()))}};function uh(a){for(var b=yh(a);a.reader.Ia()&&!a.parser.g;)a.parser.Bd(a.start+b,a.reader,a.partialOkay,a.stopOnPartial)}function zh(a){for(var b=yh(a),c=a.reader.U(),d=0;d<c&&(a.parser.Bd(a.start+b,a.reader,a.partialOkay,a.stopOnPartial),!a.parser.g);d++);}
function Ah(a){var b=yh(a);for(a.reader.skip(78);a.reader.Ia()&&!a.parser.g;)a.parser.Bd(a.start+b,a.reader,a.partialOkay,a.stopOnPartial)}function Bh(a){var b=yh(a);a.reader.skip(8);var c=a.reader.Ca();a.reader.skip(6);c==2?a.reader.skip(48):a.reader.skip(12);for(c==1&&a.reader.skip(16);a.reader.Ia()&&!a.parser.g;)a.parser.Bd(a.start+b,a.reader,a.partialOkay,a.stopOnPartial)}function Ch(a,b){return function(c){a(c.reader.Tb(c.reader.getLength()-c.reader.Pa(),b))}}
function qh(a){var b=0;a=u(a);for(var c=a.next();!c.done;c=a.next())b=b<<8|c.value.charCodeAt(0);return b}function th(a){return String.fromCharCode(a>>24&255,a>>16&255,a>>8&255,a&255)}function yh(a){return 8+(a.has64BitSize?8:0)+(a.flags!=null?4:0)}T("shaka.util.Mp4Parser",ph);ph.headerSize=yh;ph.typeToString=th;ph.allData=Ch;ph.audioSampleEntry=Bh;ph.visualSampleEntry=Ah;ph.sampleDescription=zh;ph.children=uh;ph.prototype.parseNext=ph.prototype.Bd;ph.prototype.parse=ph.prototype.parse;
ph.prototype.stop=ph.prototype.stop;ph.prototype.fullBox=ph.prototype.S;ph.prototype.box=ph.prototype.box;var rh=0,sh=1;function Dh(a){var b=this;this.g=[];this.h=[];this.data=[];(new ph).box("moov",uh).box("moof",uh).S("pssh",function(c){if(!(c.version>1)){var d=Wb(c.reader.h,-12,c.size);b.data.push(d);d=c.reader.Tb(16,!1);b.g.push(Cc(d));if(c.version>0){d=c.reader.U();for(var e=0;e<d;e++){var f=c.reader.Tb(16,!1);f=Cc(f);b.h.push(f)}}}}).parse(a)}
function Eh(a,b,c,d){var e=a.length,f=12+b.length+4+e;d>0&&(f+=4+16*c.size);var g=new Uint8Array(f),h=ac(g),k=0;h.setUint32(k,f);k+=4;h.setUint32(k,1886614376);k+=4;d<1?h.setUint32(k,0):h.setUint32(k,16777216);k+=4;g.set(b,k);k+=b.length;if(d>0)for(h.setUint32(k,c.size),k+=4,b=u(c),c=b.next();!c.done;c=b.next())c=Bc(c.value),g.set(c,k),k+=c.length;h.setUint32(k,e);g.set(a,k+4);return g};function Fh(a){var b=this;this.F=a;this.l=this.B=null;this.$=this.T=!1;this.J=0;this.g=null;this.o=new kb;this.i=new Map;this.X=[];this.C=new Map;this.K=!1;this.m=new Hg;this.h=null;this.u=function(c){c.severity==2&&b.m.reject(c);a.onError(c)};this.ba=new Map;this.ma=new Map;this.M=new rf(function(){return Gh(b)});this.R=!1;this.N=[];this.oa=!1;this.G=new rf(function(){Hh(b)});this.m.catch(function(){});this.j=new gh(function(){return Ih(b)});this.O=!1;this.H=this.I=null;this.V=function(){return!1}}
p=Fh.prototype;p.destroy=function(){return this.j.destroy()};function Ih(a){return O(function(b){switch(b.g){case 1:return a.o.release(),a.o=null,a.m.reject(),a.G.stop(),a.G=null,a.M.stop(),a.M=null,G(b,Mh(a),2);case 2:if(!a.l){b.A(3);break}sa(b,4);return G(b,a.l.setMediaKeys(null),6);case 6:ua(b,5);break;case 4:Aa(b);case 5:a.l=null;case 3:a.g=null,a.B=null,a.C=new Map,a.h=null,a.u=function(){},a.F=null,a.O=!1,a.I=null,H(b)}})}
p.configure=function(a,b){this.h=a;b&&(this.V=b);this.G&&this.T&&this.g&&this.G.Ea(this.h.updateExpirationTime)};function Nh(a,b,c){a.$=!0;a.C=new Map;a.R=c;return Oh(a,b,!1)}
function Ph(a,b,c,d){d=d===void 0?!0:d;a.C=new Map;c=u(c);for(var e=c.next();!e.done;e=c.next())a.C.set(e.value,{initData:null,initDataType:null});c=u(a.h.persistentSessionsMetadata);for(e=c.next();!e.done;e=c.next())e=e.value,a.C.set(e.sessionId,{initData:e.initData,initDataType:e.initDataType});a.R=a.C.size>0;return Oh(a,b,d)}
function Qh(a,b,c,d,e,f){var g,h,k,l,m;return O(function(n){if(n.g==1)return g=[],f.length&&g.push(f[0].contentType),e.length&&g.push(e[0].contentType),h=function(q){q=Fc(b,q,null);q.licenseServerUri=c;q.serverCertificate=d;q.persistentStateRequired=!0;q.sessionType="persistent-license";return q},k=yg(g),k.video&&(l=h(f[0].encryptionScheme||""),k.video.drmInfos.push(l)),k.audio&&(m=h(e[0].encryptionScheme||""),k.audio.drmInfos.push(m)),G(n,Qf([k],!0,a.O,[]),2);hh(a.j);return n.return(Rh(a,[k]))})}
function Oh(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E;return O(function(I){if(I.g==1){Sh(a.h.clearKeys,b);d=b.some(function(D){return D.video&&D.video.drmInfos.length||D.audio&&D.audio.drmInfos.length?!0:!1});e=kh(a.h.servers);f=kh(a.h.advanced||{});!d&&c&&Th(b,e);g=new WeakSet;h=u(b);for(k=h.next();!k.done;k=h.next())for(l=k.value,m=Uh(l),n=u(m),q=n.next();!q.done;q=n.next())r=q.value,g.has(r)||(g.add(r),Vh(r,e,f,a.h.keySystemsMapping));t=function(D,C){var B=[];D=u(D);for(var J=D.next();!J.done;J=
D.next()){J=J.value;var F=J[C]||f.has(J.keySystem)&&f.get(J.keySystem)[C]||"",L;if(L=F=="")L=(L=J.keySystem)?!!L.match(/^com\.widevine\.alpha/):!1;L&&(C=="audioRobustness"?F=[a.h.defaultAudioRobustnessForWidevine]:C=="videoRobustness"&&(F=[a.h.defaultVideoRobustnessForWidevine]));if(typeof F==="string")B.push(J);else if(Array.isArray(F))for(F.length===0&&(F=[""]),F=u(F),L=F.next();!L.done;L=F.next()){var K={};B.push(Object.assign({},J,(K[C]=L.value,K)))}}return B};v=new WeakSet;w=u(b);for(z=w.next();!z.done;z=
w.next())y=z.value,y.video&&!v.has(y.video)&&(y.video.drmInfos=t(y.video.drmInfos,"videoRobustness"),y.video.drmInfos=t(y.video.drmInfos,"audioRobustness"),v.add(y.video)),y.audio&&!v.has(y.audio)&&(y.audio.drmInfos=t(y.audio.drmInfos,"videoRobustness"),y.audio.drmInfos=t(y.audio.drmInfos,"audioRobustness"),v.add(y.audio));return G(I,Qf(b,a.R,a.O,a.h.preferredKeySystems),2)}hh(a.j);A=d||e.size>0;if(!A)return a.T=!0,I.return(Promise.resolve());E=Rh(a,b);return I.return(d?E:E.catch(function(){}))})}
function Wh(a){var b;return O(function(c){switch(c.g){case 1:if(a.l.mediaKeys)return c.return();if(!a.I){c.A(2);break}return G(c,a.I,3);case 3:return hh(a.j),c.return();case 2:return sa(c,4),a.I=a.l.setMediaKeys(a.B),G(c,a.I,6);case 6:ua(c,5);break;case 4:b=Aa(c),a.u(new U(2,6,6003,b.message));case 5:hh(a.j),H(c)}})}function Xh(a,b){return O(function(c){if(c.g==1)return G(c,Wh(a),2);Yh(a,b.initDataType,Wb(b.initData));H(c)})}
p.Vb=function(a){var b=this,c,d;return O(function(e){if(e.g==1){if(b.l===a)return e.return();if(!b.B)return b.o.Aa(a,"encrypted",function(){b.u(new U(2,6,6010))}),e.return();b.l=a;b.h.delayLicenseRequestUntilPlayed&&b.o.Aa(b.l,"play",function(){for(var f=u(b.N),g=f.next();!g.done;g=f.next())Zh(b,g.value);b.oa=!0;b.N=[]});b.l.remote?(b.o.D(b.l.remote,"connect",function(){return Mh(b)}),b.o.D(b.l.remote,"connecting",function(){return Mh(b)}),b.o.D(b.l.remote,"disconnect",function(){return Mh(b)})):
"webkitCurrentPlaybackTargetIsWireless"in b.l&&b.o.D(b.l,"webkitcurrentplaybacktargetiswirelesschanged",function(){return Mh(b)});b.H=b.g?b.g.initData.find(function(f){return f.initData.length>0})||null:null;c=b.g.keySystem;return(d=rb().Vg(c))||!b.H&&b.g.keySystem==="com.apple.fps"&&!b.C.size?e.A(2):G(e,Wh(b),2)}$h(b).catch(function(){});!d&&(b.H||b.C.size||b.h.parseInbandPsshEnabled)||b.o.D(b.l,"encrypted",function(f){return Xh(b,f)});H(e)})};
function ai(a){var b,c,d,e,f;return O(function(g){switch(g.g){case 1:if(!a.B||!a.g)return g.return();if(!a.g.serverCertificateUri||a.g.serverCertificate&&a.g.serverCertificate.length){g.A(2);break}b=Zg([a.g.serverCertificateUri],a.h.retryParameters);sa(g,3);c=a.F.vc.request(5,b,{isPreload:a.V()});return G(g,c.promise,5);case 5:d=g.h;a.g.serverCertificate=Wb(d.data);ua(g,4);break;case 3:throw e=Aa(g),new U(2,6,6017,e);case 4:if(a.j.g)return g.return();case 2:if(!a.g.serverCertificate||!a.g.serverCertificate.length)return g.return();
sa(g,6);return G(g,a.B.setServerCertificate(a.g.serverCertificate),8);case 8:ua(g,0);break;case 6:throw f=Aa(g),new U(2,6,6004,f.message);}})}function bi(a,b){var c,d,e;return O(function(f){if(f.g==1)return G(f,ci(a,b,{initData:null,initDataType:null}),2);if(f.g!=3){c=f.h;if(!c)return f.return();d=[];if(e=a.i.get(c))e.Kb=new Hg,d.push(e.Kb);d.push(c.remove());return G(f,Promise.all(d),3)}a.i.delete(c);H(f)})}
function $h(a){var b,c,d,e,f;return O(function(g){if(g.g==1){if(!a.C.size)return g.A(2);a.C.forEach(function(h,k){ci(a,k,h)});return G(g,a.m,3)}if(g.g!=2){b=a.g&&a.g.keyIds||new Set([]);if(b.size>0&&di(a))return g.return(a.m);a.K=!1;a.m=new Hg;a.m.catch(function(){})}c=(a.g?a.g.initData:[])||[];d=u(c);for(e=d.next();!e.done;e=d.next())f=e.value,Yh(a,f.initDataType,f.initData);ei(a)&&a.m.resolve();return g.return(a.m)})}
function Yh(a,b,c){if(c.length){try{c=a.h.initDataTransform(c,b,a.g)}catch(g){b=g;g instanceof U||(b=new U(2,6,6016,g));a.u(b);return}if(a.h.ignoreDuplicateInitData){var d=a.i.values();d=u(d);for(var e=d.next();!e.done;e=d.next())if(Ub(c,e.value.initData))return;var f=!1;a.C.forEach(function(g){!f&&Ub(c,g.initData)&&(f=!0)});if(f)return}a.K=!0;a.i.size>0&&ei(a)&&(a.m.resolve(),a.K=!1,a.m=new Hg,a.m.catch(function(){}));fi(a,b,c,a.g.sessionType)}}
function gi(a){a=a.i.keys();a=ih(a,function(b){return b.sessionId});return Array.from(a)}p.Kg=function(){var a=this,b=this.i.keys();b=ih(b,function(c){var d=a.i.get(c);return{sessionId:c.sessionId,sessionType:d.type,initData:d.initData,initDataType:d.initDataType}});return Array.from(b)};p.Zd=function(){var a=Infinity,b=this.i.keys();b=u(b);for(var c=b.next();!c.done;c=b.next())c=c.value,isNaN(c.expiration)||(a=Math.min(a,c.expiration));return a};function hi(a){return a.J?a.J:NaN}p.$e=function(){return lh(this.ma)};
function Rh(a,b){var c,d,e,f,g,h,k;return O(function(l){switch(l.g){case 1:c=new Map;d=ii(a,b,c);if(!d){if(!navigator.requestMediaKeySystemAccess)throw new U(2,6,6020);throw new U(2,6,6001);}hh(a.j);sa(l,2);d.getConfiguration();var m=e=a.h.keySystemsMapping[d.keySystem]||d.keySystem,n=c.get(e),q=[],r=[],t=[],v=[],w=[],z=new Set,y=new Set;ji(n,q,r,v,t,w,z,y);var A=a.R?"persistent-license":"temporary";m={keySystem:m,encryptionScheme:q[0],licenseServerUri:r[0],distinctiveIdentifierRequired:n[0].distinctiveIdentifierRequired,
persistentStateRequired:n[0].persistentStateRequired,sessionType:n[0].sessionType||A,audioRobustness:n[0].audioRobustness||"",videoRobustness:n[0].videoRobustness||"",serverCertificate:v[0],serverCertificateUri:t[0],initData:w,keyIds:z,mediaTypes:n[0].mediaTypes};y.size>0&&(m.keySystemUris=y);n=u(n);for(y=n.next();!y.done;y=n.next())y=y.value,y.distinctiveIdentifierRequired&&(m.distinctiveIdentifierRequired=y.distinctiveIdentifierRequired),y.persistentStateRequired&&(m.persistentStateRequired=y.persistentStateRequired);
a.g=m;if(!a.g.licenseServerUri)throw new U(2,6,6012,a.g.keySystem);return G(l,d.createMediaKeys(),4);case 4:f=l.h;hh(a.j);a.B=f;if(!(a.h.minHdcpVersion!=""&&"getStatusForPolicy"in a.B)){l.A(5);break}sa(l,6);return G(l,a.B.getStatusForPolicy({minHdcpVersion:a.h.minHdcpVersion}),8);case 8:g=l.h;if(g!="usable")throw new U(2,6,6018);hh(a.j);ua(l,5,2);break;case 6:h=Aa(l,2);if(h instanceof U)throw h;throw new U(2,6,6019,h.message);case 5:return a.T=!0,a.G.Ea(a.h.updateExpirationTime),G(l,ai(a),9);case 9:hh(a.j);
ua(l,0);break;case 2:k=Aa(l);hh(a.j,k);a.g=null;if(k instanceof U)throw k;throw new U(2,6,6002,k.message);}})}
function ii(a,b,c){for(var d=u(b),e=d.next();!e.done;e=d.next()){e=u(Uh(e.value));for(var f=e.next();!f.done;f=e.next())f=f.value,c.has(f.keySystem)||c.set(f.keySystem,[]),c.get(f.keySystem).push(f)}if(c.size==1&&c.has(""))throw new U(2,6,6E3);d=a.h.preferredKeySystems;d.length||(e=kh(a.h.servers),e.size==1&&(d=Array.from(e.keys())));e=u(d);var g=e.next();for(f={};!g.done;f={Ki:void 0},g=e.next()){f.Ki=g.value;g=u(b);for(var h=g.next();!h.done;h=g.next())if(h=h.value.decodingInfos.find(function(n){return function(q){return q.supported&&
q.keySystemAccess!=null&&q.keySystemAccess.keySystem==n.Ki}}(f)))return h.keySystemAccess}e=u([!0,!1]);for(f=e.next();!f.done;f=e.next())for(f=f.value,g=u(b),h=g.next();!h.done;h=g.next()){h=u(h.value.decodingInfos);for(var k=h.next();!k.done;k=h.next())if(k=k.value,k.supported&&k.keySystemAccess){var l=k.keySystemAccess.keySystem;if(!d.includes(l)){var m=c.get(l);!m&&a.h.keySystemsMapping[l]&&(m=c.get(a.h.keySystemsMapping[l]));l=u(m);for(m=l.next();!m.done;m=l.next())if(!!m.value.licenseServerUri==
f)return k.keySystemAccess}}}return null}function ki(a){ei(a)&&a.m.resolve()}function li(a,b){(new rf(function(){b.loaded=!0;ki(a)})).ka(mi)}
function ci(a,b,c){var d,e,f,g,h,k,l;return O(function(m){switch(m.g){case 1:try{d=a.B.createSession("persistent-license")}catch(n){return e=new U(2,6,6005,n.message),a.u(e),m.return(Promise.reject(e))}a.o.D(d,"message",function(n){ni(a)?a.N.push(n):Zh(a,n)});a.o.D(d,"keystatuseschange",function(n){return oi(a,n)});f={initData:c.initData,initDataType:c.initDataType,loaded:!1,Yg:Infinity,Kb:null,type:"persistent-license"};a.i.set(d,f);sa(m,2);return G(m,d.load(b),4);case 4:return g=m.h,hh(a.j),g||
(a.i.delete(d),h=a.h.persistentSessionOnlinePlayback?1:2,a.u(new U(h,6,6013)),f.loaded=!0),li(a,f),ki(a),m.return(d);case 2:k=Aa(m),hh(a.j,k),a.i.delete(d),l=a.h.persistentSessionOnlinePlayback?1:2,a.u(new U(l,6,6005,k.message)),f.loaded=!0,ki(a);case 3:return m.return(Promise.resolve())}})}
function fi(a,b,c,d){try{var e=a.B.createSession(d)}catch(f){a.u(new U(2,6,6005,f.message));return}a.o.D(e,"message",function(f){ni(a)?a.N.push(f):Zh(a,f)});a.o.D(e,"keystatuseschange",function(f){return oi(a,f)});a.i.set(e,{initData:c,initDataType:b,loaded:!1,Yg:Infinity,Kb:null,type:d});a.h.logLicenseExchange&&zc(c);e.generateRequest(b,c).catch(function(f){if(!a.j.g){a.i.delete(e);var g=f.errorCode;if(g&&g.systemCode){var h=g.systemCode;h<0&&(h+=4294967296);h="0x"+h.toString(16)}a.u(new U(2,6,6006,
f.message,f,h))}})}function ni(a){return a.l?a.h.delayLicenseRequestUntilPlayed&&a.l.paused&&!a.oa:!a.$&&a.h.delayLicenseRequestUntilPlayed}function pi(a){return O(function(b){return b.g==1?!a.K||ni(a)?b.A(0):G(b,a.m,3):G(b,Promise.all(a.X.map(function(c){return c.promise})),0)})}
function Zh(a,b){var c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z;O(function(y){switch(y.g){case 1:c=b.target;a.h.logLicenseExchange&&zc(b.message);d=a.i.get(c);e=a.g.licenseServerUri;f=a.h.advanced[a.g.keySystem];b.messageType=="individualization-request"&&f&&f.individualizationServer&&(e=f.individualizationServer);g=Zg([e],a.h.retryParameters);g.body=b.message;g.method="POST";g.licenseRequestType=b.messageType;g.sessionId=c.sessionId;g.drmInfo=a.g;d&&(g.initData=d.initData,g.initDataType=d.initDataType);if(f&&
f.headers)for(h in f.headers)g.headers[h]=f.headers[h];if(a.g.keySystem==="org.w3.clearkey"){var A=g,E=a.g;try{var I=sc(A.body);if(I){var D=JSON.parse(I);D.type||(D.type=E.sessionType,A.body=uc(JSON.stringify(D)))}}catch(C){}}if(hc(a.g.keySystem))if(A=qc(g.body,!0,!0),A.includes("PlayReadyKeyMessage")){A=Ad(A,"PlayReadyKeyMessage");E=Kd(A,"HttpHeader");E=u(E);for(I=E.next();!I.done;I=E.next())D=I.value,I=Kd(D,"name")[0],D=Kd(D,"value")[0],g.headers[Id(I)]=Id(D);A=Kd(A,"Challenge")[0];g.body=Ac(Id(A))}else g.headers["Content-Type"]=
"text/xml; charset=utf-8";k=Date.now();sa(y,2);m=a.F.vc.request(2,g,{isPreload:a.V()});a.X.push(m);return G(y,m.promise,4);case 4:l=y.h;gb(a.X,m);ua(y,3);break;case 2:n=Aa(y);if(a.j.g)return y.return();q={sessionId:c.sessionId,sessionType:d.type,initData:d.initData,initDataType:d.initDataType};r=new U(2,6,6007,n,q);a.i.size==1?(a.u(r),d&&d.Kb&&d.Kb.reject(r)):(d&&d.Kb&&d.Kb.reject(r),a.i.delete(c),ei(a)&&(a.m.resolve(),a.M.ka(.1)));return y.return();case 3:if(a.j.g)return y.return();a.J+=(Date.now()-
k)/1E3;a.h.logLicenseExchange&&zc(l.data);sa(y,5);return G(y,c.update(l.data),7);case 7:ua(y,6);break;case 5:return v=(t=Aa(y))&&t.message||String(t),w=new U(2,6,6008,v),a.u(w),d&&d.Kb&&d.Kb.reject(w),y.return();case 6:if(a.j.g)return y.return();z=new V("drmsessionupdate");a.F.onEvent(z);d&&(d.Kb&&d.Kb.resolve(),li(a,d));H(y)}})}
function oi(a,b){b=b.target;var c=a.i.get(b),d=!1;b.keyStatuses.forEach(function(f,g){if(typeof g=="string"){var h=g;g=f;f=h}h=rb();if(hc(a.g.keySystem)&&g.byteLength==16&&h.Ff()){h=ac(g);var k=h.getUint32(0,!0),l=h.getUint16(4,!0),m=h.getUint16(6,!0);h.setUint32(0,k,!1);h.setUint16(4,l,!1);h.setUint16(6,m,!1)}f!="status-pending"&&(c.loaded=!0);f=="expired"&&(d=!0);g=Cc(g).slice(0,32);a.ba.set(g,f)});var e=b.expiration-Date.now();(e<0||d&&e<1E3)&&c&&!c.Kb&&(a.i.delete(b),qi(b));ei(a)&&(a.m.resolve(),
a.M.ka(ri))}function Gh(a){var b=a.ba,c=a.ma;c.clear();b.forEach(function(d,e){return c.set(e,d)});b=Array.from(c.values());b.length&&b.every(function(d){return d=="expired"})&&a.u(new U(2,6,6014));a.F.zf(lh(c))}
function si(){var a,b,c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K;return O(function(P){if(P.g==1){a="org.w3.clearkey com.widevine.alpha com.widevine.alpha.experiment com.microsoft.playready com.microsoft.playready.hardware com.microsoft.playready.recommendation com.microsoft.playready.recommendation.3000 com.microsoft.playready.recommendation.3000.clearlead com.chromecast.playready com.apple.fps.1_0 com.apple.fps com.huawei.wiseplay".split(" ");if(!(window.MediaKeys&&window.navigator&&window.navigator.requestMediaKeySystemAccess&&
window.MediaKeySystemAccess&&window.MediaKeySystemAccess.prototype.getConfiguration)){b={};c=u(a);for(d=c.next();!d.done;d=c.next())e=d.value,b[e]=null;return P.return(b)}f="1.0 1.1 1.2 1.3 1.4 2.0 2.1 2.2 2.3".split(" ");g=["SW_SECURE_CRYPTO","SW_SECURE_DECODE","HW_SECURE_CRYPTO","HW_SECURE_DECODE","HW_SECURE_ALL"];h=["150","2000","3000"];k={"com.widevine.alpha":g,"com.widevine.alpha.experiment":g,"com.microsoft.playready.recommendation":h};l=[{contentType:'video/mp4; codecs="avc1.42E01E"'},{contentType:'video/webm; codecs="vp8"'}];
m=[{contentType:'audio/mp4; codecs="mp4a.40.2"'},{contentType:'audio/webm; codecs="opus"'}];n={videoCapabilities:l,audioCapabilities:m,initDataTypes:["cenc","sinf","skd","keyids"]};q=[null,"cenc","cbcs"];r=new Map;t=rb();v=function(Q,N,M){var R,S,ka,Y,Ca,ya,wa,Da,xa,Ja,ra,Fa,va;return O(function(za){switch(za.g){case 1:return sa(za,2),G(za,N.createMediaKeys(),5);case 5:R=za.h;case 4:ua(za,3);break;case 2:return Aa(za),za.return();case 3:ka=(S=N.getConfiguration().sessionTypes)?S.includes("persistent-license"):
!1;t.Ci()&&(ka=!1);Y=N.getConfiguration().videoCapabilities;Ca=N.getConfiguration().audioCapabilities;ya={persistentState:ka,encryptionSchemes:[],videoRobustnessLevels:[],audioRobustnessLevels:[],minHdcpVersions:[]};r.get(Q)?ya=r.get(Q):r.set(Q,ya);(wa=Y[0].encryptionScheme)&&!ya.encryptionSchemes.includes(wa)&&ya.encryptionSchemes.push(wa);(Da=Y[0].robustness)&&!ya.videoRobustnessLevels.includes(Da)&&ya.videoRobustnessLevels.push(Da);(xa=Ca[0].robustness)&&!ya.audioRobustnessLevels.includes(xa)&&
ya.audioRobustnessLevels.push(xa);if(!(M&&"getStatusForPolicy"in R)){za.A(0);break}Ja=u(f);ra=Ja.next();case 7:if(ra.done){za.A(0);break}Fa=ra.value;if(ya.minHdcpVersions.includes(Fa)){za.A(8);break}return G(za,R.getStatusForPolicy({minHdcpVersion:Fa}),10);case 10:if(va=za.h,va=="usable")ya.minHdcpVersions.includes(Fa)||ya.minHdcpVersions.push(Fa);else{za.A(0);break}case 8:ra=Ja.next(),za.A(7)}})};w=function(Q,N,M,R,S){S=S===void 0?!1:S;var ka,Y,Ca,ya,wa,Da,xa,Ja,ra,Fa,va;return O(function(za){switch(za.g){case 1:sa(za,
2);ka=wd(n);Y=u(ka.videoCapabilities);for(Ca=Y.next();!Ca.done;Ca=Y.next())ya=Ca.value,ya.encryptionScheme=N,ya.robustness=M;wa=u(ka.audioCapabilities);for(Da=wa.next();!Da.done;Da=wa.next())xa=Da.value,xa.encryptionScheme=N,xa.robustness=R;Ja=wd(ka);Ja.persistentState="required";Ja.sessionTypes=["persistent-license"];ra=[Ja,ka];va=rb();return va.Oa()=="MOBILE"?G(za,vf(5,navigator.requestMediaKeySystemAccess(Q,ra)),7):G(za,navigator.requestMediaKeySystemAccess(Q,ra),6);case 6:Fa=za.h;za.A(5);break;
case 7:Fa=za.h;case 5:return G(za,v(Q,Fa,S),8);case 8:ua(za,0);break;case 2:Aa(za),H(za)}})};z=function(Q){return rb().Ha()==="WEBKIT"&&Q==="org.w3.clearkey"?!1:!0};y=[];A=u(a);for(E=A.next();!E.done;E=A.next())if(I=E.value,r.set(I,null),z(I)){D=!0;C=u(q);for(B=C.next();!B.done;B=C.next())J=B.value,y.push(w(I,J,"","",D)),D=!1;F=u(k[I]||[]);for(L=F.next();!L.done;L=F.next())K=L.value,y.push(w(I,null,K,"")),y.push(w(I,null,"",K))}return G(P,Promise.all(y),2)}return P.return(lh(r))})}
function qi(a){return O(function(b){if(b.g==1)return sa(b,2),G(b,vf(ti,Promise.all([a.close().catch(function(){}),a.closed])),4);if(b.g!=2)return ua(b,0);Aa(b);H(b)})}
function Mh(a){var b;return O(function(c){b=Array.from(a.i.entries());a.i.clear();return G(c,Promise.all(b.map(function(d){d=u(d);var e=d.next().value;var f=d.next().value;return O(function(g){if(g.g==1)return sa(g,2),a.$||a.C.has(e.sessionId)||f.type!=="persistent-license"||a.h.persistentSessionOnlinePlayback?G(g,qi(e),5):G(g,e.remove(),5);if(g.g!=2)return ua(g,0);Aa(g);H(g)})})),0)})}function Uh(a){return(a.video?a.video.drmInfos:[]).concat(a.audio?a.audio.drmInfos:[])}
function Hh(a){a.i.forEach(function(b,c){var d=b.Yg,e=c.expiration;isNaN(e)&&(e=Infinity);e!=d&&(a.F.onExpirationUpdated(c.sessionId,e),b.Yg=e)})}function ei(a){a=a.i.values();return jh(a,function(b){return b.loaded})}function di(a){for(var b=u(a.g&&a.g.keyIds||new Set([])),c=b.next();!c.done;c=b.next())if(a.ba.get(c.value)!=="usable")return!1;return!0}
function Th(a,b){var c=[];b.forEach(function(d,e){c.push({keySystem:e,licenseServerUri:d,distinctiveIdentifierRequired:!1,persistentStateRequired:!1,audioRobustness:"",videoRobustness:"",serverCertificate:null,serverCertificateUri:"",initData:[],keyIds:new Set})});a=u(a);for(b=a.next();!b.done;b=a.next())b=b.value,b.video&&(b.video.drmInfos=c),b.audio&&(b.audio.drmInfos=c)}
function ji(a,b,c,d,e,f,g,h){var k=[];a=u(a);for(var l=a.next(),m={};!l.done;m={La:void 0},l=a.next()){m.La=l.value;b.includes(m.La.encryptionScheme)||b.push(m.La.encryptionScheme);m.La.keySystem=="org.w3.clearkey"&&m.La.licenseServerUri.startsWith("data:application/json;base64,")?k.includes(m.La.licenseServerUri)||k.push(m.La.licenseServerUri):c.includes(m.La.licenseServerUri)||c.push(m.La.licenseServerUri);e.includes(m.La.serverCertificateUri)||e.push(m.La.serverCertificateUri);m.La.serverCertificate&&
(d.some(function(r){return function(t){return Ub(t,r.La.serverCertificate)}}(m))||d.push(m.La.serverCertificate));if(m.La.initData){l=u(m.La.initData);for(var n=l.next(),q={};!n.done;q={Pg:void 0},n=l.next())q.Pg=n.value,f.some(function(r){return function(t){var v=r.Pg;return t.keyId&&t.keyId==v.keyId?!0:t.initDataType==v.initDataType&&Ub(t.initData,v.initData)}}(q))||f.push(q.Pg)}if(m.La.keyIds)for(l=u(m.La.keyIds),n=l.next();!n.done;n=l.next())g.add(n.value);if(m.La.keySystemUris&&h)for(m=u(m.La.keySystemUris),
l=m.next();!l.done;l=m.next())h.add(l.value)}if(k.length==1)c.push(k[0]);else if(k.length>0){b=[];k=u(k);for(d=k.next();!d.done;d=k.next())d=window.atob(d.value.split("data:application/json;base64,").pop()),d=JSON.parse(d),b.push.apply(b,x(d.keys));k=JSON.stringify({keys:b});c.push("data:application/json;base64,"+window.btoa(k))}}
function Vh(a,b,c,d){var e=a.keySystem;if(e&&(e!="org.w3.clearkey"||!a.licenseServerUri)){b.size&&b.get(e)&&(b=b.get(e),a.licenseServerUri=b);a.keyIds||(a.keyIds=new Set);if(c=c.get(e))a.distinctiveIdentifierRequired||(a.distinctiveIdentifierRequired=c.distinctiveIdentifierRequired),a.persistentStateRequired||(a.persistentStateRequired=c.persistentStateRequired),a.serverCertificate||(a.serverCertificate=c.serverCertificate),c.sessionType&&(a.sessionType=c.sessionType),a.serverCertificateUri||(a.serverCertificateUri=
c.serverCertificateUri);d[e]&&(a.keySystem=d[e]);window.cast&&window.cast.__platform__&&e=="com.microsoft.playready"&&(a.keySystem="com.chromecast.playready")}}function Sh(a,b){a=kh(a);if(a.size!=0){a=Gc(a);b=u(b);for(var c=b.next();!c.done;c=b.next())c=c.value,c.video&&(c.video.drmInfos=[a]),c.audio&&(c.audio.drmInfos=[a])}}var ti=1,mi=5,ri=.5;function ui(){this.g=vi;this.j=(new Map).set(vi,2).set(wi,1);this.i=0;this.h=-1}function xi(a,b){var c=a.g!==b;a.g=b;c&&b===vi&&(a.i=Date.now());return c}var wi=0,vi=1;/*
 @license
 Shaka Player
 Copyright 2023 Google LLC
 SPDX-License-Identifier: Apache-2.0
*/
function yi(a,b,c){this.h=a;this.i=b;this.g=c}function zi(a,b){return O(function(c){if(c.g==1)return G(c,Lf(a.g,b,a.h.drm.preferredKeySystems,a.h.drm.keySystemsMapping),2);a.h.streaming.dontChooseCodecs||Hf(b,a.h.preferredVideoCodecs,a.h.preferredAudioCodecs,a.h.preferredDecodingAttributes,a.h.preferredTextFormats);if(!b.variants.some(rg))throw new U(2,4,4032);return c.return(Ai(a,b))})}
function Bi(a,b){var c=a.h.restrictions;a=a.i;var d=!1;b=u(b.variants);for(var e=b.next();!e.done;e=b.next()){e=e.value;var f=e.allowedByApplication;e.allowedByApplication=Kf(e,c,a);f!=e.allowedByApplication&&(d=!0)}return d}
function Ai(a,b){var c=Bi(a,b);if(b){var d=a.g?a.g.g:null;if(d&&a.g.B){for(var e=new Set,f=u(b.variants),g=f.next();!g.done;g=f.next())g=g.value,g.audio&&e.add(g.audio),g.video&&e.add(g.video);e=u(e);for(f=e.next();!f.done;f=e.next())Ci(a,d.keySystem,f.value)}Di(a,b)}return c}
function Ci(a,b,c){c=u(c.drmInfos);for(var d=c.next();!d.done;d=c.next())if(d=d.value,d.keySystem==b){for(var e=u(d.initData||[]),f=e.next();!f.done;f=e.next())f=f.value,Yh(a.g,f.initDataType,f.initData);e=a.g;e.g&&e.g.mediaTypes!==d.mediaTypes&&(e.g.mediaTypes=d.mediaTypes)}}
function Di(a,b){function c(l){if(l&&!h.has(l)&&(h.add(l),l.keyIds.size)){l=u(l.keyIds);for(var m=l.next();!m.done;m=l.next()){m=m.value;var n=d[e?"00":m];n?Ei.includes(n)&&g.add(n):f.add(m)}}}var d=a.g?a.g.$e():{};a=Object.keys(d);var e=a.length&&a[0]=="00";a=!1;var f=new Set,g=new Set,h=new WeakSet;b=u(b.variants);for(var k=b.next();!k.done;k=b.next()){k=k.value;if(!k.allowedByApplication)a=!0;else if(k.allowedByKeySystem)return;c(k.audio);c(k.video)}a={hasAppRestrictions:a,missingKeys:Array.from(f),
restrictedKeyStatuses:Array.from(g)};throw new U(2,4,4012,a);}var Ei=["output-restricted","internal-error"];T("shaka.config.CodecSwitchingStrategy",{RELOAD:"reload",SMOOTH:"smooth"});function Fi(a){if(Gi.has(a))return Gi.get(a);var b=window.ManagedMediaSource||window.MediaSource;return b?(b=b.isTypeSupported(a),Gi.set(a,b),b):!1}function Hi(){var a=window.ManagedMediaSource||window.MediaSource;return a&&a.prototype?!!a.prototype.setLiveSeekableRange&&!!a.prototype.clearLiveSeekableRange:!1}var Gi=new Map;function Ii(a,b){var c=null,d=null,e=null,f=null,g=a.U();b&1&&(e=a.Ed());b&2&&(f=a.U());b&8&&(c=a.U());b&16&&(d=a.U());return{trackId:g,Wd:c,Xd:d,rj:e,Ri:f}}function Ji(a,b){return b==1?(b=a.U(),a=a.U(),{baseMediaDecodeTime:b*4294967296+a}):{baseMediaDecodeTime:a.U()}}function Ki(a,b){b==1?(a.skip(8),a.skip(8)):(a.skip(4),a.skip(4));b=a.U();a.skip(4);a=a.Ca();return{timescale:b,language:String.fromCharCode((a>>10)+96)+String.fromCharCode(((a&960)>>5)+96)+String.fromCharCode((a&31)+96)}}
function Li(a,b,c){var d=a.U(),e=[],f=null;c&1&&(f=a.dh());c&4&&a.skip(4);for(var g=0;g<d;g++){var h={nh:null,sampleSize:null,Gf:null};c&256&&(h.nh=a.U());c&512&&(h.sampleSize=a.U());c&1024&&a.skip(4);c&2048&&(h.Gf=b==0?a.U():a.dh());e.push(h)}return{Hm:d,mh:e,qg:f}}function Mi(a){a.skip(6);a.skip(2);a.skip(8);var b=a.Ca();a.skip(2);a.skip(2);a.skip(2);a=a.Ca()+a.Ca()/65536;return{channelCount:b,sampleRate:a}}function Ni(a){a=a.U();return{codec:th(a)}}
function Oi(a){var b=null,c=null,d=a.Tb(4,!1);var e=String.fromCharCode(d[0]);e+=String.fromCharCode(d[1]);e+=String.fromCharCode(d[2]);e+=String.fromCharCode(d[3]);if(e==="nclx"){switch(a.Ca()){case 1:case 5:case 6:case 7:b="srgb";break;case 9:b="rec2020";break;case 11:case 12:b="p3"}d=a.Ca();a.Ca();switch(d){case 1:case 6:case 13:case 14:case 15:c="SDR";break;case 16:c="PQ";break;case 18:c="HLG"}}return{colorGamut:b,ze:c}}
function Pi(a,b){b=b===void 0?!1:b;a=a.toString(16).toUpperCase();return b?a:("0"+a).slice(-2)}function Qi(a){return(a<10?"0":"")+a};function Ri(a){this.g=a}
function Si(a){for(var b=[],c=u(a.g),d=c.next();!d.done;d=c.next()){var e=b,f=e.push;var g=d.value;d=Ti;var h=g.id+1;var k=g.stream.width||0,l=g.stream.height||0;g.type=="audio"&&(l=k=0);var m=g.duration*g.timescale,n=Math.floor(m/(Ui+1));m=Math.floor(m%(Ui+1));h=new Uint8Array([1,0,0,7,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3].concat(x(Vi(h,4)),[0,0,0,0],x(Vi(n,4)),x(Vi(m,4)),[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0],x(Vi(k,2)),[0,0],x(Vi(l,
2)),[0,0]));h=Ti("tkhd",h);k=Ti;n=g.duration*g.timescale;l=Math.floor(n/(Ui+1));n=Math.floor(n%(Ui+1));m=g.stream.language;m=m.charCodeAt(0)-96<<10|m.charCodeAt(1)-96<<5|m.charCodeAt(2)-96;l=new Uint8Array([1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3].concat(x(Vi(g.timescale,4)),x(Vi(l,4)),x(Vi(n,4)),x(Vi(m,2)),[0,0]));l=Ti("mdhd",l);n=g;m=new Uint8Array([]);switch(n.type){case "video":m=Wi.value();break;case "audio":m=Xi.value()}n=Ti("hdlr",m);a:{switch(g.type){case "video":g=Ti("minf",Ti("vmhd",Yi.value()),
Zi.value(),$i(g));break a;case "audio":g=Ti("minf",Ti("smhd",aj.value()),Zi.value(),$i(g));break a}g=new Uint8Array([])}g=k("mdia",l,n,g);d=d("trak",h,g);f.call(e,d)}b=Dc.apply(xc,x(b));f=a.g[0];c=Ti;d=f.duration*f.timescale;e=Math.floor(d/(Ui+1));d=Math.floor(d%(Ui+1));e=new Uint8Array([1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3].concat(x(Vi(f.timescale,4)),x(Vi(e,4)),x(Vi(d,4)),[0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]));e=Ti("mvhd",e);d=[];a=u(a.g);for(k=a.next();!k.done;k=a.next())g=d,h=g.push,k=new Uint8Array([0,0,0,0].concat(x(Vi(k.value.id+1,4)),[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),k=Ti("trex",k),h.call(g,k);a=Dc.apply(xc,x(d));a=Ti("mvex",a);d=[];if(f.encrypted){f=u(f.stream.drmInfos);for(g=f.next();!g.done;g=f.next())if(g=g.value,g.initData)for(g=u(g.initData),h=g.next();!h.done;h=g.next())d.push(h.value.initData);f=Dc.apply(xc,x(d))}else f=new Uint8Array([]);
a=c("moov",e,b,a,f);b=bj.value();c=new Uint8Array(b.byteLength+a.byteLength);c.set(b);c.set(a,b.byteLength);return c}
function $i(a){var b=Ti,c="aac";a.codecs.includes("mp3")?c="mp3":a.codecs.includes("ac-3")?c=rb().se()?"ec-3":"ac-3":a.codecs.includes("ec-3")?c="ec-3":a.codecs.includes("opus")&&(c="opus");var d=new Uint8Array([]);switch(a.type){case "video":if(a.codecs.includes("avc1")){c=a.stream.width||0;d=a.stream.height||0;if(a.Sa.byteLength>0)var e=Ti("avcC",a.Sa);else{e=Ti;for(var f=7,g=[],h=[],k=0,l=0,m=0,n=0;n<a.Bb.length;n++){var q=cj(a.Bb[n]);switch(q[0]&31){case 7:g.push(q);f+=q.length+2;break;case 8:h.push(q),
f+=q.length+2}}g.length>0&&(k=g[0][1],m=g[0][2],l=g[0][3]);f=new Uint8Array(f);n=0;f[n++]=1;f[n++]=k;f[n++]=m;f[n++]=l;f[n++]=255;f[n++]=224|g.length;for(k=0;k<g.length;k++)f[n++]=(g[k].length&65280)>>8,f[n++]=g[k].length&255,f.set(g[k],n),n+=g[k].length;f[n++]=h.length;for(g=0;g<h.length;g++)f[n++]=(h[g].length&65280)>>8,f[n++]=h[g].length&255,f.set(h[g],n),n+=h[g].length;e=e("avcC",f)}c=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].concat(x(Vi(c,2)),x(Vi(d,2)),[0,72,0,0,0,72,
0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]));d="avc1";h=dj(a);g=new Uint8Array([]);a.encrypted&&(g=ej(a.stream,a.codecs),d="encv");d=Ti(d,c,e,h,g)}else a.codecs.includes("hvc1")&&(d=a.stream.width||0,e=a.stream.height||0,c=new Uint8Array([]),a.Sa.byteLength>0&&(c=Ti("hvcC",a.Sa)),d=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].concat(x(Vi(d,2)),x(Vi(e,2)),[0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,
100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17])),e="hvc1",h=dj(a),g=new Uint8Array([]),a.encrypted&&(g=ej(a.stream,a.codecs),e="encv"),d=Ti(e,d,c,h,g));break;case "audio":if(c=="mp3")a=Ti(".mp3",fj(a));else if(c=="ac-3")c=Ti("dac3",a.Ga),d="ac-3",e=new Uint8Array([]),a.encrypted&&(e=ej(a.stream,a.codecs),d="enca"),a=Ti(d,fj(a),c,e);else if(c=="ec-3")c=Ti("dec3",a.Ga),d="ec-3",e=new Uint8Array([]),a.encrypted&&(e=ej(a.stream,a.codecs),d="enca"),
a=Ti(d,fj(a),c,e);else if(c=="opus")c=Ti("dOps",a.Ga),d="Opus",e=new Uint8Array([]),a.encrypted&&(e=ej(a.stream,a.codecs),d="enca"),a=Ti(d,fj(a),c,e);else{if(a.Ga.byteLength>0)c=Ti("esds",a.Ga);else{c=Ti;d=a.id+1;e=a.stream.channelsCount||2;g=a.stream.audioSamplingRate||44100;k=Hc("audio",a.codecs.split(","));l={96E3:0,88200:1,64E3:2,48E3:3,44100:4,32E3:5,24E3:6,22050:7,16E3:8,12E3:9,11025:10,8E3:11,7350:12};h=l[g];if(k==="mp4a.40.5"||k==="mp4a.40.29")h=l[g*2];g=parseInt(k.split(".").pop(),10);d=
new Uint8Array([0,0,0,0,3,25].concat(x(Vi(d,2)),[0,4,17,64,21,0,0,0,0,0,0,0,0,0,0,0,5,2,g<<3|h>>>1,h<<7|e<<3,6,1,2]));c=c("esds",d)}d="mp4a";e=new Uint8Array([]);a.encrypted&&(e=ej(a.stream,a.codecs),d="enca");a=Ti(d,fj(a),c,e)}d=a}a=Ti("stsd",gj.value(),d);return b("stbl",a,Ti("stts",hj.value()),Ti("stsc",ij.value()),Ti("stsz",jj.value()),Ti("stco",kj.value()))}
function dj(a){if(!a.Za&&!a.$a)return new Uint8Array([]);var b=a.$a;a=new Uint8Array([].concat(x(Vi(a.Za,4)),x(Vi(b,4))));return Ti("pasp",a)}function fj(a){return new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,a.stream.channelsCount||2,0,16,0,0,0,0].concat(x(Vi(a.stream.audioSamplingRate||44100,2)),[0,0]))}
function ej(a,b){var c=Ti;b=new Uint8Array([].concat(x(Vi(lj(b.split(".")[0]),4))));b=Ti("frma",b);var d="cenc";var e=a.drmInfos[0];e&&e.encryptionScheme&&(d=e.encryptionScheme);d=new Uint8Array([0,0,0,0].concat(x(Vi(lj(d),4)),[0,1,0,0]));d=Ti("schm",d);e=Ti;var f=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);a=u(a.drmInfos);for(var g=a.next();!g.done;g=a.next())if((g=g.value)&&g.keyIds&&g.keyIds.size){g=u(g.keyIds);for(var h=g.next();!h.done;h=g.next())f=cj(h.value)}a=new Uint8Array([0,0,0,0,
0,0,1,8]);f=Ti("tenc",a,f);return c("sinf",b,d,e("schi",f))}
function mj(a){var b=[];a=u(a.g);for(var c=a.next();!c.done;c=a.next()){c=c.value;var d=b.push,e=d.apply;var f=Ti;var g=new Uint8Array([0,0,0,0].concat(x(Vi(c.data?c.data.sequenceNumber:0,4))));g=Ti("mfhd",g);var h;var k=c.data?c.data.zb:[];var l=new Uint8Array(4+k.length);for(h=0;h<k.length;h++){var m=k[h].flags;l[h+4]=m.ib<<4|m.mb<<2|m.jb}k=Ti("sdtp",l);var n=k.length+32+20+8+16+8+8;l=Ti;h=new Uint8Array([0,0,0,58].concat(x(Vi(c.id+1,4)),[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0]));h=Ti("tfhd",h);m=c.data?
c.data.baseMediaDecodeTime:0;var q=Math.floor(m%(Ui+1));m=new Uint8Array([1,0,0,0].concat(x(Vi(Math.floor(m/(Ui+1)),4)),x(Vi(q,4))));m=Ti("tfdt",m);var r=n;n=c.data?c.data.zb:[];q=n.length;var t=12+16*q,v=new Uint8Array(t);r+=8+t;v.set([c.type==="video"?1:0,0,15,1].concat(x(Vi(q,4)),x(Vi(r,4))),0);for(r=0;r<q;r++){var w=n[r];t=Vi(w.duration,4);var z=Vi(w.size,4),y=w.flags;w=Vi(w.sb,4);v.set([].concat(x(t),x(z),[y.xb<<2|y.ib,y.mb<<6|y.jb<<4|y.yb,y.hb&61440,y.hb&15],x(w)),12+16*r)}n=Ti("trun",v);k=
l("traf",h,m,n,k);f=f("moof",g,k);e.call(d,b,[f,nj(c)])}return Dc.apply(xc,x(b))}function nj(a){a=(a.data?a.data.zb:[]).map(function(b){return b.data});a=Dc.apply(xc,x(a));return Ti("mdat",a)}function Vi(a,b){var c=[];for(--b;b>=0;b--)c.push(a>>8*b&255);return c}function cj(a){for(var b=new Uint8Array(a.length/2),c=0;c<a.length/2;c+=1)b[c]=parseInt(String(a[c*2]+a[c*2+1]),16);return b}function lj(a){for(var b=0,c=0;c<a.length;c+=1)b|=a.charCodeAt(c)<<(a.length-c-1)*8;return b}
function Ti(a){var b=Na.apply(1,arguments),c=oj.get(a);c||(c=[a.charCodeAt(0),a.charCodeAt(1),a.charCodeAt(2),a.charCodeAt(3)],oj.set(a,c));for(var d=8,e=b.length-1;e>=0;e--)d+=b[e].byteLength;e=new Uint8Array(d);e[0]=d>>24&255;e[1]=d>>16&255;e[2]=d>>8&255;e[3]=d&255;e.set(c,4);c=0;for(d=8;c<b.length;c++)e.set(b[c],d),d+=b[c].byteLength;return e}
var Ui=4294967295,oj=new Map,Wi=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0])}),Xi=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0])}),hj=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0])}),ij=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0])}),kj=new qb(function(){return new Uint8Array([0,
0,0,0,0,0,0,0])}),jj=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0])}),Yi=new qb(function(){return new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}),aj=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,0])}),gj=new qb(function(){return new Uint8Array([0,0,0,0,0,0,0,1])}),bj=new qb(function(){var a=new Uint8Array([105,115,111,109]),b=new Uint8Array([97,118,99,49]),c=new Uint8Array([0,0,0,1]);return Ti("ftyp",a,c,a,b)}),Zi=new qb(function(){var a=new Uint8Array([0,0,0,0,0,0,0,1,0,
0,0,12,117,114,108,32,0,0,0,1]);a=Ti("dref",a);return Ti("dinf",a)});function pj(a){a=Wb(a);var b=null;(new ph).box("moov",uh).box("trak",uh).box("mdia",uh).box("minf",uh).box("stbl",uh).S("stsd",zh).box("enca",function(c){b=c.reader.h;return Bh(c)}).box("sinf",uh).box("frma",function(c){c.parser.stop();Ni(c.reader).codec==="ec-3"&&b&&b.getUint16(16)!==2&&b.setUint16(16,2)}).parse(a);return a}
function qj(a,b,c){function d(r){n.push({box:r,Ei:1701733217})}function e(r){n.push({box:r,Ei:1701733238})}function f(r){k=!0;r.parser.stop()}function g(r){m.push(r);uh(r)}var h=b=Wb(b),k=!1,l,m=[],n=[];(new ph).box("moov",g).box("trak",g).box("mdia",g).box("minf",g).box("stbl",g).S("stsd",function(r){l=r;m.push(r);zh(r)}).S("encv",f).S("enca",f).S("dvav",e).S("dva1",e).S("dvh1",e).S("dvhe",e).S("dvc1",e).S("dvi1",e).S("hev1",e).S("hvc1",e).S("avc1",e).S("avc3",e).S("ac-3",d).S("ec-3",d).S("ac-4",
d).S("Opus",d).S("fLaC",d).S("mp4a",d).parse(b);if(k)return b;if(n.length==0||!l)throw eb(Cc(b)),new U(2,3,3019,c);n.reverse();c=u(n);for(var q=c.next();!q.done;q=c.next())q=q.value,h=rj(a,h,l,q.box,m,q.Ei);return rb().ih()?(a=new Uint8Array(b.byteLength+h.byteLength),a.set(h),a.set(b,h.byteLength),a):h}
function sj(a){a=Wb(a);var b=[];(new ph).box("mdat",function(g){b.push(g)}).parse(a);for(var c=[],d=0;d<b.length;d++){var e=b[d-1],f=b[d];c.push(tj(a.subarray(e?e.start+e.size:0,f.start+f.size)))}return Dc.apply(xc,x(c))}
function tj(a){function b(n){g.push(n);uh(n)}var c,d,e,f,g=[];(new ph).box("moof",b).box("traf",b).S("tfhd",function(n){c=n;e=Ii(n.reader,n.flags)}).S("trun",function(n){d=n;f=Li(n.reader,n.version,n.flags)}).parse(a);if(e&&e.Ri!==2){var h=c.start+yh(c)+4+(e.rj!==null?8:0),k=ac(a);if(e.Ri!==null)k.setUint32(h,2);else{uj(a,c.start,c.size+4);var l=k.getUint32(c.start+8);k.setUint32(c.start+8,l|2);f&&f.qg!==null&&k.setInt32(d.start+yh(d)+4,f.qg+4);l=a.subarray(0,h);k=a.subarray(h);a=new Uint8Array(a.byteLength+
4);a.set(l);l=[];for(var m=3;m>=0;m--)l.push(2>>8*m&255);a.set(new Uint8Array(l),h);a.set(k,h+4);h=u(g);for(k=h.next();!k.done;k=h.next())k=k.value,uj(a,k.start,k.size+4)}}return a}
function rj(a,b,c,d,e,f){var g=ej(a,d.name),h=b.subarray(d.start,d.start+d.size);a=new Uint8Array(d.size+g.byteLength);a.set(h,0);ac(a).setUint32(4,f);a.set(g,d.size);uj(a,0,a.byteLength);f=new Uint8Array(b.byteLength+a.byteLength);d=rb().jf()?d.start:d.start+d.size;g=b.subarray(d);f.set(b.subarray(0,d));f.set(a,d);f.set(g,d+a.byteLength);b=u(e);for(e=b.next();!e.done;e=b.next())e=e.value,uj(f,e.start,e.size+a.byteLength);a=ac(f,c.start);c=yh(c);b=a.getUint32(c);a.setUint32(c,b+1);return f}
function uj(a,b,c){a=ac(a,b);b=a.getUint32(0);b!=0&&(b==1?(a.setUint32(8,c>>32),a.setUint32(12,c&4294967295)):a.setUint32(0,c))}
function vj(a){function b(e){d.push({start:e.start,size:e.size});uh(e)}var c=Wb(a),d=[];(new ph).box("moov",b).box("trak",b).box("mdia",b).box("minf",b).box("stbl",b).box("stsd",function(e){d.push({start:e.start,size:e.size});for(var f=ac(c,e.start),g=0;g<e.size-3;g++){var h=f.getUint32(g);h==1633889587?f.setUint32(g,1700998451):h==1684103987&&f.setUint32(g,1684366131)}}).parse(c);return c};function wj(a,b,c,d,e,f,g,h){this.P=a;this.startByte=b;this.endByte=c;this.xd=d===void 0?null:d;this.timescale=e===void 0?null:e;this.h=f===void 0?null:f;this.aesKey=g===void 0?null:g;this.g=this.mimeType=this.codecs=null;this.encrypted=h===void 0?!1:h}wj.prototype.Jc=function(){return this.startByte};wj.prototype.Hc=function(){return this.endByte};wj.prototype.ue=function(a){this.h=a};wj.prototype.$b=function(){return this.h};
function xj(a,b){return a===b?!0:a&&b?a.Jc()==b.Jc()&&a.Hc()==b.Hc()&&ib(a.P().sort(),b.P().sort())&&Ub(a.$b(),b.$b()):a==b}T("shaka.media.InitSegmentReference",wj);wj.prototype.getEndByte=wj.prototype.Hc;wj.prototype.getStartByte=wj.prototype.Jc;
function yj(a,b,c,d,e,f,g,h,k,l,m,n,q,r,t,v){l=l===void 0?[]:l;r=r===void 0?zj:r;this.startTime=a;this.j=this.endTime=b;this.C=c;this.startByte=d;this.endByte=e;this.ea=f;this.timestampOffset=g;this.appendWindowStart=h;this.appendWindowEnd=k;this.g=l;this.tilesLayout=m===void 0?"":m;this.B=n===void 0?null:n;this.h=q===void 0?null:q;this.status=r;this.preload=!1;this.l=!0;this.o=!1;this.aesKey=t===void 0?null:t;this.thumbnailSprite=null;this.i=-1;this.m=v===void 0?!1:v;this.je=this.Xc=!1;a=u(this.g);
for(b=a.next();!b.done;b=a.next())b.value.Ai();this.m&&this.g.length&&this.g[this.g.length-1].zi();this.u=this.bandwidth=this.mimeType=this.codecs=null;this.F=!1}p=yj.prototype;p.P=function(){return this.C()};p.getStartTime=function(){return this.startTime};p.Kj=function(){return this.endTime};p.Jc=function(){return this.startByte};p.Hc=function(){return this.endByte};
function Aj(a){if(a.endByte)return a.endByte+1-a.startByte;if(a.bandwidth){var b=a.bandwidth*(a.endTime-a.startTime);if(!isNaN(b)&&b>0)return b}if(a.g.length>0&&a.m)for(a=u(a.g),a=a.next();!a.done;a=a.next()){Aj(a.value);break}return null}p.ek=function(){return this.tilesLayout};p.dk=function(){return this.B};p.Kc=function(){return this.status};p.Ak=function(){this.status=Bj};p.Ug=function(){this.preload=!0};p.isPreload=function(){return this.preload};p.wd=function(){this.l=!1};p.qk=function(){return this.l};
p.Ai=function(){this.Xc=!0};p.tk=function(){return this.Xc};p.zi=function(){this.je=!0};p.rk=function(){return this.je};p.xi=function(){this.o=!0};p.kk=function(){return this.o};p.Mf=function(a){this.thumbnailSprite=a};p.bk=function(){return this.thumbnailSprite};p.offset=function(a){this.startTime+=a;this.endTime+=a;this.j+=a;for(var b=u(this.g),c=b.next();!c.done;c=b.next())c=c.value,c.startTime+=a,c.endTime+=a,c.j+=a};
p.Dh=function(a){this.h==null?Za("Sync attempted without sync time!"):(a=this.h-a-this.startTime,Math.abs(a)>=.001&&this.offset(a))};p.ue=function(a,b){this.u=a;this.F=b===void 0?!1:b};p.$b=function(a){var b=this.u;(a===void 0||a)&&this.F&&(this.u=null);return b};function Cj(a,b){a.ea=b;a=u(a.g);for(var c=a.next();!c.done;c=a.next())Cj(c.value,b)}T("shaka.media.SegmentReference",yj);yj.prototype.getSegmentData=yj.prototype.$b;yj.prototype.setSegmentData=yj.prototype.ue;yj.prototype.syncAgainst=yj.prototype.Dh;
yj.prototype.offset=yj.prototype.offset;yj.prototype.getThumbnailSprite=yj.prototype.bk;yj.prototype.setThumbnailSprite=yj.prototype.Mf;yj.prototype.hasByterangeOptimization=yj.prototype.kk;yj.prototype.markAsByterangeOptimization=yj.prototype.xi;yj.prototype.isLastPartial=yj.prototype.rk;yj.prototype.markAsLastPartial=yj.prototype.zi;yj.prototype.isPartial=yj.prototype.tk;yj.prototype.markAsPartial=yj.prototype.Ai;yj.prototype.isIndependent=yj.prototype.qk;yj.prototype.markAsNonIndependent=yj.prototype.wd;
yj.prototype.isPreload=yj.prototype.isPreload;yj.prototype.markAsPreload=yj.prototype.Ug;yj.prototype.markAsUnavailable=yj.prototype.Ak;yj.prototype.getStatus=yj.prototype.Kc;yj.prototype.getTileDuration=yj.prototype.dk;yj.prototype.getTilesLayout=yj.prototype.ek;yj.prototype.getEndByte=yj.prototype.Hc;yj.prototype.getStartByte=yj.prototype.Jc;yj.prototype.getEndTime=yj.prototype.Kj;yj.prototype.getStartTime=yj.prototype.getStartTime;yj.prototype.getUris=yj.prototype.P;var zj=0,Bj=1;
yj.Status={vl:zj,Am:Bj,Wl:2};function Dj(a){return a.length==1&&a.end(0)-a.start(0)<1E-4}function Ej(a){return!a||Dj(a)?null:a.length==1&&a.start(0)<0?0:a.length?a.start(0):null}function Fj(a){return!a||Dj(a)?null:a.length?a.end(a.length-1):null}function Gj(a,b){return!a||!a.length||Dj(a)||b>a.end(a.length-1)?!1:b>=a.start(0)}function Hj(a,b){if(!a||!a.length||Dj(a))return 0;var c=0;a=u(Ij(a));for(var d=a.next();!d.done;d=a.next()){var e=d.value;d=e.start;e=e.end;e>b&&(c+=e-Math.max(d,b))}return c}
function Jj(a,b,c){if(!a||!a.length||Dj(a))return null;a=Ij(a).findIndex(function(d,e,f){return d.start>b&&(e==0||f[e-1].end-b<=c)});return a>=0?a:null}function Ij(a){if(!a)return[];for(var b=[],c=0;c<a.length;c++)b.push({start:a.start(c),end:a.end(c)});return b};function Kj(){}function Lj(a,b){var c=document.createElement("source");c.src=a;c.type=b===void 0?"":b;return c}function Mj(a){for(var b=!1,c=a.getElementsByTagName("source"),d=c.length-1;d>=0;--d)a.removeChild(c[d]),b=!0;a.src&&(a.removeAttribute("src"),b=!0);return b}function Nj(a){for(;a.firstChild;)a.removeChild(a.firstChild)}
function Xc(){if(Oj)return Oj;Pj||(Pj=new rf(function(){Oj=null}));(Oj=document.getElementsByTagName("video")[0]||document.getElementsByTagName("audio")[0])||(Oj=document.createElement("video"));Pj.ka(1);return Oj}
function Qj(a,b){var c,d,e,f,g;return O(function(h){if(h.g==1)return"fonts"in document&&"FontFace"in window?G(h,document.fonts.ready,2):h.return();if(!("entries"in document.fonts))return h.return();c=function(k){k=k.entries();for(var l=[],m=k.next();m.done===!1;)l.push(m.value),m=k.next();return l};d=u(c(document.fonts));for(e=d.next();!e.done;e=d.next())if(f=e.value,f.family===a&&f.display==="swap")return h.return();g=new FontFace(a,"url("+b+")",{display:"swap"});document.fonts.add(g);H(h)})}
T("shaka.util.Dom",Kj);Kj.removeAllChildren=Nj;Kj.clearSourceFromVideo=Mj;var Pj=null,Oj=null;/*
 @license
 Shaka Player
 Copyright 2022 Google LLC
 SPDX-License-Identifier: Apache-2.0
*/
function Uj(){}function Vj(a,b){return b+10<=a.length&&a[b]===73&&a[b+1]===68&&a[b+2]===51&&a[b+3]<255&&a[b+4]<255&&a[b+6]<128&&a[b+7]<128&&a[b+8]<128&&a[b+9]<128?!0:!1}function Wj(a,b){return b+10<=a.length&&a[b]===51&&a[b+1]===68&&a[b+2]===73&&a[b+3]<255&&a[b+4]<255&&a[b+6]<128&&a[b+7]<128&&a[b+8]<128&&a[b+9]<128?!0:!1}function Xj(a,b){var c=(a[b]&127)<<21;c|=(a[b+1]&127)<<14;c|=(a[b+2]&127)<<7;return c|=a[b+3]&127}
function Yj(a){var b={key:a.type,description:"",data:"",mimeType:null,pictureType:null};if(a.type==="APIC"){if(a.size<2||a.data[0]!==3)return null;var c=a.data.subarray(1).indexOf(0);if(c===-1)return null;var d=oc(Wb(a.data,1,c)),e=a.data[2+c],f=a.data.subarray(3+c).indexOf(0);if(f===-1)return null;var g=oc(Wb(a.data,3+c,f)),h;d==="--\x3e"?h=oc(Wb(a.data,4+c+f)):h=Yb(a.data.subarray(4+c+f));b.mimeType=d;b.pictureType=e;b.description=g;b.data=h;return b}if(a.type==="TXXX"){if(a.size<2||a.data[0]!==
3)return null;d=a.data.subarray(1).indexOf(0);if(d===-1)return null;c=oc(Wb(a.data,1,d));a=oc(Wb(a.data,2+d)).replace(/\0*$/,"");b.description=c;b.data=a;return b}if(a.type==="WXXX"){if(a.size<2||a.data[0]!==3)return null;d=a.data.subarray(1).indexOf(0);if(d===-1)return null;c=oc(Wb(a.data,1,d));a=oc(Wb(a.data,2+d)).replace(/\0*$/,"");b.description=c;b.data=a;return b}if(a.type==="PRIV"){if(a.size<2)return null;c=a.data.indexOf(0);if(c===-1)return null;c=oc(Wb(a.data,0,c));b.description=c;c=="com.apple.streaming.transportStreamTimestamp"?
(c=a.data.subarray(c.length+1),a=c[3]&1,c=(c[4]<<23)+(c[5]<<15)+(c[6]<<7)+c[7],c/=45,a&&(c+=4.772185884E7),b.data=c):(a=Yb(a.data.subarray(c.length+1)),b.data=a);return b}if(a.type[0]==="T"){if(a.size<2||a.data[0]!==3)return null;a=oc(a.data.subarray(1)).replace(/\0*$/,"");b.data=a;return b}return a.type[0]==="W"?(a=oc(a.data).replace(/\0*$/,""),b.data=a,b):a.data?(b.data=Yb(a.data),b):null}
function Zj(a){for(var b=0,c=[];Vj(a,b);){var d=Xj(a,b+6);a[b+5]>>6&1&&(b+=10);b+=10;for(d=b+d;b+10<d;){var e=a.subarray(b),f=Xj(e,4);e={type:String.fromCharCode(e[0],e[1],e[2],e[3]),size:f,data:e.subarray(10,10+f)};(f=Yj(e))&&c.push(f);b+=e.size+10}Wj(a,b)&&(b+=10)}return c}function ak(a,b){for(var c=b=b===void 0?0:b,d=0;Vj(a,b);)a[b+5]>>6&1&&(d+=10),d+=10,d+=Xj(a,b+6),Wj(a,b+10)&&(d+=10),b+=d;return d>0?a.subarray(c,c+d):new Uint8Array([])}T("shaka.util.Id3Utils",Uj);Uj.getID3Data=ak;
Uj.getID3Frames=Zj;function bk(a){return(new Date(Date.UTC(1900,0,1,0,0,0,0)+a)).getTime()};/*

 Copyright Brightcove, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/
function ck(a,b){this.j=a;if(b===void 0?0:b){b=new Uint8Array(a.byteLength);for(var c=0,d=0;d<a.byteLength;d++)d>=2&&a[d]==3&&a[d-1]==0&&a[d-2]==0||(b[c]=a[d],c++);this.j=Wb(b,0,c)}this.i=this.j.byteLength;this.g=this.h=0}function dk(a){var b=a.j.byteLength-a.i,c=new Uint8Array(4),d=Math.min(4,a.i);d!==0&&(c.set(a.j.subarray(b,b+d)),a.h=(new mh(c,0)).U(),a.g=d*8,a.i-=d)}function ek(a,b){if(a.g<=b){b-=a.g;var c=Math.floor(b/8);b-=c*8;a.g-=c;dk(a)}a.h<<=b;a.g-=b}
function fk(a,b){var c=Math.min(a.g,b),d=a.h>>>32-c;a.g-=c;a.g>0?a.h<<=c:a.i>0&&dk(a);c=b-c;return c>0?d<<c|fk(a,c):d}function gk(a){var b;for(b=0;b<a.g;++b)if((a.h&2147483648>>>b)!==0)return a.h<<=b,a.g-=b,b;dk(a);return b+gk(a)}function hk(a){ek(a,1+gk(a))}function W(a){var b=gk(a);return fk(a,b+1)-1}function ik(a){a=W(a);return 1&a?1+a>>>1:-1*(a>>>1)}function jk(a){return fk(a,1)===1}function kk(a){return fk(a,8)}
function lk(a,b){for(var c=8,d=8,e=0;e<b;e++)d!==0&&(d=ik(a),d=(c+d+256)%256),c=d===0?c:d}function mk(a){kk(a);W(a);return W(a)}T("shaka.util.ExpGolomb",ck);function nk(){this.I=null;this.J=!1;this.m=this.K=null;this.j=[];this.g=[];this.C=this.F=null;this.i=[];this.h=[];this.G=null;this.l=[];this.B=this.H=this.o=this.u=null}p=nk.prototype;p.clearData=function(){this.j=[];this.g=[];this.i=[];this.h=[];this.l=[]};p.Kf=function(a){this.B!=null&&this.B!=a&&(this.o=this.u=null);this.B=a};
p.parse=function(a){if(a.length<564)return this;for(var b=Math.max(0,ok(a)),c=a.length-(a.length+b)%188,d=!1,e=b;e<c;e+=188)if(a[e]==71){var f=!!(a[e+1]&64),g=((a[e+1]&31)<<8)+a[e+2];if((a[e+3]&48)>>4>1){var h=e+5+a[e+4];if(h==e+188)continue}else h=e+4;switch(g){case 0:f&&(h+=a[h]+1);this.I=(a[h+10]&31)<<8|a[h+11];break;case 17:case 8191:break;case this.I:f&&(h+=a[h]+1);f=a;g={audio:-1,video:-1,gf:-1,audioCodec:"",videoCodec:""};var k=h+3+((f[h+1]&15)<<8|f[h+2])-4;for(h+=12+((f[h+10]&15)<<8|f[h+11]);h<
k;){var l=(f[h+1]&31)<<8|f[h+2],m=(f[h+3]&15)<<8|f[h+4];switch(f[h]){case 6:if(m>0)for(var n=h+5,q=m;q>2;){var r=f[n+1]+2;switch(f[n]){case 5:var t=f.subarray(n+2,n+r);t=rc.value()(t);g.audio==-1&&t==="Opus"?(g.audio=l,g.audioCodec="opus"):g.video==-1&&t==="AV01"&&(g.video=l,g.videoCodec="av1");break;case 106:g.audio==-1&&(g.audio=l,g.audioCodec="ac3");break;case 122:g.audio==-1&&(g.audio=l,g.audioCodec="ec3");break;case 124:g.audio==-1&&(g.audio=l,g.audioCodec="aac");break;case 127:g.audioCodec==
"opus"&&(t=null,f[n+2]===128&&(t=f[n+3]),t!=null&&(this.H={channelCount:(t&15)===0?2:t&15,uj:t,sampleRate:48E3}))}n+=r;q-=r}break;case 15:g.audio==-1&&(g.audio=l,g.audioCodec="aac");break;case 17:g.audio==-1&&(g.audio=l,g.audioCodec="aac-loas");break;case 21:g.gf==-1&&(g.gf=l);break;case 27:g.video==-1&&(g.video=l,g.videoCodec="avc");break;case 3:case 4:g.audio==-1&&(g.audio=l,g.audioCodec="mp3");break;case 36:g.video==-1&&(g.video=l,g.videoCodec="hvc");break;case 129:g.audio==-1&&(g.audio=l,g.audioCodec=
"ac3");break;case 132:case 135:g.audio==-1&&(g.audio=l,g.audioCodec="ec3")}h+=m+5}f=g;f.video!=-1&&(this.K=f.video,this.m=f.videoCodec);f.audio!=-1&&(this.F=f.audio,this.C=f.audioCodec);f.gf!=-1&&(this.G=f.gf);d&&!this.J&&(d=!1,e=b-188);this.J=!0;break;case this.K:h=a.subarray(h,e+188);f?this.j.push([h]):this.j.length&&this.j[this.j.length-1]&&this.j[this.j.length-1].push(h);break;case this.F:h=a.subarray(h,e+188);f?this.i.push([h]):this.i.length&&this.i[this.i.length-1]&&this.i[this.i.length-1].push(h);
break;case this.G:h=a.subarray(h,e+188);f?this.l.push([h]):this.l.length&&this.l[this.l.length-1]&&this.l[this.l.length-1].push(h);break;default:d=!0}}return this};
function pk(a,b){if((b[0]<<16|b[1]<<8|b[2])!==1)return null;var c={data:new Uint8Array(0),packetLength:b[4]<<8|b[5],pts:null,dts:null,nalus:[]};if(c.packetLength&&c.packetLength>b.byteLength-6)return null;var d=b[7];if(d&192){var e=(b[9]&14)*536870912+(b[10]&255)*4194304+(b[11]&254)*16384+(b[12]&255)*128+(b[13]&254)/2;a.u==null&&(a.u=e);c.pts=qk(e,a.u);a.u=c.pts;c.dts=c.pts;d&64&&(d=(b[14]&14)*536870912+(b[15]&255)*4194304+(b[16]&254)*16384+(b[17]&255)*128+(b[18]&254)/2,a.o==null&&(a.o=d),c.dts=c.pts!=
e?qk(d,a.o):d);a.o=c.dts}a=b[8]+9;if(b.byteLength<=a)return null;c.data=b.subarray(a);return c}p.Hk=function(a){yb("TsParser.parseAvcNalus","Please use parseNalus function instead.");return this.$g(a,{le:null,state:null})};
p.$g=function(a,b){var c=a.pts?a.pts/9E4:null;a=a.data;var d=a.byteLength,e=1;this.m=="hvc"&&(e=2);var f=b.state||0,g=f,h=0,k=[],l=-1,m=0;f==-1&&(l=0,m=this.m=="hvc"?a[0]>>1&63:a[0]&31,f=0,h=1);for(;h<d;){var n=a[h++];if(f)if(f===1)f=n?0:2;else if(n)if(n==1){n=h-f-1;if(l>=0)k.push({data:a.subarray(l+e,n),fullData:a.subarray(l,n),type:m,time:c,state:null});else if(f=k.length?k[k.length-1]:b.le)g&&h<=4-g&&f.state&&(f.data=f.data.subarray(0,f.data.byteLength-g),f.fullData=f.fullData.subarray(0,f.fullData.byteLength-
g)),n>0&&(n=a.subarray(0,n),f.data=Dc(f.data,n),f.fullData=Dc(f.fullData,n),f.state=0);h<d?(m=this.m=="hvc"?a[h]>>1&63:a[h]&31,l=h,f=0):f=-1}else f=0;else f=3;else f=n?0:1}l>=0&&f>=0&&k.push({data:a.subarray(l+e,d),fullData:a.subarray(l,d),type:m,time:c,state:f});!k.length&&b.le&&(c=k.length?k[k.length-1]:b.le)&&(c.data=Dc(c.data,a),c.fullData=Dc(c.fullData,a));b.state=f;return k};
p.getMetadata=function(){for(var a=[],b=u(this.l),c=b.next();!c.done;c=b.next())c=Dc.apply(xc,x(c.value)),(c=pk(this,c))&&a.push({cueTime:c.pts?c.pts/9E4:null,data:c.data,frames:Zj(c.data),dts:c.dts,pts:c.pts});return a};
p.ub=function(){if(this.i.length&&!this.h.length)for(var a=u(this.i),b=a.next();!b.done;b=a.next()){var c=Dc.apply(xc,x(b.value)),d=pk(this,c);b=this.h.length?this.h[this.h.length-1]:null;d&&d.pts!=null&&d.dts!=null&&(!b||b.pts!=d.pts&&b.dts!=d.dts)?this.h.push(d):this.h.length&&(c=d?d.data:c)&&(b=this.h.pop(),b.data=Dc(b.data,c),this.h.push(b))}return this.h};
p.ud=function(a){a=a===void 0?!0:a;if(this.j.length&&!this.g.length){for(var b=u(this.j),c=b.next();!c.done;c=b.next()){var d=Dc.apply(xc,x(c.value)),e=pk(this,d);c=this.g.length?this.g[this.g.length-1]:null;e&&e.pts!=null&&e.dts!=null&&(!c||c.pts!=e.pts&&c.dts!=e.dts)?this.g.push(e):this.g.length&&(d=e?e.data:d)&&(c=this.g.pop(),c.data=Dc(c.data,d),this.g.push(c))}if(a){b={le:null,state:null};c=[];d=u(this.g);for(e=d.next();!e.done;e=d.next())e=e.value,e.nalus=this.$g(e,b),e.nalus.length&&(c.push(e),
b.le=e.nalus[e.nalus.length-1]);this.g=c}}return a?this.g:(a=this.g,this.g=[],a)};p.getStartTime=function(a){if(a=="audio"){a=null;var b=this.ub();b.length&&(a=b[0],a=Math.min(a.dts,a.pts)/9E4);return a}return a=="video"?(a=null,b=this.ud(!1),b.length&&(a=b[0],a=Math.min(a.dts,a.pts)/9E4),a):null};p.Yd=function(){return{audio:this.C,video:this.m}};p.ef=function(){for(var a=[],b=u(this.ud()),c=b.next();!c.done;c=b.next())a.push.apply(a,x(c.value.nalus));return a};
p.hk=function(){yb("TsParser.getVideoResolution","Please use getVideoInfo function instead.");var a=this.Ng();return{height:a.height,width:a.width}};p.Ng=function(){return this.m=="hvc"?rk(this):sk(this)};function tk(a){var b=a.ud();return b.length>1&&(a=b[0].pts,b=b[1].pts,!isNaN(b-a))?String(Math.abs(1/(b-a)*9E4)):null}
function sk(a){var b={height:null,width:null,codec:null,frameRate:null},c=a.ef();if(!c.length)return b;c=c.find(function(r){return r.type==7});if(!c)return b;c=new ck(c.data);var d=kk(c),e=kk(c),f=kk(c);hk(c);if(uk.includes(d)){var g=W(c);g===3&&ek(c,1);hk(c);hk(c);ek(c,1);if(jk(c)){g=g!==3?8:12;for(var h=0;h<g;h++)jk(c)&&(h<6?lk(c,16):lk(c,64))}}hk(c);g=W(c);if(g===0)W(c);else if(g===1)for(ek(c,1),hk(c),hk(c),g=W(c),h=0;h<g;h++)hk(c);hk(c);ek(c,1);g=W(c);h=W(c);var k=fk(c,1);k===0&&ek(c,1);ek(c,
1);var l=0,m=0,n=0,q=0;jk(c)&&(l=W(c),m=W(c),n=W(c),q=W(c));b.height=String((2-k)*(h+1)*16-n*2-q*2);b.width=String((g+1)*16-l*2-m*2);b.codec="avc1."+("0"+d.toString(16).toUpperCase()).slice(-2)+("0"+e.toString(16).toUpperCase()).slice(-2)+("0"+f.toString(16).toUpperCase()).slice(-2);b.frameRate=tk(a);return b}
function rk(a){var b={height:null,width:null,codec:null,frameRate:null},c=a.ef();if(!c.length)return b;c=c.find(function(I){return I.type==33});if(!c)return b;var d=new ck(c.fullData,!0);kk(d);kk(d);fk(d,4);var e=fk(d,3);jk(d);var f=fk(d,2),g=fk(d,1),h=fk(d,5),k=fk(d,32);c=kk(d);for(var l=kk(d),m=kk(d),n=kk(d),q=kk(d),r=kk(d),t=kk(d),v=[],w=[],z=0;z<e;z++)v.push(jk(d)),w.push(jk(d));if(e>0)for(z=e;z<8;z++)fk(d,2);for(z=0;z<e;z++)v[z]&&fk(d,88),w[z]&&kk(d);W(d);e=W(d);e==3&&fk(d,1);v=W(d);w=W(d);var y=
z=0,A=0,E=0;jk(d)&&(z+=W(d),y+=W(d),A+=W(d),E+=W(d));b.width=String(v-(z+y)*(e===1||e===2?2:1));b.height=String(w-(A+E)*(e===1?2:1));d=function(I){for(var D=0,C=0;C<32;C++)D|=(I>>C&1)<<31-C;return D>>>0}(k);g=g==1?"H":"L";f="hvc1"+("."+["","A","B","C"][f]+h);f+="."+d.toString(16).toUpperCase();f+="."+g+t;r&&(f+="."+r.toString(16).toUpperCase());q&&(f+="."+q.toString(16).toUpperCase());n&&(f+="."+n.toString(16).toUpperCase());m&&(f+="."+m.toString(16).toUpperCase());l&&(f+="."+l.toString(16).toUpperCase());
c&&(f+="."+c.toString(16).toUpperCase());b.codec=f;b.frameRate=tk(a);return b}function qk(a,b){var c=1;for(a>b&&(c=-1);Math.abs(b-a)>4294967296;)a+=c*8589934592;return a}function vk(a){return ok(a)<0?!1:!0}function ok(a){for(var b=Math.min(1E3,a.length-564),c=0;c<b;){if(a[c]==71&&a[c+188]==71&&a[c+376]==71)return c;c++}return-1}T("shaka.util.TsParser",nk);nk.syncOffset=ok;nk.probe=vk;nk.prototype.getVideoInfo=nk.prototype.Ng;nk.prototype.getVideoResolution=nk.prototype.hk;
nk.prototype.getVideoNalus=nk.prototype.ef;nk.prototype.getCodecs=nk.prototype.Yd;nk.prototype.getStartTime=nk.prototype.getStartTime;nk.prototype.getVideoData=nk.prototype.ud;nk.prototype.getAudioData=nk.prototype.ub;nk.prototype.getMetadata=nk.prototype.getMetadata;nk.prototype.parseNalus=nk.prototype.$g;nk.prototype.parseAvcNalus=nk.prototype.Hk;nk.prototype.parse=nk.prototype.parse;nk.prototype.setDiscontinuitySequence=nk.prototype.Kf;nk.prototype.clearData=nk.prototype.clearData;
nk.Timescale=9E4;var uk=[100,110,122,244,44,83,86,118,128,138,139,134];function wk(a,b,c,d,e){var f=this;this.g=a;this.O=c;this.B=d;this.ba=b;this.l=new Map;this.G=new Map;this.Ta=new Map;this.h=null;this.Fa=!1;this.C=e||null;this.o=new Map;this.u=new kb;this.j=new Map;this.K=null;this.M=new Hg;this.Da="";this.ob=!1;this.za=!0;this.N=!1;this.F=this.R=null;this.i=xk(this,this.M);this.Ua=this.H=!1;this.I=new gh(function(){return yk(f)});this.J=!1;this.X="UNKNOWN";this.eb=this.kb=!1;this.ab=new Hg;this.m=!1;this.ya=null;this.$=new Map;this.oa=this.T=this.va=this.V=null;
this.ma=new Hg;this.g.remote&&(this.N=this.g.remote.state!="disconnected",this.u.D(this.g.remote,"connect",function(){f.N=f.g.remote.state!="disconnected"}),this.u.D(this.g.remote,"connecting",function(){f.N=f.g.remote.state!="disconnected"}),this.u.D(this.g.remote,"disconnect",function(){f.N=f.g.remote.state!="disconnected"}))}
function xk(a,b){a.za=!0;if(window.ManagedMediaSource){a.F||(a.g.disableRemotePlayback=!0);var c=new ManagedMediaSource;a.u.D(c,"startstreaming",function(){a.za=!0});a.u.D(c,"endstreaming",function(){a.za=!1})}else c=new MediaSource;a.u.Aa(c,"sourceopen",function(){URL.revokeObjectURL(a.Da);b.resolve()});a.u.Aa(a.g,"playing",function(){a.ob=!0});a.Da=zk(c);a.B.useSourceElements?(a.g.removeAttribute("src"),a.R&&a.g.removeChild(a.R),a.F&&a.g.removeChild(a.F),a.R=Lj(a.Da),a.g.appendChild(a.R),a.F&&a.g.appendChild(a.F),
a.g.load()):a.g.src=a.Da;return c}function Ak(a,b,c){a.g&&window.ManagedMediaSource&&a.i&&a.B.useSourceElements&&(a.F&&a.g.removeChild(a.F),a.F=Lj(b,c),a.g.appendChild(a.F),a.g.disableRemotePlayback=!1)}
function Bk(){var a='video/mp4; codecs="avc1.42E01E",video/mp4; codecs="avc3.42E01E",video/mp4; codecs="hev1.1.6.L93.90",video/mp4; codecs="hvc1.1.6.L93.90",video/mp4; codecs="hev1.2.4.L153.B0"; eotf="smpte2084",video/mp4; codecs="hvc1.2.4.L153.B0"; eotf="smpte2084",video/mp4; codecs="hvc1.2.20000000.L153.B0",video/mp4; codecs="hvc1.2.4.L120.b0",video/mp4; codecs="hvc1.2.4.L123.b0",video/mp4; codecs="vp9",video/mp4; codecs="vp09.00.10.08",video/mp4; codecs="av01.0.01M.08",video/mp4; codecs="av01.0.31M.10.0.111.09.16.09.0",video/mp4; codecs="av01.0.31M.10.0.112.09.18.09.0",video/mp4; codecs="dvh1.05.01",video/mp4; codecs="dvh1.08.01",video/mp4; codecs="dav1.10.01",video/mp4; codecs="dvh1.20.01",audio/mp4; codecs="mp4a.40.2",audio/mp4; codecs="ac-3",audio/mp4; codecs="ec-3",audio/mp4; codecs="ac-4.02.01.03",audio/mp4; codecs="opus",audio/mp4; codecs="flac",audio/mp4; codecs="dtsc",audio/mp4; codecs="dtse",audio/mp4; codecs="dtsx",audio/mp4; codecs="apac.31.00",video/webm; codecs="vp8",video/webm; codecs="vp9",video/webm; codecs="vp09.00.10.08",audio/webm; codecs="vorbis",audio/webm; codecs="opus",video/mp2t; codecs="avc1.42E01E",video/mp2t; codecs="avc3.42E01E",video/mp2t; codecs="hvc1.1.6.L93.90",video/mp2t; codecs="mp4a.40.2",video/mp2t; codecs="ac-3",video/mp2t; codecs="ec-3",text/vtt,application/mp4; codecs="wvtt",application/ttml+xml,application/mp4; codecs="stpp"'.split(",").concat(x(Te)),b=
{};rb();a=u(a);for(var c=a.next();!c.done;c=a.next()){c=c.value;if(hf(c))b[c]=!0;else if(Wc()){var d=af(c),e=ag(bf(c),d);d=Se(d,e);b[c]=Fi(d)||(Me(d)?!0:!1)}else b[c]=Xc().canPlayType(c)!="";d=c.split(";")[0];b[d]=b[d]||b[c]}return b}p=wk.prototype;p.destroy=function(){return this.I.destroy()};
function yk(a){var b,c,d,e,f,g,h,k,l,m,n,q,r,t,v;return O(function(w){if(w.g==1){b=[];c=u(a.o);for(d=c.next();!d.done;d=c.next())for(e=d.value,f=u(e),g=f.next().value,h=f.next().value,k=h[0],l=g,a.o.set(l,h.slice(0,1)),k&&b.push(k.p.catch(tf)),m=u(h.slice(1)),n=m.next();!n.done;n=m.next())q=n.value,q.p.reject(new U(2,7,7003,void 0));a.h&&b.push(a.h.destroy());return G(w,Promise.all(b),2)}r=u(a.j.values());for(t=r.next();!t.done;t=r.next())v=t.value,v.destroy();a.u&&(a.u.release(),a.u=null);a.g&&a.F&&
a.g.removeChild(a.F);a.g&&a.R&&(a.g.removeChild(a.R),a.g.load(),a.g.disableRemotePlayback=!1);a.g=null;a.R=null;a.F=null;a.B=null;a.i=null;a.h=null;a.ba=null;a.l.clear();a.Ta.clear();a.j.clear();a.K=null;a.o.clear();a.C=null;a.$.clear();a.O=null;H(w)})}
p.init=function(a,b,c,d){b=b===void 0?!1:b;c=c===void 0?"UNKNOWN":c;d=d===void 0?!1:d;var e=this,f,g,h,k,l,m;return O(function(n){if(n.g==1)return f=Mc,G(n,e.M,2);if(n.g!=3){if(!Ik(e)&&!Jk(e))return n.A(3);Za("Expected MediaSource to be open during init(); reopening the media source.");e.M=new Hg;e.i=xk(e,e.M);return G(n,e.M,3)}e.J=b;e.X=c;e.kb=d;e.eb=!e.J&&e.X=="HLS"&&!e.kb;e.$.clear();e.V=null;e.va=null;e.T=null;e.oa=null;e.ma=new Hg;g=u(a.keys());for(h=g.next();!h.done;h=g.next())k=h.value,l=a.get(k),
Kk(e,k,l,l.codecs),e.m?(e.o.set(f.aa,[]),e.o.set(f.wa,[])):e.o.set(k,[]);(m=a.get(f.aa))&&m.isAudioMuxedInVideo&&(e.m=!0);H(n)})};
function Kk(a,b,c,d){b=="audio"&&d&&(d=ag(d,c.mimeType));var e=Se(c.mimeType,d);if(b==Kc)Lk(a,e,a.J,c.external);else{var f=a.B.forceTransmux;if(!Fi(e)||!a.J&&Te.includes(e))f=!0;var g=Ue(c.mimeType,d);if(f){f=Ic("audio",(d||"").split(","));d=Ic("video",(d||"").split(","));if(f&&d){a.m=!0;Kk(a,"audio",c,f);Kk(a,"video",c,d);return}if(d=Me(g))e=d(),a.j.set(b,e),e=e.convertCodecs(b,g)}g=e+a.B.addExtraFeaturesToSourceBuffer(e);hh(a.I);try{var h=a.i.addSourceBuffer(g)}catch(k){throw new U(2,3,3015,k,"The mediaSource_ status was "+
a.i.readyState+" expected 'open'",null);}a.J&&(h.mode=Mk);a.u.D(h,"error",function(){var k=a.o.get(b)[0];k.p.reject(new U(2,3,3014,a.g.error?a.g.error.code:0,k.uri))});a.u.D(h,"updateend",function(){return Nk(a,b)});a.l.set(b,h);a.G.set(b,e);a.Ta.set(b,!!c.drmInfos.length)}}p.configure=function(a){this.B=a;this.h&&(this.h.B=a.modifyCueCallback)};function Ok(a){return a.za&&!a.N&&!a.H}
function Lk(a,b,c,d){a.h||(a.h=new df(a.ba),a.h&&(a.h.B=a.B.modifyCueCallback));var e=a.h;d=d||a.Fa;a=a.X;b=="application/cea-608"||b=="application/cea-708"?e.i=null:(e.i=ff.get(b)(),e.i.setSequenceMode?e.i.setSequenceMode(c):yb("Text parsers w/ setSequenceMode",'Text parsers should have a "setSequenceMode" method!'),e.i.setManifestType?e.i.setManifestType(a):yb("Text parsers w/ setManifestType",'Text parsers should have a "setManifestType" method!'),e.C=d)}
function Ik(a){return a.H?!1:a.i?a.i.readyState=="ended":!0}function Jk(a){return a.H?!1:a.i?a.i.readyState=="closed":!0}function Pk(a,b){return a.l.size?b==Kc?a.h.g:Ej(Qk(a,b)):null}function Rk(a,b){return a.l.size?b==Kc?a.h.h:Fj(Qk(a,b)):null}function Sk(a,b,c){if(b==Kc)return a=a.h,a.h==null||a.h<c?0:a.h-Math.max(c,a.g);a=Qk(a,b);return Hj(a,c)}
p.Gc=function(){var a={total:this.H?[]:Ij(this.g.buffered),audio:Ij(Qk(this,"audio")),video:Ij(Qk(this,"video")),text:[]};if(this.h){var b=this.h.g,c=this.h.h;b!=null&&c!=null&&a.text.push({start:b,end:c})}return a};function Qk(a,b){if(a.H||a.N||Jk(a))return null;try{return a.l.get(b).buffered}catch(c){return a.l.has(b),null}}
function Tk(a,b,c,d,e,f,g){g=g===void 0?!1:g;var h=null,k=[],l=Wb(c);if(Te.includes(f))c=Zj(l),c.length&&d&&((g=c.find(function(t){return t.description==="com.apple.streaming.transportStreamTimestamp"}))&&typeof g.data=="number"&&(h=Math.round(g.data)/1E3),a.O.onMetadata([{cueTime:d.startTime,data:l,frames:c,dts:d.startTime,pts:d.startTime}],0,d.endTime));else if(f.includes("/mp4")&&d&&d.ea){l=new ph;var m=e.emsgSchemeIdUris!=null&&e.emsgSchemeIdUris.length>0||a.B.dispatchAllEmsgBoxes;m&&l.S("emsg",
function(t){var v=e.emsgSchemeIdUris;if(t.version===0){var w=t.reader.Yc();var z=t.reader.Yc();var y=t.reader.U();var A=t.reader.U();var E=t.reader.U();var I=t.reader.U();var D=d.startTime+A/y}else y=t.reader.U(),D=t.reader.Ed()/y+d.timestampOffset,A=D-d.startTime,E=t.reader.U(),I=t.reader.U(),w=t.reader.Yc(),z=t.reader.Yc();t=t.reader.Tb(t.reader.getLength()-t.reader.Pa(),!0);if(v&&v.includes(w)||a.B.dispatchAllEmsgBoxes)if(w=="urn:mpeg:dash:event:2012")a.O.Gk();else if(v=D+E/y,a.O.Ek({startTime:D,
endTime:v,schemeIdUri:w,value:z,timescale:y,presentationTimeDelta:A,eventDuration:E,id:I,messageData:t}),w=="https://aomedia.org/emsg/ID3"||w=="https://developer.apple.com/streaming/emsg-id3")if(y=Zj(t),y.length)a.O.onMetadata([{cueTime:D,data:t,frames:y,dts:D,pts:D}],0,v)});var n=d.ea.timescale;b=n&&!isNaN(n);var q=0,r=!1;b&&l.S("prft",function(t){var v=t.reader,w=t.version;v.U();t=v.U();var z=v.U();t=t*1E3+z/4294967296*1E3;w===0?v=v.U():(w=v.U(),v=v.U(),v=w*4294967296+v);t=bk(t);v=(new Map).set("detail",
{wallClockTime:t,programStartDate:new Date(t-v/n*1E3)});v=new V("prft",v);a.O.onEvent(v)}).box("moof",uh).box("traf",uh).S("tfdt",function(t){r||(q=Ji(t.reader,t.version).baseMediaDecodeTime/n,r=!0,m||t.parser.stop())});(m||b)&&l.parse(c,!1,g);r&&d.timestampOffset==0&&(h=q)}else f.includes("/mp4")||f.includes("/webm")||!vk(l)||(a.$.has(b)||a.$.set(b,new nk),k=a.$.get(b),k.clearData(),k.Kf(d.i),k.parse(l),l=k.getStartTime(b),l!=null&&(h=l),k=k.getMetadata());return{timestamp:h,metadata:k}}
function Uk(a,b,c,d,e,f,g,h,k,l,m){g=g===void 0?!1:g;h=h===void 0?!1:h;k=k===void 0?!1:k;l=l===void 0?!1:l;var n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q,N;return O(function(M){switch(M.g){case 1:n=Mc;if(b!=n.Na){M.A(2);break}if(a.X!="HLS"){M.A(3);break}return G(M,a.ab,4);case 4:q=M.h,a.h.u=q;case 3:return G(M,jf(a.h,c,d?d.startTime:null,d?d.endTime:null,d?d.P()[0]:null),5);case 5:return M.return();case 2:if(l||!a.m){M.A(6);break}return G(M,Uk(a,n.aa,c,d,e,f,g,h,k,!0),7);case 7:return G(M,Uk(a,n.wa,
c,d,e,f,g,h,k,!0),8);case 8:return M.return();case 6:if(!a.l.has(b))return M.return();r=a.l.get(b).timestampOffset;t=a.G.get(b);a.j.has(b)&&(t=a.j.get(b).getOriginalMimeType());if(d&&(v=Tk(a,b,c,d,e,t,k),w=v.timestamp,z=v.metadata,w!=null&&(a.V==null&&b==n.wa&&(a.V=w,a.va=d.startTime,a.T!=null&&(y=0,a.va==a.oa&&(y=a.V-a.T),a.ma.resolve(y))),a.T==null&&b==n.aa&&(a.T=w,a.oa=d.startTime,a.V!=null&&(A=0,a.va==a.oa&&(A=a.V-a.T),a.ma.resolve(A))),E=w,I=Te,!a.J&&I.includes(a.G.get(b))&&(E=0),D=d.startTime-
E,C=Math.abs(r-D),(C>=.001||g||h)&&(!k||D>0||!r)&&(r=D,a.eb&&(Vk(a,b,function(){return Wk(a,b)},null),Vk(a,b,function(){return Xk(a,b,r)},null))),(B=b==n.wa||!a.l.has(n.wa))&&a.ab.resolve(r)),z.length))a.O.onMetadata(z,r,d?d.endTime:null);f&&b==n.wa&&(a.h||Lk(a,"application/cea-608",a.J,!1),a.K||(J=t.split(";",1)[0],a.K=new bd(J)),d?(F=a.K.Af(c),F.length&&pf(a.h,F,r)):a.K.init(c,h,m));if(!a.j.has(b)){M.A(9);break}return G(M,a.j.get(b).transmux(c,e,d,a.i.duration,b),10);case 10:L=M.h,ArrayBuffer.isView(L)?
c=L:(K=L,K.init!=null&&(P=K.init,Vk(a,b,function(){a.C&&Pc(a.C,P,r,e);a.l.get(b).appendBuffer(P)},d?d.P()[0]:null)),c=K.data);case 9:c=Yk(a,e,c,d,b);if(!d||!a.J||b==n.Na){M.A(11);break}if(!g&&!h){M.A(11);break}Q=d.startTime;if(a.X!="HLS"||a.m||b!=n.aa||!a.l.has(n.wa)){M.A(13);break}return G(M,a.ma,14);case 14:N=M.h,Math.abs(N)>.15&&(Q-=N);case 13:Vk(a,b,function(){return Wk(a,b)},null),Vk(a,b,function(){return Xk(a,b,Q)},null);case 11:return G(M,Vk(a,b,function(){var R=c;a.C&&Pc(a.C,R,r,e);a.l.get(b).appendBuffer(R)},
d?d.P()[0]:null),15);case 15:H(M)}})}function Zk(a,b){var c=Rk(a,"video")||0;nf(a.h,b,c)}function $k(a){a.h&&nf(a.h,"",0)}p.remove=function(a,b,c,d){var e=this,f,g;return O(function(h){return h.g==1?(f=Mc,a==f.wa&&e.K&&(e.K.remove(d),g=e.h.g||0,e.h.remove(g,c,!0)),a==f.Na?G(h,e.h.remove(b,c),0):c>b?G(h,Vk(e,a,function(){return al(e,a,b,c)},null),5):h.A(0)):e.m?G(h,Vk(e,f.aa,function(){return al(e,f.aa,b,c)},null),0):h.A(0)})};
function bl(a,b){var c;return O(function(d){return d.g==1?(c=Mc,b==c.Na?a.h?G(d,a.h.remove(0,Infinity),0):d.return():b===c.wa&&a.K&&a.h?G(d,a.h.remove(0,Infinity,!0),4):d.A(4)):d.g!=6?G(d,Vk(a,b,function(){return al(a,b,0,a.i.duration)},null),6):a.m?G(d,Vk(a,c.aa,function(){return al(a,c.aa,0,a.i.duration)},null),0):d.A(0)})}
p.flush=function(a){var b=this,c;return O(function(d){return d.g==1?(c=Mc,a==c.Na?d.return():G(d,Vk(b,a,function(){b.g.currentTime-=.001;Nk(b,a)},null),2)):b.m?G(d,Vk(b,c.aa,function(){var e=c.aa;b.g.currentTime-=.001;Nk(b,e)},null),0):d.A(0)})};
function cl(a,b,c,d,e,f,g,h,k){var l,m,n;return O(function(q){if(q.g==1){l=Mc;if(b==l.Na)return f||(a.h.u=c),mf(a.h,d,e),q.return();m=[];return G(q,dl(a,b,g,h,k),2)}n=q.h;n||(m.push(Vk(a,b,function(){return Wk(a,b)},null)),a.m&&m.push(Vk(a,l.aa,function(){return Wk(a,l.aa)},null)));f||(m.push(Vk(a,b,function(){return Xk(a,b,c)},null)),a.m&&m.push(Vk(a,l.aa,function(){return Xk(a,l.aa,c)},null)));if(d!=0||e!=Infinity)m.push(Vk(a,b,function(){return el(a,b,d,e)},null)),a.m&&m.push(Vk(a,l.aa,function(){return el(a,
l.aa,d,e)},null));return m.length?G(q,Promise.all(m),0):q.A(0)})}function fl(a,b,c){var d,e;return O(function(f){if(f.g==1){d=Mc;if(b==d.Na)return f.return();b==d.wa&&(a.ab=new Hg);if(!a.J||(e=Rk(a,b))&&Math.abs(e-c)<.15)return f.return();Vk(a,b,function(){return Wk(a,b)},null);a.m&&Vk(a,d.aa,function(){return Wk(a,d.aa)},null);return G(f,Vk(a,b,function(){return Xk(a,b,c)},null),2)}return a.m?G(f,Vk(a,d.aa,function(){return Xk(a,d.aa,c)},null),0):f.A(0)})}
p.endOfStream=function(a){var b=this;return O(function(c){return G(c,gl(b,function(){Ik(b)||Jk(b)||(a?b.i.endOfStream(a):b.i.endOfStream())}),0)})};p.Ab=function(a){var b=this;return O(function(c){return G(c,gl(b,function(){if(b.B.durationReductionEmitsUpdateEnd&&a<b.i.duration)for(var d=u(b.l.keys()),e=d.next();!e.done;e=d.next()){e=e.value;var f={start:function(){},p:new Hg,uri:null};b.o.get(e).unshift(f)}b.i.duration=a;b.ya=a}),0)})};p.getDuration=function(){return this.i.duration};
function hl(a,b,c){O(function(d){return a.I.g||a.g.error||a.N||a.H||Ik(a)||Jk(a)?d.return():G(d,gl(a,function(){Ik(a)||Jk(a)||a.i.setLiveSeekableRange(b,c)}),0)})}function il(a){O(function(b){return a.I.g||a.g.error||a.N||a.H||Ik(a)||Jk(a)?b.return():G(b,gl(a,function(){Ik(a)||Jk(a)||a.i.clearLiveSeekableRange()}),0)})}function al(a,b,c,d){if(d<=c)Nk(a,b);else{if(a.C){var e=a.C;b==="video"&&e.g&&e.g.flushBuffer(c,d)}a.l.get(b).remove(c,d)}}
function Wk(a,b){var c=a.l.get(b),d=c.appendWindowStart,e=c.appendWindowEnd;c.abort();c.appendWindowStart=d;c.appendWindowEnd=e;Nk(a,b)}function Xk(a,b,c){c<0&&(c+=.001);a.l.get(b).timestampOffset=c;Nk(a,b)}function el(a,b,c,d){var e=a.l.get(b);if(e.appendWindowEnd!==d||e.appendWindowStart!==c)e.appendWindowStart=0,e.appendWindowEnd=d,e.appendWindowStart=c;Nk(a,b)}
function Nk(a,b){if(a.H||a.I.g){var c=a.o.get(b);c&&c.length&&((c=c[0])&&c.p&&c.p.resolve(),a.o.set(b,[]))}else if(c=a.o.get(b)[0])c.p.resolve(),jl(a,b)}function Vk(a,b,c,d){hh(a.I);c={start:c,p:new Hg,uri:d};a.o.get(b).push(c);a.o.get(b).length==1&&kl(a,b);return c.p}
function gl(a,b){var c,d,e,f,g,h,k,l,m,n,q,r,t;return O(function(v){switch(v.g){case 1:hh(a.I);c=[];d=Array.from(a.l.keys());e=u(d);f=e.next();for(g={};!f.done;g={ready:void 0},f=e.next())h=f.value,g.ready=new Hg,k={start:function(w){return function(){return w.ready.resolve()}}(g),p:g.ready,uri:null},l=a.o.get(h),l.push(k),c.push(g.ready),l.length==1&&k.start();sa(v,2);return G(v,Promise.all(c),4);case 4:ua(v,3);break;case 2:throw m=Aa(v),m;case 3:return sa(v,5,6),G(v,b(),6);case 6:Ba(v);n=u(d);for(q=
n.next();!q.done;q=n.next())r=q.value,jl(a,r);Ea(v,0);break;case 5:throw t=Aa(v),new U(2,3,3015,t,a.g.error||"No error in the media element",null);}})}function jl(a,b){a.o.get(b).shift();kl(a,b)}function kl(a,b){var c=a.o.get(b)[0];if(c)try{c.start()}catch(d){d.name=="QuotaExceededError"?c.p.reject(new U(2,3,3017,b)):Ok(a)?c.p.reject(new U(2,3,3015,d,a.g.error||"No error in the media element",c.uri)):c.p.reject(new U(2,3,3024,b)),jl(a,b)}}function ll(a,b){a.ba=b;a.h&&(a.h.l=b)}
function Yk(a,b,c,d,e){if(Xe(a.G.get(e))!="mp4")return c;var f=d===null,g=a.Ta.get(e),h=a.O.Pj(),k=!1;d&&d.ea&&(k=d.ea.encrypted);d=d?d.P()[0]:null;var l=rb();a.B.correctEc3Enca&&f&&e==="audio"&&(c=pj(c));a.B.insertFakeEncryptionInInit&&g&&l.Fd(h,e)&&(f?c=qj(b,c,d):!k&&l.Ni(e)&&(c=sj(c)));f&&l.se()&&(c=vj(c));return c}
function ml(a,b,c,d){return Vk(a,b,function(){if(b!==Kc){a.G.get(b);if(rb().Ib()){a.j.has(b)&&(a.j.get(b).destroy(),a.j.delete(b));d&&a.j.set(b,d);var e=c+a.B.addExtraFeaturesToSourceBuffer(c);a.l.get(b).changeType(e);a.G.set(b,c)}Nk(a,b)}},null)}
function nl(a,b){var c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I;return O(function(D){if(D.g==1){if(a.H||a.N)return D.return();c=Mc;a.H=!0;a.m=!1;d=a.g.currentTime;e=a.g.autoplay;a.g.paused||(a.Ua=!0);a.ob&&(a.g.autoplay=!1);ta(D,2);a.u.Qa();f=u(a.j.values());for(g=f.next();!g.done;g=f.next())h=g.value,h.destroy();k=u(a.l.values());for(l=k.next();!l.done;l=k.next()){m=l.value;try{a.i.removeSourceBuffer(m)}catch(C){}}a.j.clear();a.l.clear();n=a.i.duration;a.M=new Hg;a.i=xk(a,a.M);return G(D,a.M,4)}if(D.g!=
2){!isNaN(n)&&n?a.i.duration=n:!isNaN(a.ya)&&a.ya&&(a.i.duration=a.ya);q=new Hg;r=a.i.sourceBuffers;t=b.size;v=0;w=function(){v++;v===t&&(q.resolve(),a.u.Ma(r,"addsourcebuffer",w))};a.u.D(r,"addsourcebuffer",w);z=u(b.keys());for(y=z.next();!y.done;y=z.next())A=y.value,E=b.get(A),Kk(a,A,E,E.codecs);(I=b.get(c.aa))&&I.isAudioMuxedInVideo&&(a.m=!0);a.m&&!a.o.has(c.aa)&&a.o.set(c.aa,[]);return G(D,q,2)}Ba(D);a.H=!1;hh(a.I);a.u.Aa(a.g,"loadedmetadata",function(){a.I.g||(a.g.currentTime=d)});a.u.Aa(a.g,
"canplaythrough",function(){a.I.g||(a.g.autoplay=e,a.Ua&&(a.Ua=!1,a.g.play()))});return Ea(D,0)})}function ol(a,b){return gl(a,function(){return nl(a,b)})}
function pl(a,b,c,d){var e=!1,f=Ic("audio",(d||"").split(",")),g=Ic("video",(d||"").split(",")),h=g;b=="audio"&&(h=f);h||(h=d);var k=Se(c,h),l=af(a.G.get(b)),m=a.B.forceTransmux;!Fi(k)||!a.J&&Te.includes(k)?m=!0:m||c==l||(m=!rb().Nf()&&Te.includes(c));if(m&&(a=Ue(c,h),h=Me(a))){var n=h();f&&g&&(e=!0);k=n.convertCodecs(b,a)}!n&&b==="video"&&f&&(k=Se(c,d));b=Ye(bf(k));return{jc:n,jl:e,Th:af(k),codec:b,mimeType:k}}
function ql(a,b,c,d,e){if(b==Kc)return{type:rl,wf:c,jc:null};var f=Ye(bf(a.G.get(b))),g=af(a.G.get(b)),h=pl(a,b,c,d),k=h.jc,l=h.jl,m=h.Th,n=h.codec;h=h.mimeType;var q=!0;l&&a.G.has("audio")&&(c=pl(a,"audio",c,d),d=Ye(bf(a.G.get("audio"))),q=af(a.G.get("audio")),q=d==c.codec&&q==c.Th,c.jc&&c.jc.destroy());if(f===n&&g===m&&q)return{type:rl,wf:h,jc:k};f=!0;if(a.m&&!e.has("audio")||l&&k&&!a.j.has(b))f=!1;b=rb();if(f&&a.B.codecSwitchingStrategy==="smooth"&&b.Ib())return{type:sl,wf:h,jc:k};k&&k.destroy();
return{type:tl,wf:h,jc:null}}
function dl(a,b,c,d,e){var f,g,h,k,l,m;return O(function(n){if(n.g==1){f=Mc;g=ql(a,b,c,d,e);h=g.type;k=g.jc;l=g.wf;if(m=e.get(f.aa))a.m=m.isAudioMuxedInVideo;if(h==rl)return a.j.has(b)&&!k?(a.j.get(b).destroy(),a.j.delete(b)):!a.j.has(b)&&k?a.j.set(b,k):k&&(a.j.has(b)&&a.j.get(b).transmux!==k.transmux?(a.j.get(b).destroy(),a.j.set(b,k)):k.destroy()),n.return(!1);if(h==sl)return G(n,ml(a,b,l,k),3);if(h!=tl)return n.A(3);k&&k.destroy();return G(n,ol(a,e),3)}return n.return(!0)})}
function ul(a,b,c,d,e){a=ql(a,b,c,d,e);a.jc&&a.jc.destroy();return a.type==tl}var zk=window.URL.createObjectURL,Mk="sequence",rl="none",tl="reset",sl="changeType";function vl(a,b,c){this.i=a;this.F=b;this.u=this.l=Infinity;this.h=1;this.g=this.j=null;this.B=0;this.C=!0;this.J=!1;this.I=0;this.G=c===void 0?!0:c;this.H=0;this.o=!1;this.m=a}p=vl.prototype;p.getDuration=function(){return this.l};p.Rj=function(){return this.h};p.Wi=function(a){this.i=a};p.Ab=function(a){this.l=a};p.Wj=function(){return this.i};p.Vi=function(a){this.B=a};p.cd=function(a){a&&!this.C&&(this.J=!0);this.C=a};p.Lf=function(a){this.u=a};p.df=function(){return this.u};
p.rh=function(a){this.F=a};p.Jj=function(){return this.F};p.Hi=function(a,b){if(a.length!=0){var c=(Date.now()+this.B)/1E3;a=a.filter(function(e){return e.start+b<c});if(a.length!=0){var d=a[a.length-1].end+b;this.xf(a[0].start+b);this.h=a.reduce(function(e,f){return Math.max(e,f.end-f.start)},this.h);this.g=Math.max(this.g,d);this.i!=null&&this.G&&!this.o&&(this.i=c-this.g-this.h)}}};
p.me=function(a){if(a.length!=0){var b=a[0].startTime,c=a[0].endTime,d=(Date.now()+this.B)/1E3;a=u(a);for(var e=a.next();!e.done;e=a.next())e=e.value,d<e.startTime||(b=Math.min(b,e.startTime),c=Math.max(c,e.endTime),this.h=Math.max(this.h,e.endTime-e.startTime));this.xf(b);this.g=Math.max(this.g,c);this.i!=null&&this.G&&!this.o&&(this.i=d-this.g-this.h)}};p.Gi=function(a,b){this.xf(a);b==Infinity||this.W()||(this.g=Math.max(this.g,b))};p.Sj=function(){return this.g};p.qf=function(){this.o=!0};
p.vk=function(){return this.o};p.sh=function(a){this.m=a};p.Oj=function(){return this.m};p.xf=function(a){this.j==null?this.j=a:this.J||(this.j=Math.min(this.j,a))};p.Wg=function(a){this.h=Math.max(this.h,a)};p.offset=function(a){this.j!=null&&(this.j+=a);this.g!=null&&(this.g+=a)};p.W=function(){return this.l==Infinity&&!this.C};p.Vc=function(){return this.l!=Infinity&&!this.C};p.Hb=function(){return Math.max(this.I,this.Ic()-this.u)};p.Yi=function(a){this.I=a};
p.Ic=function(){return this.W()||this.Vc()?Math.min(Math.max(0,(Date.now()+this.B)/1E3-this.h-this.i)+this.H,this.l):this.g?Math.min(this.g,this.l):this.l};p.ae=function(a){var b=Math.max(this.j,this.I);return this.u==Infinity?Math.ceil(b*1E3)/1E3:Math.max(b,Math.min(this.Ic()-this.u+a,this.Gb()))};p.Zb=function(){return this.ae(0)};p.Gb=function(){return Math.max(0,this.Ic()-(this.W()||this.Vc()?this.F:0))};p.kj=function(){return this.i==null||this.g!=null&&this.G?!1:!0};
p.Ui=function(a){this.H=a};p.Ej=function(){return this.H};T("shaka.media.PresentationTimeline",vl);vl.prototype.getAvailabilityTimeOffset=vl.prototype.Ej;vl.prototype.setAvailabilityTimeOffset=vl.prototype.Ui;vl.prototype.usingPresentationStartTime=vl.prototype.kj;vl.prototype.getSeekRangeEnd=vl.prototype.Gb;vl.prototype.getSeekRangeStart=vl.prototype.Zb;vl.prototype.getSafeSeekRangeStart=vl.prototype.ae;vl.prototype.getSegmentAvailabilityEnd=vl.prototype.Ic;vl.prototype.setUserSeekStart=vl.prototype.Yi;
vl.prototype.getSegmentAvailabilityStart=vl.prototype.Hb;vl.prototype.isInProgress=vl.prototype.Vc;vl.prototype.isLive=vl.prototype.W;vl.prototype.offset=vl.prototype.offset;vl.prototype.notifyMaxSegmentDuration=vl.prototype.Wg;vl.prototype.notifyMinSegmentStartTime=vl.prototype.xf;vl.prototype.getInitialProgramDateTime=vl.prototype.Oj;vl.prototype.setInitialProgramDateTime=vl.prototype.sh;vl.prototype.isStartTimeLocked=vl.prototype.vk;vl.prototype.lockStartTime=vl.prototype.qf;
vl.prototype.getMaxSegmentEndTime=vl.prototype.Sj;vl.prototype.notifyPeriodDuration=vl.prototype.Gi;vl.prototype.notifySegments=vl.prototype.me;vl.prototype.notifyTimeRange=vl.prototype.Hi;vl.prototype.getDelay=vl.prototype.Jj;vl.prototype.setDelay=vl.prototype.rh;vl.prototype.getSegmentAvailabilityDuration=vl.prototype.df;vl.prototype.setSegmentAvailabilityDuration=vl.prototype.Lf;vl.prototype.setStatic=vl.prototype.cd;vl.prototype.setClockOffset=vl.prototype.Vi;
vl.prototype.getPresentationStartTime=vl.prototype.Wj;vl.prototype.setDuration=vl.prototype.Ab;vl.prototype.setPresentationStartTime=vl.prototype.Wi;vl.prototype.getMaxSegmentDuration=vl.prototype.Rj;vl.prototype.getDuration=vl.prototype.getDuration;function wl(a,b,c,d){var e=this;this.u=d;this.g=a;this.F=b;this.h=c;this.j=new kb;this.m=!1;this.l=0;this.C=!1;this.H=this.G=0;this.o=xl(this);this.B=!1;this.j.D(a,"waiting",function(){return yl(e)});this.i=(new rf(function(){yl(e)})).Ea(this.h.gapJumpTimerTime)}wl.prototype.release=function(){this.j&&(this.j.release(),this.j=null);this.i!=null&&(this.i.stop(),this.i=null);this.o&&(this.o.release(),this.o=null);this.g=this.F=this.u=null};
wl.prototype.zd=function(){this.B=!0;this.i&&this.i.Ea(this.h.gapJumpTimerTime);yl(this)};
function yl(a){if(a.g.readyState!=0){if(a.g.seeking){if(!a.m)return}else a.m=!1;if(!a.g.paused||a.g.currentTime==a.l&&(a.g.autoplay||a.g.currentTime!=a.l)){var b;if(!(b=!a.o)){b=a.o;var c=b.h,d=zl(c),e=c.g.currentTime,f=Date.now()/1E3;if(b.g!=e||b.m!=d)b.l=f,b.g=e,b.m=d,b.i=!1;e=f-b.l;if(d=e>=b.o&&d&&!b.i)b.j&&b.j(b.g,e),b.i=!0,b.g=c.g.currentTime;b=!d}b&&(b=a.g.currentTime,c=a.g.buffered,d=Jj(c,b,a.h.gapDetectionThreshold),d==null||d==0&&!a.B||(e=c.start(d),(f=a.h.gapPadding)&&(e=Math.ceil((e+f)*
100)/100),e>=a.F.Gb()||e-b<.001||(d!=0&&c.end(d-1),Al(a,e),b==a.l&&(a.l=e),a.G++,a.u(new V("gapjumped")))))}}}function Al(a,b){a.C=!0;a.j.Aa(a.g,"seeked",function(){a.C=!1});a.g.currentTime=b}
function xl(a){if(!a.h.stallEnabled)return null;var b=a.h.stallThreshold,c=a.h.stallSkip;return new Bl(new Cl(a.g),b,function(){var d;return O(function(e){if(e.g==1)return d=Ij(a.g.buffered),d.length?c?(a.g.currentTime+=c,e.A(2)):G(e,a.g.play(),3):e.return();if(e.g!=2){if(!a.g)return e.return();a.g.pause();a.g.play()}a.H++;a.u(new V("stalldetected"));H(e)})})}function Bl(a,b,c){this.h=a;this.m=zl(a);this.g=a.g.currentTime;this.l=Date.now()/1E3;this.i=!1;this.o=b;this.j=c}
Bl.prototype.release=function(){this.h&&this.h.release();this.j=this.h=null};function Cl(a){var b=this;this.g=a;this.h=new kb;this.i=!1;this.h.D(this.g,"audiofocuspaused",function(){b.i=!0});this.h.D(this.g,"audiofocusgranted",function(){b.i=!1});this.h.D(this.g,"audiofocuslost",function(){b.i=!0})}
function zl(a){if(a.g.paused||a.g.playbackRate==0||a.i||a.g.buffered.length==0)var b=!1;else a:{b=a.g.currentTime;a=u(Ij(a.g.buffered));for(var c=a.next();!c.done;c=a.next())if(c=c.value,!(b<c.start-.1||b>c.end-.5)){b=!0;break a}b=!1}return b}Cl.prototype.release=function(){this.h&&this.h.release();this.h=null};function Dl(a,b,c,d){b==HTMLMediaElement.HAVE_NOTHING||a.readyState>=b?d():(b=El.value().get(b),c.Aa(a,b,d))}var El=new qb(function(){return new Map([[HTMLMediaElement.HAVE_METADATA,"loadedmetadata"],[HTMLMediaElement.HAVE_CURRENT_DATA,"loadeddata"],[HTMLMediaElement.HAVE_FUTURE_DATA,"canplay"],[HTMLMediaElement.HAVE_ENOUGH_DATA,"canplaythrough"]])});function Fl(a,b,c,d){var e=this;this.g=a;this.m=b;this.u=c;this.l=null;this.j=function(){e.l==null&&(e.l=d());return e.l};this.o=!1;this.h=new kb;this.i=new Gl(a);Dl(this.g,HTMLMediaElement.HAVE_METADATA,this.h,function(){Hl(e,e.j())})}Fl.prototype.release=function(){this.h&&(this.h.release(),this.h=null);this.i!=null&&(this.i.release(),this.i=null);this.m=function(){};this.g=null};function Il(a){return a.o?a.g.currentTime:a.j()}
function Jl(a,b){a.g.readyState>0?Kl(a.i,b):Dl(a.g,HTMLMediaElement.HAVE_METADATA,a.h,function(){Hl(a,a.j())})}function Hl(a,b){Math.abs(a.g.currentTime-b)<.001?Ll(a):(a.h.Aa(a.g,"seeking",function(){Ll(a)}),Kl(a.i,a.g.currentTime&&a.g.currentTime!=0?a.g.currentTime:b))}function Ll(a){a.o=!0;a.h.D(a.g,"seeking",function(){return a.m()});a.u(a.g.currentTime)}
function Gl(a){var b=this;this.g=a;this.m=10;this.j=this.l=this.i=0;this.h=new rf(function(){b.i<=0?b.h.stop():b.g.currentTime!=b.l||b.g.currentTime===b.j?b.h.stop():(b.g.currentTime=b.j,b.i--)})}Gl.prototype.release=function(){this.h&&(this.h.stop(),this.h=null);this.g=null};function Kl(a,b){a.l=a.g.currentTime;a.j=b;a.i=a.m;a.g.currentTime=b;a.h.Ea(.1)};function Ml(a){this.g=a;this.i=!1;this.h=null;this.j=new kb}p=Ml.prototype;p.ready=function(){function a(){if(b.h==null||b.h==0&&b.g.duration!=Infinity)b.i=!0;else{var c=b.g.currentTime,d=null;if(typeof b.h==="number")d=b.h;else if(b.h instanceof Date){var e=Nl(b);e!==null&&(d=b.h.getTime()/1E3-e,d=Ol(b,d))}d==null?b.i=!0:(d<0&&(d=Math.max(0,c+d)),c!=d?(b.j.Aa(b.g,"seeking",function(){b.i=!0}),b.g.currentTime=d):b.i=!0)}}var b=this;Dl(this.g,HTMLMediaElement.HAVE_FUTURE_DATA,this.j,function(){a()})};
p.release=function(){this.j&&(this.j.release(),this.j=null);this.g=null};p.$f=function(a){this.h=this.i?this.h:a};p.Qd=function(){var a=this.i?this.g.currentTime:this.h;a instanceof Date&&(a=a.getTime()/1E3-(Nl(this)||0),a=Ol(this,a));return a||0};p.Nh=function(){return 0};p.Lh=function(){return 0};p.Mh=function(){return!1};p.Fi=function(){};p.ri=function(){var a=Fj(this.g.buffered);return a!=null&&a>=this.g.duration-1};
function Nl(a){return a.g.getStartDate&&(a=a.g.getStartDate().getTime(),!isNaN(a))?a/1E3:null}function Ol(a,b){a=a.g.seekable;a.length>0&&(b=Math.max(a.start(0),b),b=Math.min(a.end(a.length-1),b));return b}
function Pl(a,b,c,d,e,f){var g=this;this.h=a;this.g=b.presentationTimeline;this.l=c;this.u=e;this.o=null;this.i=new wl(a,b.presentationTimeline,c,f);this.j=new Fl(a,function(){a:{var h=g.i;h.m=!0;h.B=!1;h.i&&h.i.Ea(h.h.gapJumpTimerTime);yl(h);var k=Il(g.j);h=Ql(g,k);if(!Hi()&&Math.abs(h-k)>.001){k=!1;var l=rb().Si();if(l){var m=Date.now()/1E3;if(!g.o||g.o<m-l)g.o=m,k=!0}else k=!0;if(k){Jl(g.j,h);h=void 0;break a}}g.u();h=void 0}return h},function(h){var k=g.i;k.g.seeking&&!k.m&&(k.m=!0,k.l=h);k.i&&
k.i.Ea(k.h.gapJumpTimerTime);yl(k)},function(){return Rl(g,d)});this.m=new rf(function(){if(g.h.readyState!=0&&!g.h.paused){var h=Il(g.j),k=g.g.Zb(),l=g.g.Gb();l-k<3&&(k=l-3);h<k&&(h=Ql(g,h),g.h.currentTime=h)}})}p=Pl.prototype;p.ready=function(){this.m.Ea(.25)};p.release=function(){this.j&&(this.j.release(),this.j=null);this.i&&(this.i.release(),this.i=null);this.m&&(this.m.stop(),this.m=null);this.h=this.j=this.g=this.l=null;this.u=function(){}};p.$f=function(a){Jl(this.j,Rl(this,a))};
p.Qd=function(){var a=Il(this.j);return this.h.readyState>0&&!this.h.paused?Sl(this,a):a};p.Nh=function(){return this.i.H};p.Lh=function(){return this.i.G};p.Mh=function(){return this.i.C};function Rl(a,b){b==null?b=a.g.getDuration()<Infinity?a.g.Zb():a.g.Gb():b instanceof Date?b=b.getTime()/1E3-(a.g.m||a.g.i):b<0&&(b=a.g.Gb()+b);return Tl(a,Sl(a,b))}p.Fi=function(){this.i.zd()};p.ri=function(){if(this.g.W()){var a=this.g.Ic(),b=Fj(this.h.buffered);if(b!=null&&b>=a)return!0}return!1};
function Tl(a,b){var c=a.g.getDuration();return b>=c?c-a.l.durationBackoff:b}function Ql(a,b){var c=a.l.rebufferingGoal,d=a.l.safeSeekOffset,e=a.g.Zb(),f=a.g.Gb(),g=a.g.getDuration();f-e<3&&(e=f-3);var h=a.g.ae(c),k=a.g.ae(d);c=a.g.ae(c+d);return b>=g?Tl(a,b):b>f?f-a.l.safeSeekEndOffset:b<e?a.g.W()&&a.l.returnToEndOfLiveWindowWhenOutside?f-a.l.safeSeekEndOffset:Gj(a.h.buffered,k)?k:c:b>=h||Gj(a.h.buffered,b)?b:c}function Sl(a,b){var c=a.g.Zb();if(b<c)return c;a=a.g.Gb();return b>a?a:b};function Ul(a){this.g=a;this.m=null;this.i=0;this.o=!1}p=Ul.prototype;p.getNumReferences=function(){return this.g.length};p.getNumEvicted=function(){return this.i};p.release=function(){this.o||(this.g=[],this.m&&this.m.stop(),this.m=null)};p.Bk=function(){this.o=!0};p.Fb=function(a){for(var b=u(this.g),c=b.next();!c.done;c=b.next())a(c.value)};function mg(a){return a.g[0]||null}
p.find=function(a){for(var b=this.g.length-1,c=b;c>=0;--c){var d=this.g[c],e=c<b?this.g[c+1].startTime:d.endTime;if(a>=d.startTime&&a<e)return c+this.i}return this.g.length&&a<this.g[0].startTime?this.i:null};p.get=function(a){if(this.g.length==0)return null;a-=this.i;return a<0||a>=this.g.length?null:this.g[a]};p.offset=function(a){if(!this.o)for(var b=u(this.g),c=b.next();!c.done;c=b.next())c.value.offset(a)};
p.tf=function(a){if(!this.o&&a.length){var b=Math.round(a[0].startTime*1E3)/1E3;this.g=this.g.filter(function(c){return Math.round(c.startTime*1E3)/1E3<b});this.g.push.apply(this.g,x(a))}};p.ke=function(a,b){var c=this;a=a.filter(function(d){return d.endTime>b&&(c.g.length==0||d.endTime>c.g[0].startTime)});this.tf(a);this.Ya(b)};p.Ya=function(a){if(!this.o){var b=this.g.length;this.g=this.g.filter(function(c){return c.endTime>a});this.i+=b-this.g.length}};
p.pd=function(a,b,c){c=c===void 0?!1:c;if(!this.o){for(;this.g.length;)if(this.g[this.g.length-1].startTime>=b)this.g.pop();else break;for(;this.g.length;)if(this.g[0].endTime<=a)this.g.shift(),c||this.i++;else break;this.g.length!=0&&(a=this.g[this.g.length-1],b=new yj(a.startTime,b,a.C,a.startByte,a.endByte,a.ea,a.timestampOffset,a.appendWindowStart,a.appendWindowEnd,a.g,a.tilesLayout,a.B,a.h,a.status,a.aesKey),b.mimeType=a.mimeType,b.codecs=a.codecs,b.i=a.i,this.g[this.g.length-1]=b)}};
p.Rf=function(a,b){var c=this;this.o||(this.m&&this.m.stop(),this.m=new rf(function(){var d=b();d?c.g.push.apply(c.g,x(d)):(c.m.stop(),c.m=null)}),this.m.Ea(a))};Ul.prototype[Symbol.iterator]=function(){return this.Xb(0)};
Ul.prototype.Xb=function(a,b,c){b=b===void 0?!1:b;c=c===void 0?!1:c;var d=this.find(a);if(d==null)return null;var e=this.get(d);c?d++:d--;var f=-1;if(e&&e.g.length>0)for(var g=e.g.length-1;g>=0;--g){var h=e.g[g];if(a>=h.startTime&&a<h.endTime){if(!b){for(;g&&!h.l;)g--,h=e.g[g];if(!h.l)return Za("No independent partial segment found!"),null}c?d--:d++;f=g-1;break}}return new Vl(this,d,f,c)};Ul.prototype.We=function(){return-1};
function Wl(a,b,c){a=new yj(a,a+b,function(){return c},0,null,null,a,a,a+b);return new Ul([a])}T("shaka.media.SegmentIndex",Ul);Ul.forSingleSegment=Wl;Ul.prototype.getIteratorForTime=Ul.prototype.Xb;Ul.prototype.updateEvery=Ul.prototype.Rf;Ul.prototype.fit=Ul.prototype.pd;Ul.prototype.evict=Ul.prototype.Ya;Ul.prototype.mergeAndEvict=Ul.prototype.ke;Ul.prototype.offset=Ul.prototype.offset;Ul.prototype.get=Ul.prototype.get;Ul.prototype.find=Ul.prototype.find;Ul.prototype.markImmutable=Ul.prototype.Bk;
Ul.prototype.release=Ul.prototype.release;Ul.prototype.getNumEvicted=Ul.prototype.getNumEvicted;Ul.prototype.getNumReferences=Ul.prototype.getNumReferences;function Vl(a,b,c,d){this.i=a;this.h=b;this.g=c;this.reverse=d}p=Vl.prototype;p.Jd=function(a){this.reverse=a};p.zj=function(){return this.h};p.current=function(){var a=this.i.get(this.h);a&&a.g.length>0&&a.m&&this.g>=a.g.length&&(this.h++,this.g=0,a=this.i.get(this.h));return a&&a.g.length>0?a.g[this.g]:a};
p.next=function(){var a=this.i.get(this.h);this.reverse?a&&a.g.length>0?(this.g--,this.g<0&&(this.h--,this.g=(a=this.i.get(this.h))&&a.g.length>0?a.g.length-1:0)):(this.h--,this.g=0):a&&a.g.length>0?(this.g++,a.m&&this.g==a.g.length&&(this.h++,this.g=0)):(this.h++,this.g=0);a=this.current();return{value:a,done:!a}};p.jh=function(){var a=this.current();if(a&&a.Xc&&!a.l&&(a=this.i.get(this.h))&&a.g.length>0)for(var b=a.g[this.g];b.l&&!(this.g<=0);)this.g--,b=a.g[this.g]};
T("shaka.media.SegmentIterator",Vl);Vl.prototype.resetToLastIndependent=Vl.prototype.jh;Vl.prototype.next=Vl.prototype.next;Vl.prototype.current=Vl.prototype.current;Vl.prototype.currentPosition=Vl.prototype.zj;Vl.prototype.setReverse=Vl.prototype.Jd;function Xl(){Ul.call(this,[]);this.h=[]}ma(Xl,Ul);p=Xl.prototype;p.clone=function(){var a=new Xl;a.h=this.h.slice();a.i=this.i;return a};p.release=function(){this.h=[]};p.Fb=function(a){for(var b=u(this.h),c=b.next();!c.done;c=b.next())c.value.Fb(a)};
function Yl(a,b){a=u(a.h);for(var c=a.next();!c.done;c=a.next())b(c.value)}p.find=function(a){for(var b=this.i,c=u(this.h),d=c.next();!d.done;d=c.next()){d=d.value;var e=d.find(a);if(e!=null)return e+b;b+=d.getNumEvicted()+d.getNumReferences()}return null};function Zl(a,b){a=u(a.h);for(var c=a.next();!c.done;c=a.next())if(c=c.value,c.find(b)!=null)return c.We();return-1}
p.get=function(a){for(var b=this.i,c=u(this.h),d=c.next();!d.done;d=c.next()){d=d.value;var e=d.get(a-b);if(e)return e;e=d.getNumReferences();b+=d.getNumEvicted()+e}return null};p.offset=function(){};p.tf=function(){};p.Ya=function(a){if(this.h.length){var b=this.h[0];b.Ya(a);b.getNumReferences()==0&&(this.h.shift(),this.i+=b.getNumEvicted(),b.release(),this.Ya(a))}};p.ke=function(){};p.pd=function(){};p.Rf=function(){};T("shaka.media.MetaSegmentIndex",Xl);Xl.prototype.updateEvery=Xl.prototype.Rf;
Xl.prototype.fit=Xl.prototype.pd;Xl.prototype.mergeAndEvict=Xl.prototype.ke;Xl.prototype.evict=Xl.prototype.Ya;Xl.prototype.merge=Xl.prototype.tf;Xl.prototype.offset=Xl.prototype.offset;Xl.prototype.get=Xl.prototype.get;Xl.prototype.find=Xl.prototype.find;Xl.prototype.forEachTopLevelReference=Xl.prototype.Fb;Xl.prototype.release=Xl.prototype.release;function $l(a){var b=this;this.g=a;this.j=!1;this.i=this.g.cf();this.h=new rf(function(){b.g.Di(b.i*.25)})}$l.prototype.release=function(){this.set(this.Tc());this.h&&(this.h.stop(),this.h=null);this.g=null};$l.prototype.set=function(a){this.i=a;am(this)};$l.prototype.Tc=function(){return this.g.Tc()};function am(a){a.h.stop();var b=a.j?0:a.i;if(b>=0)try{a.g.cf()!=b&&a.g.uh(b);return}catch(c){}a.h.Ea(.25);a.g.cf()!=0&&a.g.uh(0)};function bm(a){var b=this;this.j=a;this.h=new kb;this.g=new Set;this.i=(new rf(function(){cm(b,!1)})).Jb();a.paused||this.i.Ea(.25);this.h.D(a,"playing",function(){b.i.Jb().Ea(.25)});this.h.D(a,"pause",function(){b.i.stop()})}bm.prototype.release=function(){this.h&&(this.h.release(),this.h=null);this.i.stop();for(var a=u(this.g),b=a.next();!b.done;b=a.next())b.value.release();this.g.clear()};function cm(a,b){var c=a.j.currentTime;a=u(a.g);for(var d=a.next();!d.done;d=a.next())d.value.j(c,b)};function dm(a){Rg.call(this);this.g=new Map;this.h=a}ma(dm,Rg);dm.prototype.release=function(){this.g.clear();Rg.prototype.release.call(this)};function em(a,b){var c=a.g.get(b);c||(c={re:[],pg:null,contentType:b},a.g.set(b,c));return c}function fm(a,b,c){var d=em(a,b.contentType);gm(a,d);a={xd:b,position:c};d=d.re;b=d.findIndex(function(e){return e.position>=c});b>=0?d.splice(b,d[b].position==c?1:0,a):d.push(a)}
dm.prototype.j=function(a){for(var b=u(this.g.values()),c=b.next();!c.done;c=b.next()){c=c.value;var d=c.pg;a:{var e=c.re;for(var f=e.length-1;f>=0;f--){var g=e[f];if(g.position<=a){e=g.xd;break a}}e=null}f=e&&!(d===e||d&&e&&d.bandwidth==e.bandwidth&&d.audioSamplingRate==e.audioSamplingRate&&d.codecs==e.codecs&&d.contentType==e.contentType&&d.frameRate==e.frameRate&&d.height==e.height&&d.mimeType==e.mimeType&&d.channelsCount==e.channelsCount&&d.pixelAspectRatio==e.pixelAspectRatio&&d.width==e.width);
g=e&&d&&e.label&&d.label&&d.label!==e.label;var h=e&&d&&e.language&&d.language&&d.language!==e.language;d=e&&d&&e.roles&&d.roles&&!ib(d.roles,e.roles);(g||h||d)&&hm(this,a,e.contentType)&&(c.pg=e,d=new V("audiotrackchange",new Map([["quality",e],["position",a]])),this.dispatchEvent(d));f&&hm(this,a,e.contentType)&&(c.pg=e,JSON.stringify(e),c=new V("qualitychange",new Map([["quality",e],["position",a]])),this.dispatchEvent(c))}};
function hm(a,b,c){return(a=a.h()[c])&&a.length>0&&(c=a[a.length-1].end,b>=a[0].start&&b<c)?!0:!1}function gm(a,b){if((a=a.h()[b.contentType])&&a.length>0){var c=a[0].start,d=a[a.length-1].end,e=b.re;b.re=e.filter(function(f,g){return f.position<=c&&g+1<e.length&&e[g+1].position<=c||f.position>=d?!1:!0})}else b.re=[]}
function im(a){var b={bandwidth:a.bandwidth||0,audioSamplingRate:null,codecs:a.codecs,contentType:a.type,frameRate:null,height:null,mimeType:a.mimeType,channelsCount:null,pixelAspectRatio:null,width:null,label:null,roles:a.roles,language:null};a.type=="video"&&(b.frameRate=a.frameRate||null,b.height=a.height||null,b.pixelAspectRatio=a.pixelAspectRatio||null,b.width=a.width||null);a.type=="audio"&&(b.audioSamplingRate=a.audioSamplingRate,b.channelsCount=a.channelsCount,b.label=a.label||null,b.language=
a.language);return b};function jm(a){Rg.call(this);this.h=new Map;this.i=a;this.g=null}ma(jm,Rg);jm.prototype.release=function(){this.h.clear();this.g&&(this.g.stop(),this.g=null);Rg.prototype.release.call(this)};function km(a,b){var c=b.schemeIdUri+"_"+b.id+"_"+(b.startTime.toFixed(1)+"_"+b.endTime.toFixed(1));a.h.has(c)||(a.h.set(c,b),b=new V("regionadd",new Map([["region",b]])),a.dispatchEvent(b),lm(a))}
function lm(a){a.g||(a.g=(new rf(function(){for(var b=a.i(),c=u(a.h),d=c.next();!d.done;d=c.next()){var e=u(d.value);d=e.next().value;e=e.next().value;e.endTime<b.start&&(a.h.delete(d),d=new V("regionremove",new Map([["region",e]])),a.dispatchEvent(d))}!a.h.size&&a.g&&(a.g.stop(),a.g=null)})).Ea(2))};function mm(a,b,c,d,e){function f(g,h){return h.fastSwitching&&g.Xc&&g.je?!1:!0}this.m=a;this.i=b;this.l=c;this.g=new Map;this.j=new Map;this.h=null;this.o=d;this.u=e||f}function nm(a,b){a.l=b;a=u(a.g.values());for(var c=a.next();!c.done;c=a.next())c.value.g=b}
function om(a,b,c){c=c===void 0?!1:c;if(!a.i.segmentIndex)return Promise.resolve();a.h||(a.h=a.i.segmentIndex.Xb(b,!0,a.o));if(!a.h)return Promise.resolve();c&&a.h.next();for(b=[];a.g.size<a.m;){c=a.h.next().value;if(!c)break;var d=!0;c.isPreload()&&c.endByte!=null&&(d=!1);c.Kc()==2&&(d=!1);c.$b(!1)&&(d=!1);d&&c.ea&&b.push(pm(a,c.ea));d&&!a.g.has(c)&&(d=new qm(a.l),b.push(rm(d,c,a.i)),a.g.set(c,d));if(!a.u(c,a.i))break}sm(a);return Promise.all(b)}
function pm(a,b){if(!a.i.segmentIndex||b.$b()||Array.from(a.j.keys()).some(function(e){return xj(e,b)}))return Promise.resolve();var c=new qm(a.l),d=rm(c,b,a.i);a.j.set(b,c);return d}function tm(a,b){b=u(b.keys());for(var c=b.next();!c.done;c=b.next())(c=c.value)&&um(a,c)}function vm(a){tm(a,a.g);tm(a,a.j);a.h=null}mm.prototype.Ya=function(a,b){b=b===void 0?!1:b;for(var c=u(this.g.keys()),d=c.next();!d.done;d=c.next())d=d.value,a>d.endTime&&um(this,d);b&&sm(this)};
mm.prototype.Jd=function(a){this.o=a;this.h&&this.h.Jd(a)};function sm(a){if(a.g.size)for(var b=Array.from(a.g.keys()),c=u(a.j.keys()),d=c.next(),e={};!d.done;e={Qg:void 0},d=c.next())e.Qg=d.value,b.some(function(f){return function(g){return xj(g.ea,f.Qg)}}(e))||um(a,e.Qg)}function wm(a,b){a.m=b;for(var c=Array.from(a.g.keys());c.length>b;){var d=c.pop();d&&um(a,d)}sm(a)}function xm(a,b){b&&b!==a.i&&(vm(a),a.i=b)}
function um(a,b){var c=a.g;b instanceof wj&&(c=a.j);a=c.get(b);c.delete(b);a&&a.abort()}function qm(a){this.g=a;this.oe=this.Bh=null}function rm(a,b,c){var d=new Uint8Array(0);a.oe=a.g(b,c,function(e){return O(function(f){if(f.g==1)return d.byteLength>0?d=Dc(d,e):d=e,a.Bh?G(f,a.Bh(d),3):f.A(0);d=new Uint8Array(0);H(f)})});return a.oe.promise.catch(function(e){return e instanceof U&&e.code==7001?Promise.resolve():Promise.reject(e)})}qm.prototype.abort=function(){this.oe&&this.oe.abort()};T("shaka.config.CrossBoundaryStrategy",{KEEP:"keep",RESET:"reset",RESET_TO_ENCRYPTED:"reset_to_encrypted",RESET_ON_ENCRYPTION_CHANGE:"RESET_ON_ENCRYPTION_CHANGE"});function ym(a){var b=af(a),c=b.split("/")[0];a=bf(a);return{type:c,mimeType:b,codecs:a,language:null,height:null,width:null,channelCount:null,sampleRate:null,closedCaptions:new Map,ze:null,colorGamut:null,frameRate:null,timescale:null}}
function zm(a,b,c){function d(B){y=B.name;var J=B.reader;J.skip(24);var F=J.Ca(),L=J.Ca();J.skip(50);q=String(F);n=String(L);B.reader.Ia()&&uh(B)}function e(B){var J=Mi(B.reader);r=J.channelCount;t=J.sampleRate;f(B.name)}function f(B){B=B.toLowerCase();switch(B){case "avc1":case "avc3":h.push(B+".42E01E");l=!0;break;case "hev1":case "hvc1":h.push(B+".1.6.L93.90");l=!0;break;case "dvh1":case "dvhe":h.push(B+".05.04");l=!0;break;case "vp09":h.push(B+".00.10.08");l=!0;break;case "av01":h.push(B+".0.01M.08");
l=!0;break;case "mp4a":g.push("mp4a.40.2");k=!0;break;case "ac-3":case "ec-3":case "ac-4":case "opus":case "flac":g.push(B);k=!0;break;case "apac":g.push("apac.31.00"),k=!0}}var g=[],h=[],k=!1,l=!1,m=null,n=null,q=null,r=null,t=null,v=null,w=null,z=null,y;(new ph).box("moov",uh).box("trak",uh).box("mdia",uh).S("mdhd",function(B){B=Ki(B.reader,B.version);m=B.language;z=B.timescale}).box("minf",uh).box("stbl",uh).S("stsd",zh).box("mp4a",function(B){var J=Mi(B.reader);r=J.channelCount;t=J.sampleRate;
B.reader.Ia()?uh(B):f(B.name)}).box("esds",function(B){B=B.reader;for(var J="mp4a",F,L;B.Ia();){F=B.Y();for(var K=B.Y();K&128;)K=B.Y();if(F==3)B.Ca(),K=B.Y(),K&128&&B.Ca(),K&64&&B.skip(B.Y()),K&32&&B.Ca();else if(F==4)L=B.Y(),B.skip(12);else if(F==5)break}L&&(J+="."+Pi(L),F==5&&B.Ia()&&(F=B.Y(),L=(F&248)>>3,L===31&&B.Ia()&&(L=32+((F&7)<<3)+((B.Y()&224)>>5)),J+="."+L));g.push(J);k=!0}).box("ac-3",e).box("ec-3",e).box("ac-4",e).box("Opus",e).box("fLaC",e).box("apac",e).box("avc1",d).box("avc3",d).box("hev1",
d).box("hvc1",d).box("dva1",d).box("dvav",d).box("dvh1",d).box("dvhe",d).box("vp09",d).box("av01",d).box("avcC",function(B){var J=y||"";switch(y){case "dvav":J="avc3";break;case "dva1":J="avc1"}B=B.reader;B.skip(1);B=J+"."+Pi(B.Y())+Pi(B.Y())+Pi(B.Y());h.push(B);l=!0}).box("hvcC",function(B){var J=y||"";switch(y){case "dvh1":J="hvc1";break;case "dvhe":J="hev1"}var F=B.reader;F.skip(1);B=F.Y();var L=["","A","B","C"][B>>6],K=B&31,P=F.U(),Q=(B&32)>>5?"H":"L";B=[F.Y(),F.Y(),F.Y(),F.Y(),F.Y(),F.Y()];F=
F.Y();for(var N=0,M=0;M<32;M++){N|=P&1;if(M==31)break;N<<=1;P>>=1}J=J+("."+L+K)+("."+Pi(N,!0));J+="."+Q+F;L="";for(K=B.length;K--;)if((Q=B[K])||L)L="."+Q.toString(16).toUpperCase()+L;J+=L;h.push(J);l=!0}).box("dvcC",function(B){var J=y||"";switch(y){case "hvc1":J="dvh1";break;case "hev1":J="dvhe";break;case "avc1":J="dva1";break;case "avc3":J="dvav";break;case "av01":J="dav1"}var F=B.reader;F.skip(2);B=F.Y();F=F.Y();h.push(J+"."+Qi(B>>1&127)+"."+Qi(B<<5&32|F>>3&31));l=!0}).box("dvvC",function(B){var J=
y||"";switch(y){case "hvc1":J="dvh1";break;case "hev1":J="dvhe";break;case "avc1":J="dva1";break;case "avc3":J="dvav";break;case "av01":J="dav1"}var F=B.reader;F.skip(2);B=F.Y();F=F.Y();h.push(J+"."+Qi(B>>1&127)+"."+Qi(B<<5&32|F>>3&31));l=!0}).S("vpcC",function(B){var J=y||"",F=B.reader;B=F.Y();var L=F.Y();F=F.Y()>>4&15;h.push(J+"."+Qi(B)+"."+Qi(L)+"."+Qi(F));l=!0}).box("av1C",function(B){var J=y||"";switch(y){case "dav1":J="av01"}var F=B.reader;F.skip(1);B=F.Y();F=F.Y();var L=B>>>5,K=(F&64)>>6;h.push(J+
"."+L+"."+Qi(B&31)+(F>>>7?"H":"M")+"."+Qi(L===2&&K?(F&32)>>5?12:10:K?10:8)+"."+((F&16)>>4)+"."+((F&8)>>3)+((F&4)>>2)+(F&3)+"."+Qi(1)+"."+Qi(1)+"."+Qi(1)+".0");l=!0}).box("enca",Bh).box("encv",Ah).box("sinf",uh).box("frma",function(B){B=Ni(B.reader).codec;f(B)}).box("colr",function(B){h=h.map(function(L){if(L.startsWith("av01.")){var K=B.reader,P=K.Pa(),Q=K.Tb(4,!1);var N=String.fromCharCode(Q[0]);N+=String.fromCharCode(Q[1]);N+=String.fromCharCode(Q[2]);N+=String.fromCharCode(Q[3]);if(N==="nclx"){Q=
K.Ca();N=K.Ca();var M=K.Ca(),R=K.Y()>>7,S=L.split(".");S.length==10&&(S[6]=Qi(Q),S[7]=Qi(N),S[8]=Qi(M),S[9]=String(R),L=S.join("."))}K.seek(P)}return L});var J=Oi(B.reader),F=J.colorGamut;v=J.ze;w=F}).parse(a||b,!0,!0);if(!g.length&&!h.length)return null;var A=k&&!l,E=new Map;if(l&&!c){c=new bd("video/mp4");a&&c.init(a);try{c.Af(b);for(var I=u(c.Zf()),D=I.next();!D.done;D=I.next()){var C=D.value;E.set(C,C)}}catch(B){}c.Pd()}return{type:A?"audio":"video",mimeType:A?"audio/mp4":"video/mp4",codecs:Am(g.concat(h)).join(", "),
language:m,height:n,width:q,channelCount:r,sampleRate:t,closedCaptions:E,ze:v,colorGamut:w,frameRate:null,timescale:z}}function Am(a){var b=new Set,c=[];a=u(a);for(var d=a.next();!d.done;d=a.next()){d=d.value;var e=$e(d);b.has(e)||(c.push(d),b.add(e))}b=Lc("audio",c);d=Lc("video",c);a=Lc(Kc,c);d=Bm(d);b=b.concat(d).concat(a);return c.length&&!b.length?c:b}
function Bm(a){if(a.length<=1)return a;var b=a.find(function(c){return c.startsWith("dvav.")||c.startsWith("dva1.")||c.startsWith("dvh1.")||c.startsWith("dvhe.")||c.startsWith("dav1.")||c.startsWith("dvc1.")||c.startsWith("dvi1.")});return b?Fi('video/mp4; codecs="'+b+'"')?[b]:a.filter(function(c){return c!=b}):a}
function Cm(a){var b=null;(new ph).box("moov",uh).box("trak",uh).box("mdia",uh).box("minf",uh).box("stbl",uh).S("stsd",zh).box("encv",Ah).box("enca",Bh).box("sinf",uh).box("schi",uh).S("tenc",function(c){c=c.reader;c.Y();c.Y();c.Y();c.Y();c=c.Tb(16,!1);b=Cc(c)}).parse(a,!0);return b}
function Dm(a,b,c){var d,e,f,g,h;return O(function(k){if(k.g==1)return d=b,d.cryptoKey?k.A(2):G(k,d.fetchKey(),3);e=d.iv;if(!e)for(e=Wb(new ArrayBuffer(16)),f=d.firstMediaSequenceNumber+c,g=e.byteLength-1;g>=0;g--)e[g]=f&255,f>>=8;b.blockCipherMode=="CBC"?h={name:"AES-CBC",iv:e}:h={name:"AES-CTR",counter:e,length:64};return k.return(window.crypto.subtle.decrypt(h,d.cryptoKey,a))})};function Em(a,b,c){var d,e,f,g,h,k,l;return O(function(m){switch(m.g){case 1:d=Fm(a);if(e=Gm.get(d))return m.return(e);f=0;g=Zg([a],c);sa(m,2);g.method="HEAD";return G(m,b.request(f,g).promise,4);case 4:h=m.h;e=h.headers["content-type"];ua(m,3);break;case 2:k=Aa(m);if(!k||k.code!=1002&&k.code!=1001){m.A(3);break}g.method="GET";return G(m,b.request(f,g).promise,6);case 6:l=m.h,e=l.headers["content-type"];case 3:return m.return(e?e.toLowerCase().split(";").shift():"")}})}
function Fm(a){a=(new Db(a)).Sb.split("/").pop().split(".");return a.length==1?"":a.pop().toLowerCase()}function Hm(a,b,c,d,e){a=Zg(a,d,e);if(b!=0||c!=null)a.headers.Range=c?"bytes="+b+"-"+c:"bytes="+b+"-";return a}
var Gm=(new Map).set("mp4","video/mp4").set("m4v","video/mp4").set("m4a","audio/mp4").set("webm","video/webm").set("weba","audio/webm").set("mkv","video/webm").set("ts","video/mp2t").set("ogv","video/ogg").set("ogg","audio/ogg").set("mpg","video/mpeg").set("mpeg","video/mpeg").set("mov","video/quicktime").set("m3u8","application/x-mpegurl").set("mpd","application/dash+xml").set("ism","application/vnd.ms-sstr+xml").set("mp3","audio/mpeg").set("aac","audio/aac").set("flac","audio/flac").set("wav","audio/wav").set("sbv",
"text/x-subviewer").set("srt","text/srt").set("vtt","text/vtt").set("webvtt","text/vtt").set("ttml","application/ttml+xml").set("lrc","application/x-subtitle-lrc").set("ssa","text/x-ssa").set("ass","text/x-ssa").set("jpeg","image/jpeg").set("jpg","image/jpeg").set("png","image/png").set("svg","image/svg+xml").set("webp","image/webp").set("avif","image/avif").set("html","text/html").set("htm","text/html");function Im(a,b){var c=this;this.g=b;this.j=a;this.i=null;this.M=new Map;this.C=1;this.B=this.o=null;this.V=0;this.h=new Map;this.N=!1;this.X=null;this.F=!1;this.l=new gh(function(){return Jm(c)});this.R=Date.now()/1E3;this.m=new Map;this.T={projection:null,hfov:null};this.ba=0;this.$=Infinity;this.H=null;this.O=[];this.u=new rf(function(){if(c.j&&c.g)if(c.j.presentationTimeline.W()){var d=c.j.presentationTimeline.Zb(),e=c.j.presentationTimeline.Gb();e-d>1?hl(c.g.Z,d,e):il(c.g.Z)}else il(c.g.Z),c.u&&
c.u.stop();else c.u&&c.u.stop()});this.I=null;this.J=!1;this.K=new rf(function(){var d=c.g.video;!d.ended&&c.I&&(c.J=!0,d.currentTime=c.I,c.I=null)});this.G=new kb}p=Im.prototype;p.destroy=function(){return this.l.destroy()};
function Jm(a){var b,c,d,e,f,g,h;return O(function(k){if(k.g==1){a.u&&a.u.stop();a.u=null;a.K&&a.K.stop();a.K=null;a.G&&(a.G.release(),a.G=null);b=[];c=u(a.h.values());for(d=c.next();!d.done;d=c.next())e=d.value,Km(e),b.push(Lm(e)),e.ia&&(vm(e.ia),e.ia=null);f=u(a.m.values());for(g=f.next();!g.done;g=f.next())h=g.value,vm(h);return G(k,Promise.all(b),2)}a.h.clear();a.m.clear();a.g=null;a.j=null;a.i=null;a.I=null;H(k)})}
p.configure=function(a){this.i=a;this.X=new Eg({maxAttempts:Math.max(a.retryParameters.maxAttempts,2),baseDelay:a.retryParameters.baseDelay,backoffFactor:a.retryParameters.backoffFactor,fuzzFactor:a.retryParameters.fuzzFactor,timeout:0,stallTimeout:0,connectionTimeout:0},!0);if(a.disableAudioPrefetch){var b=this.h.get("audio");b&&b.ia&&(vm(b.ia),b.ia=null);b=u(this.m.keys());for(var c=b.next();!c.done;c=b.next())c=c.value,vm(this.m.get(c)),this.m.delete(c)}a.disableTextPrefetch&&(b=this.h.get(Kc))&&
b.ia&&(vm(b.ia),b.ia=null);a.disableVideoPrefetch&&(b=this.h.get("video"))&&b.ia&&(vm(b.ia),b.ia=null);b=u(this.h.keys());for(c=b.next();!c.done;c=b.next())c=this.h.get(c.value),c.ia?(wm(c.ia,a.segmentPrefetchLimit),a.segmentPrefetchLimit>0||(vm(c.ia),c.ia=null)):a.segmentPrefetchLimit>0&&(c.ia=Mm(this,c.stream));a.disableAudioPrefetch||Nm(this)};function Om(a,b,c){a.j.presentationTimeline.W()||(a.ba=b,a.$=c)}
p.start=function(a){var b=this;return O(function(c){if(c.g==1)return G(c,Pm(b,a||new Map),2);hh(b.l);b.N=!0;H(c)})};function Qm(a,b){var c,d,e,f,g,h,k;O(function(l){switch(l.g){case 1:return c=Mc,a.V++,d=a.V,sa(l,2),G(l,bl(a.g.Z,c.Na),4);case 4:ua(l,3);break;case 2:if(e=Aa(l),a.g)a.g.onError(e);case 3:f=Se(b.mimeType,b.codecs),Lk(a.g.Z,f,a.j.sequenceMode,b.external),g=a.g.Z.ba,(h=g.isTextVisible()||a.i.alwaysStreamText)&&a.V==d&&(k=Rm(a,b),a.h.set(c.Na,k),Sm(a,k,0)),H(l)}})}
function Tm(a){var b=a.h.get(Kc);b&&(Km(b),Lm(b).catch(function(){}),a.H=a.h.get(Kc),a.h.delete(Kc),b.stream&&b.stream.closeSegmentIndex&&b.stream.closeSegmentIndex());a.B=null}
function Um(a,b){for(var c=a.g.Ob()<0,d=u(a.h.values()),e=d.next();!e.done;e=d.next())e=e.value,e.ua&&e.ua.Jd(c),e.ia&&e.ia.Jd(c);d=u(a.m.values());for(e=d.next();!e.done;e=d.next())e.value.Jd(c);if(c=a.h.get("video"))if(d=c.stream)if(b)(b=d.trickModeVideo)&&!c.Nc&&(Vm(a,b,!1,0,!1),c.Nc=d);else if(b=c.Nc)c.Nc=null,Vm(a,b,!0,0,!1)}
function Wm(a,b,c,d,e,f){c=c===void 0?!1:c;d=d===void 0?0:d;e=e===void 0?!1:e;f=f===void 0?!1:f;a.o=b;a.N&&(b.video&&Vm(a,b.video,c,d,e,f),b.audio&&Vm(a,b.audio,c,d,e,f))}function Xm(a,b){O(function(c){if(c.g==1)return a.H=null,a.B=b,a.N?b.segmentIndex?c.A(2):G(c,b.createSegmentIndex(),2):c.return();Vm(a,b,!0,0,!1);H(c)})}function Ym(a){var b=a.h.get(Kc);b&&Vm(a,b.stream,!0,0,!0)}
function Zm(a,b){for(var c=u(a.M.entries()),d=c.next();!d.done;d=c.next()){var e=u(d.value);d=e.next().value;e=e.next().value;d.includes(b.type)&&(e(),a.M.delete(d))}}
function Vm(a,b,c,d,e,f){var g=a.h.get(b.type);g||b.type!=Kc?g&&(g.Nc&&(b.trickModeVideo?(g.Nc=b,b=b.trickModeVideo):g.Nc=null),g.stream!=b||e)&&(a.m.has(b)?g.ia=a.m.get(b):g.ia&&xm(g.ia,b),b.type==Kc&&g.stream!=b&&(e=Se(b.mimeType,b.codecs),Lk(a.g.Z,e,a.j.sequenceMode,b.external)),!a.m.has(g.stream)&&g.stream.closeSegmentIndex&&(g.Ka?(e="("+g.type+":"+g.stream.id+")",a.M.has(e)||a.M.set(e,g.stream.closeSegmentIndex)):g.stream.closeSegmentIndex()),e=g.stream.isAudioMuxedInVideo!=b.isAudioMuxedInVideo,
g.stream=b,g.ua=null,g.gg=!!f,b.dependencyStream?g.Fc=Rm(a,b.dependencyStream):g.Fc=null,$m(a),e&&(g.pb=null,g.tc=null,g.sc=null,b.isAudioMuxedInVideo&&(b=null,g.type==="video"?b=a.h.get("audio"):g.type==="audio"&&(b=a.h.get("video")),b&&(Lm(b).catch(function(){}),b.pb=null,b.tc=null,b.sc=null,an(a,b),bn(a,b).catch(function(h){if(a.g)a.g.onError(h)})))),c?g.Wb?g.Md=!0:g.Ka?(g.Ub=!0,g.ld=d,g.Md=!0):(Km(g),cn(a,g,!0,d).catch(function(h){if(a.g)a.g.onError(h)})):g.Ka||g.qb||Sm(a,g,0),bn(a,g).catch(function(h){if(a.g)a.g.onError(h)})):
Qm(a,b)}
function bn(a,b){var c,d,e;return O(function(f){if(f.g==1){if(!b.Va)return f.return();c=b.stream;d=b.Va;return c.segmentIndex?f.A(2):G(f,c.createSegmentIndex(),2)}if(f.g!=4)return e=c.dependencyStream,!e||e.segmentIndex?f.A(4):G(f,e.createSegmentIndex(),4);if(b.Va!=d||b.stream!=c)return f.return();var g=a.g.nc();var h=Rk(a.g.Z,b.type),k=b.stream.segmentIndex.find(b.Ja?b.Ja.endTime:g),l=k==null?null:b.stream.segmentIndex.get(k);k=l?Aj(l):null;l&&!k&&(k=(l.endTime-l.getStartTime())*(b.stream.bandwidth||a.o.bandwidth)/
8);k?((l=l.ea)&&(k+=(l.endByte?l.endByte+1-l.startByte:null)||0),l=a.g.getBandwidthEstimate(),g=k*8/l<(h||0)-g-a.i.rebufferingGoal||b.Va.h.g>k?!0:!1):g=!0;g&&b.Va.abort();H(f)})}
p.bd=function(){if(this.g){for(var a=this.g.nc(),b=u(this.h.keys()),c=b.next();!c.done;c=b.next()){var d=c.value;c=this.h.get(d);var e;if(e=!this.J)e=this.g.Z,d==Kc?(e=e.h,e=e.g==null||e.h==null?!1:a>=e.g&&a<e.h):(e=Qk(e,d),e=Gj(e,a)),e=!e;if(e){this.R=0;c.ia&&(c.ia.h=null);if(c.type==="audio"){e=u(this.m.values());for(var f=e.next();!f.done;f=e.next())f.value.h=null}c.ua=null;(Rk(this.g.Z,d)!=null||c.Ka)&&an(this,c);c.Va&&(c.Va.abort(),c.Va=null);d===Kc&&(d=this.g.Z,d.K&&d.K.Pd());c.bd=!0}!this.J||
c.Wb||c.Ka||c.qb||Sm(this,c,0)}dn(this)&&en(this)}};function an(a,b){b.Wb||b.Ub||(b.Ka?(b.Ub=!0,b.ld=0):Pk(a.g.Z,b.type)==null?b.qb==null&&Sm(a,b,0):(Km(b),cn(a,b,!1,0).catch(function(c){if(a.g)a.g.onError(c)})))}
function Pm(a,b){var c,d,e,f,g,h,k,l;return O(function(m){if(m.g==1){if(!a.o)throw new U(2,5,5006);c=fn(a,!0);d=a.g.Z;return G(m,d.init(c,a.j.sequenceMode,a.j.type,a.j.ignoreManifestTimestampsInSegmentsMode),2)}hh(a.l);a.updateDuration();e=u(c.keys());for(f=e.next();!f.done;f=e.next())g=f.value,h=c.get(g),a.h.has(g)||(k=Rm(a,h),b.has(h.id)&&(l=b.get(h.id),nm(l,function(n,q,r){return gn(n,q,r||null,a.i.retryParameters,a.g.vc)}),k.ia=l),a.h.set(g,k),Sm(a,k,0));$m(a);H(m)})}
function Rm(a,b){var c={stream:b,type:b.type,ua:null,ia:Mm(a,b),Ja:null,pb:null,pf:null,tc:null,sc:null,mf:null,nf:null,Nc:null,endOfStream:!1,Ka:!1,qb:null,Ub:!1,ld:0,Md:!1,Wb:!1,bd:!0,gg:!1,fh:!1,ce:!1,Va:null,Fc:null};b.dependencyStream&&(c.Fc=Rm(a,b.dependencyStream));return c}
function Mm(a,b){if(b.type==="video"&&a.i.disableVideoPrefetch||b.type==="audio"&&a.i.disableAudioPrefetch||b.type===Kc&&(b.mimeType=="application/cea-608"||b.mimeType=="application/cea-708")||b.type===Kc&&a.i.disableTextPrefetch)return null;if(a.m.has(b))return a.m.get(b);var c=a.h.get(b.type);return(c=c&&c.ia)&&b===c.i?c:a.i.segmentPrefetchLimit>0?new mm(a.i.segmentPrefetchLimit,b,function(d,e,f){return gn(d,e,f||null,a.i.retryParameters,a.g.vc)},a.g.Ob()<0,a.g.hl):null}
function Nm(a){for(var b=a.i.segmentPrefetchLimit,c=a.i.prefetchAudioLanguages,d=u(a.j.variants),e=d.next(),f={};!e.done;f={Mb:void 0},e=d.next())if(f.Mb=e.value,f.Mb.audio)if(a.m.has(f.Mb.audio)){if(e=a.m.get(f.Mb.audio),wm(e,b),!(b>0&&c.some(function(h){return function(k){return xf(h.Mb.audio.language,k)}}(f)))){var g=a.h.get(f.Mb.audio.type);e!==(g&&g.ia)&&vm(e);a.m.delete(f.Mb.audio)}}else b<=0||!c.some(function(h){return function(k){return xf(h.Mb.audio.language,k)}}(f))||!(e=Mm(a,f.Mb.audio))||
(f.Mb.audio.segmentIndex||f.Mb.audio.createSegmentIndex(),a.m.set(f.Mb.audio,e))}p.updateDuration=function(){var a=Hi(),b=this.j.presentationTimeline.getDuration();b<Infinity?(a&&(this.u&&this.u.stop(),il(this.g.Z)),this.g.Z.Ab(b)):a?(this.u&&this.u.Ea(.5),this.g.Z.Ab(Infinity)):this.g.Z.Ab(4294967296)};
function hn(a,b){var c,d,e,f,g,h,k,l,m;return O(function(n){switch(n.g){case 1:hh(a.l);c=Mc;if(b.Ka||b.qb==null||b.Wb)return n.return();b.qb=null;if(!b.Ub){n.A(2);break}return G(n,cn(a,b,b.Md,b.ld),3);case 3:return n.return();case 2:Zm(a,b);if(b.stream.segmentIndex){n.A(4);break}d=b.stream;sa(n,5);return G(n,b.stream.createSegmentIndex(),7);case 7:ua(n,6);break;case 5:return e=Aa(n),G(n,jn(a,b,e),8);case 8:return n.return();case 6:if(d!=b.stream)return d.closeSegmentIndex&&d.closeSegmentIndex(),b.Ka||
b.qb||Sm(a,b,0),n.return();case 4:if(!b.Fc){n.A(9);break}if(b.Fc.stream.segmentIndex){n.A(9);break}sa(n,11);return G(n,b.Fc.stream.createSegmentIndex(),13);case 13:ua(n,9);break;case 11:Aa(n);case 9:sa(n,14);f=kn(a,b);f!=null&&(Sm(a,b,f),b.ce=!1);ua(n,15);break;case 14:return g=Aa(n),G(n,jn(a,b,g),16);case 16:return n.return();case 15:if(b.type===c.Na)return n.return();h=[];b.stream&&!b.stream.isAudioMuxedInVideo&&h.push(b);k=b.type===c.aa?c.wa:c.aa;(l=a.h.get(k))&&l.stream&&!l.stream.isAudioMuxedInVideo&&
h.push(l);if(!a.N||!h.every(function(q){return q.endOfStream})){n.A(0);break}return G(n,a.g.Z.endOfStream(),18);case 18:hh(a.l),m=a.g.Z.getDuration(),m!=0&&m<a.j.presentationTimeline.getDuration()&&a.j.presentationTimeline.Ab(m),H(n)}})}
function kn(a,b){if(ln(b))return Zk(a.g.Z,b.stream.originalId||""),null;b.type==Kc&&$k(a.g.Z);if(b.stream.isAudioMuxedInVideo&&b.type=="audio")return null;if(b.type!=Kc&&Jk(a.g.Z))return mn(a,!0),null;var c=a.i.updateIntervalSeconds/Math.max(1,Math.abs(a.g.Ob()));if(!Ok(a.g.Z)&&b.type!=Kc)return c/2;var d=a.g.nc();if(b.type==="audio")for(var e=u(a.m.keys()),f=e.next();!f.done;f=e.next())f=a.m.get(f.value),f.Ya(d,!0),om(f,d);e=b.Ja?b.Ja.endTime:d;var g=Sk(a.g.Z,b.type,d);f=Math.max(1,Math.max(a.i.rebufferingGoal,
a.i.bufferingGoal)*a.C);var h=a.j.presentationTimeline.getDuration()-e,k=Rk(a.g.Z,b.type);if(h<1E-6&&k)return b.endOfStream=!0,b.type=="video"&&(c=a.h.get(Kc))&&ln(c)&&(c.endOfStream=!0),null;b.endOfStream=!1;if(g>=f)return c/2;h=!b.ua;k=nn(a,b,d,k);if(!k)return a=Infinity,(b=b.Ja)&&(a=b.endTime-b.startTime),Math.min(a/2,c);g=b.pb;var l=k.ea;g&&l&&xj(l,g)&&(g.g=l.g);g=!1;h&&b.gg&&(g=!0,b.gg=!1);h=Infinity;l=Array.from(a.h.values());l=u(l);for(var m=l.next();!m.done;m=l.next())m=m.value,ln(m)||m.ua&&
!m.ua.current()||(h=Math.min(h,m.Ja?m.Ja.endTime:d));if(e>=h+a.j.presentationTimeline.h)return c;b.ia&&b.ua&&!a.m.has(b.stream)&&(b.ia.Ya(k.startTime+.001),om(b.ia,k.startTime).catch(function(){}));if(dn(a)&&on(a,b,k))return null;pn(a,b,d,k,g).catch(function(){});b.Fc&&qn(a,b.Fc,d,f);return null}
function nn(a,b,c,d){if(b.ua)return(c=b.ua.current())&&b.Ja&&Math.abs(b.Ja.startTime-c.startTime)<.001&&(c=b.ua.next().value),c;if(b.Ja||d)return c=b.Ja?b.Ja.endTime:d,a=a.g.Ob()<0,b.stream.segmentIndex&&(b.ua=b.stream.segmentIndex.Xb(c,!1,a)),b.ua&&b.ua.next().value;d=a.j.sequenceMode||dn(a)?0:a.i.inaccurateManifestTolerance;var e=Math.max(c-d,0);a=a.g.Ob()<0;var f=null;d&&(b.stream.segmentIndex&&(b.ua=b.stream.segmentIndex.Xb(e,!1,a)),f=b.ua&&b.ua.next().value);f||(b.stream.segmentIndex&&(b.ua=
b.stream.segmentIndex.Xb(c,!1,a)),f=b.ua&&b.ua.next().value);return f}
function pn(a,b,c,d,e){var f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D;return O(function(C){switch(C.g){case 1:f=Mc;g=b.stream;h=b.ua;b.Ka=!0;sa(C,2);if(d.Kc()==2)throw new U(1,1,1011);return G(C,rn(a,b,d,e),4);case 4:hh(a.l);if(a.F)return C.return();k=g.mimeType=="video/mp4"||g.mimeType=="audio/mp4";l=window.ReadableStream;if((m=a.i.lowLatencyMode&&a.j.isLowLatency)&&l&&k&&(a.j.type!="HLS"||d.o))return r=new Uint8Array(0),v=t=!1,z=function(B){var J,F,L,K;return O(function(P){switch(P.g){case 1:if(t)return P.return();
v=!0;hh(a.l);if(a.F)return P.return();sa(P,2);r=Dc(r,B);J=!1;F=0;(new ph).box("mdat",function(Q){F=Q.size+Q.start;J=!0}).parse(r,!1,!0);if(!J){P.A(4);break}L=r.subarray(0,F);r=r.subarray(F);return G(P,sn(a,b,c,g,d,L,!0,e),5);case 5:b.ia&&b.ua&&om(b.ia,d.startTime,!0);case 4:ua(P,0);break;case 2:w=K=Aa(P),H(P)}})},G(C,tn(a,b,d,z),9);n=tn(a,b,d);return G(C,n,7);case 7:q=C.h;hh(a.l);if(a.F)return C.return();hh(a.l);return b.Ub?(b.Ka=!1,Sm(a,b,0),C.return()):G(C,sn(a,b,c,g,d,q,!1,e),6);case 9:y=C.h;if(w)throw w;
if(v){C.A(10);break}t=!0;hh(a.l);return a.F?C.return():b.Ub?(b.Ka=!1,Sm(a,b,0),C.return()):G(C,sn(a,b,c,g,d,y,!1,e),10);case 10:b.ia&&b.ua&&om(b.ia,d.startTime,!0);case 6:hh(a.l);if(a.F)return C.return();b.Ja=d;h.next();b.Ka=!1;b.fh=!1;A=a.g.Z.Gc();E=A[b.type];db(JSON.stringify(E));b.Ub||(I=null,b.type===f.wa?I=a.h.get(f.aa):b.type===f.aa&&(I=a.h.get(f.wa)),I&&I.type==f.aa?a.g.zd(d,b.stream,I.stream.isAudioMuxedInVideo,!1):a.g.zd(d,b.stream,b.stream.codecs.includes(","),!1));Km(b);Sm(a,b,0);ua(C,
0);break;case 2:D=Aa(C);hh(a.l,D);if(a.F)return C.return();b.Ka=!1;if(D.code==7001)b.Ka=!1,Km(b),Sm(a,b,0),C.A(0);else if(b.type==f.Na&&a.i.ignoreTextStreamFailures)a.h.delete(f.Na),C.A(0);else{if(D.code==3017)return G(C,un(a,b,D),0);b.ce=!0;D.category==1&&b.ia&&um(b.ia,d);D.severity=2;return G(C,jn(a,b,D),0)}}})}
function qn(a,b,c,d){var e,f,g,h,k,l,m,n,q,r,t,v,w;return O(function(z){switch(z.g){case 1:e=Mc;f=b.stream;for(k=(h=(g=f.segmentIndex)&&g.Xb(c))&&h.next().value;k&&a.O.includes(k.startTime);)k=h&&h.next().value;if(!k){z.A(0);break}l=k.ea;if(!l||xj(l,b.pb)){z.A(3);break}b.pb=l;sa(z,4);return G(z,tn(a,b,l),6);case 6:m=z.h;var y=a.g.Z;y.C&&Pc(y.C,m,0,f);a.O=[];ua(z,3);break;case 4:throw n=Aa(z),b.pb=null,n;case 3:if(b.Ja&&b.Ja==k){z.A(0);break}b.Ja=k;sa(z,8);return G(z,tn(a,b,k),10);case 10:q=z.h;y=
a.g.Z;y.C&&Pc(y.C,q,0,f);a.O.push(k.startTime);ua(z,9);break;case 8:throw r=Aa(z),b.Ja=null,r;case 9:b.Ub||(t=null,b.type===e.wa?t=a.h.get(e.aa):b.type===e.aa&&(t=a.h.get(e.wa)),t&&t.type==e.aa?a.g.zd(k,b.stream,t.stream.isAudioMuxedInVideo,!0):a.g.zd(k,b.stream,b.stream.codecs.includes(","),!0));v=Math.max.apply(Math,[0].concat(x(a.O)));w=a.g.nc();if(w+d>v)return G(z,qn(a,b,k.startTime,d),0);z.A(0)}})}
function un(a,b,c){var d,e,f,g,h,k,l,m,n;return O(function(q){switch(q.g){case 1:d=Array.from(a.h.values());if(e=d.some(function(r){return r!=b&&r.fh})){q.A(2);break}if(a.i.avoidEvictionOnQuotaExceededError){f=vn(a,c);if(g=a.g.disableStream(b.stream,f))return q.return();Sm(a,b,4);return q.return()}h=Math.round(100*a.C);if(h>20){a.C-=.2;q.A(3);break}if(h>4){a.C-=.04;q.A(3);break}k=vn(a,c);l=a.g.disableStream(b.stream,k);if(!l){b.ce=!0;a.F=!0;a.g.onError(c);q.A(5);break}a.C=1;m=a.g.nc();return G(q,
wn(a,b,m),5);case 5:return q.return();case 3:return b.fh=!0,n=a.g.nc(),G(q,wn(a,b,n),2);case 2:Sm(a,b,4),H(q)}})}
function rn(a,b,c,d){var e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A;return O(function(E){switch(E.g){case 1:e=Mc;f=b.Ja==null;g=[];h=Math.max(0,Math.max(c.appendWindowStart,a.ba)-.1);k=Math.min(c.appendWindowEnd,a.$)+.1;l=c.codecs||b.stream.codecs;m=$e(l);n=af(c.mimeType||b.stream.mimeType);q=c.timestampOffset;if(q==b.pf&&h==b.tc&&k==b.sc&&m==b.mf&&n==b.nf){E.A(2);break}r=b.mf&&b.nf&&ul(a.g.Z,b.type,n,l,fn(a));if(!r){E.A(3);break}t=null;b.type===e.wa?t=a.h.get(e.aa):b.type===e.aa&&(t=a.h.get(e.wa));if(!t){E.A(3);
break}return G(E,Lm(t).catch(function(){}),5);case 5:t.pb=null,t.tc=null,t.sc=null,an(a,t);case 3:return G(E,xn(a,b,q,h,k,c,m,n),2);case 2:return xj(c.ea,b.pb)||(b.pb=c.ea,c.l&&c.ea&&(v=tn(a,b,c.ea),w=function(){var I,D,C,B,J,F,L,K,P,Q,N;return O(function(M){switch(M.g){case 1:return sa(M,2),G(M,v,4);case 4:return I=M.h,hh(a.l),D=null,C=new Map,B={projection:null,hfov:null},b.stream&&(J=b.stream.videoLayout)&&(F=J.split("/"),F.includes("PROJ-RECT")?B.projection="rect":F.includes("PROJ-EQUI")?B.projection=
"equi":F.includes("PROJ-HEQU")?B.projection="hequ":F.includes("PROJ-PRIM")?B.projection="prim":F.includes("PROJ-AIV")&&(B.projection="hequ")),L=new ph,L.box("moov",uh).box("trak",uh).box("mdia",uh).S("mdhd",function(R){D=Ki(R.reader,R.version).timescale}).box("hdlr",function(R){R=R.reader;R.skip(8);switch(R.Yc()){case "soun":C.set(e.aa,D);break;case "vide":C.set(e.wa,D)}D=null}),b.type!==e.wa||B.projection||L.box("minf",uh).box("stbl",uh).S("stsd",zh).box("encv",Ah).box("avc1",Ah).box("avc3",Ah).box("hev1",
Ah).box("hvc1",Ah).box("dvav",Ah).box("dva1",Ah).box("dvh1",Ah).box("dvhe",Ah).box("dvc1",Ah).box("dvi1",Ah).box("vexu",uh).box("proj",uh).S("prji",function(R){R=R.reader.Yc();B.projection=R}).box("hfov",function(R){R=R.reader.U()/1E3;B.hfov=R}),L.parse(I,!0,!0),b.type===e.wa&&yn(a,B),C.has(b.type)?c.ea.timescale=C.get(b.type):D!=null&&(c.ea.timescale=D),K=b.stream.segmentIndex,K instanceof Xl&&(P=Zl(K,c.startTime)),Q=b.stream.closedCaptions&&b.stream.closedCaptions.size>0,G(M,a.g.Uh(b.type,I),5);
case 5:return G(M,Uk(a.g.Z,b.type,I,null,b.stream,Q,b.bd,d,!1,!1,P),6);case 6:ua(M,0);break;case 2:throw N=Aa(M),b.pb=null,N;}})},z=c.startTime,f&&(y=Rk(a.g.Z,b.type),y!=null&&(z=y)),a.g.Fk(z,c.ea),g.push(w()))),A=b.Ja?b.Ja.i:-1,c.i!=A&&g.push(fl(a.g.Z,b.type,c.startTime)),G(E,Promise.all(g),0)}})}
function xn(a,b,c,d,e,f,g,h){var k,l,m,n,q;return O(function(r){switch(r.g){case 1:k=Mc;l=fn(a);sa(r,2);b.tc=d;b.sc=e;g&&(b.mf=g);h&&(b.nf=h);b.pf=c;m=a.j.sequenceMode||a.j.type=="HLS";n=null;b.type===k.wa?n=a.h.get(k.aa):b.type===k.aa&&(n=a.h.get(k.wa));if(!(n&&n.stream&&n.stream.isAudioMuxedInVideo)){r.A(4);break}return G(r,cl(a.g.Z,n.type,c,d,e,m,n.stream.mimeType,n.stream.codecs,l),4);case 4:return G(r,cl(a.g.Z,b.type,c,d,e,m,f.mimeType||b.stream.mimeType,f.codecs||b.stream.codecs,l),6);case 6:ua(r,
0);break;case 2:throw q=Aa(r),b.tc=null,b.sc=null,b.mf=null,b.nf=null,b.pf=null,q;}})}
function sn(a,b,c,d,e,f,g,h){g=g===void 0?!1:g;h=h===void 0?!1:h;var k,l,m,n,q;return O(function(r){switch(r.g){case 1:return k=d.closedCaptions&&d.closedCaptions.size>0,a.i.shouldFixTimestampOffset&&(l=d.mimeType=="video/mp4"||d.mimeType=="audio/mp4",m=null,e.ea&&(m=e.ea.timescale),(n=l&&m&&d.type==="video"&&a.j.type=="DASH")&&(new ph).box("moof",uh).box("traf",uh).S("tfdt",function(t){var v,w,z,y,A,E;return O(function(I){v=Ji(t.reader,t.version);w=v.baseMediaDecodeTime;if(!w)return I.return();z=
-w/m;y=Number(b.pf)||0;if(!(y<z))return I.A(0);A=b.tc;E=b.sc;return G(I,xn(a,b,z,A,E,e),0)})}).parse(f,!1,g)),G(r,wn(a,b,c),2);case 2:return hh(a.l),q=b.bd,b.bd=!1,G(r,a.g.Uh(b.type,f),3);case 3:return G(r,Uk(a.g.Z,b.type,f,e,d,k,q,h,g),4);case 4:hh(a.l),H(r)}})}
function wn(a,b,c){var d,e,f,g,h,k,l,m,n;return O(function(q){if(q.g==1){a.H==b&&(a.H=null);d=b.stream.segmentIndex;d instanceof Xl&&(d.Ya(a.j.presentationTimeline.Hb()),e=[],Yl(d,function(r){e.push(r.We())}));f=Math.max(a.i.bufferBehind*a.C,a.j.presentationTimeline.h);g=Pk(a.g.Z,b.type);if(g==null)return q.return();h=c-g;k=a.i.evictionGoal;l=a.j.presentationTimeline.Zb();m=a.j.presentationTimeline.Gb();n=h-f;m-l>k&&(n=Math.max(h-f,l-k-g));return n<=k?q.return():G(q,a.g.Z.remove(b.type,g,g+n,e),2)}if(q.g!=
4)return hh(a.l),a.H?G(q,wn(a,a.H,c),4):q.A(0);hh(a.l);H(q)})}function ln(a){return a&&a.type==Kc&&(a.stream.mimeType=="application/cea-608"||a.stream.mimeType=="application/cea-708")}
function tn(a,b,c,d){var e,f,g,h,k;return O(function(l){switch(l.g){case 1:if(e=c.$b())return l.return(e);f=null;if(b.ia){var m=b.ia,n=m.g;c instanceof wj&&(n=m.j);n.has(c)?(m=n.get(c),d&&(m.Bh=d),f=m.oe):f=null}f||(f=gn(c,b.stream,d||null,a.i.retryParameters,a.g.vc));g=0;b.ua&&(g=b.ua.h);b.Va=f;return G(l,f.promise,2);case 2:h=l.h;b.Va=null;k=h.data;if(!c.aesKey){l.A(3);break}return G(l,Dm(k,c.aesKey,g),4);case 4:k=l.h;case 3:return l.return(k)}})}
function gn(a,b,c,d,e,f){f=f===void 0?!1:f;var g=a instanceof yj?a:void 0,h=g?1:0;a=Hm(a.P(),a.startByte,a.endByte,d,c);a.contentType=b.type;return e.request(eh,a,{type:h,stream:b,segment:g,isPreload:f})}
function cn(a,b,c,d){var e,f;return O(function(g){if(g.g==1)return b.Ub=!1,b.Md=!1,b.ld=0,b.Wb=!0,b.Ja=null,b.ua=null,b.ia&&!a.m.has(b.stream)&&vm(b.ia),d?(e=a.g.nc(),f=a.g.Z.getDuration(),G(g,a.g.Z.remove(b.type,e+d,f),3)):G(g,bl(a.g.Z,b.type),4);if(g.g!=3)return hh(a.l),c?G(g,a.g.Z.flush(b.type),3):g.A(3);hh(a.l);b.Wb=!1;b.endOfStream=!1;b.Ka||b.qb||Sm(a,b,0);H(g)})}
function Sm(a,b,c){var d=b.type;if(d!=Kc||a.h.has(d))b.qb=(new qf(function(){var e;return O(function(f){if(f.g==1)return sa(f,2),G(f,hn(a,b),4);if(f.g!=2)return ua(f,0);e=Aa(f);if(a.g)a.g.onError(e);H(f)})})).ka(c)}function Km(a){a.qb!=null&&(a.qb.stop(),a.qb=null)}function Lm(a){return O(function(b){return a.Va?G(b,a.Va.abort(),0):b.A(0)})}
function jn(a,b,c){var d;return O(function(e){if(e.g==1)return c.code==3024?(b.Ka=!1,Km(b),Sm(a,b,0),e.return()):G(e,Gg(a.X),2);hh(a.l);if(c.category===1&&c.code!=1003){if(b.Nc)return Um(a,!1),e.return();d=vn(a,c);c.handled=a.g.disableStream(b.stream,d);c.handled&&(c.severity=1)}if(!c.handled||c.code!=1011)a.g.onError(c);c.handled||a.i.failureCallback(c);H(e)})}function vn(a,b){return a.i.maxDisabledTime===0&&b.code==1011?1:a.i.maxDisabledTime}
function mn(a,b){b=b===void 0?!1:b;var c,d,e,f,g,h;return O(function(k){if(k.g==1){c=Date.now()/1E3;d=a.i.minTimeBetweenRecoveries;if(!b){if(!a.i.allowMediaSourceRecoveries||c-a.R<d)return k.return(!1);a.R=c}e=Mc;if(f=a.h.get(e.aa))Km(f),f.Va&&(f.Va.abort(),f.Va=null),f.pb=null,f.tc=null,f.sc=null,f.Ka=!1,f.Ub=!1,f.ld=0,f.Md=!1,f.Wb=!1,f.ua&&f.ua.jh();if(g=a.h.get(e.wa))Km(g),g.Va&&(g.Va.abort(),g.Va=null),g.pb=null,g.tc=null,g.sc=null,g.Ka=!1,g.Ub=!1,g.ld=0,g.Md=!1,g.Wb=!1,g.ua&&g.ua.jh();h=a.g.video.paused;
return G(k,ol(a.g.Z,fn(a)),2)}!g||g.Wb||g.Ka||g.qb||Sm(a,g,0);!f||f.Wb||f.Ka||f.qb||Sm(a,f,0);h||a.g.video.play();return k.return(!0)})}function yn(a,b){if(a.T.projection!=b.projection||a.T.hfov!=b.hfov){if(b.projection!=null||b.hfov!=null){var c=(new Map).set("detail",b);c=new V("spatialvideoinfo",c)}else c=new V("nospatialvideoinfo");c.cancelable=!0;a.g.onEvent(c);a.T=b}}
function dn(a){if(a.i.crossBoundaryStrategy!=="keep")return!0;var b=rb();if(!b.Ib()){b=u(a.h.keys());for(var c=b.next();!c.done;c=b.next())if(c=a.h.get(c.value),c.type!==Mc.Na&&(c=c.stream)&&c.fullMimeTypes&&c.fullMimeTypes.size>1)return!0}else if(!b.Nf())for(b=u(a.h.keys()),c=b.next();!c.done;c=b.next())if(c=a.h.get(c.value),c.type!==Mc.Na&&(c=c.stream)&&c.fullMimeTypes&&c.fullMimeTypes.size>1){a=new Set;b=u(c.fullMimeTypes);for(c=b.next();!c.done;c=b.next())a.add(Xe(c.value));return a.size>1}return!1}
function $m(a){a.G.Qa();dn(a)&&(a.G.D(a.g.video,"waiting",function(){return en(a)}),a.G.D(a.g.video,"timeupdate",function(){return en(a)}))}function en(a){if(dn(a)){a.K.stop();var b=a.g.nc(),c=a.h.get("video")||a.h.get("audio");c&&(c=c.pb)&&c.g!==null&&(b=c.g-b,b<0||b>1||(a.I=c.g+.1,a.K.ka(b)))}}
function on(a,b,c){if(b.type===Kc)return!1;var d=b.pb;if(!d)return!1;var e=c.ea;c=d.g!==e.g;a.i.crossBoundaryStrategy==="reset_to_encrypted"&&(d.encrypted||e.encrypted||(c=!1),d.encrypted&&(a.i.crossBoundaryStrategy="keep"));a.i.crossBoundaryStrategy==="RESET_ON_ENCRYPTION_CHANGE"&&d.encrypted==e.encrypted&&(c=!1);if(a.i.crossBoundaryStrategy==="keep"&&d.mimeType&&e.mimeType){var f=Ye(bf(d.mimeType)),g=Ye(bf(d.mimeType));d.mimeType==e.mimeType&&f==g&&(c=!1)}c&&(a.J||b.bd)&&(a.J=!1,mn(a,!0).then(function(){var h=
(new Map).set("oldEncrypted",d.encrypted).set("newEncrypted",e.encrypted);a.g.onEvent(new V("boundarycrossed",h))}));return c}function fn(a,b){function c(f){if(f.fullMimeTypes&&f.fullMimeTypes.size>1&&a.h.has(f.type)){var g=a.h.get(f.type),h=Rk(a.g.Z,g.type),k=a.g.nc();(g=nn(a,g,k,h))&&g.codecs&&g.mimeType&&(f.codecs=g.codecs,f.mimeType=g.mimeType)}}b=b===void 0?!1:b;var d=new Map,e=a.o.audio;e&&(c(e),d.set("audio",e));if(e=a.o.video)c(e),d.set("video",e);b&&a.B&&d.set(Kc,a.B);return d};function zn(){}
function An(a,b,c,d,e){var f=e in d;var g=f?c.constructor==Object&&Object.keys(d).length==0:c.constructor==Object&&Object.keys(c).length==0;var h=f||g,k=!0,l;for(l in b){var m=e+"."+l,n=f?d[e]:c[l];h||l in c?b[l]===void 0?n===void 0||h?delete a[l]:a[l]=wd(n):g?a[l]=b[l]:n.constructor==Object&&b[l]&&b[l].constructor==Object?(a[l]||(a[l]=wd(n)),m=An(a[l],b[l],n,d,m),k=k&&m):typeof b[l]!=typeof n||b[l]==null||typeof b[l]!="function"&&b[l].constructor!=n.constructor?(Za("Invalid config, wrong type for "+m),
k=!1):typeof c[l]=="function"&&c[l].length!=b[l].length?($a("Unexpected number of arguments for "+m),a[l]=b[l]):a[l]=Array.isArray(a[l])?b[l].slice():b[l]:(Za("Invalid config, unrecognized key "+m),k=!1)}return k}function Bn(a,b){for(var c={},d=c,e=0,f=0;;){e=a.indexOf(".",e);if(e<0)break;if(e==0||a[e-1]!="\\")f=a.substring(f,e).replace(/\\\./g,"."),d[f]={},d=d[f],f=e+1;e+=1}d[a.substring(f).replace(/\\\./g,".")]=b;return c}function Cn(a,b){return a&&b}
function Dn(a,b){function c(f){for(var g=u(Object.keys(f)),h=g.next();!h.done;h=g.next())if(h=h.value,!(f[h]instanceof HTMLElement))if(e(f[h])&&Object.keys(f[h]).length===0)delete f[h];else{var k=f[h];Array.isArray(k)&&k.length===0?delete f[h]:typeof f[h]=="function"?delete f[h]:e(f[h])&&(c(f[h]),Object.keys(f[h]).length===0&&delete f[h])}}function d(f,g){return Object.keys(f).reduce(function(h,k){var l=f[k];if(g.hasOwnProperty(k))if(l instanceof HTMLElement&&g[k]instanceof HTMLElement)l.isEqualNode(g[k])||
(h[k]=l);else if(e(l)&&e(g[k])){if(l=d(l,g[k]),Object.keys(l).length>0||!e(l))h[k]=l}else Array.isArray(l)&&Array.isArray(g[k])?hb(l,g[k])||(h[k]=l):Number.isNaN(l)&&Number.isNaN(g[k])||l!==g[k]&&(h[k]=l);else h[k]=l;return h},{})}function e(f){return f&&typeof f==="object"&&!Array.isArray(f)}a=d(a,b);c(a);return a}T("shaka.util.ConfigUtils",zn);zn.getDifferenceFromConfigObjects=Dn;zn.convertToConfigObject=Bn;zn.mergeConfigObjects=An;T("shaka.config.RepeatMode",{OFF:0,ALL:1,SINGLE:2});function En(){}function Fn(a){a=sc(a);return(new Db(a)).Db}function Gn(a,b,c){function d(h){ac(f).setUint32(g,h.byteLength,!0);g+=4;f.set(Wb(h),g);g+=h.byteLength}if(!c||!c.byteLength)throw new U(2,6,6015);var e;typeof b=="string"?e=vc(b,!0):e=b;a=sc(a);a=vc(a,!0);var f=new Uint8Array(12+a.byteLength+e.byteLength+c.byteLength),g=0;d(a);d(e);d(c);return f}function Hn(a,b,c){if(b!=="skd")return a;b=c.serverCertificate;c=sc(a).split("skd://").pop();return Gn(a,c,b)}
function In(a,b){a===2&&(a=b.drmInfo)&&ic(a.keySystem)&&(b.headers["Content-Type"]="application/octet-stream")}T("shaka.drm.FairPlay",En);
En.commonFairPlayResponse=function(a,b){if(a===2&&(a=b.originalRequest.drmInfo)&&ic(a.keySystem)){try{var c=oc(b.data)}catch(e){return}a=!1;c=c.trim();c.substr(0,5)==="<ckc>"&&c.substr(-6)==="</ckc>"&&(c=c.slice(5,-6),a=!0);if(!a)try{var d=JSON.parse(c);d.ckc&&(c=d.ckc,a=!0);d.CkcMessage&&(c=d.CkcMessage,a=!0);d.License&&(c=d.License,a=!0)}catch(e){}a&&(b.data=Yb(Ac(c)))}};En.muxFairPlayRequest=function(a,b){In(a,b)};
En.expressplayFairPlayRequest=function(a,b){if(a===2){var c=b.drmInfo;c&&ic(c.keySystem)&&In(a,b)}};En.conaxFairPlayRequest=function(a,b){In(a,b)};En.ezdrmFairPlayRequest=function(a,b){In(a,b)};En.verimatrixFairPlayRequest=function(a,b){a===2&&(a=b.drmInfo)&&ic(a.keySystem)&&(a=Wb(b.body),a=zc(a),b.headers["Content-Type"]="application/x-www-form-urlencoded",b.body=uc("spc="+a))};En.muxInitDataTransform=function(a,b,c){return Hn(a,b,c)};
En.expressplayInitDataTransform=function(a,b,c){return Hn(a,b,c)};En.conaxInitDataTransform=function(a,b,c){if(b!=="skd")return a;b=c.serverCertificate;c=sc(a).split("skd://").pop().split("?").shift();c=window.atob(c);var d=new ArrayBuffer(c.length*2);d=$b(d);for(var e=0,f=c.length;e<f;e++)d[e]=c.charCodeAt(e);return Gn(a,d,b)};En.ezdrmInitDataTransform=function(a,b,c){if(b!=="skd")return a;b=c.serverCertificate;c=sc(a).split(";").pop();return Gn(a,c,b)};
En.verimatrixInitDataTransform=function(a,b,c){return Hn(a,b,c)};En.initDataTransform=Gn;En.defaultGetContentId=Fn;En.isFairPlaySupported=function(){var a;return O(function(b){if(b.g==1)return a={initDataTypes:["cenc","sinf","skd"],videoCapabilities:[{contentType:'video/mp4; codecs="avc1.42E01E"'}]},sa(b,2),G(b,navigator.requestMediaKeySystemAccess("com.apple.fps",[a]),4);if(b.g!=2)return b.return(!0);Aa(b);return b.return(!1)})};function Jn(a,b,c){c=c===void 0?!0:c;this.h=a;this.g=new Set([a]);b=b||[];a=u(b);for(b=a.next();!b.done;b=a.next())this.add(b.value,c)}
Jn.prototype.add=function(a,b){var c=this.h;b=b===void 0?!0:b;var d;if(!(d=!!c.audio!=!!a.audio||!!c.video!=!!a.video||c.language!=a.language)&&(d=c.audio&&a.audio)){d=c.audio;var e=a.audio;d=!(!((!d.channelsCount||!e.channelsCount||d.channelsCount>2||e.channelsCount>2)&&d.channelsCount!=e.channelsCount||d.spatialAudio!==e.spatialAudio||b&&!Kn(d,e))&&hb(d.roles,e.roles)&&d.groupId===e.groupId)}!d&&(d=c.video&&a.video)&&(c=c.video,d=a.video,d=!((!b||Kn(c,d))&&hb(c.roles,d.roles)));return d?!1:(this.g.add(a),
!0)};Jn.prototype.values=function(){return this.g.values()};function Kn(a,b){if(a.mimeType!=b.mimeType)return!1;a=a.codecs.split(",").map(function(c){return $e(c)});b=b.codecs.split(",").map(function(c){return $e(c)});return hb(a,b)}T("shaka.media.AdaptationSet",Jn);function Ln(){this.h=this.g=null}Ln.prototype.configure=function(a){this.g=a};Ln.prototype.getConfiguration=function(){return this.g};
Ln.prototype.create=function(a){var b;if(this.g.language){var c=Mn(a,this.g.language);c.length&&(b=c)}b||(b=a.filter(function(f){return f.primary}),b=b.length?b:a);a=Nn(b,this.g.role);a.length&&(b=a);a=On(b,this.g.videoRole);a.length&&(b=a);this.g.videoLayout&&(a=Pn(b,this.g.videoLayout),a.length&&(b=a));this.g.hdrLevel&&(a=Qn(b,this.g.hdrLevel),a.length&&(b=a));var d=[this.g.channelCount,this.g.preferredAudioChannelCount];a=d.filter(function(f,g){return f&&d.indexOf(f)===g});if(a.length)for(a=u(a),
c=a.next();!c.done;c=a.next())if(c=Rn(b,c.value),c.length){b=c;break}this.g.audioLabel&&(a=Sn(b,this.g.audioLabel),a.length&&(b=a));this.g.videoLabel&&(a=Tn(b,this.g.videoLabel),a.length&&(b=a));a=Un(b,this.g.spatialAudio);a.length&&(b=a);var e=[this.g.audioCodec,this.g.activeAudioCodec].concat(x(this.g.preferredAudioCodecs));a=e.filter(function(f,g){return f&&e.indexOf(f)===g});if(a.length)for(a=u(a),c=a.next();!c.done;c=a.next())if(c=Vn(b,c.value),c.length){b=c;break}a=rb();a=this.g.codecSwitchingStrategy==
"smooth"&&a.Ib();return this.h=new Jn(b[0],b,!a)};Ln.prototype.getLastAdaptationSet=function(){return this.h};function Mn(a,b){b=yf(b);var c=Ff(b,a.map(function(d){return Ef(d)}));return c?a.filter(function(d){return c==Ef(d)}):[]}function Nn(a,b){return a.filter(function(c){return c.audio?b?c.audio.roles.includes(b):c.audio.roles.length==0:!1})}function On(a,b){return a.filter(function(c){return c.video?b?c.video.roles.includes(b):c.video.roles.length==0:!1})}
function Sn(a,b){return a.filter(function(c){return c.audio&&c.audio.label?c.audio.label.toLowerCase()==b.toLowerCase():!1})}function Tn(a,b){return a.filter(function(c){return c.video&&c.video.label?c.video.label.toLowerCase()==b.toLowerCase():!1})}function Rn(a,b){return a.filter(function(c){return c.audio&&c.audio.channelsCount&&c.audio.channelsCount>b?!1:!0}).sort(function(c,d){return c.audio||d.audio?c.audio?d.audio?(d.audio.channelsCount||0)-(c.audio.channelsCount||0):1:-1:0})}
function Qn(a,b){if(b=="AUTO"){var c=a.some(function(d){return d.video&&d.video.hdr&&d.video.hdr=="HLG"?!0:!1});b=rb().sd(c)}return a.filter(function(d){return d.video&&d.video.hdr&&d.video.hdr!=b?!1:!0})}function Pn(a,b){return a.filter(function(c){return c.video&&c.video.videoLayout&&c.video.videoLayout!=b?!1:!0})}function Un(a,b){return a.filter(function(c){return c.audio&&c.audio.spatialAudio!=b?!1:!0})}function Vn(a,b){return a.filter(function(c){return c.audio&&c.audio.codecs!=b?!1:!0})};function Wn(){}
function Xn(){var a=Infinity,b=rb();navigator.connection&&navigator.connection.saveData&&(a=360);var c={retryParameters:Fg(),servers:{},clearKeys:{},advanced:{},delayLicenseRequestUntilPlayed:!1,persistentSessionOnlinePlayback:!1,persistentSessionsMetadata:[],initDataTransform:function(h,k,l){"apple"===window.shakaMediaKeysPolyfill&&k=="skd"&&(k=l.serverCertificate,l=Fn(h),h=Gn(h,l,k));return h},logLicenseExchange:!1,updateExpirationTime:1,preferredKeySystems:[],keySystemsMapping:{},parseInbandPsshEnabled:!1,
minHdcpVersion:"",ignoreDuplicateInitData:!0,defaultAudioRobustnessForWidevine:"SW_SECURE_CRYPTO",defaultVideoRobustnessForWidevine:"SW_SECURE_DECODE"},d="reload";b.Ib()&&(d="smooth");var e={retryParameters:Fg(),availabilityWindowOverride:NaN,disableAudio:!1,disableVideo:!1,disableText:!1,disableThumbnails:!1,disableIFrames:!1,defaultPresentationDelay:0,segmentRelativeVttTiming:!1,raiseFatalErrorOnManifestUpdateRequestFailure:!1,continueLoadingWhenPaused:!0,ignoreSupplementalCodecs:!1,updatePeriod:-1,
ignoreDrmInfo:!1,enableAudioGroups:!0,dash:{clockSyncUri:"",disableXlinkProcessing:!0,xlinkFailGracefully:!1,ignoreMinBufferTime:!1,autoCorrectDrift:!0,initialSegmentLimit:1E3,ignoreSuggestedPresentationDelay:!1,ignoreEmptyAdaptationSet:!1,ignoreMaxSegmentDuration:!1,keySystemsByURI:{"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:e2719d58-a985-b3c9-781a-b030af78d30e":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready",
"urn:uuid:79f0049a-4098-8642-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:94ce86fb-07ff-4f43-adb8-93d2fa968ca2":"com.apple.fps","urn:uuid:3d5e6d35-9b9a-41e8-b843-dd3c6e72c42c":"com.huawei.wiseplay"},manifestPreprocessor:Yn,manifestPreprocessorTXml:Zn,sequenceMode:!1,useStreamOnceInPeriodFlattening:!1,enableFastSwitching:!0},hls:{ignoreTextStreamFailures:!1,ignoreImageStreamFailures:!1,defaultAudioCodec:"mp4a.40.2",defaultVideoCodec:"avc1.42E01E",ignoreManifestProgramDateTime:!1,ignoreManifestProgramDateTimeForTypes:[],
mediaPlaylistFullMimeType:'video/mp2t; codecs="avc1.42E01E, mp4a.40.2"',liveSegmentsDelay:3,sequenceMode:b.fd(),ignoreManifestTimestampsInSegmentsMode:!1,disableCodecGuessing:!1,disableClosedCaptionsDetection:!1,allowLowLatencyByteRangeOptimization:!0,allowRangeRequestsToGuessMimeType:!1},mss:{manifestPreprocessor:Yn,manifestPreprocessorTXml:Zn,sequenceMode:!1,keySystemsBySystemId:{"9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","79f0049a-4098-8642-ab92-e65be0885f95":"com.microsoft.playready"}}},
f={trackSelectionCallback:function(h){return O(function(k){return k.return(h)})},downloadSizeCallback:function(h){var k;return O(function(l){if(l.g==1)return navigator.storage&&navigator.storage.estimate?G(l,navigator.storage.estimate(),3):l.return(!0);k=l.h;return l.return(k.usage+h<k.quota*.95)})},progressCallback:function(h,k){return Cn([h,k])},usePersistentLicense:!0,numberOfParallelDownloads:5},g={drm:c,manifest:e,streaming:{retryParameters:Fg(),failureCallback:function(h){return Cn([h])},rebufferingGoal:0,
bufferingGoal:10,bufferBehind:30,evictionGoal:1,ignoreTextStreamFailures:!1,alwaysStreamText:!1,startAtSegmentBoundary:!1,gapDetectionThreshold:.5,gapPadding:0,gapJumpTimerTime:.25,durationBackoff:1,safeSeekOffset:5,safeSeekEndOffset:0,stallEnabled:!0,stallThreshold:1,stallSkip:.1,useNativeHlsForFairPlay:!0,inaccurateManifestTolerance:2,lowLatencyMode:!0,preferNativeDash:!1,preferNativeHls:!1,updateIntervalSeconds:1,observeQualityChanges:!1,maxDisabledTime:30,segmentPrefetchLimit:1,prefetchAudioLanguages:[],
disableAudioPrefetch:!1,disableTextPrefetch:!1,disableVideoPrefetch:!1,liveSync:{enabled:!1,targetLatency:.5,targetLatencyTolerance:.5,maxPlaybackRate:1.1,minPlaybackRate:.95,panicMode:!1,panicThreshold:60,dynamicTargetLatency:{enabled:!1,stabilityThreshold:60,rebufferIncrement:.5,maxAttempts:10,maxLatency:4,minLatency:1}},allowMediaSourceRecoveries:!0,minTimeBetweenRecoveries:5,vodDynamicPlaybackRate:!1,vodDynamicPlaybackRateLowBufferRate:.95,vodDynamicPlaybackRateBufferRatio:.5,preloadNextUrlWindow:30,
loadTimeout:30,clearDecodingCache:!1,dontChooseCodecs:!1,shouldFixTimestampOffset:!1,avoidEvictionOnQuotaExceededError:!1,crossBoundaryStrategy:"keep",returnToEndOfLiveWindowWhenOutside:!1},networking:{forceHTTP:!1,forceHTTPS:!1,minBytesForProgressEvents:16E3},mediaSource:{codecSwitchingStrategy:d,addExtraFeaturesToSourceBuffer:function(h){return Cn([h],"")},forceTransmux:!1,insertFakeEncryptionInInit:!0,correctEc3Enca:!1,modifyCueCallback:function(h,k,l){return Cn([h,k,l])},dispatchAllEmsgBoxes:!1,
useSourceElements:!0,durationReductionEmitsUpdateEnd:!0},offline:f,abrFactory:function(){return new zg},adaptationSetCriteriaFactory:function(){return new (Function.prototype.bind.apply(Ln,[null].concat(x(Na.apply(0,arguments)))))},abr:{enabled:!0,useNetworkInformation:!0,defaultBandwidthEstimate:1E6,switchInterval:8,bandwidthUpgradeTarget:.85,bandwidthDowngradeTarget:.95,restrictions:{minWidth:0,maxWidth:Infinity,minHeight:0,maxHeight:a,minPixels:0,maxPixels:Infinity,minFrameRate:0,maxFrameRate:Infinity,
minBandwidth:0,maxBandwidth:Infinity,minChannelsCount:0,maxChannelsCount:Infinity},advanced:{minTotalBytes:128E3,minBytes:16E3,fastHalfLife:2,slowHalfLife:5},restrictToElementSize:!1,restrictToScreenSize:!1,ignoreDevicePixelRatio:!1,clearBufferSwitch:!1,safeMarginSwitch:0,cacheLoadThreshold:5,minTimeToSwitch:0,preferNetworkInformationBandwidth:!1,removeLatencyFromFirstPacketTime:!1},autoShowText:3,preferredAudioLanguage:"",preferredAudioLabel:"",preferredTextLanguage:"",preferredAudioRole:"",preferredVideoRole:"",
preferredTextRole:"",preferredAudioChannelCount:2,preferredVideoHdrLevel:"AUTO",preferredVideoLayout:"",preferredVideoLabel:"",preferredVideoCodecs:[],preferredAudioCodecs:[],preferredTextFormats:[],preferForcedSubs:!1,preferSpatialAudio:!1,preferredDecodingAttributes:[],restrictions:{minWidth:0,maxWidth:Infinity,minHeight:0,maxHeight:Infinity,minPixels:0,maxPixels:Infinity,minFrameRate:0,maxFrameRate:Infinity,minBandwidth:0,maxBandwidth:Infinity,minChannelsCount:0,maxChannelsCount:Infinity},playRangeStart:0,
playRangeEnd:Infinity,textDisplayer:{captionsUpdatePeriod:.25,fontScaleFactor:1},textDisplayFactory:function(){return null},cmcd:{enabled:!1,sessionId:"",contentId:"",rtpSafetyFactor:5,useHeaders:!1,includeKeys:[],version:1,targets:[]},cmsd:{enabled:!0,applyMaximumSuggestedBitrate:!0,estimatedThroughputWeightRatio:.5},lcevc:{enabled:!1,dynamicPerformanceScaling:!0,logLevel:0,drawLogo:!1,poster:!0},ads:{customPlayheadTracker:!1,skipPlayDetection:!1,supportsMultipleMediaElements:!0,disableHLSInterstitial:!1,
disableDASHInterstitial:!1,allowPreloadOnDomElements:!0,allowStartInMiddleOfInterstitial:!0},ignoreHardwareResolution:!1,queue:{preloadNextUrlWindow:Infinity,preloadPrevItem:!0,repeatMode:0}};f.trackSelectionCallback=function(h){return O(function(k){return k.return($n(h,g.preferredAudioLanguage,g.preferredVideoHdrLevel))})};return b.Wa(g)}
function ao(){return{streaming:{inaccurateManifestTolerance:0,segmentPrefetchLimit:2,updateIntervalSeconds:.1,maxDisabledTime:1,retryParameters:{baseDelay:100}},manifest:{dash:{autoCorrectDrift:!1},retryParameters:{baseDelay:100}},drm:{retryParameters:{baseDelay:100}}}}
function bo(a,b,c){var d={".drm.keySystemsMapping":"",".drm.servers":"",".drm.clearKeys":"",".drm.advanced":{distinctiveIdentifierRequired:!1,persistentStateRequired:!1,videoRobustness:[],audioRobustness:[],sessionType:"",serverCertificate:new Uint8Array(0),serverCertificateUri:"",individualizationServer:"",headers:{}}};return An(a,b,c||Xn(),d,"")}
function $n(a,b,c){var d=c;d=="AUTO"&&(c=a.some(function(h){return h.hdr&&h.hdr=="HLG"?!0:!1}),d=rb().sd(c));var e=a.filter(function(h){return h.type!="variant"||h.hdr&&h.hdr!=d?!1:!0});c=[];var f=Ff(b,e.map(function(h){return h.language}));f&&(c=e.filter(function(h){return yf(h.language)==f}));c.length==0&&(c=e.filter(function(h){return h.primary}));c.length==0&&(e.map(function(h){return h.language}),c=e);var g=c.filter(function(h){return h.height&&h.height<=480});g.length&&(g.sort(function(h,k){return k.height-
h.height}),c=g.filter(function(h){return h.height==g[0].height}));b=[];c.length&&(e=Math.floor(c.length/2),c.sort(function(h,k){return h.bandwidth-k.bandwidth}),b.push(c[e]));a=u(a);for(c=a.next();!c.done;c=a.next())c=c.value,c.type!=Kc&&c.type!="image"||b.push(c);return b}function Yn(a){return Cn([a],a)}function Zn(a){return Cn([a],a)}T("shaka.util.PlayerConfiguration",Wn);Wn.mergeConfigObjects=bo;Wn.createDefaultForLL=ao;Wn.createDefault=Xn;function co(){this.g=null;this.h=[]}function eo(a,b){var c=0;a.g&&a.g.state==b&&(c+=a.g.duration);a=u(a.h);for(var d=a.next();!d.done;d=a.next())d=d.value,c+=d.state==b?d.duration:0;return c}function fo(a){function b(f){return{timestamp:f.timestamp,state:f.state,duration:f.duration}}for(var c=[],d=u(a.h),e=d.next();!e.done;e=d.next())c.push(b(e.value));a.g&&c.push(b(a.g));return c};function go(){this.i=this.h=null;this.g=[]}function ho(a,b,c){a.i!=b&&(a.i=b,a.g.push({timestamp:Date.now()/1E3,id:b.id,type:"text",fromAdaptation:c,bandwidth:null}))};function io(){this.C=this.X=NaN;this.l="";this.j=this.wi=this.u=this.B=this.K=this.F=this.o=this.m=this.J=this.G=this.i=this.T=this.V=this.N=this.O=this.R=NaN;this.M=0;this.H=this.I=NaN;this.g=new co;this.h=new go}function jo(a,b,c){a.R=b;a.O=c}function ko(a,b,c){a.X=b;a.C=c}function lo(a,b){a.i=isNaN(a.i)?b:Math.max(a.i,b)}function mo(a,b){a.j=isNaN(a.j)?b:a.j+b}
function no(a){var b=a.X,c=a.C,d=a.l,e=a.B,f=a.O,g=a.R,h=a.N,k=a.V,l=a.T,m=a.u,n=a.i,q=a.G,r=a.J,t=a.m,v=eo(a.g,"playing"),w=eo(a.g,"paused"),z=eo(a.g,"buffering"),y=a.o,A=a.F,E=a.K,I=a.wi,D=a.j,C=a.M,B=a.I,J=a.H,F=fo(a.g),L=[];a=u(a.h.g);for(var K=a.next();!K.done;K=a.next())K=K.value,L.push({timestamp:K.timestamp,id:K.id,type:K.type,fromAdaptation:K.fromAdaptation,bandwidth:K.bandwidth});return{width:b,height:c,currentCodecs:d,streamBandwidth:e,decodedFrames:f,droppedFrames:g,corruptedFrames:h,
stallsDetected:k,gapsJumped:l,estimatedBandwidth:m,completionPercent:n,loadLatency:q,manifestTimeSeconds:r,drmTimeSeconds:t,playTime:v,pauseTime:w,bufferingTime:z,licenseTime:y,liveLatency:A,maxSegmentDuration:E,manifestSizeBytes:I,bytesDownloaded:D,nonFatalErrorCount:C,manifestPeriodCount:B,manifestGapCount:J,stateHistory:F,switchHistory:L}};function oo(a,b,c,d){Rg.call(this);this.N=a;this.V=b;this.Da=d.networkingEngine;this.o=c;this.C=null;this.za=0;this.Ta=d.md;this.G=d.yk;this.Ua=d.zk;this.g=d.config;this.m=this.H=this.h=null;this.oa=!1;this.I=d.Kk;this.va=!1;this.j=null;this.ba=!1;this.u=null;this.M=new Map;this.ya=!1;this.Fa=d.Jk;this.X=new io;this.ma=new Hg;this.B=new Hg;this.O=null;this.l=!1;this.$=d.pj;this.T=this.i=null;this.R=!1;this.K=[];this.J=[];this.F=!0}ma(oo,Rg);function po(a,b,c){(a=b?a.J:a.K)?a.push(c):c()}
function qo(a){if(a.J)for(var b=u(a.J),c=b.next();!c.done;c=b.next())c=c.value,c();a.J=null}function ro(a,b){a.O=b;a.R=!0;if(a.K){b=u(a.K);for(var c=b.next();!c.done;c=b.next())c=c.value,c()}a.K=null}p=oo.prototype;p.getStartTime=function(){return this.o};p.rd=function(){return this.N};p.Lg=function(){return this.h};function so(a){a.va=!0;return a.I}p.getStats=function(){return this.X};function to(a){a.ba=!0;return a.j}p.Vj=function(){return this.i?jg(this.i):null};
p.Uj=function(){return this.T?kg(this.T):null};function uo(a){a.ya=!0;return a.M}
p.start=function(){var a=this;(function(){var b;return O(function(c){switch(c.g){case 1:return G(c,Promise.resolve(),2);case 2:return sa(c,3),G(c,vo(a),5);case 5:wo(a);if("webkit"===window.shakaMediaKeysPolyfill){c.A(6);break}return G(c,xo(a),7);case 7:wo(a);case 6:return G(c,yo(a),8);case 8:wo(a);if(!a.$){c.A(9);break}return G(c,zo(a),10);case 10:wo(a);case 9:if(!a.$||!a.j){c.A(11);break}return G(c,pi(a.j),12);case 12:wo(a);case 11:a.B.resolve();ua(c,0);break;case 3:b=Aa(c),b instanceof U&&(b.code==
7001||b.code==7003)||a.B.reject(b),H(c)}})})()};p.dispatchEvent=function(a){return this.O?this.O.dispatchEvent(a):Rg.prototype.dispatchEvent.call(this,a)};p.onError=function(a){a.severity===2&&(this.B.reject(a),this.destroy());var b=(new Map).set("detail",a);b=new V("error",b);this.dispatchEvent(b);b.defaultPrevented&&(a.handled=!0)};function wo(a){if(a.l)throw new U(2,7,7003);}function Ao(a,b){a.dispatchEvent(new V("onstatechange",(new Map).set("state",b)))}
function vo(a){var b,c,d,e,f,g;return O(function(h){switch(h.g){case 1:Ao(a,"manifest-parser");a.m||(a.H=Yc(a.N,a.V),a.m=a.H(),a.m.configure(a.g.manifest,function(){return a.F}));b=Date.now()/1E3;Ao(a,"manifest");if(a.h){h.A(2);break}return G(h,a.m.start(a.N,a.Ua),3);case 3:return a.h=h.h,Bo(a.h),G(h,Mo(a),2);case 2:return a.ma.resolve(),c=new V("manifestparsed",void 0),G(h,Promise.resolve(),5);case 5:a.dispatchEvent(c);if(a.h.variants.length==0)throw new U(2,4,4036);Bo(a.h);d=Bi(a.G,a.h);if(!d){h.A(6);
break}e=new V("trackschanged",void 0);return G(h,Promise.resolve(),7);case 7:wo(a),a.dispatchEvent(e);case 6:f=Date.now()/1E3,g=f-b,a.X.J=g,H(h)}})}
function xo(a,b){var c,d,e,f;return O(function(g){switch(g.g){case 1:if(!a.h||a.j)return g.return();Ao(a,"drm-engine");a.za=Date.now()/1E3;a.j=a.Ta();a.G.g=a.j;a.j.configure(a.g.drm,function(){return a.F});c=sg(a.h.variants);d=!0;a.h&&a.h.presentationTimeline&&(d=a.h.presentationTimeline.W());return G(g,Ph(a.j,c,a.h.offlineSessionIds,d),2);case 2:wo(a);if(!b){g.A(3);break}return G(g,a.j.Vb(b),4);case 4:wo(a);case 3:return G(g,zi(a.G,a.h),5);case 5:e=g.h;if(!e){g.A(0);break}f=new V("trackschanged",
void 0);return G(g,Promise.resolve(),7);case 7:a.dispatchEvent(f),H(g)}})}p.configure=function(a,b){a=Bn(a,b);bo(this.g,a)};p.getConfiguration=function(){return wd(this.g)};
function Mo(a){return O(function(b){a.C||(a.C=a.g.adaptationSetCriteriaFactory(),a.C.configure({language:a.g.preferredAudioLanguage,role:a.g.preferredAudioRole,videoRole:a.g.preferredVideoRole,channelCount:0,hdrLevel:a.g.preferredVideoHdrLevel,spatialAudio:a.g.preferSpatialAudio,videoLayout:a.g.preferredVideoLayout,audioLabel:a.g.preferredAudioLabel,videoLabel:a.g.preferredVideoLabel,codecSwitchingStrategy:a.g.mediaSource.codecSwitchingStrategy,audioCodec:"",activeAudioCodec:"",activeAudioChannelCount:0,
preferredAudioCodecs:a.g.preferredAudioCodecs,preferredAudioChannelCount:a.g.preferredAudioChannelCount}));if(a.i||!a.h.variants.length||a.h.variants.length!=1&&a.h.type!="HLS")return b.A(0);a.i=No(a);return a.i?G(b,Oo(a.i),0):b.A(0)})}function yo(a){return O(function(b){if(b.g==1)return!a.i||a.h.variants.includes(a.i)?b.A(0):G(b,Po(a.i),3);a.i=No(a);return a.i?G(b,Oo(a.i),0):b.A(0)})}
function zo(a){var b,c,d,e,f;return O(function(g){!a.i&&(b=No(a))&&(a.i=b);if(!a.i)return g.A(0);c=a.h.presentationTimeline.W();d=[];e=a.i;e.video&&d.push(Qo(a,e.video,c));e.audio&&d.push(Qo(a,e.audio,c));(f=tg(a.h.textStreams,a.g.preferredTextLanguage,a.g.preferredTextRole,a.g.preferForcedSubs)[0]||null)&&xg(e.audio,f,a.g)&&(d.push(Qo(a,f,c)),a.T=f);return G(g,Promise.all(d),0)})}
function No(a){if(!a.u){var b=a.g.abrFactory;a.u=b();a.u.configure(a.g.abr)}b=sg(a.h.variants);b=a.C.create(b);a.u.setVariants(Array.from(b.values()));return a.u.chooseVariant(!0)}
function Qo(a,b,c){var d,e,f,g,h;return O(function(k){if(k.g==1)return d=a.g.streaming.segmentPrefetchLimit||2,e=new mm(d,b,function(l,m,n){return gn(l,m,n||null,a.g.streaming.retryParameters,a.Da,a.F)},!1),a.M.set(b.id,e),b.segmentIndex?k.A(2):G(k,b.createSegmentIndex(),2);f=typeof a.o==="number"?a.o:0;g=b.segmentIndex.Xb(f);h=null;g&&(h=g.current(),h||(h=g.next().value));h||(h=mg(b.segmentIndex));return h?c?h.ea?G(k,pm(e,h.ea),0):k.A(0):G(k,om(e,h.startTime),0):k.A(0)})}
function Oo(a){var b,c,d,e;return O(function(f){b=[];c=u([a.video,a.audio]);for(d=c.next();!d.done;d=c.next())(e=d.value)&&!e.segmentIndex&&b.push(e.createSegmentIndex());return b.length>0?G(f,Promise.all(b),0):f.A(0)})}function Po(a){var b,c,d,e;return O(function(f){b=[];c=u([a.video,a.audio]);for(d=c.next();!d.done;d=c.next())(e=d.value)&&e.segmentIndex&&e.closeSegmentIndex&&b.push(e.closeSegmentIndex());return b.length>0?G(f,Promise.all(b),0):f.A(0)})}p.rl=function(){return this.B};
p.destroy=function(){var a=this,b,c,d;return O(function(e){if(e.g==1)return a.l=!0,!a.m||a.oa?e.A(2):G(e,a.m.stop(),2);if(e.g!=4)return a.u&&a.u.release(),a.I&&!a.va&&a.I.release(),!a.j||a.ba?e.A(4):G(e,a.j.destroy(),4);if(a.M.size>0&&!a.ya)for(b=u(a.M.values()),c=b.next();!c.done;c=b.next())d=c.value,vm(d);H(e)})};function Bo(a){function b(c){return c.video&&c.audio||c.video&&c.video.codecs.includes(",")}a.variants.some(b)&&(a.variants=a.variants.filter(b))}T("shaka.media.PreloadManager",oo);
oo.prototype.destroy=oo.prototype.destroy;oo.prototype.waitForFinish=oo.prototype.rl;oo.prototype.getPrefetchedTextTrack=oo.prototype.Uj;oo.prototype.getPrefetchedVariantTrack=oo.prototype.Vj;function Ro(a,b){Rg.call(this);var c=this;this.i=a;this.l=b;this.g=new Map;this.m=[{kd:null,jd:So,Uc:function(d,e){return To(c,"enter",d,e)}},{kd:Uo,jd:So,Uc:function(d,e){return To(c,"enter",d,e)}},{kd:Vo,jd:So,Uc:function(d,e){return To(c,"enter",d,e)}},{kd:So,jd:Uo,Uc:function(d,e){return To(c,"exit",d,e)}},{kd:So,jd:Vo,Uc:function(d,e){return To(c,"exit",d,e)}},{kd:Uo,jd:Vo,Uc:function(d,e){e?To(c,"skip",d,e):(To(c,"enter",d,e),To(c,"exit",d,e))}},{kd:Vo,jd:Uo,Uc:function(d,e){return To(c,"skip",
d,e)}}];this.h=new kb;this.h.D(this.i,"regionremove",function(d){c.g.delete(d.region)})}ma(Ro,Rg);Ro.prototype.release=function(){this.i=null;this.g.clear();this.h.release();this.h=null;Rg.prototype.release.call(this)};
Ro.prototype.j=function(a,b){if(!this.l||a!=0){this.l=!1;for(var c=u(this.i.h.values()),d=c.next();!d.done;d=c.next()){d=d.value;var e=this.g.get(d),f=a<d.startTime?Uo:a>d.endTime?Vo:So;this.g.set(d,f);for(var g=u(this.m),h=g.next();!h.done;h=g.next())h=h.value,h.kd==e&&h.jd==f&&h.Uc(d,b)}}};function To(a,b,c,d){b=new V(b,new Map([["region",c],["seeking",d]]));a.dispatchEvent(b)}var Uo=1,So=2,Vo=3;/*
 @license
 Copyright 2013 Ali Al Dallal

 Licensed under the MIT license.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
*/
for(var Wo={ach:"Lwo",ady:"\u0410\u0434\u044b\u0433\u044d\u0431\u0437\u044d",af:"Afrikaans","af-NA":"Afrikaans (Namibia)","af-ZA":"Afrikaans (South Africa)",ak:"T\u0255\u0265i",ar:"\u0627\u0644\u0639\u0631\u0628\u064a\u0629","ar-AR":"\u0627\u0644\u0639\u0631\u0628\u064a\u0629","ar-MA":"\u0627\u0644\u0639\u0631\u0628\u064a\u0629","ar-SA":"\u0627\u0644\u0639\u0631\u0628\u064a\u0629 (\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629)","ay-BO":"Aymar aru",az:"Az\u0259rbaycan dili","az-AZ":"Az\u0259rbaycan dili",
"be-BY":"\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f",bg:"\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438","bg-BG":"\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438",bn:"\u09ac\u09be\u0982\u09b2\u09be","bn-IN":"\u09ac\u09be\u0982\u09b2\u09be (\u09ad\u09be\u09b0\u09a4)","bn-BD":"\u09ac\u09be\u0982\u09b2\u09be(\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6)","bs-BA":"Bosanski",ca:"Catal\u00e0","ca-ES":"Catal\u00e0",cak:"Maya Kaqchikel","ck-US":"\u13e3\u13b3\u13a9 (tsalagi)",
cs:"\u010ce\u0161tina","cs-CZ":"\u010ce\u0161tina",cy:"Cymraeg","cy-GB":"Cymraeg",da:"Dansk","da-DK":"Dansk",de:"Deutsch","de-AT":"Deutsch (\u00d6sterreich)","de-DE":"Deutsch (Deutschland)","de-CH":"Deutsch (Schweiz)",dsb:"Dolnoserb\u0161\u0107ina",el:"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac","el-GR":"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac",en:"English","en-GB":"English (UK)","en-AU":"English (Australia)","en-CA":"English (Canada)","en-IE":"English (Ireland)","en-IN":"English (India)",
"en-PI":"English (Pirate)","en-UD":"English (Upside Down)","en-US":"English (US)","en-ZA":"English (South Africa)","en@pirate":"English (Pirate)",eo:"Esperanto","eo-EO":"Esperanto",es:"Espa\u00f1ol","es-AR":"Espa\u00f1ol (Argentine)","es-419":"Espa\u00f1ol (Latinoam\u00e9rica)","es-CL":"Espa\u00f1ol (Chile)","es-CO":"Espa\u00f1ol (Colombia)","es-EC":"Espa\u00f1ol (Ecuador)","es-ES":"Espa\u00f1ol (Espa\u00f1a)","es-LA":"Espa\u00f1ol (Latinoam\u00e9rica)","es-NI":"Espa\u00f1ol (Nicaragua)","es-MX":"Espa\u00f1ol (M\u00e9xico)",
"es-US":"Espa\u00f1ol (Estados Unidos)","es-VE":"Espa\u00f1ol (Venezuela)",et:"eesti keel","et-EE":"Eesti (Estonia)",eu:"Euskara","eu-ES":"Euskara",fa:"\u0641\u0627\u0631\u0633\u06cc","fa-IR":"\u0641\u0627\u0631\u0633\u06cc","fb-LT":"Leet Speak",ff:"Fulah",fi:"Suomi","fi-FI":"Suomi","fo-FO":"F\u00f8royskt",fr:"Fran\u00e7ais","fr-CA":"Fran\u00e7ais (Canada)","fr-FR":"Fran\u00e7ais (France)","fr-BE":"Fran\u00e7ais (Belgique)","fr-CH":"Fran\u00e7ais (Suisse)","fy-NL":"Frysk",ga:"Gaeilge","ga-IE":"Gaeilge (Gaelic)",
gl:"Galego","gl-ES":"Galego","gn-PY":"Ava\u00f1e'\u1ebd","gu-IN":"\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0","gx-GR":"\u1f19\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae \u1f00\u03c1\u03c7\u03b1\u03af\u03b1",he:"\u05e2\u05d1\u05e8\u05d9\u05ea\u200f","he-IL":"\u05e2\u05d1\u05e8\u05d9\u05ea\u200f",hi:"\u0939\u093f\u0928\u094d\u0926\u0940","hi-IN":"\u0939\u093f\u0928\u094d\u0926\u0940",hr:"Hrvatski","hr-HR":"Hrvatski",hsb:"Hornjoserb\u0161\u0107ina",ht:"Krey\u00f2l",hu:"Magyar","hu-HU":"Magyar","hy-AM":"\u0540\u0561\u0575\u0565\u0580\u0565\u0576",
id:"Bahasa Indonesia","id-ID":"Bahasa Indonesia",is:"\u00cdslenska","is-IS":"\u00cdslenska (Iceland)",it:"Italiano","it-IT":"Italiano",ja:"\u65e5\u672c\u8a9e","ja-JP":"\u65e5\u672c\u8a9e","jv-ID":"Basa Jawa","ka-GE":"\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8","kk-KZ":"\u049a\u0430\u0437\u0430\u049b\u0448\u0430",km:"\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a","km-KH":"\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a",kab:"Taqbaylit",kn:"\u0c95\u0ca8\u0ccd\u0ca8\u0ca1","kn-IN":"\u0c95\u0ca8\u0ccd\u0ca8\u0ca1 (India)",
ko:"\ud55c\uad6d\uc5b4","ko-KR":"\ud55c\uad6d\uc5b4 (\u97e9\u56fd)",ku:"Kurd\u00ee","ku-TR":"Kurd\u00ee",la:"Latin","la-VA":"Latin",lb:"L\u00ebtzebuergesch","li-NL":"L\u00e8mb\u00f6rgs",lt:"Lietuvi\u0173","lt-LT":"Lietuvi\u0173",lv:"Latvie\u0161u","lv-LV":"Latvie\u0161u",mai:"\u092e\u0948\u0925\u093f\u0932\u0940, \u09ae\u09c8\u09a5\u09bf\u09b2\u09c0","mg-MG":"Malagasy",mk:"\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438","mk-MK":"\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 (\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438)",
ml:"\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02","ml-IN":"\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02","mn-MN":"\u041c\u043e\u043d\u0433\u043e\u043b",mr:"\u092e\u0930\u093e\u0920\u0940","mr-IN":"\u092e\u0930\u093e\u0920\u0940",ms:"Bahasa Melayu","ms-MY":"Bahasa Melayu",mt:"Malti","mt-MT":"Malti",my:"\u1017\u1019\u102c\u1005\u1000\u102c",nb:"Norsk (bokm\u00e5l)","nb-NO":"Norsk (bokm\u00e5l)",ne:"\u0928\u0947\u092a\u093e\u0932\u0940","ne-NP":"\u0928\u0947\u092a\u093e\u0932\u0940",nl:"Nederlands","nl-BE":"Nederlands (Belgi\u00eb)",
"nl-NL":"Nederlands (Nederland)","nn-NO":"Norsk (nynorsk)",no:"Norsk",oc:"Occitan","or-IN":"\u0b13\u0b21\u0b3c\u0b3f\u0b06",pa:"\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40","pa-IN":"\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40 (\u0a2d\u0a3e\u0a30\u0a24 \u0a28\u0a42\u0a70)",pl:"Polski","pl-PL":"Polski","ps-AF":"\u067e\u069a\u062a\u0648",pt:"Portugu\u00eas","pt-BR":"Portugu\u00eas (Brasil)","pt-PT":"Portugu\u00eas (Portugal)","qu-PE":"Qhichwa","rm-CH":"Rumantsch",ro:"Rom\u00e2n\u0103","ro-RO":"Rom\u00e2n\u0103",ru:"\u0420\u0443\u0441\u0441\u043a\u0438\u0439",
"ru-RU":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439","sa-IN":"\u0938\u0902\u0938\u094d\u0915\u0943\u0924\u092e\u094d","se-NO":"Davvis\u00e1megiella","si-LK":"\u0db4\u0dc5\u0dcf\u0dad",sk:"Sloven\u010dina","sk-SK":"Sloven\u010dina (Slovakia)",sl:"Sloven\u0161\u010dina","sl-SI":"Sloven\u0161\u010dina","so-SO":"Soomaaliga",sq:"Shqip","sq-AL":"Shqip",sr:"\u0421\u0440\u043f\u0441\u043a\u0438","sr-RS":"\u0421\u0440\u043f\u0441\u043a\u0438 (Serbia)",su:"Basa Sunda",sv:"Svenska","sv-SE":"Svenska",sw:"Kiswahili",
"sw-KE":"Kiswahili",ta:"\u0ba4\u0bae\u0bbf\u0bb4\u0bcd","ta-IN":"\u0ba4\u0bae\u0bbf\u0bb4\u0bcd",te:"\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41","te-IN":"\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41",tg:"\u0437\u0430\u0431\u043e\u0301\u043d\u0438 \u0442\u043e\u04b7\u0438\u043a\u04e3\u0301","tg-TJ":"\u0442\u043e\u04b7\u0438\u043a\u04e3",th:"\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22","th-TH":"\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22 (\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17\u0e22)",tl:"Filipino","tl-PH":"Filipino",
tlh:"tlhIngan-Hol",tr:"T\u00fcrk\u00e7e","tr-TR":"T\u00fcrk\u00e7e","tt-RU":"\u0442\u0430\u0442\u0430\u0440\u0447\u0430",uk:"\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430","uk-UA":"\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430",ur:"\u0627\u0631\u062f\u0648","ur-PK":"\u0627\u0631\u062f\u0648",uz:"O'zbek","uz-UZ":"O'zbek",vi:"Ti\u1ebfng Vi\u1ec7t","vi-VN":"Ti\u1ebfng Vi\u1ec7t","xh-ZA":"isiXhosa",yi:"\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9","yi-DE":"\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9 (German)",
zh:"\u4e2d\u6587","zh-HANS":"\u4e2d\u6587\u7b80\u4f53","zh-HANT":"\u4e2d\u6587\u7e41\u9ad4","zh-CN":"\u4e2d\u6587\uff08\u4e2d\u56fd\uff09","zh-HK":"\u4e2d\u6587\uff08\u9999\u6e2f\uff09","zh-SG":"\u4e2d\u6587\uff08\u65b0\u52a0\u5761\uff09","zh-TW":"\u4e2d\u6587\uff08\u53f0\u7063\uff09","zu-ZA":"isiZulu"},Xo=u(Object.keys(Wo)),Yo=Xo.next();!Yo.done;Yo=Xo.next()){var Zo=Yo.value;Wo[Zo.toLowerCase()]=Wo[Zo]};function $o(a,b){if(a.lineBreak)return"\n";if(a.nestedCues.length)return a.nestedCues.map(function(g){return $o(g,a)}).join("");if(!a.payload)return a.payload;var c=[],d=a.fontWeight>=Ce,e=a.fontStyle==De,f=a.textDecoration.includes(Ee);d&&c.push(["b"]);e&&c.push(["i"]);f&&c.push(["u"]);e=a.color;e==""&&b&&(e=b.color);d="";(e=ap(e))&&(d+="."+e);e=a.backgroundColor;e==""&&b&&(e=b.backgroundColor);(b=ap(e))&&(d+=".bg_"+b);d&&c.push(["c",d]);return c.reduceRight(function(g,h){var k=u(h);h=k.next().value;
k=k.next().value;return"<"+h+(k===void 0?"":k)+">"+g+"</"+h+">"},a.payload)}
function ap(a){a=a.toLowerCase();var b=a.replace(/\s/g,"").match(/^rgba?\((\d+),(\d+),(\d+),?([^,\s)]+)?/i);b?a="#"+(parseInt(b[1],10)|256).toString(16).slice(1)+(parseInt(b[2],10)|256).toString(16).slice(1)+(parseInt(b[3],10)|256).toString(16).slice(1):a.startsWith("#")&&a.length>7&&(a=a.slice(0,7));switch(a){case "white":case "#fff":case "#ffffff":return"white";case "lime":case "#0f0":case "#00ff00":return"lime";case "cyan":case "#0ff":case "#00ffff":return"cyan";case "red":case "#f00":case "#ff0000":return"red";
case "yellow":case "#ff0":case "#ffff00":return"yellow";case "magenta":case "#f0f":case "#ff00ff":return"magenta";case "blue":case "#00f":case "#0000ff":return"blue";case "black":case "#000":case "#000000":return"black"}return null}function bp(a,b){var c=[];a=u(cp(a));for(var d=a.next();!d.done;d=a.next())if(d=d.value,d.isContainer)c.push.apply(c,x(bp(d.nestedCues,d)));else{var e=d.clone();e.nestedCues=[];e.payload=$o(d,b);c.push(e)}return c}
function cp(a){var b=[];a=u(a);for(var c=a.next(),d={};!c.done;d={mg:void 0},c=a.next())d.mg=c.value,b.some(function(e){return function(f){return re(e.mg,f)}}(d))||b.push(d.mg);return b}
function dp(a){function b(d){for(var e=5381,f=d.length;f;)e=e*33^d.charCodeAt(--f);return(e>>>0).toString()}if(a.startTime>=a.endTime)return null;var c=new VTTCue(a.startTime,a.endTime,a.payload);c.id=b(a.startTime.toString())+b(a.endTime.toString())+b(a.payload);c.lineAlign=a.lineAlign;c.positionAlign=a.positionAlign;a.size&&(c.size=a.size);try{c.align=a.textAlign}catch(d){}a.textAlign=="center"&&c.align!="center"&&(c.align="middle");a.writingMode=="vertical-lr"?c.vertical="lr":a.writingMode=="vertical-rl"&&
(c.vertical="rl");a.lineInterpretation==1&&(c.snapToLines=!1);a.line!=null&&(c.line=a.line);a.position!=null&&(c.position=a.position);return c}
function ep(a,b){var c=bp(b),d=[];b=a.cues?Array.from(a.cues):[];c=u(c);for(var e=c.next(),f={};!e.done;f={vd:void 0},e=c.next())f.vd=e.value,!b.some(function(g){return function(h){return h.startTime==g.vd.startTime&&h.endTime==g.vd.endTime&&h.text==g.vd.payload?!0:!1}}(f))&&f.vd.payload&&(e=dp(f.vd))&&d.push(e);b=d.slice().sort(function(g,h){return g.startTime!=h.startTime?g.startTime-h.startTime:g.endTime!=h.endTime?g.endTime-h.startTime:"line"in VTTCue.prototype?d.indexOf(h)-d.indexOf(g):d.indexOf(g)-
d.indexOf(h)});b=u(b);for(c=b.next();!c.done;c=b.next())a.addCue(c.value)}function fp(a,b){var c=!1;a.mode==="disabled"&&(c=!0,a.mode="hidden");for(var d=0;d<a.cues.length;){var e=a.cues[d];b(e)?a.removeCue(e):d++}c&&(a.mode="disabled")};function gp(a){var b=this;this.i=a;this.l=new kb;this.j=null;this.h=new Map;this.g=-1;this.u=!1;this.o=null;this.C=function(){b.l.Ma(b.i,"textchanged",b.m);b.l.Ma(b.j.textTracks,"change",b.B);for(var c=u(b.h.values()),d=c.next();!d.done;d=c.next())d.value.remove();b.h.clear();b.g=-1;b.j=null};this.m=function(){var c=new Map,d=b.i.Lc();d=u(d);for(var e=d.next();!e.done;e=d.next()){e=e.value;if(b.h.has(e.id)){var f=b.h.get(e.id);e.active||f.track.mode==="disabled"||(f.track.mode="disabled");b.h.delete(e.id)}else{f=
b.j.ownerDocument.createElement("track");f.kind=hp(e);var g=f,h=void 0;if(e.label)h=e.label;else if(e.language)if(e.language in Wo)h=Wo[e.language];else{var k=Df(e.language);k in Wo&&(h=Wo[k]+" ("+e.language+")")}h||(h=e.originalTextId,e.language&&e.language!==e.originalTextId&&(h+=" ("+e.language+")"));g.label=h;e.language in Wo&&(f.srclang=e.language);f.src="data:,WEBVTT";f.track.mode="disabled";b.j.appendChild(f)}c.set(e.id,f);e.active&&(b.g=e.id)}d=u(b.h.values());for(e=d.next();!e.done;e=d.next())e.value.remove();
b.g>-1&&(c.has(b.g)?(d=c.get(b.g).track,d.mode==="disabled"&&(d.mode=b.u?"showing":"hidden")):b.g=-1);b.h=c};this.B=function(){if(!b.o){var c=b.j;b.o=(new rf(function(){b.o=null;if(b.j===c){var d=-1,e=!1;if(b.h.has(b.g)){var f=b.h.get(b.g);f.track.mode==="showing"?(d=b.g,e=!0):f.track.mode==="hidden"&&(d=b.g)}if(!e)for(e=u(b.h),f=e.next();!f.done;f=e.next()){var g=u(f.value);f=g.next().value;g=g.next().value;if(g.track.mode==="showing"){d=f;break}else d<0&&g.track.mode==="hidden"&&(d=f)}e=u(b.h);
for(f=e.next();!f.done;f=e.next())g=u(f.value),f=g.next().value,g=g.next().value,f!==d&&g.track.mode!=="disabled"&&(g.track.mode="disabled");b.g!==d&&(b.g=d,d>-1&&b.i.ph({id:d}));b.i.wh(d>-1&&b.h.get(d).track.mode==="showing")}})).ka(0)}};this.l.D(a,"loaded",function(){return b.enableTextDisplayer()});this.enableTextDisplayer()}p=gp.prototype;p.configure=function(){};
p.remove=function(a,b){if(this.i)this.h.has(this.g)&&fp(this.h.get(this.g).track,function(c){return c.startTime<b&&c.endTime>a});else return!1;return!0};p.append=function(a){this.h.has(this.g)&&ep(this.h.get(this.g).track,a)};p.destroy=function(){this.i&&(this.j&&this.C(),this.i=null);this.l&&(this.l.release(),this.l=null);return Promise.resolve()};p.isTextVisible=function(){return this.u};
p.setTextVisibility=function(a){this.u=a;if(this.h.has(this.g)){var b=this.h.get(this.g).track;b.mode!=="disabled"&&(a=a?"showing":"hidden",b.mode!==a&&(b.mode=a))}else if(this.i&&this.i.$d()===3)if(b=Array.from(this.i.bf().textTracks).filter(function(d){return["captions","subtitles","forced"].includes(d.kind)}),a){a=null;b=u(b);for(var c=b.next();!c.done;c=b.next())if(c=c.value,c.mode==="showing"){a=null;break}else a||c.mode!=="hidden"||(a=c);a&&(a.mode="showing")}else for(a=u(b),b=a.next();!b.done;b=
a.next())b=b.value,b.mode==="showing"&&(b.mode="hidden")};p.setTextLanguage=function(){};p.enableTextDisplayer=function(){!this.j&&this.i&&this.i.$d()===2&&(this.j=this.i.bf(),this.l.Aa(this.i,"unloading",this.C),this.l.D(this.i,"textchanged",this.m),this.l.D(this.j.textTracks,"change",this.B),this.m())};
function hp(a){var b=rb();return a.forced&&b.Ha()==="WEBKIT"?"forced":a.kind==="caption"||a.roles&&a.roles.some(function(c){return c.includes("transcribes-spoken-dialog")})&&a.roles.some(function(c){return c.includes("describes-music-and-sound")})?"captions":"subtitles"}T("shaka.text.NativeTextDisplayer",gp);gp.prototype.enableTextDisplayer=gp.prototype.enableTextDisplayer;gp.prototype.setTextLanguage=gp.prototype.setTextLanguage;gp.prototype.setTextVisibility=gp.prototype.setTextVisibility;
gp.prototype.isTextVisible=gp.prototype.isTextVisible;gp.prototype.destroy=gp.prototype.destroy;gp.prototype.append=gp.prototype.append;gp.prototype.remove=gp.prototype.remove;gp.prototype.configure=gp.prototype.configure;function ip(a,b){yb("SimpleTextDisplayer","Please migrate to NativeTextDisplayer");this.h=a;this.i=b;this.g=null;a=u(Array.from(this.h.textTracks));for(b=a.next();!b.done;b=a.next())b=b.value,b.kind!=="metadata"&&b.kind!=="chapters"&&(b.mode="disabled",b.label==this.i&&(this.g=b));this.g&&(this.g.mode="hidden")}p=ip.prototype;p.configure=function(){};p.remove=function(a,b){if(!this.g)return!1;fp(this.g,function(c){return c.startTime<b&&c.endTime>a});return!0};
p.append=function(a){this.g&&ep(this.g,a)};p.destroy=function(){this.g&&(fp(this.g,function(){return!0}),this.g.mode="disabled");this.g=this.h=null;return Promise.resolve()};p.isTextVisible=function(){return this.g?this.g.mode=="showing":!1};p.setTextVisibility=function(a){a&&!this.g&&jp(this);this.g&&(this.g.mode=a?"showing":"hidden")};p.setTextLanguage=function(){};p.enableTextDisplayer=function(){jp(this)};function jp(a){a.h&&!a.g&&(a.g=a.h.addTextTrack("subtitles",a.i),a.g.mode="hidden")}
T("shaka.text.SimpleTextDisplayer",ip);ip.prototype.enableTextDisplayer=ip.prototype.enableTextDisplayer;ip.prototype.setTextLanguage=ip.prototype.setTextLanguage;ip.prototype.setTextVisibility=ip.prototype.setTextVisibility;ip.prototype.isTextVisible=ip.prototype.isTextVisible;ip.prototype.destroy=ip.prototype.destroy;ip.prototype.append=ip.prototype.append;ip.prototype.remove=ip.prototype.remove;ip.prototype.configure=ip.prototype.configure;function kp(){}p=kp.prototype;p.configure=function(){};p.remove=function(){};p.append=function(){};p.destroy=function(){};p.isTextVisible=function(){return!1};p.setTextVisibility=function(){};p.setTextLanguage=function(){};p.enableTextDisplayer=function(){};T("shaka.text.StubTextDisplayer",kp);kp.prototype.enableTextDisplayer=kp.prototype.enableTextDisplayer;kp.prototype.setTextLanguage=kp.prototype.setTextLanguage;kp.prototype.setTextVisibility=kp.prototype.setTextVisibility;
kp.prototype.isTextVisible=kp.prototype.isTextVisible;kp.prototype.destroy=kp.prototype.destroy;kp.prototype.append=kp.prototype.append;kp.prototype.remove=kp.prototype.remove;kp.prototype.configure=kp.prototype.configure;function lp(a,b){var c=this;this.m=!1;this.h=[];this.j=a;this.o=b;this.C=this.u=null;this.g=document.createElement("div");this.g.classList.add("shaka-text-container");this.g.style.textAlign="center";this.g.style.display="flex";this.g.style.flexDirection="column";this.g.style.alignItems="center";this.g.style.justifyContent="flex-end";this.B=new rf(function(){c.j.paused||mp(c)});np(this);this.l=new Map;this.i=new kb;this.i.D(document,"fullscreenchange",function(){mp(c,!0)});this.i.D(this.j,"seeking",
function(){mp(c,!0)});this.i.D(this.j,"ratechange",function(){np(c)});this.i.D(this.j,"resize",function(){var d=c.j,e=d.videoWidth;d=d.videoHeight;e&&d?c.u=e/d:c.u=null});this.F=null;"ResizeObserver"in window&&(this.F=new ResizeObserver(function(){mp(c,!0)}),this.F.observe(this.g));this.G=new Map}p=lp.prototype;p.configure=function(a){this.C=a;np(this);mp(this,!0)};
p.append=function(a){var b=[].concat(x(this.h));a=u(cp(a));for(var c=a.next(),d={};!c.done;d={ng:void 0},c=a.next())d.ng=c.value,b.some(function(e){return function(f){return re(f,e.ng)}}(d))||this.h.push(d.ng);this.h.length&&np(this);mp(this)};
p.destroy=function(){if(!this.g)return Promise.resolve();this.g.parentElement&&this.o.removeChild(this.g);this.g=null;this.m=!1;this.h=[];this.B&&(this.B.stop(),this.B=null);this.l.clear();this.i&&(this.i.release(),this.i=null);this.F&&(this.F.disconnect(),this.F=null);return Promise.resolve()};p.remove=function(a,b){if(!this.g)return!1;var c=this.h.length;this.h=this.h.filter(function(d){return d.startTime<a||d.endTime>=b});mp(this,c>this.h.length);this.h.length||np(this);return!0};
p.isTextVisible=function(){return this.m};p.setTextVisibility=function(a){(this.m=a)?(this.g.parentElement||this.o.appendChild(this.g),mp(this,!0)):this.g.parentElement&&this.o.removeChild(this.g)};p.setTextLanguage=function(a){a&&a!="und"?this.g.setAttribute("lang",a):this.g.setAttribute("lang","")};p.enableTextDisplayer=function(){};function np(a){a.B&&(a.h.length?a.B.Ea((a.C?a.C.captionsUpdatePeriod:.25)/Math.max(1,Math.abs(a.j.playbackRate))):a.B.stop())}
function op(a,b){for(;b!=null;){if(b==a.g)return!0;b=b.parentElement}return!1}
function pp(a,b,c,d,e){var f=!1,g=[],h=[];b=u(b);for(var k=b.next();!k.done;k=b.next()){k=k.value;e.push(k);var l=a.l.get(k),m=k.startTime<=d&&k.endTime>d,n=l?l.nj:null;l&&(g.push(l.og),l.$c&&g.push(l.$c),m||(f=!0,a.l.delete(k),l=null));m&&(h.push(k),l?op(a,n)||(f=!0):(qp(a,k,e),l=a.l.get(k),n=l.nj,f=!0));k.nestedCues.length>0&&n&&pp(a,k.nestedCues,n,d,e);e.pop()}if(f){d=u(g);for(e=d.next();!e.done;e=d.next())e=e.value,e.parentElement&&e.parentElement.removeChild(e);h.sort(function(q,r){return q.startTime!=
r.startTime?q.startTime-r.startTime:q.endTime-r.endTime});h=u(h);for(d=h.next();!d.done;d=h.next())d=a.l.get(d.value),d.$c?(d.$c.contains(c)&&d.$c.removeChild(c),c.appendChild(d.$c),d.$c.appendChild(d.og)):c.appendChild(d.og)}}function mp(a,b){if(a.g){var c=a.j.currentTime;if(!a.m||(b===void 0?0:b)){b=u(a.G.values());for(var d=b.next();!d.done;d=b.next())Nj(d.value);Nj(a.g);a.l.clear();a.G.clear()}a.m&&pp(a,a.h,a.g,c,[])}}
function qp(a,b,c){var d=c.length>1,e=d?"span":"div";b.lineBreak&&(e="br");b.rubyTag&&(e=b.rubyTag);d=!d&&b.nestedCues.length>0;var f=document.createElement(e);e!="br"&&rp(a,f,b,c,d);c=null;if(b.region&&b.region.id){var g=b.region,h=a.u===4/3?2.5:1.9;c=g.id+"_"+g.width+"x"+g.height+(g.heightUnits==id?"%":"px")+"-"+g.viewportAnchorX+"x"+g.viewportAnchorY+(g.viewportAnchorUnits==id?"%":"px");if(a.G.has(c))c=a.G.get(c);else{e=document.createElement("span");var k=g.heightUnits==id?"%":"px",l=g.widthUnits==
id?"%":"px",m=g.viewportAnchorUnits==id?"%":"px";e.id="shaka-text-region---"+c;e.classList.add("shaka-text-region");e.style.position="absolute";var n=g.height,q=g.width;g.heightUnits===2&&(n=g.height*5.33,k="%");g.widthUnits===2&&(q=g.width*h,l="%");e.style.height=n+k;e.style.width=q+l;g.viewportAnchorUnits===2?(h=g.viewportAnchorY/75*100,k=g.viewportAnchorX/(a.u===4/3?160:210)*100,h-=g.regionAnchorY*n/100,k-=g.regionAnchorX*q/100,e.style.top=h+"%",e.style.left=k+"%"):(e.style.top=g.viewportAnchorY-
g.regionAnchorY*n/100+m,e.style.left=g.viewportAnchorX-g.regionAnchorX*q/100+m);g.heightUnits!==0&&g.widthUnits!==0&&g.viewportAnchorUnits!==0&&(g=Math.max(0,Math.min(100-(parseInt(e.style.width.slice(0,-1),10)||0),parseInt(e.style.left.slice(0,-1),10)||0)),e.style.top=Math.max(0,Math.min(100-(parseInt(e.style.height.slice(0,-1),10)||0),parseInt(e.style.top.slice(0,-1),10)||0))+"%",e.style.left=g+"%");e.style.display="flex";e.style.flexDirection="column";e.style.alignItems="center";e.style.justifyContent=
b.displayAlign=="before"?"flex-start":b.displayAlign=="center"?"center":"flex-end";a.G.set(c,e);c=e}}e=f;d&&(e=document.createElement("span"),e.classList.add("shaka-text-wrapper"),e.style.backgroundColor=b.backgroundColor,e.style.lineHeight="normal",f.appendChild(e));a.l.set(b,{og:f,nj:e,$c:c})}
function sp(a){var b=a.direction,c=a.positionAlign;a=a.textAlign;return c!==he?c:a==="left"||a==="start"&&b===je||a==="end"&&b==="rtl"?"line-left":a==="right"||a==="start"&&b==="rtl"||a==="end"&&b===je?"line-right":"center"}
function rp(a,b,c,d,e){var f=b.style,g=c.nestedCues.length==0,h=d.length>1;f.whiteSpace="pre-wrap";var k=c.payload.replace(/\s+$/g,function(m){return"\u00a0".repeat(m.length)});f.webkitTextStrokeColor=c.textStrokeColor;f.webkitTextStrokeWidth=c.textStrokeWidth;f.color=c.color;f.direction=c.direction;f.opacity=c.opacity;f.paddingLeft=tp(c.linePadding,c,a.o);f.paddingRight=tp(c.linePadding,c,a.o);f.textCombineUpright=c.textCombineUpright;f.textShadow=c.textShadow;if(c.backgroundImage)f.backgroundImage=
"url('"+c.backgroundImage+"')",f.backgroundRepeat="no-repeat",f.backgroundSize="contain",f.backgroundPosition="center",c.backgroundColor&&(f.backgroundColor=c.backgroundColor),f.width="100%",f.height="100%";else{if(c.nestedCues.length)var l=b;else l=document.createElement("span"),b.appendChild(l);c.border&&(l.style.border=c.border);e||((b=up(d,function(m){return m.backgroundColor}))?l.style.backgroundColor=b:k&&(l.style.backgroundColor="rgba(0, 0, 0, 0.8)"));k&&(l.setAttribute("translate","no"),l.textContent=
k)}if(h&&!d[d.length-1].isContainer)f.display="inline";else{f.display="flex";f.flexDirection="column";f.alignItems="center";if(c.textAlign=="left"||c.textAlign=="start")f.width="100%",f.alignItems="start";else if(c.textAlign=="right"||c.textAlign=="end")f.width="100%",f.alignItems="end";f.justifyContent=c.displayAlign=="before"?"flex-start":c.displayAlign=="center"?"center":"flex-end"}g||(f.margin="0");f.fontFamily=c.fontFamily;f.fontWeight=c.fontWeight.toString();f.fontStyle=c.fontStyle;f.letterSpacing=
c.letterSpacing;d=a.C?a.C.fontScaleFactor:1;if(d!==1||c.fontSize)f.fontSize=tp(c.fontSize||"1em",c,a.o,d);d=c.line;d!=null&&(g=c.lineInterpretation,g==le&&(g=1,h=16,a.u&&a.u<1&&(h=32),d=d<0?100+d/h*100:d/h*100),g==1&&(f.position="absolute",c.writingMode==ke?(f.width="100%",c.lineAlign==me?f.top=d+"%":c.lineAlign=="end"&&(f.bottom=100-d+"%")):c.writingMode=="vertical-lr"?(f.height="100%",c.lineAlign==me?f.left=d+"%":c.lineAlign=="end"&&(f.right=100-d+"%")):(f.height="100%",c.lineAlign==me?f.right=
d+"%":c.lineAlign=="end"&&(f.left=100-d+"%"))));f.lineHeight=c.lineHeight;a=sp(c);a=="line-left"?(f.cssFloat="left",c.position!==null&&(f.position="absolute",c.writingMode==ke?(f.left=c.position+"%",f.width="auto"):f.top=c.position+"%")):a=="line-right"?(f.cssFloat="right",c.position!==null&&(f.position="absolute",c.writingMode==ke?(f.right=100-c.position+"%",f.width="auto"):f.bottom=c.position+"%")):c.position!==null&&c.position!=50&&(f.position="absolute",c.writingMode==ke?(f.left=c.position+"%",
f.width="auto"):f.top=c.position+"%",c.size&&(f.transform="translateX(-50%)"));f.textAlign=c.textAlign;f.textDecoration=c.textDecoration.join(" ");f.writingMode=c.writingMode;"writingMode"in document.documentElement.style&&f.writingMode==c.writingMode||(f.webkitWritingMode=c.writingMode);c.size&&(c.writingMode==ke?f.width=c.size+"%":f.height=c.size+"%")}
function tp(a,b,c,d){d=d===void 0?1:d;var e=(e=(new RegExp(/(\d*\.?\d+)([a-z]+|%+)/)).exec(a))?{value:Number(e[1]),unit:e[2]}:null;if(!e)return a;a=e.unit;d*=e.value;switch(a){case "%":return d/100*c.clientHeight/b.cellResolution.rows+"px";case "c":return c.clientHeight*d/b.cellResolution.rows+"px";default:return d+a}}function up(a,b){for(var c=a.length-1;c>=0;c--){var d=b(a[c]);if(d||d===0)return d}return null}T("shaka.text.UITextDisplayer",lp);lp.prototype.enableTextDisplayer=lp.prototype.enableTextDisplayer;
lp.prototype.setTextLanguage=lp.prototype.setTextLanguage;lp.prototype.setTextVisibility=lp.prototype.setTextVisibility;lp.prototype.isTextVisible=lp.prototype.isTextVisible;lp.prototype.remove=lp.prototype.remove;lp.prototype.destroy=lp.prototype.destroy;lp.prototype.append=lp.prototype.append;lp.prototype.configure=lp.prototype.configure;function vp(a,b){function c(f){for(var g=f,h=u(b),k=h.next();!k.done;k=h.next())k=k.value,k.end&&k.start<f&&(g+=k.end-k.start);f=Math.floor(g/3600);h=Math.floor(g/60%60);k=Math.floor(g%60);g=Math.floor(g*1E3%1E3);return(f<10?"0":"")+f+":"+(h<10?"0":"")+h+":"+(k<10?"0":"")+k+"."+(g<100?g<10?"00":"0":"")+g}var d=bp(a);a="WEBVTT\n\n";d=u(d);for(var e=d.next();!e.done;e=d.next())e=e.value,a+=c(e.startTime)+" --\x3e "+c(e.endTime)+function(f){var g=[];switch(f.textAlign){case "left":g.push("align:left");
break;case "right":g.push("align:right");break;case ie:g.push("align:middle");break;case "start":g.push("align:start");break;case "end":g.push("align:end")}switch(f.writingMode){case "vertical-lr":g.push("vertical:lr");break;case "vertical-rl":g.push("vertical:rl")}return g.length?" "+g.join(" "):""}(e)+"\n",a+=e.payload+"\n\n";return a}T("shaka.text.WebVttGenerator",function(){});function wp(a,b){this.g=b;this.j=a;this.m=new Map;this.l=void 0;this.F=!1;this.J=!0;this.u=this.I=!1;this.C=this.B=void 0;this.H=0;this.K={request:!1,response:!1,event:!1};this.o={};this.i=new kb;this.G=[];this.h=null}wp.prototype.setMediaElement=function(a){this.h=a;xp(this)};wp.prototype.configure=function(a){this.g=a;yp(this)};function zp(a){a.m.clear();a.F=!1;a.J=!0;a.I=!1;a.u=!1;a.B=0;a.C=0;a.H=0;a.K={request:!1,response:!1,event:!1};Ap(a);a.o={};a.h=null;a.i.Qa()}
function Bp(a,b){a.u=b;a.u?a.l==Cp?a.l=Dp:a.l==Ep&&(a.l=Fp):a.l==Dp?a.l=Cp:a.l==Fp&&(a.l=Ep)}function Gp(a,b){if(a.g&&a.g.enabled&&(Hp(a,"ps",{dd:"d"}),a.h&&a.h.autoplay)){var c=a.h.play();c&&c.then(function(){a.H=b}).catch(function(){a.H=0})}}
function Ip(a,b,c){try{if(!a.g.enabled)return b;var d=Jp(a);a:{switch(c.toLowerCase()){case "audio/mp4":case "audio/webm":case "audio/ogg":case "audio/mpeg":case "audio/aac":case "audio/flac":case "audio/wav":var e=Kp;break a;case "video/webm":case "video/mp4":case "video/mpeg":case "video/mp2t":e=Lp;break a;case "application/x-mpegurl":case "application/vnd.apple.mpegurl":case "application/dash+xml":case "video/vnd.mpeg.dash.mpd":case "application/vnd.ms-sstr+xml":e=Mp;break a}e=void 0}d.ot=e;d.su=
!0;var f=Np(d);return Op(b,f)}catch(g){return ab("CMCD_SRC_ERROR","Could not generate src CMCD data.",g),b}}
function xp(a){a.i.D(a.h,"playing",function(){a.C||(a.C=Date.now());Hp(a,"ps",{dd:"p"})});a.i.D(a.h,"volumechange",function(){Hp(a,a.h.muted?"m":"um")});a.i.D(a.h,"play",function(){a.B||(a.B=Date.now(),Hp(a,"ps",{dd:"s"}))});a.i.D(a.h,"pause",function(){Hp(a,"ps",{dd:"a"})});a.i.D(a.j,"buffering",function(){Hp(a,"ps",{dd:"w"})});a.i.D(a.h,"seeking",function(){return Hp(a,"ps",{dd:"k"})});a.i.D(document,"fullscreenchange",function(){Hp(a,document.fullscreenElement?"pe":"pc")});var b=a.h;(b.webkitPresentationMode||
b.webkitSupportsFullscreen)&&a.i.D(b,"webkitpresentationmodechanged",function(){b.webkitPresentationMode?Hp(a,b.webkitPresentationMode!=="inline"?"pe":"pc"):b.webkitSupportsFullscreen&&Hp(a,b.webkitDisplayingFullscreen?"pe":"pc")});a.i.D(a.h,"enterpictureinpicture",function(){Hp(a,"pe")});a.i.D(a.h,"leavepictureinpicture",function(){Hp(a,"pc")});"documentPictureInPicture"in window&&a.i.D(window.documentPictureInPicture,"enter",function(c){Hp(a,"pe");a.i.Aa(c.window,"pagehide",function(){Hp(a,"pc")})});
a.i.D(document,"visibilitychange",function(){document.hidden?Hp(a,"b",{bg:!0}):Hp(a,"b")});a.i.D(a.j,"complete",function(){Hp(a,"ps",{dd:"e"})})}function yp(a){Ap(a);var b=Pp(a);b=u(b);for(var c=b.next();!c.done;c=b.next())if(c=c.value.timeInterval,c===void 0&&(c=Qp),c>=1){var d=new rf(function(){return Hp(a,Rp)});d.Ea(c);a.G.push(d)}}function Ap(a){if(a.G)for(var b=u(a.G),c=b.next();!c.done;c=b.next())c.value.stop();a.G=[]}
function Pp(a){return(a=a.g.targets)?a.filter(function(b){return b.mode===Sp&&b.enabled}):[]}function Tp(a){return(a=a.g.targets)?a.filter(function(b){return b.mode===Up&&b.enabled===!0}):[]}function Jp(a){a.g.sessionId||(a.g.sessionId=window.crypto.randomUUID());return{v:a.g.version,sf:a.l,sid:a.g.sessionId,cid:a.g.contentId,mtp:a.j.getBandwidthEstimate()/1E3}}
function Hp(a,b,c){c=c===void 0?{}:c;b=Object.assign({e:b,ts:Date.now()},c);b=Vp(a,b,Sp);c=a.g.targets;if(!(a.g.version<Wp)&&c){var d=Pp(a);c=Array.from(new Set([].concat(x(Xp),x(Yp))));d=u(d);for(var e=d.next();!e.done;e=d.next()){e=e.value;var f=Zp(e.includeKeys||[],c);f.includes($p)||f.push($p);f=aq(b,f);var g=e.events||[],h=f.e,k=f.sta;h&&(!bq.includes(h)||!(h!=="ps"||k&&cq.includes(k))||g&&g.length>0&&!g.includes(h))||dq(a,f,e)}}}
function eq(a,b,c){if(a.g.enabled){c=Vp(a,c,fq);var d=gq({mode:fq,useHeaders:a.g.useHeaders,includeKeys:a.g.includeKeys||[]});a.o[d]||(a.o[d]={request:1,response:1});c.sn=a.o[d].request++;d=a.g.includeKeys||[];var e=a.g.version==Wp?Array.from(new Set([].concat(x(Xp),x(hq)))):iq;d=Zp(d,e);c=aq(c,d);jq(a,c,b,a.g.useHeaders)}}
function dq(a,b,c,d){var e=Fg(),f=c.url;if(c.useHeaders){b=kq(b);if(!Object.keys(b).length)return;d&&Object.assign(d.headers,b);d=Zg([f],e);Object.assign(d.headers,b)}else{b=Np(b);if(!b)return;f=Op(f,b);d&&(d.uri=f);d=Zg([f],e)}a.j.Yb().request(9,d)}function jq(a,b,c,d){if(d){b=kq(b);if(!Object.keys(b).length)return;Object.assign(c.headers,b)}else{var e=Np(b);if(!e)return;c.uris=c.uris.map(function(f){return Op(f,e)})}Tp(a).length>0||!a.m.has(c)||a.m.delete(c)}
function Zp(a,b){if(!a||a.length===0)return b;for(var c=u(a),d=c.next();!d.done;d=c.next())b.includes(d.value);return a=a.filter(function(e){return b.includes(e)})}function aq(a,b){return Object.keys(a).reduce(function(c,d){b.includes(d)&&(c[d]=a[d]);return c},{})}function lq(a){if(a.type===0)return mq;if(a=a.stream){var b=a.type;if(b=="video")return a.codecs&&a.codecs.includes(",")?Lp:nq;if(b=="audio")return Kp;if(b=="text")return a.mimeType==="application/mp4"?oq:pq}}
function gq(a){var b=Object.keys(a).sort().reduce(function(c,d){d!=="enabled"&&(c[d]=a[d]);return c},{});return JSON.stringify(b)}function qq(a,b){b=a.j.Gc()[b];if(!b.length)return NaN;var c=a.h?a.h.currentTime:0;return(a=b.find(function(d){return d.start<=c&&d.end>=c}))?(a.end-c)*1E3:NaN}function rq(a,b){b=a.j.Gc()[b];if(!b.length)return 0;var c=a.h?a.h.currentTime:0;return(a=b.find(function(d){return d.start<=c&&d.end>=c}))?(a.end-c)*1E3:0}
function sq(a,b){var c=a.j.qc();if(!c.length)return NaN;a=c[0];c=u(c);for(var d=c.next();!d.done;d=c.next())d=d.value,d.type==="variant"&&d.bandwidth>a.bandwidth&&(a=d);switch(b){case nq:return a.videoBandwidth||NaN;case Kp:return a.audioBandwidth||NaN;default:return a.bandwidth}}
function tq(a,b,c){var d=b.segment,e=0;d&&(e=d.endTime-d.startTime);e={d:e*1E3,st:a.j.W()?uq:vq};e.ot=lq(b);var f=e.ot===nq||e.ot===Kp||e.ot===Lp||e.ot===oq;if(b=b.stream){var g=a.j.Ob();if(f&&(e.bl=qq(a,b.type),e.ot!==oq)){var h=rq(a,b.type);e.dl=g?h/Math.abs(g):h}b.bandwidth&&(e.br=b.bandwidth/1E3);if(b.segmentIndex&&d){if((g=b.segmentIndex.Xb(d.endTime,!0,g<0))&&(g=g.next().value)&&g!=d){if(c&&!ib(d.P(),g.P())){var k=g.P()[0];h=new URL(k);var l=new URL(c);if(h.origin!==l.origin)c=k;else{c=h.pathname.split("/").slice(1);
k=l.pathname.split("/").slice(1,-1);l=Math.min(c.length,k.length);for(var m=0;m<l&&c[m]===k[m];m++)c.shift(),k.shift();for(;k.length;)k.shift(),c.unshift("..");c=c.join("/")+h.search+h.hash}e.nor=c}!g.startByte&&!g.endByte||d.startByte==g.startByte&&d.endByte==g.endByte||(c=g.startByte+"-",g.endByte&&(c+=g.endByte),e.nrr=c)}g=a.j.Ob()||1;c=rq(a,b.type)||500;d=(b=b.bandwidth)?b*(d.endTime-d.startTime)/1E3/(c/g/1E3)*a.g.rtpSafetyFactor:NaN;isNaN(d)||(e.rtp=d)}}f&&e.ot!==oq&&(e.tb=sq(a,e.ot)/1E3);return e}
function Vp(a,b,c){Object.assign(b,Jp(a));b.pr=a.j.Ob();var d=b.ot===nq||b.ot===Lp;a.I&&d&&(b.bs=!0,b.su=!0,a.I=!1);b.su==null&&(b.su=a.J);a.j.W()&&(d=wq(a.j),b.ltc=d||void 0);document.hidden&&(b.bg=!0);d=a.C&&a.B?a.C-(a.H||a.B):void 0;d==void 0||a.K[c]||(b.msd=d,a.K[c]=!0);return b}
function Np(a){function b(n){return c(n/100)*100}function c(n){return Math.round(n)}function d(n){return!Number.isNaN(n)&&n!=null&&n!==""&&n!==!1}var e=[],f={br:c,d:c,bl:b,dl:b,mtp:b,nor:function(n){return encodeURIComponent(n)},rtp:b,tb:c,ttfb:c,ttlb:c},g=Object.keys(a||{}).sort();g=u(g);for(var h=g.next();!h.done;h=g.next()){h=h.value;var k=a[h];if(d(k)&&(h!=="v"||k!==1)&&(h!="pr"||k!==1)){var l=f[h];l&&(k=l(k));l=typeof k;var m=void 0;m=l==="string"&&h!=="ot"&&h!=="sf"&&h!=="st"?h+"="+JSON.stringify(k):
l==="boolean"?h:l==="symbol"?h+"="+k.description:h+"="+k;e.push(m)}}return e.join(",")}
function kq(a){var b=Object.keys(a),c={},d=["Object","Request","Session","Status"],e=[{},{},{},{}],f={br:0,d:0,ot:0,tb:0,url:0,bl:1,dl:1,mtp:1,nor:1,nrr:1,su:1,ltc:1,ttfb:1,ttlb:1,ts:1,rc:1,cmsdd:1,cmsds:1,sn:1,cid:2,pr:2,sf:2,sid:2,st:2,v:2,msd:2,bs:3,rtp:3,bg:3};b=u(b);for(var g=b.next();!g.done;g=b.next())g=g.value,e[f[g]!=null?f[g]:1][g]=a[g];for(a=0;a<e.length;a++)(f=Np(e[a]))&&(c["CMCD-"+d[a]]=f);return c}
function Op(a,b){if(!b||a.includes("offline:"))return a;a=new Db(a);a.g.set("CMCD",b);return a.toString()}var Mp="m",Kp="a",nq="v",Lp="av",mq="i",pq="c",oq="tt",Wp=2,vq="v",uq="l",Cp="d",Dp="ld",Ep="h",Fp="lh";T("shaka.util.CmcdManager.StreamingFormat",{DASH:Cp,Sl:Dp,HLS:Ep,Tl:Fp,im:"s",OTHER:"o"});
var iq="br bl bs cid d dl mtp nor nrr ot pr rtp sf sid st su tb v".split(" "),Xp="br ab bl tbl bs cdn cid ltc mtp pr sf sid bg sta st ts tpb tb lb tab lab pt ec msd v sn".split(" "),hq="ab bl tbl bs cdn cid d dl ltc mtp nor ot pr rtp sf sid bg sta st su ts tpb tb lb tab lab pt ec msd v".split(" "),xq="d dl nor ot rtp rc su ttfb ttfbb ttlb url cmsdd cmsds".split(" "),Yp=["e","sta"],bq="ps e t c b m um pe pc".split(" "),cq="spawkrfeqd".split(""),Qp=10,$p="ts",Rp="t",fq="request",Up="response",Sp="event";function yq(a){this.h=a;this.g=null}p=yq.prototype;p.configure=function(a){this.h=a};p.ji=function(){return this.h.enabled&&this.h.applyMaximumSuggestedBitrate&&this.g&&this.g.has(zq)?this.g.get(zq)*1E3:null};p.gi=function(){return this.h.enabled&&this.g&&this.g.has(Aq)?this.g.get(Aq)*1E3:null};p.Xj=function(){return this.h.enabled&&this.g&&this.g.has(Bq)?this.g.get(Bq):null};p.Yj=function(){return this.h.enabled&&this.g&&this.g.has(Cq)?this.g.get(Cq):null};
p.getBandwidthEstimate=function(a){var b=this.gi();if(!b)return a;var c=this.h.estimatedThroughputWeightRatio;return c>0&&c<=1?a*(1-c)+b*c:a};function Dq(a){return a?a.toLowerCase()==="false"?!1:/^[-0-9]/.test(a)?parseInt(a,10):a.replace(/["]+/g,""):!0}T("shaka.util.CmsdManager",yq);yq.prototype.getBandwidthEstimate=yq.prototype.getBandwidthEstimate;yq.prototype.getRoundTripTime=yq.prototype.Yj;yq.prototype.getResponseDelay=yq.prototype.Xj;yq.prototype.getEstimatedThroughput=yq.prototype.gi;
yq.prototype.getMaxBitrate=yq.prototype.ji;var Aq="etp",zq="mb",Bq="rd",Cq="rtt";function Eq(){this.g=null;this.h=[]}function Fq(a,b){return O(function(c){if(c.g==1)return a.g?G(c,new Promise(function(d){return a.h.push(d)}),2):c.A(2);a.g=b;H(c)})}Eq.prototype.release=function(){this.h.length>0?this.h.shift()():this.g=null};function Gq(a,b,c){c=c===void 0?Number.EPSILON:c;if(a===b)return!0;a=Math.abs(a-b);return a<=c?!0:c!==Number.EPSILON?Math.abs(a-c)<=Number.EPSILON:!1};function X(a,b,c){b=b===void 0?null:b;Rg.call(this);var d=this;this.m=Hq;this.h=null;this.Be=b;this.$=!1;this.Le=new kb;this.Ce=new kb;this.j=new kb;this.dc=new kb;this.Gd=new kb;this.G=this.H=this.F=this.N=null;this.Me=0;this.ba=new Eq;this.O=this.Fa=this.X=this.i=this.zc=this.I=this.l=this.ye=this.T=this.Ph=this.va=this.K=this.kb=this.za=this.Ae=this.R=this.Ta=this.M=this.ac=null;this.Ua=!1;this.Ge=this.o=null;this.Fe=1E9;this.Ke=[];this.yc=new Map;this.ob=[];this.ag=-1;this.g=Iq(this);this.dg=
ao();this.V=null;this.Ne=-1;this.cc=null;this.ya={width:Infinity,height:Infinity};this.Ee=new yi(this.g,this.ya,null);this.Ie=[];this.B=null;this.J=this.g.adaptationSetCriteriaFactory();this.J.configure({language:this.g.preferredAudioLanguage,role:this.g.preferredAudioRole,videoRole:this.g.preferredVideoRole,channelCount:0,hdrLevel:this.g.preferredVideoHdrLevel,spatialAudio:this.g.preferSpatialAudio,videoLayout:this.g.preferredVideoLayout,audioLabel:this.g.preferredAudioLabel,videoLabel:this.g.preferredVideoLabel,
codecSwitchingStrategy:this.g.mediaSource.codecSwitchingStrategy,audioCodec:"",activeAudioCodec:"",activeAudioChannelCount:0,preferredAudioCodecs:this.g.preferredAudioCodecs,preferredAudioChannelCount:this.g.preferredAudioChannelCount});this.Kd=this.g.preferredTextLanguage;this.Od=this.g.preferredTextRole;this.Nd=this.g.preferForcedSubs;this.De=[];c&&c(this);this.K=new wp(this,this.g.cmcd);this.va=new yq(this.g.cmsd);this.N=Jq(this);this.ma=this.oa=this.Da=this.C=null;this.fg=!1;this.cg=[];this.eg=
new rf(function(){return O(function(e){if(e.g==1)return d.oa?G(e,d.Vb(d.ma,!0),3):e.A(0);if(e.g!=4)return G(e,d.load(d.oa),4);d.fg?d.ma.pause():d.ma.play();d.oa=null;d.fg=!1;H(e)})});Kq&&(this.C=Kq(),this.C.configure(this.g.ads),this.Gd.D(this.C,"ad-content-pause-requested",function(e){var f,g;return O(function(h){if(h.g==1){d.eg.stop();if(d.oa)return h.A(0);d.ma=d.h;d.fg=d.ge();f=e.saveLivePosition||!1;g=!0;d.W()&&(g=f);return G(h,d.$h(!0,g),3)}d.oa=h.h;H(h)})}),this.Gd.D(this.C,"ad-content-resume-requested",
function(e){e=e.offset||0;if(d.oa){var f=d.oa;f.o&&e&&(typeof f.o==="number"?f.o+=e:f.o.setTime(f.o.getTime()+e*1E3))}d.eg.ka(.1)}),this.Gd.D(this.C,"ad-content-attach-requested",function(){return O(function(e){if(e.g==1)return d.h||!d.ma?e.A(0):G(e,d.Vb(d.ma,!0),3);d.ma=null;H(e)})}));Lq&&(this.Da=Lq(this),this.Da.configure(this.g.queue));this.Le.D(window,"online",function(){Mq(d);d.kh()});this.He=new rf(function(){for(var e=Date.now()/1E3,f=!1,g=!0,h=u(d.i.variants),k=h.next();!k.done;k=h.next())k=
k.value,k.disabledUntilTime>0&&k.disabledUntilTime<=e&&(k.disabledUntilTime=0,f=!0),k.disabledUntilTime>0&&(g=!1);g&&d.He.stop();f&&Nq(d,!1,void 0,!1,!1)});this.eb=null;a&&(yb("Player w/ mediaElement","Please migrate from initializing Player with a mediaElement; use the attach method instead."),this.Vb(a,!0));this.u=null}ma(X,Rg);function Oq(a){a.T!=null&&(Qc(a.T),a.T.release(),a.T=null)}
function Pq(a,b,c){c||b.lcevc.enabled?(Oq(a),a.T==null&&(a.T=new Oc(a.h,a.Ph,b.lcevc,c),a.H&&(a.H.C=a.T))):Oq(a)}function Qq(a,b){return new V(a,b)}p=X.prototype;
p.destroy=function(){var a=this,b;return O(function(c){switch(c.g){case 1:if(a.m==Rq)return c.return();Oq(a);b=a.detach();a.m=Rq;return G(c,b,2);case 2:return G(c,a.rg(),3);case 3:a.Le&&(a.Le.release(),a.Le=null);a.Ce&&(a.Ce.release(),a.Ce=null);a.j&&(a.j.release(),a.j=null);a.dc&&(a.dc.release(),a.dc=null);a.Gd&&(a.Gd.release(),a.Gd=null);a.Ge=null;a.g=null;a.B=null;a.Be=null;a.K=null;a.va=null;if(!a.N){c.A(4);break}return G(c,a.N.destroy(),5);case 5:a.N=null;case 4:a.o&&(a.o.release(),a.o=null),
a.Da&&(a.Da.destroy(),a.Da=null),Rg.prototype.release.call(a),H(c)}})};function Sq(a,b){Tq.set(a,b)}function Uq(a,b){a.dispatchEvent(Qq("onstatechange",(new Map).set("state",b)))}
p.Vb=function(a,b){b=b===void 0?!0:b;var c=this,d,e,f;return O(function(g){switch(g.g){case 1:if(c.m==Rq)throw new U(2,7,7E3);d=c.h&&c.h==a;if(!c.h||c.h==a){g.A(2);break}return G(g,c.detach(),2);case 2:return G(g,Vq(c,"attach"),4);case 4:if(g.h)return g.return();sa(g,5,6);d||(Uq(c,"attach"),e=function(){var h=Wq(c,!1);h&&Xq(c,h)},c.Ce.D(a,"error",e),c.h=a,c.K&&c.K.setMediaElement(a));rb();if(!b||!Wc()||c.H){g.A(6);break}return G(g,Yq(c),6);case 6:Ba(g);c.ba.release();Ea(g,0);break;case 5:return f=
Aa(g),G(g,c.detach(),10);case 10:throw f;}})};p.qj=function(a){this.Ph=a};p.detach=function(a){a=a===void 0?!1:a;var b=this;return O(function(c){if(c.g==1){if(b.m==Rq)throw new U(2,7,7E3);return G(c,b.Cc(!1,a),2)}if(c.g!=3)return G(c,Vq(b,"detach"),3);if(c.h)return c.return();try{b.h&&(b.Ce.Qa(),b.h=null),Uq(b,"detach"),b.C&&!a&&b.C.release()}finally{b.ba.release()}H(c)})};
function Vq(a,b){var c;return O(function(d){return d.g==1?(c=++a.Me,G(d,Fq(a.ba,b),2)):c!=a.Me?(a.ba.release(),d.return(!0)):d.return(!1)})}
p.Cc=function(a,b){a=a===void 0?!0:a;b=b===void 0?!1:b;var c=this,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y;return O(function(A){switch(A.g){case 1:return c.m!=Rq&&(c.m=Hq),G(A,Vq(c,"unload"),2);case 2:if(A.h)return A.return();ta(A,3);c.Ua=!1;Uq(c,"unload");Oq(c);d=c.De.map(function(E){return E()});c.De=[];return G(A,Promise.all(d),5);case 5:c.dispatchEvent(Qq("unloading"));c.Ae&&(c.Ae.release(),c.Ae=null);c.za&&(c.za.release(),c.za=null);c.kb&&(c.kb.release(),c.kb=null);c.h&&(c.j.Qa(),c.dc.Qa());c.He.stop();
c.ac&&(c.ac.release(),c.ac=null);c.Ta&&(c.Ta.stop(),c.Ta=null);if(!c.I){A.A(6);break}return G(A,c.I.stop(),7);case 7:c.I=null,c.zc=null;case 6:c.o&&c.o.stop();if(!c.l){A.A(8);break}return G(A,c.l.destroy(),9);case 9:c.l=null;case 8:c.M&&(c.M.release(),c.M=null);c.G&&(c.G.release(),c.G=null);if("webkit"!==window.shakaMediaKeysPolyfill||!c.F){A.A(10);break}return G(A,c.F.destroy(),11);case 11:c.F=null;case 10:if(!c.H){A.A(12);break}return G(A,c.H.destroy(),13);case 13:c.H=null;case 12:if(c.C&&!b)c.C.onAssetUnload();
c.oa&&!b&&(c.oa.destroy(),c.oa=null);b||c.eg.stop();c.K&&zp(c.K);c.va&&(c.va.g=null);if(!c.u){A.A(14);break}return G(A,c.u.destroy(),15);case 15:c.u=null;case 14:c.$=!1;if(c.h){e=u(c.cg);for(f=e.next();!f.done;f=e.next())g=f.value,g.src.startsWith("blob:")&&URL.revokeObjectURL(g.src),g.remove();c.cg=[];Mj(c.h)&&c.h.load()}if(!c.F){A.A(16);break}return G(A,c.F.destroy(),17);case 17:c.F=null;case 16:c.eb&&c.X!=c.eb.rd()&&(c.eb.l||c.eb.destroy(),c.eb=null);c.X=null;c.Fa=null;c.R=null;if(c.i){h=u(c.i.variants);
for(k=h.next();!k.done;k=h.next())for(l=k.value,m=u([l.audio,l.video]),n=m.next();!n.done;n=m.next())(q=n.value)&&q.segmentIndex&&q.segmentIndex.release();r=u(c.i.textStreams);for(t=r.next();!t.done;t=r.next())v=t.value,v.segmentIndex&&v.segmentIndex.release()}c.g&&c.g.streaming.clearDecodingCache&&(Yf.clear(),lc.clear());c.i=null;c.B=new io;c.Oh=null;c.cc=null;c.V=null;c.Ne=-1;c.Ke=[];w=u(c.yc.values());for(z=w.next();!z.done;z=w.next())y=z.value,y.stop();c.yc.clear();c.ob=[];c.ag=-1;c.N&&c.N.Wh();
Zq(c);case 3:Ba(A);c.ba.release();Ea(A,4);break;case 4:rb();if(a&&Wc()&&!c.H&&c.h)return G(A,Yq(c),0);A.A(0)}})};p.ql=function(a){this.O=a};
p.load=function(a,b,c){b=b===void 0?null:b;var d=this,e,f,g,h,k,l,m,n,q,r,t,v,w,z;return O(function(y){switch(y.g){case 1:if(d.m==Rq)throw new U(2,7,7E3);if(d.h||!d.ma){y.A(2);break}return G(y,d.Vb(d.ma,!0),3);case 3:d.ma=null;case 2:e=null;f="";if(a instanceof oo){if(a.l)throw new U(2,7,7006);e=a;f=e.rd()||""}else f=a||"";return G(y,Fq(d.ba,"load"),4);case 4:d.ba.release();if(!d.h)throw new U(2,7,7002);if(!d.X){y.A(5);break}d.X=f;return G(y,d.Cc(!1),5);case 5:g=++d.Me;h=function(){return O(function(A){if(A.g==
1)return d.Me==g?A.A(0):e?G(A,e.destroy(),3):A.A(3);throw new U(2,7,7E3);})};k=function(A,E){return O(function(I){switch(I.g){case 1:return ta(I,2),G(I,Fq(d.ba,E),4);case 4:return G(I,h(),5);case 5:return G(I,A(),6);case 6:return G(I,h(),7);case 7:e&&d.g&&(e.g=d.g);case 2:Ba(I),d.ba.release(),Ea(I,0)}})};sa(y,7,8);b==null&&e&&(b=e.getStartTime());d.O=b;d.Ua=!1;d.dispatchEvent(Qq("loading"));if(e){c=e.V;y.A(10);break}if(c){y.A(10);break}return G(y,k(function(){return O(function(A){if(A.g==1)return G(A,
$q(d,f),2);c=A.h;H(A)})},"guessMimeType_"),10);case 10:l=!!e;if(e){ro(e,d);d.B=e.getStats();y.A(13);break}return G(y,ar(d,f,b,c,!0,d.g),14);case 14:(e=y.h)?(e.F=!1,ro(e,d),d.B=e.getStats(),e.start(),e.B.catch(function(){})):d.B=new io;case 13:m=!e;n=Date.now()/1E3;d.B=e?e.getStats():new io;d.X=f;d.Fa=c||null;Zq(d);q=function(){var A=d.h?d.h.buffered:null;return{start:Ej(A)||0,end:Fj(A)||0}};d.za=new jm(q);d.za.addEventListener("regionadd",function(A){br(d,A.region,"metadataadded")});if(m)return G(y,
k(function(){return O(function(A){return G(A,cr(d,c),0)})},"initializeSrcEqualsDrmInner_"),25);d.kb=new jm(q);return G(y,k(function(){return O(function(A){if(A.g==1)return G(A,Promise.race([e.ma,e.B]),2);d.zc=e.H;var E=e;E.oa=!0;d.I=E.m;d.i=e.Lg();H(A)})},"waitForFinish"),17);case 17:if(d.H){y.A(18);break}return G(y,k(function(){return O(function(A){return G(A,Yq(d),0)})},"initializeMediaSourceEngineInner_"),18);case 18:return d.i&&d.i.textStreams.length&&(d.u.enableTextDisplayer?d.u.enableTextDisplayer():
yb("Text displayer w/ enableTextDisplayer",'Text displayer should have a "enableTextDisplayer" method!')),G(y,k(function(){return O(function(A){return G(A,e.B,0)})},"waitForFinish"),20);case 20:d.g=e.getConfiguration();d.Ee=e.G;d.I&&d.I.setMediaElement&&d.h&&d.I.setMediaElement(d.h);d.Ae=so(e);d.ye=e.Fa;if(r=e.C)d.J=r;l&&d.h&&d.h.nodeName==="AUDIO"&&(dr(d),d.configure("manifest.disableVideo",!0));if(e.j){y.A(21);break}return G(y,k(function(){return O(function(A){return G(A,xo(e,d.h),0)})},"drmEngine_.init"),
21);case 21:return d.F=to(e),G(y,k(function(){return O(function(A){return G(A,d.F.Vb(d.h),0)})},"drmEngine_.attach"),23);case 23:return t=d.g.abrFactory,d.o&&d.Ge==t||(d.Ge=t,d.o&&d.o.release(),d.o=t(),typeof d.o.setMediaElement!="function"&&(yb("AbrManager w/o setMediaElement","Please use an AbrManager with setMediaElement function."),d.o.setMediaElement=function(){}),typeof d.o.setCmsdManager!="function"&&(yb("AbrManager w/o setCmsdManager","Please use an AbrManager with setCmsdManager function."),
d.o.setCmsdManager=function(){}),typeof d.o.trySuggestStreams!="function"&&(yb("AbrManager w/o trySuggestStreams","Please use an AbrManager with trySuggestStreams function."),d.o.trySuggestStreams=function(){}),d.o.configure(d.g.abr)),v=uo(e),w=e.i,G(y,k(function(){return O(function(A){return G(A,er(d,n,w,v),0)})},"loadInner_"),24);case 24:qo(e);d.Fa&&rb().gj()&&cf(d.Fa)&&Ak(d.H,d.X,d.Fa);y.A(16);break;case 25:return G(y,k(function(){return O(function(A){return G(A,fr(d,n,c),0)})},"srcEqualsInner_"),
16);case 16:d.dispatchEvent(Qq("loaded"));case 8:Ba(y);if(!e){y.A(27);break}return G(y,e.destroy(),27);case 27:d.eb=null;Ea(y,0);break;case 7:z=Aa(y);if(!z||z.code==7E3){y.A(29);break}return G(y,d.Cc(!1),29);case 29:throw z;}})};function dr(a){for(var b=u(a.i.variants),c=b.next();!c.done;c=b.next())c=c.value,c.video&&(c.video.closeSegmentIndex(),c.video=null),c.bandwidth=c.audio&&c.audio.bandwidth?c.audio.bandwidth:0;a.i.variants=a.i.variants.filter(function(d){return d.audio})}
p.jj=function(a,b,c){a=a===void 0?!0:a;b=b===void 0?!1:b;c=c===void 0?!1:c;var d=this,e;return O(function(f){return f.g==1?G(f,gr(d,c),2):f.g!=3?(e=f.h,G(f,d.Cc(a,b),3)):f.return(e)})};p.$h=function(a,b){a=a===void 0?!1:a;b=b===void 0?!1:b;var c=this,d;return O(function(e){return e.g==1?G(e,gr(c,b),2):e.g!=3?(d=e.h,G(e,c.detach(a),3)):e.return(d)})};
function gr(a,b){b=b===void 0?!1:b;var c,d,e;return O(function(f){if(f.g==1){c=null;if(!(a.i&&a.I&&a.zc&&a.X&&a.g))return f.A(2);d=a.h.currentTime;b||(d=null);return G(f,hr(a,a.X,d,a.Fa,a.g,!0,!1),3)}if(f.g!=2){c=f.h;a.Ie.push(c);a.I&&a.I.setMediaElement&&a.I.setMediaElement(null);if(e=a.l?a.l.o:null)c.i=e;var g=c,h=a.I,k=a.zc;g.h=a.i;g.m=h;g.H=k;c.C=a.J;c.start();a.i=null;a.I=null;a.zc=null;a.o=null;a.Ge=null}return f.return(c)})}
p.preload=function(a,b,c,d){b=b===void 0?null:b;var e=this,f,g;return O(function(h){if(h.g==1)return f=Iq(e),bo(f,d||e.g,Iq(e)),G(h,ar(e,a,b,c,!1,f),2);(g=h.h)?g.start():Xq(e,new U(2,7,7005));return h.return(g)})};p.rg=function(){var a=this,b,c,d,e;return O(function(f){b=[];c=u(a.Ie);for(d=c.next();!d.done;d=c.next())e=d.value,e.l||b.push(e.destroy());a.Ie=[];return G(f,Promise.all(b),0)})};
function ar(a,b,c,d,e,f){e=e===void 0?!1:e;var g,h,k,l;return O(function(m){if(m.g==1)return d?m.A(2):G(m,$q(a,b),3);m.g!=2&&(d=m.h);if(g=ir(a,d))return m.return(null);h=f||a.g;k=!1;e&&a.h&&a.h.nodeName==="AUDIO"&&(k=!0);l=hr(a,b,c,d||null,h,!e,k);l=e?l.then(function(n){n.F=!1;return n}):l.then(function(n){a.Ie.push(n);return n});return m.return(l)})}
function hr(a,b,c,d,e,f,g){f=f===void 0?!0:f;g=g===void 0?!1:g;var h,k,l,m,n,q,r,t,v,w,z,y,A,E,I;return O(function(D){if(D.g==1){h=null;k=wd(e);g&&(k.manifest.disableVideo=!0);l=function(){return h.R&&h.l?null:h};m=function(){return l()?l().getConfiguration():a.g};if(a.ya.width!=Infinity||a.ya.height!=Infinity||a.g.ignoreHardwareResolution)return D.A(2);n=rb();return G(D,n.lc(),3)}D.g!=2&&(q=D.h,a.ya.width=q.width,a.ya.height=q.height);r=new yi(k,a.ya,null);t={networkingEngine:a.N,filter:function(C){var B,
J;return O(function(F){if(F.g==1)return G(F,zi(r,C),2);if(F.g!=4){B=F.h;if(!B)return F.A(0);J=Qq("trackschanged");return G(F,Promise.resolve(),4)}h.dispatchEvent(J);H(F)})},makeTextStreamsForClosedCaptions:function(C){return jr(a,C)},onTimelineRegionAdded:function(C){km(h.I,C)},onEvent:function(C){return h.dispatchEvent(C)},onError:function(C){return h.onError(C)},isLowLatencyMode:function(){return m().streaming.lowLatencyMode},updateDuration:function(){a.l&&h.R&&a.l.updateDuration()},newDrmInfo:function(C){var B=
h.j,J=B?B.g:null;J&&B.B&&Ci(r,J.keySystem,C)},onManifestUpdated:function(){var C=(new Map).set("isLive",a.W());h.dispatchEvent(Qq("manifestupdated",C));po(h,!1,function(){if(a.C)a.C.onManifestUpdated(a.W())})},getBandwidthEstimate:function(){return a.o.getBandwidthEstimate()},onMetadata:function(C,B,J,F){var L=C;if(C=="com.apple.hls.interstitial"||C=="com.apple.hls.overlay")if(L="com.apple.quicktime.HLS",C={startTime:B,endTime:J,values:F},a.C)a.C.onHLSInterstitialMetadata(a,a.h,C);F=u(F);C=F.next();
for(var K={};!C.done;K={bh:void 0},C=F.next())K.bh=C.value,K.bh.name!="ID"&&po(h,!1,function(P){return function(){kr(a,B,J,L,P.bh)}}(K))},disableStream:function(C){return a.disableStream(C,a.g.streaming.maxDisabledTime)},addFont:function(C,B){return a.addFont(C,B)}};v=new jm(function(){return a.Ra()});v.addEventListener("regionadd",function(C){var B=C.region;lr(a,"timelineregionadded",B,h);po(h,!1,function(){a.C&&(a.C.onDashTimedMetadata(B),a.C.onDASHInterstitialMetadata(a,a.h,B))})});w=null;k.streaming.observeQualityChanges&&
(w=new dm(function(){return a.Gc()}),w.addEventListener("qualitychange",function(C){mr(a,C.quality,C.position)}),w.addEventListener("audiotrackchange",function(C){mr(a,C.quality,C.position,!0)}));z=!0;y={vc:a.N,onError:function(C){return h.onError(C)},zf:function(C){po(h,!0,function(){a.F&&nr(a,C)})},onExpirationUpdated:function(C,B){var J=Qq("expirationupdated");h.dispatchEvent(J);if((J=h.m)&&J.onExpirationUpdated)J.onExpirationUpdated(C,B)},onEvent:function(C){h.dispatchEvent(C);C.type=="drmsessionupdate"&&
z&&(z=!1,C=Date.now()/1E3-h.za,(a.B||h.getStats()).m=C,a.T&&Qc(a.T))}};A=Jq(a,l);Yg(a.N,A);E=function(){return a.md(y)};I={config:k,zk:t,Kk:v,Jk:w,md:E,yk:r,networkingEngine:A,pj:f};h=new oo(b,d,c,I);return D.return(h)})}
function $q(a,b){var c,d,e,f;return O(function(g){if(g.g==1)return c=a.g.manifest.retryParameters,G(g,Em(b,a.N,c),2);d=g.h;d=="application/x-mpegurl"&&(e=rb(),e.Ha()==="WEBKIT"&&(d="application/vnd.apple.mpegurl"));d=="video/quicktime"&&(f=rb(),f.Ha()==="CHROMIUM"&&(d="video/mp4"));return g.return(d)})}
function ir(a,b){if(!Wc(rb()))return!0;if(b){if((a.h||Xc()).canPlayType(b)=="")return!1;if(!Wc(rb())||!Uc.has(b.toLowerCase()))return!0;if(cf(b))return rb().Ha()==="WEBKIT"&&(a.g.drm.servers["com.apple.fps"]||a.g.drm.servers["com.apple.fps.1_0"])?a.g.streaming.useNativeHlsForFairPlay:a.g.streaming.preferNativeHls;if(b==="application/dash+xml"||b==="video/vnd.mpeg.dash.mpd")return a.g.streaming.preferNativeDash}return!1}
function or(a,b){var c=a.g.textDisplayFactory;a.Oh!==c||(b===void 0?0:b)?(b=a.u,a.u=c(),a.u.configure?a.u.configure(a.g.textDisplayer):yb("Text displayer w/ configure",'Text displayer should have a "configure" method!'),a.u.setTextLanguage||yb("Text displayer w/ setTextLanguage",'Text displayer should have a "setTextLanguage" method!'),b?(a.u.setTextVisibility(b.isTextVisible()),b.destroy().catch(function(){})):a.u.setTextVisibility(a.$),a.H&&ll(a.H,a.u),a.Oh=c,a.l&&Ym(a.l)):a.u&&a.u.configure&&a.u.configure(a.g.textDisplayer)}
function Yq(a){var b,c,d;return O(function(e){if(e.g==1)return rb(),Uq(a,"media-source"),a.g.mediaSource.useSourceElements&&Mj(a.h),or(a),b=pr(a.h,a.u,{Pj:function(){return a.keySystem()},onMetadata:function(f,g,h){f=u(f);for(var k=f.next();!k.done;k=f.next())if(k=k.value,k.data&&typeof k.cueTime=="number"&&k.frames){var l=k.cueTime+g,m=h;m&&l>m&&(m=l);for(var n=u(k.frames),q=n.next();!q.done;q=n.next())kr(a,l,m,"org.id3",q.value);if(a.C)a.C.onHlsTimedMetadata(k,l)}},Ek:function(f){a.kb&&km(a.kb,
{schemeIdUri:f.schemeIdUri,startTime:f.startTime,endTime:f.endTime,id:String(f.id),emsg:f})},onEvent:function(f){return a.dispatchEvent(f)},Gk:function(){a.I&&a.I.update&&a.I.update()}},a.T,a.g.mediaSource),c=a.g.manifest,d=c.segmentRelativeVttTiming,b.Fa=d,G(e,b.M,2);a.H=b;H(e)})}
function qr(a,b,c){function d(){return rr(a)}a.j.D(b,"playing",d);a.j.D(b,"pause",d);a.j.D(b,"ended",d);a.j.D(b,"ratechange",function(){var f=a.h.playbackRate;f!=0&&(a.M&&(a.M.set(f),a.m==sr&&a.o.playbackRateChanged(f),tr(a,f)),f=Qq("ratechange"),a.dispatchEvent(f))});b.remote&&(a.j.D(b.remote,"connect",function(){a.l&&b.remote.state=="connected"&&ur(a);vr(a)}),a.j.D(b.remote,"connecting",function(){return vr(a)}),a.j.D(b.remote,"disconnect",function(){return O(function(f){if(f.g==1)return a.l&&b.remote.state==
"disconnected"?G(f,mn(a.l),3):f.A(2);f.g!=2&&ur(a);vr(a);H(f)})}));b.audioTracks&&(a.j.D(b.audioTracks,"addtrack",function(){return vr(a)}),a.j.D(b.audioTracks,"removetrack",function(){return vr(a)}),a.j.D(b.audioTracks,"change",function(){return vr(a)}));b.videoTracks&&(a.j.D(b.videoTracks,"addtrack",function(){return vr(a)}),a.j.D(b.videoTracks,"removetrack",function(){return vr(a)}),a.j.D(b.videoTracks,"change",function(){return vr(a)}));(b.webkitPresentationMode||b.webkitSupportsFullscreen)&&
a.j.D(b,"webkitpresentationmodechanged",function(){a.Be&&or(a,!0)});if(b.textTracks){var e=function(){a.m===wr&&a.u instanceof gp&&ur(a);vr(a)};a.j.D(b.textTracks,"addtrack",function(f){if(f.track)switch(f=f.track,f.kind){case "metadata":xr(a,f);break;case "chapters":yr(a,f);break;default:e()}});a.j.D(b.textTracks,"removetrack",e);a.j.D(b.textTracks,"change",e)}b.preload!="none"&&a.j.Aa(b,"loadedmetadata",function(){a.B.G=Date.now()/1E3-c})}
function er(a,b,c,d){var e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q,N;return O(function(M){switch(M.g){case 1:Uq(a,"load");e=a.h;a.M=new $l({cf:function(){return e.playbackRate},Tc:function(){return e.defaultPlaybackRate},uh:function(R){e.playbackRate=R},Di:function(R){e.currentTime+=R}});qr(a,e,b);"onchange"in window.screen&&a.j.D(window.screen,"change",function(){if(a.J.getConfiguration){var R=a.J.getConfiguration();R.hdrLevel=="AUTO"?zr(a):a.g.preferredVideoHdrLevel=="AUTO"&&a.g.abr.enabled&&
(R.hdrLevel="AUTO",a.J.configure(R),zr(a))}});f=!1;g=u(a.i.variants);for(h=g.next();!h.done;h=g.next())k=h.value,(l=k.video&&k.video.dependencyStream)&&(f=Rc(l));Pq(a,a.g,f);a.Kd=a.g.preferredTextLanguage;a.Od=a.g.preferredTextRole;a.Nd=a.g.preferForcedSubs;Ar(a.i.presentationTimeline,a.g.playRangeStart,a.g.playRangeEnd);a.o.init(function(R,S,ka){a.i&&a.l&&R!=a.l.o&&Br(a,R,!0,S===void 0?!1:S,ka===void 0?0:ka)});a.o.setMediaElement(e);a.o.setCmsdManager(a.va);a.l=Cr(a);a.l.configure(a.g.streaming);
a.m=sr;a.dispatchEvent(Qq("streaming"));m=c;case 2:(q=a.l.o)||m||(m=Dr(a,!0));r=[];n=q||m;t=u([n.video,n.audio]);for(v=t.next();!v.done;v=t.next())(w=v.value)&&!w.segmentIndex&&(r.push(w.createSegmentIndex()),w.dependencyStream&&r.push(w.dependencyStream.createSegmentIndex()));if(!(r.length>0)){M.A(4);break}return G(M,Promise.all(r),4);case 4:if(!n||n.disabledUntilTime!=0){M.A(2);break}zr(a);if(a.I&&a.I.onInitialVariantChosen)a.I.onInitialVariantChosen(n);a.i.isLowLatency&&(a.g.streaming.lowLatencyMode?
a.configure(a.dg):$a("Low-latency live stream detected, but low-latency streaming mode is not enabled in Shaka Player. Set streaming.lowLatencyMode configuration to true, and see https://bit.ly/3clctcj for details."));a.K&&(Bp(a.K,a.i.isLowLatency&&a.g.streaming.lowLatencyMode),Gp(a.K,b*1E3));Ar(a.i.presentationTimeline,a.g.playRangeStart,a.g.playRangeEnd);Om(a.l,a.g.playRangeStart,a.g.playRangeEnd);a.Ua=!0;a.dispatchEvent(Qq("canupdatestarttime"));z=function(R){a.G=Er(a,R);a.ac=Fr(a,R);Gr(a,e,!1)};
a.g.streaming.startAtSegmentBoundary||(y=a.O,y==null&&a.i.startTime&&(y=a.i.startTime),z(y));if(q){M.A(7);break}if(!a.g.streaming.startAtSegmentBoundary){M.A(8);break}A=a.i.presentationTimeline;a.O instanceof Date&&(I=A.m||A.i,D=a.O.getTime()/1E3-I,D!=null&&(E=D));E==null&&(E=typeof a.O==="number"?a.O:a.h.currentTime);a.O==null&&a.i.startTime&&(E=a.i.startTime);C=A.Zb();B=A.Gb();E<C?E=C:E>B&&(E=B);return G(M,Hr(m,E),9);case 9:J=M.h,z(J);case 8:Br(a,m,!0,!1,0);case 7:return a.G.ready(),F=a.Lc().find(function(R){return R.active}),
F||((L=tg(a.i.textStreams,a.Kd,a.Od,a.Nd)[0]||null)&&ho(a.B.h,L,!0),m&&(L?(xg(m.audio,L,a.g)&&(a.$=!0),a.$&&a.u.setTextVisibility(!0)):(a.$=!1,a.u.setTextVisibility(!1)),Ir(a)),L&&(a.g.streaming.alwaysStreamText||a.Sg())&&(Xm(a.l,L),Jr(a))),G(M,a.l.start(d),10);case 10:a.g.abr.enabled&&(a.o.enable(),Kr(a));vr(a);a.i.variants.some(function(R){return R.primary});if((K=a.W())&&(a.g.streaming.liveSync&&a.g.streaming.liveSync.enabled||a.i.serviceDescription||a.g.streaming.liveSync.panicMode)||a.g.streaming.vodDynamicPlaybackRate)P=
function(){return Lr(a)},a.j.D(e,"timeupdate",P);K||(Q=function(){return Mr(a)},a.j.D(e,"timeupdate",Q),Mr(a),a.i.nextUrl&&(a.g.streaming.preloadNextUrlWindow>0&&(N=function(){var R;return O(function(S){if(S.g==1){R=a.Ra().end-a.h.currentTime;if(isNaN(R)||!(R<=a.g.streaming.preloadNextUrlWindow))return S.A(0);a.j.Ma(e,"timeupdate",N);return G(S,a.preload(a.i.nextUrl),4)}a.eb=S.h;H(S)})},a.j.D(e,"timeupdate",N)),a.j.D(e,"ended",function(){a.load(a.eb||a.i.nextUrl)})));if(a.C)a.C.onManifestUpdated(K);
H(M)}})}function cr(a,b){var c,d,e;return O(function(f){return f.g==1?(c=Date.now()/1E3,d=!0,a.F=a.md({vc:a.N,onError:function(g){Xq(a,g)},zf:function(){},onExpirationUpdated:function(){var g=Qq("expirationupdated");a.dispatchEvent(g)},onEvent:function(g){a.dispatchEvent(g);g.type=="drmsessionupdate"&&d&&(d=!1,a.B.m=Date.now()/1E3-c)}}),a.F.configure(a.g.drm),e=yg([b]),a.F.O=!0,G(f,Ph(a.F,[e],[]),2)):G(f,a.F.Vb(a.h),0)})}
function fr(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t;return O(function(v){switch(v.g){case 1:Uq(a,"src-equals");d=a.h;a.G=new Ml(d);e=!1;a.De.push(function(){e=!0});a.dispatchEvent(Qq("canupdatestarttime"));a.O!=null&&a.G.$f(a.O);a.ac=Nr(a,a.O||0);a.M=new $l({cf:function(){return d.playbackRate},Tc:function(){return d.defaultPlaybackRate},uh:function(w){d.playbackRate=w},Di:function(w){d.currentTime+=w}});Gr(a,d,!0);d.textTracks&&(or(a),f=function(w){if(!(a.u instanceof gp)){var z=Or(a).find(function(y){return y.mode!==
"disabled"});z&&(z.mode=w?"showing":"hidden");a.u instanceof ip&&(z=Pr(a))&&(z.mode=!w&&a.u.isTextVisible()?"showing":"hidden")}},a.j.D(d,"enterpictureinpicture",function(){return f(!0)}),a.j.D(d,"leavepictureinpicture",function(){return f(!1)}),d.remote?(a.j.D(d.remote,"connect",function(){return f(!1)}),a.j.D(d.remote,"connecting",function(){return f(!1)}),a.j.D(d.remote,"disconnect",function(){return f(!1)})):"webkitCurrentPlaybackTargetIsWireless"in d&&a.j.D(d,"webkitcurrentplaybacktargetiswirelesschanged",
function(){return f(!1)}),g=d,(g.webkitPresentationMode||g.webkitSupportsFullscreen)&&a.j.D(g,"webkitpresentationmodechanged",function(){g.webkitPresentationMode?f(g.webkitPresentationMode!=="inline"):g.webkitSupportsFullscreen&&f(g.webkitDisplayingFullscreen)}));qr(a,d,b);h=Ip(a.K,a.X,c);!h.includes("#t=")&&(a.g.playRangeStart>0||isFinite(a.g.playRangeEnd))&&(h+="#t=",a.g.playRangeStart>0&&(h+=a.g.playRangeStart),isFinite(a.g.playRangeEnd)&&(h+=","+a.g.playRangeEnd));if(!a.H){v.A(2);break}return G(v,
a.H.destroy(),3);case 3:a.H=null;case 2:return Mj(d),d.src=h,k=rb(),k.Oa()=="TV"&&d.load(),d.preload!="none"&&!d.autoplay&&cf(c)&&k.Ha()==="WEBKIT"&&d.load(),a.m=wr,a.dispatchEvent(Qq("streaming")),l=function(){return new Promise(function(w){var z=new rf(w);a.j.D(d.textTracks,"change",function(){return z.ka(.5)});z.ka(.5)})},m=new Hg,Dl(d,HTMLMediaElement.HAVE_METADATA,a.j,function(){return O(function(w){if(w.g==1)return a.G.ready(),a.Fa&&cf(a.Fa)?G(w,l(),3):(m.resolve(),w.A(0));m.resolve();H(w)})}),
Dl(d,HTMLMediaElement.HAVE_CURRENT_DATA,a.j,function(){var w,z,y,A,E;return O(function(I){if(I.g==1)return G(I,l(),2);if(e)return I.return();Qr(a);w=Or(a);w.some(function(D){return D.mode==="showing"})&&(a.$=!0,a.u.setTextVisibility(!0));if(!(a.u instanceof gp))for(w.length&&(a.u.enableTextDisplayer?a.u.enableTextDisplayer():yb("Text displayer w/ enableTextDisplayer",'Text displayer should have a "enableTextDisplayer" method')),z=!1,y=u(w),A=y.next();!A.done;A=y.next())E=A.value,E.mode!=="disabled"&&
(z?(E.mode="disabled",$a("Found more than one enabled text track, disabling it",E)):(Rr(a,E),z=!0));Sr(a);H(I)})}),d.error?m.reject(Wq(a)):d.preload=="none"&&($a('With <video preload="none">, the browser will not load anything until play() is called. We are unable to measure load latency in a meaningful way, and we cannot provide track info yet. Please do not use preload="none" with Shaka Player.'),m.resolve()),a.j.Aa(d,"error",function(){m.reject(Wq(a))}),G(v,vf(a.g.streaming.loadTimeout,m),4);case 4:if((n=
a.W())&&(a.g.streaming.liveSync&&a.g.streaming.liveSync.enabled||a.g.streaming.liveSync.panicMode)||a.g.streaming.vodDynamicPlaybackRate)q=function(){return Lr(a)},a.j.D(d,"timeupdate",q);n||(r=function(){return Mr(a)},a.j.D(d,"timeupdate",r),Mr(a));a.C&&(a.C.onManifestUpdated(n),n&&(t=a.Ra().end,a.j.D(d,"progress",function(){var w=a.Ra().end;t!=w&&(a.C.onManifestUpdated(a.W()),t=w)})));a.Ua=!0;H(v)}})}function Qr(a){var b=a.g.preferredAudioLanguage;b!=""&&a.Ti(b,a.g.preferredAudioRole)}
function Sr(a){var b=a.g.preferredTextLanguage;b!=""&&a.oh(b,a.g.preferredTextRole,a.g.preferForcedSubs)}
function xr(a,b){if(b.kind=="metadata"){b.mode="hidden";a.j.D(b,"cuechange",function(){if(b.activeCues)for(var d=u(b.activeCues),e=d.next();!e.done;e=d.next())if(e=e.value,kr(a,e.startTime,e.endTime,e.type,e.value),a.C)a.C.onCueMetadataChange(e.value);if(b.cues){d=[];e=u(b.cues);for(var f=e.next(),g={};!f.done;g={Ec:void 0},f=e.next())g.Ec=f.value,g.Ec.type=="com.apple.quicktime.HLS"&&g.Ec.startTime!=null&&(f=d.find(function(h){return function(k){return k.startTime==h.Ec.startTime&&k.endTime==h.Ec.endTime}}(g)),
f||(f={startTime:g.Ec.startTime,endTime:g.Ec.endTime,values:[]},d.push(f)),f.values.push(g.Ec.value));d=u(d);for(e=d.next();!e.done;e=d.next())e=e.value,e.values.some(function(h){return h.key=="X-ASSET-URI"||h.key=="X-ASSET-LIST"})&&a.C&&(e.values.push({key:"CUE",description:"",data:e.startTime!=0||a.W()?"ONCE":"ONCE,PRE",mimeType:null,pictureType:null}),a.C.onHLSInterstitialMetadata(a,a.h,e))}});var c=(new rf(function(){var d=Tr(a);d=u(d);for(var e=d.next();!e.done;e=d.next())e.value.mode="hidden"})).Jb().ka(.5);
a.De.push(function(){c.stop()})}}function br(a,b,c){b=(new Map).set("startTime",b.startTime).set("endTime",b.endTime).set("metadataType",b.schemeIdUri).set("payload",b.payload);a.dispatchEvent(Qq(c,b))}function kr(a,b,c,d,e){a.za&&(b={schemeIdUri:d,startTime:b,endTime:c||Infinity,id:"",payload:e},b.id=JSON.stringify(b),km(a.za,b))}function yr(a,b){if(b&&b.kind=="chapters"){b.mode="hidden";var c=(new rf(function(){b.mode="hidden"})).Jb().ka(.5);a.De.push(function(){c.stop()})}}
p.Ok=function(){for(var a=this.ba;a.g;)a.release()};p.md=function(a){return new Fh(a)};
function Jq(a,b){function c(f){b()?b().dispatchEvent(f):a.dispatchEvent(f)}function d(f){b()?po(b(),!0,f):f()}b||(b=function(){return null});var e=new Ug(function(f,g,h,k,l){d(function(){a.o&&a.o.segmentDownloaded(f,g,h,k,l)})},function(f,g,h){g=(new Map).set("headers",f).set("request",g).set("requestType",h);c(Qq("downloadheadersreceived",g));d(function(){if(a.va){var k=a.va;if(k.h.enabled){var l=f["cmsd-static"];if(l)try{var m=new Map,n=l.split(",");for(l=0;l<n.length;l++){var q=n[l].split("=");
m.set(q[0],Dq(q[1]))}}catch(z){}if(m=f["cmsd-dynamic"]){a:{try{var r=new Map,t=m.split(";");for(m=1;m<t.length;m++){var v=t[m].split("=");r.set(v[0],Dq(v[1]))}var w=r;break a}catch(z){w=null;break a}w=void 0}w&&(k.g=w)}}}})},function(f,g){f=(new Map).set("request",f).set("response",g);c(Qq("downloadcompleted",f))},function(f,g,h,k){f=(new Map).set("request",f).set("error",g).set("httpResponseCode",h).set("aborted",k);c(Qq("downloadfailed",f))},function(f,g,h){d(function(){if(a.K){var k=a.K,l=h;l=
l===void 0?{}:l;if(k.g.enabled)if(g.method==="HEAD")eq(k,g,{});else switch(f){case 0:try{if(k.g.enabled){if(l.type){a:{switch(l.type){case 4:var m=k.u?Dp:Cp;break a;case 3:case 2:m=k.u?Fp:Ep;break a;case 5:m="s";break a}m=void 0}k.l=m}eq(k,g,{ot:Mp,su:!k.F})}}catch(q){ab("CMCD_MANIFEST_ERROR","Could not generate manifest CMCD data.",q)}break;case eh:try{if(k.g.enabled){var n=tq(k,l,g.uris[0]);n.ts=Date.now();k.m.has(g)&&k.m.delete(g);k.m.set(g,n.ts);eq(k,g,n)}}catch(q){ab("CMCD_SEGMENT_ERROR","Could not generate segment CMCD data.",
q)}break;case 2:case 5:case 6:eq(k,g,{ot:"k"});break;case 4:eq(k,g,{ot:"o"})}}})},function(f,g,h,k){(f=b()?b().m:a.I)&&f.banLocation&&f.banLocation(k)},function(f,g,h){if(g.data){var k=g.data.byteLength,l=b()?b().getStats():a.B;l&&(mo(l,k),f===0&&(l.wi=k));k=a.K;h=h===void 0?{}:h;if(Tp(k).length!==0)switch(f){case eh:try{var m=tq(k,h,g.uri);g.originalRequest&&g.originalRequest.timeToFirstByte!=null&&(m.ttfb=g.originalRequest.timeToFirstByte);g.timeMs!=null&&(m.ttlb=g.timeMs);var n=g.originalUri||
g.uri;if(n.includes("CMCD="))try{var q=new URL(n);q.searchParams.delete("CMCD");var r=q.toString()}catch(C){r=n}else r=n;m.url=r;k.m.has(g.originalRequest)?(m.ts=k.m.get(g.originalRequest),k.m.delete(g.originalRequest)):m.ts||(m.ts=Date.now());var t=Tp(k);if(t.length!==0){var v=k.g.version==Wp?Array.from(new Set([].concat(x(Xp),x(xq)))):iq;m.rc=g.status||0;var w=Vp(k,m,Up);g.headers&&g.headers["CMSD-Static"]&&(w.cmsds=btoa(g.headers["CMSD-Static"]));g.headers&&g.headers["CMSD-Dynamic"]&&(w.cmsdd=
btoa(g.headers["CMSD-Dynamic"]));for(var z=u(t),y=z.next();!y.done;y=z.next()){var A=y.value,E=Zp(A.includeKeys||[],v),I=gq(A);k.o[I]||(k.o[I]={request:1,response:1});w.sn=k.o[I].response++;var D=aq(w,E);dq(k,D,A,g)}}}catch(C){ab("CMCD_SEGMENT_ERROR","Could not generate response segment CMCD data.",C)}}}});e.configure(a.g.networking);return e}
function Er(a,b){return new Pl(a.h,a.i,a.g.streaming,b,function(){a.ac&&cm(a.ac,!a.G.Mh());a.l&&a.l.bd();a.R&&Ur(a,"seeking")},function(c){return a.dispatchEvent(c)})}
function Fr(a,b){var c=a.W()||typeof b==="number"&&b>0;b=new Ro(a.Ae,c);b.addEventListener("enter",function(f){lr(a,"timelineregionenter",f.region)});b.addEventListener("exit",function(f){lr(a,"timelineregionexit",f.region)});b.addEventListener("skip",function(f){var g=f.region;f.seeking||(lr(a,"timelineregionenter",g),lr(a,"timelineregionexit",g))});var d=new Ro(a.za,c);d.addEventListener("enter",function(f){br(a,f.region,"metadata")});c=new Ro(a.kb,c);c.addEventListener("enter",function(f){f=(new Map).set("detail",
f.region.emsg);a.dispatchEvent(Qq("emsg",f))});var e=new bm(a.h);e.g.add(b);e.g.add(d);e.g.add(c);a.ye&&e.g.add(a.ye);return e}function Nr(a,b){b=new Ro(a.za,b instanceof Date||b>0);b.addEventListener("enter",function(d){br(a,d.region,"metadata")});var c=new bm(a.h);c.g.add(b);return c}
function Gr(a,b,c){a.R=new ui;xi(a.R,wi);Vr(a);Zq(a);a.Ta=new rf(function(){Ur(a)});a.g.streaming.rebufferingGoal&&a.Ta.Ea(.25);a.j.D(b,"waiting",function(){return Ur(a,"waiting")});a.j.D(b,"canplaythrough",function(){return Ur(a,"canplaythrough")});a.j.D(b,"playing",function(){return Ur(a,"playing")});a.j.D(b,"seeked",function(){return Ur(a,"seeked")});a.j.D(b,"timeupdate",function(){return Ur(a,"timeupdate")});c&&(a.j.D(b,"progress",function(){return Ur(a,"progress")}),a.j.D(b,"stalled",function(){return Ur(a,
"stalled")}))}function Vr(a){var b=a.g.streaming.rebufferingGoal;a.R.j.set(vi,Math.min(.5,b/2)).set(wi,b)}
function Ur(a,b){if(a.g.streaming.rebufferingGoal){b=a.H?Ik(a.H):!1;b=a.ge()||b||a.G.ri();var c=Hj(a.h.buffered,a.h.currentTime),d=a.R,e=d.j.get(d.g);xi(d,b||c>=e&&c>0?vi:wi)&&Zq(a)}else if(b){c=a.R;d=a.h.currentTime;e=c.h;c.h=d;var f=void 0;switch(b){case "seeking":case "waiting":c.h=-1;f=wi;break;case "canplaythrough":case "playing":case "seeked":f=vi;break;case "timeupdate":e>=0&&d-e>.01&&(f=vi)}f!==void 0&&xi(c,f)&&Zq(a)}}function pr(a,b,c,d,e){return new wk(a,b,c,e,d)}
function Cr(a){return new Im(a.i,{nc:function(){return a.G?a.G.Qd():0},getBandwidthEstimate:function(){return a.o.getBandwidthEstimate()},Ob:function(){return a.Ob()},video:a.h,Z:a.H,vc:a.N,onError:function(b){return Xq(a,b)},onEvent:function(b){return a.dispatchEvent(b)},zd:function(b,c,d,e){var f=b.startTime,g=b.endTime,h=c.type;if(h!=Kc){if(a.G){a.G.Fi();var k=Pk(a.H,h);!a.W()&&a.h.paused&&!a.h.seeking&&k!=null&&k>0&&a.G.Qd()<k&&!Gq(a.G.Qd(),k,.001)&&a.G.$f(k)}Ur(a)}d=(new Map).set("start",f).set("end",
g).set("contentType",h).set("isMuxed",d).set("isDependency",e);a.dispatchEvent(Qq("segmentappended",d));a.o&&c.fastSwitching&&b.Xc&&b.je&&a.o.trySuggestStreams()},Fk:function(b,c){(c=c.xd)&&a.ye&&fm(a.ye,c,b)},Uh:function(b,c){var d=a.F;if(d.h.parseInbandPsshEnabled&&!d.H&&["audio","video"].includes(b)){b=new Dh(Wb(c));c=0;for(var e=u(b.data),f=e.next();!f.done;f=e.next())c+=f.value.length;if(c==0)d=Promise.resolve();else{c=new Uint8Array(c);e=0;b=u(b.data);for(f=b.next();!f.done;f=b.next())f=f.value,
c.set(f,e),e+=f.length;Yh(d,"cenc",c);d=d.m}}else d=Promise.resolve();return d},disableStream:function(b,c){return a.disableStream(b,c)},hl:function(b,c){return a.g.abr.enabled&&c.fastSwitching&&b.Xc&&b.je?!1:!0}})}
p.configure=function(a,b){var c=this.getConfiguration();arguments.length==2&&typeof a=="string"&&(a=Bn(a,b));"preferredVariantRole"in a&&(yb("preferredVariantRole configuration","Please Use preferredAudioRole instead."),a.preferredAudioRole=a.preferredVariantRole,delete a.preferredVariantRole);a.streaming&&"forceTransmuxTS"in a.streaming&&(yb("streaming.forceTransmuxTS configuration","Please Use mediaSource.forceTransmux instead."),a.mediaSource=a.mediaSource||{},a.mediaSource.mediaSource=a.streaming.forceTransmuxTS,
delete a.streaming.forceTransmuxTS);a.streaming&&"forceTransmux"in a.streaming&&(yb("streaming.forceTransmux configuration","Please Use mediaSource.forceTransmux instead."),a.mediaSource=a.mediaSource||{},a.mediaSource.mediaSource=a.streaming.forceTransmux,delete a.streaming.forceTransmux);if(a.streaming&&"useNativeHlsOnSafari"in a.streaming){yb("streaming.useNativeHlsOnSafari configuration","Please Use streaming.useNativeHlsForFairPlay or streaming.preferNativeHls instead.");var d=rb();a.streaming.preferNativeHls=
a.streaming.useNativeHlsOnSafari&&d.Ha()==="WEBKIT";delete a.streaming.useNativeHlsOnSafari}a.streaming&&typeof a.streaming.liveSync=="boolean"&&(yb("streaming.liveSync","Please Use streaming.liveSync.enabled instead."),d=a.streaming.liveSync,a.streaming.liveSync={},a.streaming.liveSync.enabled=d);if(a.streaming&&!(a.streaming.liveSync&&"targetLatency"in a.streaming.liveSync)&&("liveSyncMinLatency"in a.streaming||"liveSyncMaxLatency"in a.streaming)){d=a.streaming.liveSyncMinLatency||0;var e=Math.abs((a.streaming.liveSyncMaxLatency||
1)-d)/2;a.streaming.liveSync=a.streaming.liveSync||{};a.streaming.liveSync.targetLatency=d+e;a.streaming.liveSync.targetLatencyTolerance=e}a.streaming&&"liveSyncMaxLatency"in a.streaming&&(yb("streaming.liveSyncMaxLatency","Please Use streaming.liveSync.targetLatency and streaming.liveSync.targetLatencyTolerance instead. Or, set the values in your DASH manifest"),delete a.streaming.liveSyncMaxLatency);a.streaming&&"liveSyncMinLatency"in a.streaming&&(yb("streaming.liveSyncMinLatency","Please Use streaming.liveSync.targetLatency and streaming.liveSync.targetLatencyTolerance instead. Or, set the values in your DASH manifest"),
delete a.streaming.liveSyncMinLatency);a.streaming&&"liveSyncTargetLatency"in a.streaming&&(yb("streaming.liveSyncTargetLatency","Please Use streaming.liveSync.targetLatency instead."),a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.targetLatency=a.streaming.liveSyncTargetLatency,delete a.streaming.liveSyncTargetLatency);a.streaming&&"liveSyncTargetLatencyTolerance"in a.streaming&&(yb("streaming.liveSyncTargetLatencyTolerance","Please Use streaming.liveSync.targetLatencyTolerance instead."),
a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.targetLatencyTolerance=a.streaming.liveSyncTargetLatencyTolerance,delete a.streaming.liveSyncTargetLatencyTolerance);a.streaming&&"liveSyncPlaybackRate"in a.streaming&&(yb("streaming.liveSyncPlaybackRate","Please Use streaming.liveSync.maxPlaybackRate instead."),a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.maxPlaybackRate=a.streaming.liveSyncPlaybackRate,delete a.streaming.liveSyncPlaybackRate);a.streaming&&"liveSyncMinPlaybackRate"in
a.streaming&&(yb("streaming.liveSyncMinPlaybackRate","Please Use streaming.liveSync.minPlaybackRate instead."),a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.minPlaybackRate=a.streaming.liveSyncMinPlaybackRate,delete a.streaming.liveSyncMinPlaybackRate);a.streaming&&"liveSyncPanicMode"in a.streaming&&(yb("streaming.liveSyncPanicMode","Please Use streaming.liveSync.panicMode instead."),a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.panicMode=a.streaming.liveSyncPanicMode,
delete a.streaming.liveSyncPanicMode);a.streaming&&"liveSyncPanicThreshold"in a.streaming&&(yb("streaming.liveSyncPanicThreshold","Please Use streaming.liveSync.panicThreshold instead."),a.streaming.liveSync=a.streaming.liveSync||{},a.streaming.liveSync.panicThreshold=a.streaming.liveSyncPanicThreshold,delete a.streaming.liveSyncPanicThreshold);if(a.mediaSource&&"sourceBufferExtraFeatures"in a.mediaSource){yb("mediaSource.sourceBufferExtraFeatures configuration","Please Use mediaSource.addExtraFeaturesToSourceBuffer() instead.");
var f=a.mediaSource.sourceBufferExtraFeatures;a.mediaSource.addExtraFeaturesToSourceBuffer=function(){return f};delete a.mediaSource.sourceBufferExtraFeatures}a.manifest&&a.manifest.hls&&"useSafariBehaviorForLive"in a.manifest.hls&&(yb("manifest.hls.useSafariBehaviorForLive configuration","Please Use liveSync config to keep on live Edge instead."),delete a.manifest.hls.useSafariBehaviorForLive);a.streaming&&"parsePrftBox"in a.streaming&&(yb("streaming.parsePrftBox configuration","Now fired without needing a configuration."),
delete a.streaming.parsePrftBox);a.manifest&&a.manifest.dash&&"enableAudioGroups"in a.manifest.dash&&(yb("manifest.dash.enableAudioGroups configuration","Please Use manifest.enableAudioGroups instead."),a.manifest.enableAudioGroups=a.manifest.dash.enableAudioGroups,delete a.manifest.dash.enableAudioGroups);a.streaming&&"dispatchAllEmsgBoxes"in a.streaming&&(yb("streaming.dispatchAllEmsgBoxes configuration","Please Use mediaSource.dispatchAllEmsgBoxes instead."),a.mediaSource=a.mediaSource||{},a.mediaSource.dispatchAllEmsgBoxes=
a.streaming.dispatchAllEmsgBoxes,delete a.streaming.dispatchAllEmsgBoxes);a.streaming&&"autoLowLatencyMode"in a.streaming&&(yb("streaming.autoLowLatencyMode configuration","Please Use streaming.lowLatencyMode instead."),a.streaming.lowLatencyMode=a.streaming.autoLowLatencyMode,delete a.streaming.autoLowLatencyMode);a.manifest&&a.manifest.dash&&"ignoreSupplementalCodecs"in a.manifest.dash&&(yb("manifest.dash.ignoreSupplementalCodecs configuration","Please Use manifest.ignoreSupplementalCodecs instead."),
a.manifest.ignoreSupplementalCodecs=a.manifest.dash.ignoreSupplementalCodecs,delete a.manifest.dash.ignoreSupplementalCodecs);a.manifest&&a.manifest.hls&&"ignoreSupplementalCodecs"in a.manifest.hls&&(yb("manifest.hls.ignoreSupplementalCodecs configuration","Please Use manifest.ignoreSupplementalCodecs instead."),a.manifest.ignoreSupplementalCodecs=a.manifest.hls.ignoreSupplementalCodecs,delete a.manifest.hls.ignoreSupplementalCodecs);a.manifest&&a.manifest.dash&&"updatePeriod"in a.manifest.dash&&
(yb("manifest.dash.updatePeriod configuration","Please Use manifest.updatePeriod instead."),a.manifest.updatePeriod=a.manifest.dash.updatePeriod,delete a.manifest.dash.updatePeriod);a.manifest&&a.manifest.hls&&"updatePeriod"in a.manifest.hls&&(yb("manifest.hls.updatePeriod configuration","Please Use manifest.updatePeriod instead."),a.manifest.updatePeriod=a.manifest.hls.updatePeriod,delete a.manifest.hls.updatePeriod);a.manifest&&a.manifest.dash&&"ignoreDrmInfo"in a.manifest.dash&&(yb("manifest.dash.ignoreDrmInfo configuration",
"Please Use manifest.ignoreDrmInfo instead."),a.manifest.ignoreDrmInfo=a.manifest.dash.ignoreDrmInfo,delete a.manifest.dash.ignoreDrmInfo);if(a.drm&&a.drm.advanced){d=!1;for(var g in a.drm.advanced){var h=a.drm.advanced[g];e=h.videoRobustness;h=h.audioRobustness;"videoRobustness"in a.drm.advanced[g]&&!Array.isArray(a.drm.advanced[g].videoRobustness)&&(a.drm.advanced[g].videoRobustness=[e],d=!0);"audioRobustness"in a.drm.advanced[g]&&!Array.isArray(a.drm.advanced[g].audioRobustness)&&(a.drm.advanced[g].audioRobustness=
[h],d=!0)}d&&yb("AdvancedDrmConfiguration's videoRobustness and audioRobustness","These properties are no longer strings but array of strings, please update your usage of these properties.")}a.streaming&&"forceHTTP"in a.streaming&&(yb("streaming.forceHTTP configuration","Please Use networking.forceHTTP instead."),a.networking=a.networking||{},a.networking.forceHTTP=a.streaming.forceHTTP,delete a.streaming.forceHTTP);a.streaming&&"forceHTTPS"in a.streaming&&(yb("streaming.forceHTTPS configuration",
"Please Use networking.forceHTTP instead."),a.networking=a.networking||{},a.networking.forceHTTPS=a.streaming.forceHTTPS,delete a.streaming.forceHTTPS);a.streaming&&"minBytesForProgressEvents"in a.streaming&&(yb("streaming.minBytesForProgressEvents configuration","Please Use networking.minBytesForProgressEvents instead."),a.networking=a.networking||{},a.networking.minBytesForProgressEvents=a.streaming.minBytesForProgressEvents,delete a.streaming.minBytesForProgressEvents);g=bo(this.g,a,Iq(this));
Wr(this,c);return g};p.yj=function(a){this.dg=a};
function Wr(a,b){a.Ee=new yi(a.g,a.ya,a.F);if(a.I){var c=wd(a.g.manifest);a.h&&a.h.nodeName==="AUDIO"&&(c.disableVideo=!0);a.I.configure(c)}a.F&&a.F.configure(a.g.drm);if(a.l){a.l.configure(a.g.streaming);try{a.m!=Rq&&Ai(a.Ee,a.i)&&vr(a)}catch(e){Xq(a,e)}a.o&&zr(a);c=a.l.o;!c||c.allowedByApplication&&c.allowedByKeySystem||Nq(a)}a.N&&a.N.configure(a.g.networking);a.H&&(a.H.configure(a.g.mediaSource),a.H.Fa=a.g.manifest.segmentRelativeVttTiming);a.u&&or(a);a.o&&(a.o.configure(a.g.abr),a.g.abr.enabled?
a.o.enable():a.o.disable(),Kr(a));a.R&&Vr(a);a.Ta&&(a.g.streaming.rebufferingGoal?a.Ta.Ea(.25):a.Ta.stop());a.i&&Ar(a.i.presentationTimeline,a.g.playRangeStart,a.g.playRangeEnd);a.C&&a.C.configure(a.g.ads);a.K&&a.K.configure(a.g.cmcd);a.va&&a.va.configure(a.g.cmsd);a.Da&&a.Da.configure(a.g.queue);if(a.m==sr&&a.J.getConfiguration){c=a.J.getConfiguration();var d=!1;b.preferredVideoHdrLevel!=a.g.preferredVideoHdrLevel&&c.hdrLevel!=a.g.preferredVideoHdrLevel&&(c.hdrLevel=a.g.preferredVideoHdrLevel,d=
!0);b.preferredVideoLayout!=a.g.preferredVideoLayout&&c.videoLayout!=a.g.preferredVideoLayout&&(c.videoLayout=a.g.preferredVideoLayout,d=!0);b.preferSpatialAudio!=a.g.preferSpatialAudio&&c.spatialAudio!=a.g.preferSpatialAudio&&(c.spatialAudio=a.g.preferSpatialAudio,d=!0);b.preferredVideoRole!=a.g.preferredVideoRole&&c.videoRole!=a.g.preferredVideoRole&&(c.videoRole=a.g.preferredVideoRole,d=!0);d&&(a.J.configure(c),Nq(a))}}p.getConfiguration=function(){var a=Iq(this);bo(a,this.g,Iq(this));return a};
p.Ij=function(){return this.dg};p.ki=function(){var a=Iq(this);bo(a,this.g,Iq(this));return Dn(this.g,Iq(this))};p.ei=function(){if(this.h){var a=this.h.buffered.length;a=a?this.h.buffered.end(a-1):0;var b=this.getConfiguration().streaming.bufferingGoal;b=Math.min(this.h.currentTime+b,this.Ra().end);if(a>=b)return 1;if(!(a<=this.h.currentTime)&&a<b)return(a-this.h.currentTime)/(b-this.h.currentTime)}return 0};
p.Oi=function(){var a=this.getConfiguration(),b;for(b in this.g)delete this.g[b];bo(this.g,Iq(this),Iq(this));Wr(this,a)};p.$d=function(){return this.m};p.ii=function(){return this.i?this.i.type:null};p.bf=function(){return this.h};p.Yb=function(){return this.N};p.rd=function(){return this.X};p.di=function(){return this.C?this.C:null};p.mi=function(){return this.Da?this.Da:null};
p.W=function(){return this.i&&!this.xa()?this.i.presentationTimeline.W():this.h&&(this.h.src||this.xa())?this.h.duration==Infinity:!1};p.Vc=function(){return this.i?this.i.presentationTimeline.Vc():!1};p.lk=function(){if(this.i&&!this.xa()){var a=this.i.variants;return a.length?!a[0].video:!1}return this.h&&(this.h.src||this.xa())?this.h.videoTracks?this.h.videoTracks.length==0:this.h.videoHeight==0:!1};
p.ti=function(){if(this.i&&!this.xa()){var a=this.i.variants;if(!a.length)return!1;a=a[0];return a.audio||!a.video?!1:!a.video.codecs.includes(",")}return this.h&&(this.h.src||this.xa())&&this.h.audioTracks?this.h.audioTracks.length==0:!1};
p.Ra=function(){if(this.i&&!this.xa()){if(!this.Ua&&this.i.type=="HLS")return{start:0,end:0};var a=this.i.presentationTimeline;return{start:a.Zb(),end:a.Gb()}}if(this.h&&(this.h.src||this.xa())&&(a=this.h.seekable)&&a.length){var b=this.g?this.g.playRangeStart:0;b=Math.max(a.start(0),b);var c=this.g?this.g.playRangeEnd:Infinity;a=Math.min(a.end(a.length-1),c);return{start:b,end:a}}return{start:0,end:0}};p.ik=function(){this.W()&&(this.h.currentTime=this.Ra().end)};p.nk=function(){return this.Ua};
p.keySystem=function(){var a=this.drmInfo();return a?a.keySystem:""};p.drmInfo=function(){return this.F?this.F.g:null};p.Zd=function(){return this.F?this.F.Zd():Infinity};p.Kg=function(){return this.F?this.F.Kg():[]};p.$e=function(){return this.F?this.F.$e():{}};p.Rg=function(){return this.R?this.R.g==wi:!!this.X};p.Ob=function(){return this.h?this.M?this.M.i:1:0};p.Kh=function(a){this.m==sr&&this.l&&Um(this.l,a)};
p.xe=function(a,b){b=b===void 0?!0:b;a==0?$a("A trick play rate of 0 is unsupported!"):(this.M.set(a),this.m==sr&&(this.o.playbackRateChanged(a),this.Kh(b&&a!=1)),tr(this,a))};p.Sd=function(){var a=this.M.Tc();this.m==wr&&this.M.set(a);this.m==sr&&(this.M.set(a),this.o.playbackRateChanged(a),this.Kh(!1));this.dc.Qa()};
p.qc=function(){if(this.i&&!this.xa()){for(var a=this.l?this.l.o:null,b=[],c=0,d=u(this.i.variants),e=d.next();!e.done;e=d.next())if(e=e.value,rg(e)){var f=jg(e);f.active=e==a;f.active||c==1||a==null||e.video!=a.video||e.audio!=a.audio||(f.active=!0);f.active&&c++;b.push(f)}return b}if(this.h&&this.h.audioTracks){var g=Xr(this);a=Array.from(this.h.audioTracks);return a.length?a.map(function(h){return qg(h,g)}):g?[qg(null,g)]:[]}return[]};
p.Lc=function(){if(this.i){if(this.xa())return[];for(var a=this.l?this.l.B:null,b=[],c=u(this.i.textStreams),d=c.next();!d.done;d=c.next()){d=d.value;var e=kg(d);e.active=d==a;b.push(e)}return b}return this.h&&this.h.src&&this.h.textTracks?Or(this).map(function(f){return pg(f)}):[]};p.Nj=function(){var a=this.Ke;this.i&&(a=this.i.imageStreams);return a.map(function(b){return lg(b)})};
p.Bj=function(a){var b=this,c,d;return O(function(e){if(e.g==1)return G(e,Yr(b,a),2);c=e.h;if(!c)return e.return(null);d=[];c.segmentIndex.Fb(function(f){var g=Zr(f.tilesLayout||c.tilesLayout);if(g)for(var h=g.rows*g.columns,k=f.j-f.startTime,l=0;l<h;l++){var m=$r(f,c,f.startTime+k*l/h,g);d.push(m)}});c.closeSegmentIndex&&c.closeSegmentIndex();return e.return(d)})};function Zr(a){return a?(a=/(\d+)x(\d+)/.exec(a))?{columns:parseInt(a[1],10),rows:parseInt(a[2],10)}:null:null}
p.ck=function(a,b){var c=this,d,e,f,g,h,k;return O(function(l){if(l.g==1)return G(l,Yr(c,a),2);d=l.h;if(!d)return l.return(null);d.closeSegmentIndex&&(c.yc.has(d)||(e=new rf(function(){d.closeSegmentIndex();c.yc.delete(d)}),c.yc.set(d,e)),f=c.yc.get(d),f.ka(5));g=d.segmentIndex.find(b);if(g==null)return l.return(null);h=d.segmentIndex.get(g);return(k=Zr(h.tilesLayout||d.tilesLayout))?l.return($r(h,d,b,k)):l.return(null)})};
function Yr(a,b){var c,d;return O(function(e){if(e.g==1){if(a.m!=sr&&a.m!=wr)return e.return(null);c=a.Ke;a.i&&(c=a.i.imageStreams);d=c[0];if(!d)return e.return(null);b!=null&&(d=c.find(function(f){return f.id==b}));return d?d.segmentIndex?e.A(2):G(e,d.createSegmentIndex(),2):e.return(null)}return e.return(d)})}
function $r(a,b,c,d){var e=b.width||0,f=b.height||0,g=e/d.columns,h=f/d.rows,k=d.columns*d.rows,l=a.j-a.startTime;l=a.B||l/k;var m=a.startTime,n=0,q=0;k>1&&(q=Math.floor((c-a.startTime)/l),m=a.startTime+q*l,n=q%d.columns*g,q=Math.floor(q/d.columns)*h);d=!1;if(c=a.thumbnailSprite)d=!0,h=c.height,n=c.positionX,q=c.positionY,g=c.width;return{segment:a,imageHeight:f,imageWidth:e,height:h,positionX:n,positionY:q,startTime:m,duration:l,uris:a.P(),startByte:a.Jc(),endByte:a.Hc(),width:g,sprite:d,mimeType:a.mimeType||
b.mimeType,codecs:a.codecs||b.codecs}}
p.ph=function(a){function b(){var d=c.i.textStreams.find(function(e){return e.id==a.id});d&&d!=c.l.B&&(ho(c.B.h,d,!1),Xm(c.l,d),ur(c),Jr(c),c.Kd=d.language)}var c=this;if(this.i&&this.G&&(b(),!this.xa()))return;(function(){if(c.h&&c.h.textTracks){var d=Or(c),e=d.find(function(h){return ng(h)===a.id});if(e){if(c.u instanceof gp){d=u(d);for(var f=d.next();!f.done;f=d.next()){f=f.value;var g=f===e?c.$?"showing":"hidden":"disabled";f.mode!==g&&(f.mode=g)}}else d=d.find(function(h){return h.mode!=="disabled"}),
d!==e&&(d&&(d.mode="disabled",c.j.Ma(d,"cuechange"),c.u.remove(0,Infinity)),e&&Rr(c,e));ur(c);Jr(c)}}})()};
function Rr(a,b){a.j.D(b,"cuechange",function(){a.u.remove(0,Math.max(0,a.h.currentTime-a.g.streaming.bufferBehind));var c={periodStart:0,segmentStart:0,segmentEnd:a.h.duration,vttOffset:0},d=[],e=Array.from(b.activeCues||[]);e=u(e);for(var f=e.next();!f.done;f=e.next()){f=f.value;if(f.endTime===Infinity||f.endTime<f.startTime)f=null;else{var g=new ge(f.startTime,f.endTime,f.text);g.line=typeof f.line==="number"?f.line:null;f.lineAlign&&(g.lineAlign=f.lineAlign);g.lineInterpretation=f.snapToLines?
le:1;g.position=typeof f.position==="number"?f.position:null;f.positionAlign&&(g.positionAlign=f.positionAlign);g.size=f.size;g.textAlign=f.align;f.vertical==="lr"?g.writingMode="vertical-lr":f.vertical==="rl"&&(g.writingMode="vertical-rl");f.region&&(g.region.id=f.region.id,g.region.height=f.region.lines,g.region.heightUnits=2,g.region.regionAnchorX=f.region.regionAnchorX,g.region.regionAnchorY=f.region.regionAnchorY,g.region.scroll=f.region.scroll,g.region.viewportAnchorX=f.region.viewportAnchorX,
g.region.viewportAnchorY=f.region.viewportAnchorY,g.region.viewportAnchorUnits=id,g.region.width=f.region.width,g.region.widthUnits=id);se(g);f=g}f&&((g=a.g.mediaSource.modifyCueCallback)&&g(f,null,c),d.push(f))}a.u.append(d)});b.mode=document.pictureInPictureElement?"showing":"hidden"}
p.Jf=function(a,b,c){function d(){var f=e.i.variants.find(function(h){return h.id==a.id});if(f&&rg(f)){var g=e.l.o;e.g.abr.enabled&&(g.video!=f.video||g.audio&&f.audio&&g.audio.language==f.audio.language&&g.audio.channelsCount==f.audio.channelsCount&&g.audio.label==f.audio.label)&&$a("Changing tracks while abr manager is enabled will likely result in the selected track being overridden. Consider disabling abr before calling selectVariantTrack().");e.xa()?Br(e,f,!1,!1,0):Br(e,f,!1,b||!1,c||0);e.J.configure({language:f.language,
role:f.audio&&f.audio.roles&&f.audio.roles[0]||"",videoRole:f.video&&f.video.roles&&f.video.roles[0]||"",channelCount:f.audio&&f.audio.channelsCount?f.audio.channelsCount:0,hdrLevel:f.video&&f.video.hdr?f.video.hdr:"",spatialAudio:f.audio&&f.audio.spatialAudio?f.audio.spatialAudio:!1,videoLayout:f.video&&f.video.videoLayout?f.video.videoLayout:"",audioLabel:f.audio&&f.audio.label?f.audio.label:"",videoLabel:f.video&&f.video.label?f.video.label:"",codecSwitchingStrategy:e.g.mediaSource.codecSwitchingStrategy,
audioCodec:f.audio&&f.audio.codecs?f.audio.codecs:"",activeAudioCodec:g.audio&&g.audio.codecs?g.audio.codecs:"",activeAudioChannelCount:g.audio&&g.audio.channelsCount?g.audio.channelsCount:0,preferredAudioCodecs:e.g.preferredAudioCodecs,preferredAudioChannelCount:e.g.preferredAudioChannelCount});zr(e)}}var e=this;b=b===void 0?!1:b;c=c===void 0?0:c;if(this.i&&this.G&&(d(),!this.xa()))return;(function(){if(a.originalAudioId&&e.h&&e.h.audioTracks){var f=Array.from(e.h.audioTracks);f=u(f);for(var g=f.next();!g.done;g=
f.next())if(g=g.value,ng(g)==a.id){as(e,g);break}}})()};
p.Wk=function(a,b){function c(){var e=d.J.getConfiguration();e.audioCodec=a.codecs||"";e.audioLabel=a.label||"";e.channelCount=a.channelsCount||0;e.language=a.language;e.role=a.roles[0]||"";e.spatialAudio=a.spatialAudio;var f=d.l.o;if(f=f&&f.audio)e.activeAudioCodec=f.codecs||"",e.activeAudioChannelCount=f.channelsCount||0;d.J.configure(e);Nq(d,!0,b,!1,!1)}var d=this;b=b===void 0?0:b;if(this.i&&this.G&&(c(),!this.xa()))return;(function(){if(d.h&&d.h.audioTracks){var e=yf(a.language),f=Array.from(d.h.audioTracks),
g=null;f=u(f);for(var h=f.next();!h.done;h=f.next()){h=h.value;var k=h.language||"und";if(h.label==a.label&&yf(k)==e&&h.kind==a.roles[0]){g=h;break}}g&&as(d,g)}})()};
p.getAudioTracks=function(){if(this.i&&!this.xa()){var a=this.qc();if(!a.length)return[];var b=a.find(function(f){return f.active});if(!b)return[];var c=a;this.m!=sr||this.xa()||(c=a.filter(function(f){return f.originalVideoId===b.originalVideoId&&(f.audioCodec||Te.includes(f.audioMimeType||""))}));if(!c.length)return[];a=new Map;c=u(c);for(var d=c.next();!d.done;d=c.next()){d=d.value;var e=d.originalAudioId;e||d.audioId==null||(e=String(d.audioId));!e&&d.codecs.includes(",")&&d.audioCodec&&(e="muxed-in-video");
e&&(e+=[d.language,d.label,d.channelsCount,d.spatialAudio,d.audioCodec||""].join("_"),a.set(e,{active:d.active,language:d.language,label:d.label,mimeType:d.audioMimeType,codecs:d.audioCodec,primary:d.primary,roles:d.audioRoles||[],accessibilityPurpose:d.accessibilityPurpose,channelsCount:d.channelsCount,audioSamplingRate:d.audioSamplingRate,spatialAudio:d.spatialAudio,originalLanguage:d.originalLanguage}))}return Array.from(a.values())}return this.h&&this.h.audioTracks?Array.from(this.h.audioTracks).map(function(f){var g=
f.language;g={active:f.enabled,language:yf(g||"und"),label:f.label,mimeType:null,codecs:null,primary:f.kind=="main",roles:[],accessibilityPurpose:null,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,originalLanguage:g};f.kind&&(f.kind=="description"&&(g.accessibilityPurpose="visually impaired"),g.roles.push(f.kind));f.configuration&&(f.configuration.codec&&(g.codecs=f.configuration.codec),f.configuration.sampleRate&&(g.audioSamplingRate=f.configuration.sampleRate),f.configuration.numberOfChannels&&
(g.channelsCount=f.configuration.numberOfChannels));return g}):[]};
p.Yk=function(a,b,c){b=b===void 0?!1:b;c=c===void 0?0:c;var d=this.qc();if(d.length){var e=d.find(function(g){return g.active});if(e){d=d.filter(function(g){return(g.videoBandwidth||g.bandwidth)==a.bandwidth&&g.width==a.width&&g.height==a.height&&g.frameRate==a.frameRate&&g.pixelAspectRatio==a.pixelAspectRatio&&g.hdr==a.hdr&&g.colorGamut==a.colorGamut&&g.videoLayout==a.videoLayout&&g.videoMimeType==a.mimeType&&g.videoCodec==a.codecs&&ib(g.videoRoles,a.roles)&&g.videoLabel==a.label});var f;d.length==
1?f=d[0]:f=d.find(function(g){return g.audioId===e.audioId});f||(f=d.find(function(g){return g.language==e.language&&g.label===e.label&&g.channelsCount===e.channelsCount&&g.spatialAudio===e.spatialAudio&&g.audioMimeType===e.audioMimeType&&Ye(g.audioCodec||"")===Ye(e.audioCodec||"")&&ib(g.audioRoles,e.audioRoles)}));f&&!f.active&&this.Jf(f,b,c)}}};
p.getVideoTracks=function(){if(this.m==wr||this.xa())return[];var a=this.qc();if(!a.length)return[];var b=a.find(function(f){return f.active});if(!b)return[];var c=a;this.ti()||(c=a.filter(function(f){return f.videoCodec&&f.audioGroupId===b.audioGroupId&&f.originalAudioId===b.originalAudioId?f.audioId===b.audioId?!0:f.language===b.language&&f.label===b.label&&f.channelsCount===b.channelsCount&&f.spatialAudio===b.spatialAudio&&f.audioMimeType===b.audioMimeType&&Ye(f.audioCodec||"")===Ye(b.audioCodec||
"")&&ib(f.audioRoles,b.audioRoles):!1}));if(!c.length)return[];a=new Map;c=u(c);for(var d=c.next();!d.done;d=c.next()){d=d.value;var e=d.originalVideoId;e||d.videoId==null||(e=String(d.videoId));e&&a.set(e,{active:d.active,bandwidth:d.videoBandwidth||d.bandwidth,width:d.width,height:d.height,frameRate:d.frameRate,pixelAspectRatio:d.pixelAspectRatio,hdr:d.hdr,colorGamut:d.colorGamut,videoLayout:d.videoLayout,mimeType:d.videoMimeType,codecs:d.videoCodec,roles:d.videoRoles||[],label:d.videoLabel})}return Array.from(a.values())};
p.Dj=function(){return bs(this.qc())};p.$j=function(){return bs(this.Lc())};p.Cj=function(){return Array.from(cs(this.qc()))};p.Zj=function(){return Array.from(cs(this.Lc()))};
p.Ti=function(a,b,c,d,e,f,g){function h(){function l(t,v){return t.video||v.video?t.video&&v.video?Math.abs((t.video.height||0)-(v.video.height||0))+Math.abs((t.video.width||0)-(v.video.width||0)):Infinity:0}var m=k.l.o;k.J=k.g.adaptationSetCriteriaFactory();k.J.configure({language:a,role:b||"",videoRole:m.video&&m.video.roles&&m.video.roles[0]||"",channelCount:c||0,hdrLevel:"",spatialAudio:f||!1,videoLayout:"",audioLabel:g||"",videoLabel:"",codecSwitchingStrategy:k.g.mediaSource.codecSwitchingStrategy,
audioCodec:e||"",activeAudioCodec:m.audio&&m.audio.codecs?m.audio.codecs:"",activeAudioChannelCount:m.audio&&m.audio.channelsCount?m.audio.channelsCount:0,preferredAudioCodecs:k.g.preferredAudioCodecs,preferredAudioChannelCount:k.g.preferredAudioChannelCount});var n=k.J.create(k.i.variants),q=null;n=u(n.values());for(var r=n.next();!r.done;r=n.next())r=r.value,rg(r)&&(!q||l(q,m)>l(r,m))&&(q=r);q!=m&&(q?(m=jg(q),k.Jf(m,!0,d||0)):Nq(k))}var k=this;c=c===void 0?0:c;d=d===void 0?0:d;e=e===void 0?"":e;
f=f===void 0?!1:f;g=g===void 0?"":g;if(this.i&&this.G&&(h(),!this.xa()))return;(function(){if(k.h&&k.h.audioTracks){var l=tg(k.qc(),a,b||"",!1)[0];l&&k.Jf(l)}})()};p.oh=function(a,b,c){function d(){e.Kd=a;e.Od=b||"";e.Nd=c||!1;var f=tg(e.i.textStreams,e.Kd,e.Od,e.Nd)[0]||null;f&&f!=e.l.B&&(ho(e.B.h,f,!1),e.g.streaming.alwaysStreamText||e.Sg())&&(Xm(e.l,f),ur(e),Jr(e))}var e=this;c=c===void 0?!1:c;if(this.i&&this.G&&(d(),!this.xa()))return;(function(){var f=tg(e.Lc(),a,b||"",c||!1)[0];f&&e.ph(f)})()};
p.Xk=function(a,b,c){function d(){for(var f=null,g=u(e.i.variants),h=g.next();!h.done;h=g.next())if(h=h.value,h.audio.label==a){f=h;break}f!=null&&(e.J=e.g.adaptationSetCriteriaFactory(),e.J.configure({language:f.language,role:"",videoRole:"",channelCount:0,hdrLevel:"",spatialAudio:!1,videoLayout:"",videoLabel:"",audioLabel:a,codecSwitchingStrategy:e.g.mediaSource.codecSwitchingStrategy,audioCodec:"",activeAudioCodec:"",activeAudioChannelCount:0,preferredAudioCodecs:e.g.preferredAudioCodecs,preferredAudioChannelCount:e.g.preferredAudioChannelCount}),
Nq(e,b,c))}var e=this;b=b===void 0?!0:b;c=c===void 0?0:c;if(this.i&&this.G&&(d(),!this.xa()))return;(function(){if(e.h&&e.h.audioTracks){var f=Array.from(e.h.audioTracks),g=null;f=u(f);for(var h=f.next();!h.done;h=f.next())h=h.value,h.label==a&&(g=h);g&&as(e,g)}})()};p.Sg=function(){var a=this.$;return this.u?this.u.isTextVisible():a};p.Hj=function(){return this.ob.map(function(a){return kg(a)})};
p.Fj=function(a){yb("getChapters","Please use an getChaptersAsync.");if(!this.ob.length)return[];var b=yf(a);a=this.ob.filter(function(f){return yf(f.language)==b});if(!a.length)return[];var c=[],d=new Set;a=u(a);for(var e=a.next();!e.done;e=a.next())e=e.value,e.segmentIndex&&e.segmentIndex.Fb(function(f){var g=f.P()[0],h=f.startTime+"-"+f.endTime+"-"+g;f={id:h,title:g,startTime:f.startTime,endTime:f.endTime};d.has(h)||(c.push(f),d.add(h))});return c};
p.Gj=function(a){var b=this,c,d,e,f,g,h,k;return O(function(l){switch(l.g){case 1:if(!b.ob.length)return l.return([]);c=yf(a);d=b.ob.filter(function(m){return yf(m.language)==c});if(!d.length)return l.return([]);e=[];f=new Set;g=u(d);h=g.next();case 2:if(h.done){l.A(4);break}k=h.value;if(k.segmentIndex){l.A(5);break}return G(l,k.createSegmentIndex(),5);case 5:k.segmentIndex.Fb(function(m){var n=m.P()[0],q=m.startTime+"-"+m.endTime+"-"+n;m={id:q,title:n,startTime:m.startTime,endTime:m.endTime};f.has(q)||
(e.push(m),f.add(q))});h=g.next();l.A(2);break;case 4:return l.return(e)}})};function Or(a){return Array.from(a.h.textTracks).filter(function(b){return b.kind!="metadata"&&b.kind!="chapters"&&b.label!="Shaka Player TextTrack"})}function Pr(a){return Array.from(a.h.textTracks).find(function(b){return b.label=="Shaka Player TextTrack"})}function Tr(a){return Array.from(a.h.textTracks).filter(function(b){return b.kind=="metadata"})}
p.wh=function(a){a=!!a;this.$!=a&&(this.$=a,this.m==sr?(this.u.setTextVisibility(a),this.g.streaming.alwaysStreamText||(a?this.l.B||(a=tg(this.i.textStreams,this.Kd,this.Od,this.Nd),a.length>0&&(Xm(this.l,a[0]),ur(this),Jr(this))):Tm(this.l))):this.h&&this.h.src&&this.h.textTracks&&this.u.setTextVisibility(a),Ir(this))};
p.Tj=function(){if(this.G)var a=this.G.Qd();else{if(this.O==null)return new Date;if(this.O instanceof Date)return this.O;a=this.O}if(this.i&&!this.xa()){var b=this.i.presentationTimeline;return new Date(((b.m||b.i)+a)*1E3)}return this.h&&this.h.getStartDate?(b=this.h.getStartDate(),isNaN(b.getTime())?null:new Date(b.getTime()+a*1E3)):null};
p.li=function(){if(this.i&&!this.xa()){var a=this.i.presentationTimeline;a=a.m||a.i;return a===null?null:new Date(a*1E3)}return this.h&&this.h.getStartDate?(a=this.h.getStartDate(),isNaN(a.getTime())?null:a):null};p.df=function(){return this.W()?this.i?this.i.presentationTimeline.df():null:null};p.Gc=function(){if(this.m==sr)return this.H.Gc();var a={total:[],audio:[],video:[],text:[]};this.m==wr&&(a.total=Ij(this.h.buffered));return a};
function wq(a){if(!a.h||!a.h.currentTime)return null;var b=a.li();return b?Math.floor(Date.now()-(b.getTime()+a.h.currentTime*1E3)):null}p.getBandwidthEstimate=function(){return this.o?this.o.getBandwidthEstimate():NaN};
p.getStats=function(){if(this.m!=sr&&this.m!=wr)return{width:NaN,height:NaN,currentCodecs:"",streamBandwidth:NaN,decodedFrames:NaN,droppedFrames:NaN,corruptedFrames:NaN,stallsDetected:NaN,gapsJumped:NaN,estimatedBandwidth:NaN,completionPercent:NaN,loadLatency:NaN,manifestTimeSeconds:NaN,drmTimeSeconds:NaN,playTime:NaN,pauseTime:NaN,bufferingTime:NaN,licenseTime:NaN,liveLatency:NaN,maxSegmentDuration:NaN,manifestSizeBytes:NaN,bytesDownloaded:NaN,nonFatalErrorCount:NaN,manifestPeriodCount:NaN,manifestGapCount:NaN,
switchHistory:[],stateHistory:[]};rr(this);var a=this.h,b=a.currentTime/a.duration;isNaN(b)||this.W()||lo(this.B,Math.round(100*b));this.G&&(this.B.T=this.G.Lh(),this.B.V=this.G.Nh());a.getVideoPlaybackQuality&&(b=a.getVideoPlaybackQuality(),jo(this.B,Number(b.droppedVideoFrames),Number(b.totalVideoFrames)),this.B.N=Number(b.corruptedVideoFrames));this.B.o=this.F?hi(this.F):NaN;ko(this.B,a.videoWidth||NaN,a.videoHeight||NaN);this.B.l="";this.W()&&(a=wq(this),a!=null&&(this.B.F=a/1E3));b=this.qc().find(function(e){return e.active});
a=this.Lc().find(function(e){return e.active});if(b){if(b.bandwidth){var c=this.M?this.M.i:1,d=c*b.bandwidth;a&&a.bandwidth&&(d+=c*a.bandwidth);this.B.B=d}b.width&&b.height&&ko(this.B,b.width||NaN,b.height||NaN);b=b.codecs;a&&(b+=","+(a.codecs||a.mimeType));b&&(this.B.l=b)}this.m!=sr||this.xa()||(this.i&&(this.B.I=this.i.periodCount,this.B.H=this.i.gapCount,this.i.presentationTimeline&&(this.B.K=this.i.presentationTimeline.h)),a=this.o.getBandwidthEstimate(),this.B.u=a);this.m==wr&&mo(this.B,NaN);
return no(this.B)};
p.Rd=function(a,b,c,d,e,f,g){g=g===void 0?!1:g;var h=this,k,l,m,n,q,r,t,v,w,z,y,A;return O(function(E){switch(E.g){case 1:if(h.m!=sr&&h.m!=wr)throw new U(1,7,7004);c!="subtitles"&&c!="captions"&&$a("Using a kind value different of `subtitles` or `captions` can cause unwanted issues.");if(d){E.A(2);break}return G(E,ds(h,a),3);case 3:d=E.h;case 2:k=[];h.C&&(k=h.C.getCuePoints());if(h.m!=wr){E.A(4);break}l=rb();g&&l.Ha()==="WEBKIT"&&(c="forced");return G(E,es(h,a,b,c,d,f||"",k),5);case 5:m=E.h;if(m.track)return vr(h),
ur(h),E.return(pg(m.track));throw new U(1,2,2012);case 4:n=Mc;q=h.Ra();r=q.end-q.start;h.i&&(r=h.i.presentationTimeline.getDuration());if(r==Infinity)throw new U(1,4,4033);if(!k.length){E.A(6);break}return G(E,fs(h,a),7);case 7:t=E.h,v=gs(h,t,d,k),w=new Blob([v],{type:"text/vtt"}),a=zk(w),d="text/vtt";case 6:z={id:h.Fe++,originalId:null,groupId:null,createSegmentIndex:function(){return Promise.resolve()},segmentIndex:Wl(0,r,[a]),mimeType:d||"",codecs:e||"",kind:c,encrypted:!1,drmInfos:[],keyIds:new Set,
language:b,originalLanguage:b,label:f||null,type:n.Na,primary:!1,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:null,roles:[],forced:!!g,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,accessibilityPurpose:null,external:!0,fastSwitching:!1,fullMimeTypes:new Set([Se(d||"",e||"")]),isAudioMuxedInVideo:!1,baseOriginalId:null};y=Se(z.mimeType,z.codecs);A=hf(y);if(!A)throw new U(2,2,2014,d);h.i.textStreams.push(z);vr(h);ur(h);return E.return(kg(z))}})};
p.Pe=function(a,b){var c=this,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E;return O(function(I){switch(I.g){case 1:if(c.m!=sr&&c.m!=wr)throw new U(1,7,7004);if(b){I.A(2);break}return G(I,ds(c,a),3);case 3:b=I.h;case 2:if(b!="text/vtt")throw new U(1,2,2017,a);d=Mc;e=c.Ra();f=e.end-e.start;c.i&&(f=c.i.presentationTimeline.getDuration());if(f==Infinity)throw new U(1,4,4045);return G(I,fs(c,a),4);case 4:g=I.h;h=gf(b);if(!h)throw new U(2,2,2014,b);k=h();l={periodStart:0,segmentStart:0,segmentEnd:f,vttOffset:0};
m=Wb(g);n=k.parseMedia(m,l,a,[]);q=[];r=u(n);t=r.next();for(v={};!t.done;v={Wf:void 0,nd:void 0},t=r.next())v.nd=t.value,v.Wf=null,w=function(D){return function(){D.Wf==null&&(D.Wf=Ec([a],[D.nd.payload]));return D.Wf||[]}}(v),z=new yj(v.nd.startTime,v.nd.endTime,w,0,null,null,0,0,Infinity),v.nd.payload.includes("#xywh")&&(y=v.nd.payload.split("#xywh=")[1].split(","),y.length===4&&z.Mf({height:parseInt(y[3],10),positionX:parseInt(y[0],10),positionY:parseInt(y[1],10),width:parseInt(y[2],10)})),q.push(z);
A=b;if(!q.length){I.A(5);break}return G(I,ds(c,q[0].P()[0]),6);case 6:A=I.h;case 5:return E={id:c.Fe++,originalId:null,groupId:null,createSegmentIndex:function(){return Promise.resolve()},segmentIndex:new Ul(q),mimeType:A||"",codecs:"",kind:"",encrypted:!1,drmInfos:[],keyIds:new Set,language:"und",originalLanguage:null,label:null,type:d.Yf,primary:!1,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:null,roles:[],forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,
tilesLayout:"1x1",accessibilityPurpose:null,external:!0,fastSwitching:!1,fullMimeTypes:new Set([Se(A||"","")]),isAudioMuxedInVideo:!1,baseOriginalId:null},c.m==wr?c.Ke.push(E):c.i.imageStreams.push(E),vr(c),I.return(lg(E))}})};
p.Oe=function(a,b,c){var d=this,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y;return O(function(A){switch(A.g){case 1:if(d.m!=sr&&d.m!=wr)throw new U(1,7,7004);if(c){A.A(2);break}return G(A,ds(d,a),3);case 3:c=A.h;case 2:e=Mc;f=d.Ra();g=f.end-f.start;d.i&&(g=d.i.presentationTimeline.getDuration());if(g==Infinity)throw new U(1,4,4055);h=gf(c);if(!h)throw new U(2,2,2014,c);return G(A,fs(d,a),4);case 4:k=A.h;l=h();m={periodStart:0,segmentStart:0,segmentEnd:g,vttOffset:0};n=Wb(k);q=l.parseMedia(n,m,a,[]);r=[];t=u(q);
v=t.next();for(w={};!v.done;w={Xe:void 0},v=t.next())w.Xe=v.value,z=new yj(w.Xe.startTime,w.Xe.endTime,function(E){return function(){return[E.Xe.payload]}}(w),0,null,null,0,0,Infinity),r.push(z);y={id:d.Fe++,originalId:null,groupId:null,createSegmentIndex:function(){return Promise.resolve()},segmentIndex:new Ul(r),mimeType:"text/plain",codecs:"",kind:"",encrypted:!1,drmInfos:[],keyIds:new Set,language:b,originalLanguage:b,label:null,type:e.Na,primary:!1,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:null,
roles:[],forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,accessibilityPurpose:null,external:!0,fastSwitching:!1,fullMimeTypes:new Set([Se("text/plain","")]),isAudioMuxedInVideo:!1,baseOriginalId:null};d.ob.push(y);vr(d);return A.return(kg(y))}})};
function ds(a,b){var c;return O(function(d){switch(d.g){case 1:return sa(d,2),G(d,Em(b,a.N,a.g.streaming.retryParameters),4);case 4:c=d.h;ua(d,3);break;case 2:Aa(d);case 3:if(c)return d.return(c);throw new U(1,2,2011,b);}})}
function es(a,b,c,d,e,f,g){var h,k,l,m;return O(function(n){if(n.g==1)return e!="text/vtt"||g.length?G(n,fs(a,b),3):n.A(2);n.g!=2&&(h=n.h,k=gs(a,h,e,g),l=new Blob([k],{type:"text/vtt"}),b=zk(l),e="text/vtt");m=document.createElement("track");a:{var q=a.K,r=b;try{if(!q.g.enabled){var t=r;break a}var v=Jp(q);v.ot=pq;v.su=!0;var w=Np(v);t=Op(r,w);break a}catch(z){ab("CMCD_TEXT_TRACK_ERROR","Could not generate text track CMCD data.",z);t=r;break a}t=void 0}m.src=t;m.label=f;m.kind=d;m.srclang=c;a.h.getAttribute("crossorigin")||
a.h.setAttribute("crossorigin","anonymous");a.h.appendChild(m);a.cg.push(m);return n.return(m)})}function fs(a,b){var c,d,e,f;return O(function(g){if(g.g==1){c=eh;d=a.g.streaming.retryParameters;e=Zg([b],d);e.method="GET";var h=a.K;try{h.g.enabled&&eq(h,e,{ot:pq,su:!0})}catch(k){ab("CMCD_TEXT_ERROR","Could not generate text CMCD data.",k)}return G(g,a.N.request(c,e).promise,2)}f=g.h;return g.return(f.data)})}
function gs(a,b,c,d){var e=gf(c);if(e)return c=e(),a={periodStart:0,segmentStart:0,segmentEnd:a.h.duration,vttOffset:0},b=Wb(b),b=c.parseMedia(b,a,null,[]),vp(b,d);throw new U(2,2,2014,c);}p.fl=function(a,b){this.ya.width=a;this.ya.height=b};p.kh=function(a){if(this.m==sr){var b=this.l;a=a===void 0?.1:a;if(b.l.g)b=!1;else if(b.F)b=!1;else{for(var c=u(b.h.values()),d=c.next();!d.done;d=c.next())d=d.value,!d.ce||d.Ka||d.qb||(d.ce=!1,Sm(b,d,a));b=!0}}else b=!1;return b};
p.Lg=function(){$a("Shaka Player's internal Manifest structure is NOT covered by semantic versioning compatibility guarantees.  It may change at any time!  Please consider filing a feature request for whatever you use getManifest() for.");return this.i};p.Qj=function(){return this.zc};
p.Lj=function(){var a={video:null,audio:null,text:null};if(this.m!=sr)return a;var b=this.l.o,c=this.h.currentTime;b=u([b.video,b.audio,this.l.B]);for(var d=b.next();!d.done;d=b.next())if((d=d.value)&&d.segmentIndex){var e=d.segmentIndex.find(c);e=d.segmentIndex.get(e);e={codecs:e.codecs||d.codecs,mimeType:e.mimeType||d.mimeType,bandwidth:e.bandwidth||d.bandwidth};d.type=="video"?(e.width=d.width,e.height=d.height,a.video=e):d.type=="audio"?a.audio=e:d.type==Kc&&(a.text=e)}return a};
function Iq(a){var b=Xn();b.streaming.failureCallback=function(c){if(a.W()){var d=null;c.code==1001||c.code==1002?(d=1,a.g.streaming.lowLatencyMode&&(d=.1)):c.code==1003&&(d=.1);d!=null&&(c.severity=1,a.kh(d))}};b.textDisplayFactory=function(){if(a.Be){var c=a.h;c=c.webkitDisplayingFullscreen||c.webkitPresentationMode&&c.webkitPresentationMode!="inline"?!1:!0}else c=!1;return c?new lp(a.h,a.Be):"track"in document.createElement("track")?new gp(a):new kp};return b}p.Zi=function(a){this.Be=a};
function jr(a,b){for(var c=new Set,d=u(b.textStreams),e=d.next();!e.done;e=d.next())e=e.value,e.mimeType!="application/cea-608"&&e.mimeType!="application/cea-708"||c.add(e.originalId);d=u(b.variants);for(e=d.next();!e.done;e=d.next())if((e=e.value.video)&&e.closedCaptions)for(var f=u(e.closedCaptions.keys()),g=f.next();!g.done;g=f.next())if(g=g.value,!c.has(g)){var h=g.startsWith("CC")?"application/cea-608":"application/cea-708",k=new Xl,l=e.closedCaptions.get(g);h={id:a.Fe++,originalId:g,groupId:null,
createSegmentIndex:function(){return Promise.resolve()},segmentIndex:k,mimeType:h,codecs:"",kind:"caption",encrypted:!1,drmInfos:[],keyIds:new Set,language:l,originalLanguage:l,label:null,type:Kc,primary:!1,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:null,roles:e.roles,forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,accessibilityPurpose:null,external:!1,fastSwitching:!1,fullMimeTypes:new Set([Se(h,"")]),isAudioMuxedInVideo:!1,baseOriginalId:null};
b.textStreams.push(h);c.add(g)}}
function Hr(a,b){var c,d,e,f,g;return O(function(h){if(h.g==1)return c=a.audio,d=a.video,e=function(k,l){var m,n,q;return O(function(r){if(r.g==1)return k?k.segmentIndex?r.A(2):G(r,k.createSegmentIndex(),2):r.return(null);n=(m=k.segmentIndex.Xb(l))?m.next().value:null;if(!n)return r.return(null);q=n.startTime;return r.return(q)})},G(h,e(c,b),2);if(h.g!=3)return f=h.h,G(h,e(d,b),3);g=h.h;return g!=null&&f!=null?h.return(Math.max(g,f)):g!=null?h.return(g):f!=null?h.return(f):h.return(b)})}
function Zq(a){var b=a.Rg();if(a.B&&a.R&&a.G){if(a.g.streaming.rebufferingGoal==0){var c=a.M;c.j=!1;am(c)}else c=a.M,c.j=b,am(c);a.K&&(c=a.K,b||c.F||(c.F=!0),c.F&&b&&(c.I=!0,Hp(c,"ps",{dd:"r"})),c.J=b);rr(a);c=a.g.streaming.liveSync.dynamicTargetLatency.maxAttempts;if(a.g.streaming.liveSync.dynamicTargetLatency.enabled&&b&&a.Ne<c){c=a.g.streaming.liveSync.dynamicTargetLatency.maxLatency;var d=a.g.streaming.liveSync.targetLatencyTolerance,e=a.g.streaming.liveSync.dynamicTargetLatency.rebufferIncrement;
a.V&&(a.V=Math.min(a.V+ ++a.Ne*e,c-d))}}b=(new Map).set("buffering",b);a.dispatchEvent(Qq("buffering",b))}function tr(a,b){a.dc.Qa();a.dc.D(a.h,"timeupdate",function(){var c=a.h.currentTime,d=a.Ra(),e=a.W(),f=e?a.g.streaming.safeSeekOffset:0;b>0?e&&b>1&&Math.floor(c)>=Math.floor(d.end)&&a.Sd():Math.floor(c)<=Math.floor(d.start+f)&&a.Sd()})}
function rr(a){if(a.B&&a.R){var b=a.B.g,c="playing";a.R.g==wi?c="buffering":a.ge()?c="ended":a.h.paused&&(c="paused");var d=c;if(b.g==null)b.g={timestamp:Date.now()/1E3,state:d,duration:0},b=!0;else{var e=Date.now()/1E3;b.g.duration=e-b.g.timestamp;b.g.state==d?b=!1:(b.h.push(b.g),b.g={timestamp:e,state:d,duration:0},b=!0)}b&&(c=(new Map).set("newstate",c),a.dispatchEvent(Qq("statechanged",c)))}}
function Lr(a){var b=a.h.playbackRate,c=a.W();if(a.g.streaming.vodDynamicPlaybackRate&&!c){var d=a.g.streaming.vodDynamicPlaybackRateLowBufferRate,e=a.ei();e<=a.g.streaming.vodDynamicPlaybackRateBufferRatio?b!=d&&a.xe(d,!1):e==1&&b!==a.M.Tc()&&a.Sd()}if(c&&(c=a.Ra(),Number.isFinite(c.end)&&!(a.h.currentTime<c.start||a.h.paused))){d=a.g.streaming.liveSync.targetLatencyTolerance;e=a.g.streaming.liveSync.dynamicTargetLatency.enabled;var f=a.g.streaming.liveSync.dynamicTargetLatency.stabilityThreshold;
if(a.g.streaming.liveSync&&a.g.streaming.liveSync.enabled){var g=a.g.streaming.liveSync.targetLatency;var h=g+d;var k=Math.max(0,g-d);var l=a.g.streaming.liveSync.maxPlaybackRate;var m=a.g.streaming.liveSync.minPlaybackRate}else a.i&&a.i.serviceDescription&&(g=a.i.serviceDescription.targetLatency,a.i.serviceDescription.targetLatency!=null?h=a.i.serviceDescription.targetLatency+d:a.i.serviceDescription.maxLatency!=null&&(h=a.i.serviceDescription.maxLatency),a.i.serviceDescription.targetLatency!=null?
k=Math.max(0,a.i.serviceDescription.targetLatency-d):a.i.serviceDescription.minLatency!=null&&(k=a.i.serviceDescription.minLatency),l=a.i.serviceDescription.maxPlaybackRate||a.g.streaming.liveSync.maxPlaybackRate,m=a.i.serviceDescription.minPlaybackRate||a.g.streaming.liveSync.minPlaybackRate);a.V||typeof g!=="number"||(a.V=g);var n=a.g.streaming.liveSync.dynamicTargetLatency.maxAttempts;e&&a.cc&&a.V!==null&&typeof g==="number"&&a.Ne<n&&Date.now()-a.cc>f*1E3&&(f=a.g.streaming.liveSync.dynamicTargetLatency.minLatency,
a.V=Math.max(a.V-(g-f)/2,f+d),a.cc=Date.now());e&&a.V!==null&&(h=a.V+d,k=a.V-d);g=c.end-a.h.currentTime;d=0;a.m==wr&&(e=a.h.buffered,e.length>0&&(d=e.end(e.length-1),d=Math.max(l,d-c.end)));c=a.g.streaming.liveSync.panicMode;e=a.g.streaming.liveSync.panicThreshold*1E3;f=Date.now()-a.R.i;c&&!m&&(m=a.g.streaming.liveSync.minPlaybackRate);c&&m&&f<=e?b!=m&&a.xe(m,!1):h!=void 0&&l&&g-d>h?(b!=l&&a.xe(l,!1),a.cc=null):k!=void 0&&m&&g-d<k?(b!=m&&a.xe(m,!1),a.cc=null):b!==a.M.Tc()&&(a.Sd(),a.cc=Date.now())}}
function Mr(a){if(a.h){var b=function(e,f){return(Gq(e,f,.01)||f>e)&&a.ag<e?(a.ag=e,!0):!1},c=a.Ra();c=c.end-c.start;c=c>0?a.h.currentTime/c:0;if(!isNaN(c)){c*=100;if(b(0,c))var d=Qq("started");else if(b(25,c))d=Qq("firstquartile");else if(b(50,c))d=Qq("midpoint");else if(b(75,c))d=Qq("thirdquartile");else{if(b(100,c)||c>100)d=Qq("complete");a.g&&a.g.playRangeEnd!=Infinity&&a.ge()&&a.h.pause()}d&&a.dispatchEvent(d)}}}
function zr(a){try{Di(a.Ee,a.i)}catch(c){return Xq(a,c),!1}var b=sg(a.i.variants);b=a.J.create(b);a=a.o.setVariants(Array.from(b.values()));return typeof a=="boolean"?a:!0}
function Dr(a,b){b=b===void 0?!1:b;if(zr(a)){if(!a.g.abr.enabled){var c=a.J;typeof c.getLastAdaptationSet!="function"&&(yb("AdaptationSetCriteria w/o getLastAdaptationSet","Please use an AdaptationSetCriteria with getLastAdaptationSet."),c.getLastAdaptationSet=function(){return null});if(c=c.getLastAdaptationSet())if(c=Array.from(c.values()),c.length){var d=a.l.o;if(d&&d.video&&(c=c.find(function(e){return e.video==d.video})))return c}}return a.o.chooseVariant(b)}return null}
function Nq(a,b,c,d,e){b=b===void 0?!0:b;c=c===void 0?0:c;d=d===void 0?!1:d;e=e===void 0?!0:e;var f=Dr(a);f&&Br(a,f,e,b,c,d)}
function Br(a,b,c,d,e,f){f=f===void 0?!1:f;var g=a.l.o;if(b==g)d&&Wm(a.l,b,d,e,!0);else{var h=a.B.h;h.h!=b&&(h.h=b,h.g.push({timestamp:Date.now()/1E3,id:b.id,type:"variant",fromAdaptation:c,bandwidth:b.bandwidth}));Wm(a.l,b,d,e,f,c);d=null;g&&(d=jg(g));g=jg(b);g.active=!0;if(a.T&&(e=a.T,b=b.video)){b.dependencyStream&&(b=b.dependencyStream);f=0;h=-1;switch(b.mimeType){case "video/webm":f=1;break;case "video/mp4":f=2}switch(a.ii()){case "DASH":h=1;break;case "HLS":h=0}e.g&&(e.g.setLevelSwitching(b.id,
!0),e.g.setContainerFormat(f),e.j||e.g.setStreamingFormat(h))}c?(c=(new Map).set("oldTrack",d).set("newTrack",g),c=Qq("adaptation",c),hs(a,c)):is(a,d,g);js(a,d,g)}}function as(a,b){var c=Array.from(a.h.audioTracks).find(function(e){return e.enabled});b.enabled=!0;if(c){b.id!==c.id&&(c.enabled=!1);var d=Xr(a);c=qg(c,d);b=qg(b,d);is(a,c,b);js(a,c,b)}}function Xr(a){return a.h&&a.h.videoTracks?Array.from(a.h.videoTracks).find(function(b){return b.selected}):null}
function vr(a){var b=Qq("trackschanged");hs(a,b);ks(a)}function is(a,b,c){b=(new Map).set("oldTrack",b).set("newTrack",c);b=Qq("variantchanged",b);hs(a,b)}function js(a,b,c){var d=!1;b&&b.audioId==c.audioId&&b.audioGroupId==c.audioGroupId||(d=!0);d&&ks(a)}function ks(a){var b=Qq("audiotrackschanged");hs(a,b)}function ur(a){var b=Qq("textchanged");hs(a,b)}function Ir(a){var b=Qq("texttrackvisibility");hs(a,b)}
function Kr(a){a.g.abr.enabled||Mq(a);var b=(new Map).set("newStatus",a.g.abr.enabled);hs(a,Qq("abrstatuschanged",b))}function Jr(a){var b=a.Lc().find(function(c){return c.active});b&&a.u&&a.u.setTextLanguage&&a.u.setTextLanguage(b.language)}function Mq(a,b){b=b===void 0?!0:b;if(a.m==sr){a.He.stop();for(var c=u(a.i.variants),d=c.next();!d.done;d=c.next())d.value.disabledUntilTime=0;b&&zr(a)}}
p.disableStream=function(a,b){if(!this.g.abr.enabled||this.m===Rq||!navigator.onLine||b==0||!this.i)return!1;if(this.i.variants.some(function(h){var k=h[a.type];return k&&k.id!==a.id&&!h.disabledUntilTime?a.type=="audio"?a.language===k.language:!0:!1})){for(var c=!1,d=!1,e=u(this.i.variants),f=e.next();!f.done;f=e.next()){f=f.value;var g=f[a.type];g&&(g.id===a.id?(f.disabledUntilTime=Date.now()/1E3+b,c=!0):g.trickModeVideo&&g.trickModeVideo.id==a.id&&(d=!0))}if(!c&&d)return!1;this.He.Ea(1);b=this.Gc().video.reduce(function(h,
k){return h+k.end-k.start},0);Nq(this,!1,b,!0,!1);return!0}return!1};
function Xq(a,b){var c,d,e,f,g;return O(function(h){switch(h.g){case 1:if(a.m==Rq)return h.return();b.severity===1&&a.B.M++;c=!0;if(!(a.Ua&&a.i&&a.l)||b.code!=3016&&b.code!=3014&&b.code!=3015&&b.code!=3024&&b.code!=3018){h.A(2);break}d=rb();if(d.Ha()==="WEBKIT"&&b.code==3016)return h.return();sa(h,3);return G(h,mn(a.l),5);case 5:e=h.h;c=!e;e&&(f=Qq("mediasourcerecovered"),a.dispatchEvent(f));ua(h,2);break;case 3:Aa(h),c=!0;case 2:if(!c)return h.return();b.severity===2&&Mq(a,!1);g=Qq("error",(new Map).set("detail",
b));a.dispatchEvent(g);g.defaultPrevented&&(b.handled=!0);H(h)}})}p.addFont=function(a,b){return Qj(a,b)};function lr(a,b,c,d){d=d===void 0?a:d;a=(new Map).set("detail",{schemeIdUri:c.schemeIdUri,value:c.value,startTime:c.startTime,endTime:c.endTime,id:c.id,timescale:c.timescale,eventElement:c.eventElement,eventNode:c.eventNode});d.dispatchEvent(Qq(b,a))}
function mr(a,b,c,d){d=d===void 0?!1:d;b=(new Map).set("mediaQuality",{bandwidth:b.bandwidth,audioSamplingRate:b.audioSamplingRate,codecs:b.codecs,contentType:b.contentType,frameRate:b.frameRate,height:b.height,mimeType:b.mimeType,channelsCount:b.channelsCount,pixelAspectRatio:b.pixelAspectRatio,width:b.width,label:b.label,roles:b.roles,language:b.language}).set("position",c);a.dispatchEvent(Qq(d?"audiotrackchanged":"mediaqualitychanged",b))}
function Wq(a,b){b=b===void 0?!0:b;if(!a.h.error)return b?new U(2,3,3016):null;var c=a.h.error.code;if(!b&&c==1)return null;if(b=a.h.error.msExtendedCode)b<0&&(b+=4294967296),b=b.toString(16);return new U(2,3,3016,c,b,a.h.error.message)}
function nr(a,b){var c=Qq("keystatuschanged");a.dispatchEvent(c);var d=Object.keys(b);d.length==1&&d[0]==""&&(d=["00"],b={"00":b[""]});var e=d.length==1&&d[0]=="00";c=!1;if(d.length){d=a.keySystem();for(var f=kh(a.g.drm.clearKeys),g=function(t,v){t.allowedByKeySystem=!0;v=u(v);for(var w=v.next();!w.done;w=v.next())if(w=w.value,(w=b[e?"00":w])||a.F.H)t.allowedByKeySystem=t.allowedByKeySystem&&!!w&&!Ei.includes(w)},h=u(a.i.variants),k=h.next();!k.done;k=h.next()){k=k.value;var l=vg(k);l=u(l);for(var m=
l.next();!m.done;m=l.next()){m=m.value;var n=k.allowedByKeySystem;if(m.keyIds.size)if(m.drmInfos.length&&!f.size&&a.i.type=="HLS")for(var q=u(m.drmInfos),r=q.next();!r.done;r=q.next())r=r.value,r.keySystem==d&&(r.keyIds.size?g(k,r.keyIds):g(k,m.keyIds));else g(k,m.keyIds);n!=k.allowedByKeySystem&&(c=!0)}}}c&&(vr(a),(c=a.l.o)&&!c.allowedByKeySystem?Nq(a):zr(a))}function Ar(a,b,c){b>0&&(a.W()||a.Yi(b));b=a.getDuration();c<b&&(a.W()||a.Ab(c))}
function hs(a,b){O(function(c){if(c.g==1)return G(c,Promise.resolve(),2);a.m!=Rq&&a.dispatchEvent(b);H(c)})}function cs(a){var b=new Set;a=u(a);for(var c=a.next();!c.done;c=a.next())c=c.value,c.language?b.add(yf(c.language)):b.add("und");return b}
function bs(a){for(var b=new Map,c=new Map,d=0;d<a.length;d++){var e=a[d],f="und",g=[];e.language&&(f=yf(e.language));e.type=="variant"?g=e.audioRoles:g=e.roles;g&&g.length||(g=[""]);b.has(f)||b.set(f,new Set);g=u(g);for(var h=g.next();!h.done;h=g.next())h=h.value,b.get(f).add(h),e.label&&(c.has(f)||c.set(f,new Map),c.get(f).set(h,e.label))}var k=[];b.forEach(function(l,m){l=u(l);for(var n=l.next();!n.done;n=l.next()){n=n.value;var q=null;c.has(m)&&c.get(m).has(n)&&(q=c.get(m).get(n));k.push({language:m,
role:n,label:q})}});return k}p.xa=function(){return this.h&&this.h.remote?this.h.remote.state!="disconnected":!1};p.ge=function(){return!this.h||this.h.ended?!0:this.Ua&&!this.W()&&this.h.currentTime>=this.Ra().end};T("shaka.Player",X);X.prototype.isEnded=X.prototype.ge;X.prototype.isRemotePlayback=X.prototype.xa;X.prototype.addFont=X.prototype.addFont;X.prototype.setVideoContainer=X.prototype.Zi;X.prototype.getFetchedPlaybackInfo=X.prototype.Lj;X.prototype.getManifestParserFactory=X.prototype.Qj;
X.prototype.getManifest=X.prototype.Lg;X.prototype.retryStreaming=X.prototype.kh;X.prototype.setMaxHardwareResolution=X.prototype.fl;X.prototype.addChaptersTrack=X.prototype.Oe;X.prototype.addThumbnailsTrack=X.prototype.Pe;X.prototype.addTextTrackAsync=X.prototype.Rd;X.prototype.getStats=X.prototype.getStats;X.prototype.getBufferedInfo=X.prototype.Gc;X.prototype.getSegmentAvailabilityDuration=X.prototype.df;X.prototype.getPresentationStartTimeAsDate=X.prototype.li;
X.prototype.getPlayheadTimeAsDate=X.prototype.Tj;X.prototype.setTextTrackVisibility=X.prototype.wh;X.prototype.getChaptersAsync=X.prototype.Gj;X.prototype.getChapters=X.prototype.Fj;X.prototype.getChaptersTracks=X.prototype.Hj;X.prototype.isTextTrackVisible=X.prototype.Sg;X.prototype.selectVariantsByLabel=X.prototype.Xk;X.prototype.selectTextLanguage=X.prototype.oh;X.prototype.selectAudioLanguage=X.prototype.Ti;X.prototype.getTextLanguages=X.prototype.Zj;X.prototype.getAudioLanguages=X.prototype.Cj;
X.prototype.getTextLanguagesAndRoles=X.prototype.$j;X.prototype.getAudioLanguagesAndRoles=X.prototype.Dj;X.prototype.getVideoTracks=X.prototype.getVideoTracks;X.prototype.selectVideoTrack=X.prototype.Yk;X.prototype.getAudioTracks=X.prototype.getAudioTracks;X.prototype.selectAudioTrack=X.prototype.Wk;X.prototype.selectVariantTrack=X.prototype.Jf;X.prototype.selectTextTrack=X.prototype.ph;X.prototype.getThumbnails=X.prototype.ck;X.prototype.getAllThumbnails=X.prototype.Bj;
X.prototype.getImageTracks=X.prototype.Nj;X.prototype.getTextTracks=X.prototype.Lc;X.prototype.getVariantTracks=X.prototype.qc;X.prototype.cancelTrickPlay=X.prototype.Sd;X.prototype.trickPlay=X.prototype.xe;X.prototype.useTrickPlayTrackIfAvailable=X.prototype.Kh;X.prototype.getPlaybackRate=X.prototype.Ob;X.prototype.isBuffering=X.prototype.Rg;X.prototype.getKeyStatuses=X.prototype.$e;X.prototype.getActiveSessionsMetadata=X.prototype.Kg;X.prototype.getExpiration=X.prototype.Zd;
X.prototype.drmInfo=X.prototype.drmInfo;X.prototype.keySystem=X.prototype.keySystem;X.prototype.isFullyLoaded=X.prototype.nk;X.prototype.goToLive=X.prototype.ik;X.prototype.seekRange=X.prototype.Ra;X.prototype.isVideoOnly=X.prototype.ti;X.prototype.isAudioOnly=X.prototype.lk;X.prototype.isInProgress=X.prototype.Vc;X.prototype.isLive=X.prototype.W;X.prototype.getQueueManager=X.prototype.mi;X.prototype.getAdManager=X.prototype.di;X.prototype.getAssetUri=X.prototype.rd;
X.prototype.getNetworkingEngine=X.prototype.Yb;X.prototype.getMediaElement=X.prototype.bf;X.prototype.getManifestType=X.prototype.ii;X.prototype.getLoadMode=X.prototype.$d;X.prototype.resetConfiguration=X.prototype.Oi;X.prototype.getBufferFullness=X.prototype.ei;X.prototype.getNonDefaultConfiguration=X.prototype.ki;X.prototype.getConfigurationForLowLatency=X.prototype.Ij;X.prototype.getConfiguration=X.prototype.getConfiguration;X.prototype.configurationForLowLatency=X.prototype.yj;
X.prototype.configure=X.prototype.configure;X.prototype.releaseAllMutexes=X.prototype.Ok;X.prototype.destroyAllPreloads=X.prototype.rg;X.prototype.preload=X.prototype.preload;X.prototype.detachAndSavePreload=X.prototype.$h;X.prototype.unloadAndSavePreload=X.prototype.jj;X.prototype.load=X.prototype.load;X.prototype.updateStartTime=X.prototype.ql;X.prototype.unload=X.prototype.Cc;X.prototype.detach=X.prototype.detach;X.prototype.attachCanvas=X.prototype.qj;X.prototype.attach=X.prototype.Vb;
X.probeSupport=function(a){a=a===void 0?!0:a;var b,c,d,e,f,g,h;return O(function(k){switch(k.g){case 1:b={};if(!a){k.A(2);break}return G(k,si(),3);case 3:b=k.h;case 2:return c=Vc(),d=Bk(),e=rb(),G(k,e.lc(),4);case 4:return f=k.h,g={manifest:c,media:d,drm:b,hardwareResolution:f},h=Tq,h.forEach(function(l,m){g[m]=l()}),k.return(g)}})};
X.isBrowserSupported=function(){window.Promise||$a("A Promise implementation or polyfill is required");if(!(window.Promise&&window.Uint8Array&&Array.prototype.forEach)||(navigator.userAgent||"").includes("Trident/"))return!1;rb();return Wc()?!0:Xc().canPlayType("application/x-mpegurl")!=""};X.setQueueManagerFactory=function(a){Lq=a};X.setAdManagerFactory=function(a){Kq=a};X.registerSupportPlugin=Sq;X.prototype.destroy=X.prototype.destroy;var Rq=0,Hq=1,sr=2,wr=3;
X.LoadMode={DESTROYED:Rq,NOT_LOADED:Hq,MEDIA_SOURCE:sr,SRC_EQUALS:wr};X.version="v4.16.12";var ls=["4","16"];zb=new function(a){this.g=a;this.i=Ab;this.h=Bb}(new xb(Number(ls[0]),Number(ls[1])));var Tq=new Map,Kq=null,Lq=null;function ms(){this.g=[];this.i=this.m=this.l=this.j=this.h=0}function ns(a){return a.g.length?a.g.reduce(function(b,c){return b+c},0)/a.g.length:0};function os(a,b,c){var d=this;this.g=a;this.h=b;this.m=c;this.i=!1;this.j=this.h.getVolume();this.l=new kb;this.l.D(this.h,google.ima.AdEvent.Type.PAUSED,function(){d.i=!0});this.l.D(this.h,google.ima.AdEvent.Type.RESUMED,function(){d.i=!1})}p=os.prototype;p.needsSkipUI=function(){return!1};p.isClientRendering=function(){return!0};p.hasCustomClick=function(){return!0};p.isUsingAnotherMediaElement=function(){return!0};p.getDuration=function(){return this.g.getDuration()};
p.getMinSuggestedDuration=function(){return this.g.getMinSuggestedDuration()};p.getRemainingTime=function(){return this.h.getRemainingTime()};p.isPaused=function(){return this.i};p.isSkippable=function(){return this.g.getSkipTimeOffset()>=0};p.getTimeUntilSkippable=function(){var a=this.g.getSkipTimeOffset();a=this.getRemainingTime()-a;return Math.max(a,0)};p.canSkipNow=function(){return this.h.getAdSkippableState()};p.skip=function(){return this.h.skip()};p.pause=function(){return this.h.pause()};
p.play=function(){return this.h.resume()};p.getVolume=function(){return this.h.getVolume()};p.setVolume=function(a){this.m.volume=a;return this.h.setVolume(a)};p.isMuted=function(){return this.h.getVolume()==0};p.isLinear=function(){return this.g.isLinear()};p.resize=function(a,b){this.h.resize(a,b)};p.setMuted=function(a){(this.m.muted=a)?(this.j=this.getVolume(),this.h.setVolume(0)):this.h.setVolume(this.j)};p.getSequenceLength=function(){var a=this.g.getAdPodInfo();return a==null?1:a.getTotalAds()};
p.getPositionInSequence=function(){var a=this.g.getAdPodInfo();return a==null?1:a.getAdPosition()};p.getTitle=function(){return this.g.getTitle()};p.getDescription=function(){return this.g.getDescription()};p.getVastMediaBitrate=function(){return this.g.getVastMediaBitrate()};p.getVastMediaHeight=function(){return this.g.getVastMediaHeight()};p.getVastMediaWidth=function(){return this.g.getVastMediaWidth()};p.getVastAdId=function(){return""};p.getAdId=function(){return this.g.getAdId()};
p.getCreativeAdId=function(){return this.g.getCreativeAdId()};p.getAdvertiserName=function(){return this.g.getAdvertiserName()};p.getMediaUrl=function(){return this.g.getMediaUrl()};p.getTimeOffset=function(){var a=this.g.getAdPodInfo();return a==null?0:a.getTimeOffset()};p.getPodIndex=function(){var a=this.g.getAdPodInfo();return a==null?0:a.getPodIndex()};p.release=function(){this.h=this.g=null};T("shaka.ads.ClientSideAd",os);os.prototype.release=os.prototype.release;os.prototype.getPodIndex=os.prototype.getPodIndex;
os.prototype.getTimeOffset=os.prototype.getTimeOffset;os.prototype.getMediaUrl=os.prototype.getMediaUrl;os.prototype.getAdvertiserName=os.prototype.getAdvertiserName;os.prototype.getCreativeAdId=os.prototype.getCreativeAdId;os.prototype.getAdId=os.prototype.getAdId;os.prototype.getVastAdId=os.prototype.getVastAdId;os.prototype.getVastMediaWidth=os.prototype.getVastMediaWidth;os.prototype.getVastMediaHeight=os.prototype.getVastMediaHeight;os.prototype.getVastMediaBitrate=os.prototype.getVastMediaBitrate;
os.prototype.getDescription=os.prototype.getDescription;os.prototype.getTitle=os.prototype.getTitle;os.prototype.getPositionInSequence=os.prototype.getPositionInSequence;os.prototype.getSequenceLength=os.prototype.getSequenceLength;os.prototype.setMuted=os.prototype.setMuted;os.prototype.resize=os.prototype.resize;os.prototype.isLinear=os.prototype.isLinear;os.prototype.isMuted=os.prototype.isMuted;os.prototype.setVolume=os.prototype.setVolume;os.prototype.getVolume=os.prototype.getVolume;
os.prototype.play=os.prototype.play;os.prototype.pause=os.prototype.pause;os.prototype.skip=os.prototype.skip;os.prototype.canSkipNow=os.prototype.canSkipNow;os.prototype.getTimeUntilSkippable=os.prototype.getTimeUntilSkippable;os.prototype.isSkippable=os.prototype.isSkippable;os.prototype.isPaused=os.prototype.isPaused;os.prototype.getRemainingTime=os.prototype.getRemainingTime;os.prototype.getMinSuggestedDuration=os.prototype.getMinSuggestedDuration;os.prototype.getDuration=os.prototype.getDuration;
os.prototype.isUsingAnotherMediaElement=os.prototype.isUsingAnotherMediaElement;os.prototype.hasCustomClick=os.prototype.hasCustomClick;os.prototype.isClientRendering=os.prototype.isClientRendering;os.prototype.needsSkipUI=os.prototype.needsSkipUI;function ps(){}
function qs(a,b){var c=[];a=u(Hd(a,"Ad"));for(var d=a.next();!d.done;d=a.next())if(d=Ld(d.value,"InLine"))if(d=Ld(d,"Creatives")){d=u(Hd(d,"Creative"));for(var e=d.next();!e.done;e=d.next()){e=e.value;var f=Ld(e,"Linear");f&&rs(c,b,f);if(e=Ld(e,"NonLinearAds")){e=Hd(e,"NonLinear");e=u(e);for(var g=e.next();!g.done;g=e.next())a:{f=c;var h=b,k=g.value,l=Ld(k,"StaticResource");if(l)g=l.attributes.creativeType;else{l=Ld(k,"HTMLResource");if(!l)break a;g="text/html"}if(l=Jd(l)){g==="text/html"&&(l="data:text/html;charset=UTF-8,"+
encodeURIComponent(l));var m=Od(k,"width",Vd)||Od(k,"expandedWidth",Vd),n=Od(k,"height",Vd)||Od(k,"expandedHeight",Vd);if(m||n){var q=null,r=Ld(k,"NonLinearClickThrough");r&&(r=Jd(r))&&(q=r);r=null;(k=k.attributes.minSuggestedDuration)&&(r=ud(k));k=0;h!=null&&(k=h);f.push({id:null,groupId:null,startTime:k,endTime:null,uri:l,mimeType:g,isSkippable:!1,skipOffset:null,skipFor:null,canJump:!1,resumeOffset:0,playoutLimit:r,once:!0,pre:h==null,post:h==Infinity,timelineRange:!1,loop:!1,overlay:{viewport:{x:0,
y:0},topLeft:{x:0,y:0},size:{x:m||0,y:n||0}},displayOnBackground:!1,currentVideo:null,background:null,clickThroughUrl:q})}}}}}}return c}
function rs(a,b,c){var d=0;b!=null&&(d=b);var e=null;c.attributes.skipoffset&&(e=ud(c.attributes.skipoffset),isNaN(e)&&(e=null));var f=Ld(c,"MediaFiles");if(f){var g=null;(c=Ld(c,"VideoClicks"))&&(c=Ld(c,"ClickThrough"))&&(c=Jd(c))&&(g=c);f=c=Hd(f,"MediaFile");c=c.filter(function(k){return k.attributes.delivery=="streaming"});c.length&&(f=c);f=f.sort(function(k,l){return(parseInt(l.attributes.height,10)||0)-(parseInt(k.attributes.height,10)||0)});f=u(f);for(c=f.next();!c.done;c=f.next())if(c=c.value,
!c.attributes.apiFramework){var h=Jd(c);if(h){a.push({id:null,groupId:null,startTime:d,endTime:null,uri:h,mimeType:c.attributes.type||null,isSkippable:e!=null,skipOffset:e,skipFor:null,canJump:!1,resumeOffset:0,playoutLimit:null,once:!0,pre:b==null,post:b==Infinity,timelineRange:!1,loop:!1,overlay:null,displayOnBackground:!1,currentVideo:null,background:null,clickThroughUrl:g});break}}}}
function ss(a){var b=[];a=u(Hd(a,"vmap:AdBreak"));for(var c=a.next();!c.done;c=a.next()){var d=c.value,e=d.attributes.timeOffset;e&&(c=null,e=="start"?c=null:e=="end"?c=Infinity:c=ud(e),(d=Ld(d,"vmap:AdSource"))&&(d=Ld(d,"vmap:AdTagURI"))&&(d=Id(d))&&b.push({time:c,uri:d}))}return b}T("shaka.ads.Utils",ps);ps.ADS_LOADED="ads-loaded";ps.AD_STARTED="ad-started";ps.AD_FIRST_QUARTILE="ad-first-quartile";ps.AD_MIDPOINT="ad-midpoint";ps.AD_THIRD_QUARTILE="ad-third-quartile";ps.AD_COMPLETE="ad-complete";
ps.AD_STOPPED="ad-stopped";ps.AD_SKIPPED="ad-skipped";ps.AD_VOLUME_CHANGED="ad-volume-changed";ps.AD_MUTED="ad-muted";ps.AD_PAUSED="ad-paused";ps.AD_RESUMED="ad-resumed";ps.AD_SKIP_STATE_CHANGED="ad-skip-state-changed";ps.CUEPOINTS_CHANGED="ad-cue-points-changed";ps.IMA_AD_MANAGER_LOADED="ima-ad-manager-loaded";ps.IMA_STREAM_MANAGER_LOADED="ima-stream-manager-loaded";ps.AD_CLICKED="ad-clicked";ps.AD_PROGRESS="ad-progress";ps.AD_BUFFERING="ad-buffering";ps.AD_IMPRESSION="ad-impression";
ps.AD_DURATION_CHANGED="ad-duration-changed";ps.AD_CLOSED="ad-closed";ps.AD_LOADED="ad-loaded";ps.ALL_ADS_COMPLETED="all-ads-completed";ps.AD_LINEAR_CHANGED="ad-linear-changed";ps.AD_METADATA="ad-metadata";ps.AD_RECOVERABLE_ERROR="ad-recoverable-error";ps.AD_ERROR="ad-error";ps.AD_BREAK_READY="ad-break-ready";ps.AD_INTERACTION="ad-interaction";ps.AD_CONTENT_PAUSE_REQUESTED="ad-content-pause-requested";ps.AD_CONTENT_RESUME_REQUESTED="ad-content-resume-requested";ps.AD_CONTENT_ATTACH_REQUESTED="ad-content-attach-requested";function ts(a,b,c,d,e){var f=this;this.u=a;this.i=b;this.G=!1;this.B=this.o=null;this.H=NaN;this.l=e;this.j=null;this.h=new kb;google.ima.settings.setLocale(c);google.ima.settings.setDisableCustomPlaybackForIOS10Plus(!0);this.F=new google.ima.AdDisplayContainer(this.u,this.i);this.F.initialize();this.m=new google.ima.AdsLoader(this.F);this.m.getSettings().setPlayerType("shaka-player");this.m.getSettings().setPlayerVersion("v4.16.12");this.g=null;this.C=d||new google.ima.AdsRenderingSettings;this.h.D(this.m,
google.ima.AdsManagerLoadedEvent.Type.ADS_MANAGER_LOADED,function(g){us(f,g)});this.h.D(this.m,google.ima.AdErrorEvent.Type.AD_ERROR,function(g){vs(f,g)});this.h.D(this.i,"ended",function(){f.m.contentComplete()});this.h.Aa(this.i,"play",function(){f.G=!0})}ts.prototype.configure=function(a){this.o=a};ts.prototype.stop=function(){this.g&&this.g.stop();this.u&&Nj(this.u)};
ts.prototype.release=function(){this.stop();this.B&&this.B.disconnect();this.h&&this.h.release();this.g&&this.g.destroy();this.m.destroy();this.F.destroy()};function vs(a,b){b.getError();b=(new Map).set("originalEvent",b);a.l(new V("ad-error",b));ws(a,null);a.l(new V("ad-cue-points-changed",(new Map).set("cuepoints",[])))}
function us(a,b){a.l(new V("ads-loaded",(new Map).set("loadTime",Date.now()/1E3-a.H)));if(a.o.customPlayheadTracker){var c={currentTime:a.i.currentTime};a.g=b.getAdsManager(c,a.C);a.i.muted?a.g.setVolume(0):a.g.setVolume(a.i.volume);a.h.D(a.i,"timeupdate",function(){a.i.duration&&(c.currentTime=a.i.currentTime)});a.h.D(a.i,"volumechange",function(){a.j&&(a.j.setVolume(a.i.volume),a.i.muted&&a.j.setMuted(!0))})}else a.g=b.getAdsManager(a.i,a.C);a.l(new V("ima-ad-manager-loaded",(new Map).set("imaAdManager",
a.g)));var d=a.g.getCuePoints();if(d.length){b=[];d=u(d);for(var e=d.next();!e.done;e=d.next())b.push({start:e.value,end:null});a.l(new V("ad-cue-points-changed",(new Map).set("cuepoints",b)))}xs(a);try{a.g.init(a.i.offsetWidth,a.i.offsetHeight),a.h.D(a.i,"loadeddata",function(){a.g.resize(a.i.offsetWidth,a.i.offsetHeight)}),"ResizeObserver"in window?(a.B=new ResizeObserver(function(){a.g.resize(a.i.offsetWidth,a.i.offsetHeight)}),a.B.observe(a.i)):a.h.D(document,"fullscreenchange",function(){a.g.resize(a.i.offsetWidth,
a.i.offsetHeight)}),a.G||a.o.skipPlayDetection?a.g.start():a.h.Aa(a.i,"play",function(){a.G=!0;a.g.start()})}catch(f){ws(a,null)}}
function xs(a){function b(c,d){c=(new Map).set("originalEvent",c);a.l(new V(d,c))}a.h.D(a.g,google.ima.AdErrorEvent.Type.AD_ERROR,function(c){vs(a,c)});a.h.D(a.g,google.ima.AdEvent.Type.CONTENT_PAUSE_REQUESTED,function(c){ys(a,c)});a.h.D(a.g,google.ima.AdEvent.Type.STARTED,function(c){ys(a,c)});a.h.D(a.g,google.ima.AdEvent.Type.FIRST_QUARTILE,function(c){b(c,"ad-first-quartile")});a.h.D(a.g,google.ima.AdEvent.Type.MIDPOINT,function(c){b(c,"ad-midpoint")});a.h.D(a.g,google.ima.AdEvent.Type.THIRD_QUARTILE,
function(c){b(c,"ad-third-quartile")});a.h.D(a.g,google.ima.AdEvent.Type.COMPLETE,function(c){b(c,"ad-complete")});a.h.D(a.g,google.ima.AdEvent.Type.CONTENT_RESUME_REQUESTED,function(c){ws(a,c)});a.h.D(a.g,google.ima.AdEvent.Type.ALL_ADS_COMPLETED,function(c){b(c,"all-ads-completed");ws(a,c)});a.h.D(a.g,google.ima.AdEvent.Type.SKIPPED,function(c){b(c,"ad-skipped")});a.h.D(a.g,google.ima.AdEvent.Type.VOLUME_CHANGED,function(c){b(c,"ad-volume-changed")});a.h.D(a.g,google.ima.AdEvent.Type.VOLUME_MUTED,
function(c){b(c,"ad-muted")});a.h.D(a.g,google.ima.AdEvent.Type.PAUSED,function(c){a.j&&(a.j.i=!0,b(c,"ad-paused"))});a.h.D(a.g,google.ima.AdEvent.Type.RESUMED,function(c){a.j&&(a.j.i=!1,b(c,"ad-resumed"))});a.h.D(a.g,google.ima.AdEvent.Type.SKIPPABLE_STATE_CHANGED,function(c){a.j&&b(c,"ad-skip-state-changed")});a.h.D(a.g,google.ima.AdEvent.Type.CLICK,function(c){b(c,"ad-clicked")});a.h.D(a.g,google.ima.AdEvent.Type.AD_PROGRESS,function(c){b(c,"ad-progress")});a.h.D(a.g,google.ima.AdEvent.Type.AD_BUFFERING,
function(c){b(c,"ad-buffering")});a.h.D(a.g,google.ima.AdEvent.Type.IMPRESSION,function(c){b(c,"ad-impression")});a.h.D(a.g,google.ima.AdEvent.Type.DURATION_CHANGE,function(c){b(c,"ad-duration-changed")});a.h.D(a.g,google.ima.AdEvent.Type.USER_CLOSE,function(c){b(c,"ad-closed")});a.h.D(a.g,google.ima.AdEvent.Type.LOADED,function(c){b(c,"ad-loaded")});a.h.D(a.g,google.ima.AdEvent.Type.LINEAR_CHANGED,function(c){b(c,"ad-linear-changed")});a.h.D(a.g,google.ima.AdEvent.Type.AD_METADATA,function(c){b(c,
"ad-metadata")});a.h.D(a.g,google.ima.AdEvent.Type.LOG,function(c){b(c,"ad-recoverable-error")});a.h.D(a.g,google.ima.AdEvent.Type.AD_BREAK_READY,function(c){b(c,"ad-break-ready")});a.h.D(a.g,google.ima.AdEvent.Type.INTERACTION,function(c){b(c,"ad-interaction")})}
function ys(a,b){var c=b.getAd();c?(a.j=new os(c,a.g,a.i),b.type!=google.ima.AdEvent.Type.CONTENT_PAUSE_REQUESTED||a.o.supportsMultipleMediaElements||a.l(new V("ad-content-pause-requested")),b=(new Map).set("ad",a.j).set("sdkAdObject",c).set("originalEvent",b),a.l(new V("ad-started",b)),a.j.isLinear()&&(a.u.setAttribute("ad-active","true"),a.o.customPlayheadTracker||a.i.pause(),a.i.muted?(b=a.j,b.j=a.i.volume,b.h.setVolume(0)):a.j.setVolume(a.i.volume))):$a("The IMA SDK fired a "+b.type+" event with no associated ad. Unable to play ad!")}
function ws(a,b){b&&b.type==google.ima.AdEvent.Type.CONTENT_RESUME_REQUESTED&&!a.o.supportsMultipleMediaElements&&a.l(new V("ad-content-resume-requested"));a.l(new V("ad-stopped",(new Map).set("originalEvent",b)));a.j&&a.j.isLinear()&&(a.u.removeAttribute("ad-active"),a.o.customPlayheadTracker||a.i.ended||a.i.play())};function zs(a,b,c,d,e,f){this.g=a;this.h=b;this.j=(this.i=b.isSkippable)?b.skipOffset||0:b.skipOffset;this.l=b.skipFor;this.B=c;this.o=d;this.m=e;this.u=f;this.C=b.overlay}p=zs.prototype;p.needsSkipUI=function(){return!0};p.isClientRendering=function(){return!0};p.hasCustomClick=function(){return this.h.clickThroughUrl!=null};p.isUsingAnotherMediaElement=function(){return this.u};p.getDuration=function(){var a=this.g.duration;return isNaN(a)?-1:a};p.getMinSuggestedDuration=function(){return this.getDuration()};
p.getRemainingTime=function(){var a=this.g.duration;return isNaN(a)?-1:a-this.g.currentTime};p.isPaused=function(){return this.g.paused};p.isSkippable=function(){return this.i&&this.l!=null?this.getDuration()-this.getRemainingTime()<this.j+this.l:this.i};p.getTimeUntilSkippable=function(){if(this.isSkippable()){var a=this.getRemainingTime()+this.j-this.getDuration();return Math.max(a,0)}return Math.max(this.getRemainingTime(),0)};
p.canSkipNow=function(){return this.i&&this.getTimeUntilSkippable()==0};p.skip=function(){this.canSkipNow()&&this.B()};p.pause=function(){return this.g.pause()};p.play=function(){return this.g.play()};p.getVolume=function(){return this.g.volume};p.setVolume=function(a){this.g.volume=a};p.isMuted=function(){return this.g.muted};p.isLinear=function(){return this.C==null};p.resize=function(){};p.setMuted=function(a){this.g.muted=a};p.getSequenceLength=function(){return this.o};
p.getPositionInSequence=function(){return this.m};p.getTitle=function(){return""};p.getDescription=function(){return""};p.getVastMediaBitrate=function(){return 0};p.getVastMediaHeight=function(){return 0};p.getVastMediaWidth=function(){return 0};p.getVastAdId=function(){return""};p.getAdId=function(){return this.h.id||""};p.getCreativeAdId=function(){return""};p.getAdvertiserName=function(){return""};p.getMediaUrl=function(){return this.h.uri};
p.getTimeOffset=function(){return this.h.pre?0:this.h.post?-1:this.h.startTime};p.getPodIndex=function(){return 0};p.release=function(){this.g=null};T("shaka.ads.InterstitialAd",zs);zs.prototype.release=zs.prototype.release;zs.prototype.getPodIndex=zs.prototype.getPodIndex;zs.prototype.getTimeOffset=zs.prototype.getTimeOffset;zs.prototype.getMediaUrl=zs.prototype.getMediaUrl;zs.prototype.getAdvertiserName=zs.prototype.getAdvertiserName;zs.prototype.getCreativeAdId=zs.prototype.getCreativeAdId;
zs.prototype.getAdId=zs.prototype.getAdId;zs.prototype.getVastAdId=zs.prototype.getVastAdId;zs.prototype.getVastMediaWidth=zs.prototype.getVastMediaWidth;zs.prototype.getVastMediaHeight=zs.prototype.getVastMediaHeight;zs.prototype.getVastMediaBitrate=zs.prototype.getVastMediaBitrate;zs.prototype.getDescription=zs.prototype.getDescription;zs.prototype.getTitle=zs.prototype.getTitle;zs.prototype.getPositionInSequence=zs.prototype.getPositionInSequence;zs.prototype.getSequenceLength=zs.prototype.getSequenceLength;
zs.prototype.setMuted=zs.prototype.setMuted;zs.prototype.resize=zs.prototype.resize;zs.prototype.isLinear=zs.prototype.isLinear;zs.prototype.isMuted=zs.prototype.isMuted;zs.prototype.setVolume=zs.prototype.setVolume;zs.prototype.getVolume=zs.prototype.getVolume;zs.prototype.play=zs.prototype.play;zs.prototype.pause=zs.prototype.pause;zs.prototype.skip=zs.prototype.skip;zs.prototype.canSkipNow=zs.prototype.canSkipNow;zs.prototype.getTimeUntilSkippable=zs.prototype.getTimeUntilSkippable;
zs.prototype.isSkippable=zs.prototype.isSkippable;zs.prototype.isPaused=zs.prototype.isPaused;zs.prototype.getRemainingTime=zs.prototype.getRemainingTime;zs.prototype.getMinSuggestedDuration=zs.prototype.getMinSuggestedDuration;zs.prototype.getDuration=zs.prototype.getDuration;zs.prototype.isUsingAnotherMediaElement=zs.prototype.isUsingAnotherMediaElement;zs.prototype.hasCustomClick=zs.prototype.hasCustomClick;zs.prototype.isClientRendering=zs.prototype.isClientRendering;
zs.prototype.needsSkipUI=zs.prototype.needsSkipUI;function As(a,b,c){this.g=a;this.j=b;this.h=c;this.i=a.overlay==null}p=As.prototype;p.needsSkipUI=function(){return!0};p.isClientRendering=function(){return!0};p.hasCustomClick=function(){return this.g.clickThroughUrl!=null};p.isUsingAnotherMediaElement=function(){return!1};p.getDuration=function(){return-1};p.getMinSuggestedDuration=function(){return this.getDuration()};p.getRemainingTime=function(){return-1};p.isPaused=function(){return!1};p.isSkippable=function(){return!1};
p.getTimeUntilSkippable=function(){return 0};p.canSkipNow=function(){return!1};p.skip=function(){};p.pause=function(){};p.play=function(){};p.getVolume=function(){return 1};p.setVolume=function(){};p.isMuted=function(){return!1};p.isLinear=function(){return this.i};p.resize=function(){};p.setMuted=function(){};p.getSequenceLength=function(){return this.j};p.getPositionInSequence=function(){return this.h};p.getTitle=function(){return""};p.getDescription=function(){return""};p.getVastMediaBitrate=function(){return 0};
p.getVastMediaHeight=function(){return 0};p.getVastMediaWidth=function(){return 0};p.getVastAdId=function(){return""};p.getAdId=function(){return this.g.id||""};p.getCreativeAdId=function(){return""};p.getAdvertiserName=function(){return""};p.getMediaUrl=function(){return this.g.uri};p.getTimeOffset=function(){return this.g.pre?0:this.g.post?-1:this.g.startTime};p.getPodIndex=function(){return 0};p.release=function(){};T("shaka.ads.InterstitialStaticAd",As);As.prototype.release=As.prototype.release;
As.prototype.getPodIndex=As.prototype.getPodIndex;As.prototype.getTimeOffset=As.prototype.getTimeOffset;As.prototype.getMediaUrl=As.prototype.getMediaUrl;As.prototype.getAdvertiserName=As.prototype.getAdvertiserName;As.prototype.getCreativeAdId=As.prototype.getCreativeAdId;As.prototype.getAdId=As.prototype.getAdId;As.prototype.getVastAdId=As.prototype.getVastAdId;As.prototype.getVastMediaWidth=As.prototype.getVastMediaWidth;As.prototype.getVastMediaHeight=As.prototype.getVastMediaHeight;
As.prototype.getVastMediaBitrate=As.prototype.getVastMediaBitrate;As.prototype.getDescription=As.prototype.getDescription;As.prototype.getTitle=As.prototype.getTitle;As.prototype.getPositionInSequence=As.prototype.getPositionInSequence;As.prototype.getSequenceLength=As.prototype.getSequenceLength;As.prototype.setMuted=As.prototype.setMuted;As.prototype.resize=As.prototype.resize;As.prototype.isLinear=As.prototype.isLinear;As.prototype.isMuted=As.prototype.isMuted;As.prototype.setVolume=As.prototype.setVolume;
As.prototype.getVolume=As.prototype.getVolume;As.prototype.play=As.prototype.play;As.prototype.pause=As.prototype.pause;As.prototype.skip=As.prototype.skip;As.prototype.canSkipNow=As.prototype.canSkipNow;As.prototype.getTimeUntilSkippable=As.prototype.getTimeUntilSkippable;As.prototype.isSkippable=As.prototype.isSkippable;As.prototype.isPaused=As.prototype.isPaused;As.prototype.getRemainingTime=As.prototype.getRemainingTime;As.prototype.getMinSuggestedDuration=As.prototype.getMinSuggestedDuration;
As.prototype.getDuration=As.prototype.getDuration;As.prototype.isUsingAnotherMediaElement=As.prototype.isUsingAnotherMediaElement;As.prototype.hasCustomClick=As.prototype.hasCustomClick;As.prototype.isClientRendering=As.prototype.isClientRendering;As.prototype.needsSkipUI=As.prototype.needsSkipUI;function Bs(a,b,c,d){function e(g){return g?g.overlay?!0:f.g.ended?g.post:f.g.paused?!1:!0:!1}var f=this;this.M=null;this.m=a;this.C=b;this.g=c;this.G=null;this.u=!0;this.h=this.g;this.va=d;this.ma=new Set;this.T=new Set;this.H=new Set;this.F=new Map;this.K=new Map;this.i=new X;Cs(this);this.I=new kb;this.j=new kb;this.J=!1;this.$=this.o=this.B=this.l=null;this.ba=!1;this.O=-1;this.X=function(){if(!f.J&&f.l&&!f.C.xa()){f.l=f.g.currentTime;var g=Ds(f);g&&e(g)&&Es(f,g,1,1,Date.now())}};this.V=function(){if(!(f.J||
f.l||f.C.xa())){f.g.paused||(f.l=f.g.currentTime);var g=Ds(f,!0);g||(g=Ds(f));g&&e(g)&&Es(f,g,1,1,Date.now())}};this.oa=function(){if(!f.J&&f.l&&!f.C.xa()){var g=f.g.currentTime;f.B&&!f.B.pre&&!f.B.post&&g<(f.B.endTime||f.B.startTime)&&(f.B=null)}};this.R=new rf(this.X);this.N=new rf(function(){var g,h,k,l,m,n,q,r,t,v,w;return O(function(z){switch(z.g){case 1:if(!f.H.size||f.l==null){z.A(0);break}g=f.C.$d();if(g==Rq||g==Hq)return z.return();h=!1;k=Array.from(f.H);l=f.C.Ra();m=u(k);n=m.next();case 3:if(n.done){z.A(5);
break}q=n.value;if(q==f.B){z.A(4);break}r=q.endTime||q.startTime;if(!(l.start-r>=1)){t=q.startTime-f.l;t>0&&t<=10&&(!f.F.has(q)&&Fs(q)&&f.F.set(q,f.i.preload(q.uri,null,q.mimeType||void 0)),Gs(f,q));z.A(4);break}if(!f.F.has(q)){z.A(7);break}return G(z,f.F.get(q),8);case 8:(v=z.h)&&v.destroy(),f.F.delete(q);case 7:Hs(f,q),w=q.id||JSON.stringify(q),f.T.has(w)&&f.T.delete(w),f.H.delete(q),Is(f),q.overlay||(h=!0);case 4:n=m.next();z.A(3);break;case 5:h&&Js(f),H(z)}})});this.configure(this.C.getConfiguration().ads)}
p=Bs.prototype;p.configure=function(a){this.M=a;this.J||Ks(this)};function Ls(a){if(!a.ba&&a.H.size){a.I.D(a.g,"playing",a.V);a.I.D(a.g,"timeupdate",a.V);a.I.D(a.g,"seeked",a.oa);a.I.D(a.g,"ended",a.X);if("requestVideoFrameCallback"in a.g&&!Ms()){var b=a.g,c=function(){a.O!=-1&&(a.X(),a.O!=-1&&(a.O=b.requestVideoFrameCallback(c)))};a.O=b.requestVideoFrameCallback(c)}else a.R.Ea(.025);a.N&&a.N.Ea(1);a.ba=!0}}
function Is(a){a.ba&&!a.H.size&&(a.I.Ma(a.g,"playing",a.V),a.I.Ma(a.g,"timeupdate",a.V),a.I.Ma(a.g,"seeked",a.oa),a.I.Ma(a.g,"ended",a.X),a.O!=-1&&(a.g.cancelVideoFrameCallback(a.O),a.O=-1),a.R&&a.R.stop(),a.N&&a.N.stop(),a.ba=!1)}
function Ks(a){if(a.m&&a.M){var b=a.M.supportsMultipleMediaElements,c=a.g;c.controls?b=!1:c.webkitPresentationMode&&c.webkitPresentationMode!=="inline"?b=!1:c.webkitDisplayingFullscreen&&(b=!1);a.u==b&&(a.u=!b,a.u?(a.h=a.g,a.G&&(a.G.parentElement&&a.m.removeChild(a.G),a.G=null)):(a.G||(b=document.createElement(a.g.tagName),b.autoplay=!0,b.style.position="absolute",b.style.top="0",b.style.left="0",b.style.width="100%",b.style.height="100%",b.style.display="none",b.setAttribute("playsinline",""),a.G=
b),a.h=a.G))}else a.u=!0}
p.stop=function(){this.j&&this.j.Qa();this.ma.clear();this.T.clear();this.H.clear();this.i.rg();if(this.F.size){var a=Array.from(this.F.values());a=u(a);for(var b=a.next();!b.done;b=a.next())(b=b.value)&&b.then(function(c){c&&c.destroy()})}this.F.clear();if(this.K.size)for(a=Array.from(this.K.keys()),a=u(a),b=a.next();!b.done;b=a.next())Hs(this,b.value);this.K.clear();this.i.detach();this.J=!1;this.B=this.l=null;this.u=!0;this.h=this.g;this.G=null;Ns(this);Is(this);this.m&&Nj(this.m);this.o&&(this.o.stop(),
this.o=null)};p.release=function(){this.stop();this.I&&this.I.release();this.j&&this.j.release();this.R&&(this.R.stop(),this.R=null);this.N&&(this.N.stop(),this.N=null);this.i.destroy()};p.td=function(){return this.i};
function Os(a,b){var c,d,e;O(function(f){if(f.g==1){c=null;if(d=b.values.find(function(g){return g.key=="ID"}))c=d.data;if(c){if(a.ma.has(c))return f.return();a.ma.add(c)}Cs(a);e=[];return b&&b.values.find(function(g){return g.key=="X-OVERLAY-ID"})?(e=Ps(b),f.A(2)):G(f,Qs(a,b),3)}f.g!=2&&(e=f.h);e.length?Rs(a,e):$a("Unsupported HLS interstitial",b);H(f)})}
function Ss(a,b){var c=Ld(b.eventNode,"OverlayEvent"),d=c.attributes.uri,e=c.attributes.mimeType,f=c.attributes.loop=="true",g=Od(c,"z",Vd);if(d&&g!=0){var h=null,k=Ld(c,"Background");if(k){var l=k.attributes.uri;l?h="center / contain no-repeat url('"+l+"')":h=Jd(k)}k=1920;l=1080;var m=Ld(c,"Viewport");if(m){k=Od(m,"x",Vd);if(k==null)return;l=Od(m,"y",Vd);if(l==null)return}var n={viewport:{x:k,y:l},topLeft:{x:0,y:0},size:{x:k,y:l}},q=Ld(c,"Overlay");if(m&&q){var r=Ld(q,"TopLeft"),t=Ld(q,"Size");if(r&&
t){q=Od(r,"x",Vd);if(q==null)return;r=Od(r,"y",Vd);if(r==null)return;var v=Od(t,"x",Vd);if(v==null)return;t=Od(t,"y",Vd);if(t==null)return;n.topLeft.x=q;n.topLeft.y=r;n.size.x=v;n.size.y=t}}q=null;c=Ld(c,"Squeeze");if(m&&c&&(t=Ld(c,"TopLeft"),c=Ld(c,"Size"),t&&c)){m=Od(t,"x",Vd);if(m==null)return;q=Od(t,"y",Vd);if(q==null)return;t=Od(c,"x",Vd);if(t==null)return;c=Od(c,"y",Vd);if(c==null)return;q={viewport:{x:k,y:l},topLeft:{x:m,y:q},size:{x:t,y:c}}}Rs(a,[{id:b.id,groupId:null,startTime:b.startTime,
endTime:b.endTime,uri:d,mimeType:e,isSkippable:!1,skipOffset:null,skipFor:null,canJump:!0,resumeOffset:null,playoutLimit:null,once:!1,pre:!1,post:!1,timelineRange:!0,loop:f,overlay:n,displayOnBackground:g==-1,currentVideo:q,background:h,clickThroughUrl:null}])}}
p.addAdUrlInterstitial=function(a){var b=this,c,d,e,f,g,h,k,l,m;return O(function(n){if(n.g==1)return c={type:12},G(n,Ts(b,a,c),2);if(n.g!=3){d=n.h;e=zd(d,"VAST,vmap:VMAP");if(!e)throw new U(2,10,10007);f=[];if(e.tagName=="VAST")return f=qs(e,b.l),n.A(3);if(e.tagName!="vmap:VMAP")return n.A(3);g=function(q){var r,t;return O(function(v){if(v.g==1)return G(v,Ts(b,q.uri,c),2);r=v.h;t=zd(r,"VAST");if(!t)throw new U(2,10,10007);f.push.apply(f,x(qs(t,q.time)));H(v)})};h=[];k=u(ss(e));for(l=k.next();!l.done;l=
k.next())m=l.value,h.push(g(m));return h.length?G(n,Promise.all(h),3):n.A(3)}Rs(b,f);H(n)})};
function Rs(a,b){var c,d,e,f,g,h,k,l;O(function(m){switch(m.g){case 1:c=!1,d=u(b),e=d.next();case 2:if(e.done){m.A(4);break}f=e.value;if(!f.uri){$a("Missing URL in interstitial",f);m.A(3);break}if(f.mimeType){m.A(5);break}sa(m,6);g=a.i.Yb();return G(m,Em(f.uri,g,a.C.getConfiguration().streaming.retryParameters),8);case 8:f.mimeType=m.h;ua(m,5);break;case 6:Aa(m);case 5:h=f.id||JSON.stringify(f);if(a.T.has(h)){m.A(3);break}f.loop&&!f.overlay&&$a("Loop is only supported in overlay interstitials",f);
f.overlay||(c=!0);a.T.add(h);a.H.add(f);k=!1;f.pre&&a.l==null?k=!0:f.startTime!=0||f.canJump?a.l!=null&&(l=f.startTime-a.l,l>0&&l<=10&&(k=!0)):k=!0;k&&(!a.F.has(f)&&Fs(f)&&a.F.set(f,a.i.preload(f.uri,null,f.mimeType||void 0)),Gs(a,f));case 3:e=d.next();m.A(2);break;case 4:c&&Js(a),Ls(a),H(m)}})}
function Ds(a,b,c){b=b===void 0?!1:b;c=c===void 0?null:c;var d=0,e=null;if(a.H.size&&a.l!=null){var f=a.g.ended,g=Array.from(a.H).sort(function(n,q){return q.startTime-n.startTime}),h=g;h=b?g.filter(function(n){return n.pre}):f?g.filter(function(n){return n.post}):g.filter(function(n){return!n.pre&&!n.post});g=u(h);for(h=g.next();!h.done;h=g.next()){h=h.value;var k=!1;if(b)k=h.pre;else if(f)k=h.post;else if(!h.pre&&!h.post){var l=a.l-Math.round(h.startTime*1E3)/1E3,m=1;a.M.allowStartInMiddleOfInterstitial&&
h.endTime&&h.endTime!=Infinity&&(m=h.endTime-h.startTime);(l>0||l==0&&a.l==0)&&(l<=m||!h.canJump)&&(k=c==null&&a.B&&!a.B.pre&&!a.B.post&&a.B.startTime>=h.startTime?!1:!0)}k&&(!a.B||h.startTime>=a.B.startTime)&&(d==(c||0)?e=h:e&&!h.canJump&&Math.round(h.startTime*1E3)/1E3-Math.round(e.startTime*1E3)/1E3>.001&&(e=h,d=0),d++)}}return e}
function Es(a,b,c,d,e,f){f=f===void 0?0:f;a.B=b;Ks(a);a.u||!a.m||a.h.parentElement||a.m.appendChild(a.h);d==1&&c==1&&(c=Array.from(a.H).filter(function(g){return b.pre?g.pre==b.pre:b.post?g.post==b.post:Math.abs(g.startTime-b.startTime)<.001}).length);b.once&&(f++,a.H.delete(b),Is(a),b.overlay||Js(a));b.mimeType&&(b.mimeType.startsWith("image/")||b.mimeType==="text/html")?b.overlay?Us(a,b,c,d,f):$a("Unsupported interstitial",b):a.u&&b.overlay?$a("Unsupported interstitial",b):Vs(a,b,c,d,e,f)}
function Us(a,b,c,d,e){function f(){a.o&&(a.o.stop(),a.o=null);a.m.removeChild(k);Ns(a,b);Ws(a,"ad-stopped");a.j.Qa();var q=Ds(a,b.pre,d-e);q?Es(a,q,c,++d,Date.now(),e):a.J=!1}a.J=!0;var g=b.overlay,h=b.mimeType=="text/html"?"iframe":"img",k=document.createElement(h);k.style.objectFit="contain";k.style.position="absolute";k.style.border="none";Xs(a,b);var l=new As(b,c,d);Ws(a,"ad-impression");Ws(a,"ad-started",(new Map).set("ad",l));h=="iframe"?k.src=b.uri:(k.src=b.uri,k.onerror=function(q){Ws(a,
"ad-error",(new Map).set("originalEvent",q));f()});l=g.viewport;var m=g.topLeft;g=g.size;l.x==0&&l.y==0?(k.width=b.overlay.size.x,k.height=b.overlay.size.y,k.style.bottom="10%",k.style.left="0",k.style.right="0",k.style.width="100%",b.overlay.size.y||h!="iframe"||(k.style.height="auto")):(k.style.height=g.y/l.y*100+"%",k.style.left=m.x/l.x*100+"%",k.style.top=m.y/l.y*100+"%",k.style.width=g.x/l.x*100+"%");a.m.appendChild(k);var n=Date.now();a.o&&a.o.stop();a.o=new rf(function(){b.playoutLimit&&(Date.now()-
n)/1E3>b.playoutLimit?(Ws(a,"ad-complete"),f()):b.endTime&&a.g.currentTime>b.endTime?(Ws(a,"ad-complete"),f()):a.g.currentTime<b.startTime&&(Ws(a,"ad-skipped"),f())});b.playoutLimit&&!b.endTime?a.o.ka(b.playoutLimit):b.endTime&&a.o.Ea(.025);a.j.D(a.g,"seeked",function(){var q=a.g.currentTime;if(q<b.startTime||b.endTime&&q>b.endTime)a.o&&a.o.stop(),Ws(a,"ad-skipped"),f()});b.clickThroughUrl&&a.j.D(k,"click",function(){b.clickThroughUrl&&window.open(b.clickThroughUrl,"_blank")})}
function Vs(a,b,c,d,e,f){var g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F;O(function(L){switch(L.g){case 1:g=Date.now();a.J=!0;h=!1;k=function(){if(!a.u&&!b.overlay&&b.resumeOffset==null)if(b.timelineRange&&b.endTime&&b.endTime!=Infinity)a.g.currentTime!=b.endTime&&(a.g.currentTime=b.endTime);else{var K=Date.now();a.g.currentTime+=(K-e)/1E3;e=K}};l=function(K){var P,Q;return O(function(N){if(N.g==1){k();P=Ds(a,b.pre,d-f);if(K&&b.groupId)for(;P&&P.groupId==b.groupId;)d++,P=Ds(a,b.pre,d-f);a.o&&(!b.groupId||
P&&P.groupId!=b.groupId)&&(a.o.stop(),a.o=null);Ns(a,b);if(P&&!P.overlay)return N.A(2);b.post&&(a.l=null,a.B=null);return a.u?G(N,a.i.detach(),4):G(N,a.i.Cc(),4)}N.g!=2&&(a.u&&(Q=b.resumeOffset,Q==null&&(Q=b.timelineRange&&b.endTime&&b.endTime!=Infinity?b.endTime-(a.l||0):(Date.now()-e)/1E3),Ws(a,"ad-content-resume-requested",(new Map).set("offset",Q))),Ws(a,"ad-stopped"),a.j.Qa(),a.J=!1,a.u?Js(a):(a.h.style.display="none",k(),a.g.ended||a.g.play()));Ks(a);P&&(Ws(a,"ad-stopped"),a.j.Qa(),Es(a,P,c,
++d,e,f));H(N)})};m=function(K){return O(function(P){if(h)return P.return();h=!0;Ws(a,"ad-error",(new Map).set("originalEvent",K));return G(P,l(!1),0)})};n=function(){return O(function(K){if(K.g==1){if(h)return K.return();h=!0;return G(K,l(!1),2)}Ws(a,"ad-complete");H(K)})};a.$=function(){return O(function(K){if(h)return K.return();h=!0;Ws(a,"ad-skipped");return G(K,l(!0),0)})};q=new zs(a.h,b,a.$,c,d,!a.u);a.u||(q.setMuted(a.g.muted),q.setVolume(a.g.volume));Ws(a,"ad-started",(new Map).set("ad",q));
(r=q.canSkipNow())&&Ws(a,"ad-skip-state-changed");a.j.Aa(a.i,"error",m);a.j.D(a.h,"timeupdate",function(){if(a.h.duration){var K=q.canSkipNow();r!=K&&q.getRemainingTime()>0&&q.getDuration()>0&&Ws(a,"ad-skip-state-changed");r=K;!a.u&&!b.overlay&&b.resumeOffset==null&&b.timelineRange&&b.endTime&&b.endTime!=Infinity&&a.g.currentTime!=b.endTime&&a.C.Ra().end>=b.endTime&&(a.g.currentTime=b.endTime)}});a.j.Aa(a.i,"firstquartile",function(){k();Ws(a,"ad-first-quartile")});a.j.Aa(a.i,"midpoint",function(){k();
Ws(a,"ad-midpoint")});a.j.Aa(a.i,"thirdquartile",function(){k();Ws(a,"ad-third-quartile")});a.j.Aa(a.i,"complete",n);a.j.D(a.h,"play",function(){Ws(a,"ad-resumed")});a.j.D(a.h,"pause",function(){var K=a.i.getConfiguration();a.h.currentTime>=K.playRangeEnd?n():Ws(a,"ad-paused")});a.j.D(a.h,"volumechange",function(){a.h.muted?Ws(a,"ad-muted"):Ws(a,"ad-volume-changed")});b.clickThroughUrl&&(t=a.m||a.h,a.j.D(t,"click",function(){b.clickThroughUrl&&(q.isPaused()||q.pause(),window.open(b.clickThroughUrl,
"_blank"))}));if(!a.u||d!=1){L.A(2);break}Ws(a,"ad-content-pause-requested",(new Map).set("saveLivePosition",!0));v=new Hg;w=function(K){return O(function(P){if(P.g==1)return K.state!="detach"?P.A(0):Ms()?G(P,new Promise(function(Q){return(new rf(Q)).ka(.1)}),3):P.A(3);v.resolve();a.j.Ma(a.C,"onstatechange",w);H(P)})};a.j.D(a.C,"onstatechange",w);return G(L,v,2);case 2:return Xs(a,b),a.u||(a.h.style.display="",b.overlay?(a.h.loop=b.loop,z=b.overlay.viewport,y=b.overlay.topLeft,A=b.overlay.size,a.h.style.height=
A.y/z.y*100+"%",a.h.style.left=y.x/z.x*100+"%",a.h.style.top=y.y/z.y*100+"%",a.h.style.width=A.x/z.x*100+"%"):(a.g.pause(),b.resumeOffset!=null&&b.resumeOffset!=0&&(a.g.currentTime+=b.resumeOffset),a.h.loop=!1,a.h.style.height="100%",a.h.style.left="0",a.h.style.top="0",a.h.style.width="100%")),sa(L,4),Cs(a),b.startTime&&b.endTime&&b.endTime!=Infinity&&b.startTime!=b.endTime&&(E=b.endTime-b.startTime,E>0&&a.i.configure("playRangeEnd",E)),b.playoutLimit&&!a.o&&(a.o=(new rf(function(){a.$()})).ka(b.playoutLimit),
a.i.configure("playRangeEnd",b.playoutLimit)),G(L,a.i.Vb(a.h),6);case 6:return I=null,b.pre||b.post||!a.M.allowStartInMiddleOfInterstitial||a.l==null||(D=a.l-b.startTime,Math.abs(D)>.25&&(I=D)),a.F.has(b)?G(L,a.F.get(b),10):G(L,a.i.load(b.uri,I,b.mimeType||void 0),8);case 10:return C=L.h,a.F.delete(b),C?G(L,a.i.load(C),8):G(L,a.i.load(b.uri,I,b.mimeType||void 0),8);case 8:b.overlay&&a.g.paused?a.h.pause():a.h.play();B=(Date.now()-g)/1E3;Ws(a,"ads-loaded",(new Map).set("loadTime",B));a.u&&a.g.play();
b.overlay&&(b.pre||b.post||a.C.W()&&!(b.startTime>0)||(J=function(){var K=a.g.currentTime-b.startTime;Math.abs(K-a.h.currentTime)>.1&&(a.h.currentTime=K)},a.j.Aa(a.h,"playing",J),a.j.D(a.g,"seeking",J)),a.j.D(a.g,"seeked",function(){var K=a.g.currentTime;(K<b.startTime||b.endTime&&K>b.endTime)&&a.$()}));ua(L,0);break;case 4:F=Aa(L);if(!a.J)return L.return();m(F);H(L)}})}
function Xs(a,b){b.displayOnBackground&&(a.g.style.zIndex="1");if(b.currentVideo!=null){var c=b.currentVideo;a.g.style.transformOrigin="top left";var d=!0,e=[],f=c.topLeft.x/c.viewport.x*100;f>0&&f<=100&&(e.push("translateX("+f+"%)"),d=!1);f=c.topLeft.y/c.viewport.y*100;f>0&&f<=100&&(e.push("translateY("+f+"%)"),d=!1);f=c.size.x/c.viewport.x;f<1&&e.push("scaleX("+f+")");c=c.size.y/c.viewport.y;f<1&&e.push("scaleY("+c+")");e.length&&(a.g.style.transform=e.join(" "));d&&(a.g.style.transition="transform 250ms")}a.m&&
(b.clickThroughUrl?(a.m.setAttribute("ad-active","true"),a.m.style.pointerEvents=""):a.m.style.pointerEvents="none",b.background&&(a.m.style.background=b.background));a.G&&(a.G.style.background=b.overlay?"":"rgb(0, 0, 0)")}
function Ns(a,b){if(!b||b.displayOnBackground)a.g.style.zIndex="";b&&b.currentVideo==null||(a.g.style.transformOrigin="",a.g.style.transition="",a.g.style.transform="");a.m&&(a.m.removeAttribute("ad-active"),a.m.style.pointerEvents="",!b||b.background)&&(a.m.style.background="");a.G&&(a.G.style.background="")}
function Qs(a,b){var c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q,N,M,R,S,ka,Y,Ca,ya,wa,Da,xa,Ja,ra;return O(function(Fa){switch(Fa.g){case 1:c=[];if(!b)return Fa.return(c);d=b.values.find(function(va){return va.key=="X-ASSET-URI"});e=b.values.find(function(va){return va.key=="X-ASSET-LIST"});if(!d&&!e)return Fa.return(c);f=null;if(g=b.values.find(function(va){return va.key=="ID"}))f=g.data;h=f==null?Math.floor(b.startTime*10)/10:b.startTime;(k=b.endTime)&&b.endTime!=Infinity&&typeof b.endTime==
"number"&&(k=f==null?Math.floor(b.endTime*10)/10:b.endTime);l=b.values.find(function(va){return va.key=="X-RESTRICT"});n=m=!0;l&&l.data&&(q=l.data,m=!q.includes("SKIP"),n=!q.includes("JUMP"));r=m?0:null;if(t=b.values.find(function(va){return va.key=="X-ENABLE-SKIP-AFTER"}))v=t.data,r=parseFloat(v),isNaN(r)&&(r=m?0:null);w=null;if(z=b.values.find(function(va){return va.key=="X-ENABLE-SKIP-FOR"}))y=z.data,w=parseFloat(y),isNaN(r)&&(w=null);A=null;if(E=b.values.find(function(va){return va.key=="X-RESUME-OFFSET"}))I=
E.data,A=parseFloat(I),isNaN(A)&&(A=null);D=null;if(C=b.values.find(function(va){return va.key=="X-PLAYOUT-LIMIT"}))B=C.data,D=parseFloat(B),isNaN(D)&&(D=null);L=F=J=!1;if(K=b.values.find(function(va){return va.key=="CUE"}))P=K.data,J=P.includes("ONCE"),F=P.includes("PRE"),L=P.includes("POST");Q=!1;(N=b.values.find(function(va){return va.key=="X-TIMELINE-OCCUPIES"}))?(M=N.data,Q=M.includes("RANGE")):!E&&a.C.W()&&(Q=!F&&!L);if(d){R=d.data;if(!R)return Fa.return(c);c.push({id:f,groupId:null,startTime:h,
endTime:k,uri:R,mimeType:null,isSkippable:m,skipOffset:r,skipFor:w,canJump:n,resumeOffset:A,playoutLimit:D,once:J,pre:F,post:L,timelineRange:Q,loop:!1,overlay:null,displayOnBackground:!1,currentVideo:null,background:null,clickThroughUrl:null});Fa.A(2);break}if(!e){Fa.A(2);break}S=e.data;if(!S)return Fa.return(c);sa(Fa,4);ka={type:11};return G(Fa,Ts(a,S,ka),6);case 6:Y=Fa.h;Ca=oc(Y);ya=JSON.parse(Ca);if(wa=ya["SKIP-CONTROL"])Da=wa["ENABLE-SKIP-AFTER"],typeof Da=="number"&&(r=parseFloat(Da),isNaN(Da)&&
(r=m?0:null)),xa=wa["ENABLE-SKIP-FOR"],typeof xa=="number"&&(w=parseFloat(xa),isNaN(xa)&&(w=null));for(Ja=0;Ja<ya.ASSETS.length;Ja++)ra=ya.ASSETS[Ja],ra.URI&&c.push({id:f+"_shaka_asset_"+Ja,groupId:f,startTime:h,endTime:k,uri:ra.URI,mimeType:null,isSkippable:m,skipOffset:r,skipFor:w,canJump:n,resumeOffset:A,playoutLimit:D,once:J,pre:F,post:L,timelineRange:Q,loop:!1,overlay:null,displayOnBackground:!1,currentVideo:null,background:null,clickThroughUrl:null});ua(Fa,2);break;case 4:Aa(Fa);case 2:return Fa.return(c)}})}
function Ps(a){var b=[];if(!a)return b;var c=a.values.find(function(w){return w.key=="X-ASSET-URI"});if(!c)return b;c=c.data;if(!c)return b;var d=null,e=a.values.find(function(w){return w.key=="X-OVERLAY-ID"});e&&(d=e.data);e=d==null?Math.floor(a.startTime*10)/10:a.startTime;var f=a.endTime;a.endTime&&a.endTime!=Infinity&&typeof a.endTime=="number"&&(f=d==null?Math.floor(a.endTime*10)/10:a.endTime);var g=!1,h=!1,k=!1,l=a.values.find(function(w){return w.key=="CUE"});l&&(k=l.data,g=k.includes("ONCE"),
h=k.includes("PRE"),k=k.includes("POST"));l=null;var m=a.values.find(function(w){return w.key=="X-ASSET-MIMETYPE"});m&&(l=m.data);m=!1;var n=a.values.find(function(w){return w.key=="X-LOOP"});n&&(m=n.data=="YES");n=1;var q=a.values.find(function(w){return w.key=="X-DEPTH"});q&&(n=parseFloat(q.data),isNaN(n)&&(n=1));q=null;var r=a.values.find(function(w){return w.key=="X-BACKGROUND"});r&&(q=r.data);r=1920;var t=1080,v=a.values.find(function(w){return w.key=="X-VIEWPORT"});if(v){t=v.data.split("x");
if(t.length!=2)return b;r=parseFloat(t[0]);t=parseFloat(t[1])}r={viewport:{x:r,y:t},topLeft:{x:0,y:0},size:{x:r,y:t}};if(t=a.values.find(function(w){return w.key=="X-OVERLAY-POSITION"})){t=t.data.split("x");if(t.length!=2)return b;r.topLeft.x=parseFloat(t[0]);r.topLeft.y=parseFloat(t[1])}if(t=a.values.find(function(w){return w.key=="X-OVERLAY-SIZE"})){t=t.data.split("x");if(t.length!=2)return b;r.size.x=parseFloat(t[0]);r.size.y=parseFloat(t[1])}t=null;if(v=a.values.find(function(w){return w.key==
"X-SQUEEZECURRENT"}))if(t=parseFloat(v.data),isNaN(t)&&(t=1),t={viewport:{x:1920,y:1080},topLeft:{x:0,y:0},size:{x:1920*t,y:1080*t}},a=a.values.find(function(w){return w.key=="X-SQUEEZECURRENT-POSITION"})){a=a.data.split("x");if(a.length!=2)return b;t.topLeft.x=parseFloat(a[0]);t.topLeft.y=parseFloat(a[1])}b.push({id:d,groupId:null,startTime:e,endTime:f,uri:c,mimeType:l,isSkippable:!1,skipOffset:null,skipFor:null,canJump:!0,resumeOffset:null,playoutLimit:null,once:g,pre:h,post:k,timelineRange:!0,
loop:m,overlay:r,displayOnBackground:n==-1,currentVideo:t,background:q,clickThroughUrl:null});return b}
function Js(a){for(var b=[],c=u(a.H),d=c.next(),e={};!d.done;e={Bc:void 0},d=c.next())d=d.value,d.overlay||(e.Bc={start:d.startTime,end:null},d.pre?(e.Bc.start=0,e.Bc.end=null):d.post?(e.Bc.start=-1,e.Bc.end=null):d.timelineRange&&(e.Bc.end=d.endTime),b.find(function(f){return function(g){return f.Bc.start==g.start&&f.Bc.end==g.end}}(e))||b.push(e.Bc));Ws(a,"ad-cue-points-changed",(new Map).set("cuepoints",b))}
function Cs(a){a.i.configure(a.C.ki());a.i.configure("ads.disableHLSInterstitial",!0);a.i.configure("ads.disableDASHInterstitial",!0);a.i.configure("playRangeEnd",Infinity);Yg(a.C.Yb(),a.i.Yb())}function Ts(a,b,c){var d,e,f;return O(function(g){if(g.g==1)return d=Zg([b],Fg()),e=a.C.Yb().request(7,d,c),G(g,e.promise,2);f=g.h;return g.return(f.data)})}function Fs(a){return(a=a.mimeType)?!a.startsWith("image/")&&a!=="text/html":!0}
function Ms(){var a=rb().Oa();return a=="TV"||a=="CONSOLE"||a=="CAST"?!0:!1}function Gs(a,b){if(!(a.K.has(b)||a.M&&!a.M.allowPreloadOnDomElements)){var c=function(f){var g=document.createElement("link");g.rel="preload";g.href=f;g.as="image";document.head.appendChild(g);return g},d=[];if(b.background){var e=b.background.match(/url\(('|")?([^'"()]+)('|")\)?/);e&&d.push(c(e[2]))}b.mimeType&&b.mimeType.startsWith("image/")&&d.push(c(b.uri));a.K.set(b,d)}}
function Hs(a,b){if(a.K.has(b)){var c=a.K.get(b);c=u(c);for(var d=c.next();!d.done;d=c.next())d=d.value,d.parentNode.removeChild(d);a.K.delete(b)}}function Ws(a,b,c){a.va(new V(b,c))};function Ys(a,b,c,d,e){this.h=a;this.j=ud(this.h.skipOffset);this.g=e;this.i=b;this.l=c;this.o=d;this.m=!1}p=Ys.prototype;p.needsSkipUI=function(){return!0};p.isClientRendering=function(){return!1};p.hasCustomClick=function(){return!1};p.isUsingAnotherMediaElement=function(){return!1};p.getDuration=function(){return this.h.durationInSeconds};p.getMinSuggestedDuration=function(){return this.getDuration()};p.getRemainingTime=function(){return this.h.startTimeInSeconds+this.h.durationInSeconds-this.g.currentTime};
p.isPaused=function(){return this.g.paused};p.isSkippable=function(){return typeof this.j=="number"?!0:!1};p.getTimeUntilSkippable=function(){if(typeof this.j!="number")return this.getRemainingTime();var a=this.getRemainingTime()+this.j-this.getDuration();return Math.max(a,0)};p.canSkipNow=function(){return this.getTimeUntilSkippable()==0};p.skip=function(){this.m=!0;this.g.currentTime+=this.getRemainingTime()};p.pause=function(){return this.g.pause()};p.play=function(){return this.g.play()};
p.getVolume=function(){return this.g.volume};p.setVolume=function(a){this.g.volume=a};p.isMuted=function(){return this.g.muted};p.isLinear=function(){return this.o};p.resize=function(){};p.setMuted=function(a){this.g.muted=a};p.getSequenceLength=function(){return this.l?this.l:1};p.getPositionInSequence=function(){return this.i?this.i:1};p.getTitle=function(){return this.h.adTitle};p.getDescription=function(){return""};p.getVastMediaBitrate=function(){return 0};p.getVastMediaHeight=function(){return 0};
p.getVastMediaWidth=function(){return 0};p.getVastAdId=function(){return this.h.vastAdId||""};p.getAdId=function(){return this.h.adId};p.getCreativeAdId=function(){return this.h.creativeId};p.getAdvertiserName=function(){return""};p.getMediaUrl=function(){return null};p.getTimeOffset=function(){return 0};p.getPodIndex=function(){return 0};p.release=function(){this.l=this.i=this.g=this.h=null};T("shaka.ads.MediaTailorAd",Ys);Ys.prototype.release=Ys.prototype.release;Ys.prototype.getPodIndex=Ys.prototype.getPodIndex;
Ys.prototype.getTimeOffset=Ys.prototype.getTimeOffset;Ys.prototype.getMediaUrl=Ys.prototype.getMediaUrl;Ys.prototype.getAdvertiserName=Ys.prototype.getAdvertiserName;Ys.prototype.getCreativeAdId=Ys.prototype.getCreativeAdId;Ys.prototype.getAdId=Ys.prototype.getAdId;Ys.prototype.getVastAdId=Ys.prototype.getVastAdId;Ys.prototype.getVastMediaWidth=Ys.prototype.getVastMediaWidth;Ys.prototype.getVastMediaHeight=Ys.prototype.getVastMediaHeight;Ys.prototype.getVastMediaBitrate=Ys.prototype.getVastMediaBitrate;
Ys.prototype.getDescription=Ys.prototype.getDescription;Ys.prototype.getTitle=Ys.prototype.getTitle;Ys.prototype.getPositionInSequence=Ys.prototype.getPositionInSequence;Ys.prototype.getSequenceLength=Ys.prototype.getSequenceLength;Ys.prototype.setMuted=Ys.prototype.setMuted;Ys.prototype.resize=Ys.prototype.resize;Ys.prototype.isLinear=Ys.prototype.isLinear;Ys.prototype.isMuted=Ys.prototype.isMuted;Ys.prototype.setVolume=Ys.prototype.setVolume;Ys.prototype.getVolume=Ys.prototype.getVolume;
Ys.prototype.play=Ys.prototype.play;Ys.prototype.pause=Ys.prototype.pause;Ys.prototype.skip=Ys.prototype.skip;Ys.prototype.canSkipNow=Ys.prototype.canSkipNow;Ys.prototype.getTimeUntilSkippable=Ys.prototype.getTimeUntilSkippable;Ys.prototype.isSkippable=Ys.prototype.isSkippable;Ys.prototype.isPaused=Ys.prototype.isPaused;Ys.prototype.getRemainingTime=Ys.prototype.getRemainingTime;Ys.prototype.getMinSuggestedDuration=Ys.prototype.getMinSuggestedDuration;Ys.prototype.getDuration=Ys.prototype.getDuration;
Ys.prototype.isUsingAnotherMediaElement=Ys.prototype.isUsingAnotherMediaElement;Ys.prototype.hasCustomClick=Ys.prototype.hasCustomClick;Ys.prototype.isClientRendering=Ys.prototype.isClientRendering;Ys.prototype.needsSkipUI=Ys.prototype.needsSkipUI;function Zs(a,b,c,d){this.C=a;this.K=b;this.h=c;this.l=null;this.R=NaN;this.i=d;this.J=!1;this.B=null;this.j=[];this.N=[];this.M=this.F=this.g=null;this.G=new Map;this.m=[];this.u=[];this.H="";this.O=!0;this.I="";this.o=new kb}Zs.prototype.stop=function(){for(var a=u(this.m),b=a.next();!b.done;b=a.next())b=b.value,this.o.Ma(b.target,b.type,b.listener);$s(this);this.m=[];this.u=[];this.H="";this.O=!0;this.I="";this.B=null;this.j=[];this.N=[];this.G.clear()};
Zs.prototype.release=function(){this.stop();this.o&&this.o.release()};Zs.prototype.onManifestUpdated=function(a){this.J=a;this.H!=""&&(at(this,this.H,this.O),this.O=!1)};Zs.prototype.getCuePoints=function(){for(var a=[],b=u(this.j),c=b.next();!c.done;c=b.next()){c=u(c.value.ads);for(var d=c.next();!d.done;d=c.next())d=d.value,a.push({start:d.startTimeInSeconds,end:d.startTimeInSeconds+d.durationInSeconds})}return a};
function bt(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t;O(function(v){if(v.g==1)return d={type:7},e=Zg([b],Fg()),e.method="POST",c&&(f=JSON.stringify(c),e.body=uc(f)),g=a.K.request(7,e,d),sa(v,2),G(v,g.promise,4);if(v.g!=2){h=v.h;k=oc(h.data);l=JSON.parse(k);if(l.manifestUrl&&l.trackingUrl)m=new Db(b),n=new Db(l.trackingUrl),a.H=m.resolve(n).toString(),q=Date.now()/1E3,r=q-a.R,a.i(new V("ads-loaded",(new Map).set("loadTime",r))),t=new Db(l.manifestUrl),a.l.resolve(m.resolve(t).toString()),a.l=null;else throw Error("Insufficient data from MediaTailor.");
return ua(v,0)}Aa(v);if(!a.I.length)return a.l.reject("MediaTailor request returned an error and there was no backup asset uri provided."),a.l=null,v.return();a.l.resolve(a.I);a.l=null;H(v)})}
function at(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y;O(function(A){if(A.g==1)return d={type:8},e=Zg([b],Fg()),f=a.K.request(7,e,d),sa(A,2),G(A,f.promise,4);if(A.g!=2){g=A.h;h=[];k=oc(g.data);l=JSON.parse(k);if(l.avails.length>0){if(JSON.stringify(a.j)!=JSON.stringify(l.avails)){a.j=l.avails;m=u(a.j);for(n=m.next();!n.done;n=m.next())for(q=n.value,r=u(q.nonLinearAdsList),t=r.next();!t.done;t=r.next())for(v=t.value,w=u(v.nonLinearAdList),z=w.next();!z.done;z=w.next())y=z.value,ct(a,y);h=a.getCuePoints();
a.i(new V("ad-cue-points-changed",(new Map).set("cuepoints",h)))}}else a.j.length&&a.i(new V("ad-cue-points-changed",(new Map).set("cuepoints",h))),$s(a),a.j=[];c&&(a.J||h.length>0)&&dt(a);return ua(A,0)}Aa(A);H(A)})}
function ct(a,b){var c,d,e,f,g,h,k,l,m;O(function(n){if(n.g==1){if(!b.staticResource)return n.return();c=et(b);if(d=a.G.get(c))return n.return();e={type:9};f=Zg([b.staticResource],Fg());g=a.K.request(7,f,e);sa(n,2);a.G.set(c,[]);return G(n,g.promise,4)}if(n.g!=2)return h=n.h,k=oc(h.data),l=JSON.parse(k),m=l.apps,a.G.set(c,m),ua(n,0);Aa(n);a.G.delete(c);H(n)})}
function et(a){return[a.adId,a.adParameters,a.adSystem,a.adTitle,a.creativeAdId,a.creativeId,a.creativeSequence,a.height,a.width,a.staticResource].join("")}function dt(a){ft(a);a.J||(gt(a),a.o.D(a.h,"seeked",function(){gt(a)}),a.o.D(a.h,"ended",function(){$s(a)}));a.o.D(a.h,"timeupdate",function(){ft(a)})}
function gt(a){var b=a.h.currentTime;if(b!=0&&a.B==null){for(var c,d,e=u(a.j),f=e.next();!f.done;f=e.next()){f=f.value;for(var g=u(f.ads),h=g.next();!h.done;h=g.next())if(h=h.value,!d)h.startTimeInSeconds<b&&(d=h,c=f);else if(h.startTimeInSeconds<b&&h.startTimeInSeconds>d.startTimeInSeconds+d.durationInSeconds){d=h;c=f;break}}c&&d&&!a.N.includes(d.adId)&&(a.B=b,a.h.currentTime=c.startTimeInSeconds)}}
function ft(a){if(a.h.duration&&(a.g||a.j.length)){var b=a.h.currentTime,c=!1;if(a.g){c=!0;var d=a.F,e=d.startTimeInSeconds+.5*d.durationInSeconds,f=d.startTimeInSeconds+.75*d.durationInSeconds;b>=d.startTimeInSeconds+.25*d.durationInSeconds&&!a.u.includes("firstQuartile")?(a.u.push("firstQuartile"),ht(a,"firstQuartile")):b>=e&&!a.u.includes("midpoint")?(a.u.push("midpoint"),ht(a,"midpoint")):b>=f&&!a.u.includes("thirdQuartile")&&(a.u.push("thirdQuartile"),ht(a,"thirdQuartile"));d=a.g.getRemainingTime();
e=a.g.getDuration();a.g.canSkipNow()&&d>0&&e>0&&ht(a,"skipStateChanged");e>0&&(d<=0||d>e)&&$s(a)}if(!a.g||!a.g.isLinear()){a:for(d=u(a.j),e=d.next();!e.done;e=d.next()){e=e.value;if(a.g&&a.g.isLinear())break;for(f=0;f<e.ads.length;f++){var g=e.ads[f],h=g.startTimeInSeconds+g.durationInSeconds;if(g.startTimeInSeconds<=b&&h>b){if(a.N.includes(g.adId)){if(a.h.ended)continue;a.h.currentTime=h;break a}$s(a);a.M=e;a.g=new Ys(g,f+1,e.ads.length,!0,a.h);a.F=g;f===0&&ht(a,"breakStart");it(a);break}}}if(!a.g)for(d=
u(a.j),e=d.next();!e.done;e=d.next()){e=e.value;if(a.g)break;for(f=0;f<e.nonLinearAdsList.length;f++)if(g=e.nonLinearAdsList[f],g.nonLinearAdList.length){h=e.startTimeInSeconds;var k=a.G.get(et(g.nonLinearAdList[0]));if(h<=b&&k&&k.length){$s(a);h=a;k=u(k);for(var l=k.next();!l.done;l=k.next())if(l=l.value,l.data.source.length){var m=document.createElement("img");m.src=l.data.source[0].url;m.style.top=(l.placeholder.top||0)+"%";m.style.height=100-(l.placeholder.top||0)+"%";m.style.left=(l.placeholder.left||
0)+"%";m.style.maxWidth=100-(l.placeholder.left||0)+"%";m.style.objectFit="contain";m.style.position="absolute";h.C.appendChild(m)}a.M=e;a.g=new Ys(g,f+1,e.ads.length,!1,a.h);a.F=g;f===0&&ht(a,"breakStart");it(a);break}}}c&&!a.g&&(b=a.h.currentTime,a.B&&a.B>b&&(a.h.currentTime=a.B),a.B=null)}}}
function $s(a){if(a.g){for(;a.C.lastChild;)a.C.removeChild(a.C.firstChild);a.J||a.N.push(a.F.adId);var b=a.g.m;(b===void 0?0:b)?ht(a,"skip"):ht(a,"complete");b=u(a.m);for(var c=b.next();!c.done;c=b.next())c=c.value,a.o.Ma(c.target,c.type,c.listener);a.m=[];a.u=[];b=a.g.getPositionInSequence();c=a.g.getSequenceLength();b===c&&ht(a,"breakEnd");a.g=null;a.F=null;a.M=null}}
function it(a){var b=!1;a.h.paused?b=!0:(ht(a,"impression"),ht(a,"start"));a.m.push({target:a.h,type:"volumechange",listener:function(){a.h.muted&&ht(a,"mute")}});a.m.push({target:a.h,type:"volumechange",listener:function(){a.h.muted||ht(a,"unmute")}});a.m.push({target:a.h,type:"play",listener:function(){b?(ht(a,"impression"),ht(a,"start"),b=!1):ht(a,"resume")}});a.m.push({target:a.h,type:"pause",listener:function(){ht(a,"pause")}});for(var c=u(a.m),d=c.next();!d.done;d=c.next())d=d.value,a.o.D(d.target,
d.type,d.listener)}
function ht(a,b){var c=a.F.trackingEvents.find(function(f){return f.eventType==b});c||(c=a.M.adBreakTrackingEvents.find(function(f){return f.eventType==b}));if(c){var d={type:10};c=u(c.beaconUrls);for(var e=c.next();!e.done;e=c.next())(e=e.value)&&e!=""&&(e=Zg([e],Fg()),e.method="POST",a.K.request(7,e,d))}switch(b){case "impression":a.i(new V("ad-impression"));break;case "start":a.i(new V("ad-started",(new Map).set("ad",a.g)));break;case "mute":a.i(new V("ad-muted"));break;case "unmute":a.i(new V("ad-volume-changed"));break;
case "resume":a.i(new V("ad-resumed"));break;case "pause":a.i(new V("ad-paused"));break;case "firstQuartile":a.i(new V("ad-first-quartile"));break;case "midpoint":a.i(new V("ad-midpoint"));break;case "thirdQuartile":a.i(new V("ad-third-quartile"));break;case "complete":a.i(new V("ad-complete"));a.i(new V("ad-stopped"));break;case "skip":a.i(new V("ad-skipped"));a.i(new V("ad-stopped"));break;case "breakStart":a.C.setAttribute("ad-active","true");break;case "breakEnd":a.C.removeAttribute("ad-active");
break;case "skipStateChanged":a.i(new V("ad-skip-state-changed"))}};function jt(a,b){this.g=a;this.i=null;this.h=b}p=jt.prototype;p.needsSkipUI=function(){return!0};p.isClientRendering=function(){return!1};p.hasCustomClick=function(){return!0};p.isUsingAnotherMediaElement=function(){return!1};p.getDuration=function(){return this.i?this.i.duration:-1};p.getMinSuggestedDuration=function(){return this.getDuration()};p.getRemainingTime=function(){return this.i?this.i.duration-this.i.currentTime:-1};p.isPaused=function(){return this.h.paused};p.isSkippable=function(){return this.g.isSkippable()};
p.getTimeUntilSkippable=function(){var a=this.g.getSkipTimeOffset();a=this.getRemainingTime()-a;return Math.max(a,0)};p.canSkipNow=function(){return this.getTimeUntilSkippable()==0};p.skip=function(){this.h.currentTime+=this.getRemainingTime()};p.pause=function(){return this.h.pause()};p.play=function(){return this.h.play()};p.getVolume=function(){return this.h.volume};p.setVolume=function(a){this.h.volume=a};p.isMuted=function(){return this.h.muted};p.isLinear=function(){return!0};p.resize=function(){};
p.setMuted=function(a){this.h.muted=a};p.getSequenceLength=function(){var a=this.g.getAdPodInfo();return a==null?1:a.getTotalAds()};p.getPositionInSequence=function(){var a=this.g.getAdPodInfo();return a==null?1:a.getAdPosition()};p.getTitle=function(){return this.g.getTitle()};p.getDescription=function(){return this.g.getDescription()};p.getVastMediaBitrate=function(){return 0};p.getVastMediaHeight=function(){return this.g.getVastMediaHeight()};p.getVastMediaWidth=function(){return this.g.getVastMediaWidth()};
p.getVastAdId=function(){return""};p.getAdId=function(){return this.g.getAdId()};p.getCreativeAdId=function(){return this.g.getCreativeAdId()};p.getAdvertiserName=function(){return this.g.getAdvertiserName()};p.getMediaUrl=function(){return null};p.getTimeOffset=function(){var a=this.g.getAdPodInfo();return a==null?0:a.getTimeOffset()};p.getPodIndex=function(){var a=this.g.getAdPodInfo();return a==null?0:a.getPodIndex()};p.release=function(){this.h=this.i=this.g=null};T("shaka.ads.ServerSideAd",jt);
jt.prototype.release=jt.prototype.release;jt.prototype.getPodIndex=jt.prototype.getPodIndex;jt.prototype.getTimeOffset=jt.prototype.getTimeOffset;jt.prototype.getMediaUrl=jt.prototype.getMediaUrl;jt.prototype.getAdvertiserName=jt.prototype.getAdvertiserName;jt.prototype.getCreativeAdId=jt.prototype.getCreativeAdId;jt.prototype.getAdId=jt.prototype.getAdId;jt.prototype.getVastAdId=jt.prototype.getVastAdId;jt.prototype.getVastMediaWidth=jt.prototype.getVastMediaWidth;
jt.prototype.getVastMediaHeight=jt.prototype.getVastMediaHeight;jt.prototype.getVastMediaBitrate=jt.prototype.getVastMediaBitrate;jt.prototype.getDescription=jt.prototype.getDescription;jt.prototype.getTitle=jt.prototype.getTitle;jt.prototype.getPositionInSequence=jt.prototype.getPositionInSequence;jt.prototype.getSequenceLength=jt.prototype.getSequenceLength;jt.prototype.setMuted=jt.prototype.setMuted;jt.prototype.resize=jt.prototype.resize;jt.prototype.isLinear=jt.prototype.isLinear;
jt.prototype.isMuted=jt.prototype.isMuted;jt.prototype.setVolume=jt.prototype.setVolume;jt.prototype.getVolume=jt.prototype.getVolume;jt.prototype.play=jt.prototype.play;jt.prototype.pause=jt.prototype.pause;jt.prototype.skip=jt.prototype.skip;jt.prototype.canSkipNow=jt.prototype.canSkipNow;jt.prototype.getTimeUntilSkippable=jt.prototype.getTimeUntilSkippable;jt.prototype.isSkippable=jt.prototype.isSkippable;jt.prototype.isPaused=jt.prototype.isPaused;jt.prototype.getRemainingTime=jt.prototype.getRemainingTime;
jt.prototype.getMinSuggestedDuration=jt.prototype.getMinSuggestedDuration;jt.prototype.getDuration=jt.prototype.getDuration;jt.prototype.isUsingAnotherMediaElement=jt.prototype.isUsingAnotherMediaElement;jt.prototype.hasCustomClick=jt.prototype.hasCustomClick;jt.prototype.isClientRendering=jt.prototype.isClientRendering;jt.prototype.needsSkipUI=jt.prototype.needsSkipUI;function kt(a,b,c,d){var e=this;this.u=a;this.l=b;this.j=null;this.G=NaN;this.i=d;this.H=!1;this.B=this.m=this.o=null;this.C="";this.F=[];this.h=new kb;a=new google.ima.dai.api.UiSettings;a.setLocale(c);this.g=new google.ima.dai.api.StreamManager(this.l,this.u,a);this.i(new V("ima-stream-manager-loaded",(new Map).set("imaStreamManager",this.g)));this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.LOADED,function(f){lt(e,f)});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.ERROR,function(){e.C.length?
e.j.resolve(e.C):e.j.reject("IMA Stream request returned an error and there was no backup asset uri provided.");e.j=null});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.AD_BREAK_STARTED,function(){});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.STARTED,function(f){f=f.getAd();e.m=new jt(f,e.l);e.B&&(e.m.i=e.B);e.i(new V("ad-started",(new Map).set("ad",e.m)));e.u.setAttribute("ad-active","true")});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.AD_BREAK_ENDED,function(){e.u.removeAttribute("ad-active");
var f=e.l.currentTime;e.o&&e.o>f&&(e.l.currentTime=e.o,e.o=null)});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.AD_PROGRESS,function(f){e.B=f.getStreamData().adProgressData;e.m&&(e.m.i=e.B)});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.FIRST_QUARTILE,function(){e.i(new V("ad-first-quartile"))});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.MIDPOINT,function(){e.i(new V("ad-midpoint"))});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.THIRD_QUARTILE,function(){e.i(new V("ad-third-quartile"))});
this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.COMPLETE,function(){e.i(new V("ad-complete"));e.i(new V("ad-stopped"));e.u.removeAttribute("ad-active");e.m=null});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.SKIPPED,function(){e.i(new V("ad-skipped"));e.i(new V("ad-stopped"))});this.h.D(this.g,google.ima.dai.api.StreamEvent.Type.CUEPOINTS_CHANGED,function(f){var g=f.getStreamData();f=[];g=u(g.cuepoints);for(var h=g.next();!h.done;h=g.next())h=h.value,f.push({start:h.start,end:h.end});e.F=
f;e.i(new V("ad-cue-points-changed",(new Map).set("cuepoints",f)))})}p=kt.prototype;p.configure=function(){};p.stop=function(){this.C="";this.o=null;this.F=[]};p.release=function(){this.stop();this.h&&this.h.release()};p.onCueMetadataChange=function(a){if(a.key&&a.data){var b={};b[a.key]=a.data;this.g.onTimedMetadata(b)}};p.getCuePoints=function(){return this.F};
function lt(a,b){a.i(new V("ads-loaded",(new Map).set("loadTime",Date.now()/1E3-a.G)));b=b.getStreamData().url;a.j.resolve(b);a.j=null;a.H||a.h.D(a.l,"seeked",function(){var c=a.l.currentTime;if(c!=0){a.g.streamTimeForContentTime(c);var d=a.g.previousCuePointForStreamTime(c);d&&!d.played&&(a.o=c,a.l.currentTime=d.start)}})};function Z(){Rg.call(this);this.h=this.i=this.j=this.g=null;this.m=new ms;this.o=navigator.language;this.l=null}ma(Z,Rg);p=Z.prototype;p.setLocale=function(a){this.o=a};p.configure=function(a){this.l=a;this.g&&this.g.configure(this.l);this.j&&this.j.configure(this.l);this.h&&this.h.configure(this.l)};p.initInterstitial=function(a,b,c){var d=this;this.g&&this.g.release();this.g=new Bs(a,b,c,function(e){return mt(d,e)});this.g.configure(this.l)};
p.initClientSide=function(a,b,c){var d=this;if(!window.google||!google.ima||!google.ima.AdsLoader)throw new U(2,10,1E4);this.j&&this.j.release();this.j=new ts(a,b,this.o,c,function(e){return mt(d,e)});this.j.configure(this.l)};p.release=function(){this.g&&(this.g.release(),this.g=null);this.j&&(this.j.release(),this.j=null);this.i&&(this.i.release(),this.i=null);this.h&&(this.h.release(),this.h=null);Rg.prototype.release.call(this)};
p.onAssetUnload=function(){this.g&&this.g.stop();this.j&&this.j.stop();this.i&&this.i.stop();this.h&&this.h.stop();this.dispatchEvent(new V("ad-stopped"));this.dispatchEvent(new V("ad-content-attach-requested"));this.m=new ms};p.requestClientSideAds=function(a){if(!this.j)throw new U(1,10,10001);var b=this.j;b.g&&b.g.destroy();b.m&&b.m.contentComplete();b.H=Date.now()/1E3;b.m.requestAds(a)};
p.updateClientSideAdsRenderingSettings=function(a){if(!this.j)throw new U(1,10,10001);var b=this.j;b.C=a;b.g&&b.g.updateAdsRenderingSettings(b.C)};p.initMediaTailor=function(a,b,c){var d=this;this.i&&this.i.release();this.i=new Zs(a,b,c,function(e){return mt(d,e)})};p.requestMediaTailorStream=function(a,b,c){if(!this.i)throw new U(1,10,10005);var d=this.i;c=c===void 0?"":c;d.l?a=Promise.reject(new U(1,10,10004)):(d.l=new Hg,bt(d,a,b),d.I=c||"",d.R=Date.now()/1E3,a=d.l);return a};
p.addMediaTailorTrackingUrl=function(a){if(!this.i)throw new U(1,10,10005);var b=this.i;b.H=a;b.i(new V("ads-loaded",(new Map).set("loadTime",0)))};p.initServerSide=function(a,b){var c=this;if(!window.google||!google.ima||!google.ima.dai)throw new U(2,10,10002);this.h&&this.h.release();this.h=new kt(a,b,this.o,function(d){return mt(c,d)});this.h.configure(this.l)};
p.requestServerSideStream=function(a,b){b=b===void 0?"":b;if(!this.h)throw new U(1,10,10003);a.adTagParameters||(a.adTagParameters={});var c=a.adTagParameters;(c.mpt||c.mpv)&&$a('You have attempted to set "mpt" and/or "mpv" parameters of the ad tag. Please note that those parameters are used for Shaka adoption tracking and will be overridden.');a.adTagParameters.mpt="shaka-player";a.adTagParameters.mpv="v4.16.12";c=this.h;c.j?a=Promise.reject(new U(1,10,10004)):(a instanceof google.ima.dai.api.LiveStreamRequest&&
(c.H=!0),c.j=new Hg,c.g.requestStream(a),c.C=b||"",c.G=Date.now()/1E3,a=c.j);return a};p.replaceServerSideAdTagParameters=function(a){if(!this.h)throw new U(1,10,10003);(a.mpt||a.mpv)&&$a('You have attempted to set "mpt" and/or "mpv" parameters of the ad tag. Please note that those parameters are used for Shaka adoption tracking and will be overridden.');a.mpt="Shaka Player";a.mpv="v4.16.12";this.h.g.replaceAdTagParameters(a)};
p.getServerSideCuePoints=function(){yb("AdManager.getServerSideCuePoints","Please use getCuePoints function.");return this.getCuePoints()};p.getCuePoints=function(){var a=[];this.h&&(a=a.concat(this.h.getCuePoints()));this.i&&(a=a.concat(this.i.getCuePoints()));return a};p.getStats=function(){var a=this.m;return{loadTimes:a.g,averageLoadTime:ns(a),started:a.h,overlayAds:a.j,playedCompletely:a.l,skipped:a.m,errors:a.i}};p.onManifestUpdated=function(a){if(this.i)this.i.onManifestUpdated(a)};
p.onDashTimedMetadata=function(a){this.h&&a.schemeIdUri=="urn:google:dai:2018"&&this.h.g.processMetadata(a.schemeIdUri,a.eventNode?a.eventNode.attributes.messageData:null,a.startTime)};p.onHlsTimedMetadata=function(a,b){this.h&&this.h.g.processMetadata("ID3",a.data,b)};p.onCueMetadataChange=function(a){if(this.h)this.h.onCueMetadataChange(a)};p.onHLSInterstitialMetadata=function(a,b,c){this.l&&this.l.disableHLSInterstitial||(this.g||this.initInterstitial(null,a,b),this.g&&Os(this.g,c))};
p.onDASHInterstitialMetadata=function(a,b,c){if(!this.l||!this.l.disableDASHInterstitial){var d=c.schemeIdUri;if(d=="urn:mpeg:dash:event:alternativeMPD:insert:2025"||d=="urn:mpeg:dash:event:alternativeMPD:replace:2025"){if(this.g||this.initInterstitial(null,a,b),this.g&&(a=this.g,b=c.schemeIdUri=="urn:mpeg:dash:event:alternativeMPD:replace:2025",d=c.schemeIdUri=="urn:mpeg:dash:event:alternativeMPD:insert:2025",b||d)){for(var e=c.startTime,f=c.endTime,g=null,h=0,k,l=u(c.eventNode.children),m=l.next();!m.done;m=
l.next())if(m=m.value,m.tagName=="AlternativeMPD"){if(m=m.attributes.uri){k=m;break}}else if(m.tagName=="InsertPresentation"||m.tagName=="ReplacePresentation"){var n=m.attributes.url;if(n){k=wc(n);(l=Od(m,"maxDuration",Vd))&&(g=l/c.timescale);(l=Od(m,"returnOffset",Vd))&&(h=l/c.timescale);b&&h&&(f=e+h);break}}k&&Rs(a,[{id:c.id,groupId:null,startTime:e,endTime:f,uri:k,mimeType:null,isSkippable:!1,skipOffset:null,skipFor:null,canJump:!0,resumeOffset:d?h:null,playoutLimit:g,once:!1,pre:!1,post:!1,timelineRange:b&&
!d,loop:!1,overlay:null,displayOnBackground:!1,currentVideo:null,background:null,clickThroughUrl:null}])}}else(d=="urn:mpeg:dash:event:2012"||d=="urn:scte:dash:scte214-events")&&c.eventNode&&Ld(c.eventNode,"OverlayEvent")&&(this.g||this.initInterstitial(null,a,b),this.g&&Ss(this.g,c))}};p.addCustomInterstitial=function(a){if(!this.g)throw new U(1,10,10006);Rs(this.g,[a])};p.addAdUrlInterstitial=function(a){if(!this.g)throw new U(1,10,10006);return this.g.addAdUrlInterstitial(a)};
p.getInterstitialPlayer=function(){if(!this.g)throw new U(1,10,10006);return this.g.td()};function mt(a,b){if(b&&b.type)switch(b.type){case "ads-loaded":a.m.g.push(b.loadTime);break;case "ad-started":a.m.h++;var c=b.ad;c&&!c.isLinear()&&a.m.j++;break;case "ad-complete":a.m.l++;break;case "ad-skipped":a.m.m++;break;case "ad-error":a.m.i++}a.dispatchEvent(b)}T("shaka.ads.AdManager",Z);Z.prototype.getInterstitialPlayer=Z.prototype.getInterstitialPlayer;Z.prototype.addAdUrlInterstitial=Z.prototype.addAdUrlInterstitial;
Z.prototype.addCustomInterstitial=Z.prototype.addCustomInterstitial;Z.prototype.onDASHInterstitialMetadata=Z.prototype.onDASHInterstitialMetadata;Z.prototype.onHLSInterstitialMetadata=Z.prototype.onHLSInterstitialMetadata;Z.prototype.onCueMetadataChange=Z.prototype.onCueMetadataChange;Z.prototype.onHlsTimedMetadata=Z.prototype.onHlsTimedMetadata;Z.prototype.onDashTimedMetadata=Z.prototype.onDashTimedMetadata;Z.prototype.onManifestUpdated=Z.prototype.onManifestUpdated;Z.prototype.getStats=Z.prototype.getStats;
Z.prototype.getCuePoints=Z.prototype.getCuePoints;Z.prototype.getServerSideCuePoints=Z.prototype.getServerSideCuePoints;Z.prototype.replaceServerSideAdTagParameters=Z.prototype.replaceServerSideAdTagParameters;Z.prototype.requestServerSideStream=Z.prototype.requestServerSideStream;Z.prototype.initServerSide=Z.prototype.initServerSide;Z.prototype.addMediaTailorTrackingUrl=Z.prototype.addMediaTailorTrackingUrl;Z.prototype.requestMediaTailorStream=Z.prototype.requestMediaTailorStream;
Z.prototype.initMediaTailor=Z.prototype.initMediaTailor;Z.prototype.updateClientSideAdsRenderingSettings=Z.prototype.updateClientSideAdsRenderingSettings;Z.prototype.requestClientSideAds=Z.prototype.requestClientSideAds;Z.prototype.onAssetUnload=Z.prototype.onAssetUnload;Z.prototype.release=Z.prototype.release;Z.prototype.initClientSide=Z.prototype.initClientSide;Z.prototype.initInterstitial=Z.prototype.initInterstitial;Z.prototype.configure=Z.prototype.configure;Z.prototype.setLocale=Z.prototype.setLocale;
Z.ADS_LOADED="ads-loaded";Z.AD_STARTED="ad-started";Z.AD_FIRST_QUARTILE="ad-first-quartile";Z.AD_MIDPOINT="ad-midpoint";Z.AD_THIRD_QUARTILE="ad-third-quartile";Z.AD_COMPLETE="ad-complete";Z.AD_STOPPED="ad-stopped";Z.AD_SKIPPED="ad-skipped";Z.AD_VOLUME_CHANGED="ad-volume-changed";Z.AD_MUTED="ad-muted";Z.AD_PAUSED="ad-paused";Z.AD_RESUMED="ad-resumed";Z.AD_SKIP_STATE_CHANGED="ad-skip-state-changed";Z.CUEPOINTS_CHANGED="ad-cue-points-changed";Z.IMA_AD_MANAGER_LOADED="ima-ad-manager-loaded";
Z.IMA_STREAM_MANAGER_LOADED="ima-stream-manager-loaded";Z.AD_CLICKED="ad-clicked";Z.AD_PROGRESS="ad-progress";Z.AD_BUFFERING="ad-buffering";Z.AD_IMPRESSION="ad-impression";Z.AD_DURATION_CHANGED="ad-duration-changed";Z.AD_CLOSED="ad-closed";Z.AD_LOADED="ad-loaded";Z.ALL_ADS_COMPLETED="all-ads-completed";Z.AD_LINEAR_CHANGED="ad-linear-changed";Z.AD_METADATA="ad-metadata";Z.AD_RECOVERABLE_ERROR="ad-recoverable-error";Z.AD_ERROR="ad-error";Z.AD_BREAK_READY="ad-break-ready";Z.AD_INTERACTION="ad-interaction";
Z.AD_CONTENT_PAUSE_REQUESTED="ad-content-pause-requested";Z.AD_CONTENT_RESUME_REQUESTED="ad-content-resume-requested";Z.AD_CONTENT_ATTACH_REQUESTED="ad-content-attach-requested";Kq=function(){return new Z};function nt(a){return JSON.stringify(a,function(b,c){if(typeof c!="function"){b=c instanceof V;if(c instanceof Event||b){var d={};for(f in c){var e=c[f];e&&typeof e=="object"?f=="detail"?d[f]=e:e instanceof Event||e instanceof V?d[f]={__type__:"Event",event:nt(e)}:b&&Array.isArray(e)&&(d[f]=e):f in Event||(d[f]=e)}return d}if(c instanceof Error){var f=new Set(["name","message","stack"]);for(d in c)f.add(d);b=u(Object.getOwnPropertyNames(c));for(d=b.next();!d.done;d=b.next())f.add(d.value);b={};f=
u(f);for(d=f.next();!d.done;d=f.next())d=d.value,b[d]=c[d];c={__type__:"Error",contents:b}}else if(c instanceof TimeRanges){f={__type__:"TimeRanges",length:c.length,start:[],end:[]};c=u(Ij(c));for(b=c.next();!b.done;b=c.next())b=b.value,d=b.end,f.start.push(b.start),f.end.push(d);c=f}else c=ArrayBuffer.isView(c)&&c.BYTES_PER_ELEMENT===1?{__type__:"Uint8Array",entries:Array.from(c)}:typeof c=="number"?isNaN(c)?"NaN":isFinite(c)?c:c<0?"-Infinity":"Infinity":c;return c}})}
function ot(a){return JSON.parse(a,function(b,c){if(c=="NaN")var d=NaN;else if(c=="-Infinity")d=-Infinity;else if(c=="Infinity")d=Infinity;else if(c&&typeof c=="object"&&c.__type__=="TimeRanges")d=pt(c);else if(c&&typeof c=="object"&&c.__type__=="Uint8Array")d=new Uint8Array(c.entries);else if(c&&typeof c=="object"&&c.__type__=="Error"){b=c.contents;c=Error(b.message);for(d in b)c[d]=b[d];d=c}else d=c&&typeof c=="object"&&c.__type__=="Event"?ot(c.event):c;return d})}
function pt(a){return{length:a.length,start:function(b){return a.start[b]},end:function(b){return a.end[b]}}}
var qt="ended play playing pause pausing ratechange seeked seeking timeupdate volumechange".split(" "),rt="buffered currentTime duration ended loop muted paused playbackRate seeking videoHeight videoWidth volume".split(" "),st=["loop","playbackRate"],tt=["pause","play"],ut=(new Map).set("getAssetUri",2).set("getAudioLanguages",4).set("getAudioLanguagesAndRoles",4).set("getBufferFullness",1).set("getBufferedInfo",2).set("getExpiration",2).set("getKeyStatuses",2).set("getPlaybackRate",2).set("getTextLanguages",
4).set("getTextLanguagesAndRoles",4).set("isAudioOnly",10).set("isBuffering",1).set("isInProgress",1).set("isLive",10).set("isTextTrackVisible",1).set("isVideoOnly",10).set("keySystem",10).set("seekRange",1).set("getLoadMode",10).set("getManifestType",10).set("isFullyLoaded",1).set("isEnded",1).set("getBandwidthEstimate",1).set("isRemotePlayback",1),vt=(new Map).set("getConfiguration",4).set("getConfigurationForLowLatency",4).set("getStats",5).set("getAudioTracks",2).set("getChaptersTracks",2).set("getImageTracks",
2).set("getVideoTracks",2).set("getTextTracks",2).set("getVariantTracks",2),wt=(new Map).set("getPlayheadTimeAsDate",1).set("getPresentationStartTimeAsDate",20).set("getSegmentAvailabilityDuration",20),xt=[["getConfiguration","configure","getConfigurationForLowLatency","configurationForLowLatency"]],yt=[["isTextTrackVisible","setTextTrackVisibility"]],zt="cancelTrickPlay configure configurationForLowLatency getChapters resetConfiguration retryStreaming selectAudioLanguage selectAudioTrack selectTextLanguage selectTextTrack selectVariantTrack selectVariantsByLabel selectVideoTrack setTextTrackVisibility trickPlay updateStartTime goToLive useTrickPlayTrackIfAvailable".split(" "),
At="addChaptersTrack addTextTrackAsync addThumbnailsTrack getAllThumbnails getChaptersAsync getThumbnails attach attachCanvas detach load unload".split(" ");function Bt(a,b,c,d,e,f,g){var h=this;this.H=a;this.K=g;this.l=new rf(b);this.M=c;this.u=!1;this.B=d;this.G=e;this.N=f;this.i=this.m=!1;this.J="";this.o=null;this.C=function(){return Ct(h)};this.F=function(k,l){k=ot(l);switch(k.type){case "event":var m=k.targetName,n=Pg(k.event);h.B(m,n);break;case "update":m=k.update;for(n in m){k=h.g[n]||{};for(var q in m[n])k[q]=m[n][q]}h.u&&(h.M(),h.u=!1);break;case "asyncComplete":if(q=k.id,n=k.error,l=k.res,k=h.h.get(q),h.h.delete(q),k)if(n){q=new U(n.severity,
n.category,n.code);for(m in n)q[m]=n[m];k.reject(q)}else k.resolve(l)}};this.g={video:{},player:{}};this.I=0;this.h=new Map;this.j=null;Dt.add(this)}p=Bt.prototype;p.destroy=function(){Dt.delete(this);Et(this);Ft&&Gt(this);this.l&&(this.l.stop(),this.l=null);this.G=this.B=null;this.i=this.m=!1;this.F=this.C=this.j=this.h=this.g=this.o=null;return Promise.resolve()};p.wb=function(){return this.i};p.eh=function(){return this.J};
p.init=function(){if(this.H.length)if(window.chrome&&chrome.cast&&chrome.cast.isAvailable){this.m=!0;this.l.Jb();var a=new chrome.cast.SessionRequest(this.H,[],null,this.K,null);a=new chrome.cast.ApiConfig(a,function(b){for(var c=u(Dt),d=c.next();!d.done;d=c.next()){d=d.value;var e=b;d.j=new Hg;d.u=!0;Ht(d,e)}},function(b){for(var c=u(Dt),d=c.next();!d.done;d=c.next())d=d.value,It=b=="available",d.l.Jb()},"origin_scoped");chrome.cast.initialize(a,function(){},function(){});It&&this.l.ka(Jt);(a=Ft)&&
a.status!=chrome.cast.SessionStatus.STOPPED?(this.j=new Hg,this.u=!0,Ht(this,a)):Ft=null}else window.__onGCastApiAvailable!==Kt&&(Lt=window.__onGCastApiAvailable||null,window.__onGCastApiAvailable=Kt)};p.qh=function(a){this.o=a;this.i&&Mt(this,{type:"appData",appData:this.o})};
p.cast=function(){var a=this;return O(function(b){if(!a.m)throw new U(1,8,8E3);if(!It)throw new U(1,8,8001);if(a.i)throw new U(1,8,8002);a.j=new Hg;chrome.cast.requestSession(function(c){return Ht(a,c)},function(c){return Nt(a,c)});return G(b,a.j,0)})};function Ot(a){a.i&&chrome.cast.requestSession(function(b){return Ht(a,b)},function(b){return Nt(a,b)})}p.qd=function(){if(this.i){Et(this);if(Ft){Gt(this);try{Ft.stop(function(){},function(){})}catch(a){}Ft=null}Ct(this)}};
p.get=function(a,b){var c=this;if(a=="video"){if(tt.includes(b))return function(){return c.Mi.apply(c,[a,b].concat(x(Na.apply(0,arguments))))}}else if(a=="player"){if(wt.has(b)&&!this.get("player","isLive")())return function(){};if(zt.includes(b))return function(){return c.Mi.apply(c,[a,b].concat(x(Na.apply(0,arguments))))};if(At.includes(b))return function(){return c.Pk.apply(c,[a,b].concat(x(Na.apply(0,arguments))))};if(ut.has(b)||vt.has(b))return function(){return c.g[a][b]}}return this.g[a][b]};
p.set=function(a,b,c){this.g[a][b]=c;Mt(this,{type:"set",targetName:a,property:b,value:c})};function Ht(a,b){var c=a.N();Ft=b;b.addUpdateListener(a.C);b.addMessageListener("urn:x-cast:com.google.shaka.v2",a.F);Ct(a);Mt(a,{type:"init",initState:c,appData:a.o});a.j.resolve()}function Nt(a,b){var c=8003;switch(b.code){case "cancel":c=8004;break;case "timeout":c=8005;break;case "receiver_unavailable":c=8006}a.j.reject(new U(2,8,c,b))}
p.Mi=function(a,b){Mt(this,{type:"call",targetName:a,methodName:b,args:Na.apply(2,arguments)})};p.Pk=function(a,b){var c=Na.apply(2,arguments),d=new Hg,e=this.I.toString();this.I++;this.h.set(e,d);try{Mt(this,{type:"asyncCall",targetName:a,methodName:b,args:c,id:e})}catch(f){d.reject(f)}return d};function Gt(a){var b=Ft;b.removeUpdateListener(a.C);b.removeMessageListener("urn:x-cast:com.google.shaka.v2",a.F)}
function Ct(a){var b=Ft?Ft.status=="connected":!1;if(a.i&&!b){a.G();for(var c in a.g)a.g[c]={};Et(a)}a.i=b;a.J=b?Ft.receiver.friendlyName:"";a.l.Jb()}function Et(a){if(a.h)for(var b=u(a.h.keys()),c=b.next();!c.done;c=b.next()){c=c.value;var d=a.h.get(c);a.h.delete(c);d.reject(new U(1,7,7E3))}}
function Mt(a,b){b=nt(b);var c=Ft;try{c.sendMessage("urn:x-cast:com.google.shaka.v2",b,function(){},cb)}catch(d){throw b=new U(2,8,8005,d),c=new V("error",(new Map).set("detail",b)),a.B("player",c),a.qd(),b;}}var Jt=.02,It=!1,Ft=null,Lt=null,Dt=new Set;function Kt(a){Lt?window.__onGCastApiAvailable=Lt:delete window.__onGCastApiAvailable;Lt=null;if(a)for(var b=u(Dt),c=b.next();!c.done;c=b.next())c.value.init();typeof window.__onGCastApiAvailable==="function"&&window.__onGCastApiAvailable(a)};function Pt(a,b,c,d){d=d===void 0?!1:d;Rg.call(this);var e=this;this.i=a;this.h=b;this.l=this.o=this.m=this.u=this.j=null;this.I=c;this.H=d;this.F=[];this.C=[];this.B=[];this.G=new Map;this.g=null;window.chrome&&rb().Oa()!="CAST"?(this.g=new Bt(c,function(){return Qt(e)},function(){return Rt(e)},function(f,g){return St(e,f,g)},function(){return Tt(e)},function(){return Ut(e)},d),Vt(this)):(this.j=this.i,this.u=this.h)}ma(Pt,Rg);p=Pt.prototype;
p.destroy=function(a){this.g&&(a===void 0?0:a)&&this.g.qd();this.l&&(this.l.release(),this.l=null);a=[];this.h&&(a.push(this.h.destroy()),this.h=null);this.g&&(a.push(this.g.destroy()),this.g=null);this.u=this.j=this.i=null;Rg.prototype.release.call(this);return Promise.all(a)};p.gk=function(){return this.j};p.td=function(){return this.u};p.sj=function(){return this.g?this.g.m&&It:!1};p.wb=function(){return this.g?this.g.wb():!1};p.eh=function(){return this.g?this.g.eh():""};
p.cast=function(){var a=this;return O(function(b){return b.g==1?a.g?G(b,a.g.cast(),2):b.return():a.h?G(b,a.h.Cc(),0):b.return()})};p.qh=function(a){this.g&&this.g.qh(a)};p.il=function(){this.g&&Ot(this.g)};p.qd=function(){this.g&&this.g.qd()};
p.tj=function(a,b){b=b===void 0?!1:b;var c=this;return O(function(d){if(d.g==1){if(a==c.I&&b==c.H)return d.return();c.I=a;c.H=b;if(!c.g)return d.return();c.g.qd();return G(d,c.g.destroy(),2)}c.g=null;c.g=new Bt(a,function(){return Qt(c)},function(){return Rt(c)},function(e,f){return St(c,e,f)},function(){return Tt(c)},function(){return Ut(c)},b);c.g.init();H(d)})};
function Vt(a){a.g.init();a.l=new kb;for(var b=u(qt),c=b.next();!c.done;c=b.next())a.l.D(a.i,c.value,function(f){a.g.wb()||(f=Pg(f),a.m.dispatchEvent(f))});for(var d in Qg)a.l.D(a.h,Qg[d],function(f){a.g.wb()||a.o.dispatchEvent(f)});a.j={};b={};for(var e in a.i)b={ie:b.ie},b.ie=e,Object.defineProperty(a.j,b.ie,{configurable:!1,enumerable:!0,get:function(f){return function(){return Wt(a,f.ie)}}(b),set:function(f){return function(g){var h=f.ie;a.g.wb()?a.g.set("video",h,g):a.i[h]=g}}(b)});a.u={};Xt(a,
function(f){Object.defineProperty(a.u,f,{configurable:!1,enumerable:!0,get:function(){return Yt(a,f)}})});Zt(a);a.m=new Rg;a.m.Je=a.j;a.o=new Rg;a.o.Je=a.u;a.l.D(a.h,"unloading",function(){a.g&&a.g.wb()||$t(a)})}function Zt(a){var b=new Map;Xt(a,function(c,d){b.has(d)?(d=b.get(d),c.length<d.length?a.G.set(c,d):a.G.set(d,c)):b.set(d,c)})}
function Xt(a,b){function c(k){return k=="constructor"||typeof d[k]!="function"?!1:!e.has(k)}var d=a.h,e=new Set,f;for(f in d)c(f)&&(e.add(f),b(f,d[f]));a=Object.getPrototypeOf(d);for(f=Object.getPrototypeOf({});a&&a!=f;){for(var g=u(Object.getOwnPropertyNames(a)),h=g.next();!h.done;h=g.next())h=h.value,c(h)&&(e.add(h),b(h,d[h]));a=Object.getPrototypeOf(a)}}
function Ut(a){var b={video:{},player:{},playerAfterLoad:{},manifest:a.h.rd(),startTime:null,addThumbnailsTrackCalls:a.F,addTextTrackAsyncCalls:a.C,addChaptersTrackCalls:a.B};a.i.pause();for(var c=u(st),d=c.next();!d.done;d=c.next())d=d.value,b.video[d]=a.i[d];a.i.ended||(b.startTime=a.i.currentTime);c=u(xt);for(d=c.next();!d.done;d=c.next()){var e=d.value;d=e[1];e=a.h[e[0]]();b.player[d]=e}c=u(yt);for(d=c.next();!d.done;d=c.next())e=d.value,d=e[1],e=a.h[e[0]](),b.playerAfterLoad[d]=e;return b}
function Qt(a){var b=new V("caststatuschanged");a.dispatchEvent(b)}function Rt(a){var b=new V(a.j.paused?"pause":"play");a.m.dispatchEvent(b)}
function Tt(a){for(var b=u(xt),c=b.next();!c.done;c=b.next()){var d=c.value;c=d[1];d=a.g.get("player",d[0])();a.h[c](d)}var e=a.F,f=a.C,g=a.B;$t(a);var h=a.g.get("player","getAssetUri")();d=a.g.get("video","ended");b=Promise.resolve();var k=a.i.autoplay;c=null;d||(c=a.g.get("video","currentTime"));var l;(d=a.g.get("player","getTextTracks")())&&d.length&&(l=d.find(function(q){return q.active}));var m=a.g.get("player","isTextTrackVisible")();h&&(a.i.autoplay=!1,b=a.h.load(h,c));var n={};c=u(st);for(d=
c.next();!d.done;d=c.next())d=d.value,n[d]=a.g.get("video",d);b.then(function(){if(a.i){for(var q=u(e),r=q.next();!r.done;r=q.next()){r=r.value;var t;(t=a.td()).Pe.apply(t,x(r))}q=u(f);for(t=q.next();!t.done;t=q.next()){t=t.value;var v;(v=a.td()).Rd.apply(v,x(t))}v=u(g);for(q=v.next();!q.done;q=v.next()){q=q.value;var w;(w=a.td()).Oe.apply(w,x(q))}w=u(st);for(v=w.next();!v.done;v=w.next())v=v.value,a.i[v]=n[v];w=u(yt);for(v=w.next();!v.done;v=w.next())q=v.value,v=q[1],q=a.g.get("player",q[0])(),a.h[v](q);
a.h.wh(m);l&&a.h.oh(l.language,l.roles,l.forced);a.i.autoplay=k;h&&a.i.play()}},function(q){q=(new Map).set("detail",q);q=new V("error",q);a.h.dispatchEvent(q)})}
function Wt(a,b){if(b=="addEventListener")return function(d,e,f){return a.m.addEventListener(d,e,f)};if(b=="removeEventListener")return function(d,e,f){return a.m.removeEventListener(d,e,f)};if(a.g.wb()&&Object.keys(a.g.g.video).length==0){var c=a.i[b];if(typeof c!="function")return c}return a.g.wb()?a.g.get("video",b):(b=a.i[b],typeof b=="function"&&(b=b.bind(a.i)),b)}
function Yt(a,b,c){c=c===void 0?!1:c;a.G.has(b)&&(b=a.G.get(b));if(b=="addEventListener")return function(d,e,f){return a.o.addEventListener(d,e,f)};if(b=="removeEventListener")return function(d,e,f){return a.o.removeEventListener(d,e,f)};if(b=="getMediaElement")return function(){return a.j};if(b=="getSharedConfiguration")return a.g.get("player","getConfiguration");if(b=="getNetworkingEngine")return function(){return a.h.Yb()};if(b=="getDrmEngine")return function(){return a.h.F};if(b=="getAdManager")return function(){return a.h.di()};
if(b=="getQueueManager")return function(){return a.h.mi()};if(b=="setVideoContainer")return function(d){return a.h.Zi(d)};if(!c){if(b=="addThumbnailsTrack")return function(){var d=Na.apply(0,arguments);a.F.push(d);return Yt(a,b,!0).apply(null,x(d))};if(b=="addTextTrackAsync")return function(){var d=Na.apply(0,arguments);a.C.push(d);return Yt(a,b,!0).apply(null,x(d))};if(b=="addChaptersTrack")return function(){var d=Na.apply(0,arguments);a.B.push(d);return Yt(a,b,!0).apply(null,x(d))}}if(a.g.wb()){if(b==
"getManifest"||b=="drmInfo")return function(){$a(b+"() does not work while casting!");return null};if(b=="attach"||b=="detach")return function(){$a(b+"() does not work while casting!");return Promise.resolve()};if(b=="getChapters")return function(){$a(b+"() does not work while casting!");return[]}}return a.g.wb()&&Object.keys(a.g.g.video).length==0&&(ut.has(b)||vt.has(b))||!a.g.wb()?a.h[b].bind(a.h):a.g.get("player",b)}
function St(a,b,c){a.g.wb()&&(b=="video"?a.m.dispatchEvent(c):b=="player"&&(c.type=="unloading"&&$t(a),a.o.dispatchEvent(c)))}function $t(a){a.F=[];a.C=[];a.B=[]}T("shaka.cast.CastProxy",Pt);Pt.prototype.changeReceiverId=Pt.prototype.tj;Pt.prototype.forceDisconnect=Pt.prototype.qd;Pt.prototype.suggestDisconnect=Pt.prototype.il;Pt.prototype.setAppData=Pt.prototype.qh;Pt.prototype.cast=Pt.prototype.cast;Pt.prototype.receiverName=Pt.prototype.eh;Pt.prototype.isCasting=Pt.prototype.wb;
Pt.prototype.canCast=Pt.prototype.sj;Pt.prototype.getPlayer=Pt.prototype.td;Pt.prototype.getVideo=Pt.prototype.gk;Pt.prototype.destroy=Pt.prototype.destroy;function au(a,b,c,d){Rg.call(this);var e=this;this.h=a;this.g=b;this.j=new kb;this.I={video:a,player:b};this.G=c||function(){};this.J=d||function(f){return f};this.i=null;this.H=!1;this.o=!0;this.m=0;this.C=!1;this.B=!0;this.u=this.l=null;this.F=new rf(function(){bu(e)});cu(this)}ma(au,Rg);p=au.prototype;p.isConnected=function(){return this.H};p.pk=function(){return this.o};p.al=function(a){this.i=a};p.xj=function(){this.i=null};
p.cl=function(a){this.i||(this.i={metadataType:cast.receiver.media.MetadataType.GENERIC});this.i.title=a};p.$k=function(a){this.i||(this.i={metadataType:cast.receiver.media.MetadataType.GENERIC});this.i.images=[{url:a}]};p.Zk=function(a){this.i||(this.i={});this.i.artist=a;this.i.metadataType=cast.receiver.media.MetadataType.MUSIC_TRACK};
p.destroy=function(){var a=this,b,c;return O(function(d){if(d.g==1)return a.j&&(a.j.release(),a.j=null),b=[],a.g&&(b.push(a.g.destroy()),a.g=null),a.F&&(a.F.stop(),a.F=null),a.h=null,a.I=null,a.G=null,a.H=!1,a.o=!0,a.l=null,a.u=null,Rg.prototype.release.call(a),G(d,Promise.all(b),2);c=cast.receiver.CastReceiverManager.getInstance();c.stop();H(d)})};
function cu(a){var b=cast.receiver.CastReceiverManager.getInstance();b.onSenderConnected=function(){return du(a)};b.onSenderDisconnected=function(){return du(a)};b.onSystemVolumeChanged=function(){var e=cast.receiver.CastReceiverManager.getInstance().getSystemVolume();e&&eu(a,{type:"update",update:{video:{volume:e.level,muted:e.muted}}},a.l);eu(a,{type:"event",targetName:"video",event:{type:"volumechange"}},a.l)};a.u=b.getCastMessageBus("urn:x-cast:com.google.cast.media");a.u.onMessage=function(e){return fu(a,
e)};a.l=b.getCastMessageBus("urn:x-cast:com.google.shaka.v2");a.l.onMessage=function(e){return gu(a,e)};b.start();b=u(qt);for(var c=b.next();!c.done;c=b.next())a.j.D(a.h,c.value,function(e){return hu(a,"video",e)});for(var d in Qg)a.j.D(a.g,Qg[d],function(e){return hu(a,"player",e)});a.j.D(a.h,"loadeddata",function(){a.C=!0});a.j.D(a.g,"loading",function(){a.o=!1;iu(a)});a.j.D(a.h,"playing",function(){a.o=!1;iu(a)});a.j.D(a.h,"pause",function(){iu(a)});a.j.D(a.g,"unloading",function(){a.o=!0;iu(a)});
a.j.D(a.h,"ended",function(){(new rf(function(){a.h&&a.h.ended&&(a.o=!0,iu(a))})).ka(ju)})}function du(a){a.m=0;a.B=!0;a.H=cast.receiver.CastReceiverManager.getInstance().getSenders().length!=0;iu(a)}function iu(a){var b;O(function(c){if(c.g==1)return G(c,Promise.resolve(),2);if(!a.g)return c.return();b=new V("caststatuschanged");a.dispatchEvent(b);ku(a)||lu(a);H(c)})}
function mu(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I;O(function(D){switch(D.g){case 1:for(d in b.player)e=b.player[d],a.g[d](e);a.G(c);f=a.h.autoplay;return b.manifest?(a.h.autoplay=!1,sa(D,5),G(D,a.g.load(b.manifest,b.startTime),7)):G(D,Promise.resolve(),3);case 7:if(b.addThumbnailsTrackCalls)for(g=u(b.addThumbnailsTrackCalls),h=g.next();!h.done;h=g.next())k=h.value,a.g.Pe.apply(a.g,x(k));if(b.addTextTrackAsyncCalls)for(l=u(b.addTextTrackAsyncCalls),m=l.next();!m.done;m=l.next())n=m.value,
a.g.Rd.apply(a.g,x(n));if(b.addChaptersTrackCalls)for(q=u(b.addChaptersTrackCalls),r=q.next();!r.done;r=q.next())t=r.value,a.g.Oe.apply(a.g,x(t));ua(D,3);break;case 5:return v=Aa(D),w=(new Map).set("detail",v),z=new V("error",w),a.g&&a.g.dispatchEvent(z),D.return();case 3:if(!a.g)return D.return();for(y in b.video)A=b.video[y],a.h[y]=A;for(E in b.playerAfterLoad)I=b.playerAfterLoad[E],a.g[E](I);a.h.autoplay=f;b.manifest&&(a.h.play(),lu(a));H(D)}})}
function hu(a,b,c){a.g&&(bu(a),eu(a,{type:"event",targetName:b,event:c},a.l))}
function bu(a){a.F.ka(nu);for(var b={video:{},player:{}},c=u(rt),d=c.next();!d.done;d=c.next())d=d.value,b.video[d]=a.h[d];a.g.W()&&wt.forEach(function(e,f){a.m%e==0&&(b.player[f]=a.g[f]())});ut.forEach(function(e,f){a.m%e==0&&(b.player[f]=a.g[f]())});if(c=cast.receiver.CastReceiverManager.getInstance().getSystemVolume())b.video.volume=c.level,b.video.muted=c.muted;eu(a,{type:"update",update:b},a.l);vt.forEach(function(e,f){a.m%e==0&&(e={player:{}},e.player[f]=a.g[f](),eu(a,{type:"update",update:e},
a.l))});a.C&&(a.m+=1);ku(a)}function ku(a){return a.B&&(a.h.duration||a.g.W())?(ou(a),a.B=!1,!0):!1}function ou(a,b){var c={contentId:a.g.rd(),streamType:a.g.W()?"LIVE":"BUFFERED",contentType:""};a.g.W()||(c.duration=a.h.duration);a.i&&(c.metadata=a.i);lu(a,b===void 0?0:b,c)}
function gu(a,b){var c=ot(b.data);switch(c.type){case "init":a.m=0;a.C=!1;a.B=!0;mu(a,c.initState,c.appData);bu(a);break;case "appData":a.G(c.appData);break;case "set":var d=c.targetName,e=c.property;c=c.value;if(d=="video")if(b=cast.receiver.CastReceiverManager.getInstance(),e=="volume"){b.setSystemVolumeLevel(c);break}else if(e=="muted"){b.setSystemVolumeMuted(c);break}a.I[d][e]=c;break;case "call":d=a.I[c.targetName];d[c.methodName].apply(d,c.args);break;case "asyncCall":d=c.targetName;e=c.methodName;
d=="player"&&e=="load"&&(a.m=0,a.C=!1);var f=c.id,g=b.senderId;b=a.I[d];c=b[e].apply(b,c.args);d=="player"&&e=="load"&&(c=c.then(function(){a.B=!0}));c.then(function(h){return pu(a,g,f,null,h)},function(h){return pu(a,g,f,h,null)})}}
function fu(a,b){var c=ot(b.data);switch(c.type){case "PLAY":a.h.play();lu(a);break;case "PAUSE":a.h.pause();lu(a);break;case "SEEK":b=c.currentTime;var d=c.resumeState;b!=null&&(a.h.currentTime=Number(b));d&&d=="PLAYBACK_START"?(a.h.play(),lu(a)):d&&d=="PLAYBACK_PAUSE"&&(a.h.pause(),lu(a));break;case "STOP":a.g.Cc().then(function(){a.g&&lu(a)});break;case "GET_STATUS":ou(a,Number(c.requestId));break;case "VOLUME":d=c.volume;b=d.level;d=d.muted;var e=a.h.volume,f=a.h.muted;b!=null&&(a.h.volume=Number(b));
d!=null&&(a.h.muted=d);e==a.h.volume&&f==a.h.muted||lu(a);break;case "LOAD":a.m=0;a.C=!1;a.B=!1;b=c.media;d=c.currentTime;e=a.J(b.contentId);f=c.autoplay||!0;a.G(b.customData);f&&(a.h.autoplay=!0);a.g.load(e,d).then(function(){a.g&&ou(a)}).catch(function(g){var h="LOAD_FAILED";g.category==7&&g.code==7E3&&(h="LOAD_CANCELLED");eu(a,{requestId:Number(c.requestId),type:h},a.u)});break;default:eu(a,{requestId:Number(c.requestId),type:"INVALID_REQUEST",reason:"INVALID_COMMAND"},a.u)}}
function pu(a,b,c,d,e){a.g&&eu(a,{type:"asyncComplete",id:c,error:d,res:e},a.l,b)}function eu(a,b,c,d){a.H&&(a=nt(b),d?c.getCastChannel(d).send(a):c.broadcast(a))}function lu(a,b,c){c=c===void 0?null:c;var d={mediaSessionId:0,playbackRate:a.h.playbackRate,playerState:a.o?qu:a.g.Rg()?ru:a.h.paused?su:tu,currentTime:a.h.currentTime,supportedMediaCommands:63,volume:{level:a.h.volume,muted:a.h.muted}};c&&(d.media=c);eu(a,{requestId:b===void 0?0:b,type:"MEDIA_STATUS",status:[d]},a.u)}
T("shaka.cast.CastReceiver",au);au.prototype.destroy=au.prototype.destroy;au.prototype.setContentArtist=au.prototype.Zk;au.prototype.setContentImage=au.prototype.$k;au.prototype.setContentTitle=au.prototype.cl;au.prototype.clearContentMetadata=au.prototype.xj;au.prototype.setContentMetadata=au.prototype.al;au.prototype.isIdle=au.prototype.pk;au.prototype.isConnected=au.prototype.isConnected;var nu=.5,ju=5,qu="IDLE",tu="PLAYING",ru="BUFFERING",su="PAUSED";function uu(a,b,c,d,e){if(d>=e)return null;for(var f=-1,g=-1,h=0;h<c.length;h++)if(c[h].some(function(E){return E!=null&&E.g.trim()!=""})){f=h;break}for(h=c.length-1;h>=0;h--)if(c[h].some(function(E){return E!=null&&E.g.trim()!=""})){g=h;break}if(f===-1||g===-1)return null;for(var k=h=!1,l="white",m="black",n=vu(d,e,h,k,l,m);f<=g;f++){for(var q=c[f],r=-1,t=-1,v=0;v<q.length;v++)if(q[v]!=null&&q[v].g.trim()!==""){r=v;break}for(v=q.length-1;v>=0;v--)if(q[v]!=null&&q[v].g.trim()!==""){t=v;break}if(r===
-1||t===-1)q=wu(d,e),a.nestedCues.push(q);else{for(;r<=t;r++)if(v=q[r]){var w=v.l,z=v.i,y=v.j,A=v.h;if(w!=h||z!=k||y!=l||A!=m)n.payload&&a.nestedCues.push(n),n=vu(d,e,w,z,y,A),h=w,k=z,l=y,m=A;n.payload+=v.g}else n.payload+=" ";n.payload&&a.nestedCues.push(n);f!==g&&(n=wu(d,e),a.nestedCues.push(n));n=vu(d,e,h,k,l,m)}}return a.nestedCues.length?{cue:a,stream:b}:null}function vu(a,b,c,d,e,f){a=new ge(a,b,"");c&&a.textDecoration.push(Ee);d&&(a.fontStyle=De);a.color=e;a.backgroundColor=f;return a}
function wu(a,b){a=new ge(a,b,"");a.lineBreak=!0;return a}function xu(a,b,c,d,e){this.g=a;this.l=b;this.i=c;this.h=d;this.j=e};function yu(a,b){this.i=[];this.g=1;this.h=0;this.F=a;this.C=b;this.j=this.m=!1;this.l="white";this.o="black";this.u=this.B=null;zu(this)}function Au(a,b,c){var d="CC"+((a.F<<1|a.C)+1),e=new ge(b,c,"");e.lineInterpretation=1;var f=Bu.get(a.g);f&&(e.line=f);a.u!=null&&a.B!=null&&(e.position=10+Math.min(70,a.u*10)+a.B*2.5);(b=uu(e,d,a.i,b,c))&&a.g+b.cue.nestedCues.length-3>15&&(f=Bu.get(a.g+3-b.cue.nestedCues.length))&&(e.line=f);return b}function zu(a){Cu(a,0,15);a.g=1}
function Du(a,b,c){if(!(c<32||c>127)){var d="";switch(b){case 0:d=Eu.has(c)?Eu.get(c):String.fromCharCode(c);break;case 1:d=Fu.get(c);break;case 2:a.i[a.g].pop();d=Gu.get(c);break;case 3:a.i[a.g].pop(),d=Hu.get(c)}d&&a.i[a.g].push(new xu(d,a.m,a.j,a.o,a.l))}}function Iu(a,b,c,d){if(!(c<0||b<0))if(b>=c)for(--d;d>=0;d--)a.i[b+d]=a.i[c+d].map(function(f){return f});else for(var e=0;e<d;e++)a.i[b+e]=a.i[c+e].map(function(f){return f})}function Cu(a,b,c){for(var d=0;d<=c;d++)a.i[b+d]=[]}
var Eu=new Map([[39,"\u2019"],[42,"\u00e1"],[92,"\u00e9"],[92,"\u00e9"],[94,"\u00ed"],[95,"\u00f3"],[96,"\u00fa"],[123,"\u00e7"],[124,"\u00f7"],[125,"\u00d1"],[126,"\u00f1"],[127,"\u2588"]]),Fu=new Map([[48,"\u00ae"],[49,"\u00b0"],[50,"\u00bd"],[51,"\u00bf"],[52,"\u2122"],[53,"\u00a2"],[54,"\u00a3"],[55,"\u266a"],[56,"\u00e0"],[57," "],[58,"\u00e8"],[59,"\u00e2"],[60,"\u00ea"],[61,"\u00ee"],[62,"\u00f4"],[63,"\u00fb"]]),Gu=new Map([[32,"\u00c1"],[33,"\u00c9"],[34,"\u00d3"],[35,"\u00da"],[36,"\u00dc"],
[37,"\u00fc"],[38,"\u2018"],[39,"\u00a1"],[40,"*"],[41,"'"],[42,"\u2500"],[43,"\u00a9"],[44,"\u2120"],[45,"\u00b7"],[46,"\u201c"],[47,"\u201d"],[48,"\u00c0"],[49,"\u00c2"],[50,"\u00c7"],[51,"\u00c8"],[52,"\u00ca"],[53,"\u00cb"],[54,"\u00eb"],[55,"\u00ce"],[56,"\u00cf"],[57,"\u00ef"],[58,"\u00d4"],[59,"\u00d9"],[60,"\u00f9"],[61,"\u00db"],[62,"\u00ab"],[63,"\u00bb"]]),Hu=new Map([[32,"\u00c3"],[33,"\u00e3"],[34,"\u00cd"],[35,"\u00cc"],[36,"\u00ec"],[37,"\u00d2"],[38,"\u00f2"],[39,"\u00d5"],[40,"\u00f5"],
[41,"{"],[42,"}"],[43,"\\"],[44,"^"],[45,"_"],[46,"|"],[47,"~"],[48,"\u00c4"],[49,"\u00e4"],[50,"\u00d6"],[51,"\u00f6"],[52,"\u00df"],[53,"\u00a5"],[54,"\u00a4"],[55,"\u2502"],[56,"\u00c5"],[57,"\u00e5"],[58,"\u00d8"],[59,"\u00f8"],[60,"\u250c"],[61,"\u2510"],[62,"\u2514"],[63,"\u2518"]]),Bu=new Map([[1,10],[2,15.33],[3,20.66],[4,26],[5,31.33],[6,36.66],[7,42],[8,47.33],[9,52.66],[10,58],[11,63.33],[12,68.66],[13,74],[14,79.33],[15,84.66]]);function Ju(a,b){this.h=0;this.o=new yu(a,b);this.i=new yu(a,b);this.g=this.j=new yu(a,b);this.l=0;this.m=null}function Ku(a,b,c){a.g=a.i;var d=a.g,e=null;a.h!==3&&a.h!==4&&(e=Au(d,a.l,c),c=a.i,c.g=c.h>0?c.h:0,Cu(c,0,15),c=a.j,c.g=c.h>0?c.h:0,Cu(c,0,15),d.g=15);a.h=3;d.h=b;return e}function Lu(a){a.h=1;a.g=a.j;a.g.h=0}function Mu(a){ab("Cea608DataChannel","CEA-608 text mode entered, but is unsupported");a.g=a.o;a.h=4}var Nu="black green blue cyan red yellow magenta black".split(" "),Ou="white green blue cyan red yellow magenta white_italics".split(" ");function Pu(a,b){this.J=b;this.N=a;this.K=this.l=!1;this.m=this.o=this.H=this.M=this.I=0;this.G=2;this.i=[];this.g=this.h=this.j=0;this.F=this.B=!1;this.C="white";this.u="black";Qu(this)}function Qu(a){a.i=[];for(var b=0;b<16;b++)a.i.push(Ru())}function Ru(){for(var a=[],b=0;b<42;b++)a.push(null);return a}function Su(a,b){Tu(a)&&(a.i[a.h][a.g]=new xu(b,a.F,a.B,a.u,a.C),a.g++)}function Tu(a){var b=a.g<a.m&&a.g>=0;return a.h<a.o&&a.h>=0&&b}Pu.prototype.isVisible=function(){return this.l};
function Uu(a){for(var b=0,c=1;c<16;c++,b++)a.i[b]=a.i[c];for(c=0;c<1;c++,b++)a.i[b]=Ru()}
function Vu(a,b,c){var d=new ge(a.j,b,"");d.textAlign=a.G===0?"left":a.G===1?"right":ie;var e=d.region;a.J&&(e.id+="svc"+a.J);e.id+="win"+a.N;e.height=a.o;e.width=a.m;e.heightUnits=2;e.widthUnits=2;e.viewportAnchorX=a.I;e.viewportAnchorY=a.M;e.viewportAnchorUnits=a.K?id:2;switch(a.H){case 0:e.regionAnchorX=0;e.regionAnchorY=0;break;case 1:e.regionAnchorX=50;e.regionAnchorY=0;break;case 2:e.regionAnchorX=100;e.regionAnchorY=0;break;case 3:e.regionAnchorX=0;e.regionAnchorY=50;break;case 4:e.regionAnchorX=
50;e.regionAnchorY=50;break;case 5:e.regionAnchorX=100;e.regionAnchorY=50;break;case 6:e.regionAnchorX=0;e.regionAnchorY=100;break;case 7:e.regionAnchorX=50;e.regionAnchorY=100;break;case 8:e.regionAnchorX=100,e.regionAnchorY=100}if(c=uu(d,"svc"+c,a.i,a.j,b))a.j=b;return c}Pu.prototype.display=function(){this.l=!0};function Wu(){this.i=[];this.h=null;this.g=0}function Xu(a,b){b.type===3?(a.g=(b.value&63)*2-1,a.h=[]):a.h&&(a.g>0&&(a.h.push(b),a.g--),a.g===0&&(a.i.push(new Yu(a.h)),a.h=null,a.g=0))}function Yu(a){this.g=0;this.h=a}Yu.prototype.Ia=function(){return this.g<this.h.length};Yu.prototype.Pa=function(){return this.g};function Zu(a){if(!a.Ia())throw new U(2,2,3E3);return a.h[a.g++]}Yu.prototype.skip=function(a){if(this.g+a>this.h.length)throw new U(2,2,3E3);this.g+=a};
Yu.prototype.Qi=function(a){if(this.g-a<0)throw new U(2,2,3E3);this.g-=a};function $u(a){this.i=a;this.h=[null,null,null,null,null,null,null,null];this.g=null}
function av(a,b,c,d){if(!a.g)return[];if(c==24)return c=Zu(b).value,d=Zu(b).value,c=function(f){return f.map(function(g){return("0"+(g&255).toString(16)).slice(-2)}).join("")}([c,d]),Su(a.g,String.fromCharCode(parseInt(c,16))),[];b=a.g;var e=null;switch(c){case 8:!Tu(b)||b.g<=0&&b.h<=0||(b.g<=0?(b.g=b.m-1,b.h--):b.g--,b.i[b.h][b.g]=null);break;case 13:b.isVisible()&&(e=Vu(b,d,a.i));b.h+1>=b.o?Uu(b):b.h++;b.g=0;break;case 14:b.isVisible()&&(e=Vu(b,d,a.i));b.i[b.h]=Ru();b.g=0;break;case 12:b.isVisible()&&
(e=Vu(b,d,a.i)),Qu(b),b.h=0,b.g=0}return e?[e]:[]}
function bv(a,b,c,d){if(c>=128&&c<=135)d=c&7,a.h[d]&&(a.g=a.h[d]);else{if(c===136){c=Zu(b).value;b=[];c=u(cv(a,c));for(var e=c.next();!e.done;e=c.next()){e=a.h[e.value];if(e.isVisible()){var f=Vu(e,d,a.i);f&&b.push(f)}Qu(e)}return b}if(c===137)for(b=Zu(b).value,b=u(cv(a,b)),c=b.next();!c.done;c=b.next())c=a.h[c.value],c.isVisible()||(c.j=d),c.display();else{if(c===138){c=Zu(b).value;b=null;c=u(cv(a,c));for(e=c.next();!e.done;e=c.next())e=a.h[e.value],e.isVisible()&&(b=Vu(e,d,a.i)),e.l=!1;return b?
[b]:[]}if(c===139){c=Zu(b).value;b=null;c=u(cv(a,c));for(e=c.next();!e.done;e=c.next())e=a.h[e.value],e.isVisible()?b=Vu(e,d,a.i):e.j=d,e.l=!e.l;return b?[b]:[]}if(c===140)return b=Zu(b).value,dv(a,b,d);if(c===143)return d=dv(a,255,d),ev(a),d;if(c===144)b.skip(1),d=Zu(b).value,a.g&&(a.g.B=(d&128)>0,a.g.F=(d&64)>0);else if(c===145)d=Zu(b).value,c=Zu(b).value,b.skip(1),a.g&&(b=fv((c&48)>>4,(c&12)>>2,c&3),a.g.C=fv((d&48)>>4,(d&12)>>2,d&3),a.g.u=b);else if(c===146)d=Zu(b).value,b=Zu(b).value,a.g&&(a=
a.g,a.h=d&15,a.g=b&63);else if(c===151)b.skip(1),b.skip(1),d=Zu(b).value,b.skip(1),a.g&&(a.g.G=d&3);else if(c>=152&&c<=159){c=(c&15)-8;e=a.h[c]!==null;e||(f=new Pu(c,a.i),f.j=d,a.h[c]=f);d=Zu(b).value;f=Zu(b).value;var g=Zu(b).value,h=Zu(b).value,k=Zu(b).value;b=Zu(b).value;e&&(b&7)===0||(b=a.h[c],b.h=0,b.g=0,b.F=!1,b.B=!1,b.C="white",b.u="black");b=a.h[c];b.l=(d&32)>0;b.M=f&127;b.I=g;b.H=(h&240)>>4;b.K=(f&128)>0;b.o=(h&15)+1;b.m=(k&63)+1;a.g=a.h[c]}}}return[]}
function cv(a,b){for(var c=[],d=0;d<8;d++)(b&1)===1&&a.h[d]&&c.push(d),b>>=1;return c}function dv(a,b,c){var d=[];b=u(cv(a,b));for(var e=b.next();!e.done;e=b.next()){e=e.value;var f=a.h[e];f.isVisible()&&(f=Vu(f,c,a.i))&&d.push(f);a.h[e]=null}return d}function ev(a){a.g=null;a.h=[null,null,null,null,null,null,null,null]}function fv(a,b,c){var d={0:0,1:0,2:1,3:1};a=d[a];b=d[b];c=d[c];return gv[a<<2|b<<1|c]}
var hv=new Map([[32," "],[33,"\u00a0"],[37,"\u2026"],[42,"\u0160"],[44,"\u0152"],[48,"\u2588"],[49,"\u2018"],[50,"\u2019"],[51,"\u201c"],[52,"\u201d"],[53,"\u2022"],[57,"\u2122"],[58,"\u0161"],[60,"\u0153"],[61,"\u2120"],[63,"\u0178"],[118,"\u215b"],[119,"\u215c"],[120,"\u215d"],[121,"\u215e"],[122,"\u2502"],[123,"\u2510"],[124,"\u2514"],[125,"\u2500"],[126,"\u2518"],[127,"\u250c"]]),gv="black blue green cyan red magenta yellow white".split(" ");function iv(){this.h=[];this.g=[];this.i=new Wu;this.l=0;this.m=new Map([["CC1",new Ju(0,0)],["CC2",new Ju(0,1)],["CC3",new Ju(1,0)],["CC4",new Ju(1,1)]]);this.u=this.o=0;this.j=new Map;this.C=!0;this.B=new Set;jv(this)}iv.prototype.clear=function(){this.l=0;this.h=[];this.g=[];var a=this.i;a.i=[];a.h=[];a.g=0;jv(this);a=u(this.j.values());for(var b=a.next();!b.done;b=a.next())ev(b.value)};
function jv(a){a.o=0;a.u=0;for(var b=u(a.m.values()),c=b.next();!c.done;c=b.next())c=c.value,c.h=0,c.g=c.j,c.m=null,zu(c.i),zu(c.j),zu(c.o);a.C=!0}
iv.prototype.extract=function(a,b){if(this.C){for(var c=u(this.m.values()),d=c.next();!d.done;d=c.next())d.value.l=b;this.C=!1}a=new mh(a,0);if(!(a.getLength()<8)&&a.Y()===181&&a.Ca()===49&&a.U()===1195456820&&a.Y()===3&&(c=a.Y(),(c&64)!==0))for(c&=31,a.skip(1),d=0;d<c;d++){var e=a.Y(),f=(e&4)>>2,g=a.Y(),h=a.Y();f&&(e&=3,e===0||e===1?this.h.push({pts:b,type:e,Cb:g,kc:h,order:this.h.length}):(this.g.push({pts:b,type:e,value:g,order:this.g.length}),this.g.push({pts:b,type:2,value:h,order:this.g.length})))}};
iv.prototype.decode=function(){function a(e,f){return e.pts-f.pts||e.order-f.order}var b=[];this.h.sort(a);this.g.sort(a);for(var c=u(this.h),d=c.next();!d.done;d=c.next())(d=kv(this,d.value))&&b.push(d);c=u(this.g);for(d=c.next();!d.done;d=c.next())Xu(this.i,d.value);c=u(this.i.i);for(d=c.next();!d.done;d=c.next())d=lv(this,d.value),b.push.apply(b,x(d));this.i.i=[];this.h=[];this.g=[];return b};
function kv(a,b){var c=b.type;if((b.Cb&112)===16){var d=b.Cb>>3&1;c===0?a.o=d:a.u=d}d="CC"+((c<<1|(c?a.u:a.o))+1);c=a.m.get(d);if(b.Cb===255&&b.kc===255||!b.Cb&&!b.kc||!mv(b.Cb)||!mv(b.kc))return++a.l>=45&&jv(a),null;a.l=0;b.Cb&=127;b.kc&=127;var e=b.Cb;if(e>=1&&e<=15||!b.Cb&&!b.kc)return null;e=null;if((b.Cb&112)===16)a:{a.B.add(d),d=b.Cb;a=b.kc;if(c.m===(d<<8|a))c.m=null;else if(c.m=d<<8|a,(d&240)===16&&(a&192)===64){b=[11,11,1,2,3,4,12,13,14,15,5,6,7,8,9,10][(d&7)<<1|a>>5&1];d="white";e=!1;var f=
null;var g=a>95?a-96:a-64;g<=13?d=Ou[Math.floor(g/2)]:g<=15?e=!0:f=Math.floor((g-16)/2);a=(a&1)===1;c.h!==4&&(g=c.g,c.h===3&&b!==g.g&&(c=1+b-g.h,Iu(g,c,1+g.g-g.h,g.h),Cu(g,0,c-1),Cu(g,b+1,15-b)),g.g=b,g.m=a,g.j=e,g.l=d,g.u=f,g.o="black")}else if((d&247)===17&&(a&240)===32)c.g.m=!1,c.g.j=!1,c.g.l="white",Du(c.g,0,32),d=!1,b=Ou[(a&14)>>1],b==="white_italics"&&(b="white",d=!0),c.g.m=(a&1)===1,c.g.j=d,c.g.l=b;else if((d&247)===16&&(a&240)===32||(d&247)===23&&(a&255)===45)b="black",(d&7)===0&&(b=Nu[(a&
14)>>1]),c.g.o=b;else if((d&247)===17&&(a&240)===48)Du(c.g,1,a);else if((d&246)===18&&(a&224)===32)Du(c.g,d&1?3:2,a);else{if((d&246)===20&&(a&240)===32){a=b.pts;d=null;switch(b.kc){case 32:Lu(c);break;case 33:c=c.g;c.i[c.g].pop();break;case 37:d=Ku(c,2,a);break;case 38:d=Ku(c,3,a);break;case 39:d=Ku(c,4,a);break;case 40:Du(c.g,0,32);break;case 41:c.h=2;c.g=c.i;c.g.h=0;c.l=a;break;case 42:zu(c.o);Mu(c);break;case 43:Mu(c);break;case 44:b=c.i;d=null;c.h!==4&&(d=Au(b,c.l,a));Cu(b,0,15);break;case 45:b=
c.g;c.h!==3?d=null:(d=Au(b,c.l,a),e=b.g-b.h+1,Iu(b,e-1,e,b.h),Cu(b,0,e-1),Cu(b,b.g,15-b.g),c.l=a);break;case 46:Cu(c.j,0,15);break;case 47:b=null,c.h!==4&&(b=Au(c.i,c.l,a)),d=c.j,c.j=c.i,c.i=d,Lu(c),c.l=a,d=b}e=d;break a}(d==23||d==31)&&a>=33&&a<=35&&(c.g.B=a-32)}e=null}else a=b.kc,Du(c.g,0,b.Cb),Du(c.g,0,a);return e}
function lv(a,b){var c=[];try{for(;b.Ia();){var d=Zu(b).value,e=(d&224)>>5,f=d&31;e===7&&f!=0&&(e=Zu(b).value&63);if(e!=0){a.B.add("svc"+e);a.j.has(e)||a.j.set(e,new $u(e));for(var g=a.j.get(e),h=b.Pa();b.Pa()-h<f;){e=g;var k=b,l=Zu(k),m=l.value,n=l.pts;if(m===16){var q=Zu(k);m=m<<16|q.value}if(m>=0&&m<=31)var r=av(e,k,m,n);else if(m>=128&&m<=159)r=bv(e,k,m,n);else{if(m>=4096&&m<=4127)e=k,k=m&255,k>=8&&k<=15?e.skip(1):k>=16&&k<=23?e.skip(2):k>=24&&k<=31&&e.skip(3);else if(m>=4224&&m<=4255)e=k,k=m&
255,k>=128&&k<=135?e.skip(4):k>=136&&k<=143&&e.skip(5);else if(m>=32&&m<=127)k=m,e.g&&(k===127?Su(e.g,"\u266a"):Su(e.g,String.fromCharCode(k)));else if(m>=160&&m<=255)e.g&&Su(e.g,String.fromCharCode(m));else if(m>=4128&&m<=4223){if(k=m&255,e.g)if(hv.has(k)){var t=hv.get(k);Su(e.g,t)}else Su(e.g,"_")}else m>=4256&&m<=4351&&e.g&&((m&255)!=160?Su(e.g,"_"):Su(e.g,"[CC]"));r=[]}c.push.apply(c,x(r))}}}}catch(v){if(v instanceof U&&v.code===3E3)ab("CEA708_INVALID_DATA","Buffer read out of bounds / invalid CEA-708 Data.");
else throw v;}return c}function mv(a){for(var b=0;a;)b^=a&1,a>>=1;return b===1}iv.prototype.getStreams=function(){return Array.from(this.B)};T("shaka.cea.CeaDecoder",iv);dd=function(){return new iv};function nv(a){for(var b=[],c=a,d=a=0;d<c.length;)a==2&&c[d]==3?(a=0,c=[].concat(x(c)),c.splice(d,1),c=new Uint8Array(c)):c[d]==0?a++:a=0,d++;a=c;for(d=0;d<a.length;){for(c=0;a[d]==255;)c+=255,d++;c+=a[d++];for(var e=0;a[d]==255;)e+=255,d++;e+=a[d++];c==4&&b.push(a.subarray(d,d+e));d+=e}return b};function ov(){this.j=new Map;this.i=this.h=0;this.g=pv}
ov.prototype.init=function(a){function b(f){f=f.name;qv.has(f)&&(c.g=qv.get(f))}var c=this,d=[],e=[];(new ph).box("moov",uh).box("mvex",uh).S("trex",function(f){var g=f.reader;g.skip(4);g.skip(4);f=g.U();g=g.U();c.h=f;c.i=g}).box("trak",uh).S("tkhd",function(f){var g=f.reader;f=f.version;f==1?(g.skip(8),g.skip(8)):(g.skip(4),g.skip(4));var h=g.U();f==1?g.skip(8):g.skip(4);g.skip(4);g.skip(8);g.skip(2);g.skip(2);g.skip(2);g.skip(2);g.skip(36);g.Ca();g.Ca();g.Ca();g.Ca();d.push(h)}).box("mdia",uh).S("mdhd",
function(f){f=Ki(f.reader,f.version);e.push(f.timescale)}).box("minf",uh).box("stbl",uh).S("stsd",zh).box("avc1",b).box("avc3",b).box("dvav",b).box("dva1",b).box("hev1",b).box("hvc1",b).box("dvh1",b).box("dvhe",b).box("vvc1",b).box("vvi1",b).box("dvc1",b).box("dvi1",b).box("encv",Ah).box("sinf",uh).box("frma",function(f){f=Ni(f.reader).codec;qv.has(f)&&(c.g=qv.get(f))}).parse(a,!0,!0);if(!d.length||!e.length||d.length!=e.length)throw new U(2,2,2010);this.g==pv&&$a("Unable to determine bitstream format for CEA parsing!");
d.forEach(function(f,g){c.j.set(f,e[g])})};
ov.prototype.parse=function(a){var b=this;if(this.g==pv)return[];var c=[],d=0,e=[];(new ph).box("moof",function(f){d=f.start;e=[];uh(f)}).box("traf",function(f){e.push({baseMediaDecodeTime:null,Wd:b.h,Xd:b.i,Ii:[],timescale:9E4});uh(f)}).S("trun",function(f){var g=e[e.length-1];f=Li(f.reader,f.version,f.flags);g.Ii.push(f)}).S("tfhd",function(f){var g=e[e.length-1];f=Ii(f.reader,f.flags);g.Wd=f.Wd||b.h;g.Xd=f.Xd||b.i;f=f.trackId;b.j.has(f)&&(g.timescale=b.j.get(f))}).S("tfdt",function(f){var g=e[e.length-
1];f=Ji(f.reader,f.version);g.baseMediaDecodeTime=f.baseMediaDecodeTime}).box("mdat",function(f){for(var g=d-f.start-8,h=f.reader.Pa(),k=u(e),l=k.next();!l.done;l=k.next())l=l.value,l.baseMediaDecodeTime===null?$a("Unable to find base media decode time for CEA captions!"):(f.reader.seek(h),rv(b,f.reader,l.baseMediaDecodeTime,l.timescale,l.Wd,l.Xd,g,l.Ii,c))}).parse(a,!1,!0);return c};
function rv(a,b,c,d,e,f,g,h,k){var l=0,m=f,n=h.map(function(t){return t.mh});n=[].concat.apply([],x(n));n.length&&(m=n[0].sampleSize||f);for(b.skip(g+h[0].qg);b.Ia();){g=b.U();var q=b.Y(),r=null;r=!1;h=1;switch(a.g){case sv:r=q&31;r=r==6;break;case tv:h=2;b.skip(1);r=q>>1&63;r=r==39||r==40;break;case uv:h=2;b.skip(1);r=q>>1&63;r=r==23||r==24;break;default:return}if(r)for(q=0,l<n.length&&(q=n[l].Gf||0),q=(c+q)/d,h=b.Tb(g-h,!1),h=u(nv(h)),r=h.next();!r.done;r=h.next())k.push({packet:r.value,pts:q});
else try{b.skip(g-h)}catch(t){break}m-=g+4;m==0&&(c=l<n.length?c+(n[l].nh||e):c+e,l++,l<n.length?m=n[l].sampleSize||f:m=f)}}T("shaka.cea.Mp4CeaParser",ov);var pv=0,sv=1,tv=2,uv=3,qv=(new Map).set("avc1",sv).set("avc3",sv).set("dvav",sv).set("dva1",sv).set("hev1",tv).set("hvc1",tv).set("dvh1",tv).set("dvhe",tv).set("vvc1",uv).set("vvi1",uv).set("dvc1",uv).set("dvi1",uv);ed("video/mp4",function(){return new ov});function vv(){this.g=null}vv.prototype.init=function(){};vv.prototype.parse=function(a){this.g?this.g.clearData():this.g=new nk;var b=[];a=Wb(a);if(!vk(a))return b;a=this.g.parse(a);var c=a.Yd(),d=a.ef();a=[];switch(c.video){case "avc":a.push(6);break;case "hvc":a.push(39),a.push(40)}if(!a.length)return b;c=u(d);for(d=c.next();!d.done;d=c.next())if(d=d.value,a.includes(d.type)&&d.time!=null)for(var e=u(nv(d.data)),f=e.next();!f.done;f=e.next())b.push({packet:f.value,pts:d.time});return b};
T("shaka.cea.TsCeaParser",vv);ed("video/mp2t",function(){return new vv});function wv(a){var b=0,c=ac(a),d=c.getUint32(b,!0);if(d!=a.byteLength)return[];a:{a=b+4+2;for(b=[];a<c.byteLength-1;){d=c.getUint16(a,!0);a+=2;var e=c.getUint16(a,!0);a+=2;if((e&1)!=0||e+a>c.byteLength){c=[];break a}var f=Wb(c,a,e);b.push({type:d,value:f});a+=e}c=b}return c}function xv(a){a=Ac(Id(a));a=wv(a).filter(function(b){return b.type===yv})[0];if(!a)return null;a=qc(a.value,!0);return(a=Ad(a,"WRMHEADER"))?a:null}
function zv(a){try{var b=xv(a);if(b)a:{for(var c=u(Kd(b,"DATA")),d=c.next();!d.done;d=c.next()){var e=d.value;if(e.children)for(var f=u(e.children),g=f.next();!g.done;g=f.next()){var h=g.value;if(h.tagName=="LA_URL"){var k=Id(h);break a}}}k=""}else k="";return k}catch(l){return""}}var yv=1;function Av(){this.g=new Map}Av.prototype.release=function(){this.g.clear()};
function Bv(a,b,c,d){var e=Cv(a,b),f=null;a=[];var g=[];b=null;var h=new Set(e.map(function(l){return l.keyId}));h.delete(null);var k="cenc";if(h.size>1)throw new U(2,4,4010);if(!c){g=e.filter(function(l){return l.Hd=="urn:mpeg:dash:sea:2012"});if(g.length>1)throw new U(2,4,4050);g.length&&(b=Dv(g[0]));(g=e.find(function(l){return l.Hd=="urn:mpeg:dash:mp4protection:2011"}))&&g.encryptionScheme&&(k=g.encryptionScheme);g=e.filter(function(l){return l.Hd=="urn:mpeg:dash:mp4protection:2011"?(f=l.init||
f,!1):l.Hd!="urn:mpeg:dash:sea:2012"});g.length&&(a=Ev(f,k,g,d,h),a.length==0&&(a=[Fc("",k,f)]))}if(e.length&&!b&&(c||!g.length))for(a=[],c=u(Object.values(d)),d=c.next();!d.done;d=c.next())d=d.value,d!="org.w3.clearkey"&&(d=Fc(d,k,f),a.push(d));if(h=Array.from(h)[0]||null)for(k=u(a),c=k.next();!c.done;c=k.next())for(c=u(c.value.initData),d=c.next();!d.done;d=c.next())d.value.keyId=h;return{Yh:h,Em:f,drmInfos:a,hg:b,ci:!0}}
function Fv(a,b,c,d,e){var f=Bv(a,b,d,e);if(c.ci){a=c.drmInfos.length==1&&!c.drmInfos[0].keySystem;b=f.drmInfos.length==0;if(c.drmInfos.length==0||a&&!b)c.drmInfos=f.drmInfos;c.ci=!1}else if(f.drmInfos.length>0&&(c.drmInfos=c.drmInfos.filter(function(g){return f.drmInfos.some(function(h){return h.keySystem==g.keySystem})}),c.drmInfos.length==0))throw new U(2,4,4008);return f.Yh||c.Yh}
function Gv(a){var b=Md(a.node,"https://dashif.org/CPS","Laurl");if(b&&(b=Id(b)))return b;if((b=Md(a.node,"urn:microsoft:playready","pro"))&&Id(b))return zv(b);if(a=Md(a.node,"urn:mpeg:cenc:2013","pssh"))if(a=Id(a)){b=Ac(a);a=8;b=ac(b);var c=b.getUint8(a);a+=20;c>0&&(a+=4+16*b.getUint32(a));a=Wb(b,a+4);a=yc(a);a=Ad("<pro>"+a+"</pro>");return zv(a)}return""}
function Ev(a,b,c,d,e){var f=[];c=u(c);for(var g=c.next();!g.done;g=c.next()){g=g.value;var h=d[g.Hd];if(h){var k;if((k=Md(g.node,"urn:microsoft:playready","pro"))&&Id(k)){k=Id(k);k=Ac(k);var l=new Uint8Array([154,4,240,121,152,64,66,134,171,146,230,91,224,136,95,149]);k=[{initData:Eh(k,l,new Set,0),initDataType:"cenc",keyId:g.keyId}]}else k=null;l=null;if(g.Hd==="urn:uuid:e2719d58-a985-b3c9-781a-b030af78d30e"){l=g;var m=e;if(m.size==0)l=null;else{var n=new Uint8Array([16,119,239,236,192,178,77,2,
172,227,60,30,82,226,251,75]),q=new Uint8Array([]);l=[{initData:Eh(q,n,m,1),initDataType:"cenc",keyId:l.keyId}]}}k=Fc(h,b,g.init||a||k||l);if(h=Hv.get(h))k.licenseServerUri=h(g);a:{if(g=Md(g.node,"https://dashif.org/CPS","Certurl"))if(g=Id(g))break a;g=""}k.serverCertificateUri=g;f.push(k)}}return f}function Cv(a,b){var c=[];b=u(b);for(var d=b.next();!d.done;d=b.next())(d=Iv(a,d.value))&&c.push(d);return c}
function Iv(a,b){var c=b.attributes.schemeIdUri,d=Pd(b,"urn:mpeg:cenc:2013","default_KID"),e=Nd(b,"urn:mpeg:cenc:2013","pssh").map(Jd),f=b.attributes.value;if(!c)return null;c=c.toLowerCase();if(d&&(d=d.replace(/-/g,"").toLowerCase(),d.includes(" ")))throw new U(2,4,4009);var g=[];try{g=e.map(function(h){if(!a.g.has(h)){var k=Ac(h);a.g.set(h,k)}return{initDataType:"cenc",initData:a.g.get(h),keyId:null}})}catch(h){throw new U(2,4,4007);}return{node:b,Hd:c,keyId:d,init:g.length>0?g:null,encryptionScheme:f}}
function Dv(a){if(!window.crypto||!window.crypto.subtle)throw $a("Web Crypto API is not available to decrypt AES-128. (Web Crypto only exists in secure origins like https)"),new U(2,4,4042);var b=Md(a.node,"urn:mpeg:dash:schema:sea:2012","SegmentEncryption");if(!b)throw new U(2,4,4051);if(b.attributes.schemeIdUri!="urn:mpeg:dash:sea:aes128-cbc:2013")throw new U(2,4,4051);b=Md(a.node,"urn:mpeg:dash:schema:sea:2012","CryptoPeriod");if(!b)throw new U(2,4,4051);a=b.attributes.IV;b=wc(b.attributes.keyUriTemplate);
if(!a||!b)throw new U(2,4,4051);a=Bc(a.substr(2));if(a.byteLength!=16)throw new U(2,4,4048);return{wk:b,iv:a}}
var Hv=(new Map).set("com.apple.fps",function(a){if("apple"===window.shakaMediaKeysPolyfill)throw new U(2,4,4054);if(a=Md(a.node,"https://dashif.org/CPS","Laurl"))if(a=Id(a))return a;return""}).set("com.widevine.alpha",function(a){var b=Md(a.node,"https://dashif.org/CPS","Laurl");return b&&(b=Id(b))?b:(a=Md(a.node,"urn:microsoft","laurl"))?wc(a.attributes.licenseUrl)||"":""}).set("com.microsoft.playready",Gv).set("com.microsoft.playready.recommendation",Gv).set("com.microsoft.playready.software",
Gv).set("com.microsoft.playready.hardware",Gv).set("org.w3.clearkey",function(a){var b=Md(a.node,"https://dashif.org/CPS","Laurl");return b&&(b=Id(b))?b:(a=Md(a.node,"http://dashif.org/guidelines/clearKey","Laurl"))&&a.attributes.Lic_type==="EME-1.0"&&a&&(a=Id(a))?a:""});function Jv(a,b,c,d,e,f){var g=(new Map).set("RepresentationID",b).set("Number",c).set("SubNumber",d).set("Bandwidth",e).set("Time",f);return a.replace(/\$(RepresentationID|Number|SubNumber|Bandwidth|Time)?(?:%0([0-9]+)([diouxX]))?\$/g,function(h,k,l,m){if(h=="$$")return"$";var n=g.get(k);if(n==null)return h;k=="RepresentationID"&&l&&(l=void 0);k=="Time"&&typeof n!="bigint"&&(Math.abs(n-Math.round(n))>=.2&&$a("Calculated $Time$ values must be close to integers"),n=Math.round(n));switch(m){case void 0:case "d":case "i":case "u":h=
n.toString();break;case "o":h=n.toString(8);break;case "x":h=n.toString(16);break;case "X":h=n.toString(16).toUpperCase();break;default:h=n.toString()}l=window.parseInt(l,10)||1;return Array(Math.max(0,l-h.length)+1).join("0")+h})}
function Kv(a,b){var c=Lv(a,b,"timescale"),d=1;c&&(d=Wd(c)||1);c=Lv(a,b,"duration");var e=(c=Wd(c||""))?c/d:null,f=Lv(a,b,"startNumber"),g=Number(Lv(a,b,"presentationTimeOffset"))||0,h=Xd(f||"");if(f==null||h==null)h=1;f=null;if(b=Mv(a,b,"SegmentTimeline")){b=Hd(b,"S");f=d;a=a.na.duration||Infinity;for(var k=h,l=[],m=-g,n=0;n<b.length;++n){var q=b[n],r=b[n+1],t=Od(q,"t",Xd),v=Od(q,"d",Xd),w=Od(q,"r",Vd);q=Od(q,"k",Vd)||0;t!=null&&(t-=g);if(v){t=t!=null?t:m;w=w||0;if(w<0)if(r){r=Od(r,"t",Xd);if(r==
null)break;else if(t>=r)break;w=Math.ceil((r-t)/v)-1}else{if(a==Infinity)break;else if(t/f>=a)break;w=Math.ceil((a*f-t)/v)-1}l.length>0&&t!=m&&(l[l.length-1].end=t/f);for(r=0;r<=w;++r)m=t+v,l.push({start:t/f,Ld:t,end:m/f,Jh:m,wc:q,Vk:l.length+k}),t=m}}f=l}return{timescale:d,Qf:c,gb:e,ve:h,ec:g/d||0,gd:g,timeline:f}}function Nv(a,b){return[b(a.L),b(a.qa),b(a.sa)].filter(uf)}function Lv(a,b,c){b=Nv(a,b);a=null;b=u(b);for(var d=b.next();!d.done&&!(a=d.value.attributes[c]);d=b.next());return a}
function Mv(a,b,c){b=Nv(a,b);a=null;b=u(b);for(var d=b.next();!d.done&&!(a=Ld(d.value,c));d=b.next());return a}
function Ov(a,b,c,d,e,f){for(var g=Pd(a,"http://www.w3.org/1999/xlink","href"),h=Pd(a,"http://www.w3.org/1999/xlink","actuate")||"onRequest",k=u(Object.keys(a.attributes)),l=k.next();!l.done;l=k.next()){l=l.value;var m=l.split(":"),n=Cd("http://www.w3.org/1999/xlink");m[0]==n&&delete a.attributes[l]}if(f>=5)return Jg(new U(2,4,4028));if(h!="onLoad")return Jg(new U(2,4,4027));var q=Ec([d],[g]);return e.request(0,Zg(q,b)).Xa(function(r){r=zd(r.data,a.tagName);if(!r)return Jg(new U(2,4,4001,g));for(a.children=
[];r.children.length;){var t=r.children.shift();a.children.push(t)}t=u(Object.keys(r.attributes));for(var v=t.next();!v.done;v=t.next())v=v.value,a.attributes[v]=r.attributes[v];return Pv(a,b,c,q[0],e,f+1)})}
function Pv(a,b,c,d,e,f){f=f===void 0?0:f;if(Pd(a,"http://www.w3.org/1999/xlink","href")){var g=Ov(a,b,c,d,e,f);c&&(g=g.Xa(void 0,function(){return Pv(a,b,c,d,e,f)}));return g}g=[];for(var h=u(Gd(a)),k=h.next(),l={};!k.done;l={Td:void 0},k=h.next())l.Td=k.value,Pd(l.Td,"http://www.w3.org/1999/xlink","href")=="urn:mpeg:dash:resolve-to-zero:2013"?a.children=a.children.filter(function(m){return function(n){return n!==m.Td}}(l)):l.Td.tagName!="SegmentTimeline"&&g.push(Pv(l.Td,b,c,d,e,f));return Ng(g).Xa(function(){return a})}
;function Qv(a,b,c,d,e,f,g,h){var k,l=(new ph).S("sidx",function(m){k=Rv(b,d,e,f,g,c,m,h)});a&&l.parse(a);if(k)return k;throw new U(2,3,3004);}
function Rv(a,b,c,d,e,f,g,h){h=h===void 0?!1:h;var k=[];g.reader.skip(4);var l=g.reader.U();if(l==0)throw new U(2,3,3005);if(g.version==0){var m=g.reader.U();var n=g.reader.U()}else m=g.reader.Ed(),n=g.reader.Ed();g.reader.skip(2);var q=g.reader.Ca();a=(h?-g.size:a)+g.size+n;for(h=0;h<q;h++){var r=g.reader.U();n=(r&2147483648)>>>31;r&=2147483647;var t=g.reader.U();g.reader.skip(4);if(n==1)throw new U(2,3,3006);k.push(new yj(m/l+c,(m+t)/l+c,function(){return f},a,a+r-1,b,c,d,e));m+=t;a+=r}g.parser.stop();
return k};function Sv(a){this.h=ac(a);this.g=new mh(this.h,0)}Sv.prototype.Ia=function(){return this.g.Ia()};
function Tv(a){var b=Uv(a);if(b.length>7)throw new U(2,3,3002);var c=0;b=u(b);for(var d=b.next();!d.done;d=b.next())c=256*c+d.value;b=Uv(a);a:{d=u(Vv);for(var e=d.next();!e.done;e=d.next())if(Ub(b,new Uint8Array(e.value))){d=!0;break a}d=!1}if(d)b=a.h.byteLength-a.g.Pa();else{if(b.length==8&&b[1]&224)throw new U(2,3,3001);for(e=d=0;e<b.length;e++){var f=b[e];d=e==0?f&(1<<8-b.length)-1:256*d+f}b=d}b=a.g.Pa()+b<=a.h.byteLength?b:a.h.byteLength-a.g.Pa();d=ac(a.h,a.g.Pa(),b);a.g.skip(b);return new Wv(c,
d)}function Uv(a){var b=a.g.Pa(),c=a.g.Y();if(c==0)throw new U(2,3,3002);c=8-Math.floor(Math.log2(c));a.g.skip(c-1);return Wb(a.h,b,c)}var Vv=[[255],[127,255],[63,255,255],[31,255,255,255],[15,255,255,255,255],[7,255,255,255,255,255],[3,255,255,255,255,255,255],[1,255,255,255,255,255,255,255]];function Wv(a,b){this.id=a;this.g=b}
function Xv(a){if(a.g.byteLength>8)throw new U(2,3,3002);if(a.g.byteLength==8&&a.g.getUint8(0)&224)throw new U(2,3,3001);for(var b=0,c=0;c<a.g.byteLength;c++){var d=a.g.getUint8(c);b=256*b+d}return b};function Yv(a,b,c,d,e,f,g){b=new Sv(b);if(Tv(b).id!=440786851)throw new U(2,3,3008);var h=Tv(b);if(h.id!=408125543)throw new U(2,3,3009);b=h.g.byteOffset;h=new Sv(h.g);for(var k=null;h.Ia();){var l=Tv(h);if(l.id==357149030){k=l;break}}if(!k)throw new U(2,3,3010);k=new Sv(k.g);l=1E6;for(h=null;k.Ia();){var m=Tv(k);if(m.id==2807729)l=Xv(m);else if(m.id==17545)if(m.g.byteLength==4)h=m.g.getFloat32(0);else if(m.g.byteLength==8)h=m.g.getFloat64(0);else throw new U(2,3,3003);}if(h==null)throw new U(2,3,
3011);k=l/1E9;h*=k;a=Tv(new Sv(a));if(a.id!=475249515)throw new U(2,3,3007);return Zv(a,b,k,h,c,d,e,f,g)}function Zv(a,b,c,d,e,f,g,h,k){function l(){return e}var m=[];a=new Sv(a.g);for(var n=null,q=null;a.Ia();){var r=Tv(a);if(r.id==187){var t=$v(r);t&&(r=c*t.ol,t=b+t.Nk,n!=null&&m.push(new yj(n+g,r+g,l,q,t-1,f,g,h,k)),n=r,q=t)}}n!=null&&m.push(new yj(n+g,d+g,l,q,null,f,g,h,k));return m}
function $v(a){var b=new Sv(a.g);a=Tv(b);if(a.id!=179)throw new U(2,3,3013);a=Xv(a);b=Tv(b);if(b.id!=183)throw new U(2,3,3012);b=new Sv(b.g);for(var c=0;b.Ia();){var d=Tv(b);if(d.id==241){c=Xv(d);break}}return{ol:a,Nk:c}};function aw(a,b,c){b=Mv(a,b,"Initialization");if(!b)return null;var d=a.L.bb(),e=b.attributes.sourceURL;e&&(d=Ec(d,[wc(e)],a.Lb()));e=0;var f=null;if(b=Od(b,"range",Ud))e=b.start,f=b.end;c=new wj(function(){return d},e,f,bw(a),null,null,c,a.qa.encrypted);c.codecs=a.L.codecs;c.mimeType=a.L.mimeType;a.na&&!a.na.kf&&(c.g=a.na.start+a.na.duration);return c}
function cw(a,b,c){var d=Number(Lv(a,dw,"presentationTimeOffset"))||0,e=Lv(a,dw,"timescale"),f=1;e&&(f=Wd(e)||1);var g=d/f||0,h=aw(a,dw,c);ew(a,h);var k=xd(a);return{endTime:-1,timeline:-1,Sc:function(){var l=Mv(k,dw,"RepresentationIndex");var m=k.L.bb();l&&(l=wc(l.attributes.sourceURL))&&(m=Ec(m,[l],k.Lb()));l=fw(k);return gw(k,b,h,m,l.start,l.end,g)},timescale:f}}
function gw(a,b,c,d,e,f,g){var h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F;return O(function(L){if(L.g==1)return h=a.presentationTimeline,k=!a.Eb||!a.na.kf,l=a.na.start,m=a.na.duration,n=a.L.mimeType.split("/")[1],q=b,r=null,t=[q(d,e,f,!1),n=="webm"?q(c.P(),c.startByte,c.endByte,!0):null],q=null,G(L,Promise.all(t),2);v=L.h;w=v[0];z=v[1]||null;y=null;A=l-g;E=l;I=m?l+m:Infinity;D=a.L.bb();C=D.length!=d.length||D.some(function(K,P){return K!=d[P]});y=n=="mp4"?Qv(w,e,D,c,A,E,I,C):Yv(w,z,D,c,A,E,I);B=u(y);
for(J=B.next();!J.done;J=B.next())F=J.value,F.codecs=a.L.codecs,F.mimeType=a.L.mimeType,F.bandwidth=a.bandwidth;h.me(y);r=new Ul(y);k&&r.pd(E,I,!0);return L.return(r)})}function dw(a){return a.Id}function fw(a){var b=Mv(a,dw,"RepresentationIndex");a=Lv(a,dw,"indexRange");a=Ud(a||"");b&&(a=Od(b,"range",Ud,a));return a}function ew(a,b){hw(a,b);if(!fw(a))throw new U(2,4,4002);}
function hw(a,b){var c=a.L.mimeType.split("/")[1];if(a.L.contentType!=Kc&&c!="mp4"&&c!="webm")throw new U(2,4,4006);if(c=="webm"&&!b)throw new U(2,4,4005);}
function bw(a){var b=a.L;return{bandwidth:a.bandwidth,audioSamplingRate:b.audioSamplingRate,codecs:b.codecs,contentType:b.contentType,frameRate:b.frameRate||null,height:b.height||null,mimeType:b.mimeType,channelsCount:b.yf,pixelAspectRatio:b.pixelAspectRatio||null,width:b.width||null,label:a.qa.label||null,roles:a.roles||null,language:a.qa.language||null}};function iw(a,b,c){var d=aw(a,jw,c),e=kw(a);if(!e.gb&&!e.timeline&&e.yd.length>1)throw new U(2,4,4002);if(!e.gb&&!a.na.duration&&!e.timeline&&e.yd.length==1)throw new U(2,4,4002);if(e.timeline&&e.timeline.length==0)throw new U(2,4,4002);var f=null,g=null;a.sa.id&&a.L.id&&(g=b.get(a.sa.id+","+a.L.id))&&(f=g.segmentIndex);var h=lw(a.na.start,a.na.duration,a.L.bb,e,d,c,a.L.mimeType,a.L.codecs,a.bandwidth,a.Lb);b=!f;f?f.ke(h,a.presentationTimeline.Hb()):f=new Ul(h);a.presentationTimeline.me(h);a.Eb&&
a.na.kf||f.pd(a.na.start,a.na.duration?a.na.start+a.na.duration:Infinity,b);g&&(g.segmentIndex=f);return{endTime:-1,timeline:-1,Sc:function(){f&&f.getNumReferences()!=0||f.tf(h);return Promise.resolve(f)},timescale:e.timescale}}function jw(a){return a.Ac}function kw(a){var b=mw(a);a=Kv(a,jw);var c=a.ve;c==0&&(c=1);var d=0;a.gb?d=a.gb*(c-1):a.timeline&&a.timeline.length>0&&(d=a.timeline[0].start);return{gb:a.gb,startTime:d,ve:c,ec:a.ec,timescale:a.timescale,timeline:a.timeline,yd:b}}
function lw(a,b,c,d,e,f,g,h,k,l){var m=d.yd.length;d.timeline&&d.timeline.length!=d.yd.length&&(m=Math.min(d.timeline.length,d.yd.length));for(var n=a-d.ec,q=b?a+b:Infinity,r=[],t=d.startTime,v={},w=0;w<m;v={Sf:void 0,Hf:void 0},w++){v.Hf=d.yd[w];var z=t;t=void 0;t=d.gb!=null?z+d.gb:d.timeline?d.timeline[w].end:z+b;v.Sf=null;v=new yj(a+z,a+t,function(y){return function(){y.Sf==null&&(y.Sf=Ec(c(),[y.Hf.Ck],l()));return y.Sf}}(v),v.Hf.start,v.Hf.end,e,n,a,q,[],"",null,null,zj,f);v.codecs=h;v.mimeType=
g;v.bandwidth=k;r.push(v)}return r}function mw(a){return[a.L.Ac,a.qa.Ac,a.sa.Ac].filter(uf).map(function(b){return Hd(b,"SegmentURL")}).reduce(function(b,c){return b.length>0?b:c}).map(function(b){b.attributes.indexRange&&!a.Og&&(a.Og=!0);var c=wc(b.attributes.media);b=Od(b,"mediaRange",Ud,{start:0,end:null});return{Ck:c,start:b.start,end:b.end}})};function nw(a,b,c,d,e,f,g,h,k,l){k||a.L.hf||(a.L.hf=Lv(a,ow,"initialization"));var m=a.L.hf?pw(a,g):null,n=qw(a);rw(n);var q=xd(a);if(n.fe)return hw(a,m),{endTime:-1,timeline:-1,Sc:function(){var z=Jv(n.fe,q.L.originalId,null,null,q.bandwidth||null,null);z=Ec(q.L.bb(),[z]);return gw(q,b,m,z,0,null,n.ec)},timescale:n.timescale};if(n.gb)return d||a.qa.contentType==="image"||a.qa.contentType==="text"||(d=a.na.start,l=a.sa.id,c=a.na.duration,l=(l=l!=null&&f.get(l)||c)?d+l:Infinity,a.presentationTimeline.Wg(n.gb),
a.presentationTimeline.Gi(d,l)),{endTime:-1,timeline:-1,Sc:function(){return sw(q,n,e,m,f,g,h,a.L.If)},timescale:n.timescale};var r=null;d=d=null;a.sa.id&&a.L.id&&(d=a.sa.id+","+a.L.id,d=c.get(d))&&(r=d.segmentIndex);var t=a.na.start,v=a.na.duration?t+a.na.duration:Infinity;if(r)l=r,tw(l,n,t,v,m,a.Eb),l.Ya(a.presentationTimeline.Hb());else{c=0;k=-1;if(a.sa.id!=null&&a.L.id!=null){var w=l.get(a.sa.id);if(w)k=w.timeline;else for(l=u(l.values()),w=l.next();!w.done;w=l.next())if(w=w.value,Math.abs(n.ec-
w.endTime)<=Nc&&w.gh.includes(a.L.id)){k=w.timeline;break}else w.timeline>=c&&(c=w.timeline+1)}k==-1&&(k=c);r=new uw(a.Eb,n,a.L.originalId,a.bandwidth,a.L.bb,a.Lb,t,v,m,g,a.L.If,k)}n.timeline&&a.qa.contentType!=="image"&&a.qa.contentType!=="text"&&a.presentationTimeline.Hi(r.h?r.h.timeline:[],t);d&&a.Eb&&(d.segmentIndex=r);d=(d=(d=n.timeline)&&d[d.length-1])?d.end+n.ec:-1;l=-1;r instanceof uw&&(l=r.We());return{endTime:d,timeline:l,Sc:function(){r instanceof uw&&r.getNumReferences()==0&&tw(r,n,t,
v,m,a.Eb);return Promise.resolve(r)},timescale:n.timescale}}function ow(a){return a.Oc}function qw(a){var b=Kv(a,ow),c=Lv(a,ow,"media"),d=Lv(a,ow,"index"),e=Lv(a,ow,"k"),f=0;e&&(f=parseInt(e,10));return{Qf:b.Qf,gb:b.gb,timescale:b.timescale,ve:b.ve,ec:b.ec,gd:b.gd,timeline:b.timeline,bc:c&&wc(c),fe:d,mimeType:a.L.mimeType,codecs:a.L.codecs,bandwidth:a.bandwidth,Dk:f}}
function rw(a){var b=a.fe?1:0;b+=a.timeline?1:0;b+=a.gb?1:0;if(b==0)throw new U(2,4,4002);b!=1&&(a.fe&&(a.timeline=null),a.Qf=null,a.gb=null);if(!a.fe&&!a.bc)throw new U(2,4,4002);}
function sw(a,b,c,d,e,f,g,h){function k(K){var P=K-w,Q=P*v,N=b.Qf,M=P*N;"BigInt"in window&&M>Number.MAX_SAFE_INTEGER&&(M=BigInt(P)*BigInt(N));Q+=q;P=Q+v;N=Math.min(P,m());var R=[],S=b.Dk;if(S)for(var ka=(N-Q)/S,Y={},Ca=0;Ca<S;Y={bj:void 0},Ca++){var ya=Q+ka*Ca,wa=ya+ka;Y.bj=Ca;Y=new yj(ya,wa,function(Da){return function(){var xa=Jv(z,A,K,Da.bj,y,M);return Ec(E(),[xa],I())}}(Y),0,null,d,D,q,m(),[],"",null,null,zj,f);Y.codecs=a.L.codecs;Y.mimeType=a.L.mimeType;h==0?Ca>0&&Y.wd():Ca%h!=0&&Y.wd();R.push(Y)}Q=
new yj(Q,N,function(){if(S)return[];var Da=Jv(z,A,K,null,y,M);return Ec(E(),[Da],I())},0,null,d,D,q,m(),R,"",null,null,zj,f,R.length>0);Q.codecs=a.L.codecs;Q.mimeType=a.L.mimeType;Q.bandwidth=a.bandwidth;Q.j=P;return Q}function l(){var K=[Math.max(n.Hb(),q),Math.min(n.Ic(),m())].map(function(P){return P-q});K=[Math.ceil(K[0]/v),Math.ceil(K[1]/v)-1];a.L.rb&&K[1]++;return K.map(function(P){return P+w})}function m(){var K=r!=null&&e.get(r)||t;return K?q+K:Infinity}var n=a.presentationTimeline,q=a.na.start,
r=a.sa.id,t=a.na.duration,v=b.gb,w=b.ve,z=b.bc,y=a.bandwidth||null,A=a.L.originalId,E=a.L.bb,I=a.Lb,D=q-b.ec,C=l();c=a.Eb?Math.max(C[0],C[1]-c+1):C[0];g=g||C[1];C=[];for(var B=c;B<=g;++B){var J=k(B);C.push(J)}var F=new Ul(C);C=n.Ic()<m();B=n.W();if(C||B){var L=Math.max(c,g+1);c=v;a.L.rb&&(c=.1);F.Rf(c,function(){var K=n.Hb();F.Ya(K);var P=u(l());P.next();P=P.next().value;for(var Q=[];L<=P;){var N=k(L);Q.push(N);L++}return K>m()&&!Q.length?null:Q})}return Promise.resolve(F)}
function pw(a,b){var c=a.L.hf;c||(c=Lv(a,ow,"initialization"));if(!c)return null;c=wc(c);var d=a.L.originalId,e=a.bandwidth||null,f=a.L.bb,g=a.Lb;b=new wj(function(){var h=Jv(c,d,null,null,e,null);return Ec(f(),[h],g())},0,null,bw(a),null,null,b,a.qa.encrypted);b.codecs=a.L.codecs;b.mimeType=a.L.mimeType;a.na&&!a.na.kf&&(b.g=a.na.start+a.na.duration);return b}
function uw(a,b,c,d,e,f,g,h,k,l,m,n){Ul.call(this,[]);this.F=a;this.h=b;this.H=c;this.C=d;this.G=e;this.J=f;this.j=g;this.l=h;this.u=k;this.B=l;this.I=m;this.K=n;vw(this)}ma(uw,Ul);p=uw.prototype;p.getNumReferences=function(){return this.h?this.h.timeline.length:0};p.release=function(){Ul.prototype.release.call(this);this.h=null};
p.Ya=function(a){if(this.h){for(var b=0,c=this.h.timeline,d=0;d<c.length;d+=1)if(c[d].end+this.j<=a)b+=1;else break;b>0&&(this.h.timeline=c.slice(b),this.g.length>=b&&(this.g=this.g.slice(b)),this.i+=b,this.getNumReferences()===0&&this.release())}};
function tw(a,b,c,d,e,f){ww(a,e);a.F=f;if(a.h){if(a.h.gd!==b.gd)for(c=b.gd-a.h.gd,e=0;e<b.timeline.length;e++)f=b.timeline[e],f.Ld+=c,f.Jh+=c,f.start=(f.Ld+c)/b.timescale,f.end=(f.Jh+c)/b.timescale;a.h.bc!==b.bc&&(a.h.bc=b.bc);c=a.h.timeline;if(c.length){var g=c[c.length-1];b=b.timeline.filter(function(h){return h.end>g.end})}else b=b.timeline.slice();b.length>0&&a.h.timeline.push.apply(a.h.timeline,x(b));a.l!==d&&(a.l=d)}else a.h=b,a.j=c,a.l=d;vw(a)}
function ww(a,b){if(a.u!==b){a.u=b;a=u(a.g);for(var c=a.next();!c.done;c=a.next())(c=c.value)&&Cj(c,b)}}function vw(a){if(a.h&&!a.o){for(var b=[],c=u(a.h.timeline),d=c.next();!d.done;d=c.next())d=d.value,d.start>=a.l||d.end<=0||b.push(d);a.h.timeline=b;a.Ya(a.j)}}
p.find=function(a){if(this.h&&this.h.timeline&&this.h.timeline.length&&a<this.h.timeline[0].start+this.j)return this.i;if(!this.h)return null;var b=this.h.timeline;if(a<this.j||a>=this.l)return null;for(var c=b.length-1,d=0;d<b.length;d++){var e=b[d],f=e.start+this.j;e=d<c?b[d+1].start+this.j:this.l===Infinity?e.end+this.j:this.l;if(a>=f&&a<e)return d+this.i}return null};
p.get=function(a){var b=this;a-=this.i;if(a<0||a>=this.getNumReferences()||!this.h)return null;var c=this.g[a];if(!c){c=this.h.timeline[a];var d=c.Vk,e=c.Ld+this.h.gd,f=this.j-this.h.ec,g=this.j+c.end,h=g;a===this.getNumReferences()-1&&this.l!==Infinity&&(h=this.F&&Math.abs(h-this.l)>.1?Math.min(h,this.l):this.l);var k=this.h.codecs,l=this.h.mimeType,m=this.h.bandwidth,n=[],q=!1;c.wc&&this.h&&this.h.bc&&(q=this.h.bc.includes("$SubNumber$"));if(q){q=(c.end-c.start)/c.wc;for(var r={},t=0;t<c.wc;r={Tf:void 0,
cj:void 0},t++){var v=c.start+q*t,w=v+q;r.cj=t;r.Tf=null;r=new yj(this.j+v,this.j+w,function(z){return function(){if(!b.h)return[];z.Tf==null&&(z.Tf=xw(b.h.bc,b.H,d,b.C,e,z.cj,b.G,b.J));return z.Tf}}(r),0,null,this.u,f,this.j,this.l,[],"",null,null,zj,this.B);r.codecs=k;r.mimeType=l;r.bandwidth=m;this.I==0?t>0&&r.wd():t%this.I!=0&&r.wd();n.push(r)}}c=new yj(this.j+c.start,h,function(){return n.length>0||!b.h?[]:xw(b.h.bc,b.H,d,b.C,e,null,b.G,b.J)},0,null,this.u,f,this.j,this.l,n,"",null,null,zj,this.B,
n.length>0);c.codecs=k;c.mimeType=l;c.j=g;c.bandwidth=m;this.g[a]=c}return c};p.Fb=function(a){vw(this);for(var b=0;b<this.getNumReferences();b++){var c=this.get(b+this.i);c&&a(c)}};function xw(a,b,c,d,e,f,g,h){a=Jv(a,b,c,f,d||null,e);return Ec(g(),[a],h()).map(function(k){return k.toString()})}p.We=function(){return this.K};function yw(a){this.o=null;this.B=a;this.H=new Sg;this.i=[];this.h=null;this.m=[];this.C=null;this.G=[];this.F=300;this.l=new Map;this.j=new Map;this.g=null;this.u="UNKNOWN"}yw.prototype.configure=function(a){this.o=a};yw.prototype.destroy=function(){this.B=this.o=null;this.i=[];this.h=null;this.m=[];this.G=[];this.l.clear();this.g!=null&&(this.g.stop(),this.g=null);return this.H.destroy()};yw.prototype.setManifestType=function(a){this.u=a};
function zw(a,b){var c,d,e,f,g,h,k;return O(function(l){if(l.g==1)return c=Ec(a.i,[Aw(a,b)]),d=Zg(c,a.o.retryParameters),e=a.B.networkingEngine.request(8,d),Tg(a.H,e),sa(l,2),G(l,e.promise,4);if(l.g!=2)return f=l.h,g=oc(f.data),h=JSON.parse(g),h.VERSION==1&&Bw(a,h,f.uri),ua(l,0);if((k=Aa(l))&&k.code==7001)return l.return();a.g!=null&&(a.g.stop(),a.g=null);a.g=new rf(function(){zw(a,b)});a.g.ka(a.F);H(l)})}
function Aw(a,b){if(!a.m.length)return b;b=new Db(b);var c=a.C||a.m[0],d=Math.round(a.B.getBandwidthEstimate()),e=b.g;a.u=="DASH"?(e.add("_DASH_pathway",c),e.add("_DASH_throughput",String(d))):a.u=="HLS"&&(e.add("_HLS_pathway",c),e.add("_HLS_throughput",String(d)));Sb(e)&&Hb(b,e);return b.toString()}function Bw(a,b,c){a.g!=null&&(a.g.stop(),a.g=null);var d=b["RELOAD-URI"]||c;a.g=new rf(function(){zw(a,d)});if(c=b.TTL)a.F=c;a.g.ka(a.F);a.m=b["PATHWAY-PRIORITY"]||[];a.G=b["PATHWAY-CLONES"]||[]}
function Cw(a,b,c,d){var e=a.l.get(b);e||(e=new Map);e.set(c,d);a.l.set(b,e)}yw.prototype.banLocation=function(a){this.j.set(a,Date.now()+6E4)};
function Dw(a,b,c){c=c===void 0?!1:c;b=a.l.get(b)||new Map;for(var d=[],e=u(a.m),f=e.next(),g={};!f.done;g={Cd:void 0},f=e.next())if(g.Cd=f.value,f=b.get(g.Cd))d.push({ah:g.Cd,location:f});else if(f=a.G.find(function(k){return function(l){return l.Ol==k.Cd}}(g))){var h=b.get(f["BASE-ID"]);h&&(f["URI-REPLACEMENT"].oj?(h=new Db(h),Fb(h,f["URI-REPLACEMENT"].oj),d.push({ah:g.Cd,location:h.toString()})):d.push({ah:g.Cd,location:h}))}e=Date.now();g=u(a.j.keys());for(f=g.next();!f.done;f=g.next())f=f.value,
h=a.j.get(f),e>h&&a.j.delete(f);d=d.filter(function(k){for(var l=u(a.j.keys()),m=l.next();!m.done;m=l.next())if(m.value.includes((new Db(k.location)).Db))return!1;return!0});d.length&&(a.C=d[0].ah);d=d.map(function(k){return k.location});if(!d.length&&a.h)for(e=u(a.h.split(",")),g=e.next();!g.done;g=e.next())if(g=b.get(g.value))a.C=a.h,d.push(g);if(!d.length)for(b=u(b.values()),e=b.next();!e.done;e=b.next())d.push(e.value);return c?d:Ec(a.i,d)};function Ew(){this.l=[];this.h=[];this.g=[];this.j=[];this.i=[];this.o=!1;this.m=new Set}p=Ew.prototype;p.release=function(){for(var a=u(this.h.concat(this.g,this.j,this.i)),b=a.next();!b.done;b=a.next())b=b.value,b.segmentIndex&&b.segmentIndex.release();this.h=[];this.g=[];this.j=[];this.i=[];this.l=[];this.o=!1;this.m.clear()};p.fk=function(){return this.l};p.Mg=function(){return this.j.slice()};p.Mj=function(){return this.i};
p.Zh=function(a,b){if(a){if(a.type=="audio")for(var c=u(this.h),d=c.next();!d.done;d=c.next())d=d.value,d.matchedStreams=d.matchedStreams.filter(function(e){return e!==a});else if(a.type=="video")for(c=u(this.g),d=c.next();!d.done;d=c.next())d=d.value,d.matchedStreams=d.matchedStreams.filter(function(e){return e!==a}),d.trickModeVideo&&(d.trickModeVideo.matchedStreams=d.trickModeVideo.matchedStreams.filter(function(e){return e!==a})),d.dependencyStream&&(d.dependencyStream.matchedStreams=d.dependencyStream.matchedStreams.filter(function(e){return e!==
a}));else if(a.type==Kc)for(c=u(this.j),d=c.next();!d.done;d=c.next())d=d.value,d.matchedStreams=d.matchedStreams.filter(function(e){return e!==a});else if(a.type=="image")for(c=u(this.i),d=c.next();!d.done;d=c.next())d=d.value,d.matchedStreams=d.matchedStreams.filter(function(e){return e!==a});a.segmentIndex&&a.closeSegmentIndex();this.m.delete(b)}};
function Fw(a,b){var c=[],d=[],e=[],f=[];a=u(a);for(var g=a.next();!g.done;g=a.next()){var h=g.value;g=new Map(h.audioStreams.map(function(n){return[Gw(n),n]}));var k=new Map(h.videoStreams.map(function(n){return[Hw(n),n]})),l=new Map(h.textStreams.map(function(n){return[Iw(n),n]}));h=new Map(h.imageStreams.map(function(n){return[Jw(n),n]}));if(b){var m=Kw(Kc);l.set(Iw(m),m);m=Kw("image");h.set(Jw(m),m)}c.push(g);d.push(k);e.push(l);f.push(h)}return{Sh:c,mj:d,hj:e,pi:f}}
p.lg=function(a,b,c){c=c===void 0?!1:c;var d=this,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q,N,M,R,S,ka;return O(function(Y){if(Y.g==1){e=Mc;if(!b&&a.length==1)return f=Fw(a,!1),g=f.Sh,h=f.mj,k=f.hj,l=f.pi,d.h=Array.from(g[0].values()),d.g=Array.from(h[0].values()),d.j=Array.from(k[0].values()),d.i=Array.from(l[0].values()),Y.A(2);m=c?d.m.size:0;n=-1;for(q=0;q<a.length;q++)r=a[q],d.m.has(r.id)||(d.m.add(r.id),n==-1&&(n=q));if(n==-1)return Y.return();t=Fw(a,!0);v=t.Sh;w=t.mj;z=t.hj;y=t.pi;
return G(Y,Promise.all([Lw(d,d.h,v,n,Mw,Nw,m),Lw(d,d.g,w,n,Mw,Nw,m),Lw(d,d.j,z,n,Mw,Nw,m),Lw(d,d.i,y,n,Mw,Nw,m)]),2)}A=0;E=[];if(d.g.length&&d.h.length)for(L=u(d.h),K=L.next();!K.done;K=L.next())for(P=K.value,Q=u(d.g),N=Q.next();!N.done;N=Q.next())M=N.value,R=fc(P.drmInfos,M.drmInfos),P.drmInfos.length&&M.drmInfos.length&&!R.length||(S=(P.bandwidth||0)+(M.bandwidth||0),P.dependencyStream&&(S+=P.dependencyStream.bandwidth||0),M.dependencyStream&&(S+=M.dependencyStream.bandwidth||0),ka=A++,E.push({id:ka,
language:P.language,disabledUntilTime:0,primary:P.primary,audio:P,video:M,bandwidth:S,drmInfos:R,allowedByApplication:!0,allowedByKeySystem:!0,decodingInfos:[]}));else for(I=d.g.length?d.g:d.h,D=u(I),C=D.next();!C.done;C=D.next())B=C.value,J=A++,F=B.bandwidth||0,B.dependencyStream&&(F+=B.dependencyStream.bandwidth||0),E.push({id:J,language:B.language,disabledUntilTime:0,primary:B.primary,audio:B.type==e.aa?B:null,video:B.type==e.wa?B:null,bandwidth:F,drmInfos:B.drmInfos,allowedByApplication:!0,allowedByKeySystem:!0,
decodingInfos:[]});d.l=E;H(Y)})};
function Ow(a){var b,c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q;return O(function(N){switch(N.g){case 1:b=Mc;if(a.length==1)return N.return(a[0]);c=a.map(function(M){return new Map(M.filter(function(R){return R.type===b.aa}).map(function(R){return[Gw(R),R]}))});d=a.map(function(M){return new Map(M.filter(function(R){return R.type===b.wa}).map(function(R){return[Hw(R),R]}))});e=a.map(function(M){return new Map(M.filter(function(R){return R.type===b.Na}).map(function(R){return[Iw(R),R]}))});
f=a.map(function(M){return new Map(M.filter(function(R){return R.type===b.Yf}).map(function(R){return[Jw(R),R]}))});g=u(e);for(h=g.next();!h.done;h=g.next())k=h.value,l=Pw(b.Na),k.set(Iw(l),l);m=u(f);for(n=m.next();!n.done;n=m.next())q=n.value,r=Pw(b.Yf),q.set(Jw(r),r);t=new Ew;return G(N,Lw(t,[],c,0,Qw,Rw,0),2);case 2:return v=N.h,G(N,Lw(t,[],d,0,Qw,Rw,0),3);case 3:return w=N.h,G(N,Lw(t,[],e,0,Qw,Rw,0),4);case 4:return z=N.h,G(N,Lw(t,[],f,0,Qw,Rw,0),5);case 5:y=N.h;A=0;if(w.length&&v.length)for(B=
u(v),J=B.next();!J.done;J=B.next())for(F=J.value,L=u(w),K=L.next();!K.done;K=L.next())P=K.value,Q=A++,P.variantIds.push(Q),F.variantIds.push(Q);else for(E=w.concat(v),I=u(E),D=I.next();!D.done;D=I.next())C=D.value,C.variantIds=[A++];return N.return(w.concat(v).concat(z).concat(y))}})}
function Lw(a,b,c,d,e,f,g){var h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F;return O(function(L){switch(L.g){case 1:h=[];for(k=0;k<c.length;k++)k>=d?h.push(new Set(c[k].values())):h.push(new Set);l=u(b);m=l.next();case 2:if(m.done){L.A(4);break}n=m.value;return G(L,cx(a,n,c,d,f,h,g),5);case 5:q=L.h;if(!q)throw new U(2,4,4037);m=l.next();L.A(2);break;case 4:r=u(h);for(t=r.next();!t.done;t=r.next())for(v=t.value,w=u(v),z=w.next();!z.done;z=w.next())y=z.value,(A=dx(a,b,y,c,e,f,h))&&b.push(A);E=u(h);for(I=
E.next();!I.done;I=E.next())for(D=I.value,C=u(D),B=C.next(),J={};!B.done;J={yh:void 0},B=C.next())if(J.yh=B.value,!ex(J.yh)&&(F=b.some(function(K){return function(P){return fx(K.yh,P)}}(J))))throw new U(2,4,4037);return L.return(b)}})}function cx(a,b,c,d,e,f,g){return O(function(h){if(h.g==1)return gx(a,c,b,g>0),b.matchedStreams?b.segmentIndex?G(h,hx(b,d+g),2):h.A(2):h.return(!1);ix(b,d,e,f,g);return h.return(!0)})}
function hx(a,b){var c,d,e,f,g,h;return O(function(k){if(k.g==1){c=[];d=a.matchedStreams;for(e=b;e<d.length;e++)f=d[e],c.push(f.createSegmentIndex()),f.trickModeVideo&&!f.trickModeVideo.segmentIndex&&c.push(f.trickModeVideo.createSegmentIndex()),f.dependencyStream&&!f.dependencyStream.segmentIndex&&c.push(f.dependencyStream.createSegmentIndex());return G(k,Promise.all(c),2)}if(a.segmentIndex instanceof Xl)for(g=b;g<d.length;g++)h=d[g],h.segmentIndex&&a.segmentIndex.h.push(h.segmentIndex);H(k)})}
function dx(a,b,c,d,e,f,g){if(ex(c))return null;var h=e(c);gx(a,d,h);h.createSegmentIndex&&(h.createSegmentIndex=function(){return O(function(k){if(h.segmentIndex)return k.A(0);h.segmentIndex=new Xl;return G(k,hx(h,0),0)})},h.closeSegmentIndex=function(){h.segmentIndex&&(h.segmentIndex.release(),h.segmentIndex=null);if(h.matchedStreams)for(var k=u(h.matchedStreams),l=k.next();!l.done;l=k.next()){l=l.value;var m;if(m=l.segmentIndex){a:{m=u(b);for(var n=m.next();!n.done;n=m.next())if(n=n.value,n!==
h&&n.segmentIndex&&n.matchedStreams&&n.matchedStreams.includes(l)){m=!0;break a}m=!1}m=!m}m&&(l.segmentIndex.release(),l.segmentIndex=null)}});if(!h.matchedStreams||!h.matchedStreams.length)return null;ix(h,0,f,g,0);return h}
function ix(a,b,c,d,e){var f=a.matchedStreams;for(b+=e;b<f.length;b++){var g=f[b];c(a,g);var h=!0;a.type=="audio"&&Cf(a.language,g.language)==0&&(h=!1);if(h&&((h=d[b-e])&&h.delete(g),g.fullMimeTypes))for(g=u(g.fullMimeTypes.values()),h=g.next();!h.done;h=g.next())a.fullMimeTypes.add(h.value)}}
function Mw(a){var b=Object.assign({},a);b.originalId=null;b.createSegmentIndex=function(){return Promise.resolve()};b.closeSegmentIndex=function(){};b.roles=b.roles.slice();b.segmentIndex=null;b.emsgSchemeIdUris=[];b.keyIds=new Set(a.keyIds);b.closedCaptions=a.closedCaptions?new Map(a.closedCaptions):null;b.trickModeVideo=null;b.dependencyStream=null;return b}
function Qw(a){var b=Object.assign({},a);b.roles=b.roles.slice();b.keyIds=new Set(a.keyIds);b.segments=[];b.variantIds=[];b.closedCaptions=a.closedCaptions?new Map(a.closedCaptions):null;return b}
function Nw(a,b){function c(g,h){g||(g=[]);h=u(h);for(var k=h.next();!k.done;k=h.next())k=k.value,g.includes(k)||g.push(k);return g}a.roles=c(a.roles,b.roles);b.emsgSchemeIdUris&&(a.emsgSchemeIdUris=c(a.emsgSchemeIdUris,b.emsgSchemeIdUris));for(var d=u(b.keyIds),e=d.next();!e.done;e=d.next())a.keyIds.add(e.value);a.originalId==null?a.originalId=b.originalId:(d=b.originalId||"")&&!a.originalId.endsWith(d)&&(a.originalId+=","+d);d=fc(a.drmInfos,b.drmInfos);if(b.drmInfos.length&&a.drmInfos.length&&!d.length)throw new U(2,
4,4038);a.drmInfos=d;a.encrypted=a.encrypted||b.encrypted;if(b.closedCaptions)for(a.closedCaptions||(a.closedCaptions=new Map),d=u(b.closedCaptions),e=d.next();!e.done;e=d.next()){var f=u(e.value);e=f.next().value;f=f.next().value;a.closedCaptions.set(e,f)}a.bandwidth&&b.bandwidth&&(a.bandwidth=Math.max(a.bandwidth,b.bandwidth));b.trickModeVideo?(a.trickModeVideo||(a.trickModeVideo=Mw(b.trickModeVideo),a.trickModeVideo.matchedStreams=[],a.trickModeVideo.createSegmentIndex=function(){if(a.trickModeVideo.segmentIndex)return Promise.resolve();
for(var g=new Xl,h=u(a.trickModeVideo.matchedStreams),k=h.next();!k.done;k=h.next())g.h.push(k.value.segmentIndex);a.trickModeVideo.segmentIndex=g;return Promise.resolve()}),a.trickModeVideo.matchedStreams.push(b.trickModeVideo),Nw(a.trickModeVideo,b.trickModeVideo)):a.trickModeVideo&&(a.trickModeVideo.matchedStreams.push(b),Nw(a.trickModeVideo,b));b.dependencyStream?(a.dependencyStream||(a.dependencyStream=Mw(b.dependencyStream),a.dependencyStream.matchedStreams=[],a.dependencyStream.createSegmentIndex=
function(){if(a.dependencyStream.segmentIndex)return Promise.resolve();for(var g=new Xl,h=u(a.dependencyStream.matchedStreams),k=h.next();!k.done;k=h.next())g.h.push(k.value.segmentIndex);a.dependencyStream.segmentIndex=g;return Promise.resolve()}),a.dependencyStream.matchedStreams.push(b.dependencyStream),Nw(a.dependencyStream,b.dependencyStream)):a.dependencyStream&&(a.dependencyStream.matchedStreams.push(b),Nw(a.dependencyStream,b))}
function Rw(a,b){var c=a.roles;c||(c=[]);for(var d=u(b.roles),e=d.next();!e.done;e=d.next())e=e.value,c.includes(e)||c.push(e);a.roles=c;c=u(b.keyIds);for(d=c.next();!d.done;d=c.next())a.keyIds.add(d.value);a.encrypted=a.encrypted&&b.encrypted;a.segments.push.apply(a.segments,x(b.segments));if(b.closedCaptions)for(a.closedCaptions||(a.closedCaptions=new Map),b=u(b.closedCaptions),c=b.next();!c.done;c=b.next())d=u(c.value),c=d.next().value,d=d.next().value,a.closedCaptions.set(c,d)}
function gx(a,b,c,d){d=(d===void 0?0:d)?c.matchedStreams:[];b=u(b);for(var e=b.next();!e.done;e=b.next()){e=jx(a,e.value,c);if(!e)return;d.push(e)}c.matchedStreams=d}
function jx(a,b,c){var d={audio:Gw,video:Hw,text:Iw,image:Jw}[c.type],e=null,f=d(c);if(b.has(f))e=b.get(f);else{f={audio:function(l,m){return fx(l,m)},video:function(l,m){return fx(l,m)},text:kx,image:lx}[c.type];for(var g={audio:mx,video:nx,text:ox,image:px}[c.type],h=u(b.values()),k=h.next();!k.done;k=h.next())k=k.value,!f(c,k)||c.fastSwitching!=k.fastSwitching||e&&!g(c,e,k)||(e=k)}a.o&&!ex(e)&&b.delete(d(e));return e}
function qx(a,b){return a.mimeType!=b.mimeType?!1:rx(a.codecs)===rx(b.codecs)}p.Xi=function(a){this.o=a};function fx(a,b){return a.drmInfos&&!bc(a.drmInfos,b.drmInfos)?!1:!0}function kx(a,b){return b.language?a.forced!==b.forced||Cf(a.language,b.language)==0||b.kind!=a.kind?!1:!0:!0}function lx(){return!0}
function mx(a,b,c){var d=sx(a,b,c);if(d===tx)return!0;if(d===ux)return!1;d=Cf(a.language,b.language);var e=Cf(a.language,c.language);if(e>d)return!0;if(e<d)return!1;if(b.label!==c.label){if(a.label===b.label)return!1;if(a.label===c.label)return!0}if(a.roles.length){d=b.roles.filter(function(f){return a.roles.includes(f)});e=c.roles.filter(function(f){return a.roles.includes(f)});if(e.length>d.length)return!0;if(e.length<d.length)return!1;if(c.roles.length!==b.roles.length)return c.roles.length<b.roles.length}else{if(!c.roles.length&&
b.roles.length)return!0;if(c.roles.length&&!b.roles.length)return!1}if(!b.primary&&c.primary)return!0;if(b.primary&&!c.primary)return!1;d=vx(a.channelsCount,b.channelsCount,c.channelsCount);if(d==tx)return!0;if(d==ux)return!1;d=vx(a.audioSamplingRate,b.audioSamplingRate,c.audioSamplingRate);return d==tx?!0:d==ux?!1:a.bandwidth&&wx(a.bandwidth,b.bandwidth,c.bandwidth)==tx?!0:!1}
function nx(a,b,c){var d=sx(a,b,c);if(d===tx)return!0;if(d===ux)return!1;d=vx(a.width*a.height,b.width*b.height,c.width*c.height);if(d==tx)return!0;if(d==ux)return!1;if(a.frameRate){d=vx(a.frameRate,b.frameRate,c.frameRate);if(d==tx)return!0;if(d==ux)return!1}return a.bandwidth&&wx(a.bandwidth,b.bandwidth,c.bandwidth)==tx?!0:!1}
function ox(a,b,c){var d=Cf(a.language,b.language),e=Cf(a.language,c.language);if(e>d)return!0;if(e<d)return!1;if(!b.primary&&c.primary)return!0;if(b.primary&&!c.primary)return!1;if(b.label!==c.label){if(a.label===b.label)return!1;if(a.label===c.label)return!0}if(a.roles.length){d=b.roles.filter(function(f){return a.roles.includes(f)});e=c.roles.filter(function(f){return a.roles.includes(f)});if(e.length>d.length)return!0;if(e.length<d.length)return!1}else{if(!c.roles.length&&b.roles.length)return!0;
if(c.roles.length&&!b.roles.length)return!1}return c.mimeType!=a.mimeType||c.codecs!=a.codecs||b.mimeType==a.mimeType&&b.codecs==a.codecs?!1:!0}function px(a,b,c){return vx(a.width*a.height,b.width*b.height,c.width*c.height)==tx?!0:!1}
function Pw(a){return{id:0,originalId:"",groupId:null,primary:!1,type:a,mimeType:"",codecs:"",language:"",originalLanguage:null,label:null,width:null,height:null,encrypted:!1,keyIds:new Set,segments:[],variantIds:[],roles:[],forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,external:!1,fastSwitching:!1,isAudioMuxedInVideo:!1,baseOriginalId:null}}
function Kw(a){return{id:0,originalId:"",groupId:null,createSegmentIndex:function(){return Promise.resolve()},segmentIndex:new Ul([]),mimeType:"",codecs:"",encrypted:!1,drmInfos:[],keyIds:new Set,language:"",originalLanguage:null,label:null,type:a,primary:!1,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:null,roles:[],forced:!1,channelsCount:null,audioSamplingRate:null,spatialAudio:!1,closedCaptions:null,accessibilityPurpose:null,external:!1,fastSwitching:!1,fullMimeTypes:new Set,isAudioMuxedInVideo:!1,
baseOriginalId:null}}function vx(a,b,c){if(b==a&&a!=c)return ux;if(c==a&&a!=b)return tx;if(b>a){if(c<=a||c-a<b-a)return tx;if(c-a>b-a)return ux}else{if(c>a)return ux;if(a-c<a-b)return tx;if(a-c>a-b)return ux}return xx}function sx(a,b,c){var d=a.mimeType===b.mimeType&&a.codecs===b.codecs,e=a.mimeType===c.mimeType&&a.codecs===c.codecs;if(d&&!e)return ux;if(!d&&e)return tx;b=qx(a,b);a=qx(a,c);return b&&!a?ux:!b&&a?tx:xx}function wx(a,b,c){b=Math.abs(a-b);a=Math.abs(a-c);return a<b?tx:b<a?ux:xx}
function ex(a){switch(a.type){case Kc:return!a.language;case "image":return!a.tilesLayout;default:return!1}}function Hw(a){return yx([a.fastSwitching,a.width,a.frameRate,a.codecs,a.mimeType,a.label,a.roles,a.closedCaptions?Array.from(a.closedCaptions.entries()):null,a.bandwidth,a.dependencyStream?a.dependencyStream.baseOriginalId:null,Array.from(a.keyIds)])}
function Gw(a){return yx([a.fastSwitching,a.channelsCount,a.language,a.bandwidth,a.label,a.codecs,a.mimeType,a.roles,a.audioSamplingRate,a.primary,a.dependencyStream?a.dependencyStream.baseOriginalId:null,Array.from(a.keyIds)])}function Iw(a){return yx([a.language,a.label,a.codecs,a.mimeType,a.bandwidth,a.roles])}function Jw(a){return yx([a.width,a.codecs,a.mimeType])}function yx(a){return JSON.stringify(a)}function rx(a){if(!zx.has(a)){var b=Ye(a);zx.set(a,b)}return zx.get(a)}
T("shaka.util.PeriodCombiner",Ew);Ew.prototype.setUseStreamOnce=Ew.prototype.Xi;Ew.prototype.combinePeriods=Ew.prototype.lg;Ew.prototype.deleteStream=Ew.prototype.Zh;Ew.prototype.getImageStreams=Ew.prototype.Mj;Ew.prototype.getTextStreams=Ew.prototype.Mg;Ew.prototype.getVariants=Ew.prototype.fk;var tx=1,xx=0,ux=-1,zx=new Map;function Ax(a,b){var c=new DOMParser,d=Bx.value()(a);a=null;try{a=c.parseFromString(d,"text/xml")}catch(e){return null}c=a.documentElement;if(!c||c.getElementsByTagName("parsererror").length||c.tagName!=b)return null;if(!("createNodeIterator"in document))return c;for(b=document.createNodeIterator(a,NodeFilter.SHOW_ALL);a=b.nextNode();)if(a instanceof HTMLElement||a instanceof SVGElement)return null;return c}function Cx(a,b){try{var c=sc(a);return Ax(c,b)}catch(d){return null}}
var Bx=new qb(function(){if(typeof trustedTypes!=="undefined"){var a=trustedTypes.createPolicy("shaka-player#xml",{createHTML:function(b){return b}});return function(b){return a.createHTML(b)}}return function(b){return b}});function Dx(){var a=this;this.j=this.g=null;this.B=[];this.h=null;this.Fa=1;this.H=[];this.l={vf:"",type:"",profiles:[],uc:null,rb:0,bb:null,qe:0};this.u=new Map;this.C=new Map;this.o=new Map;this.F=new Map;this.za=new Map;this.m=new Ew;this.K=0;this.Da=new Va(5);this.M=new rf(function(){if(a.J&&!a.g.continueLoadingWhenPaused&&(a.I.Ma(a.J,"timeupdate"),a.J.paused)){a.I.Aa(a.J,"timeupdate",function(){return Ex(a)});return}Ex(a)});this.R=new Sg;this.O=null;this.G=[];this.ba=Infinity;this.va=!1;this.i=
null;this.N=0;this.T=!1;this.I=new kb;this.J=null;this.V=!1;this.$="";this.oa=function(){return!1};this.X=[];this.ma=new Set;this.ya=new Av}p=Dx.prototype;p.configure=function(a,b){var c=this.j&&a.updatePeriod!=this.g.updatePeriod&&a.updatePeriod>=0;this.g=a;b&&(this.oa=b);c&&this.h&&this.h.presentationTimeline.W()&&this.M.Jb();this.i&&this.i.configure(this.g);this.m&&this.m.Xi(this.g.dash.useStreamOnceInPeriodFlattening)};
p.start=function(a,b){var c=this,d;return O(function(e){if(e.g==1)return c.va=b.isLowLatencyMode(),c.B=[a],c.j=b,G(e,Fx(c),2);d=e.h;c.j&&Gx(c,d);if(!c.j)throw new U(2,7,7001);return e.return(c.h)})};
p.stop=function(){for(var a=u(this.o.values()),b=a.next();!b.done;b=a.next())b=b.value,b.segmentIndex&&b.segmentIndex.release();this.m&&this.m.release();this.g=this.j=null;this.B=[];this.h=null;this.o.clear();this.F.clear();this.u.clear();this.C.clear();this.l={vf:"",type:"",profiles:[],uc:null,rb:0,bb:null,qe:0};this.m=null;this.M!=null&&(this.M.stop(),this.M=null);this.i&&this.i.destroy();this.I&&(this.I.release(),this.I=null);this.ma.clear();this.ya.release();return this.R.destroy()};
p.update=function(){var a=this,b;return O(function(c){if(c.g==1)return sa(c,2),G(c,Fx(a),4);if(c.g!=2)return ua(c,0);b=Aa(c);if(!a.j||!b)return c.return();a.j.onError(b);H(c)})};p.onExpirationUpdated=function(){};p.onInitialVariantChosen=function(a){if(this.h&&this.h.presentationTimeline.W()){var b=a.video||a.audio;if(b&&b.segmentIndex){a=this.h.presentationTimeline.Ic();var c=b.segmentIndex.find(a);c!=null&&(b=b.segmentIndex.get(c))&&(this.K=b.endTime-a,Gx(this,0))}}};
p.banLocation=function(a){this.i&&this.i.banLocation(a)};p.setMediaElement=function(a){this.J=a};
function Fx(a){var b,c,d,e,f,g,h,k,l,m,n;return O(function(q){if(q.g==1)return b=4,c="MPD",d=Hx(a),e=a.B,d.length?(e=d,c="Patch",b=6):a.B.length>1&&a.i&&(f=Dw(a.i,"Location",!0),f.length&&(e=f)),g=Zg(e,a.g.retryParameters),h=Date.now(),G(q,Ix(a,g,0,{type:b}),2);if(q.g!=3){k=q.h;if(!a.j)return q.return(0);k.uri&&k.uri!=k.originalUri&&!a.B.includes(k.uri)&&a.B.unshift(k.uri);l=new Db(k.uri);a.$=l.g.toString();return G(q,Jx(a,k.data,k.uri,c),3)}m=Date.now();n=(m-h)/1E3;a.Da.sample(1,n);a.ma.clear();
return q.return(n)})}
function Jx(a,b,c,d){var e,f,g,h,k,l,m,n,q,r,t;return O(function(v){if(v.g==1){e=b;f=a.g.dash.manifestPreprocessor;g=Yn;if(f!=g){yb("manifest.dash.manifestPreprocessor configuration","Please Use manifest.dash.manifestPreprocessorTXml instead.");h=Cx(e,d);if(!h)throw new U(2,4,4001,c);f(h);e=uc(h.outerHTML)}k=zd(e,d);if(!k)throw new U(2,4,4001,c);l=a.g.dash.manifestPreprocessorTXml;m=Zn;l!=m&&l(k);if(d==="Patch")return v.return(Kx(a,k));if(n=a.g.dash.disableXlinkProcessing)return v.return(Lx(a,k,c));
q=a.g.dash.xlinkFailGracefully;r=Pv(k,a.g.retryParameters,q,c,a.j.networkingEngine);Tg(a.R,r);return G(v,r.promise,2)}t=v.h;return v.return(Lx(a,t,c))})}
function Lx(a,b,c){var d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K,P,Q,N,M,R,S,ka,Y,Ca,ya,wa,Da,xa,Ja,ra,Fa,va,za,pb,tb,tc,dc,pc,Uf,od,pd,Vf,qd,Rj,vh,wh;return O(function(fd){switch(fd.g){case 1:a.i&&a.i.l.clear();d=[c];e=[];f=new Map;g=Hd(b,"Location");h=u(g);for(k=h.next();!k.done;k=h.next())if(l=k.value,m=l.attributes.serviceLocation,n=Jd(l))q=Ec(d,[n])[0],m&&(a.i?Cw(a.i,"Location",m,q):f.set(m,q)),e.push(q);a.i?(r=Dw(a.i,"Location",!0),r.length>0&&(d=a.B=r)):e.length&&(d=a.B=e);a.l.vf=
b.attributes.id||"";a.l.qe=Od(b,"publishTime",Rd)||0;a.H=Hd(b,"PatchLocation");t=Promise.resolve();if((v=Ld(b,"ContentSteering"))&&a.j){w=v.attributes.defaultServiceLocation;if(a.i)a.i.i=d,a.i.h=w;else if(a.i=new yw(a.j),a.i.configure(a.g),a.i.setManifestType("DASH"),a.i.i=d,a.i.h=w,z=Jd(v))(y=Od(v,"queryBeforeStart",Zd,!1))?t=zw(a.i,z):zw(a.i,z);A=u(f.keys());for(E=A.next();!E.done;E=A.next())I=E.value,D=f.get(I),Cw(a.i,"Location",I,D)}C=Hd(b,"BaseURL");B=!1;if(a.i)for(J=u(C),F=J.next();!F.done;F=
J.next())L=F.value,K=L.attributes.serviceLocation,P=Jd(L),K&&P&&(Cw(a.i,"BaseURL",K,P),B=!0);a.X.splice(0);B&&a.i||(Q=C.map(Jd),a.X.push.apply(a.X,x(Ec(d,Q))));N=a.i;M=a.X;R=Mx;S=R.call(Dx,N,B,M);a.l.bb=S;ka=0;C&&C.length&&(ka=Od(C[0],"availabilityTimeOffset",Yd)||0);a.l.rb=ka;a.K=Od(b,"minimumUpdatePeriod",Sd,-1);Y=Od(b,"availabilityStartTime",Rd);Ca=Od(b,"timeShiftBufferDepth",Sd);ya=a.g.dash.ignoreSuggestedPresentationDelay;wa=null;ya||(wa=Od(b,"suggestedPresentationDelay",Sd));Da=a.g.dash.ignoreMaxSegmentDuration;
xa=null;Da||(xa=Od(b,"maxSegmentDuration",Sd));Ja=b.attributes.type||"static";a.h&&a.h.presentationTimeline&&(a.V=a.h.presentationTimeline.W()&&Ja=="static");a.l.type=Ja;if(a.h)for(ra=a.h.presentationTimeline,Fa=ra.Hb(),va=u(a.o.values()),za=va.next();!za.done;za=va.next())pb=za.value,pb.segmentIndex&&pb.segmentIndex.Ya(Fa);else tb=a.g.dash.ignoreMinBufferTime,tc=0,tb||(tc=Od(b,"minBufferTime",Sd)||0),dc=0,dc=wa!=null?Math.min(wa,Ca||Infinity):a.g.defaultPresentationDelay>0?a.g.defaultPresentationDelay:
Math.min(tc*1.5,Ca||Infinity),ra=new vl(Y,dc,a.g.dash.autoCorrectDrift);ra.cd(Ja=="static");(pc=ra.W())&&!isNaN(a.g.availabilityWindowOverride)&&(Ca=a.g.availabilityWindowOverride);Ca==null&&(Ca=Infinity);ra.Lf(Ca);Uf=b.attributes.profiles||"";a.l.profiles=Uf.split(",");od={Eb:Ja!="static",presentationTimeline:ra,sa:null,na:null,qa:null,L:null,bandwidth:0,Og:!1,rb:ka,uc:null,profiles:Uf.split(","),roles:null,Lb:Nx};return G(fd,t,2);case 2:a.N=0;pd=Ox(a,od,S,b,!1);Vf=pd.duration;qd=pd.periods;(Ja!=
"static"||a.V)&&pd.ai||ra.Ab(Vf||Infinity);a.T&&a.va&&ra.Ui(a.ba);ra.Wg(xa||1);a.T&&a.va&&(Rj=wa!=null?wa:a.g.defaultPresentationDelay,ra.rh(Rj));if(!a.h)return G(fd,a.m.lg(qd,od.Eb),6);a.h.periodCount=qd.length;a.h.gapCount=a.N;return G(fd,Px(a,qd,!1),4);case 6:var Sj=ra,Wf=a.m.l,xh=a.m.Mg(),Xf=a.m.i,Tj=a.g.dash.sequenceMode;var ub=Ld(b,"ServiceDescription");if(ub){var ec=Ld(ub,"Latency");ub=Ld(ub,"PlaybackRate");if(ec||ub){var Vb={};ec&&("target"in ec.attributes&&(Vb.targetLatency=parseInt(ec.attributes.target,
10)/1E3),"max"in ec.attributes&&(Vb.maxLatency=parseInt(ec.attributes.max,10)/1E3),"min"in ec.attributes&&(Vb.minLatency=parseInt(ec.attributes.min,10)/1E3));ub&&("max"in ub.attributes&&(Vb.maxPlaybackRate=parseFloat(ub.attributes.max)),"min"in ub.attributes&&(Vb.minPlaybackRate=parseFloat(ub.attributes.min)));ec=Vb}else ec=null}else ec=null;a:{ub=Hd(b,"SupplementalProperty");if(ub.length)for(ub=u(ub),Vb=ub.next();!Vb.done;Vb=ub.next())if(Vb=Vb.value,Vb.attributes.schemeIdUri=="urn:mpeg:dash:chaining:2016"){ub=
Vb.attributes.value;break a}ub=null}a.h={presentationTimeline:Sj,variants:Wf,textStreams:xh,imageStreams:Xf,offlineSessionIds:[],sequenceMode:Tj,ignoreManifestTimestampsInSegmentsMode:!1,type:"DASH",serviceDescription:ec,nextUrl:ub,periodCount:qd.length,gapCount:a.N,isLowLatency:a.T,startTime:null};if(!ra.kj()){fd.A(7);break}vh=Hd(b,"UTCTiming");return G(fd,Qx(a,S,vh),8);case 8:wh=fd.h;if(!a.j)return fd.return();ra.Vi(wh);case 7:ra.qf(),a.m&&!a.h.presentationTimeline.W()&&a.m.release();case 4:a.j.makeTextStreamsForClosedCaptions(a.h),
Rx(a),Sx(a,qd),H(fd)}})}function Px(a,b,c){var d;return O(function(e){if(e.g==1)return G(e,a.m.lg(b,!0,c),2);a.h.variants=a.m.l;d=a.m.Mg();d.length>0&&(a.h.textStreams=d);a.h.imageStreams=a.m.i;a.j.filter(a.h);H(e)})}
function Kx(a,b){var c,d,e,f,g,h,k,l,m,n,q,r,t,v,w,z,y,A,E,I,D,C,B,J,F,L,K;return O(function(P){if(P.g==1){c=b.attributes.mpdId;d=Od(b,"originalPublishTime",Rd);if(!c||c!==a.l.vf||d!==a.l.qe)throw a.H=[],new U(1,4,4052);e=[];f=[];g=new Set;h=u(Gd(b));for(k=h.next();!k.done;k=h.next())if(l=k.value,m=ae(l.attributes.sel||""),n=m[m.length-1],q=Jd(l)||"",n.name==="MPD")if(n.Dc==="mediaPresentationDuration"){r=Jd(l)||"";var Q=Sd(r);if(Q!=null){a.l.uc=Q;for(var N=u(a.u.values()),M=N.next();!M.done;M=N.next())M.value.uc=
Q}}else if(n.Dc==="type"){a.h.presentationTimeline.cd(q=="static");a.l.type=q;Q=u(a.u.values());for(N=Q.next();!N.done;N=Q.next())N.value.Eb=q=="dynamic";q=="static"&&(a.K=-1)}else n.Dc==="publishTime"?a.l.qe=Rd(q)||0:n.Dc===null&&l.tagName==="add"&&f.push(l);else if(n.name==="PatchLocation")be(a.H,l);else if(n.name==="Period")l.tagName==="add"?f.push(l):l.tagName==="remove"&&n.id&&Tx(a,n.id);else if(n.name==="SegmentTemplate"){N=ae(l.attributes.sel||"");Q=N[N.length-1];if(Q.Dc){N=Ux(a,N);M=Jd(l)||
"";for(var R=u(N),S=R.next();!S.done;S=R.next())S=a.u.get(S.value),de(S.L.Oc,l.tagName,Q.Dc,M);Q=N}else Q=[];t=Q;v=u(t);for(w=v.next();!w.done;w=v.next())z=w.value,g.add(z)}else if(n.name==="SegmentTimeline"||n.name==="S"){Q=ae(l.attributes.sel||"");Q=Ux(a,Q);N=u(Q);for(M=N.next();!M.done;M=N.next())M=a.u.get(M.value),M=Mv(M,ow,"SegmentTimeline"),R=Hd(M,"S"),be(R,l),M.children=R;y=Q;A=u(y);for(E=A.next();!E.done;E=A.next())I=E.value,g.add(I)}D=u(g);for(C=D.next();!C.done;C=D.next())B=C.value,Vx(a,
B);J=u(f);for(F=J.next();!F.done;F=J.next())L=F.value,e.push.apply(e,x(Ox(a,{Eb:a.l.type=="dynamic",presentationTimeline:a.h.presentationTimeline,sa:null,na:null,qa:null,L:null,bandwidth:0,Og:!1,rb:a.l.rb,profiles:a.l.profiles,uc:a.l.uc,roles:null,Lb:Nx},a.l.bb,L,!0).periods));if(!e.length)return P.A(2);a.h.periodCount+=e.length;a.h.gapCount=a.N;return G(P,Px(a,e,!0),2)}a.l.type=="static"&&(K=a.l.uc,a.h.presentationTimeline.Ab(K||Infinity));H(P)})}
function Tx(a,b){a.h.periodCount--;for(var c=u(a.u.keys()),d=c.next();!d.done;d=c.next())if(d=d.value,d.startsWith(b)){var e=a.u.get(d);Mv(e,ow,"SegmentTimeline").children=[];Vx(a,d);a.u.delete(d)}a.G=a.G.filter(function(f){return f!==b})}
function Ux(a,b){var c="",d="",e=-1,f="";b=u(b);for(var g=b.next();!g.done;g=b.next())g=g.value,g.name==="Period"?c=g.id:g.name==="AdaptationSet"?(d=g.id,g.position!==null&&(e=g.position)):g.name==="Representation"&&(f=g.id);b=[];if(f)b.push(c+","+f);else if(d)for(e=u(a.u.values()),a=e.next();!a.done;a=e.next())a=a.value,a.sa.id===c&&a.qa.id===d&&a.L.id&&b.push(c+","+a.L.id);else if(e>-1)for(d=u(a.u.values()),a=d.next();!a.done;a=d.next())a=a.value,a.sa.id===c&&a.qa.position===e&&a.L.id&&b.push(c+
","+a.L.id);return b}function Vx(a,b){var c=a.u.get(b),d=a.o.get(b);d.segmentIndex&&d.segmentIndex.Ya(a.h.presentationTimeline.Hb());try{var e=nw(c,function(f,g,h,k){return Wx(a,f,g,h,k)},a.o,!0,a.g.dash.initialSegmentLimit,a.za,c.L.aesKey,null,!0,a.C);d.createSegmentIndex=function(){return O(function(f){if(f.g==1)return d.segmentIndex?f.A(0):G(f,e.Sc(),3);d.segmentIndex=f.h;H(f)})}}catch(f){if(b=c.L.contentType,b!=Kc&&b!="application"&&b!="image"||f.code!=4002)throw f;}}
function Ox(a,b,c,d,e){var f=b.uc;f||(f=Od(d,"mediaPresentationDuration",Sd),a.l.uc=f);var g=0;a.h&&a.h.presentationTimeline&&a.V&&(g=a.h.presentationTimeline.Zb());var h=[],k=g;d=Hd(d,"Period");for(var l=0;l<d.length;l++){var m=d[l],n=d[l+1],q=Od(m,"start",Sd,k),r=m.attributes.id,t=Od(m,"duration",Sd);q=l==0&&q==0&&a.V?g:q;var v=null;if(n){var w=Od(n,"start",Sd);w!=null&&(v=w-q+g)}else f!=null&&(v=f-q+g);w=Nc;v&&t&&Math.abs(v-t)>w&&v>t&&a.N++;v==null&&(v=t);if(!(a.O!==null&&r!==null&&q!==null&&q<
a.O)||a.G.includes(r)||l+1==d.length){q!==null&&(a.O===null||q>a.O)&&(a.O=q);k=Xx(a,b,c,{start:q,duration:v,node:m,kf:v==null||!n});h.push(k);b.sa.id&&v&&a.za.set(b.sa.id,v);if(v==null){k=null;break}k=q+v}}if(e)for(b=u(h),c=b.next();!c.done;c=b.next())c=c.value.id,a.G.includes(c)||a.G.push(c);else a.G=h.map(function(z){return z.id});return f!=null?{periods:h,duration:f+g,ai:!1}:{periods:h,duration:k,ai:!0}}
function Rx(a){var b=Array.from(a.F.keys()).filter(function(h){return!a.G.includes(h)});b=u(b);for(var c=b.next();!c.done;c=b.next()){c=c.value;for(var d=!0,e=u(a.F.get(c)),f=e.next();!f.done;f=e.next()){f=f.value;var g=a.o.get(f);g&&(g.segmentIndex&&g.segmentIndex.getNumReferences()!=0?d=!1:(a.m&&a.m.Zh(g,c),a.o.delete(f)))}d&&a.F.delete(c)}}function Sx(a,b){b=new Set(b.map(function(e){return e.id}));for(var c=u(a.C.keys()),d=c.next();!d.done;d=c.next())d=d.value,b.has(d)||a.C.delete(d)}
function Xx(a,b,c,d){b.sa=Yx(a,d.node,null,c);b.na=d;b.sa.rb=b.rb;b.sa.id||(b.sa.id="__shaka_period_"+d.start);var e=Hd(d.node,"EventStream");c=b.presentationTimeline.Hb();e=u(e);for(var f=e.next();!f.done;f=e.next())Zx(a,d.start,d.duration,f.value,c);c=Hd(d.node,"SupplementalProperty");c=u(c);for(e=c.next();!e.done;e=c.next())if(e=e.value,e.attributes.schemeIdUri=="urn:mpeg:dash:urlparam:2014"&&(e=$x(a,e)))b.Lb=e;c=Hd(d.node,"AdaptationSet").map(function(r,t){return ay(a,b,t,r)}).filter(uf);if(b.Eb){e=
[];f=u(c);for(var g=f.next();!g.done;g=f.next()){g=u(g.value.Rk);for(var h=g.next();!h.done;h=g.next())e.push(h.value)}if(e.length!=(new Set(e)).size)throw new U(2,4,4018);}e=new Map;f=u(c);for(g=f.next();!g.done;g=f.next())for(g=u(g.value.Aj),h=g.next();!h.done;h=g.next()){var k=u(h.value);h=k.next().value;k=k.next().value;e.set(h,k)}if(e.size)for(f=null,g=u(c),h=g.next();!h.done;h=g.next()){h=h.value;k=[];for(var l=u(h.streams),m=l.next(),n={};!m.done;n={Ah:void 0},m=l.next())if(n.Ah=m.value,e.has(n.Ah.originalId)){f||
(f=Hd(d.node,"AdaptationSet").map(function(r,t){return ay(a,b,t,r)}).filter(uf));m=u(f);for(var q=m.next();!q.done;q=m.next())if(q=q.value.streams.find(function(r){return function(t){return t.originalId==r.Ah.originalId}}(n)))q.dependencyStream=e.get(q.originalId),q.originalId+=q.dependencyStream.originalId,k.push(q)}k.length&&h.streams.push.apply(h.streams,x(k))}d=c.filter(function(r){return!r.Hh});c=c.filter(function(r){return r.Hh});if(!a.g.disableIFrames)for(c=u(c),e=c.next();!e.done;e=c.next())for(e=
e.value,f=e.Hh.split(" "),g=u(d),h=g.next();!h.done;h=g.next())if(h=h.value,f.includes(h.id))for(h=u(h.streams),k=h.next();!k.done;k=h.next())wg(k.value,e.streams);c=by(a.g.disableAudio,d,"audio");e=by(a.g.disableVideo,d,"video");f=by(a.g.disableText,d,Kc);d=by(a.g.disableThumbnails,d,"image");if(e.length===0&&c.length===0)throw new U(2,4,4004);return{id:b.sa.id,audioStreams:c,videoStreams:e,textStreams:f,imageStreams:d}}
function by(a,b,c){return a||!b.length?[]:b.reduce(function(d,e){if(e.contentType!=c)return d;d.push.apply(d,x(e.streams));return d},[])}
function ay(a,b,c,d){function e(K){var P=K.attributes["dvb:fontFamily"];K=K.attributes["dvb:url"];P&&K&&(K=Ec(b.qa.bb(),[K],b.Lb()),a.j.addFont(P,K[0]))}function f(K){switch(K){case 1:case 5:case 6:case 7:return"srgb";case 9:return"rec2020";case 11:case 12:return"p3"}}function g(K){switch(K){case 1:case 6:case 13:case 14:case 15:return"SDR";case 16:return"PQ";case 18:return"HLG"}}b.qa=Yx(a,d,b.sa,null);b.qa.position=c;var h=!1;c=Hd(d,"Role");var k=c.map(function(K){return K.attributes.value}).filter(uf),
l=void 0,m=b.qa.contentType==Kc;m&&(l="subtitle");c=u(c);for(var n=c.next();!n.done;n=c.next()){n=n.value;var q=n.attributes.schemeIdUri;if(q==null||q=="urn:mpeg:dash:role:2011")switch(n=n.attributes.value,n){case "main":h=!0;break;case "caption":case "subtitle":l=n}}var r=Hd(d,"EssentialProperty");c=null;var t=!1;n=null;q=!1;r=u(r);for(var v=r.next();!v.done;v=r.next()){v=v.value;var w=v.attributes.schemeIdUri;if(w=="http://dashif.org/guidelines/trickmode")c=v.attributes.value;else if(w=="urn:mpeg:mpegB:cicp:TransferCharacteristics")var z=
g(parseInt(v.attributes.value,10));else if(w=="urn:mpeg:mpegB:cicp:ColourPrimaries")var y=f(parseInt(v.attributes.value,10));else w!="urn:mpeg:mpegB:cicp:MatrixCoefficients"&&(w=="urn:mpeg:dash:ssr:2023"&&a.g.dash.enableFastSwitching?t=!0:w=="urn:dvb:dash:fontdownload:2014"?e(v):w=="urn:mpeg:dash:urlparam:2014"?(n=$x(a,v))||(q=!0):q=!0)}if(q)return null;var A=null;q=Hd(d,"SupplementalProperty");q=u(q);for(r=q.next();!r.done;r=q.next())r=r.value,v=r.attributes.schemeIdUri,v=="http://dashif.org/guidelines/last-segment-number"?
A=parseInt(r.attributes.value,10)-1:v=="urn:mpeg:mpegB:cicp:TransferCharacteristics"?z=g(parseInt(r.attributes.value,10)):v=="urn:mpeg:mpegB:cicp:ColourPrimaries"?y=f(parseInt(r.attributes.value,10)):v=="urn:dvb:dash:fontdownload:2014"?e(r):v=="urn:mpeg:dash:urlparam:2014"&&(n=$x(a,r));n&&(b.Lb=n);n=Hd(d,"Accessibility");var E=new Map,I;n=u(n);for(q=n.next();!q.done;q=n.next())if(r=q.value,q=r.attributes.schemeIdUri,r=r.attributes.value,q!="urn:scte:dash:cc:cea-608:2015"||a.g.disableText)if(q!="urn:scte:dash:cc:cea-708:2015"||
a.g.disableText)q=="urn:mpeg:dash:role:2011"?r!=null&&(k.push(r),r=="captions"&&(l="caption")):q=="urn:tva:metadata:cs:AudioPurposeCS:2007"&&(r=="1"?I="visually impaired":r=="2"?I="hard of hearing":r=="9"&&(I="spoken subtitles"));else if(q=1,r!=null)for(r=u(r.split(";")),v=r.next();!v.done;v=r.next()){w=v.value;var D=v=void 0;w.includes("=")?(w=w.split("="),v="svc"+w[0],D=w[1].split(",")[0].split(":").pop()):(v="svc"+q,q++,D=w);E.set(v,yf(D))}else E.set("svc1","und");else if(q=1,r!=null)for(r=r.split(";"),
v=u(r),w=v.next();!w.done;w=v.next()){D=w.value;var C=w=void 0;D.includes("=")?(D=D.split("="),w=D[0].startsWith("CC")?D[0]:"CC"+D[0],C=D[1]||"und"):(w="CC"+q,r.length==2?q+=2:q++,C=D);E.set(w,yf(C))}else E.set("CC1","und");n=Hd(d,"ContentProtection");var B=Bv(a.ya,n,a.g.ignoreDrmInfo,a.g.dash.keySystemsByURI);b.qa.encrypted=n.length>0;var J=yf(b.qa.language||"und"),F=b.qa.label,L=new Map;d=Hd(d,"Representation");if(!a.g.ignoreSupplementalCodecs){n=[];q=u(d);for(r=q.next();!r.done;r=q.next())if(v=
r.value,r=Pd(v,"urn:scte:dash:scte214-extensions","supplementalCodecs"))v=wd(v),v.attributes.codecs=r.split(" ").join(","),v.attributes.id&&(v.attributes.supplementalId=v.attributes.id+"_supplementalCodecs"),n.push(v);d.push.apply(d,x(n))}n=d.map(function(K){var P=cy(a,b,B,l,J,F,h,k,E,K,I,A);return P&&(P.hdr=P.hdr||z,P.colorGamut=P.colorGamut||y,P.fastSwitching=t,K=K.attributes.dependencyId)?(P.baseOriginalId=K,L.set(K,P),null):P}).filter(function(K){return!!K});if(n.length==0&&L.size==0){c=b.qa.contentType==
"image";if(a.g.dash.ignoreEmptyAdaptationSet||m||c)return null;throw new U(2,4,4003);}if(!b.qa.contentType||b.qa.contentType=="application")for(b.qa.contentType=dy(n[0].mimeType,n[0].codecs),m=u(n),q=m.next();!q.done;q=m.next())q.value.type=b.qa.contentType;m=b.qa.id||"__fake__"+a.Fa++;q=u(n);for(r=q.next();!r.done;r=q.next()){r=r.value;v=u(B.drmInfos);for(w=v.next();!w.done;w=v.next())w=w.value,w.keyIds=w.keyIds&&r.keyIds?new Set([].concat(x(w.keyIds),x(r.keyIds))):w.keyIds||r.keyIds;a.g.enableAudioGroups&&
(r.groupId=m)}d=d.map(function(K){return K.attributes.supplementalId||K.attributes.id}).filter(uf);return{id:m,contentType:b.qa.contentType,language:J,Fm:h,streams:n,drmInfos:B.drmInfos,Hh:c,Rk:d,Aj:L}}
function $x(a,b){if((b=Md(b,"urn:mpeg:dash:schema:urlparam:2014","UrlQueryInfo"))&&Od(b,"useMPDUrlQuery",Zd,!1)){var c=b.attributes.queryTemplate;if(c)return function(){return c=="$querypart$"?a.$:c.split("&").map(function(d){if(d=="$querypart$")return a.$;var e=/\$query:(.*?)\$/g.exec(d);if(e&&e.length==2){e=e[1];var f=(new Jb(a.$)).get(e);if(f.length)return e+"="+f[0]}return d}).join("&")}}return null}
function cy(a,b,c,d,e,f,g,h,k,l,m,n){b.L=Yx(a,l,b.qa,null);var q=b.L.id;a.ba=Math.min(a.ba,b.L.rb);a.T=a.ba>0;if(!ey(b.L))return null;var r=b.na.start;b.bandwidth=Od(l,"bandwidth",Wd)||0;b.roles=h;var t=Hd(l,"SupplementalProperty"),v=Hd(l,"EssentialProperty"),w=Hd(l,"ContentProtection");l=null;var z=v.find(function(N){return N.attributes.schemeIdUri=="urn:mpeg:dash:urlparam:2014"});z?l=$x(a,z):(z=t.find(function(N){return N.attributes.schemeIdUri=="urn:mpeg:dash:urlparam:2014"}))&&(l=$x(a,z));l&&
(b.Lb=l);z=b.L.contentType;l=z==Kc||z=="application";z=z=="image";w.length&&(b.qa.encrypted=!0);try{var y=void 0;if(c.hg){var A=b.L.bb,E=b.Lb,I=Ec(A(),[c.hg.wk],E()),D=Zg(I,a.g.retryParameters);y={bitsKey:128,blockCipherMode:"CBC",iv:c.hg.iv,firstMediaSequenceNumber:0,fetchKey:function(){var N,M,R;return O(function(S){if(S.g==1)return G(S,Ix(a,D,6),2);if(S.g!=3){N=S.h;if(!N.data||N.data.byteLength!=16)throw new U(2,4,4049);M={name:"AES-CBC"};R=y;return G(S,window.crypto.subtle.importKey("raw",N.data,
M,!0,["decrypt"]),3)}R.cryptoKey=S.h;y.fetchKey=void 0;H(S)})}}}b.L.aesKey=y;A=function(N,M,R,S){return Wx(a,N,M,R,S)};if(b.L.Id)var C=cw(b,A,y);else if(b.L.Ac)C=iw(b,a.o,y);else if(b.L.Oc)C=nw(b,A,a.o,!!a.h,a.g.dash.initialSegmentLimit,a.za,y,n,!1,a.C);else{var B=b.na.duration||0,J=b.L.bb,F=b.L.mimeType,L=b.L.codecs;C={endTime:-1,timeline:-1,Sc:function(){var N=Wl(r,B,J());N.Fb(function(M){M.mimeType=F;M.codecs=L});return Promise.resolve(N)},timescale:1}}}catch(N){if((l||z)&&N.code==4002)return null;
throw N;}n=Fv(a.ya,w,c,a.g.ignoreDrmInfo,a.g.dash.keySystemsByURI);n=new Set(n?[n]:[]);w=!1;t.some(function(N){return N.attributes.schemeIdUri=="tag:dolby.com,2018:dash:EC3_ExtensionType:2018"&&N.attributes.value=="JOC"})&&(w=!0);t=!1;l&&(t=h.includes("forced_subtitle")||h.includes("forced-subtitle"));var K;if(z&&((v=v.find(function(N){return["http://dashif.org/thumbnail_tile","http://dashif.org/guidelines/thumbnail_tile"].includes(N.attributes.schemeIdUri)}))&&(K=v.attributes.value),!K))return null;
var P;l=b.L.codecs;b.profiles.includes("http://dashif.org/guidelines/dash-if-uhd#hevc-hdr-pq10")&&(l.includes("hvc1.2.4.L153.B0")||l.includes("hev1.2.4.L153.B0"))&&(P="PQ");v=b.L.id?b.sa.id+","+b.L.id:"";a.H.length&&q&&a.u.set(b.sa.id+","+q,fy(b));b.L.Cf&&gy(a,b.L.Cf,C,b.presentationTimeline);C.endTime!=-1&&b.sa.id!=null&&b.L.id!=null&&((q=a.C.get(b.sa.id))?(q.endTime=C.endTime,q.gh.includes(b.L.id)||q.gh.push(b.L.id),a.C.set(b.sa.id,q)):a.C.set(b.sa.id,{endTime:C.endTime,timeline:C.timeline,gh:[b.L.id]}));
var Q=v&&a.o.has(v)?a.o.get(v):{id:a.Fa++,originalId:b.L.id,groupId:null,createSegmentIndex:function(){return Promise.resolve()},closeSegmentIndex:function(){Q.segmentIndex&&(Q.segmentIndex.release(),Q.segmentIndex=null)},segmentIndex:null,mimeType:b.L.mimeType,codecs:l,frameRate:b.L.frameRate,pixelAspectRatio:b.L.pixelAspectRatio,bandwidth:b.bandwidth,width:b.L.width,height:b.L.height,kind:d,encrypted:c.drmInfos.length>0,drmInfos:c.drmInfos,keyIds:n,language:e,originalLanguage:b.qa.language,label:f,
type:b.qa.contentType,primary:g,trickModeVideo:null,dependencyStream:null,emsgSchemeIdUris:b.L.emsgSchemeIdUris,roles:h,forced:t,channelsCount:b.L.yf,audioSamplingRate:b.L.audioSamplingRate,spatialAudio:w,closedCaptions:k,hdr:P,colorGamut:void 0,videoLayout:void 0,tilesLayout:K,accessibilityPurpose:m,external:!1,fastSwitching:!1,fullMimeTypes:new Set([Se(b.L.mimeType,b.L.codecs)]),isAudioMuxedInVideo:!1,baseOriginalId:null};Q.createSegmentIndex=function(){var N;return O(function(M){if(M.g==1){if(Q.segmentIndex)return M.A(0);
N=Q;return G(M,C.Sc(),3)}N.segmentIndex=M.h;H(M)})};v&&b.Eb&&!a.o.has(v)&&(b=b.sa.id||"",a.F.has(b)||a.F.set(b,[]),a.o.set(v,Q),a.F.get(b).push(v));return Q}
function gy(a,b,c,d){if(!a.ma.has(b)){a.ma.add(b);var e=Od(b,"presentationTime",Xd)||0,f=Ld(b,"UTCTiming"),g;if(g=f&&f.attributes.schemeIdUri)f=f.attributes.schemeIdUri,g=!(f==="urn:mpeg:dash:utc:http-ntp:2014"||f==="urn:mpeg:dash:utc:ntp:2014"||f==="urn:mpeg:dash:utc:sntp:2014");g?b=(Od(b,"wallClockTime",Rd)||0)*1E3:(b=Od(b,"wallClockTime",Xd)||0,b=bk(b));c=new Date(b-e/c.timescale*1E3);e=c.getTime()/1E3;isNaN(e)||(d.o||d.sh(e),d=(new Map).set("detail",{wallClockTime:b,programStartDate:c}),d=new V("prft",
d),a.j.onEvent(d))}}function fy(a){function b(c){if(!c)return null;c=xd(c);c.Id=null;c.Ac=null;c.Oc=fe(c.Oc);c.Cf=null;return c}a=xd(a);a.sa=b(a.sa);a.qa=b(a.qa);a.L=b(a.L);a.na&&(a.na=xd(a.na),a.na.node=null);return a}
function Ex(a){var b,c;return O(function(d){switch(d.g){case 1:return b=0,sa(d,2),G(d,Fx(a),4);case 4:b=d.h;ua(d,3);break;case 2:if(c=Aa(d),a.j){if(a.g.raiseFatalErrorOnManifestUpdateRequestFailure)return a.j.onError(c),d.return();c.severity=1;a.j.onError(c)}case 3:if(!a.j)return d.return();a.j.onManifestUpdated();Gx(a,b);H(d)}})}function Gx(a,b){if(!(a.K<0)){var c=a.K;a.g.updatePeriod>=0&&(c=a.g.updatePeriod);a.M.ka(Math.max(c-b,Wa(a.Da)))}}
function Yx(a,b,c,d){c=c||{contentType:"",mimeType:"",codecs:"",emsgSchemeIdUris:[],frameRate:void 0,pixelAspectRatio:void 0,yf:null,audioSamplingRate:null,rb:0,If:1,encrypted:!1};d=d||c.bb;var e=b.attributes.id,f=b.attributes.supplementalId,g=Hd(b,"BaseURL"),h,k=!1;if(a.i)for(var l=u(g),m=l.next();!m.done;m=l.next()){var n=m.value;m=n.attributes.serviceLocation;n=Jd(n);m&&n&&(Cw(a.i,e,m,n),k=!0)}k&&a.i||(h=g.map(Jd));var q=a.i;a=b.attributes.contentType||c.contentType;l=b.attributes.mimeType||c.mimeType;
m=Am([b.attributes.codecs||c.codecs]).join(",");n=Od(b,"frameRate",$d)||c.frameRate;var r=b.attributes.sar||c.pixelAspectRatio,t=hy(Hd(b,"InbandEventStream"),c.emsgSchemeIdUris),v=Hd(b,"AudioChannelConfiguration");v=iy(v)||c.yf;var w=Od(b,"audioSamplingRate",Xd)||c.audioSamplingRate;a||(a=dy(l,m));var z=Ld(b,"SegmentBase"),y=Ld(b,"SegmentTemplate"),A=z?Od(z,"availabilityTimeOffset",Yd)||0:0,E=y?Od(y,"availabilityTimeOffset",Yd)||0:0,I=g&&g.length?Od(g[0],"availabilityTimeOffset",Yd)||0:0;A=c.rb+I+
A+E;E=null;(I=Ld(b,"SegmentSequenceProperties"))&&(I=Od(I,"cadence",Wd))&&(E=I);I=b.attributes.label;var D=Hd(b,"Label");D&&D.length&&(D=D[0],Id(D)&&(I=Id(D)));return{bb:function(){return Ec(d(),g.length?q&&k?Dw(q,e):h?h:[]:[])},Id:z||c.Id,Ac:Ld(b,"SegmentList")||c.Ac,Oc:y||c.Oc,Cf:Ld(b,"ProducerReferenceTime")||c.Cf,width:Od(b,"width",Xd)||c.width,height:Od(b,"height",Xd)||c.height,contentType:a,mimeType:l,codecs:m,frameRate:n,pixelAspectRatio:r,emsgSchemeIdUris:t,id:f||e,originalId:e,language:b.attributes.lang,
yf:v,audioSamplingRate:w,rb:A,hf:null,If:E||c.If,label:I||null,encrypted:!1}}function hy(a,b){b=b.slice();a=u(a);for(var c=a.next();!c.done;c=a.next())c=c.value.attributes.schemeIdUri,b.includes(c)||b.push(c);return b}
function iy(a){a=u(a);for(var b=a.next();!b.done;b=a.next()){b=b.value;var c=b.attributes.schemeIdUri;if(c&&(b=b.attributes.value))switch(c){case "urn:mpeg:dash:outputChannelPositionList:2012":return b.trim().split(/ +/).length;case "urn:mpeg:dash:23003:3:audio_channel_configuration:2011":case "urn:dts:dash:audio_channel_configuration:2012":b=parseInt(b,10);if(!b)continue;return b;case "tag:dolby.com,2015:dash:audio_channel_configuration:2015":c=[2,1,2,2,2,2,1,2,2,1,1,1,1,2,1,1,2,2];b=parseInt(b,
16);if(!b)continue;for(var d=0,e=0;e<c.length;e++)b&1<<e&&(d+=c[e]);if(d)return d;continue;case "tag:dolby.com,2014:dash:audio_channel_configuration:2011":case "urn:dolby:dash:audio_channel_configuration:2011":c=[1,1,1,1,1,2,2,1,1,2,2,2,1,2,1,1].reverse();b=parseInt(b,16);if(!b)continue;for(e=d=0;e<c.length;e++)b&1<<e&&(d+=c[e]);if(d)return d;continue;case "urn:mpeg:mpegB:cicp:ChannelConfiguration":if(c=[0,1,2,3,4,5,6,8,2,3,4,7,8,24,8,12,10,12,14,12,14],(b=parseInt(b,10))&&b>0&&b<c.length)return c[b]}}return null}
function ey(a){var b=a.Id?1:0;b+=a.Ac?1:0;b+=a.Oc?1:0;if(b==0)return a.contentType==Kc||a.contentType=="application"?!0:!1;b!=1&&(a.Id&&(a.Ac=null),a.Oc=null);return!0}
function jy(a,b,c,d){var e,f,g,h,k,l,m;return O(function(n){if(n.g==1)return e=[wc(c)],f=Ec(b(),e),g=Zg(f,a.g.retryParameters),g.method=d,h=a.j.networkingEngine.request(4,g,{isPreload:a.oa()}),Tg(a.R,h),G(n,h.promise,2);k=n.h;if(d=="HEAD"){if(!k.headers||!k.headers.date)return n.return(0);l=k.headers.date}else l=oc(k.data);m=Date.parse(l);return isNaN(m)?n.return(0):n.return(m-Date.now())})}
function Qx(a,b,c){var d,e,f,g,h,k,l,m;return O(function(n){switch(n.g){case 1:d=c.map(function(q){return{scheme:q.attributes.schemeIdUri,value:q.attributes.value}}),e=a.g.dash.clockSyncUri,!d.length&&e&&d.push({scheme:"urn:mpeg:dash:utc:http-head:2014",value:e}),f=u(d),g=f.next();case 2:if(g.done){n.A(4);break}h=g.value;sa(n,5);k=h.scheme;l=h.value;switch(k){case "urn:mpeg:dash:utc:http-head:2014":case "urn:mpeg:dash:utc:http-head:2012":return n.A(7);case "urn:mpeg:dash:utc:http-xsdate:2014":case "urn:mpeg:dash:utc:http-iso:2014":case "urn:mpeg:dash:utc:http-xsdate:2012":case "urn:mpeg:dash:utc:http-iso:2012":return n.A(8);
case "urn:mpeg:dash:utc:direct:2014":case "urn:mpeg:dash:utc:direct:2012":return m=Date.parse(l),n.return(isNaN(m)?0:m-Date.now());case "urn:mpeg:dash:utc:http-ntp:2014":case "urn:mpeg:dash:utc:ntp:2014":case "urn:mpeg:dash:utc:sntp:2014":$a("NTP UTCTiming scheme is not supported");break;default:$a("Unrecognized scheme in UTCTiming element",k)}n.A(9);break;case 7:return G(n,jy(a,b,l,"HEAD"),10);case 10:return n.return(n.h);case 8:return G(n,jy(a,b,l,"GET"),11);case 11:return n.return(n.h);case 9:ua(n,
3);break;case 5:Aa(n);case 3:g=f.next();n.A(2);break;case 4:return $a("A UTCTiming element should always be given in live manifests! This content may not play on clients with bad clocks!"),n.return(0)}})}
function Zx(a,b,c,d,e){var f=d.attributes.schemeIdUri||"",g=d.attributes.value||"",h=Od(d,"timescale",Xd)||1,k=Od(d,"presentationTimeOffset",Xd)||0;d=u(Hd(d,"Event"));for(var l=d.next();!l.done;l=d.next()){l=l.value;var m=Od(l,"presentationTime",Xd)||0,n=Od(l,"duration",Xd)||0;m=Math.max((m-k)/h+b,b);n=m+n/h;c!=null&&(m=Math.min(m,b+c),n=Math.min(n,b+c));n<e||(l={schemeIdUri:f,value:g,startTime:m,endTime:n,id:l.attributes.id||"",timescale:h,eventElement:ee(l),eventNode:fe(l)},a.j.onTimelineRegionAdded(l))}}
function Wx(a,b,c,d,e){var f,g,h,k;return O(function(l){if(l.g==1)return f=eh,g=e?0:1,h=Hm(b,c,d,a.g.retryParameters),G(l,Ix(a,h,f,{type:g}),2);k=l.h;return l.return(k.data)})}function dy(a,b){b=Se(a,b);return hf(b)?Kc:a.split("/")[0]}function Ix(a,b,c,d){d||(d={});d.isPreload=a.oa();b=a.j.networkingEngine.request(c,b,d);Tg(a.R,b);return b.promise}
function Hx(a){var b=a.l.qe;if(!a.l.vf||!b||!a.H.length)return[];var c=Date.now()/1E3,d=a.H.filter(function(e){e=Xd(e.attributes.ttl);return!e||b+e>c}).map(Jd).filter(uf);return d.length?Ec(a.B,d):[]}function Nx(){return""}function Mx(a,b,c){return function(){return a&&b?Dw(a,"BaseURL"):c.slice()}}T("shaka.dash.DashParser",Dx);Tc("application/dash+xml",function(){return new Dx});Tc("video/vnd.mpeg.dash.mpd",function(){return new Dx});function ky(){}T("shaka.dependencies",ky);ky.has=function(a){return ly.has(a)};ky.add=function(a,b){if(!my[a])throw Error(a+" is not supported");a==ny?yb("mux.js","mux.js is no longer used in Shaka Player."):ly.set(a,function(){return b})};var ny="muxjs",my={Gm:ny,ISOBoxer:"ISOBoxer"};ky.Allowed=my;var ly=new Map([["ISOBoxer",function(){return window.ISOBoxer}]]);function oy(){this.j=new qb(function(){return["Oculus","Quest"].some(function(a){return navigator.userAgent.includes(a.toLowerCase())})?"VR":navigator.userAgent.match(/Smart( ?|_)TV/i)||navigator.userAgent.match(/Android ?TV/i)?"TV":navigator.userAgentData?navigator.userAgentData.mobile?"MOBILE":"DESKTOP":/(?:iPhone|iPad|iPod)/.test(navigator.userAgent)?"MOBILE":navigator.userAgentData&&navigator.userAgentData.platform?navigator.userAgentData.platform.toLowerCase()=="android"?"MOBILE":"DESKTOP":navigator.userAgent.includes("Android")?
"MOBILE":"DESKTOP"});this.l=new qb(function(){return navigator.vendor.includes("Apple")&&(navigator.userAgent.includes("Version/")||navigator.userAgent.includes("OS/"))?"WEBKIT":navigator.userAgent.includes("Edge/")?"EDGE":navigator.userAgent.includes("Chrome/")?"CHROMIUM":navigator.userAgent.includes("Firefox/")?"GECKO":"UNKNOWN"})}function Wc(){var a=window.ManagedMediaSource||window.MediaSource;return a&&a.isTypeSupported?!0:!1}p=oy.prototype;p.hc=function(){return!!navigator.mediaCapabilities};
p.Oa=function(){return this.j.value()};p.Ha=function(){return this.l.value()};p.Fd=function(){return!1};p.ih=function(){return!1};p.jf=function(){return!1};p.Ni=function(){return!1};p.se=function(){return!1};p.fd=function(){return!0};p.Ib=function(){var a=window.ManagedSourceBuffer||window.SourceBuffer;return!!a&&!!a.prototype&&!!a.prototype.changeType};p.we=function(){return!0};p.Si=function(){return 0};p.lc=function(){return Promise.resolve({width:Infinity,height:Infinity})};p.$i=function(){return!1};
p.xh=function(){return!1};p.Wa=function(a){var b=this.Oa();if(b==="TV"||b==="CONSOLE"||b==="CAST")a.ads.customPlayheadTracker=!0,a.ads.skipPlayDetection=!0,a.ads.supportsMultipleMediaElements=!1;return a};p.Ch=function(){return!!window.indexedDB};p.Li=function(){return[]};p.sd=function(a){return window.matchMedia!==void 0&&window.matchMedia("(color-gamut: p3)").matches?a?"HLG":"PQ":"SDR"};p.gj=function(){return!1};p.Bi=function(){return!1};p.Ff=function(){return!1};p.Of=function(){return!0};
p.Ci=function(){return!1};p.fj=function(){return!0};p.ed=function(){return!1};p.Vg=function(a){return a==="com.apple.fps"};p.Nf=function(){return!0};p.toString=function(){return"Device: "+this.Nb()+" v"+this.Ba()+"; Type: "+this.Oa()};function py(){oy.call(this);this.g=new qb(function(){var a=navigator.userAgent.match(/Version\/(\d+)/);return a?parseInt(a[1],10):(a=navigator.userAgent.match(/OS (\d+)(?:_\d+)?/))?parseInt(a[1],10):null});this.h=new qb(function(){return/(?:iPhone|iPad|iPod)/.test(navigator.userAgent)||navigator.maxTouchPoints>1?"xr"in navigator?"APPLE_VR":"MOBILE":"xr"in navigator?"APPLE_VR":"DESKTOP"})}ma(py,oy);p=py.prototype;p.Ba=function(){return this.g.value()};p.Nb=function(){return"Apple Browser"};p.Oa=function(){return this.h.value()};
p.Ha=function(){return"WEBKIT"};p.hc=function(){return!1};p.Fd=function(a,b){return b==="audio"};p.jf=function(){return!0};p.Ni=function(a){return a==="audio"};p.Wa=function(a){oy.prototype.Wa.call(this,a);a.abr.minTimeToSwitch=.5;return a};p.gj=function(){return!0};p.Nf=function(){return!1};
(navigator.vendor||"").includes("Apple")&&(/(?:iPhone|iPad|iPod)/.test(navigator.userAgent)||navigator.maxTouchPoints>1||navigator.userAgentData&&navigator.userAgentData.platform&&navigator.userAgentData.platform.toLowerCase()=="macos"||navigator.platform&&navigator.platform.toLowerCase().includes("mac"))&&(vb=function(){return new py});function qy(){if(!ry())throw Error("Not a Chromecast device!");oy.call(this);this.h=new qb(function(){var a=navigator.userAgent.match(/Chrome\/(\d+)/);return a?parseInt(a[1],10):null});this.g=new qb(function(){var a=navigator.userAgentData&&navigator.userAgentData.platform||navigator.userAgent;a=a.toLowerCase();return a.includes("android")?sy:a.includes("fuchsia")?ty:uy})}ma(qy,oy);p=qy.prototype;p.Ba=function(){return this.h.value()};p.Nb=function(){return"Chromecast with "+this.g.value()};
p.Oa=function(){return"CAST"};p.Ha=function(){return"CHROMIUM"};p.hc=function(){return oy.prototype.hc.call(this)&&this.g.value()!==uy};p.Ib=function(){return oy.prototype.Ib.call(this)&&this.g.value()!==uy};p.Si=function(){switch(this.g.value()){case sy:return 0;case ty:return 3;default:return 1}};
p.lc=function(){var a,b,c,d,e;return O(function(f){switch(f.g){case 1:a=window.cast&&cast.__platform__&&cast.__platform__.canDisplayType;b={width:1280,height:720};sa(f,2);if(!(c=a)){f.A(4);break}return G(f,cast.__platform__.canDisplayType('video/mp4; codecs="avc1.640028"; width=3840; height=2160'),5);case 5:c=f.h;case 4:if(c){b.width=3840;b.height=2160;f.A(6);break}if(!(d=a)){f.A(7);break}return G(f,cast.__platform__.canDisplayType('video/mp4; codecs="avc1.640028"; width=1920; height=1080'),8);case 8:d=
f.h;case 7:d&&(b.width=1920,b.height=1080);case 6:ua(f,3);break;case 2:e=Aa(f),Za("Failed to check canDisplayType:",e);case 3:return f.return(b)}})};p.Wa=function(a){oy.prototype.Wa.call(this,a);a.streaming.stallSkip=0;return a};p.Ch=function(){return!1};p.ed=function(){return!0};function ry(){return navigator.userAgent.includes("CrKey")&&!navigator.userAgent.includes("VIZIO SmartCast")}var sy="Android",ty="Fuchsia",uy="Linux";ry()&&(vb=function(){return new qy});function vy(){oy.call(this);var a=this;this.i=new qb(function(){var b=navigator.userAgent.match(/(Chrome|Firefox)\/(\d+)/);return b?parseInt(b[2],10):null});this.g=new qb(function(){return navigator.userAgent.match(/Edge?\//)?"Edge":navigator.userAgent.includes("Chrome")?"Chrome":navigator.userAgent.includes("Firefox")?"Firefox":"Unknown"});this.h=new qb(function(){return navigator.userAgentData&&navigator.userAgentData.platform?navigator.userAgentData.platform.toLowerCase()=="windows":navigator.platform?
navigator.platform.toLowerCase().includes("win32"):!1});this.u=new qb(function(){return oy.prototype.Ib.call(a)?navigator.userAgent.match(/Edge?\//)?!a.h.value():!0:!1});this.o=new qb(function(){return navigator.userAgent.includes("sony.hbbtv.tv")});this.m=new qb(function(){return navigator.userAgentData&&navigator.userAgentData.platform?navigator.userAgentData.platform.toLowerCase()=="android":navigator.userAgent.includes("Android")?!0:!1})}ma(vy,oy);p=vy.prototype;p.Ba=function(){return this.i.value()};
p.Nb=function(){return this.g.value()};p.Fd=function(a){return hc(a)?this.g.value()==="Edge"&&this.h.value():!1};p.ih=function(){return this.g.value()==="Edge"&&this.h.value()};p.jf=function(){return this.g.value()==="Edge"&&this.h.value()};p.Ib=function(){return this.u.value()};
p.Wa=function(a){oy.prototype.Wa.call(this,a);if(this.h.value())switch(this.g.value()){case "Firefox":a.drm.keySystemsMapping={"com.microsoft.playready":"com.microsoft.playready.recommendation"};break;case "Chrome":a.drm.keySystemsMapping={"com.microsoft.playready":"com.microsoft.playready.recommendation.3000","com.microsoft.playready.recommendation":"com.microsoft.playready.recommendation.3000"}}this.m.value()&&(a.drm.defaultAudioRobustnessForWidevine="",a.drm.defaultVideoRobustnessForWidevine="");
return a};p.Ff=function(){return this.g.value()==="Edge"||this.o.value()};p.ed=function(){if(this.Ha()==="GECKO"){var a=this.Ba();return a!==null?a>=100:oy.prototype.ed.call(this)}return oy.prototype.ed.call(this)};p.Vg=function(a){return this.Ha()==="GECKO"?a.startsWith("com.microsoft.playready.recommendation"):oy.prototype.Vg.call(this,a)};wb=function(){return new vy};function wy(){oy.apply(this,arguments)}ma(wy,oy);p=wy.prototype;p.Ba=function(){return null};p.Nb=function(){return"Hisense"};p.Oa=function(){return"TV"};p.hc=function(){return!1};p.lc=function(){var a={width:1920,height:1080},b=null;if(window.Hisense_Get4KSupportState)try{b=window.Hisense_Get4KSupportState()}catch(c){}b==null&&(b=navigator.userAgent.includes("UHD"));b&&(a.width=3840,a.height=2160);return Promise.resolve(a)};p.Wa=function(a){oy.prototype.Wa.call(this,a);a.streaming.stallSkip=0;return a};
if(navigator.userAgent.includes("Hisense")||navigator.userAgent.includes("VIDAA"))vb=function(){return new wy};function xy(){oy.call(this);this.g=new qb(function(){var a=navigator.userAgent.match(/PlayStation (\d+)/);return a?parseInt(a[1],10):null})}ma(xy,oy);p=xy.prototype;p.Nb=function(){return"PlayStation"};p.Oa=function(){return"CONSOLE"};p.Ha=function(){return"WEBKIT"};p.Ba=function(){return this.g.value()};p.hc=function(){return!1};p.fd=function(){return!1};p.Ib=function(){return!1};p.xh=function(){return this.Ba()===4};
p.lc=function(){var a,b,c,d,e;return O(function(f){switch(f.g){case 1:return a={width:1920,height:1080},b=!1,sa(f,2),G(f,window.msdk.device.getDisplayInfo(),4);case 4:c=f.h;b=c.resolution==="4K";ua(f,3);break;case 2:return Aa(f),sa(f,5),G(f,window.msdk.device.getDisplayInfoImmediate(),7);case 7:d=f.h;b=d.resolution==="4K";ua(f,3);break;case 5:e=Aa(f),$a("PlayStation: Failed to get the display info:",e);case 3:return b&&(a.width=3840,a.height=2160),f.return(a)}})};
p.Wa=function(a){oy.prototype.Wa.call(this,a);this.Ba()===4&&a.drm.preferredKeySystems.push("com.microsoft.playready");a.streaming.clearDecodingCache=!0;return a};p.Ff=function(){return this.Ba()===4};p.Of=function(){return this.Ba()!==4};navigator.userAgent.includes("PlayStation")&&(vb=function(){return new xy});function yy(){oy.call(this);var a=navigator.userAgent.match(/Tizen (\d+).(\d+)/);this.g=a?parseInt(a[1],10):null;this.h=a?parseInt(a[2],10):null}ma(yy,oy);p=yy.prototype;p.Ba=function(){return this.g};p.Nb=function(){return"Tizen"};p.Ha=function(){return"CHROMIUM"};p.Oa=function(){return"TV"};p.Fd=function(){return!0};p.se=function(){return this.Ba()===3};p.hc=function(){return!1};p.fd=function(){var a=this.Ba();return a!==null?a>=4:oy.prototype.fd.call(this)};p.Ib=function(){return!1};
p.we=function(){return this.g&&this.h?this.g===5?this.h>=5:this.g>5:oy.prototype.we.call(this)};
p.lc=function(){var a=window.devicePixelRatio;a={width:window.screen.width*a>1920?3840:1920,height:window.screen.height*a>1080?2160:1080};try{if(webapis.systeminfo&&webapis.systeminfo.getMaxVideoResolution){var b=webapis.systeminfo.getMaxVideoResolution();a.width=b.width;a.height=b.height}else webapis.productinfo.is8KPanelSupported&&webapis.productinfo.is8KPanelSupported()?(a.width=7680,a.height=4320):webapis.productinfo.isUdPanelSupported&&webapis.productinfo.isUdPanelSupported()&&(a.width=3840,
a.height=2160)}catch(c){$a("Tizen: Error detecting screen size, default screen size 1920x1080.")}return Promise.resolve(a)};p.Wa=function(a){oy.prototype.Wa.call(this,a);a.drm.ignoreDuplicateInitData=this.Ba()!==2;this.Ba()===3&&(a.streaming.crossBoundaryStrategy="reset_to_encrypted");a.streaming.shouldFixTimestampOffset=!0;a.streaming.stallSkip=0;a.streaming.gapPadding=2;return a};p.Li=function(){var a=[];this.g!==null&&this.g<5&&a.push("opus");return a};
p.sd=function(a){try{if(webapis.avinfo.isHdrTvSupport())return a?"HLG":"PQ"}catch(b){return oy.prototype.sd.call(this,a)}return"SDR"};p.Bi=function(){return!0};p.Ci=function(){return this.Ba()===3};navigator.userAgent.includes("Tizen")&&(vb=function(){return new yy});function zy(){oy.apply(this,arguments)}ma(zy,oy);zy.prototype.Ba=function(){return null};zy.prototype.Nb=function(){return"Vizio"};zy.prototype.Oa=function(){return"TV"};zy.prototype.hc=function(){return!1};navigator.userAgent.includes("VIZIO SmartCast")&&(vb=function(){return new zy});function Ay(){oy.call(this);this.i=new qb(function(){return navigator.userAgent.includes("DT_STB_BCM")||navigator.userAgent.includes("Sky_STB")});this.h=new qb(function(){return navigator.userAgent.includes("SOPOpenBrowser")});this.g=new qb(function(){if(navigator.userAgent.includes("DT_STB_BCM"))return 11;var a=navigator.userAgent.match(/Version\/(\d+)/);return a?parseInt(a[1],10):(a=navigator.userAgent.match(/OS (\d+)(?:_\d+)?/))?parseInt(a[1],10):null})}ma(Ay,oy);p=Ay.prototype;p.Ba=function(){return this.g.value()};
p.Nb=function(){return"WebKit STB"};p.Oa=function(){return"TV"};p.Ha=function(){return"WEBKIT"};p.hc=function(){return!1};p.fd=function(){var a=this.g.value();return a!==null?a>=15:!0};p.Fd=function(){return this.h.value()};p.lc=function(){return Promise.resolve({width:window.screen.width*window.devicePixelRatio,height:window.screen.height*window.devicePixelRatio})};p.Of=function(){return!this.i.value()};p.Nf=function(){return!1};
if(navigator.userAgent.includes("SOPOpenBrowser")||navigator.userAgent.includes("DT_STB_BCM")||navigator.userAgent.includes("Sky_STB")||!(!(navigator.vendor||"").includes("Apple")||/(?:iPhone|iPad|iPod)/.test(navigator.userAgent)||navigator.maxTouchPoints>1||navigator.userAgentData&&navigator.userAgentData.platform&&navigator.userAgentData.platform.toLowerCase()=="macos"||navigator.platform&&navigator.platform.toLowerCase().includes("mac")))vb=function(){return new Ay};function By(){oy.call(this);var a=this;this.h=Cy();this.g=null;try{var b=new PalmServiceBridge;b.onservicecallback=function(c){c=JSON.parse(c);a.g=c.configs["tv.model.supportHDR"]||c.configs["tv.config.supportDolbyHDRContents"]||!1};b.call("luna://com.webos.service.config/getConfigs",JSON.stringify({configNames:["tv.model.supportHDR","tv.config.supportDolbyHDRContents"]}))}catch(c){$a("WebOS: getConfigs call failed",c)}}ma(By,oy);p=By.prototype;p.Ba=function(){return this.h};p.Nb=function(){return"WebOS"};
p.Oa=function(){return"TV"};p.Ha=function(){return"CHROMIUM"};p.hc=function(){return!1};p.fd=function(){var