# Embed 版（外部システム組み込み用）

このフォルダは、`videojs-drm-player` を **外部システムへ組み込みやすい形（HTML + js/ + css/）** にしたサンプルです。

## 生成方法

`videojs-package/` で以下を実行します。

```bash
npm run build:embed
```

デバッグ/中身確認用に **非min版** も生成できます。

```bash
npm run build:embed:dev
```

さらに、外部システム側で `video.js` / `shaka-player` / `videojs-contrib-eme` を既に読み込める場合は、
依存を同梱しない **軽量版（LITE）** を生成できます（ラッパーのみ出力）。

```bash
npm run build:embed:lite
```

すると `embed/` 配下に下記が生成されます（`index.html` は手書きサンプルとして保持されます）。

- `embed/index.html`（サンプル）
- `embed/index-lite.html`（外部読み込み前提のサンプル）
- `embed/js/videojs-drm-player.min.js`
- `embed/js/videojs-drm-player.js`（非min・読みやすい版）
- `embed/js/videojs-drm-player.lite.js`（依存を同梱しない軽量版）
- `embed/css/*.css`

## 使い方（最短）

1) `embed/` フォルダ一式を、外部システムの静的配信領域へコピー  
2) `index.html` を参考に、以下を行う

- CSS を `<link>` で読み込む（`css/` 配下）
- JS を `<script>` で読み込む（`js/` 配下）
- コンテナ要素（例: `<div id="player-container"></div>`）を置く
- `new VideoJSDRMPlayer({ ... })` で初期化する

## 同梱版（embed）と軽量版（LITE）の使い分け

- **同梱版（`videojs-drm-player.min.js` / `videojs-drm-player.js`）**
  - 依存（Video.js / Shaka等）をバンドルに含めるため、外部システムへ“フォルダ一式を置くだけ”で動きやすい
  - その代わり JS が大きくなる

- **軽量版（`videojs-drm-player.lite.js`）**
  - 依存を含めないため、JS が小さく読みやすい
  - 代わりにホスト側で **読み込み順を保証**する必要がある
    - 1) `video.js`
    - 2) `videojs-contrib-eme`
    - 3) `shaka-player`（`window.shaka` が存在すること）
    - 4) `videojs-drm-player.lite.js`

## 初期化オプション（重要）

最低限必須:

- `containerId`: プレイヤーを挿入するDOM要素の `id`
- `source`: 動画URL

DRM時:

- `isDRM: true`
- `drmConfig`: Widevine / PlayReady / FairPlay のライセンスURLやヘッダ等

## 注意

- この embed 版は **CSSをJSに注入せず、ファイルとして出力**します。HTML 側でCSSの読み込みが必須です。
- JSバンドルは依存（Video.js / Shaka 等）を含むため大きめです（外部組み込みを優先）。

