# VideoJS DRM Player

A Video.js package library with integrated DRM and custom UI controls, supporting DRMtoday and advanced media player features.

## Features

- ✅ Fully integrated with Video.js
- ✅ DRM support with DRMtoday (Widevine, PlayReady, FairPlay)
- ✅ Custom UI controls (play/pause/stop/rewind/forward/volume)
- ✅ Responsive design with automatic video sizing
- ✅ Video content always matches the size of the media player
- ✅ Flexible configuration
- ✅ Error handling and logging

## どうやって使う？（外部システムに組み込みたい場合）

このライブラリは `new VideoJSDRMPlayer({...})` で **指定したコンテナ要素の中に `<video>` を自動生成して** 初期化します。

### もっとも簡単な組み込み（embed 版）

外部システムへ「HTML + js/ + css/」で持ち出す場合は、embed ビルドを使うのが最短です。

1) `videojs-package/` で生成:

```bash
npm run build:embed
```

2) `videojs-package/embed/` を外部システムの静的ファイル置き場へコピー  
3) `embed/index.html` を参考に、`css/` を `<link>`、`js/` を `<script>` で読み込む  
4) `new VideoJSDRMPlayer({ containerId, source, ... })` を呼ぶ

### 初期化例（非DRM）

```js
new VideoJSDRMPlayer({
  containerId: "player-container",
  source: "https://example.com/your.m3u8",
  isDRM: false,
  controls: true,
  classicControls: false,
  fluid: true,
});
```

### 初期化例（DRM: videojs-contrib-eme 経由）

`isDRM: true` のときは `drmConfig` が必須です。

```js
new VideoJSDRMPlayer({
  containerId: "player-container",
  source: "https://example.com/your.mpd",
  isDRM: true,
  drmConfig: {
    widevine: {
      url: "https://YOUR_LICENSE_SERVER",
      licenseHeaders: {
        "x-dt-auth-token": "YOUR_TOKEN",
        "x-dt-custom-data": "YOUR_CUSTOM_DATA",
      },
    },
    // playready / fairplay も必要に応じて指定
  },
});
```

### 初期化時の必須パラメータ

- `containerId`: 描画先コンテナのID（例: `player-container`）
- `source`: 動画URL

## License

MIT License - see [LICENSE](LICENSE) for details.
